/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.veccy;

import de.malban.Global;
import de.malban.util.UtilityString;
import de.malban.vide.veccy.LevelDataXMLHandler;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.HashMap;
import javax.swing.JOptionPane;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.helpers.DefaultHandler;

public class LevelData {
    protected String mClass = "";
    public String mName = "";
    protected int mLevelOrder = 0;
    protected boolean mUseSmartList = false;
    private static LevelDataXMLHandler XMLHANDLER = new LevelDataXMLHandler();

    public String getName() {
        return this.mName;
    }

    public void setName(String n) {
        this.mName = n;
    }

    public String getCClass() {
        return this.mClass;
    }

    public void setCClass(String c) {
        this.mClass = c;
    }

    public int getLevelOrder() {
        return this.mLevelOrder;
    }

    public void setLevelOrder(int LevelOrder) {
        this.mLevelOrder = LevelOrder;
    }

    public boolean getUseSmartList() {
        return this.mUseSmartList;
    }

    public void setUseSmartList(boolean UseSmartList) {
        this.mUseSmartList = UseSmartList;
    }

    private String exportXML() {
        StringBuffer s = new StringBuffer();
        s.append("\t<LevelData>\n");
        s.append("\t\t<Class>" + UtilityString.toXML(this.mClass) + "</Class>\n");
        s.append("\t\t<Name>" + UtilityString.toXML(this.mName) + "</Name>\n");
        s.append("\t\t<LevelOrder>" + this.mLevelOrder + "</LevelOrder>\n");
        s.append("\t\t<UseSmartList>" + this.mUseSmartList + "</UseSmartList>\n");
        s.append("\t</LevelData>\n");
        return s.toString();
    }

    public String toString() {
        return this.mName;
    }

    public static LevelDataXMLHandler getXMLParseHandler() {
        return XMLHANDLER;
    }

    public static boolean saveCollectionAsXML(String filename, Collection<LevelData> col) {
        return LevelData.saveCollectionAsXML(Global.mBaseDir, filename, col);
    }

    public static boolean saveCollectionAsXML(String pathName, String filename, Collection<LevelData> col) {
        try {
            PrintWriter pw = new PrintWriter(pathName + filename, "UTF-8");
            pw.print("<?xml version=\"1.0\"?>\n");
            pw.print("<AllLevelData>\n");
            for (LevelData item : col) {
                pw.print(item.exportXML());
            }
            pw.print("</AllLevelData>\n");
            pw.close();
        }
        catch (IOException e) {
            System.err.println(e.toString());
            return false;
        }
        return true;
    }

    public static HashMap<String, LevelData> getHashMapFromXML(String filename) {
        HashMap<String, LevelData> filters = new HashMap<String, LevelData>();
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            LevelDataXMLHandler h = LevelData.getXMLParseHandler();
            saxParser.parse(Global.mBaseDir + filename, (DefaultHandler)h);
            filters = h.getLastHashMap();
        }
        catch (Throwable e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, e.toString(), "LevelData Load Error...", 1);
        }
        return filters;
    }
}

