/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.veccy;

import de.malban.Global;
import de.malban.vide.veccy.LevelObjectData;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.JOptionPane;

public class LevelObjectDataPool {
    public static final String DEFAULT_XML_NAME = new String("LevelObjectData.xml");
    private String mFileName = DEFAULT_XML_NAME;
    private HashMap<String, LevelObjectData> mLevelObjectData = new HashMap();
    private HashMap<String, String> mKlassenMap = new HashMap();

    public LevelObjectDataPool(String name) {
        this.mFileName = name;
        this.init();
    }

    public LevelObjectDataPool() {
        this.init();
    }

    public void setFilename(String n) {
        this.mFileName = n;
    }

    private boolean init() {
        try {
            return this.load();
        }
        catch (Throwable e) {
            JOptionPane.showMessageDialog(null, e.toString(), "Load Error LevelObjectData...", 1);
            return false;
        }
    }

    public boolean load() {
        File f = new File(Global.mBaseDir + this.mFileName);
        if (!f.exists()) {
            return false;
        }
        this.mLevelObjectData = LevelObjectData.getHashMapFromXML(this.mFileName);
        return true;
    }

    public void save() {
        LevelObjectData.saveCollectionAsXML(this.mFileName, this.mLevelObjectData.values());
        this.buildKlassenMap();
    }

    public void remove(LevelObjectData st) {
        this.mLevelObjectData.remove(st.mName);
    }

    public void put(LevelObjectData st) {
        this.mLevelObjectData.remove(st.mName);
        this.mLevelObjectData.put(st.mName, st);
    }

    public void putAsNew(LevelObjectData st) {
        this.mLevelObjectData.put(st.mName, st);
    }

    public LevelObjectData get(String key) {
        return this.mLevelObjectData.get(key);
    }

    public HashMap<String, LevelObjectData> getHashMap() {
        return this.mLevelObjectData;
    }

    private void buildKlassenMap() {
        this.mKlassenMap = new HashMap();
        Set<Map.Entry<String, LevelObjectData>> entries = this.mLevelObjectData.entrySet();
        for (Map.Entry<String, LevelObjectData> entry : entries) {
            LevelObjectData value = entry.getValue();
            this.mKlassenMap.put(value.mClass, value.mClass);
        }
    }

    public HashMap<String, String> getKlassenHashMap() {
        this.buildKlassenMap();
        return this.mKlassenMap;
    }

    public HashMap<String, LevelObjectData> getMapForKlasse(String klasse) {
        HashMap<String, LevelObjectData> ret = new HashMap<String, LevelObjectData>();
        Set<Map.Entry<String, LevelObjectData>> entries = this.mLevelObjectData.entrySet();
        for (Map.Entry<String, LevelObjectData> entry : entries) {
            LevelObjectData value = entry.getValue();
            if (!value.mClass.equalsIgnoreCase(klasse)) continue;
            ret.put(value.mName, value);
        }
        return ret;
    }
}

