/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.veccy;

import de.malban.config.Configuration;
import de.malban.event.EditMouseEvent;
import de.malban.graphics.MouseMovedListener;
import de.malban.graphics.SingleVectorPanel;
import de.malban.gui.CSAMainFrame;
import de.malban.gui.HotKey;
import de.malban.gui.Windowable;
import de.malban.gui.components.CSAInternalFrame;
import de.malban.gui.components.CSAView;
import de.malban.gui.panels.LogPanel;
import de.malban.vide.veccy.VecciSettings;
import de.malban.vide.veccy.VeccyPanel;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SingleVecciPanel
extends JPanel
implements Windowable,
MouseMovedListener {
    LogPanel log = (LogPanel)Configuration.getConfiguration().getDebugEntity();
    private int mClassSetting = 0;
    private CSAView mParent = null;
    private JMenuItem mParentMenuItem = null;
    VeccyPanel vecci;
    public int xpos = 0;
    public int ypos = 0;
    public int w = 0;
    public int h = 0;
    private JButton jButtonDown;
    private JButton jButtonLeft;
    private JButton jButtonRight;
    private JButton jButtonUp;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabelMode;
    private JLabel jLabelScale;
    private JLabel jLabelXO;
    private JLabel jLabelYO;
    private JPanel jPanelScroller;
    private JSlider jSliderSourceScale;
    private SingleVectorPanel singleVectorPanel1;

    @Override
    public void closing() {
        if (this.vecci != null) {
            this.vecci.closeSingleVecciPanel();
        }
    }

    @Override
    public boolean isIcon() {
        CSAMainFrame frame = Configuration.getConfiguration().getMainFrame();
        if (frame.getInternalFrame(this) == null) {
            return false;
        }
        return frame.getInternalFrame(this).isIcon();
    }

    @Override
    public void setIcon(boolean b) {
        CSAMainFrame frame = Configuration.getConfiguration().getMainFrame();
        if (frame.getInternalFrame(this) == null) {
            return;
        }
        try {
            frame.getInternalFrame(this).setIcon(b);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void setParentWindow(CSAView jpv) {
        this.mParent = jpv;
    }

    @Override
    public void setMenuItem(JMenuItem item) {
        this.mParentMenuItem = item;
        this.mParentMenuItem.setText("Vector: Editor single");
    }

    @Override
    public JMenuItem getMenuItem() {
        return this.mParentMenuItem;
    }

    @Override
    public JPanel getPanel() {
        return this;
    }

    public SingleVecciPanel(VeccyPanel v) {
        ++this.mClassSetting;
        this.initComponents();
        this.vecci = v;
        this.singleVectorPanel1.setUsePrivateScale(true);
        this.singleVectorPanel1.setUsePrivateOffset(true);
        --this.mClassSetting;
        this.updateOutput();
        new HotKey("Delete selected(Window)", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SingleVecciPanel.this.vecci.lineDeleteProxy();
            }
        }, this);
        new HotKey("Mode change(Window)", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SingleVecciPanel.this.vecci.cycleMode();
            }
        }, this);
        new HotKey("UndoMac(Window)", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SingleVecciPanel.this.vecci.undoProxy();
            }
        }, this);
        new HotKey("RedoMac(Window)", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SingleVecciPanel.this.vecci.redoProxy();
            }
        }, this);
        new HotKey("UndoWin(Window)", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SingleVecciPanel.this.vecci.undoProxy();
            }
        }, this);
        new HotKey("RedoWin(Window)", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SingleVecciPanel.this.vecci.redoProxy();
            }
        }, this);
        new HotKey("SelectAllMac(Window)", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SingleVecciPanel.this.vecci.selectAllProxy();
            }
        }, this);
        new HotKey("SelectAllWin(Window)", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SingleVecciPanel.this.vecci.selectAllProxy();
            }
        }, this);
        new HotKey("CopyMac(Window)", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SingleVecciPanel.this.vecci.copyProxy();
            }
        }, this);
        new HotKey("CopyWin(Window)", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SingleVecciPanel.this.vecci.copyProxy();
            }
        }, this);
        new HotKey("PasteMac(Window)", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SingleVecciPanel.this.vecci.pasteProxy();
            }
        }, this);
        new HotKey("PasteWin(Window)", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SingleVecciPanel.this.vecci.pasteProxy();
            }
        }, this);
        new HotKey("CutMac(Window)", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SingleVecciPanel.this.vecci.cutProxy();
            }
        }, this);
        new HotKey("CutWin(Window)", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SingleVecciPanel.this.vecci.cutProxy();
            }
        }, this);
        new HotKey("AnimLeftKP(Window)", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SingleVecciPanel.this.vecci.animLeft();
            }
        }, this);
        new HotKey("AnimRightKP(Window)", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SingleVecciPanel.this.vecci.animRight();
            }
        }, this);
        new HotKey("AnimLeft(Window)", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SingleVecciPanel.this.vecci.animLeft();
            }
        }, this);
        new HotKey("AnimRight(Window)", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SingleVecciPanel.this.vecci.animRight();
            }
        }, this);
        this.updateMode();
    }

    public void initPart2() {
        this.singleVectorPanel1.addMouseMovedListener(this);
    }

    private void initComponents() {
        this.singleVectorPanel1 = new SingleVectorPanel();
        this.jPanelScroller = new JPanel();
        this.jButtonUp = new JButton();
        this.jButtonDown = new JButton();
        this.jButtonLeft = new JButton();
        this.jButtonRight = new JButton();
        this.jSliderSourceScale = new JSlider();
        this.jLabelMode = new JLabel();
        this.jLabelScale = new JLabel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabelXO = new JLabel();
        this.jLabelYO = new JLabel();
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                SingleVecciPanel.this.formComponentResized(evt);
            }
        });
        this.singleVectorPanel1.setMaximumSize(new Dimension(300, 300));
        this.singleVectorPanel1.setMinimumSize(new Dimension(300, 300));
        this.singleVectorPanel1.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                SingleVecciPanel.this.singleVectorPanel1ComponentResized(evt);
            }
        });
        GroupLayout singleVectorPanel1Layout = new GroupLayout(this.singleVectorPanel1);
        this.singleVectorPanel1.setLayout(singleVectorPanel1Layout);
        singleVectorPanel1Layout.setHorizontalGroup(singleVectorPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 371, Short.MAX_VALUE));
        singleVectorPanel1Layout.setVerticalGroup(singleVectorPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        this.jPanelScroller.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                SingleVecciPanel.this.jPanelScrollerMouseClicked(evt);
            }
        });
        this.jPanelScroller.setLayout(null);
        this.jButtonUp.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/arrow_up.png")));
        this.jButtonUp.setToolTipText("select all");
        this.jButtonUp.setHorizontalAlignment(2);
        this.jButtonUp.setMargin(new Insets(-1, -3, -1, -4));
        this.jButtonUp.setPreferredSize(new Dimension(14, 18));
        this.jButtonUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SingleVecciPanel.this.jButtonUpActionPerformed(evt);
            }
        });
        this.jPanelScroller.add(this.jButtonUp);
        this.jButtonUp.setBounds(19, 1, 14, 18);
        this.jButtonDown.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/arrow_down.png")));
        this.jButtonDown.setToolTipText("select all");
        this.jButtonDown.setHorizontalAlignment(2);
        this.jButtonDown.setMargin(new Insets(-1, -3, -1, -4));
        this.jButtonDown.setPreferredSize(new Dimension(14, 18));
        this.jButtonDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SingleVecciPanel.this.jButtonDownActionPerformed(evt);
            }
        });
        this.jPanelScroller.add(this.jButtonDown);
        this.jButtonDown.setBounds(19, 31, 14, 18);
        this.jButtonLeft.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/arrow_left.png")));
        this.jButtonLeft.setToolTipText("select all");
        this.jButtonLeft.setHorizontalAlignment(2);
        this.jButtonLeft.setMargin(new Insets(-4, 0, -4, -1));
        this.jButtonLeft.setPreferredSize(new Dimension(65, 19));
        this.jButtonLeft.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SingleVecciPanel.this.jButtonLeftActionPerformed(evt);
            }
        });
        this.jPanelScroller.add(this.jButtonLeft);
        this.jButtonLeft.setBounds(0, 18, 19, 14);
        this.jButtonRight.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/arrow_right.png")));
        this.jButtonRight.setToolTipText("select all");
        this.jButtonRight.setHorizontalAlignment(2);
        this.jButtonRight.setMargin(new Insets(-1, 0, -1, -1));
        this.jButtonRight.setPreferredSize(new Dimension(65, 19));
        this.jButtonRight.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SingleVecciPanel.this.jButtonRightActionPerformed(evt);
            }
        });
        this.jPanelScroller.add(this.jButtonRight);
        this.jButtonRight.setBounds(33, 18, 19, 14);
        this.jSliderSourceScale.setMajorTickSpacing(1);
        this.jSliderSourceScale.setMinimum(1);
        this.jSliderSourceScale.setMinorTickSpacing(1);
        this.jSliderSourceScale.setOrientation(1);
        this.jSliderSourceScale.setPaintTicks(true);
        this.jSliderSourceScale.setSnapToTicks(true);
        this.jSliderSourceScale.setValue(21);
        this.jSliderSourceScale.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                SingleVecciPanel.this.jSliderSourceScaleStateChanged(evt);
            }
        });
        this.jLabelMode.setForeground(new Color(51, 51, 255));
        this.jLabelMode.setText("Mode");
        this.jLabelScale.setText(" ");
        this.jLabel1.setText("Y:");
        this.jLabel2.setText("X:");
        this.jLabelXO.setText(" ");
        this.jLabelYO.setText(" ");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jSliderSourceScale, -2, 52, -2).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelXO, -1, -1, Short.MAX_VALUE)).addComponent(this.jLabelMode, -1, -1, Short.MAX_VALUE).addComponent(this.jLabelScale, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelYO, -1, -1, Short.MAX_VALUE)).addComponent(this.jPanelScroller, -2, 52, -2)).addGap(0, 0, 0).addComponent(this.singleVectorPanel1, -1, -1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jSliderSourceScale, -1, 370, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelScale).addGap(0, 0, 0).addComponent(this.jLabelMode, -2, 16, -2).addGap(2, 2, 2).addComponent(this.jPanelScroller, -2, 52, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jLabelXO)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jLabelYO))).addComponent(this.singleVectorPanel1, -1, -1, Short.MAX_VALUE));
    }

    private void jButtonUpActionPerformed(ActionEvent evt) {
        this.singleVectorPanel1.addYOffset(-this.singleVectorPanel1.getGridWidth());
        this.updateOutput();
    }

    private void jButtonDownActionPerformed(ActionEvent evt) {
        this.singleVectorPanel1.addYOffset(this.singleVectorPanel1.getGridWidth());
        this.updateOutput();
    }

    private void jButtonLeftActionPerformed(ActionEvent evt) {
        this.singleVectorPanel1.addXOffset(-this.singleVectorPanel1.getGridWidth());
        this.updateOutput();
    }

    private void jButtonRightActionPerformed(ActionEvent evt) {
        this.singleVectorPanel1.addXOffset(this.singleVectorPanel1.getGridWidth());
        this.updateOutput();
    }

    private void jSliderSourceScaleStateChanged(ChangeEvent evt) {
        if (this.mClassSetting > 0) {
            return;
        }
        int value = this.jSliderSourceScale.getValue();
        int max = this.jSliderSourceScale.getMaximum();
        double scale = value - (max - 1) / 2;
        if (value < max / 2 + 1) {
            int invScale;
            scale = (invScale = max / 2 - --value) == 0 ? 1.0 : 1.0 / (double)invScale;
        }
        if (scale < 1.0) {
            scale += 0.25;
        }
        if (scale > 1.0) {
            scale -= 0.75;
        }
        if (scale > 2.0) {
            scale -= 0.5;
        }
        if (scale > 2.5) {
            scale -= 0.25;
        }
        if (scale > 2.75) {
            scale -= 0.5;
        }
        this.singleVectorPanel1.setScale(scale);
        this.updateOutput();
    }

    private void jPanelScrollerMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            this.singleVectorPanel1.setOffsets(0, 0, 0);
        }
        this.updateOutput();
    }

    private void formComponentResized(ComponentEvent evt) {
        Container cc = this.getParent().getParent().getParent().getParent();
        if (cc instanceof CSAInternalFrame) {
            this.xpos = ((CSAInternalFrame)cc).getBounds().x;
            this.ypos = ((CSAInternalFrame)cc).getBounds().y;
            this.w = ((CSAInternalFrame)cc).getBounds().width;
            this.h = ((CSAInternalFrame)cc).getBounds().height;
        }
    }

    private void singleVectorPanel1ComponentResized(ComponentEvent evt) {
    }

    public static SingleVecciPanel showSingleVecciPanelNoModal(VeccyPanel v) {
        CSAMainFrame frame = Configuration.getConfiguration().getMainFrame();
        SingleVecciPanel panel = new SingleVecciPanel(v);
        Configuration.getConfiguration().getMainFrame().addAsWindow(panel, 919, 387, "Vector: Editor single");
        return panel;
    }

    public SingleVectorPanel getSVP() {
        return this.singleVectorPanel1;
    }

    void updateOutput() {
        if (this.mClassSetting > 0) {
            return;
        }
        ++this.mClassSetting;
        this.jLabelScale.setText(" " + new DecimalFormat("#.##").format(this.singleVectorPanel1.getScale()));
        this.jLabelXO.setText(" " + this.singleVectorPanel1.getXOffset());
        this.jLabelYO.setText(" " + this.singleVectorPanel1.getYOffset());
        --this.mClassSetting;
    }

    void setSettings(final VecciSettings settings) {
        ++this.mClassSetting;
        Container cc = this.getParent().getParent().getParent().getParent();
        if (cc instanceof CSAInternalFrame) {
            ((CSAInternalFrame)cc).setBounds(settings.singleVecciX, settings.singleVecciY, settings.singleVecciW, settings.singleVecciH);
            this.xpos = ((CSAInternalFrame)cc).getBounds().x;
            this.ypos = ((CSAInternalFrame)cc).getBounds().y;
            this.w = ((CSAInternalFrame)cc).getBounds().width;
            this.h = ((CSAInternalFrame)cc).getBounds().height;
        }
        this.jSliderSourceScale.setValue(settings.singleVecciScaleSlider);
        int value = this.jSliderSourceScale.getValue();
        int max = this.jSliderSourceScale.getMaximum();
        double scale = value - (max - 1) / 2;
        if (value < max / 2 + 1) {
            int invScale = max / 2 + 2 - value;
            scale = 1.0 / (double)invScale;
        }
        this.jLabelScale.setText(" " + new DecimalFormat("#.##").format(scale));
        final double val = scale;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SingleVecciPanel.this.singleVectorPanel1.setScale(val);
                SingleVecciPanel.this.singleVectorPanel1.setGrid(settings.isGrid, settings.gridSize);
                SingleVecciPanel.this.singleVectorPanel1.repaint();
                SingleVecciPanel.this.singleVectorPanel1.sharedRepaint();
            }
        });
        --this.mClassSetting;
        this.updateOutput();
    }

    int getScaleSlider() {
        return this.jSliderSourceScale.getValue();
    }

    @Override
    public void moved(EditMouseEvent evt) {
        if (!evt.dragging || !evt.ctrlPressed) {
            return;
        }
        this.updateOutput();
    }

    @Override
    public void deIconified() {
    }

    public void updateMode() {
        if (this.singleVectorPanel1.getSharedVars().workingMode == 0) {
            this.jLabelMode.setText("Set");
        }
        if (this.singleVectorPanel1.getSharedVars().workingMode == 1) {
            this.jLabelMode.setText("Vector");
        }
        if (this.singleVectorPanel1.getSharedVars().workingMode == 2) {
            this.jLabelMode.setText("Point");
        }
    }
}

