/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.veccy;

import de.malban.vide.veccy.SpriteData;
import de.malban.vide.veccy.SpriteDataPool;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

public class SpriteDataPanel
extends JPanel {
    private SpriteData mSpriteData = new SpriteData();
    private SpriteDataPool mSpriteDataPool;
    private int mClassSetting = 0;
    private JButton jButtonDelete;
    private JButton jButtonNew;
    private JButton jButtonSave;
    private JButton jButtonSaveAsNew;
    private JComboBox jComboBoxKlasse;
    private JComboBox jComboBoxName;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JTextField jTextFieldKlasse;
    private JTextField jTextFieldName;

    public SpriteDataPanel() {
        this.initComponents();
        this.mSpriteDataPool = new SpriteDataPool();
        this.resetConfigPool(false, "");
    }

    private void resetConfigPool(boolean select, String klasseToSet) {
        ++this.mClassSetting;
        Collection<String> collectionKlasse = this.mSpriteDataPool.getKlassenHashMap().values();
        Iterator<String> iterKlasse = collectionKlasse.iterator();
        int i = 0;
        String klasse = "";
        this.jComboBoxKlasse.removeAllItems();
        while (iterKlasse.hasNext()) {
            String item = iterKlasse.next();
            this.jComboBoxKlasse.addItem(item);
            if (select) {
                if (klasseToSet.length() == 0) {
                    if (i == 0) {
                        this.jComboBoxKlasse.setSelectedIndex(i);
                        this.jTextFieldKlasse.setText(item);
                        klasse = item;
                    }
                } else if (klasseToSet.equalsIgnoreCase(item)) {
                    this.jComboBoxKlasse.setSelectedIndex(i);
                    this.jTextFieldKlasse.setText(item);
                    klasse = item;
                }
            }
            ++i;
        }
        if (select && klasse.length() == 0 && this.jComboBoxKlasse.getItemCount() > 0) {
            this.jComboBoxKlasse.setSelectedIndex(0);
            this.jTextFieldKlasse.setText(this.jComboBoxKlasse.getSelectedItem().toString());
            klasse = this.jComboBoxKlasse.getSelectedItem().toString();
        }
        if (!select) {
            this.jComboBoxKlasse.setSelectedIndex(-1);
        }
        Collection<SpriteData> colC = this.mSpriteDataPool.getMapForKlasse(klasse).values();
        Iterator<SpriteData> iterC = colC.iterator();
        this.jComboBoxName.removeAllItems();
        i = 0;
        while (iterC.hasNext()) {
            SpriteData item = iterC.next();
            this.jComboBoxName.addItem(item.mName);
            if (i == 0 && select) {
                this.jComboBoxName.setSelectedIndex(0);
                this.mSpriteData = this.mSpriteDataPool.get(item.mName);
                this.setAllFromCurrent();
            }
            ++i;
        }
        if (!select) {
            this.jComboBoxName.setSelectedIndex(-1);
        }
        --this.mClassSetting;
    }

    private void clearAll() {
        ++this.mClassSetting;
        this.mSpriteData = new SpriteData();
        this.setAllFromCurrent();
        --this.mClassSetting;
    }

    private void setAllFromCurrent() {
        ++this.mClassSetting;
        this.jComboBoxKlasse.setSelectedItem(this.mSpriteData.mClass);
        this.jTextFieldKlasse.setText(this.mSpriteData.mClass);
        this.jComboBoxName.setSelectedItem(this.mSpriteData.mName);
        this.jTextFieldName.setText(this.mSpriteData.mName);
        --this.mClassSetting;
    }

    private void readAllToCurrent() {
        this.mSpriteData.mClass = this.jTextFieldKlasse.getText();
        this.mSpriteData.mName = this.jTextFieldName.getText();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jComboBoxKlasse = new JComboBox();
        this.jComboBoxName = new JComboBox();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jTextFieldName = new JTextField();
        this.jTextFieldKlasse = new JTextField();
        this.jButtonNew = new JButton();
        this.jButtonSave = new JButton();
        this.jButtonSaveAsNew = new JButton();
        this.jButtonDelete = new JButton();
        this.jPanel2 = new JPanel();
        this.jPanel1.setBorder(BorderFactory.createEtchedBorder());
        this.jComboBoxKlasse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SpriteDataPanel.this.jComboBoxKlasseActionPerformed(evt);
            }
        });
        this.jComboBoxName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SpriteDataPanel.this.jComboBoxNameActionPerformed(evt);
            }
        });
        this.jLabel3.setText("Name");
        this.jLabel4.setText("Class");
        this.jButtonNew.setText("New");
        this.jButtonNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SpriteDataPanel.this.jButtonNewActionPerformed(evt);
            }
        });
        this.jButtonSave.setText("Save");
        this.jButtonSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SpriteDataPanel.this.jButtonSaveActionPerformed(evt);
            }
        });
        this.jButtonSaveAsNew.setText("Save as new");
        this.jButtonSaveAsNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SpriteDataPanel.this.jButtonSaveAsNewActionPerformed(evt);
            }
        });
        this.jButtonDelete.setText("Delete");
        this.jButtonDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SpriteDataPanel.this.jButtonDeleteActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel4).addComponent(this.jLabel3)).addGap(16, 16, 16).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jTextFieldName, GroupLayout.Alignment.LEADING, -1, 146, Short.MAX_VALUE).addComponent(this.jTextFieldKlasse, GroupLayout.Alignment.LEADING, -1, 146, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jComboBoxKlasse, 0, 146, Short.MAX_VALUE).addComponent(this.jComboBoxName, 0, 146, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonSave).addComponent(this.jButtonNew)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonSaveAsNew).addComponent(this.jButtonDelete)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jButtonDelete).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonSave).addComponent(this.jButtonSaveAsNew))).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jComboBoxKlasse, -2, -1, -2).addComponent(this.jButtonNew)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBoxName, -2, -1, -2)).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.jTextFieldKlasse, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.jTextFieldName, -2, -1, -2))))).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 531, Short.MAX_VALUE));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 215, Short.MAX_VALUE));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE)));
    }

    private void jButtonNewActionPerformed(ActionEvent evt) {
        ++this.mClassSetting;
        this.mSpriteData = new SpriteData();
        this.clearAll();
        this.resetConfigPool(false, "");
        --this.mClassSetting;
    }

    private void jButtonSaveActionPerformed(ActionEvent evt) {
        this.readAllToCurrent();
        this.mSpriteDataPool.put(this.mSpriteData);
        this.mSpriteDataPool.save();
        ++this.mClassSetting;
        String klasse = this.jTextFieldKlasse.getText();
        this.resetConfigPool(true, klasse);
        this.jComboBoxName.setSelectedItem(this.mSpriteData.mName);
        --this.mClassSetting;
    }

    private void jButtonSaveAsNewActionPerformed(ActionEvent evt) {
        this.mSpriteData = new SpriteData();
        this.readAllToCurrent();
        this.mSpriteDataPool.putAsNew(this.mSpriteData);
        this.mSpriteDataPool.save();
        ++this.mClassSetting;
        String klasse = this.jTextFieldKlasse.getText();
        this.resetConfigPool(true, klasse);
        this.jComboBoxName.setSelectedItem(this.mSpriteData.mName);
        --this.mClassSetting;
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        this.readAllToCurrent();
        this.mSpriteDataPool.remove(this.mSpriteData);
        this.mSpriteDataPool.save();
        ++this.mClassSetting;
        String klasse = this.jTextFieldKlasse.getText();
        this.resetConfigPool(true, klasse);
        if (this.jComboBoxName.getSelectedIndex() == -1) {
            this.clearAll();
        }
        String key = this.jComboBoxName.getSelectedItem().toString();
        this.mSpriteData = this.mSpriteDataPool.get(key);
        this.setAllFromCurrent();
        --this.mClassSetting;
    }

    private void jComboBoxKlasseActionPerformed(ActionEvent evt) {
        if (this.mClassSetting > 0) {
            return;
        }
        ++this.mClassSetting;
        String selected = this.jComboBoxKlasse.getSelectedItem().toString();
        this.clearAll();
        this.resetConfigPool(true, selected);
        this.jTextFieldKlasse.setText(this.jComboBoxKlasse.getSelectedItem().toString());
        String key = this.jComboBoxName.getSelectedItem().toString();
        this.mSpriteData = this.mSpriteDataPool.get(key);
        this.setAllFromCurrent();
        --this.mClassSetting;
    }

    private void jComboBoxNameActionPerformed(ActionEvent evt) {
        if (this.mClassSetting > 0) {
            return;
        }
        String key = this.jComboBoxName.getSelectedItem().toString();
        this.mSpriteData = this.mSpriteDataPool.get(key);
        this.setAllFromCurrent();
    }
}

