/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.veccy;

import de.malban.graphics.Single3dDisplayPanel;
import de.malban.graphics.VectorColors;
import de.malban.util.Utility;
import de.malban.util.UtilityFiles;
import de.malban.util.XMLSupport;
import java.awt.Color;

public class StoryboardElement
extends Single3dDisplayPanel {
    public int listScaleFrom = 80;
    public int listScaleTo = 80;
    public int listScaleStart = 80;
    public int listScaleDelay = 0;
    public int listScaleIncrease = 0;
    public int intensityFrom = 127;
    public int intensityTo = 127;
    public int intensityStart = 127;
    public int intensityDelay = 0;
    public int intensityIncrease = 0;
    public int moveScale = 80;
    public int positionXFrom = 0;
    public int positionYFrom = 0;
    public int positionXTo = 0;
    public int positionYTo = 0;
    public int positionXStart = 0;
    public int positionYStart = 0;
    public int positionXDelay = 0;
    public int positionYDelay = 0;
    public int positionXIncrease = 0;
    public int positionYIncrease = 0;
    public boolean disabled = false;
    public boolean loop = true;
    public boolean _goto = false;
    public boolean pause = false;
    public boolean manualRoundCount = false;
    public boolean animationLoop = true;
    public String drawType = "synced";
    public String listName = "";
    public int delay = 0;
    public int vectrexdelay = 3;
    public int loopCount = 0;
    public int resyncMax = 20;
    public int factor = 1;
    public int goto_value = 0;
    public int roundCount = 0;
    public int version = 1;

    public void calculateV2() {
        double inverse;
        if (this.roundCount == 0) {
            this.listScaleDelay = 0;
            this.listScaleIncrease = 0;
            this.intensityDelay = 0;
            this.intensityIncrease = 0;
            this.positionXDelay = 0;
            this.positionYDelay = 0;
            this.positionXIncrease = 0;
            this.positionYIncrease = 0;
            return;
        }
        double dif = this.listScaleTo - this.listScaleFrom;
        double perRound = dif / (double)this.roundCount;
        int round = 0;
        round = perRound > 0.0 ? (int)(perRound + 0.99999) : (int)(perRound - 0.99999);
        if (dif == 0.0) {
            this.listScaleDelay = 0;
            this.listScaleIncrease = 0;
        } else {
            this.listScaleIncrease = round;
            if (Math.abs(perRound) >= 1.0) {
                this.listScaleDelay = 1;
            } else {
                inverse = 1.0 / Math.abs(perRound) + 1.0;
                this.listScaleDelay = (int)inverse;
            }
        }
        dif = this.intensityTo - this.intensityFrom;
        perRound = dif / (double)this.roundCount;
        round = perRound > 0.0 ? (int)(perRound + 0.99999) : (int)(perRound - 0.99999);
        if (dif == 0.0) {
            this.intensityDelay = 0;
            this.intensityIncrease = 0;
        } else {
            this.intensityIncrease = round;
            if (Math.abs(perRound) >= 1.0) {
                this.intensityDelay = 1;
            } else {
                inverse = 1.0 / Math.abs(perRound) + 1.0;
                this.intensityDelay = (int)inverse;
            }
        }
        dif = this.positionXTo - this.positionXFrom;
        perRound = dif / (double)this.roundCount;
        round = perRound > 0.0 ? (int)(perRound + 0.99999) : (int)(perRound - 0.99999);
        if (dif == 0.0) {
            this.positionXDelay = 0;
            this.positionXIncrease = 0;
        } else {
            this.positionXIncrease = round;
            if (Math.abs(perRound) >= 1.0) {
                this.positionXDelay = 1;
            } else {
                inverse = 1.0 / Math.abs(perRound) + 1.0;
                this.positionXDelay = (int)inverse;
            }
        }
        dif = this.positionYTo - this.positionYFrom;
        perRound = dif / (double)this.roundCount;
        round = perRound > 0.0 ? (int)(perRound + 0.99999) : (int)(perRound - 0.99999);
        if (dif == 0.0) {
            this.positionYDelay = 0;
            this.positionYIncrease = 0;
        } else {
            this.positionYIncrease = round;
            if (Math.abs(perRound) >= 1.0) {
                this.positionYDelay = 1;
            } else {
                inverse = 1.0 / Math.abs(perRound) + 1.0;
                this.positionYDelay = (int)inverse;
            }
        }
    }

    public boolean toXML(StringBuilder s, String tag) {
        s.append("<").append(tag).append(">\n");
        boolean ok = true;
        ok &= XMLSupport.addElement(s, "version", this.version);
        if (this.version == 1) {
            ok &= XMLSupport.addElement(s, "listScaleStart", this.listScaleStart);
            ok &= XMLSupport.addElement(s, "listScaleIncAtStep", this.listScaleDelay);
            ok &= XMLSupport.addElement(s, "listScaleInc", this.listScaleIncrease);
            ok &= XMLSupport.addElement(s, "intensityStart", this.intensityStart);
            ok &= XMLSupport.addElement(s, "intensityIncAtStep", this.intensityDelay);
            ok &= XMLSupport.addElement(s, "intensityInc", this.intensityIncrease);
            ok &= XMLSupport.addElement(s, "moveScale", this.moveScale);
            ok &= XMLSupport.addElement(s, "positionXStart", this.positionXStart);
            ok &= XMLSupport.addElement(s, "positionYStart", this.positionYStart);
            ok &= XMLSupport.addElement(s, "positionXIncAtStep", this.positionXDelay);
            ok &= XMLSupport.addElement(s, "positionYIncAtStep", this.positionYDelay);
            ok &= XMLSupport.addElement(s, "positionXInc", this.positionXIncrease);
            ok &= XMLSupport.addElement(s, "positionYInc", this.positionYIncrease);
            ok &= XMLSupport.addElement(s, "goto_value", this.goto_value);
            ok &= XMLSupport.addElement(s, "loop", this.loop);
            ok &= XMLSupport.addElement(s, "_goto", this._goto);
            ok &= XMLSupport.addElement(s, "pause", this.pause);
            ok &= XMLSupport.addElement(s, "drawType", this.drawType);
            ok &= XMLSupport.addElement(s, "listName", Utility.makeVideRelative(this.listName));
            ok &= XMLSupport.addElement(s, "delay", this.delay);
            ok &= XMLSupport.addElement(s, "vectrexdelay", this.vectrexdelay);
            ok &= XMLSupport.addElement(s, "loopCount", this.loopCount);
            ok &= XMLSupport.addElement(s, "resyncMax", this.resyncMax);
            ok &= XMLSupport.addElement(s, "factor", this.factor);
            ok &= XMLSupport.addElement(s, "manualRoundCount", this.manualRoundCount);
            ok &= XMLSupport.addElement(s, "roundCount", this.roundCount);
        } else if (this.version == 2) {
            ok &= XMLSupport.addElement(s, "animationLoop", this.animationLoop);
            ok &= XMLSupport.addElement(s, "listScaleFrom", this.listScaleFrom);
            ok &= XMLSupport.addElement(s, "listScaleTo", this.listScaleTo);
            ok &= XMLSupport.addElement(s, "intensityFrom", this.intensityFrom);
            ok &= XMLSupport.addElement(s, "intensityTo", this.intensityTo);
            ok &= XMLSupport.addElement(s, "moveScale", this.moveScale);
            ok &= XMLSupport.addElement(s, "positionXFrom", this.positionXFrom);
            ok &= XMLSupport.addElement(s, "positionYFrom", this.positionYFrom);
            ok &= XMLSupport.addElement(s, "positionXTo", this.positionXTo);
            ok &= XMLSupport.addElement(s, "positionYTo", this.positionYTo);
            ok &= XMLSupport.addElement(s, "pause", this.pause);
            ok &= XMLSupport.addElement(s, "drawType", this.drawType);
            ok &= XMLSupport.addElement(s, "listName", this.listName);
            ok &= XMLSupport.addElement(s, "delay", this.delay);
            ok &= XMLSupport.addElement(s, "vectrexdelay", this.vectrexdelay);
            ok &= XMLSupport.addElement(s, "resyncMax", this.resyncMax);
            ok &= XMLSupport.addElement(s, "factor", this.factor);
            ok &= XMLSupport.addElement(s, "roundCount", this.roundCount);
        }
        s.append("</").append(tag).append(">\n");
        return ok;
    }

    public boolean fromXML(StringBuilder xml, XMLSupport xmlSupport) {
        int errorCode = 0;
        this.version = xmlSupport.getIntElement("version", xml);
        if (xmlSupport.errorCode != 0) {
            this.version = 1;
        }
        if (this.version == 1) {
            this.listScaleStart = xmlSupport.getIntElement("listScaleStart", xml);
            errorCode |= xmlSupport.errorCode;
            this.listScaleDelay = xmlSupport.getIntElement("listScaleIncAtStep", xml);
            errorCode |= xmlSupport.errorCode;
            this.listScaleIncrease = xmlSupport.getIntElement("listScaleInc", xml);
            errorCode |= xmlSupport.errorCode;
            this.intensityStart = xmlSupport.getIntElement("intensityStart", xml);
            errorCode |= xmlSupport.errorCode;
            this.intensityDelay = xmlSupport.getIntElement("intensityIncAtStep", xml);
            errorCode |= xmlSupport.errorCode;
            this.intensityIncrease = xmlSupport.getIntElement("intensityInc", xml);
            errorCode |= xmlSupport.errorCode;
            this.moveScale = xmlSupport.getIntElement("moveScale", xml);
            errorCode |= xmlSupport.errorCode;
            this.positionXStart = xmlSupport.getIntElement("positionXStart", xml);
            errorCode |= xmlSupport.errorCode;
            this.positionYStart = xmlSupport.getIntElement("positionYStart", xml);
            errorCode |= xmlSupport.errorCode;
            this.positionXDelay = xmlSupport.getIntElement("positionXIncAtStep", xml);
            errorCode |= xmlSupport.errorCode;
            this.positionYDelay = xmlSupport.getIntElement("positionYIncAtStep", xml);
            errorCode |= xmlSupport.errorCode;
            this.positionXIncrease = xmlSupport.getIntElement("positionXInc", xml);
            errorCode |= xmlSupport.errorCode;
            this.positionYIncrease = xmlSupport.getIntElement("positionYInc", xml);
            errorCode |= xmlSupport.errorCode;
            this.goto_value = xmlSupport.getIntElement("goto_value", xml);
            errorCode |= xmlSupport.errorCode;
            this.loop = xmlSupport.getBooleanElement("loop", xml);
            errorCode |= xmlSupport.errorCode;
            this._goto = xmlSupport.getBooleanElement("_goto", xml);
            errorCode |= xmlSupport.errorCode;
            this.pause = xmlSupport.getBooleanElement("pause", xml);
            errorCode |= xmlSupport.errorCode;
            this.manualRoundCount = xmlSupport.getBooleanElement("manualRoundCount", xml);
            errorCode |= xmlSupport.errorCode;
            this.drawType = xmlSupport.getStringElement("drawType", xml);
            errorCode |= xmlSupport.errorCode;
            this.listName = xmlSupport.getStringElement("listName", xml);
            errorCode |= xmlSupport.errorCode;
            this.listName = UtilityFiles.convertSeperator(this.listName);
            this.delay = xmlSupport.getIntElement("delay", xml);
            errorCode |= xmlSupport.errorCode;
            this.vectrexdelay = xmlSupport.getIntElement("vectrexdelay", xml);
            errorCode |= xmlSupport.errorCode;
            this.loopCount = xmlSupport.getIntElement("loopCount", xml);
            errorCode |= xmlSupport.errorCode;
            this.resyncMax = xmlSupport.getIntElement("resyncMax", xml);
            errorCode |= xmlSupport.errorCode;
            this.factor = xmlSupport.getIntElement("factor", xml);
            errorCode |= xmlSupport.errorCode;
            this.roundCount = xmlSupport.getIntElement("roundCount", xml);
            errorCode |= xmlSupport.errorCode;
        } else if (this.version == 2) {
            this.animationLoop = xmlSupport.getBooleanElement("animationLoop", xml);
            errorCode |= xmlSupport.errorCode;
            this.listScaleFrom = xmlSupport.getIntElement("listScaleFrom", xml);
            errorCode |= xmlSupport.errorCode;
            this.listScaleTo = xmlSupport.getIntElement("listScaleTo", xml);
            errorCode |= xmlSupport.errorCode;
            this.intensityFrom = xmlSupport.getIntElement("intensityFrom", xml);
            errorCode |= xmlSupport.errorCode;
            this.intensityTo = xmlSupport.getIntElement("intensityTo", xml);
            errorCode |= xmlSupport.errorCode;
            this.moveScale = xmlSupport.getIntElement("moveScale", xml);
            errorCode |= xmlSupport.errorCode;
            this.positionXFrom = xmlSupport.getIntElement("positionXFrom", xml);
            errorCode |= xmlSupport.errorCode;
            this.positionYFrom = xmlSupport.getIntElement("positionYFrom", xml);
            errorCode |= xmlSupport.errorCode;
            this.positionXTo = xmlSupport.getIntElement("positionXTo", xml);
            errorCode |= xmlSupport.errorCode;
            this.positionYTo = xmlSupport.getIntElement("positionYTo", xml);
            errorCode |= xmlSupport.errorCode;
            this.pause = xmlSupport.getBooleanElement("pause", xml);
            errorCode |= xmlSupport.errorCode;
            this.drawType = xmlSupport.getStringElement("drawType", xml);
            errorCode |= xmlSupport.errorCode;
            this.listName = xmlSupport.getStringElement("listName", xml);
            errorCode |= xmlSupport.errorCode;
            this.listName = UtilityFiles.convertSeperator(this.listName);
            this.delay = xmlSupport.getIntElement("delay", xml);
            errorCode |= xmlSupport.errorCode;
            this.vectrexdelay = xmlSupport.getIntElement("vectrexdelay", xml);
            errorCode |= xmlSupport.errorCode;
            this.resyncMax = xmlSupport.getIntElement("resyncMax", xml);
            errorCode |= xmlSupport.errorCode;
            this.factor = xmlSupport.getIntElement("factor", xml);
            errorCode |= xmlSupport.errorCode;
            this.roundCount = xmlSupport.getIntElement("roundCount", xml);
            errorCode |= xmlSupport.errorCode;
        }
        return errorCode == 0;
    }

    void setElementSelected(boolean b) {
        if (b) {
            this.setVectorBackground(new Color((VectorColors.VECCI_BACKGROUND_COLOR.getRed() + 30) % 255, (VectorColors.VECCI_BACKGROUND_COLOR.getGreen() + 30) % 255, (VectorColors.VECCI_BACKGROUND_COLOR.getBlue() + 30) % 255, 255));
        } else {
            this.setVectorBackground(VectorColors.VECCI_BACKGROUND_COLOR);
        }
        this.continueRepaint();
    }
}

