/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.veccy;

import de.malban.Global;
import de.malban.config.Configuration;
import de.malban.graphics.GFXVectorAnimation;
import de.malban.gui.CSAMainFrame;
import de.malban.gui.HotKey;
import de.malban.gui.Windowable;
import de.malban.gui.components.CSAView;
import de.malban.gui.dialogs.InternalFrameFileChoser;
import de.malban.gui.panels.LogPanel;
import de.malban.util.Utility;
import de.malban.util.UtilityFiles;
import de.malban.util.UtilityString;
import de.malban.util.XMLSupport;
import de.malban.vide.assy.Asmj;
import de.malban.vide.veccy.StoryboardElement;
import de.malban.vide.veccy.StoryboardLanePanel;
import de.malban.vide.veccy.StoryboardPanelInterface;
import de.malban.vide.veccy.VeccyPanel;
import de.malban.vide.vecx.VecXPanel;
import de.malban.vide.vedi.VediPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;

public class StoryboardPanel
extends JPanel
implements Windowable,
StoryboardPanelInterface {
    LogPanel log = (LogPanel)Configuration.getConfiguration().getDebugEntity();
    String pathOnly = "";
    private int mClassSetting = 0;
    private CSAView mParent = null;
    private JMenuItem mParentMenuItem = null;
    Thread two = null;
    String orgName = "";
    BufferedImage baseImage;
    VeccyPanel veccy = null;
    private ArrayList<StoryboardLanePanel> lanes = new ArrayList();
    private StoryboardLanePanel currentLane = null;
    private StoryboardElement currentElement = null;
    private GFXVectorAnimation currentAnimation = new GFXVectorAnimation();
    Thread one = null;
    public boolean asmStarted = false;
    public boolean stop = false;
    public boolean running = false;
    public boolean pausing = false;
    private ButtonGroup buttonGroup1;
    private JButton jButton3;
    private JButton jButtonAssemble;
    private JButton jButtonEditInVedi;
    private JButton jButtonLoad1;
    private JButton jButtonLoad2;
    private JButton jButtonSave3;
    private JButton jButtonaddLane;
    private JButton jButtonaddLane1;
    private JCheckBox jCheckBoxDisable;
    private JCheckBox jCheckBoxGoto;
    private JCheckBox jCheckBoxLoop;
    private JCheckBox jCheckBoxManualRoundCount;
    private JCheckBox jCheckBoxNoAdditionalSynOptimization;
    private JCheckBox jCheckBoxPause;
    private JComboBox jComboBoxDrawType;
    private JLabel jLabel1;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane5;
    private JTextArea jTextAreaResult;
    private JTextField jTextFieldAnimationName;
    private JTextField jTextFieldDelayVectrex;
    private JTextField jTextFieldFactor;
    private JTextField jTextFieldFrameCount;
    private JTextField jTextFieldFrameCount2;
    private JTextField jTextFieldGotoValue;
    private JTextField jTextFieldListIntensityDelay;
    private JTextField jTextFieldListIntensityFrom;
    private JTextField jTextFieldListIntensityIncrease;
    private JTextField jTextFieldListScaleDelay;
    private JTextField jTextFieldListScaleIncrease;
    private JTextField jTextFieldListScaleStart;
    private JTextField jTextFieldLoopCount;
    private JTextField jTextFieldMoveScale;
    private JTextField jTextFieldPosDelayX;
    private JTextField jTextFieldPosDelayY;
    private JTextField jTextFieldPosIncreaseX;
    private JTextField jTextFieldPosIncreaseY;
    private JTextField jTextFieldPosStartX;
    private JTextField jTextFieldPosStartY;
    private JTextField jTextFieldResync;
    private JTextField jTextFieldRoundCount;
    private JPanel lanePanel;
    private StoryboardLanePanel storyboardLanePanel1;

    @Override
    public ArrayList<StoryboardLanePanel> getLanes() {
        return this.lanes;
    }

    @Override
    public void setLanes(ArrayList<StoryboardLanePanel> lanes) {
        this.lanes = lanes;
    }

    @Override
    public StoryboardLanePanel getCurrentLane() {
        return this.currentLane;
    }

    @Override
    public void setCurrentLane(StoryboardLanePanel currentLane) {
        this.currentLane = currentLane;
    }

    @Override
    public StoryboardElement getCurrentElement() {
        return this.currentElement;
    }

    @Override
    public void setCurrentElement(StoryboardElement currentElement) {
        this.currentElement = currentElement;
    }

    @Override
    public GFXVectorAnimation getCurrentAnimation() {
        return this.currentAnimation;
    }

    @Override
    public void setCurrentAnimation(GFXVectorAnimation currentAnimation) {
        this.currentAnimation = currentAnimation;
    }

    @Override
    public void closing() {
        if (this.veccy != null) {
            this.veccy.removeSBPanel();
        }
    }

    @Override
    public boolean isIcon() {
        CSAMainFrame frame = Configuration.getConfiguration().getMainFrame();
        if (frame.getInternalFrame(this) == null) {
            return false;
        }
        return frame.getInternalFrame(this).isIcon();
    }

    @Override
    public void setIcon(boolean b) {
        CSAMainFrame frame = Configuration.getConfiguration().getMainFrame();
        if (frame.getInternalFrame(this) == null) {
            return;
        }
        try {
            frame.getInternalFrame(this).setIcon(b);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void setParentWindow(CSAView jpv) {
        this.mParent = jpv;
    }

    @Override
    public void setMenuItem(JMenuItem item) {
        this.mParentMenuItem = item;
        this.mParentMenuItem.setText("Vector: Storyboard");
    }

    @Override
    public JMenuItem getMenuItem() {
        return this.mParentMenuItem;
    }

    @Override
    public JPanel getPanel() {
        return this;
    }

    public StoryboardPanel() {
        this.initComponents();
        if (Global.getOSName().toUpperCase().contains("MAC")) {
            HotKey.addMacDefaults(this.jTextFieldAnimationName);
            HotKey.addMacDefaults(this.jTextFieldFrameCount);
            HotKey.addMacDefaults(this.jTextFieldDelayVectrex);
            HotKey.addMacDefaults(this.jTextFieldListScaleStart);
            HotKey.addMacDefaults(this.jTextFieldListScaleDelay);
            HotKey.addMacDefaults(this.jTextFieldListScaleIncrease);
            HotKey.addMacDefaults(this.jTextFieldListIntensityFrom);
            HotKey.addMacDefaults(this.jTextFieldListIntensityDelay);
            HotKey.addMacDefaults(this.jTextFieldListIntensityIncrease);
            HotKey.addMacDefaults(this.jTextFieldPosStartX);
            HotKey.addMacDefaults(this.jTextFieldPosDelayX);
            HotKey.addMacDefaults(this.jTextFieldPosIncreaseX);
            HotKey.addMacDefaults(this.jTextFieldPosStartY);
            HotKey.addMacDefaults(this.jTextFieldPosDelayY);
            HotKey.addMacDefaults(this.jTextFieldPosIncreaseY);
            HotKey.addMacDefaults(this.jTextFieldMoveScale);
            HotKey.addMacDefaults(this.jTextFieldResync);
            HotKey.addMacDefaults(this.jTextFieldFactor);
            HotKey.addMacDefaults(this.jTextFieldGotoValue);
            HotKey.addMacDefaults(this.jTextFieldLoopCount);
        }
        this.lanePanel.remove(this.storyboardLanePanel1);
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jScrollPane1 = new JScrollPane();
        this.lanePanel = new JPanel();
        this.storyboardLanePanel1 = new StoryboardLanePanel();
        this.jButtonaddLane = new JButton();
        this.jPanel3 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jTextFieldFrameCount = new JTextField();
        this.jLabel2 = new JLabel();
        this.jButton3 = new JButton();
        this.jLabel3 = new JLabel();
        this.jTextFieldListScaleStart = new JTextField();
        this.jLabel4 = new JLabel();
        this.jTextFieldMoveScale = new JTextField();
        this.jLabel5 = new JLabel();
        this.jTextFieldPosStartX = new JTextField();
        this.jTextFieldPosStartY = new JTextField();
        this.jLabel7 = new JLabel();
        this.jTextFieldPosDelayX = new JTextField();
        this.jTextFieldPosDelayY = new JTextField();
        this.jLabel8 = new JLabel();
        this.jComboBoxDrawType = new JComboBox();
        this.jTextFieldPosIncreaseX = new JTextField();
        this.jTextFieldPosIncreaseY = new JTextField();
        this.jTextFieldListScaleIncrease = new JTextField();
        this.jTextFieldListScaleDelay = new JTextField();
        this.jButtonLoad2 = new JButton();
        this.jLabel6 = new JLabel();
        this.jTextFieldAnimationName = new JTextField();
        this.jLabel12 = new JLabel();
        this.jTextFieldLoopCount = new JTextField();
        this.jTextFieldDelayVectrex = new JTextField();
        this.jTextFieldResync = new JTextField();
        this.jTextFieldFactor = new JTextField();
        this.jLabel14 = new JLabel();
        this.jTextFieldRoundCount = new JTextField();
        this.jCheckBoxManualRoundCount = new JCheckBox();
        this.jLabel9 = new JLabel();
        this.jTextFieldListIntensityFrom = new JTextField();
        this.jTextFieldListIntensityDelay = new JTextField();
        this.jTextFieldListIntensityIncrease = new JTextField();
        this.jTextFieldGotoValue = new JTextField();
        this.jCheckBoxGoto = new JCheckBox();
        this.jCheckBoxLoop = new JCheckBox();
        this.jLabel13 = new JLabel();
        this.jCheckBoxDisable = new JCheckBox();
        this.jCheckBoxPause = new JCheckBox();
        this.jCheckBoxNoAdditionalSynOptimization = new JCheckBox();
        this.jPanel4 = new JPanel();
        this.jScrollPane5 = new JScrollPane();
        this.jTextAreaResult = new JTextArea();
        this.jPanel5 = new JPanel();
        this.jButtonLoad1 = new JButton();
        this.jButtonSave3 = new JButton();
        this.jButtonAssemble = new JButton();
        this.jButtonEditInVedi = new JButton();
        this.jButtonaddLane1 = new JButton();
        this.jLabel15 = new JLabel();
        this.jTextFieldFrameCount2 = new JTextField();
        this.jScrollPane1.setHorizontalScrollBarPolicy(32);
        this.jScrollPane1.setVerticalScrollBarPolicy(22);
        this.lanePanel.setPreferredSize(new Dimension(600, 428));
        this.lanePanel.setLayout(null);
        this.lanePanel.add(this.storyboardLanePanel1);
        this.storyboardLanePanel1.setBounds(0, 65, 1028, 0);
        this.jScrollPane1.setViewportView(this.lanePanel);
        this.jButtonaddLane.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/add.png")));
        this.jButtonaddLane.setText("add lane");
        this.jButtonaddLane.setMargin(new Insets(2, 2, 2, 2));
        this.jButtonaddLane.setPreferredSize(new Dimension(93, 21));
        this.jButtonaddLane.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StoryboardPanel.this.jButtonaddLaneActionPerformed(evt);
            }
        });
        this.jPanel3.setBorder(BorderFactory.createTitledBorder("sequence detail"));
        this.jLabel1.setText("frames");
        this.jTextFieldFrameCount.setEditable(false);
        this.jTextFieldFrameCount.setText("10");
        this.jLabel2.setText("animation");
        this.jButton3.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/delete.png")));
        this.jButton3.setToolTipText("delete current element");
        this.jButton3.setEnabled(false);
        this.jButton3.setPreferredSize(new Dimension(20, 20));
        this.jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StoryboardPanel.this.jButton3ActionPerformed(evt);
            }
        });
        this.jLabel3.setText("scale/delay/increase");
        this.jTextFieldListScaleStart.setText("10");
        this.jTextFieldListScaleStart.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StoryboardPanel.this.jTextFieldListScaleStartActionPerformed(evt);
            }
        });
        this.jTextFieldListScaleStart.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                StoryboardPanel.this.jTextFieldListScaleStartKeyReleased(evt);
            }
        });
        this.jLabel4.setText("move - scale");
        this.jTextFieldMoveScale.setText("10");
        this.jTextFieldMoveScale.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StoryboardPanel.this.jTextFieldMoveScaleActionPerformed(evt);
            }
        });
        this.jTextFieldMoveScale.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                StoryboardPanel.this.jTextFieldPosStartXKeyReleased(evt);
            }
        });
        this.jLabel5.setText("X/delay/increase");
        this.jTextFieldPosStartX.setText("10");
        this.jTextFieldPosStartX.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StoryboardPanel.this.jTextFieldPosStartXActionPerformed(evt);
            }
        });
        this.jTextFieldPosStartX.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                StoryboardPanel.this.textfieldKeyReleased(evt);
            }
        });
        this.jTextFieldPosStartY.setText("10");
        this.jTextFieldPosStartY.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StoryboardPanel.this.jTextFieldPosStartYActionPerformed(evt);
            }
        });
        this.jTextFieldPosStartY.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                StoryboardPanel.this.jTextFieldPosStartXKeyReleased(evt);
            }
        });
        this.jLabel7.setText("Y/delay/increase");
        this.jTextFieldPosDelayX.setText("10");
        this.jTextFieldPosDelayX.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StoryboardPanel.this.jTextFieldPosDelayXActionPerformed(evt);
            }
        });
        this.jTextFieldPosDelayX.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                StoryboardPanel.this.jTextFieldPosStartXKeyReleased(evt);
            }
        });
        this.jTextFieldPosDelayY.setText("10");
        this.jTextFieldPosDelayY.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StoryboardPanel.this.jTextFieldPosDelayYActionPerformed(evt);
            }
        });
        this.jTextFieldPosDelayY.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                StoryboardPanel.this.jTextFieldPosStartXKeyReleased(evt);
            }
        });
        this.jLabel8.setText("draw type");
        this.jComboBoxDrawType.setModel(new DefaultComboBoxModel<String>(new String[]{"synced extended"}));
        this.jComboBoxDrawType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StoryboardPanel.this.jComboBoxDrawTypeActionPerformed(evt);
            }
        });
        this.jTextFieldPosIncreaseX.setText("10");
        this.jTextFieldPosIncreaseX.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StoryboardPanel.this.jTextFieldPosIncreaseXActionPerformed(evt);
            }
        });
        this.jTextFieldPosIncreaseX.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                StoryboardPanel.this.jTextFieldPosStartXKeyReleased(evt);
            }
        });
        this.jTextFieldPosIncreaseY.setText("10");
        this.jTextFieldPosIncreaseY.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StoryboardPanel.this.jTextFieldPosIncreaseYActionPerformed(evt);
            }
        });
        this.jTextFieldPosIncreaseY.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                StoryboardPanel.this.jTextFieldPosStartXKeyReleased(evt);
            }
        });
        this.jTextFieldListScaleIncrease.setText("10");
        this.jTextFieldListScaleIncrease.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StoryboardPanel.this.jTextFieldListScaleIncreaseActionPerformed(evt);
            }
        });
        this.jTextFieldListScaleIncrease.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                StoryboardPanel.this.jTextFieldListScaleIncreaseKeyReleased(evt);
            }
        });
        this.jTextFieldListScaleDelay.setText("10");
        this.jTextFieldListScaleDelay.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StoryboardPanel.this.textFieldReturn(evt);
            }
        });
        this.jTextFieldListScaleDelay.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                StoryboardPanel.this.jTextFieldListScaleDelayKeyReleased(evt);
            }
        });
        this.jButtonLoad2.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/page_go.png")));
        this.jButtonLoad2.setToolTipText("load animation");
        this.jButtonLoad2.setEnabled(false);
        this.jButtonLoad2.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonLoad2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StoryboardPanel.this.jButtonLoad2ActionPerformed(evt);
            }
        });
        this.jLabel6.setText("delay");
        this.jTextFieldAnimationName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StoryboardPanel.this.jTextFieldAnimationNameActionPerformed(evt);
            }
        });
        this.jLabel12.setText("loop");
        this.jTextFieldLoopCount.setText("10");
        this.jTextFieldLoopCount.setToolTipText("Loop count: (0 = endless, after loop - continue)");
        this.jTextFieldLoopCount.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StoryboardPanel.this.jTextFieldLoopCountActionPerformed(evt);
            }
        });
        this.jTextFieldDelayVectrex.setText("10");
        this.jTextFieldDelayVectrex.setToolTipText("display delay for vectrex, in \"rounds\"");
        this.jTextFieldDelayVectrex.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StoryboardPanel.this.jTextFieldDelayVectrexActionPerformed(evt);
            }
        });
        this.jTextFieldDelayVectrex.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                StoryboardPanel.this.jTextFieldDelayVectrexKeyReleased(evt);
            }
        });
        this.jTextFieldResync.setText("10");
        this.jTextFieldResync.setToolTipText("resync max");
        this.jTextFieldResync.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StoryboardPanel.this.jTextFieldResyncActionPerformed(evt);
            }
        });
        this.jTextFieldResync.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                StoryboardPanel.this.jTextFieldResyncjTextFieldPosStartXKeyReleased(evt);
            }
        });
        this.jTextFieldFactor.setText("10");
        this.jTextFieldFactor.setToolTipText("factor for list values");
        this.jTextFieldFactor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StoryboardPanel.this.jTextFieldFactorActionPerformed(evt);
            }
        });
        this.jTextFieldFactor.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                StoryboardPanel.this.jTextFieldFactorjTextFieldPosStartXKeyReleased(evt);
            }
        });
        this.jLabel14.setText("display rounds");
        this.jTextFieldRoundCount.setText("0");
        this.jTextFieldRoundCount.setEnabled(false);
        this.jTextFieldRoundCount.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StoryboardPanel.this.jTextFieldRoundCountActionPerformed(evt);
            }
        });
        this.jCheckBoxManualRoundCount.setText("manual round count");
        this.jCheckBoxManualRoundCount.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StoryboardPanel.this.jCheckBoxManualRoundCountActionPerformed(evt);
            }
        });
        this.jLabel9.setText("intensity/delay/increase");
        this.jLabel9.setEnabled(false);
        this.jTextFieldListIntensityFrom.setText("10");
        this.jTextFieldListIntensityFrom.setToolTipText("-1 = no intensity setting");
        this.jTextFieldListIntensityFrom.setEnabled(false);
        this.jTextFieldListIntensityFrom.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StoryboardPanel.this.jTextFieldListIntensityFromActionPerformed(evt);
            }
        });
        this.jTextFieldListIntensityFrom.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                StoryboardPanel.this.jTextFieldListIntensityFromKeyReleased(evt);
            }
        });
        this.jTextFieldListIntensityDelay.setText("10");
        this.jTextFieldListIntensityDelay.setEnabled(false);
        this.jTextFieldListIntensityDelay.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StoryboardPanel.this.jTextFieldListIntensityDelaytextFieldReturn(evt);
            }
        });
        this.jTextFieldListIntensityDelay.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                StoryboardPanel.this.jTextFieldListIntensityDelayKeyReleased(evt);
            }
        });
        this.jTextFieldListIntensityIncrease.setText("10");
        this.jTextFieldListIntensityIncrease.setEnabled(false);
        this.jTextFieldListIntensityIncrease.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StoryboardPanel.this.jTextFieldListIntensityIncreaseActionPerformed(evt);
            }
        });
        this.jTextFieldListIntensityIncrease.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                StoryboardPanel.this.jTextFieldListIntensityIncreaseKeyReleased(evt);
            }
        });
        this.jTextFieldGotoValue.setText("10");
        this.jTextFieldGotoValue.setToolTipText("GotValue - must be a storyboard element within this lane - 0 based.");
        this.jTextFieldGotoValue.setEnabled(false);
        this.jTextFieldGotoValue.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StoryboardPanel.this.jTextFieldGotoValueActionPerformed(evt);
            }
        });
        this.jTextFieldGotoValue.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                StoryboardPanel.this.jTextFieldGotoValuejTextFieldPosStartXKeyReleased(evt);
            }
        });
        this.jCheckBoxGoto.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StoryboardPanel.this.jCheckBoxGotoActionPerformed(evt);
            }
        });
        this.jCheckBoxLoop.setSelected(true);
        this.jCheckBoxLoop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StoryboardPanel.this.jCheckBoxLoopActionPerformed(evt);
            }
        });
        this.jLabel13.setText("jump");
        this.jCheckBoxDisable.setText("disable");
        this.jCheckBoxDisable.setToolTipText("treat sequence as if it was not aviable (for testing purposes - not SAVED)");
        this.jCheckBoxDisable.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StoryboardPanel.this.jCheckBoxDisableActionPerformed(evt);
            }
        });
        this.jCheckBoxPause.setText("is pause");
        this.jCheckBoxPause.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StoryboardPanel.this.jCheckBoxPauseActionPerformed(evt);
            }
        });
        this.jCheckBoxNoAdditionalSynOptimization.setSelected(true);
        this.jCheckBoxNoAdditionalSynOptimization.setText("no opt");
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel14).addComponent(this.jLabel5).addComponent(this.jLabel7).addComponent(this.jLabel4).addComponent(this.jLabel12).addComponent(this.jLabel2).addComponent(this.jLabel1).addComponent(this.jLabel3).addComponent(this.jLabel8).addComponent(this.jLabel9).addComponent(this.jLabel13)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jTextFieldAnimationName, -2, 147, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonLoad2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton3, -2, -1, -2)).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextFieldMoveScale, -2, 45, -2).addGroup(GroupLayout.Alignment.TRAILING, jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jComboBoxDrawType, -2, 147, -2).addGroup(GroupLayout.Alignment.LEADING, jPanel3Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jTextFieldLoopCount, -2, 45, -2).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jCheckBoxGoto).addGap(32, 32, 32).addComponent(this.jTextFieldGotoValue, -2, 45, -2)))).addGap(3, 3, 3).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jTextFieldResync, -2, 45, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldFactor, -2, 45, -2)).addComponent(this.jCheckBoxNoAdditionalSynOptimization))).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextFieldRoundCount, -2, 45, -2).addComponent(this.jCheckBoxLoop)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBoxManualRoundCount).addComponent(this.jCheckBoxPause, -2, 89, -2))).addGroup(GroupLayout.Alignment.TRAILING, jPanel3Layout.createSequentialGroup().addComponent(this.jCheckBoxDisable).addGap(39, 39, 39))).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextFieldPosStartY, -2, 45, -2).addComponent(this.jTextFieldPosStartX, -2, 45, -2).addComponent(this.jTextFieldListIntensityFrom, -2, 45, -2).addComponent(this.jTextFieldListScaleStart, -2, 45, -2).addComponent(this.jTextFieldFrameCount, -2, 45, -2)).addGap(6, 6, 6).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jTextFieldPosDelayX, -2, 45, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldPosIncreaseX, -2, 45, -2)).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jTextFieldPosDelayY, -2, 45, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldPosIncreaseY, -2, 45, -2)).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextFieldListScaleDelay, -2, 45, -2).addComponent(this.jLabel6)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextFieldDelayVectrex, -2, 45, -2).addComponent(this.jTextFieldListScaleIncrease, -2, 45, -2))).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jTextFieldListIntensityDelay, -2, 45, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldListIntensityIncrease, -2, 45, -2)))))));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGap(1, 1, 1).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButton3, -2, -1, -2).addComponent(this.jButtonLoad2).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jTextFieldAnimationName, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jTextFieldFrameCount, -2, -1, -2).addComponent(this.jLabel6).addComponent(this.jTextFieldDelayVectrex, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.jTextFieldListScaleStart, -2, -1, -2).addComponent(this.jTextFieldListScaleDelay, -2, -1, -2).addComponent(this.jTextFieldListScaleIncrease, -2, -1, -2)).addGap(4, 4, 4).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel9).addComponent(this.jTextFieldListIntensityFrom, -2, -1, -2).addComponent(this.jTextFieldListIntensityDelay, -2, -1, -2).addComponent(this.jTextFieldListIntensityIncrease, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldPosStartX, -2, -1, -2).addComponent(this.jLabel5)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7).addComponent(this.jTextFieldPosStartY, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldMoveScale, -2, -1, -2).addComponent(this.jLabel4)).addGap(6, 6, 6).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel8, -1, -1, Short.MAX_VALUE).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldResync, -2, -1, -2).addComponent(this.jTextFieldFactor, -2, -1, -2)).addComponent(this.jComboBoxDrawType, -2, 19, -2))).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldPosDelayX, -2, -1, -2).addComponent(this.jTextFieldPosIncreaseX, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldPosIncreaseY, -2, -1, -2).addComponent(this.jTextFieldPosDelayY, -2, -1, -2)))).addGap(6, 6, 6).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGap(2, 2, 2).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBoxGoto).addComponent(this.jLabel13)).addGap(5, 5, 5).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBoxLoop, GroupLayout.Alignment.TRAILING).addComponent(this.jLabel12))).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jTextFieldGotoValue, -2, -1, -2).addComponent(this.jCheckBoxNoAdditionalSynOptimization)).addGap(7, 7, 7).addComponent(this.jTextFieldLoopCount, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel14).addComponent(this.jTextFieldRoundCount, -2, -1, -2).addComponent(this.jCheckBoxManualRoundCount)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 7, Short.MAX_VALUE).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBoxPause).addComponent(this.jCheckBoxDisable))));
        this.jTextAreaResult.setColumns(20);
        this.jTextAreaResult.setFont(new Font("Courier New", 1, 12));
        this.jTextAreaResult.setRows(5);
        this.jScrollPane5.setViewportView(this.jTextAreaResult);
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane5, -1, 344, Short.MAX_VALUE));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane5));
        this.jButtonLoad1.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/page_go.png")));
        this.jButtonLoad1.setToolTipText("load storyboard");
        this.jButtonLoad1.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonLoad1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StoryboardPanel.this.jButtonLoad1ActionPerformed(evt);
            }
        });
        this.jButtonSave3.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/page_save.png")));
        this.jButtonSave3.setToolTipText("save storyboard");
        this.jButtonSave3.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonSave3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StoryboardPanel.this.jButtonSave3ActionPerformed(evt);
            }
        });
        this.jButtonAssemble.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/control_play_blue.png")));
        this.jButtonAssemble.setToolTipText("Assemble current file, if if project is loaded, build project");
        this.jButtonAssemble.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonAssemble.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StoryboardPanel.this.jButtonAssembleActionPerformed(evt);
            }
        });
        this.jButtonEditInVedi.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/page_edit.png")));
        this.jButtonEditInVedi.setToolTipText("edit output in vedi");
        this.jButtonEditInVedi.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonEditInVedi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StoryboardPanel.this.jButtonEditInVediActionPerformed(evt);
            }
        });
        GroupLayout jPanel5Layout = new GroupLayout(this.jPanel5);
        this.jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addComponent(this.jButtonLoad1).addGap(6, 6, 6).addComponent(this.jButtonSave3).addGap(18, 18, 18).addComponent(this.jButtonAssemble).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonEditInVedi).addGap(0, 0, Short.MAX_VALUE)));
        jPanel5Layout.setVerticalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonLoad1).addComponent(this.jButtonSave3).addComponent(this.jButtonAssemble).addComponent(this.jButtonEditInVedi));
        this.jButtonaddLane1.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/delete.png")));
        this.jButtonaddLane1.setText("delete lane");
        this.jButtonaddLane1.setMargin(new Insets(2, 2, 2, 2));
        this.jButtonaddLane1.setPreferredSize(new Dimension(93, 21));
        this.jButtonaddLane1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StoryboardPanel.this.jButtonaddLane1ActionPerformed(evt);
            }
        });
        this.jLabel15.setText("length in rounds");
        this.jTextFieldFrameCount2.setEditable(false);
        this.jTextFieldFrameCount2.setText("0");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jButtonaddLane, -2, 127, -2).addGap(35, 35, 35).addComponent(this.jButtonaddLane1, -2, 127, -2)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel15).addGap(14, 14, 14).addComponent(this.jTextFieldFrameCount2, -2, 45, -2)).addComponent(this.jPanel3, -2, -1, -2)).addGap(0, 0, 0).addComponent(this.jPanel4, -1, -1, Short.MAX_VALUE)).addComponent(this.jPanel5, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel3, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel15).addComponent(this.jTextFieldFrameCount2, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonaddLane, -2, -1, -2).addComponent(this.jButtonaddLane1, -2, -1, -2)).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.jPanel4, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -2, 275, -2).addGap(0, 0, 0).addComponent(this.jPanel5, -2, -1, -2)));
    }

    private void jButtonLoad1ActionPerformed(ActionEvent evt) {
        this.loadStoryboard();
    }

    private void jButtonSave3ActionPerformed(ActionEvent evt) {
        this.saveStoryboard();
    }

    private void jButtonEditInVediActionPerformed(ActionEvent evt) {
        this.generateSource();
        CSAMainFrame frame = Configuration.getConfiguration().getMainFrame();
        VediPanel p = new VediPanel(false);
        p.setTreeVisible(false);
        frame.addAsWindow(p, 1024, 768, VediPanel.SID);
        String tmpFile = Global.mainPathPrefix + "tmp" + File.separator + "veccyAsm.asm";
        UtilityFiles.createTextFile(tmpFile, this.jTextAreaResult.getText());
        p.addTempEditFile(tmpFile);
    }

    private void jButtonAssembleActionPerformed(ActionEvent evt) {
        this.generateSource();
        String filename = Global.mainPathPrefix + "tmp" + File.separator + "veccytmp.asm";
        UtilityFiles.createTextFile(filename, this.jTextAreaResult.getText());
        this.startASM(filename);
    }

    private void jButtonaddLaneActionPerformed(ActionEvent evt) {
        StoryboardLanePanel sb = new StoryboardLanePanel(this);
        this.lanePanel.add(sb);
        sb.setBounds(0, 80 * this.getLanes().size(), 28, 79);
        this.getLanes().add(sb);
        this.lanePanel.repaint();
        this.updateBounds();
    }

    private void jButtonLoad2ActionPerformed(ActionEvent evt) {
        this.loadAnimation();
        this.setListType("dummy");
        this.jTextFieldFrameCount.setText("" + this.getCurrentAnimation().size());
        if (this.getCurrentElement() != null) {
            this.updateToElement(false);
        }
        this.guessBlowUpFactor();
    }

    private void jTextFieldListScaleStartKeyReleased(KeyEvent evt) {
        this.updateToElement(false);
    }

    private void jTextFieldListScaleIncreaseKeyReleased(KeyEvent evt) {
        this.updateToElement(false);
    }

    private void jTextFieldListScaleDelayKeyReleased(KeyEvent evt) {
        this.updateToElement(false);
    }

    private void jTextFieldPosStartXKeyReleased(KeyEvent evt) {
        this.updateToElement(false);
    }

    private void textFieldReturn(ActionEvent evt) {
        this.updateToElement(false);
    }

    private void textfieldKeyReleased(KeyEvent evt) {
        this.updateToElement(false);
    }

    private void jTextFieldDelayVectrexActionPerformed(ActionEvent evt) {
        this.updateToElement(false);
    }

    private void jTextFieldDelayVectrexKeyReleased(KeyEvent evt) {
        this.updateToElement(false);
    }

    private void jTextFieldLoopCountActionPerformed(ActionEvent evt) {
        this.updateToElement(false);
    }

    private void jTextFieldMoveScaleActionPerformed(ActionEvent evt) {
        this.updateToElement(false);
    }

    private void jTextFieldPosDelayXActionPerformed(ActionEvent evt) {
        this.updateToElement(false);
    }

    private void jTextFieldPosDelayYActionPerformed(ActionEvent evt) {
        this.updateToElement(false);
    }

    private void jTextFieldPosStartYActionPerformed(ActionEvent evt) {
        this.updateToElement(false);
    }

    private void jTextFieldPosStartXActionPerformed(ActionEvent evt) {
        this.updateToElement(false);
    }

    private void jTextFieldPosIncreaseXActionPerformed(ActionEvent evt) {
        this.updateToElement(false);
    }

    private void jTextFieldPosIncreaseYActionPerformed(ActionEvent evt) {
        this.updateToElement(false);
    }

    private void jTextFieldListScaleIncreaseActionPerformed(ActionEvent evt) {
        this.updateToElement(false);
    }

    private void jTextFieldListScaleStartActionPerformed(ActionEvent evt) {
        this.updateToElement(false);
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
        this.deleteCurrentElement();
    }

    private void jButtonaddLane1ActionPerformed(ActionEvent evt) {
        this.deleteLane();
    }

    private void jTextFieldResyncActionPerformed(ActionEvent evt) {
        this.updateToElement(false);
    }

    private void jTextFieldResyncjTextFieldPosStartXKeyReleased(KeyEvent evt) {
        this.updateToElement(false);
    }

    private void jTextFieldFactorActionPerformed(ActionEvent evt) {
        this.updateToElement(false);
    }

    private void jTextFieldFactorjTextFieldPosStartXKeyReleased(KeyEvent evt) {
        this.updateToElement(false);
    }

    private void jTextFieldListIntensityFromActionPerformed(ActionEvent evt) {
        this.updateToElement(false);
    }

    private void jTextFieldListIntensityFromKeyReleased(KeyEvent evt) {
        this.updateToElement(false);
    }

    private void jTextFieldListIntensityDelaytextFieldReturn(ActionEvent evt) {
        this.updateToElement(false);
    }

    private void jTextFieldListIntensityDelayKeyReleased(KeyEvent evt) {
        this.updateToElement(false);
    }

    private void jTextFieldListIntensityIncreaseActionPerformed(ActionEvent evt) {
        this.updateToElement(false);
    }

    private void jTextFieldListIntensityIncreaseKeyReleased(KeyEvent evt) {
        this.updateToElement(false);
    }

    private void jCheckBoxManualRoundCountActionPerformed(ActionEvent evt) {
        this.jTextFieldRoundCount.setEnabled(this.jCheckBoxManualRoundCount.isSelected());
        this.updateToElement(false);
    }

    private void jTextFieldGotoValueActionPerformed(ActionEvent evt) {
        this.updateToElement(false);
    }

    private void jTextFieldGotoValuejTextFieldPosStartXKeyReleased(KeyEvent evt) {
        this.updateToElement(false);
    }

    private void jTextFieldRoundCountActionPerformed(ActionEvent evt) {
        this.updateToElement(false);
    }

    private void jCheckBoxGotoActionPerformed(ActionEvent evt) {
        this.jTextFieldGotoValue.setEnabled(this.jCheckBoxGoto.isSelected());
        this.updateToElement(false);
    }

    private void jCheckBoxLoopActionPerformed(ActionEvent evt) {
        this.jTextFieldLoopCount.setEnabled(this.jCheckBoxLoop.isSelected());
        this.updateToElement(false);
    }

    private void jCheckBoxPauseActionPerformed(ActionEvent evt) {
        if (this.jCheckBoxPause.isSelected()) {
            this.jCheckBoxManualRoundCount.setEnabled(true);
        }
        this.updateToElement(false);
    }

    private void jComboBoxDrawTypeActionPerformed(ActionEvent evt) {
        if (this.mClassSetting > 0) {
            return;
        }
        this.updateToElement(false);
    }

    private void jTextFieldAnimationNameActionPerformed(ActionEvent evt) {
    }

    private void jCheckBoxDisableActionPerformed(ActionEvent evt) {
        this.updateToElement(false);
    }

    @Override
    public void updateBounds() {
        int minW = this.jScrollPane1.getViewport().getBounds().width;
        int minH = this.jScrollPane1.getViewport().getBounds().height;
        int laneH = 0;
        for (StoryboardLanePanel l : this.getLanes()) {
            if (l.getBounds().width > minW) {
                minW = l.getBounds().width;
            }
            laneH += 80;
        }
        if (laneH > minH) {
            minH = laneH;
        }
        Rectangle bounds = this.lanePanel.getBounds();
        bounds.width = minW;
        bounds.height = minH;
        Dimension dim = new Dimension(minW, minH);
        this.lanePanel.setBounds(bounds);
        this.lanePanel.setPreferredSize(dim);
        this.lanePanel.setSize(dim);
        this.lanePanel.setMinimumSize(dim);
        this.repaint();
    }

    public void startASM(final String filenameASM) {
        if (this.asmStarted) {
            return;
        }
        this.asmStarted = true;
        this.jButtonAssemble.setEnabled(false);
        if (this.one != null) {
            return;
        }
        this.one = new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(10L);
                    try {
                        Asmj asm = new Asmj(filenameASM, null, null, null, null, "", null);
                        String info = asm.getInfo();
                        final boolean asmOk = info.indexOf("0 errors detected.") >= 0;
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                StoryboardPanel.this.asmResult(asmOk);
                            }
                        });
                    }
                    catch (Throwable e) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                StoryboardPanel.this.log.addLog(e, LogPanel.WARN);
                                StoryboardPanel.this.asmResult(false);
                            }
                        });
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                StoryboardPanel.this.one = null;
                StoryboardPanel.this.jButtonAssemble.setEnabled(true);
                StoryboardPanel.this.asmStarted = false;
            }
        };
        this.one.setName("Run ASMJ with: " + filenameASM);
        this.one.start();
    }

    protected void asmResult(boolean asmOk) {
        if (asmOk) {
            VecXPanel vec = ((CSAMainFrame)this.mParent).getVecxy();
            ((CSAMainFrame)this.mParent).getInternalFrame(vec).toFront();
            String fname = Global.mainPathPrefix + "tmp" + File.separator + "veccytmp.bin";
            vec.startUp(fname);
            if (this.veccy != null) {
                boolean bl;
                if (this.veccy.jCheckBoxPiTrex.isSelected()) {
                    bl = this.veccy.checkVec4EverFile(fname);
                }
                if (this.veccy.jCheckBoxVecFever.isSelected()) {
                    bl = this.veccy.checkVec4EverFile(fname);
                }
            }
            this.log.addLog("Vecci-Assembly successful...", LogPanel.INFO);
        } else {
            this.log.addLog("Vecci-Assembly not successful, see ASM output...", LogPanel.WARN);
        }
        this.jButtonAssemble.setEnabled(true);
    }

    @Override
    public void setVeccy(VeccyPanel vp) {
        this.veccy = vp;
    }

    public static void showModPanelNoModal(VeccyPanel v) {
        CSAMainFrame frame = Configuration.getConfiguration().getMainFrame();
        StoryboardPanel panel = new StoryboardPanel();
        if (v != null) {
            v.setSBPanel(panel);
            panel.veccy = v;
        }
        Configuration.getConfiguration().getMainFrame().addAsWindow(panel, 1080, 800, "Vector: Storyboard");
    }

    void updateToElement(boolean onlyAnimation) {
        if (this.mClassSetting > 0) {
            return;
        }
        this.jButtonLoad2.setEnabled(this.getCurrentElement() != null);
        this.jButton3.setEnabled(this.getCurrentElement() != null);
        if (this.getCurrentElement() == null) {
            return;
        }
        ++this.mClassSetting;
        if (!onlyAnimation) {
            this.currentElement.listScaleStart = UtilityString.Int0(this.jTextFieldListScaleStart.getText());
            this.currentElement.listScaleDelay = UtilityString.Int0(this.jTextFieldListScaleDelay.getText());
            this.currentElement.listScaleIncrease = UtilityString.Int0(this.jTextFieldListScaleIncrease.getText());
            this.currentElement.intensityStart = UtilityString.Int0(this.jTextFieldListIntensityFrom.getText());
            this.currentElement.intensityDelay = UtilityString.Int0(this.jTextFieldListIntensityDelay.getText());
            this.currentElement.intensityIncrease = UtilityString.Int0(this.jTextFieldListIntensityIncrease.getText());
            this.currentElement.positionXStart = UtilityString.Int0(this.jTextFieldPosStartX.getText());
            this.currentElement.positionYStart = UtilityString.Int0(this.jTextFieldPosStartY.getText());
            this.currentElement.positionXDelay = UtilityString.Int0(this.jTextFieldPosDelayX.getText());
            this.currentElement.positionYDelay = UtilityString.Int0(this.jTextFieldPosDelayY.getText());
            this.currentElement.positionXIncrease = UtilityString.Int0(this.jTextFieldPosIncreaseX.getText());
            this.currentElement.positionYIncrease = UtilityString.Int0(this.jTextFieldPosIncreaseY.getText());
            this.currentElement.moveScale = UtilityString.Int0(this.jTextFieldMoveScale.getText());
            this.currentElement.vectrexdelay = UtilityString.Int0(this.jTextFieldDelayVectrex.getText());
            this.currentElement.delay = this.getCurrentElement().vectrexdelay * 20;
            this.currentElement.loopCount = UtilityString.Int0(this.jTextFieldLoopCount.getText());
            this.currentElement.resyncMax = UtilityString.IntX(this.jTextFieldResync.getText(), 20);
            this.currentElement.factor = UtilityString.IntX(this.jTextFieldFactor.getText(), 1);
            this.currentElement.goto_value = UtilityString.IntX(this.jTextFieldGotoValue.getText(), 1);
            this.currentElement.disabled = this.jCheckBoxDisable.isSelected();
            this.currentElement.loop = this.jCheckBoxLoop.isSelected();
            this.currentElement._goto = this.jCheckBoxGoto.isSelected();
            this.currentElement.pause = this.jCheckBoxPause.isSelected();
            if (this.getCurrentElement().pause) {
                this.jCheckBoxManualRoundCount.setSelected(true);
            }
            if (this.getCurrentElement().vectrexdelay == 0) {
                this.currentElement.vectrexdelay = 1;
            }
            if (this.getCurrentAnimation() != null) {
                this.jTextFieldFrameCount.setText("" + this.getCurrentAnimation().size());
            }
            this.currentElement.roundCount = UtilityString.IntX(this.jTextFieldRoundCount.getText(), 20);
            this.currentElement.manualRoundCount = this.jCheckBoxManualRoundCount.isSelected();
            if (!this.currentElement.manualRoundCount) {
                this.currentElement.roundCount = 1;
                if (this.getCurrentAnimation() != null) {
                    int roundCount = this.getCurrentElement().vectrexdelay * this.getCurrentAnimation().size();
                    if (this.getCurrentElement().loop) {
                        roundCount *= this.getCurrentElement().loopCount;
                    }
                    this.currentElement.roundCount = roundCount;
                }
            }
            this.jTextFieldRoundCount.setText("" + this.getCurrentElement().roundCount);
            this.currentElement.drawType = this.getListType();
            if (this.getCurrentElement().drawType == null || this.getCurrentElement().drawType.trim().length() == 0) {
                this.currentElement.drawType = "synced";
                this.setListType("synced");
            }
            this.jLabel9.setEnabled(this.currentElement.drawType != "synced extended");
            this.jTextFieldListIntensityFrom.setEnabled(this.currentElement.drawType != "synced extended");
            this.jTextFieldListIntensityDelay.setEnabled(this.currentElement.drawType != "synced extended");
            this.jTextFieldListIntensityIncrease.setEnabled(this.currentElement.drawType != "synced extended");
            if (this.getCurrentElement().drawType == "synced extended") {
                this.currentElement.intensityIncrease = 0;
                this.jTextFieldListIntensityIncrease.setText("" + this.getCurrentElement().intensityIncrease);
                this.currentElement.intensityStart = -1;
                this.jTextFieldListIntensityFrom.setText("" + this.getCurrentElement().intensityStart);
            }
        }
        this.currentElement.listName = this.jTextFieldAnimationName.getText();
        if (this.getCurrentAnimation() != null && this.jTextFieldAnimationName.getText().trim().length() != 0 && !this.currentElement.pause) {
            this.getCurrentElement().setAnimation(this.getCurrentAnimation());
        }
        if (this.getCurrentElement().loop && !this.currentElement.manualRoundCount && this.getCurrentElement().loopCount == 0) {
            this.currentElement.roundCount = 65535;
            this.jTextFieldRoundCount.setText("" + this.getCurrentElement().roundCount);
        }
        this.getCurrentElement().setDelay(this.getCurrentElement().delay);
        this.jTextFieldRoundCount.setEnabled(this.jCheckBoxManualRoundCount.isSelected());
        this.jTextFieldLoopCount.setEnabled(this.jCheckBoxLoop.isSelected());
        this.jTextFieldGotoValue.setEnabled(this.jCheckBoxGoto.isSelected());
        this.upladeLaneData();
        --this.mClassSetting;
    }

    void clearElement(boolean isPause) {
        this.jTextFieldListScaleStart.setText("80");
        this.jTextFieldListScaleIncrease.setText("0");
        this.jTextFieldListScaleDelay.setText("0");
        this.jTextFieldListIntensityFrom.setText("127");
        this.jTextFieldListIntensityIncrease.setText("0");
        this.jTextFieldListIntensityDelay.setText("0");
        this.jTextFieldPosStartX.setText("0");
        this.jTextFieldPosStartY.setText("0");
        this.jTextFieldPosIncreaseX.setText("0");
        this.jTextFieldPosIncreaseY.setText("0");
        this.jTextFieldPosDelayX.setText("0");
        this.jTextFieldPosDelayY.setText("0");
        this.jTextFieldMoveScale.setText("80");
        this.jTextFieldDelayVectrex.setText("3");
        this.jTextFieldLoopCount.setText("0");
        this.jCheckBoxLoop.setSelected(true);
        this.jCheckBoxGoto.setSelected(false);
        this.jCheckBoxDisable.setSelected(false);
        this.jTextFieldFactor.setText("1");
        this.jTextFieldResync.setText("20");
        this.jTextFieldFrameCount.setText("0");
        this.jTextFieldAnimationName.setText("");
        this.jTextFieldGotoValue.setText("0");
        if (!isPause) {
            this.jTextFieldRoundCount.setText("0");
            this.jCheckBoxPause.setSelected(false);
        }
        ++this.mClassSetting;
        if (!isPause) {
            this.jCheckBoxManualRoundCount.setSelected(false);
            this.jTextFieldRoundCount.setEnabled(this.jCheckBoxManualRoundCount.isSelected());
        }
        this.jComboBoxDrawType.setModel(new DefaultComboBoxModel<String>(new String[]{""}));
        this.jComboBoxDrawType.setSelectedIndex(-1);
        this.jTextFieldLoopCount.setEnabled(this.jCheckBoxLoop.isSelected());
        this.jTextFieldGotoValue.setEnabled(this.jCheckBoxGoto.isSelected());
        --this.mClassSetting;
        this.upladeLaneData();
    }

    @Override
    public void setElement(StoryboardElement element, StoryboardLanePanel lane) {
        if (this.getCurrentLane() != null) {
            this.getCurrentLane().setLaneSelected(false);
        }
        this.setCurrentLane(lane);
        if (this.getCurrentLane() == null) {
            this.clearElement(false);
            return;
        }
        this.getCurrentLane().setLaneSelected(true);
        if (this.getCurrentElement() != null) {
            this.getCurrentElement().setElementSelected(false);
        }
        this.setCurrentElement(element);
        this.jButtonLoad2.setEnabled(this.getCurrentElement() != null);
        this.jButton3.setEnabled(this.getCurrentElement() != null);
        if (this.getCurrentElement() == null) {
            this.clearElement(false);
            return;
        }
        this.getCurrentElement().setElementSelected(true);
        this.jCheckBoxPause.setSelected(this.getCurrentElement().pause);
        if (this.getCurrentElement().pause) {
            element.manualRoundCount = true;
        }
        this.jCheckBoxManualRoundCount.setSelected(element.manualRoundCount);
        this.jTextFieldRoundCount.setText("" + element.roundCount);
        if (!this.currentElement.pause && !this.setAnimationFromElement(this.currentElement)) {
            this.clearElement(this.getCurrentElement().pause);
            return;
        }
        this.jTextFieldAnimationName.setText(element.listName);
        this.jTextFieldFrameCount.setText("" + this.getCurrentAnimation().size());
        this.jTextFieldListScaleStart.setText("" + element.listScaleStart);
        this.jTextFieldListScaleIncrease.setText("" + element.listScaleIncrease);
        this.jTextFieldListScaleDelay.setText("" + element.listScaleDelay);
        this.jTextFieldListIntensityFrom.setText("" + element.intensityStart);
        this.jTextFieldListIntensityIncrease.setText("" + element.intensityIncrease);
        this.jTextFieldListIntensityDelay.setText("" + element.intensityDelay);
        this.jTextFieldPosStartX.setText("" + element.positionXStart);
        this.jTextFieldPosStartY.setText("" + element.positionYStart);
        this.jTextFieldPosIncreaseX.setText("" + element.positionXIncrease);
        this.jTextFieldPosIncreaseY.setText("" + element.positionYIncrease);
        this.jCheckBoxDisable.setSelected(element.disabled);
        this.jTextFieldPosDelayX.setText("" + element.positionXDelay);
        this.jTextFieldPosDelayY.setText("" + element.positionYDelay);
        this.jTextFieldMoveScale.setText("" + element.moveScale);
        if (element.vectrexdelay == 0) {
            element.vectrexdelay = 1;
        }
        this.jTextFieldDelayVectrex.setText("" + element.vectrexdelay);
        this.currentElement.delay = this.getCurrentElement().vectrexdelay * 20;
        this.currentElement.goto_value = UtilityString.IntX(this.jTextFieldGotoValue.getText(), 1);
        this.jTextFieldLoopCount.setText("" + element.loopCount);
        this.jTextFieldResync.setText("" + element.resyncMax);
        this.jTextFieldFactor.setText("" + element.factor);
        this.jCheckBoxLoop.setSelected(element.loop);
        this.jCheckBoxGoto.setSelected(element._goto);
        if (!element.manualRoundCount) {
            element.roundCount = 1;
            if (this.getCurrentAnimation() != null) {
                int roundCount = element.vectrexdelay * this.getCurrentAnimation().size();
                if (element.loop) {
                    roundCount *= element.loopCount;
                }
                element.roundCount = roundCount;
            }
        }
        this.jTextFieldRoundCount.setText("" + element.roundCount);
        this.setListType(element.drawType);
        this.jTextFieldRoundCount.setEnabled(this.jCheckBoxManualRoundCount.isSelected());
        this.jTextFieldLoopCount.setEnabled(this.jCheckBoxLoop.isSelected());
        this.jTextFieldGotoValue.setEnabled(this.jCheckBoxGoto.isSelected());
        if (this.getCurrentElement().loop && !this.currentElement.manualRoundCount && this.getCurrentElement().loopCount == 0) {
            this.currentElement.roundCount = 65535;
            this.jTextFieldRoundCount.setText("" + this.getCurrentElement().roundCount);
        }
        this.upladeLaneData();
    }

    boolean loadAnimationFromElement(String loadName) {
        if (this.getCurrentElement() == null) {
            return false;
        }
        boolean ok = false;
        if (loadName == null) {
            this.clearElement(false);
            return false;
        }
        if (loadName.trim().length() == 0) {
            this.clearElement(false);
            return false;
        }
        if (loadName != null) {
            if (!loadName.toUpperCase().endsWith(".XML")) {
                loadName = loadName + ".xml";
            }
            this.setCurrentAnimation(new GFXVectorAnimation());
            ok = this.getCurrentAnimation().loadFromXML(loadName);
            if (ok) {
                if (this.getCurrentAnimation().size() > 0) {
                    this.updateToElement(true);
                } else {
                    this.clearElement(false);
                    return false;
                }
            }
        }
        loadName = Utility.makeVideRelative(loadName);
        this.jTextFieldAnimationName.setText(loadName);
        this.currentElement.listName = loadName;
        this.upladeLaneData();
        return ok;
    }

    boolean setAnimationFromElement(StoryboardElement element) {
        if (element == null) {
            return false;
        }
        boolean ok = false;
        if (!element.pause) {
            String loadName = element.listName;
            this.setCurrentAnimation(element.getAnimation());
            if (this.getCurrentAnimation() == null) {
                this.clearElement(false);
                return false;
            }
            if (this.getCurrentAnimation().size() <= 0) {
                this.clearElement(false);
                return false;
            }
            this.updateToElement(true);
            this.currentElement.listName = loadName;
        }
        this.upladeLaneData();
        return true;
    }

    boolean loadAnimation() {
        boolean ok = false;
        String filename = Global.mainPathPrefix + "xml" + File.separator + "vectoranimation";
        InternalFrameFileChoser fc = new InternalFrameFileChoser();
        fc.setCurrentDirectory(new File(filename));
        int r = fc.showOpenDialog(Configuration.getConfiguration().getMainFrame());
        if (r != 0) {
            return false;
        }
        String name = fc.getSelectedFile().getAbsolutePath();
        return this.loadAnimationFromElement(name);
    }

    private void setListType(String type) {
        ++this.mClassSetting;
        if (this.getCurrentElement() == null || this.getCurrentAnimation() == null) {
            this.jComboBoxDrawType.setModel(new DefaultComboBoxModel<String>(new String[]{""}));
            this.jComboBoxDrawType.setSelectedIndex(-1);
            --this.mClassSetting;
            return;
        }
        ArrayList<String> types = new ArrayList<String>();
        boolean Mov_Draw_VLc_a = true;
        boolean Draw_VLc = this.getCurrentAnimation().isAnimation;
        boolean Draw_VLp = this.getCurrentAnimation().isAnimation;
        boolean Draw_VL_mode = true;
        boolean AnimCodeGen = true;
        boolean allSamePattern = this.getCurrentAnimation().isAllSamePattern();
        boolean allContinuous = this.getCurrentAnimation().isCompleteRelative();
        boolean allHighPattern = this.getCurrentAnimation().isAllPatternHigh(false);
        boolean allHighPattern0 = this.getCurrentAnimation().isAllPatternHigh(true);
        if (!allSamePattern) {
            Draw_VLc = false;
        }
        if (!allHighPattern0) {
            Draw_VLp = false;
        }
        if (!allContinuous) {
            Mov_Draw_VLc_a = false;
            Draw_VLc = false;
            Draw_VLp = false;
            Draw_VL_mode = false;
            AnimCodeGen = false;
        }
        types.add("synced");
        types.add("synced extended");
        int index = -1;
        int count = 0;
        for (String s : types) {
            if (s.equals(type)) {
                index = count;
                break;
            }
            ++count;
        }
        this.jComboBoxDrawType.setModel(new DefaultComboBoxModel<String>(types.toArray(new String[0])));
        this.jComboBoxDrawType.setSelectedIndex(index);
        --this.mClassSetting;
    }

    private String getListType() {
        if (this.jComboBoxDrawType.getSelectedIndex() == -1) {
            return "";
        }
        if (this.jComboBoxDrawType.getSelectedItem() == null) {
            return "";
        }
        return this.jComboBoxDrawType.getSelectedItem().toString();
    }

    boolean loadStoryboard() {
        String filename = Global.mainPathPrefix + "xml" + File.separator + "storyboard";
        InternalFrameFileChoser fc = new InternalFrameFileChoser();
        fc.setCurrentDirectory(new File(filename));
        int r = fc.showOpenDialog(Configuration.getConfiguration().getMainFrame());
        if (r != 0) {
            return false;
        }
        String loadName = fc.getSelectedFile().getAbsolutePath();
        boolean ok = false;
        if (loadName != null) {
            this.clearLanes();
            if (!loadName.toUpperCase().endsWith(".XML")) {
                loadName = loadName + ".xml";
            }
            ok = this.loadFromXML(loadName);
        }
        return ok;
    }

    boolean saveStoryboard() {
        String filename = Global.mainPathPrefix + "xml" + File.separator + "storyboard";
        InternalFrameFileChoser fc = new InternalFrameFileChoser();
        fc.setCurrentDirectory(new File(filename));
        int r = fc.showOpenDialog(Configuration.getConfiguration().getMainFrame());
        if (r != 0) {
            return false;
        }
        String saveName = fc.getSelectedFile().getAbsolutePath();
        if (saveName != null) {
            if (!saveName.toUpperCase().endsWith(".XML")) {
                saveName = saveName + ".xml";
            }
            return this.saveAsXML(saveName);
        }
        return false;
    }

    public boolean loadFromXML(String filename) {
        String xml = UtilityString.readTextFileToOneString(new File(filename));
        boolean ok = this.fromXML(xml, new XMLSupport());
        if (!ok) {
            this.log.addLog("Storyboard load from xml '" + filename + "' return false", LogPanel.WARN);
            return false;
        }
        return true;
    }

    public boolean saveAsXML(String filename) {
        StringBuilder xml = new StringBuilder();
        boolean ok = this.toXML(xml, "Storyboard");
        if (!ok) {
            this.log.addLog("Storyboard save 'toXML' return false", LogPanel.WARN);
            return false;
        }
        ok = UtilityFiles.createTextFile(filename, xml.toString());
        if (!ok) {
            this.log.addLog("Storyboard create file '" + filename + "' return false", LogPanel.WARN);
            return false;
        }
        return true;
    }

    public boolean toXML(StringBuilder s, String tag) {
        s.append("<").append(tag).append(">\n");
        boolean ok = true;
        ok &= XMLSupport.addElement(s, "noAdditionalStoryboardOptimization", this.jCheckBoxNoAdditionalSynOptimization.isSelected());
        for (StoryboardLanePanel l : this.getLanes()) {
            ok &= l.toXML(s, "SBLane");
        }
        s.append("</").append(tag).append(">\n");
        return ok;
    }

    public boolean fromXML(String xml, XMLSupport xmlSupport) {
        this.setLanes(new ArrayList<StoryboardLanePanel>());
        int errorCode = 0;
        StringBuilder xmlBuffer = new StringBuilder(xml);
        StringBuilder oneElement = null;
        this.jCheckBoxNoAdditionalSynOptimization.setSelected(xmlSupport.getBooleanElement("noAdditionalStoryboardOptimization", xmlBuffer));
        errorCode |= xmlSupport.errorCode;
        while ((oneElement = xmlSupport.removeTag("SBLane", xmlBuffer)) != null) {
            errorCode |= xmlSupport.errorCode;
            StoryboardLanePanel sb = new StoryboardLanePanel(this);
            sb.fromXML(oneElement, xmlSupport);
            errorCode |= xmlSupport.errorCode;
            if (!sb.isVersion1()) {
                this.log.addLog("Wrong storyboard version - not loaded", LogPanel.WARN);
                this.setLanes(new ArrayList<StoryboardLanePanel>());
                this.upladeLaneData();
                this.updateBounds();
                return false;
            }
            this.lanePanel.add(sb);
            sb.setBounds(0, 0 + 80 * this.getLanes().size(), sb.getBounds().width, 79);
            this.getLanes().add(sb);
            this.lanePanel.repaint();
        }
        this.upladeLaneData();
        this.updateBounds();
        return errorCode == 0;
    }

    void clearLanes() {
        for (int i = this.lanePanel.getComponentCount() - 1; i >= 0; --i) {
            Component c = this.lanePanel.getComponent(i);
            if (!(c instanceof StoryboardLanePanel)) continue;
            this.lanePanel.remove(c);
        }
        this.setCurrentElement(null);
        this.setCurrentLane(null);
        this.upladeLaneData();
        this.repaint();
    }

    void deleteCurrentElement() {
        if (this.getCurrentElement() == null) {
            return;
        }
        if (this.getCurrentLane() == null) {
            return;
        }
        this.getCurrentLane().removeElement(this.getCurrentElement());
        this.upladeLaneData();
    }

    void deleteLane() {
        if (this.getCurrentLane() == null) {
            return;
        }
        this.lanePanel.remove(this.getCurrentLane());
        this.getLanes().remove(this.getCurrentLane());
        this.setCurrentLane(null);
        this.setCurrentElement(null);
        this.reorder();
        this.upladeLaneData();
        this.lanePanel.repaint();
    }

    void reorder() {
        int count = 0;
        for (int i = 0; i < this.lanePanel.getComponentCount(); ++i) {
            Component c = this.lanePanel.getComponent(i);
            if (!(c instanceof StoryboardLanePanel)) continue;
            StoryboardLanePanel sb = (StoryboardLanePanel)c;
            sb.setBounds(0, 0 + 80 * count, sb.getBounds().width, 79);
            ++count;
        }
        this.updateBounds();
        this.repaint();
    }

    void guessBlowUpFactor() {
        int factor;
        if (this.getCurrentAnimation() == null) {
            return;
        }
        if (this.getCurrentElement() == null) {
            return;
        }
        int maxLen = (int)this.getCurrentAnimation().getMaxAbsLenValue();
        if (maxLen == 0) {
            this.currentElement.factor = 1;
            this.jTextFieldFactor.setText("" + this.getCurrentElement().factor);
            return;
        }
        this.currentElement.factor = factor = 127 / maxLen;
        this.jTextFieldFactor.setText("" + this.getCurrentElement().factor);
    }

    private void generateSource() {
        StringBuilder text = new StringBuilder();
        HashMap<String, String> noDoubleAnimMap = new HashMap<String, String>();
        ArrayList<String> animData = new ArrayList<String>();
        HashMap<String, String> noDoubleRoutineMap = new HashMap<String, String>();
        ArrayList<String> routineData = new ArrayList<String>();
        ArrayList<String> laneInit = new ArrayList<String>();
        ArrayList<String> laneData = new ArrayList<String>();
        for (StoryboardLanePanel storyboardLanePanel : this.getLanes()) {
            storyboardLanePanel.getAnimData(animData, noDoubleAnimMap);
            storyboardLanePanel.getDrawRoutines(routineData, noDoubleRoutineMap);
            storyboardLanePanel.getLaneData(laneData, noDoubleAnimMap);
            storyboardLanePanel.getLaneInit(laneInit);
        }
        StringBuilder laneInitString = new StringBuilder();
        for (String li : laneInit) {
            laneInitString.append(li);
        }
        Path path = Paths.get(Global.mainPathPrefix, "template", "storyboardDefines.template");
        String defines = UtilityString.readTextFileToOneString(new File(path.toString()));
        Path path2 = Paths.get(Global.mainPathPrefix, "template", "storyboardMain.template");
        String main = UtilityString.readTextFileToOneString(new File(path2.toString()));
        main = UtilityString.replace(main, ";INSERT LANE INIT CODE", laneInitString.toString());
        Path path3 = Paths.get(Global.mainPathPrefix, "template", "storyboardRoutines.template");
        String lane_subroutines = UtilityString.readTextFileToOneString(new File(path3.toString()));
        Path path4 = Paths.get(Global.mainPathPrefix, "template", "storyboardRAM.template");
        String ram = UtilityString.readTextFileToOneString(new File(path4.toString()));
        ram = UtilityString.replace(ram, "#LANE_COUNT#", "" + this.getLanes().size());
        text.append(ram);
        text.append(defines);
        text.append(main);
        text.append(lane_subroutines);
        for (String routine : routineData) {
            text.append(routine);
        }
        for (String lc : laneData) {
            text.append(lc);
        }
        for (String anim : animData) {
            text.append(anim);
        }
        this.jTextAreaResult.setText(UtilityString.replace(text.toString(), "#_UNIQUE_ID#", ""));
    }

    void upladeLaneData() {
        if (this.getCurrentLane() != null) {
            this.jTextFieldFrameCount2.setText("" + this.getCurrentLane().getLengthInRound());
        } else {
            this.jTextFieldFrameCount2.setText("0");
        }
    }

    @Override
    public boolean isNoAdditionalSyncOptimization() {
        return this.jCheckBoxNoAdditionalSynOptimization.isSelected();
    }

    @Override
    public int getVersion() {
        return 1;
    }

    @Override
    public void deIconified() {
    }
}

