/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.veccy;

import de.malban.config.Configuration;
import de.malban.graphics.GFXVector;
import de.malban.graphics.GFXVectorAnimation;
import de.malban.graphics.GFXVectorList;
import de.malban.gui.panels.LogPanel;
import de.malban.util.UtilityString;
import de.malban.vide.assy.Comment;
import de.malban.vide.veccy.VeccyPanel;
import java.util.ArrayList;

public class VeccyInterpreter {
    LogPanel log = (LogPanel)Configuration.getConfiguration().getDebugEntity();
    String line1Pattern = "";
    String lineXPattern = "";
    String lastLinePattern = "";
    String[] patternLine1 = new String[0];
    String[] patternLineX = new String[0];
    String[] patternLineLast = new String[0];
    ArrayList<String> removers = new ArrayList();
    String representation = "";
    ArrayList<Byte> dataInterpreted = new ArrayList();
    String textOrg = "";

    public ArrayList<Byte> setData(String text) {
        String[] splits;
        String orgText;
        ArrayList<Byte> data2 = this.dataInterpreted;
        text = UtilityString.replace(text, "\r\n", "\n");
        String[] textSplits = text.split("\n");
        StringBuilder newText = new StringBuilder();
        for (String s : textSplits) {
            if (s.trim().startsWith("*")) continue;
            s = Comment.removeEndOfLineComment(s);
            s = Comment.removeCEndOfLineComment(s);
            if ((s = Comment.removeC1EndOfLineComment(s)).trim().length() == 0) continue;
            newText.append(s + "\n");
        }
        text = newText.toString().toUpperCase();
        for (String remove : this.removers) {
            text = UtilityString.replace(text, remove, " ");
        }
        text = UtilityString.replaceWhiteSpaces(text.toUpperCase(), " ");
        text = UtilityString.replace(text, ";", " ");
        text = UtilityString.replace(text, ",", " ");
        text = UtilityString.replace(text, ":", " ");
        text = UtilityString.replace(text, "*", " ");
        text = UtilityString.replace(text, "/", " ");
        text = UtilityString.replace(text, "(", " ");
        text = UtilityString.replace(text, ")", " ");
        text = UtilityString.replace(text, "{", " ");
        text = UtilityString.replace(text, "}", " ");
        text = UtilityString.replace(text, "[", " ");
        text = UtilityString.replace(text, "]", " ");
        text = UtilityString.replace(text, "<", " ");
        text = UtilityString.replace(text, ">", " ");
        while (!(orgText = text).equals(text = UtilityString.replace(text, "  ", " "))) {
        }
        text = UtilityString.replace(text, "- ", "-");
        text = UtilityString.replace(text, "+ ", "+");
        for (String s : splits = text.split(" ")) {
            int number = VeccyInterpreter.toNumber(s.trim());
            if (number == Integer.MAX_VALUE) continue;
            if (number < -128 || number > 255) {
                data2.add((byte)(number >> 8 & 0xFF));
                data2.add((byte)(number & 0xFF));
                continue;
            }
            data2.add((byte)(number & 0xFF));
        }
        return data2;
    }

    public void setPatterns(String l1, String lx, String ll) {
        String l1Org = l1;
        l1 = UtilityString.replaceWhiteSpaces(l1.toUpperCase(), " ");
        l1 = UtilityString.replace(l1, ",", "");
        l1 = UtilityString.replace(l1, ";", "");
        l1 = UtilityString.replace(l1, ":", "");
        l1 = UtilityString.replace(l1, " ", "");
        lx = UtilityString.replaceWhiteSpaces(lx.toUpperCase(), " ");
        lx = UtilityString.replace(lx, ",", "");
        lx = UtilityString.replace(lx, ";", "");
        lx = UtilityString.replace(lx, ":", "");
        lx = UtilityString.replace(lx, " ", "");
        ll = UtilityString.replaceWhiteSpaces(ll.toUpperCase(), " ");
        ll = UtilityString.replace(ll, ",", "");
        ll = UtilityString.replace(ll, ";", "");
        ll = UtilityString.replace(ll, ":", "");
        ll = UtilityString.replace(ll, " ", "");
        this.line1Pattern = l1;
        this.lineXPattern = lx;
        this.lastLinePattern = ll;
        this.patternLineX = this.removeEmpty(this.lineXPattern.split("%"));
        this.patternLine1 = this.removeEmpty(this.line1Pattern.split("%"));
        this.patternLineLast = this.removeEmpty(this.lastLinePattern.split("%"));
        ArrayList<String> ss = new ArrayList<String>();
        for (int i = 0; i < this.patternLine1.length; ++i) {
            String s = this.patternLine1[i];
            if (s.startsWith("R\"")) {
                s = s.substring(2, s.length() - 1);
                continue;
            }
            ss.add(s);
        }
        this.patternLine1 = ss.toArray(new String[0]);
        this.removers.clear();
        l1Org = UtilityString.replace(l1Org, "%r\"", "%R\"");
        String[] removersSplit = l1Org.toUpperCase().split("%R\"");
        if (removersSplit.length > 1) {
            for (String toRemove : removersSplit) {
                String remove = toRemove;
                if (remove.length() == 0) continue;
                remove = remove.substring(0, remove.length() - 1);
                this.removers.add(remove);
            }
        }
        if (this.textOrg.length() != 0) {
            this.setData(this.textOrg);
        }
    }

    String[] removeEmpty(String[] s) {
        ArrayList<String> ss = new ArrayList<String>();
        for (String _s : s) {
            if (_s.trim().length() == 0) continue;
            ss.add(_s);
        }
        return ss.toArray(new String[0]);
    }

    public static int toNumber(String s) {
        s = s.toUpperCase();
        boolean minus = false;
        int radix = 10;
        int result = 0;
        if (s.startsWith("-")) {
            minus = true;
            s = s.substring(1);
        }
        if (s.startsWith("+")) {
            s = s.substring(1);
        }
        if (s.startsWith("$")) {
            radix = 16;
            s = s.substring(1);
        }
        if (s.startsWith("0X")) {
            s = s.substring(2);
            radix = 16;
        }
        try {
            result = Integer.parseInt(s, radix);
            if (minus) {
                result *= -1;
            }
        }
        catch (Throwable ex) {
            return Integer.MAX_VALUE;
        }
        return result;
    }

    public GFXVectorList getVectorList(IntegerPointer startPos) {
        ArrayList<Byte> data2 = this.dataInterpreted;
        StringBuilder s = new StringBuilder();
        int pos = startPos.pos;
        GFXVectorList vl = new GFXVectorList();
        int count = -1;
        if (data2.size() == 0) {
            return vl;
        }
        if (pos >= data2.size()) {
            return vl;
        }
        for (String p : this.patternLine1) {
            GFXVector v;
            if (pos >= data2.size()) {
                s.append("end of data encountered line 1");
                this.representation = s.toString();
                startPos.pos = pos;
                return vl;
            }
            if (p.equals("C0")) {
                count = data2.get(pos++).byteValue();
                s.append(this.hex(count));
            } else if (p.equals("C+")) {
                count = data2.get(pos++) + 1;
                s.append(this.hex(count));
            } else if (p.equals("C-")) {
                count = data2.get(pos++) - 1;
                s.append(this.hex(count));
            } else if (p.equals("I")) {
                ++pos;
            } else if (p.equals("Y")) {
                v = vl.size() == 0 ? new GFXVector() : vl.get(0);
                v.pattern = 0;
                s.append(this.hex(data2.get(pos).byteValue()));
                int yval = data2.get(pos++) & 0xFF;
                if (yval > 127) {
                    yval -= 256;
                }
                v.end.y(yval);
                vl.remove(v);
                vl.add(v);
            } else if (p.equals("X")) {
                v = vl.size() == 0 ? new GFXVector() : vl.get(0);
                v.pattern = 0;
                s.append(this.hex(data2.get(pos).byteValue()));
                int xval = data2.get(pos++) & 0xFF;
                if (xval > 127) {
                    xval -= 256;
                }
                v.end.x(xval);
                vl.remove(v);
                vl.add(v);
            }
            s.append(" ");
        }
        if (this.patternLine1.length > 0 && s.length() > 0) {
            s.append("\n");
        }
        boolean syncMode = false;
        byte lastAbsX = 0;
        byte lastAbsY = 0;
        byte saveLastAbsY = 0;
        byte saveLastAbsX = 0;
        boolean startingX = true;
        boolean startingY = true;
        int hasNextPattern = 0;
        int nextPattern = 255;
        do {
            boolean breaking = false;
            boolean relative = false;
            boolean finished = false;
            boolean dontAdd = false;
            GFXVector v = new GFXVector();
            if (hasNextPattern == 2) {
                v.pattern = nextPattern;
            }
            hasNextPattern = 0;
            for (String p : this.patternLineX) {
                int xval;
                int yval;
                if (pos >= data2.size()) {
                    breaking = true;
                    break;
                }
                if (pos >= data2.size()) {
                    s.append("end of data encountered line x");
                    this.representation = s.toString();
                    startPos.pos = pos;
                    return vl;
                }
                if (vl.size() != 0 && p.equals(this.patternLineX[0])) {
                    int b = data2.get(pos).byteValue();
                    if (this.lastLinePattern.contains("%0") && (b &= 0xFF) == 0) {
                        finished = true;
                    }
                    if (this.lastLinePattern.contains("%1") && b == 1) {
                        finished = true;
                    }
                    if (this.lastLinePattern.contains("%-") && b >= 128) {
                        finished = true;
                    }
                    if (this.lastLinePattern.contains("%+") && b < 128 && b > 0) {
                        finished = true;
                    }
                    if (this.lastLinePattern.contains("%2") && b == 2) {
                        finished = true;
                    }
                    if (finished) {
                        s.append(this.hex(b) + "\n");
                        break;
                    }
                }
                if (p.equals("Y")) {
                    relative = true;
                    s.append(this.hex(data2.get(pos).byteValue()));
                    yval = data2.get(pos++) & 0xFF;
                    if (yval > 127) {
                        yval -= 256;
                    }
                    v.end.y(yval);
                } else if (p.equals("X")) {
                    relative = true;
                    s.append(this.hex(data2.get(pos).byteValue()));
                    xval = data2.get(pos++) & 0xFF;
                    if (xval > 127) {
                        xval -= 256;
                    }
                    v.end.x(xval);
                } else if (p.equals("CX-")) {
                    if (startingX) {
                        startingX = false;
                        s.append(this.hex(data2.get(pos).byteValue()) + " ");
                        lastAbsX = data2.get(pos++);
                        dontAdd = true;
                        continue;
                    }
                    s.append(this.hex(data2.get(pos).byteValue()));
                    if (data2.get(pos) == -127) {
                        ++hasNextPattern;
                        nextPattern = 0;
                        saveLastAbsX = lastAbsX;
                    }
                    v.start.x(lastAbsX);
                    lastAbsX = data2.get(pos++);
                    v.end.x(lastAbsX);
                } else if (p.equals("CY-")) {
                    if (startingY) {
                        startingY = false;
                        s.append(this.hex(data2.get(pos).byteValue()));
                        lastAbsY = data2.get(pos++);
                        dontAdd = true;
                        continue;
                    }
                    if (data2.get(pos) == -127) {
                        ++hasNextPattern;
                        nextPattern = 0;
                        saveLastAbsY = lastAbsY;
                    }
                    s.append(this.hex(data2.get(pos).byteValue()));
                    v.start.y(lastAbsY);
                    lastAbsY = data2.get(pos++);
                    v.end.y(lastAbsY);
                } else if (p.equals("CX1")) {
                    if (startingX) {
                        startingX = false;
                        s.append(this.hex(data2.get(pos).byteValue()) + " ");
                        lastAbsX = data2.get(pos++);
                        dontAdd = true;
                        continue;
                    }
                    s.append(this.hex(data2.get(pos).byteValue()));
                    if (data2.get(pos) == -1) {
                        ++hasNextPattern;
                        nextPattern = 0;
                        saveLastAbsX = lastAbsX;
                    }
                    v.start.x(lastAbsX);
                    lastAbsX = data2.get(pos++);
                    v.end.x(lastAbsX);
                } else if (p.equals("CY1")) {
                    if (startingY) {
                        startingY = false;
                        s.append(this.hex(data2.get(pos).byteValue()));
                        lastAbsY = data2.get(pos++);
                        dontAdd = true;
                        continue;
                    }
                    if (data2.get(pos) == -1) {
                        ++hasNextPattern;
                        nextPattern = 0;
                        saveLastAbsY = lastAbsY;
                    }
                    s.append(this.hex(data2.get(pos).byteValue()));
                    v.start.y(lastAbsY);
                    lastAbsY = data2.get(pos++);
                    v.end.y(lastAbsY);
                } else if (p.equals("SY")) {
                    if (!syncMode) {
                        relative = true;
                        s.append(this.hex(data2.get(pos).byteValue()));
                        yval = data2.get(pos++) & 0xFF;
                        if (yval > 127) {
                            yval -= 256;
                        }
                        v.end.y(yval);
                    } else {
                        s.append(this.hex(data2.get(pos).byteValue()));
                        v.end.y(data2.get(pos++).byteValue());
                    }
                } else if (p.equals("SX")) {
                    if (!syncMode) {
                        relative = true;
                        s.append(this.hex(data2.get(pos).byteValue()));
                        xval = data2.get(pos++) & 0xFF;
                        if (xval > 127) {
                            xval -= 256;
                        }
                        v.end.x(xval);
                    } else {
                        s.append(this.hex(data2.get(pos).byteValue()));
                        v.end.x(data2.get(pos++).byteValue());
                    }
                } else if (p.equals("Y0")) {
                    s.append(this.hex(data2.get(pos).byteValue()));
                    v.start.y(data2.get(pos++).byteValue());
                } else if (p.equals("X0")) {
                    s.append(this.hex(data2.get(pos).byteValue()));
                    v.start.x(data2.get(pos++).byteValue());
                } else if (p.equals("Y1")) {
                    s.append(this.hex(data2.get(pos).byteValue()));
                    v.end.y(data2.get(pos++).byteValue());
                } else if (p.equals("X1")) {
                    s.append(this.hex(data2.get(pos).byteValue()));
                    v.end.x(data2.get(pos++).byteValue());
                } else if (p.equals("P")) {
                    s.append(this.hex(data2.get(pos).byteValue()));
                    v.pattern = data2.get(pos++) & 0xFF;
                } else if (p.equals("B")) {
                    s.append(this.hex(data2.get(pos).byteValue()));
                    v.intensity = data2.get(pos++) & 0xFF;
                } else if (p.equals("I")) {
                    ++pos;
                } else if (p.equals("M")) {
                    int mode = data2.get(pos++) & 0xFF;
                    s.append(this.hex(mode));
                    if (mode == 0) {
                        v.pattern = 0;
                    } else if (mode > 1) {
                        v.pattern = 255;
                    } else if (mode < 0) {
                        v.pattern = 170;
                    } else if (mode == 1) {
                        finished = true;
                        s.append("\n");
                        break;
                    }
                } else if (p.equals("S")) {
                    int sPattern;
                    if ((sPattern = data2.get(pos++) & 0xFF) != 1) {
                        s.append(this.hex(sPattern));
                        v.pattern = sPattern;
                        syncMode = false;
                    } else {
                        syncMode = true;
                        s.append(this.hex(sPattern) + " ");
                        v.pattern = 0;
                        s.append(this.hex(0) + " ");
                        v.start.y(0.0);
                        s.append(this.hex(0));
                        v.start.x(0.0);
                    }
                }
                s.append(" ");
            }
            s.append("\n");
            if (finished) break;
            if (breaking) {
                this.log.addLog("Vector interpreter, input out of data!", LogPanel.WARN);
                break;
            }
            if (relative && vl.size() != 0) {
                v.setRelativ(relative);
                v.start = vl.get((int)(vl.size() - 1)).end;
                v.start_connect = vl.get(vl.size() - 1);
                v.uid_start_connect = vl.get((int)(vl.size() - 1)).uid;
                vl.get((int)(vl.size() - 1)).end_connect = v;
                vl.get((int)(vl.size() - 1)).uid_end_connect = v.uid;
                v.end.x(v.end.x() + v.start.x());
                v.end.y(v.end.y() + v.start.y());
            }
            if (hasNextPattern == 2) {
                lastAbsY = saveLastAbsY;
                lastAbsX = saveLastAbsX;
                dontAdd = true;
            }
            if (!dontAdd) {
                vl.add(v);
                continue;
            }
            dontAdd = false;
        } while (--count != -1 && pos < data2.size());
        this.representation = s.toString();
        startPos.pos = pos;
        return vl;
    }

    public GFXVectorList getVectorList() {
        IntegerPointer pos = new IntegerPointer();
        pos.pos = 0;
        return this.getVectorList(pos);
    }

    public GFXVectorAnimation getVectorAnimation() {
        GFXVectorAnimation al = new GFXVectorAnimation();
        IntegerPointer pos = new IntegerPointer();
        pos.pos = 0;
        int oldPos = -1;
        String allIntRep = "";
        while (oldPos != pos.pos) {
            oldPos = pos.pos;
            GFXVectorList vl = this.getVectorList(pos);
            if (oldPos == pos.pos) continue;
            al.list.add(vl);
            if (allIntRep.length() != 0) {
                allIntRep = allIntRep + ";;;; \n";
            }
            allIntRep = allIntRep + this.representation;
        }
        this.representation = allIntRep;
        return al;
    }

    public String toString() {
        return this.representation;
    }

    String hex(int b) {
        String s = "";
        int idata = b;
        if ((idata &= 0xFF) >= 128) {
            idata -= 256;
            idata *= -1;
            s = s + "-";
        } else {
            s = s + "+";
        }
        s = s + "$";
        s = s + String.format("%02X", idata);
        return s;
    }

    public static VeccyPanel.PatternInfo buildPatternInfo(String comment) {
        if (!comment.toUpperCase().contains("VLIST")) {
            return null;
        }
        if (!comment.toUpperCase().contains("0:")) {
            return null;
        }
        if (!comment.toUpperCase().contains("1:")) {
            return null;
        }
        if (!comment.toUpperCase().contains("2:")) {
            return null;
        }
        String p0 = comment.substring(comment.indexOf("0:2"));
        String p1 = comment.substring(comment.indexOf("1:2"));
        String p2 = comment.substring(comment.indexOf("2:2"));
        p0 = p0.substring(0, comment.indexOf("1:2")).trim();
        p1 = p1.substring(0, comment.indexOf("2:2")).trim();
        p2 = p2.trim();
        VeccyPanel.PatternInfo pattern = new VeccyPanel.PatternInfo();
        pattern.name = "noName";
        pattern.line1Pattern = p0;
        pattern.lineXPattern = p1;
        pattern.lastLinePattern = p2;
        return pattern;
    }

    class IntegerPointer {
        int pos;

        IntegerPointer() {
        }
    }
}

