/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.veccy;

import de.malban.Global;
import de.malban.graphics.GFXVector;
import de.malban.graphics.GFXVectorList;
import de.malban.vide.vecx.E6809;
import de.malban.vide.vecx.VecX;
import de.malban.vide.vecx.cartridge.Cartridge;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;

public class VectorListScanner {
    public static final int THRESHOLD = 3;
    static ArrayList<ScanEntry> listsFound = new ArrayList();
    static HashMap<String, Boolean> scanDone = new HashMap();
    public static final int NONE = 0;
    public static final int Draw_Pat_VL = 1;
    public static final int Draw_VL = 2;
    public static final int Draw_VL_a = 3;
    public static final int Draw_VL_ab = 4;
    public static final int Draw_VL_b = 5;
    public static final int Draw_VL_mode = 6;
    public static final int Draw_VLc = 7;
    public static final int Draw_VLcs = 8;
    public static final int Draw_VLp = 9;
    public static final int Draw_VLp_7F = 10;
    public static final int Draw_VLp_b = 11;
    public static final int Draw_VLp_FF = 12;
    public static final int Draw_VLp_scale = 13;
    public static final int Mov_Draw_VL_a = 14;
    static String[] typeString = new String[]{"NONE", "Draw_Pat_VL", "Draw_VL", "Draw_VL_a", "Draw_VL_ab", "Draw_VL_b", "Draw_VL_mode", "Draw_VLc", "Draw_VLcs", "Draw_VLp", "Draw_VLp_7F", "Draw_VLp_b", "Draw_VLp_FF", "Draw_VLp_scale", "Mov_Draw_VL_a"};

    private static boolean isDone(E6809 e6809, Cartridge cart, String key) {
        int x = e6809.reg_x;
        for (ScanEntry se : listsFound) {
            if (!cart.cartName.equals(se.name) || cart.getCurrentBank() != se.bank || x < se.listStartAddress || x > se.listEndAddress) continue;
            scanDone.put(key, Boolean.TRUE);
            return true;
        }
        return false;
    }

    static boolean saveList(ScanEntry list2) {
        if (list2.list.list.size() < 3) {
            return false;
        }
        String name = new File(list2.name).getName();
        name = name + "_" + list2.bank;
        name = name + "_0x" + String.format("%04X", list2.listStartAddress);
        name = name + "_" + typeString[list2.listType];
        String filename = Global.mainPathPrefix + "xml" + File.separator + "vectorlist" + File.separator + name + ".xml";
        return list2.list.saveAsXML(filename);
    }

    public static void check(E6809 e6809, Cartridge cart, VecX vecx) {
        if (e6809.reg_pc < 62381 || e6809.reg_pc > 62574) {
            return;
        }
        int checkType = 0;
        if (e6809.reg_pc == 62519) {
            checkType = 1;
        }
        if (e6809.reg_pc == 62429) {
            checkType = 2;
        }
        if (e6809.reg_pc == 62426) {
            checkType = 3;
        }
        if (e6809.reg_pc == 62424) {
            checkType = 4;
        }
        if (e6809.reg_pc == 62418) {
            checkType = 5;
        }
        if (e6809.reg_pc == 62574) {
            checkType = 6;
        }
        if (e6809.reg_pc == 62414) {
            checkType = 7;
        }
        if (e6809.reg_pc == 62422) {
            checkType = 8;
        }
        if (e6809.reg_pc == 62480) {
            checkType = 9;
        }
        if (e6809.reg_pc == 62472) {
            checkType = 10;
        }
        if (e6809.reg_pc == 62478) {
            checkType = 11;
        }
        if (e6809.reg_pc == 62468) {
            checkType = 12;
        }
        if (e6809.reg_pc == 62476) {
            checkType = 13;
        }
        if (e6809.reg_pc == 62393) {
            checkType = 14;
        }
        if (checkType == 0) {
            return;
        }
        String key = cart.cartName + "_" + cart.getCurrentBank() + "_" + e6809.reg_x + "_" + typeString[checkType];
        if (VectorListScanner.isDone(e6809, cart, key)) {
            return;
        }
        Boolean isDone = scanDone.get(key);
        if (isDone != null && isDone.booleanValue()) {
            return;
        }
        switch (checkType) {
            case 1: {
                VectorListScanner.doDraw_Pat_VL(e6809, cart, vecx, key, checkType);
                break;
            }
            case 2: {
                VectorListScanner.doDraw_VL(e6809, cart, vecx, key, checkType);
                break;
            }
            case 9: {
                VectorListScanner.doDraw_VLp(e6809, cart, vecx, key, checkType);
                break;
            }
            case 6: {
                VectorListScanner.doDraw_VL_mode(e6809, cart, vecx, key, checkType);
                break;
            }
            case 14: {
                VectorListScanner.doMov_Draw_VL_a(e6809, cart, vecx, key, checkType);
                break;
            }
        }
        scanDone.put(key, Boolean.TRUE);
    }

    static void doDraw_VL(E6809 e6809, Cartridge cart, VecX vecx, String key, int type) {
        ScanEntry list2 = new ScanEntry();
        list2.name = cart.cartName;
        list2.bank = cart.getCurrentBank();
        list2.key = key;
        list2.listType = type;
        list2.listStartAddress = e6809.reg_x;
        int bytesUsed = 0;
        int count = vecx.e6809_readOnly8(51235) + 1;
        int oldx = 0;
        int oldy = 0;
        int pattern = 255;
        int intensity = vecx.alg_zsh.intValue;
        for (int i = 0; i < count; ++i) {
            int y = vecx.e6809_readOnly8(e6809.reg_x + bytesUsed) & 0xFF;
            int x = vecx.e6809_readOnly8(e6809.reg_x + bytesUsed + 1) & 0xFF;
            if (y > 127) {
                y -= 256;
            }
            if (x > 127) {
                x -= 256;
            }
            GFXVector v = new GFXVector();
            v.start.x(oldx);
            v.start.y(oldy);
            v.end.x(x += oldx);
            v.end.y(y += oldy);
            oldx = x;
            oldy = y;
            v.intensity = intensity;
            v.pattern = pattern;
            if (i != 0) {
                list2.list.get((int)(i - 1)).end_connect = v;
                list2.list.get((int)(i - 1)).uid_end_connect = v.uid;
                v.start_connect = list2.list.get(i - 1);
                v.uid_start_connect = list2.list.get((int)(i - 1)).uid;
                v.start = list2.list.get((int)(i - 1)).end;
            }
            list2.list.add(v);
            bytesUsed += 2;
        }
        for (GFXVector v : list2.list.list) {
            if (v.end_connect == null || v.start_connect == null) continue;
            v.setRelativ(true);
        }
        list2.listEndAddress = list2.listStartAddress + bytesUsed;
        VectorListScanner.saveList(list2);
        listsFound.add(list2);
    }

    static void doDraw_VLp(E6809 e6809, Cartridge cart, VecX vecx, String key, int type) {
        ScanEntry list2 = new ScanEntry();
        list2.name = cart.cartName;
        list2.bank = cart.getCurrentBank();
        list2.key = key;
        list2.listType = type;
        list2.listStartAddress = e6809.reg_x;
        int bytesUsed = 0;
        int oldx = 0;
        int oldy = 0;
        int intensity = vecx.alg_zsh.intValue;
        int count = 0;
        boolean first = true;
        while (true) {
            GFXVector v = new GFXVector();
            v.pattern = vecx.e6809_readOnly8(e6809.reg_x + bytesUsed) & 0xFF;
            if (!first && v.pattern < 128) break;
            first = false;
            int y = vecx.e6809_readOnly8(e6809.reg_x + bytesUsed + 1) & 0xFF;
            int x = vecx.e6809_readOnly8(e6809.reg_x + bytesUsed + 2) & 0xFF;
            if (y > 127) {
                y -= 256;
            }
            if (x > 127) {
                x -= 256;
            }
            v.start.x(oldx);
            v.start.y(oldy);
            v.end.x(x += oldx);
            v.end.y(y += oldy);
            oldx = x;
            oldy = y;
            v.intensity = intensity;
            if (count != 0) {
                list2.list.get((int)(count - 1)).end_connect = v;
                list2.list.get((int)(count - 1)).uid_end_connect = v.uid;
                v.start_connect = list2.list.get(count - 1);
                v.uid_start_connect = list2.list.get((int)(count - 1)).uid;
                v.start = list2.list.get((int)(count - 1)).end;
            }
            list2.list.add(v);
            bytesUsed += 3;
            ++count;
        }
        for (GFXVector v : list2.list.list) {
            if (v.end_connect == null || v.start_connect == null) continue;
            v.setRelativ(true);
        }
        list2.listEndAddress = list2.listStartAddress + bytesUsed;
        VectorListScanner.saveList(list2);
        listsFound.add(list2);
    }

    static void doDraw_Pat_VL(E6809 e6809, Cartridge cart, VecX vecx, String key, int type) {
        ScanEntry list2 = new ScanEntry();
        list2.name = cart.cartName;
        list2.bank = cart.getCurrentBank();
        list2.key = key;
        list2.listType = type;
        list2.listStartAddress = e6809.reg_x;
        int bytesUsed = 0;
        int oldx = 0;
        int oldy = 0;
        int intensity = vecx.alg_zsh.intValue;
        int pattern = vecx.e6809_readOnly8(51241) & 0xFF;
        int max = vecx.e6809_readOnly8(51235) & 0xFF;
        ++max;
        for (int i = 0; i < max; ++i) {
            GFXVector v = new GFXVector();
            v.pattern = pattern;
            int y = vecx.e6809_readOnly8(e6809.reg_x + bytesUsed + 0) & 0xFF;
            int x = vecx.e6809_readOnly8(e6809.reg_x + bytesUsed + 1) & 0xFF;
            if (y > 127) {
                y -= 256;
            }
            if (x > 127) {
                x -= 256;
            }
            v.start.x(oldx);
            v.start.y(oldy);
            v.end.x(x += oldx);
            v.end.y(y += oldy);
            oldx = x;
            oldy = y;
            v.intensity = intensity;
            if (i != 0) {
                list2.list.get((int)(i - 1)).end_connect = v;
                list2.list.get((int)(i - 1)).uid_end_connect = v.uid;
                v.start_connect = list2.list.get(i - 1);
                v.uid_start_connect = list2.list.get((int)(i - 1)).uid;
                v.start = list2.list.get((int)(i - 1)).end;
            }
            list2.list.add(v);
            bytesUsed += 2;
        }
        for (GFXVector v : list2.list.list) {
            if (v.end_connect == null || v.start_connect == null) continue;
            v.setRelativ(true);
        }
        list2.listEndAddress = list2.listStartAddress + bytesUsed;
        VectorListScanner.saveList(list2);
        listsFound.add(list2);
    }

    static void doDraw_VL_mode(E6809 e6809, Cartridge cart, VecX vecx, String key, int type) {
        ScanEntry list2 = new ScanEntry();
        list2.name = cart.cartName;
        list2.bank = cart.getCurrentBank();
        list2.key = key;
        list2.listType = type;
        list2.listStartAddress = e6809.reg_x;
        int bytesUsed = 0;
        int oldx = 0;
        int oldy = 0;
        int intensity = vecx.alg_zsh.intValue;
        int count = 0;
        int pattern = 0;
        while (true) {
            GFXVector v = new GFXVector();
            int mode = vecx.e6809_readOnly8(e6809.reg_x + bytesUsed) & 0xFF;
            if (mode == 1) break;
            pattern = mode == 0 ? 0 : (mode >= 128 ? vecx.e6809_readOnly8(51241) : 255);
            int y = vecx.e6809_readOnly8(e6809.reg_x + bytesUsed + 1) & 0xFF;
            int x = vecx.e6809_readOnly8(e6809.reg_x + bytesUsed + 2) & 0xFF;
            if (y > 127) {
                y -= 256;
            }
            if (x > 127) {
                x -= 256;
            }
            v.start.x(oldx);
            v.start.y(oldy);
            v.end.x(x += oldx);
            v.end.y(y += oldy);
            oldx = x;
            oldy = y;
            v.intensity = intensity;
            if (count != 0) {
                list2.list.get((int)(count - 1)).end_connect = v;
                list2.list.get((int)(count - 1)).uid_end_connect = v.uid;
                v.start_connect = list2.list.get(count - 1);
                v.uid_start_connect = list2.list.get((int)(count - 1)).uid;
                v.start = list2.list.get((int)(count - 1)).end;
            }
            list2.list.add(v);
            bytesUsed += 3;
            ++count;
        }
        for (GFXVector v : list2.list.list) {
            if (v.end_connect == null || v.start_connect == null) continue;
            v.setRelativ(true);
        }
        list2.listEndAddress = list2.listStartAddress + bytesUsed;
        VectorListScanner.saveList(list2);
        listsFound.add(list2);
    }

    static void doMov_Draw_VL_a(E6809 e6809, Cartridge cart, VecX vecx, String key, int type) {
        ScanEntry list2 = new ScanEntry();
        list2.name = cart.cartName;
        list2.bank = cart.getCurrentBank();
        list2.key = key;
        list2.listType = type;
        list2.listStartAddress = e6809.reg_x;
        int bytesUsed = 2;
        int count = e6809.reg_a & 0xFF;
        int oldx = 0;
        int oldy = 0;
        int pattern = 255;
        int intensity = vecx.alg_zsh.intValue;
        for (int i = 0; i < count; ++i) {
            int y = vecx.e6809_readOnly8(e6809.reg_x + bytesUsed) & 0xFF;
            int x = vecx.e6809_readOnly8(e6809.reg_x + bytesUsed + 1) & 0xFF;
            if (y > 127) {
                y -= 256;
            }
            if (x > 127) {
                x -= 256;
            }
            GFXVector v = new GFXVector();
            v.start.x(oldx);
            v.start.y(oldy);
            v.end.x(x += oldx);
            v.end.y(y += oldy);
            oldx = x;
            oldy = y;
            v.intensity = intensity;
            v.pattern = pattern;
            if (i != 0) {
                list2.list.get((int)(i - 1)).end_connect = v;
                list2.list.get((int)(i - 1)).uid_end_connect = v.uid;
                v.start_connect = list2.list.get(i - 1);
                v.uid_start_connect = list2.list.get((int)(i - 1)).uid;
                v.start = list2.list.get((int)(i - 1)).end;
            }
            list2.list.add(v);
            bytesUsed += 2;
        }
        for (GFXVector v : list2.list.list) {
            if (v.end_connect == null || v.start_connect == null) continue;
            v.setRelativ(true);
        }
        list2.listEndAddress = list2.listStartAddress + bytesUsed;
        VectorListScanner.saveList(list2);
        listsFound.add(list2);
    }

    static class ScanEntry {
        public int listStartAddress;
        public int listEndAddress;
        public int listType;
        String name = "";
        int bank;
        public String key;
        public GFXVectorList list = new GFXVectorList();

        ScanEntry() {
        }
    }
}

