/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.veccy.gtest;

import de.malban.graphics.GFXVector;
import de.malban.graphics.GFXVectorList;
import de.malban.graphics.Vertex;
import de.malban.vide.veccy.gtest.Obj3D;
import de.malban.vide.veccy.gtest.Point2D;
import de.malban.vide.veccy.gtest.Point3D;
import de.malban.vide.veccy.gtest.Polygon3D;
import de.malban.vide.veccy.gtest.Tools2D;
import de.malban.vide.veccy.gtest.Tria;
import java.awt.Dimension;
import java.util.HashMap;
import java.util.Vector;

public class HLines {
    public static int CALC_SCALE = 1000;
    private int maxX;
    private int maxY;
    private int centerX;
    private int centerY;
    private int nTria;
    private int nVertices;
    private Obj3D obj;
    private Point2D imgCenter;
    private Tria[] tr;
    private int[] refPol;
    private int[][] connect;
    private int[] nConnect;
    private int chunkSize = 4;
    private double hLimit;
    private Vector polyList;

    Obj3D getObj() {
        return this.obj;
    }

    void setObj(Obj3D obj) {
        this.obj = obj;
    }

    public GFXVectorList processVectorlist(GFXVectorList vlist) {
        vlist = vlist.clone();
        HashMap<Vertex, Vertex> safety = new HashMap<Vertex, Vertex>();
        for (GFXVector vector : vlist.list) {
            Vertex end2;
            Vertex start = vector.start;
            if (start != null && safety.get(start) == null) {
                start.z(-start.z());
                safety.put(start, start);
            }
            if ((end2 = vector.end) == null || safety.get(end2) != null) continue;
            end2.z(-end2.z());
            safety.put(end2, end2);
        }
        GFXVectorList vl = new GFXVectorList();
        Obj3D obj = new Obj3D();
        obj.setVectorlist(vlist);
        this.setObj(obj);
        this.process(vl);
        for (GFXVector vector : vl.list) {
            Vertex end3;
            Vertex start = vector.start;
            if (start != null) {
                start.x((int)(start.x() / (double)CALC_SCALE));
                start.y((int)(start.y() / (double)CALC_SCALE));
                start.z((int)(start.z() / (double)CALC_SCALE));
            }
            if ((end3 = vector.end) == null) continue;
            end3.x((int)(end3.x() / (double)CALC_SCALE));
            end3.y((int)(end3.y() / (double)CALC_SCALE));
            end3.z((int)(end3.z() / (double)CALC_SCALE));
        }
        vl.removePoints(false);
        vl.removeDoubles();
        vl.doOrder();
        vl.connectWherePossible(false);
        return vl;
    }

    public void process(GFXVectorList vl) {
        if (this.obj == null) {
            return;
        }
        Vector polyList = this.obj.getPolyList();
        if (polyList == null) {
            return;
        }
        int nFaces = polyList.size();
        if (nFaces == 0) {
            return;
        }
        Dimension dim = new Dimension();
        dim.width = CALC_SCALE;
        dim.height = CALC_SCALE;
        this.maxX = dim.width - 1;
        this.maxY = dim.height - 1;
        this.centerX = this.maxX / 2;
        this.centerY = this.maxY / 2;
        this.obj.eyeAndScreen(dim, false);
        this.imgCenter = this.obj.getImgCenter();
        this.obj.planeCoeff();
        this.hLimit = -1.0E-6 * (double)this.obj.getRho();
        this.buildLineSet();
        this.nTria = 0;
        for (int j = 0; j < nFaces; ++j) {
            Polygon3D pol = (Polygon3D)polyList.elementAt(j);
            if (pol.getNrs().length <= 2 || !(pol.getH() <= this.hLimit)) continue;
            pol.triangulate(this.obj);
            this.nTria += pol.getT().length;
        }
        this.tr = new Tria[this.nTria];
        this.refPol = new int[this.nTria];
        int iTria = 0;
        for (int j = 0; j < nFaces; ++j) {
            Polygon3D pol = (Polygon3D)polyList.elementAt(j);
            Tria[] t = pol.getT();
            if (pol.getNrs().length <= 2 || !(pol.getH() <= this.hLimit)) continue;
            for (int i = 0; i < t.length; ++i) {
                Tria tri;
                this.tr[iTria] = tri = t[i];
                this.refPol[iTria++] = j;
            }
        }
        Point3D[] e = this.obj.getE();
        Point2D[] vScr = this.obj.getVScr();
        for (int i = 0; i < this.nVertices; ++i) {
            for (int j = 0; j < this.nConnect[i]; ++j) {
                int jj = this.connect[i][j];
                this.lineSegment(e[i], e[jj], vScr[i], vScr[jj], i, jj, 0, vl);
            }
        }
        HashMap<Vertex, Integer> noDoubles = new HashMap<Vertex, Integer>();
        float unscaler = this.obj.getD();
        for (GFXVector vector : vl.list) {
            Vertex end2;
            Vertex start = vector.start;
            if (start != null && noDoubles.get(start) == null) {
                noDoubles.put(start, new Integer(1));
                double x = -start.y() / (double)this.obj.getD() * (double)this.obj.getRho();
                double y = start.x() / (double)this.obj.getD() * (double)this.obj.getRho();
                start.x(x);
                start.y(y);
            }
            if ((end2 = vector.end) == null || noDoubles.get(end2) != null) continue;
            noDoubles.put(end2, new Integer(1));
            double x = -end2.y() / (double)this.obj.getD() * (double)this.obj.getRho();
            double y = end2.x() / (double)this.obj.getD() * (double)this.obj.getRho();
            end2.x(x);
            end2.y(y);
        }
    }

    private void buildLineSet() {
        this.polyList = this.obj.getPolyList();
        this.nVertices = this.obj.getVScr().length;
        this.connect = new int[this.nVertices][];
        this.nConnect = new int[this.nVertices];
        for (int i = 0; i < this.nVertices; ++i) {
            this.nConnect[i] = 0;
        }
        int nFaces = this.polyList.size();
        for (int j = 0; j < nFaces; ++j) {
            Polygon3D pol = (Polygon3D)this.polyList.elementAt(j);
            int[] nrs = pol.getNrs();
            int n = nrs.length;
            if (n > 2 && pol.getH() > 0.0) continue;
            int ii = Math.abs(nrs[n - 1]);
            for (int k = 0; k < n; ++k) {
                int jj = nrs[k];
                if (jj < 0) {
                    jj = -jj;
                } else {
                    int l;
                    int i1 = Math.min(ii, jj);
                    int j1 = Math.max(ii, jj);
                    int nCon = this.nConnect[i1];
                    for (l = 0; l < nCon && this.connect[i1][l] != j1; ++l) {
                    }
                    if (l == nCon) {
                        if (nCon % this.chunkSize == 0) {
                            int[] temp = new int[nCon + this.chunkSize];
                            for (l = 0; l < nCon; ++l) {
                                temp[l] = this.connect[i1][l];
                            }
                            this.connect[i1] = temp;
                        }
                        int n2 = i1;
                        int n3 = this.nConnect[n2];
                        this.nConnect[n2] = n3 + 1;
                        this.connect[i1][n3] = j1;
                    }
                }
                ii = jj;
            }
        }
    }

    int iX(float x) {
        return Math.round((float)this.centerX + x - this.imgCenter.x);
    }

    int iY(float y) {
        return Math.round((float)this.centerY - y + this.imgCenter.y);
    }

    private void lineSegment(Point3D Pe, Point3D Qe, Point2D PScr, Point2D QScr, int iP, int iQ, int iStart, GFXVectorList vl) {
        double u1 = QScr.x - PScr.x;
        double u2 = QScr.y - PScr.y;
        double minPQx = Math.min(PScr.x, QScr.x);
        double maxPQx = Math.max(PScr.x, QScr.x);
        double minPQy = Math.min(PScr.y, QScr.y);
        double maxPQy = Math.max(PScr.y, QScr.y);
        double zP = Pe.z;
        double zQ = Qe.z;
        double minPQz = Math.min(zP, zQ);
        Point3D[] e = this.obj.getE();
        Point2D[] vScr = this.obj.getVScr();
        for (int i = iStart; i < this.nTria; ++i) {
            boolean QNear;
            Tria t = this.tr[i];
            int iA = t.iA;
            int iB = t.iB;
            int iC = t.iC;
            Point2D AScr = vScr[iA];
            Point2D BScr = vScr[iB];
            Point2D CScr = vScr[iC];
            if (maxPQx <= (double)AScr.x && maxPQx <= (double)BScr.x && maxPQx <= (double)CScr.x || minPQx >= (double)AScr.x && minPQx >= (double)BScr.x && minPQx >= (double)CScr.x || maxPQy <= (double)AScr.y && maxPQy <= (double)BScr.y && maxPQy <= (double)CScr.y || minPQy >= (double)AScr.y && minPQy >= (double)BScr.y && minPQy >= (double)CScr.y || (iP == iA || iP == iB || iP == iC) && (iQ == iA || iQ == iB || iQ == iC)) continue;
            Point3D Ae = e[iA];
            Point3D Be = e[iB];
            Point3D Ce = e[iC];
            double zA = Ae.z;
            double zB = Be.z;
            double zC = Ce.z;
            if (minPQz >= zA && minPQz >= zB && minPQz >= zC) continue;
            double eps = 0.001;
            if ((double)Tools2D.area2(AScr, BScr, PScr) < eps && (double)Tools2D.area2(AScr, BScr, QScr) < eps || (double)Tools2D.area2(BScr, CScr, PScr) < eps && (double)Tools2D.area2(BScr, CScr, QScr) < eps || (double)Tools2D.area2(CScr, AScr, PScr) < eps && (double)Tools2D.area2(CScr, AScr, QScr) < eps) continue;
            double PQA = Tools2D.area2(PScr, QScr, AScr);
            double PQB = Tools2D.area2(PScr, QScr, BScr);
            double PQC = Tools2D.area2(PScr, QScr, CScr);
            if (PQA < eps && PQB < eps && PQC < eps || PQA > -eps && PQB > -eps && PQC > -eps) continue;
            int iPol = this.refPol[i];
            Polygon3D pol = (Polygon3D)this.polyList.elementAt(iPol);
            double a = pol.getA();
            double b = pol.getB();
            double c = pol.getC();
            double h = pol.getH();
            double eps1 = 1.0E-5 * Math.abs(h);
            double hP = a * (double)Pe.x + b * (double)Pe.y + c * (double)Pe.z;
            double hQ = a * (double)Qe.x + b * (double)Qe.y + c * (double)Qe.z;
            if (hP > h - eps1 && hQ > h - eps1) continue;
            boolean PInside = Tools2D.insideTriangle(AScr, BScr, CScr, PScr);
            boolean QInside = Tools2D.insideTriangle(AScr, BScr, CScr, QScr);
            if (PInside && QInside) {
                return;
            }
            double h1 = h + eps1;
            boolean PNear = hP > h1;
            boolean bl = QNear = hQ > h1;
            if (PNear && PInside || QNear && QInside) continue;
            double lambdaMin = 1.0;
            double lambdaMax = 0.0;
            for (int ii = 0; ii < 3; ++ii) {
                double lambda;
                double mu;
                double v1 = BScr.x - AScr.x;
                double v2 = BScr.y - AScr.y;
                double w1 = AScr.x - PScr.x;
                double w2 = AScr.y - PScr.y;
                double denom = u2 * v1 - u1 * v2;
                if (denom != 0.0 && (mu = (u1 * w2 - u2 * w1) / denom) > -1.0E-4 && mu < 1.0001 && (lambda = (v1 * w2 - v2 * w1) / denom) > -1.0E-4 && lambda < 1.0001) {
                    if (PInside != QInside && lambda > 1.0E-4 && lambda < 0.9999) {
                        lambdaMin = lambdaMax = lambda;
                        break;
                    }
                    if (lambda < lambdaMin) {
                        lambdaMin = lambda;
                    }
                    if (lambda > lambdaMax) {
                        lambdaMax = lambda;
                    }
                }
                Point2D temp = AScr;
                AScr = BScr;
                BScr = CScr;
                CScr = temp;
            }
            float d = this.obj.getD();
            if (!PInside && lambdaMin > 0.001) {
                double zI = 1.0 / (lambdaMin / zQ + (1.0 - lambdaMin) / zP);
                double IScrx = (double)PScr.x + lambdaMin * u1;
                double xI = -zI * IScrx / (double)d;
                double IScry = (double)PScr.y + lambdaMin * u2;
                double yI = -zI * IScry / (double)d;
                if (a * xI + b * yI + c * zI > h1) continue;
                Point2D IScr = new Point2D((float)IScrx, (float)IScry);
                if ((double)Tools2D.distance2(IScr, PScr) >= 1.0) {
                    this.lineSegment(Pe, new Point3D(xI, yI, zI), PScr, IScr, iP, -1, i + 1, vl);
                }
            }
            if (!QInside && lambdaMax < 0.999) {
                double zJ = 1.0 / (lambdaMax / zQ + (1.0 - lambdaMax) / zP);
                double JScrx = (double)PScr.x + lambdaMax * u1;
                double xJ = -zJ * JScrx / (double)d;
                double JScry = (double)PScr.y + lambdaMax * u2;
                double yJ = -zJ * JScry / (double)d;
                double number = a * xJ + b * yJ + c * zJ;
                if (number > h1) continue;
                Point2D JScr = new Point2D((float)JScrx, (float)JScry);
                if ((double)Tools2D.distance2(JScr, QScr) >= 1.0) {
                    this.lineSegment(Qe, new Point3D(xJ, yJ, zJ), QScr, JScr, iQ, -1, i + 1, vl);
                }
            }
            return;
        }
        if (vl != null) {
            this.addVector(vl, PScr.x, PScr.y, QScr.x, QScr.y);
        }
    }

    void addVector(GFXVectorList vl, float x0, float y0, float x1, float y1) {
        GFXVector v = new GFXVector();
        Vertex start = new Vertex();
        start.x(x0);
        start.y(y0);
        Vertex end2 = new Vertex();
        end2.x(x1);
        end2.y(y1);
        v.start = start;
        v.end = end2;
        vl.add(v);
    }
}

