/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.veccy.gtest;

import de.malban.graphics.Face;
import de.malban.graphics.GFXVector;
import de.malban.graphics.GFXVectorList;
import de.malban.graphics.Vertex;
import de.malban.vide.veccy.gtest.HLines;
import de.malban.vide.veccy.gtest.Point2D;
import de.malban.vide.veccy.gtest.Point3D;
import de.malban.vide.veccy.gtest.Polygon3D;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;

class Obj3D {
    private float rho;
    private float d;
    private float theta = 0.0f;
    private float phi = 0.0f;
    private float rhoMin;
    private float rhoMax;
    private float xMin;
    private float xMax;
    private float yMin;
    private float yMax;
    private float zMin;
    private float zMax;
    private float v11;
    private float v12;
    private float v13;
    private float v21;
    private float v22;
    private float v23;
    private float v32;
    private float v33;
    private float v43;
    private float xe;
    private float ye;
    private float ze;
    private float objSize;
    private Point2D imgCenter;
    private double sunZ;
    private double sunY = this.sunZ = 1.0 / Math.sqrt(3.0);
    private double sunX = -this.sunZ;
    private double inprodMin = 1.0E30;
    private double inprodMax = -1.0E30;
    private double inprodRange;
    private Vector w = new Vector();
    private Point3D[] e;
    private Point2D[] vScr;
    private Vector polyList = new Vector();

    Obj3D() {
    }

    Vector getPolyList() {
        return this.polyList;
    }

    Point3D[] getE() {
        return this.e;
    }

    Point2D[] getVScr() {
        return this.vScr;
    }

    Point2D getImgCenter() {
        return this.imgCenter;
    }

    float getRho() {
        return this.rho;
    }

    float getD() {
        return this.d;
    }

    public boolean setVectorlist(GFXVectorList vlist) {
        int pointNo = 1;
        HashMap<Vertex, Integer> noDoubles = new HashMap<Vertex, Integer>();
        HashMap<String, String> noDoublesVectors = new HashMap<String, String>();
        HLines.CALC_SCALE = 1000;
        for (GFXVector vector : vlist.list) {
            Vertex end2;
            Vertex start = vector.start;
            if (start != null && noDoubles.get(start) == null) {
                noDoubles.put(start, new Integer(pointNo));
                this.w.ensureCapacity(pointNo + 1);
                this.addVertex(pointNo, (float)start.x() * (float)HLines.CALC_SCALE, (float)start.y() * (float)HLines.CALC_SCALE, (float)start.z() * (float)HLines.CALC_SCALE);
                ++pointNo;
            }
            if ((end2 = vector.end) == null || noDoubles.get(end2) != null) continue;
            noDoubles.put(end2, new Integer(pointNo));
            this.w.ensureCapacity(pointNo + 1);
            this.addVertex(pointNo, (float)end2.x() * (float)HLines.CALC_SCALE, (float)end2.y() * (float)HLines.CALC_SCALE, (float)end2.z() * (float)HLines.CALC_SCALE);
            ++pointNo;
        }
        this.initRho();
        boolean fno = true;
        ArrayList<Face> faces = vlist.buildFacelist();
        for (Face face : faces) {
            Vertex vertex;
            int i;
            Vector<Integer> vnrs = new Vector<Integer>();
            String vectorId = "";
            for (i = 0; i < face.vertice.size(); ++i) {
                vertex = face.vertice.get(i);
                pointNo = (Integer)noDoubles.get(vertex);
                vnrs.addElement(new Integer(pointNo));
                if (vectorId.length() == 0) {
                    vectorId = vectorId + vertex.uid + " ";
                    continue;
                }
                vectorId = vectorId + vertex.uid + " ";
                noDoublesVectors.put(vectorId, vectorId);
                vectorId = vertex.uid + " ";
            }
            this.polyList.addElement(new Polygon3D(vnrs));
            vnrs = new Vector();
            for (i = face.vertice.size() - 1; i >= 0; --i) {
                vertex = face.vertice.get(i);
                pointNo = (Integer)noDoubles.get(vertex);
                vnrs.addElement(new Integer(pointNo));
                if (vectorId.length() == 0) {
                    vectorId = vectorId + vertex.uid + " ";
                    continue;
                }
                vectorId = vectorId + vertex.uid + " ";
                noDoublesVectors.put(vectorId, vectorId);
                vectorId = vertex.uid + " ";
            }
            this.polyList.addElement(new Polygon3D(vnrs));
        }
        for (GFXVector vector : vlist.list) {
            Vertex end3;
            String vectorId = "";
            Vector<Integer> vnrs = new Vector<Integer>();
            Vertex start = vector.start;
            if (start != null) {
                vectorId = vectorId + start.uid + " ";
            }
            if ((end3 = vector.end) != null) {
                vectorId = vectorId + end3.uid + " ";
            }
            if (noDoublesVectors.get(vectorId) != null) continue;
            if (start != null) {
                vectorId = vectorId + start.uid + " ";
                pointNo = (Integer)noDoubles.get(start);
                vnrs.addElement(new Integer(pointNo));
            }
            if (end3 != null) {
                pointNo = (Integer)noDoubles.get(end3);
                vnrs.addElement(new Integer(pointNo));
            }
            this.polyList.addElement(new Polygon3D(vnrs));
        }
        return true;
    }

    private void addVertex(int i, float x, float y, float z) {
        if (x < this.xMin) {
            this.xMin = x;
        }
        if (x > this.xMax) {
            this.xMax = x;
        }
        if (y < this.yMin) {
            this.yMin = y;
        }
        if (y > this.yMax) {
            this.yMax = y;
        }
        if (z < this.zMin) {
            this.zMin = z;
        }
        if (z > this.zMax) {
            this.zMax = z;
        }
        if (i >= this.w.size()) {
            this.w.setSize(i + 1);
        }
        this.w.setElementAt(new Point3D(x, y, z), i);
    }

    private void initRho() {
        float dx = this.xMax - this.xMin;
        float dy = this.yMax - this.yMin;
        float dz = this.zMax - this.zMin;
        this.rhoMin = 0.6f * (float)Math.sqrt(dx * dx + dy * dy + dz * dz);
        this.rhoMax = 10000.0f * this.rhoMin;
        this.rho = 3.0f * this.rhoMin;
        this.rho = this.rhoMin;
        this.rho = this.rhoMax;
    }

    float eyeAndScreen(Dimension dim, boolean isPaint) {
        int n = this.w.size();
        this.e = new Point3D[n];
        this.vScr = new Point2D[n];
        float xScrMin = 1.0E30f;
        float xScrMax = -1.0E30f;
        float yScrMin = 1.0E30f;
        float yScrMax = -1.0E30f;
        for (int i = 1; i < n; ++i) {
            Point3D P2 = (Point3D)this.w.elementAt(i);
            if (P2 == null) {
                this.e[i] = null;
                this.vScr[i] = null;
                continue;
            }
            float x = P2.y;
            float y = -P2.x;
            float z = P2.z - this.rho;
            Point3D Pe = this.e[i] = new Point3D(x, y, z);
            float xScr = -Pe.x / -this.rho;
            float yScr = -Pe.y / -this.rho;
            this.vScr[i] = new Point2D(xScr, yScr);
            if (xScr < xScrMin) {
                xScrMin = xScr;
            }
            if (xScr > xScrMax) {
                xScrMax = xScr;
            }
            if (yScr < yScrMin) {
                yScrMin = yScr;
            }
            if (!(yScr > yScrMax)) continue;
            yScrMax = yScr;
        }
        float rangeX = xScrMax - xScrMin;
        float rangeY = yScrMax - yScrMin;
        this.d = 1.0f * Math.min((float)dim.width / rangeX, (float)dim.height / rangeY);
        this.imgCenter = new Point2D(this.d * (xScrMin + xScrMax) / 2.0f, this.d * (yScrMin + yScrMax) / 2.0f);
        for (int i = 1; i < n; ++i) {
            if (this.vScr[i] == null) continue;
            this.vScr[i].x *= this.d;
            this.vScr[i].y *= this.d;
        }
        return this.d * Math.max(rangeX, rangeY);
    }

    void planeCoeff() {
        int nFaces = this.polyList.size();
        for (int j = 0; j < nFaces; ++j) {
            Polygon3D pol = (Polygon3D)this.polyList.elementAt(j);
            int[] nrs = pol.getNrs();
            if (nrs.length < 3) continue;
            int iA = Math.abs(nrs[0]);
            int iB = Math.abs(nrs[1]);
            int iC = Math.abs(nrs[2]);
            Point3D A = this.e[iA];
            Point3D B = this.e[iB];
            Point3D C = this.e[iC];
            double u1 = B.x - A.x;
            double u2 = B.y - A.y;
            double u3 = B.z - A.z;
            double v1 = C.x - A.x;
            double v2 = C.y - A.y;
            double v3 = C.z - A.z;
            double a = u2 * v3 - u3 * v2;
            double b = u3 * v1 - u1 * v3;
            double c = u1 * v2 - u2 * v1;
            double len = Math.sqrt(a * a + b * b + c * c);
            double h = (a /= len) * (double)A.x + (b /= len) * (double)A.y + (c /= len) * (double)A.z;
            pol.setAbch(a, b, c, h);
            Point2D A1 = this.vScr[iA];
            Point2D B1 = this.vScr[iB];
            Point2D C1 = this.vScr[iC];
            u1 = B1.x - A1.x;
            u2 = B1.y - A1.y;
            v1 = C1.x - A1.x;
            v2 = C1.y - A1.y;
            if (u1 * v2 - u2 * v1 <= 0.0) continue;
            double inprod = a * this.sunX + b * this.sunY + c * this.sunZ;
            if (inprod < this.inprodMin) {
                this.inprodMin = inprod;
            }
            if (!(inprod > this.inprodMax)) continue;
            this.inprodMax = inprod;
        }
        this.inprodRange = this.inprodMax - this.inprodMin;
    }
}

