/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.veccy.gtest;

import de.malban.vide.veccy.gtest.Obj3D;
import de.malban.vide.veccy.gtest.Point2D;
import de.malban.vide.veccy.gtest.Tools2D;
import de.malban.vide.veccy.gtest.Tria;
import java.util.Vector;

class Polygon3D {
    private int[] nrs;
    private double a;
    private double b;
    private double c;
    private double h;
    private Tria[] t;

    Polygon3D(Vector vnrs) {
        int n = vnrs.size();
        this.nrs = new int[n];
        for (int i = 0; i < n; ++i) {
            this.nrs[i] = (Integer)vnrs.elementAt(i);
        }
    }

    int[] getNrs() {
        return this.nrs;
    }

    double getA() {
        return this.a;
    }

    double getB() {
        return this.b;
    }

    double getC() {
        return this.c;
    }

    double getH() {
        return this.h;
    }

    void setAbch(double a, double b, double c, double h) {
        this.a = a;
        this.b = b;
        this.c = c;
        this.h = h;
    }

    Tria[] getT() {
        return this.t;
    }

    void triangulate(Obj3D obj) {
        int n = this.nrs.length;
        int[] next = new int[n];
        this.t = new Tria[n - 2];
        Point2D[] vScr = obj.getVScr();
        int iA = 0;
        int j = n - 1;
        int i = 0;
        while (i < n) {
            next[j] = i;
            j = i++;
        }
        for (int k = 0; k < n - 2; ++k) {
            boolean found = false;
            int count = 0;
            int nA = -1;
            int nB = 0;
            int nC = 0;
            while (!found && ++count < n) {
                Point2D C;
                Point2D B;
                int iB = next[iA];
                int iC = next[iB];
                nA = Math.abs(this.nrs[iA]);
                Point2D A = vScr[nA];
                if (Tools2D.area2(A, B = vScr[nB = Math.abs(this.nrs[iB])], C = vScr[nC = Math.abs(this.nrs[iC])]) >= 0.0f) {
                    j = next[iC];
                    int nj = Math.abs(this.nrs[j]);
                    while (!(j == iA || nj != nA && nj != nB && nj != nC && Tools2D.insideTriangle(A, B, C, vScr[nj]))) {
                        j = next[j];
                        nj = Math.abs(this.nrs[j]);
                    }
                    if (j == iA) {
                        this.t[k] = new Tria(nA, nB, nC);
                        next[iA] = iC;
                        found = true;
                    }
                }
                iA = next[iA];
            }
            if (count != n) continue;
            if (nA >= 0) {
                this.t[k] = new Tria(nA, nB, nC);
                continue;
            }
            System.out.println("Nonsimple polygon");
            System.exit(1);
        }
    }
}

