/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.vecx;

import java.util.ArrayList;

public class CodeScanMemory {
    public MemInfo[] mem = new MemInfo[65536];
    ArrayList<MemInfo[]> allBankMem = new ArrayList();
    int currentBank = 0;

    public static CodeScanMemory getCodeScanMemory() {
        return new CodeScanMemory();
    }

    public int getBankCount() {
        return this.allBankMem.size();
    }

    public void setCurrentBank(int b) {
        while (b >= this.allBankMem.size()) {
            this.mem = new MemInfo[65536];
            for (int i = 0; i < 65536; ++i) {
                this.mem[i] = new MemInfo();
            }
            this.allBankMem.add(this.mem);
        }
        this.currentBank = b;
        this.mem = this.allBankMem.get(this.currentBank);
    }

    private CodeScanMemory() {
        this.reset();
    }

    public void reset() {
        this.allBankMem.clear();
        for (int i = 0; i < 65536; ++i) {
            this.mem[i] = new MemInfo();
        }
        this.allBankMem.add(this.mem);
    }

    public static class MemInfo {
        public static final int MEMORY_UNKOWN = 0;
        public static final int MEMORY_CODE = 1;
        public static final int MEMORY_READ = 2;
        public static final int MEMORY_WRITE = 4;
        public static final int MEMORY_CODE_PART = 8;
        public ArrayList<Integer> readAccess;
        public ArrayList<Integer> writeAccess;
        public int codeScanType = 0;
        public int dp = 255;

        public void addAccess(int address, int dp, int type) {
            this.codeScanType |= type;
            this.dp = dp;
            if ((type & 1) == 1) {
                this.codeScanType &= 0xFFFFFFFD;
                if (this.readAccess == null) {
                    this.readAccess = new ArrayList();
                }
                if (!this.readAccess.contains(address)) {
                    this.readAccess.add(address);
                }
            }
            if ((type & 1) == 8) {
                this.codeScanType &= 0xFFFFFFFD;
                this.codeScanType &= 0xFFFFFFFE;
                if (this.readAccess == null) {
                    this.readAccess = new ArrayList();
                }
                if (!this.readAccess.contains(address)) {
                    this.readAccess.add(address);
                }
            }
            if ((type & 2) == 2) {
                if (this.readAccess == null) {
                    this.readAccess = new ArrayList();
                }
                if (!this.readAccess.contains(address)) {
                    this.readAccess.add(address);
                }
            }
            if ((type & 4) == 4) {
                if (this.writeAccess == null) {
                    this.writeAccess = new ArrayList();
                }
                if (!this.writeAccess.contains(address)) {
                    this.writeAccess.add(address);
                }
            }
        }
    }
}

