/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.vecx;

import de.malban.vide.vecx.E6809Access;
import de.malban.vide.vecx.E6809State;
import de.malban.vide.vecx.E6809Statics;
import de.malban.vide.vecx.Profiler;
import de.malban.vide.vecx.ValuePointer;
import java.util.ArrayList;

public class E6809
extends E6809State
implements E6809Statics {
    int clear = 0;
    public static transient boolean NO_SHADOW_STEP = true;
    public static transient boolean RC3 = false;
    public static transient boolean R251_error = false;
    transient E6809Access vecx = null;
    transient Profiler profiler = null;
    public transient int lowestStackValue = 65536;
    public static final int PRE_CLR_STEPS = 4;
    public static final int POST_CLR_ADDSTEPS = -1;
    boolean nmi = false;
    ValuePointer cycles = new ValuePointer();
    int op;
    int ea;
    int i0;
    int i1;
    int r;
    int tmp;
    int orgPC;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void callstackSanityCheck() {
        ArrayList arrayList = this.callStack;
        synchronized (arrayList) {
            for (int j = this.callStack.size() - 1; j >= 0; --j) {
                int check = (Integer)this.callStack.get(j);
                boolean found = false;
                int adr = this.reg_s.intValue;
                for (int i = 0; i < 20; ++i) {
                    int datalo;
                    int datahi = this.vecx.e6809_readOnly8(adr + i & 0xFFFF);
                    if (check != datahi * 256 + (datalo = this.vecx.e6809_readOnly8(adr + 1 + i & 0xFFFF))) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                this.callStack.remove(this.callStack.get(j));
            }
        }
    }

    void resetCallstack() {
        this.callStack.clear();
    }

    int read_xyus(int r) {
        if (r == 0) {
            return this.reg_x;
        }
        if (r == 1) {
            return this.reg_y;
        }
        if (r == 2) {
            return this.reg_u.intValue;
        }
        return this.reg_s.intValue;
    }

    void write_xyus(int r, int v) {
        if (r == 0) {
            this.reg_x = v;
        } else if (r == 1) {
            this.reg_y = v;
        } else if (r == 2) {
            this.reg_u.intValue = v;
        } else {
            this.reg_s.intValue = v;
            if (v < this.lowestStackValue) {
                this.lowestStackValue = v;
            }
        }
    }

    int get_cc_old(int flag) {
        return this.reg_cc / flag & 1;
    }

    boolean get_cc(int flag) {
        return (this.reg_cc & flag) == flag;
    }

    int get_cc_int(int flag) {
        return (this.reg_cc & flag) == flag ? 1 : 0;
    }

    void set_cc_old(int flag, int value) {
        this.reg_cc &= ~flag;
        this.reg_cc |= value * flag;
    }

    void set_cc(int flag, boolean value) {
        this.reg_cc = value ? this.reg_cc | flag : this.reg_cc & ~flag;
    }

    int test_c_old(int i0, int i1, int r, int sub) {
        int flag = (i0 | i1) & ~r;
        flag |= i0 & i1;
        flag = flag >> 7 & 1;
        return flag ^= sub;
    }

    boolean test_c(int i0, int i1, int r, boolean sub) {
        return (((i0 | i1) & ~r | i0 & i1) & 0x80) == 128 ^ sub;
    }

    int test_n_old(int r) {
        return r >> 7 & 1;
    }

    boolean test_n(int r) {
        return (r & 0x80) == 128;
    }

    int test_z8_old(int r) {
        int flag = ~r;
        flag = flag >> 4 & (flag & 0xF);
        flag = flag >> 2 & (flag & 3);
        flag = flag >> 1 & (flag & 1);
        return flag;
    }

    boolean test_z8(int r) {
        return (r & 0xFF) == 0;
    }

    int test_z16_old(int r) {
        int flag = ~r;
        flag = flag >> 8 & (flag & 0xFF);
        flag = flag >> 4 & (flag & 0xF);
        flag = flag >> 2 & (flag & 3);
        flag = flag >> 1 & (flag & 1);
        return flag;
    }

    boolean test_z16(int r) {
        return (r & 0xFFFF) == 0;
    }

    int test_v_old(int i0, int i1, int r) {
        int flag = ~(i0 ^ i1);
        flag &= i0 ^ r;
        flag = flag >> 7 & 1;
        return flag;
    }

    boolean test_v(int i0, int i1, int r) {
        return (~(i0 ^ i1) & (i0 ^ r) & 0x80) == 128;
    }

    int get_reg_d() {
        return this.reg_a << 8 & 0xFF00 | this.reg_b & 0xFF;
    }

    void set_reg_d(int value) {
        this.reg_a = value >> 8 & 0xFF;
        this.reg_b = value & 0xFF;
    }

    int read8(int address) {
        return this.vecx.e6809_read8(address & 0xFFFF) & 0xFF;
    }

    void write8(int address, int data2) {
        this.vecx.e6809_write8(address & 0xFFFF, data2);
    }

    int read16(int address) {
        int datahi = this.read8(address);
        int datalo = this.read8(address + 1);
        return datahi << 8 | datalo;
    }

    int read16_cycloid(int address) {
        int datahi = this.vecx.e6809_read8(address & 0xFFFF);
        if (NO_SHADOW_STEP) {
            this.vecx.vectrexNonCPUStep(1);
        } else if (RC3) {
            this.vecx.vectrexNonCPUStep(1);
        } else {
            this.vecx.vectrexNonCPUStepDontAdd(1);
        }
        int datalo = this.vecx.e6809_read8(address + 1 & 0xFFFF);
        return datahi << 8 | datalo;
    }

    void write16(int address, int data2) {
        this.write8(address, data2 >> 8);
        this.write8(address + 1, data2);
    }

    void write16_cycloid(int address, int data2) {
        this.write8(address, data2 >> 8);
        if (NO_SHADOW_STEP) {
            this.vecx.vectrexNonCPUStep(1);
        } else if (RC3) {
            this.vecx.vectrexNonCPUStep(1);
        } else {
            this.vecx.vectrexNonCPUStepDontAdd(1);
        }
        this.write8(address + 1, data2);
    }

    void push8(ValuePointer sp, int data2) {
        --sp.intValue;
        this.write8(sp.intValue, data2);
    }

    int pull8(ValuePointer sp) {
        int data2 = this.read8(sp.intValue);
        ++sp.intValue;
        return data2;
    }

    void push16(ValuePointer sp, int data2) {
        this.push8(sp, data2);
        this.push8(sp, data2 >> 8);
    }

    int pull16(ValuePointer sp) {
        int datahi = this.pull8(sp);
        int datalo = this.pull8(sp);
        return datahi << 8 | datalo;
    }

    int pc_read8() {
        int data2 = this.read8(this.reg_pc);
        this.reg_pc = this.reg_pc + 1 & 0xFFFF;
        return data2;
    }

    int pc_read16() {
        int data2 = this.read16(this.reg_pc);
        this.reg_pc = this.reg_pc + 2 & 0xFFFF;
        return data2;
    }

    int sign_extend(int data2) {
        return ~(data2 & 0x80) + 1 | data2 & 0xFF;
    }

    int ea_direct() {
        return this.reg_dp << 8 | this.pc_read8();
    }

    int ea_extended() {
        this.addressBUS = this.pc_read16();
        return this.addressBUS;
    }

    int ea_indexed(ValuePointer cycles) {
        int ea;
        int op = this.pc_read8();
        int r = op >> 5 & 3;
        switch (op) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: {
                ++cycles.intValue;
                this.vecx.vectrexNonCPUStep(1);
                ea = this.read_xyus(r) + (op & 0xF);
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: {
                ++cycles.intValue;
                this.vecx.vectrexNonCPUStep(1);
                ea = this.read_xyus(r) + (op & 0xF) - 16;
                break;
            }
            case 128: 
            case 129: 
            case 160: 
            case 161: 
            case 192: 
            case 193: 
            case 224: 
            case 225: {
                cycles.intValue += 2 + (op & 1);
                this.vecx.vectrexNonCPUStep(2 + (op & 1));
                ea = this.read_xyus(r);
                this.write_xyus(r, this.read_xyus(r) + 1 + (op & 1));
                break;
            }
            case 144: 
            case 145: 
            case 176: 
            case 177: 
            case 208: 
            case 209: 
            case 240: 
            case 241: {
                cycles.intValue += 5 + (op & 1);
                this.vecx.vectrexNonCPUStep(5 + (op & 1));
                ea = this.read16(this.read_xyus(r));
                this.write_xyus(r, this.read_xyus(r) + 1 + (op & 1));
                break;
            }
            case 130: 
            case 131: 
            case 162: 
            case 163: 
            case 194: 
            case 195: 
            case 226: 
            case 227: {
                cycles.intValue += 2 + (op & 1);
                this.vecx.vectrexNonCPUStep(2 + (op & 1));
                this.write_xyus(r, this.read_xyus(r) - (1 + (op & 1)));
                ea = this.read_xyus(r);
                break;
            }
            case 146: 
            case 147: 
            case 178: 
            case 179: 
            case 210: 
            case 211: 
            case 242: 
            case 243: {
                cycles.intValue += 5 + (op & 1);
                this.vecx.vectrexNonCPUStep(5 + (op & 1));
                this.write_xyus(r, this.read_xyus(r) - (1 + (op & 1)));
                ea = this.read16(this.read_xyus(r));
                break;
            }
            case 132: 
            case 164: 
            case 196: 
            case 228: {
                ea = this.read_xyus(r);
                break;
            }
            case 148: 
            case 180: 
            case 212: 
            case 244: {
                if (R251_error) {
                    cycles.intValue += 2;
                    this.vecx.vectrexNonCPUStep(2);
                    ea = this.read16(this.read_xyus(r));
                    break;
                }
                cycles.intValue += 3;
                this.vecx.vectrexNonCPUStep(3);
                ea = this.read16(this.read_xyus(r));
                break;
            }
            case 133: 
            case 165: 
            case 197: 
            case 229: {
                ++cycles.intValue;
                this.vecx.vectrexNonCPUStep(1);
                ea = this.read_xyus(r) + this.sign_extend(this.reg_b);
                break;
            }
            case 149: 
            case 181: 
            case 213: 
            case 245: {
                cycles.intValue += 4;
                this.vecx.vectrexNonCPUStep(4);
                ea = this.read16(this.read_xyus(r) + this.sign_extend(this.reg_b));
                break;
            }
            case 134: 
            case 166: 
            case 198: 
            case 230: {
                ++cycles.intValue;
                this.vecx.vectrexNonCPUStep(1);
                ea = this.read_xyus(r) + this.sign_extend(this.reg_a);
                break;
            }
            case 150: 
            case 182: 
            case 214: 
            case 246: {
                cycles.intValue += 4;
                this.vecx.vectrexNonCPUStep(4);
                ea = this.read16(this.read_xyus(r) + this.sign_extend(this.reg_a));
                break;
            }
            case 136: 
            case 168: 
            case 200: 
            case 232: {
                ++cycles.intValue;
                this.vecx.vectrexNonCPUStep(1);
                ea = this.read_xyus(r) + this.sign_extend(this.pc_read8());
                break;
            }
            case 152: 
            case 184: 
            case 216: 
            case 248: {
                cycles.intValue += 4;
                this.vecx.vectrexNonCPUStep(4);
                ea = this.read16(this.read_xyus(r) + this.sign_extend(this.pc_read8()));
                break;
            }
            case 137: 
            case 169: 
            case 201: 
            case 233: {
                cycles.intValue += 4;
                this.vecx.vectrexNonCPUStep(4);
                ea = this.read_xyus(r) + this.pc_read16();
                break;
            }
            case 153: 
            case 185: 
            case 217: 
            case 249: {
                cycles.intValue += 7;
                this.vecx.vectrexNonCPUStep(7);
                ea = this.read16(this.read_xyus(r) + this.pc_read16());
                break;
            }
            case 139: 
            case 171: 
            case 203: 
            case 235: {
                cycles.intValue += 4;
                this.vecx.vectrexNonCPUStep(4);
                ea = this.read_xyus(r) + this.get_reg_d();
                break;
            }
            case 155: 
            case 187: 
            case 219: 
            case 251: {
                cycles.intValue += 7;
                this.vecx.vectrexNonCPUStep(7);
                ea = this.read16(this.read_xyus(r) + this.get_reg_d());
                break;
            }
            case 140: 
            case 172: 
            case 204: 
            case 236: {
                this.vecx.vectrexNonCPUStep(1);
                ea = this.reg_pc + r;
                ++cycles.intValue;
                r = this.sign_extend(this.pc_read8());
                break;
            }
            case 156: 
            case 188: 
            case 220: 
            case 252: {
                this.vecx.vectrexNonCPUStep(4);
                r = this.sign_extend(this.pc_read8());
                cycles.intValue += 4;
                ea = this.read16(this.reg_pc + r);
                break;
            }
            case 141: 
            case 173: 
            case 205: 
            case 237: {
                this.vecx.vectrexNonCPUStep(5);
                r = this.pc_read16();
                ea = this.reg_pc + r;
                cycles.intValue += 5;
                break;
            }
            case 157: 
            case 189: 
            case 221: 
            case 253: {
                this.vecx.vectrexNonCPUStep(8);
                r = this.pc_read16();
                ea = this.read16(this.reg_pc + r);
                cycles.intValue += 8;
                break;
            }
            case 159: {
                this.vecx.vectrexNonCPUStep(5);
                ea = this.read16(this.pc_read16());
                cycles.intValue += 5;
                break;
            }
            default: {
                ea = 0;
                System.out.println("undefined post-byte\n");
            }
        }
        return ea & 0xFFFF;
    }

    int inst_neg(int data2) {
        int i0 = 0;
        int i1 = ~data2;
        int r = i0 + i1 + 1;
        this.reg_cc = this.test_c(i0 << 4, i1 << 4, r << 4, false) ? this.reg_cc | 0x20 : this.reg_cc & 0xFFFFFFDF;
        this.reg_cc = (r & 0x80) == 128 ? this.reg_cc | 8 : this.reg_cc & 0xFFFFFFF7;
        this.reg_cc = (r & 0xFF) == 0 ? this.reg_cc | 4 : this.reg_cc & 0xFFFFFFFB;
        this.reg_cc = this.test_v(i0, i1, r) ? this.reg_cc | 2 : this.reg_cc & 0xFFFFFFFD;
        this.reg_cc = this.test_c(i0, i1, r, true) ? this.reg_cc | 1 : this.reg_cc & 0xFFFFFFFE;
        return r;
    }

    int inst_com(int data2) {
        int r = ~data2;
        this.reg_cc = (r & 0x80) == 128 ? this.reg_cc | 8 : this.reg_cc & 0xFFFFFFF7;
        this.reg_cc = (r & 0xFF) == 0 ? this.reg_cc | 4 : this.reg_cc & 0xFFFFFFFB;
        this.reg_cc &= 0xFFFFFFFD;
        this.reg_cc |= 1;
        return r;
    }

    int inst_lsr(int data2) {
        int r = data2 >> 1 & 0x7F;
        this.reg_cc &= 0xFFFFFFF7;
        this.reg_cc = (r & 0xFF) == 0 ? this.reg_cc | 4 : this.reg_cc & 0xFFFFFFFB;
        this.reg_cc = (data2 & 1) == 1 ? this.reg_cc | 1 : this.reg_cc & 0xFFFFFFFE;
        return r;
    }

    int inst_ror(int data2) {
        int r = data2 >> 1 & 0x7F | ((this.reg_cc & 1) == 1 ? 1 : 0) << 7;
        this.reg_cc = (r & 0x80) == 128 ? this.reg_cc | 8 : this.reg_cc & 0xFFFFFFF7;
        this.reg_cc = (r & 0xFF) == 0 ? this.reg_cc | 4 : this.reg_cc & 0xFFFFFFFB;
        this.reg_cc = (data2 & 1) == 1 ? this.reg_cc | 1 : this.reg_cc & 0xFFFFFFFE;
        return r;
    }

    int inst_asr(int data2) {
        int r = data2 >> 1 & 0x7F | data2 & 0x80;
        this.reg_cc = (r & 0x80) == 128 ? this.reg_cc | 8 : this.reg_cc & 0xFFFFFFF7;
        this.reg_cc = (r & 0xFF) == 0 ? this.reg_cc | 4 : this.reg_cc & 0xFFFFFFFB;
        this.reg_cc = (data2 & 1) == 1 ? this.reg_cc | 1 : this.reg_cc & 0xFFFFFFFE;
        return r;
    }

    int inst_asl(int data2) {
        int i0 = data2;
        int i1 = data2;
        int r = i0 + i1;
        this.reg_cc = this.test_c(i0 << 4, i1 << 4, r << 4, false) ? this.reg_cc | 0x20 : this.reg_cc & 0xFFFFFFDF;
        this.reg_cc = (r & 0x80) == 128 ? this.reg_cc | 8 : this.reg_cc & 0xFFFFFFF7;
        this.reg_cc = (r & 0xFF) == 0 ? this.reg_cc | 4 : this.reg_cc & 0xFFFFFFFB;
        this.reg_cc = (data2 & 0x40) >> 6 != (data2 & 0x80) >> 7 ? this.reg_cc | 2 : this.reg_cc & 0xFFFFFFFD;
        this.reg_cc = (data2 & 0x80) == 128 ? this.reg_cc | 1 : this.reg_cc & 0xFFFFFFFE;
        return r & 0xFF;
    }

    int inst_rol(int data2) {
        int r = data2 + data2 + ((this.reg_cc & 1) == 1 ? 1 : 0);
        this.reg_cc = (r & 0x80) == 128 ? this.reg_cc | 8 : this.reg_cc & 0xFFFFFFF7;
        this.reg_cc = (r & 0xFF) == 0 ? this.reg_cc | 4 : this.reg_cc & 0xFFFFFFFB;
        this.reg_cc = (data2 & 0x40) >> 6 != (data2 & 0x80) >> 7 ? this.reg_cc | 2 : this.reg_cc & 0xFFFFFFFD;
        this.reg_cc = (data2 & 0x80) == 128 ? this.reg_cc | 1 : this.reg_cc & 0xFFFFFFFE;
        return r & 0xFF;
    }

    int inst_dec(int data2) {
        int r = data2 + 255 & 0xFF;
        this.reg_cc = (r & 0x80) == 128 ? this.reg_cc | 8 : this.reg_cc & 0xFFFFFFF7;
        this.reg_cc = r == 0 ? this.reg_cc | 4 : this.reg_cc & 0xFFFFFFFB;
        this.reg_cc = data2 == 128 ? this.reg_cc | 2 : this.reg_cc & 0xFFFFFFFD;
        return r;
    }

    int inst_inc(int data2) {
        int r = data2 + 1 & 0xFF;
        this.reg_cc = (r & 0x80) == 128 ? this.reg_cc | 8 : this.reg_cc & 0xFFFFFFF7;
        this.reg_cc = r == 0 ? this.reg_cc | 4 : this.reg_cc & 0xFFFFFFFB;
        this.reg_cc = data2 == 127 ? this.reg_cc | 2 : this.reg_cc & 0xFFFFFFFD;
        return r;
    }

    void inst_tst8(int data2) {
        this.reg_cc = (data2 & 0x80) == 128 ? this.reg_cc | 8 : this.reg_cc & 0xFFFFFFF7;
        this.reg_cc = (data2 & 0xFF) == 0 ? this.reg_cc | 4 : this.reg_cc & 0xFFFFFFFB;
        this.reg_cc &= 0xFFFFFFFD;
    }

    void inst_tst16(int data2) {
        this.reg_cc = (data2 & 0x8000) == 32768 ? this.reg_cc | 8 : this.reg_cc & 0xFFFFFFF7;
        this.reg_cc = (data2 & 0xFFFF) == 0 ? this.reg_cc | 4 : this.reg_cc & 0xFFFFFFFB;
        this.reg_cc &= 0xFFFFFFFD;
    }

    void inst_clr() {
        this.reg_cc &= 0xFFFFFFF7;
        this.reg_cc |= 4;
        this.reg_cc &= 0xFFFFFFFD;
        this.reg_cc &= 0xFFFFFFFE;
    }

    int inst_sub8(int data0, int data1) {
        int i0 = data0;
        int i1 = ~data1;
        int r = i0 + i1 + 1;
        this.reg_cc = this.test_c(i0 << 4, i1 << 4, r << 4, false) ? this.reg_cc | 0x20 : this.reg_cc & 0xFFFFFFDF;
        this.reg_cc = (r & 0x80) == 128 ? this.reg_cc | 8 : this.reg_cc & 0xFFFFFFF7;
        this.reg_cc = (r & 0xFF) == 0 ? this.reg_cc | 4 : this.reg_cc & 0xFFFFFFFB;
        this.reg_cc = this.test_v(i0, i1, r) ? this.reg_cc | 2 : this.reg_cc & 0xFFFFFFFD;
        this.reg_cc = this.test_c(i0, i1, r, true) ? this.reg_cc | 1 : this.reg_cc & 0xFFFFFFFE;
        return r & 0xFF;
    }

    int inst_sbc(int data0, int data1) {
        int i0 = data0;
        int i1 = ~data1;
        int r = i0 + i1 + ((this.reg_cc & 1) == 1 ? 0 : 1);
        this.reg_cc = this.test_c(i0 << 4, i1 << 4, r << 4, false) ? this.reg_cc | 0x20 : this.reg_cc & 0xFFFFFFDF;
        this.reg_cc = (r & 0x80) == 128 ? this.reg_cc | 8 : this.reg_cc & 0xFFFFFFF7;
        this.reg_cc = (r & 0xFF) == 0 ? this.reg_cc | 4 : this.reg_cc & 0xFFFFFFFB;
        this.reg_cc = this.test_v(i0, i1, r) ? this.reg_cc | 2 : this.reg_cc & 0xFFFFFFFD;
        this.reg_cc = this.test_c(i0, i1, r, true) ? this.reg_cc | 1 : this.reg_cc & 0xFFFFFFFE;
        return r & 0xFF;
    }

    int inst_and(int data0, int data1) {
        int r = data0 & data1;
        this.reg_cc = (r & 0x80) == 128 ? this.reg_cc | 8 : this.reg_cc & 0xFFFFFFF7;
        this.reg_cc = (r & 0xFF) == 0 ? this.reg_cc | 4 : this.reg_cc & 0xFFFFFFFB;
        this.reg_cc &= 0xFFFFFFFD;
        return r;
    }

    int inst_eor(int data0, int data1) {
        int r = data0 ^ data1;
        this.reg_cc = (r & 0x80) == 128 ? this.reg_cc | 8 : this.reg_cc & 0xFFFFFFF7;
        this.reg_cc = (r & 0xFF) == 0 ? this.reg_cc | 4 : this.reg_cc & 0xFFFFFFFB;
        this.reg_cc &= 0xFFFFFFFD;
        return r;
    }

    int inst_adc(int data0, int data1) {
        int i0 = data0;
        int i1 = data1;
        int r = i0 + i1 + ((this.reg_cc & 1) == 1 ? 1 : 0) & 0xFF;
        this.reg_cc = this.test_c(i0 << 4, i1 << 4, r << 4, false) ? this.reg_cc | 0x20 : this.reg_cc & 0xFFFFFFDF;
        this.reg_cc = (r & 0x80) == 128 ? this.reg_cc | 8 : this.reg_cc & 0xFFFFFFF7;
        this.reg_cc = (r & 0xFF) == 0 ? this.reg_cc | 4 : this.reg_cc & 0xFFFFFFFB;
        this.reg_cc = this.test_v(i0, i1, r) ? this.reg_cc | 2 : this.reg_cc & 0xFFFFFFFD;
        this.reg_cc = this.test_c(i0, i1, r, false) ? this.reg_cc | 1 : this.reg_cc & 0xFFFFFFFE;
        return r;
    }

    int inst_or(int data0, int data1) {
        int r = data0 | data1;
        this.reg_cc = (r & 0x80) == 128 ? this.reg_cc | 8 : this.reg_cc & 0xFFFFFFF7;
        this.reg_cc = (r & 0xFF) == 0 ? this.reg_cc | 4 : this.reg_cc & 0xFFFFFFFB;
        this.reg_cc &= 0xFFFFFFFD;
        return r;
    }

    int inst_add8(int data0, int data1) {
        int i0 = data0;
        int i1 = data1;
        int r = i0 + i1 & 0xFF;
        this.reg_cc = this.test_c(i0 << 4, i1 << 4, r << 4, false) ? this.reg_cc | 0x20 : this.reg_cc & 0xFFFFFFDF;
        this.reg_cc = (r & 0x80) == 128 ? this.reg_cc | 8 : this.reg_cc & 0xFFFFFFF7;
        this.reg_cc = r == 0 ? this.reg_cc | 4 : this.reg_cc & 0xFFFFFFFB;
        this.reg_cc = this.test_v(i0, i1, r) ? this.reg_cc | 2 : this.reg_cc & 0xFFFFFFFD;
        this.reg_cc = this.test_c(i0, i1, r, false) ? this.reg_cc | 1 : this.reg_cc & 0xFFFFFFFE;
        return r;
    }

    int inst_add16(int data0, int data1) {
        int i0 = data0;
        int i1 = data1;
        int r = i0 + i1 & 0xFFFF;
        this.reg_cc = (r & 0x8000) == 32768 ? this.reg_cc | 8 : this.reg_cc & 0xFFFFFFF7;
        this.reg_cc = r == 0 ? this.reg_cc | 4 : this.reg_cc & 0xFFFFFFFB;
        this.reg_cc = this.test_v(i0 >> 8, i1 >> 8, r >> 8) ? this.reg_cc | 2 : this.reg_cc & 0xFFFFFFFD;
        this.reg_cc = this.test_c(i0 >> 8, i1 >> 8, r >> 8, false) ? this.reg_cc | 1 : this.reg_cc & 0xFFFFFFFE;
        return r;
    }

    int inst_sub16(int data0, int data1) {
        int i0 = data0;
        int i1 = ~data1;
        int r = i0 + i1 + 1 & 0xFFFF;
        this.reg_cc = (r & 0x8000) == 32768 ? this.reg_cc | 8 : this.reg_cc & 0xFFFFFFF7;
        this.reg_cc = r == 0 ? this.reg_cc | 4 : this.reg_cc & 0xFFFFFFFB;
        this.reg_cc = this.test_v(i0 >> 8, i1 >> 8, r >> 8) ? this.reg_cc | 2 : this.reg_cc & 0xFFFFFFFD;
        this.reg_cc = this.test_c(i0 >> 8, i1 >> 8, r >> 8, true) ? this.reg_cc | 1 : this.reg_cc & 0xFFFFFFFE;
        return r;
    }

    void inst_bra8_old(int test, int op, ValuePointer cycles) {
        int offset = this.pc_read8();
        int mask = (test ^ op & 1) - 1;
        this.reg_pc += this.sign_extend(offset) & mask;
        this.reg_pc &= 0xFFFF;
        cycles.intValue += 3;
    }

    void inst_bra8(boolean test, int op, ValuePointer cycles) {
        int offset = this.pc_read8();
        if (!(test ^ (op & 1) == 1)) {
            this.reg_pc = this.reg_pc + (~(offset & 0x80) + 1 | offset & 0xFF) & 0xFFFF;
        }
        cycles.intValue += 3;
    }

    void inst_bra16(boolean test, int op, ValuePointer cycles) {
        int offset = this.pc_read16();
        if (!(test ^ (op & 1) == 1)) {
            this.reg_pc = this.reg_pc + offset & 0xFFFF;
            this.vecx.vectrexNonCPUStep(1);
            ++cycles.intValue;
        }
        cycles.intValue += 5;
        this.vecx.vectrexNonCPUStep(5);
    }

    void inst_bra16_old(int test, int op, ValuePointer cycles) {
        int offset = this.pc_read16();
        int mask = (test ^ op & 1) - 1;
        this.reg_pc += offset & mask;
        this.reg_pc &= 0xFFFF;
        cycles.intValue += 5 - mask;
        this.vecx.vectrexNonCPUStep(5 - mask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void inst_psh(int op, ValuePointer sp, ValuePointer data2, ValuePointer cycles) {
        if ((op & 0x80) != 0) {
            this.push16(sp, this.reg_pc);
            ArrayList arrayList = this.callStack;
            synchronized (arrayList) {
                this.callStack.add(this.reg_pc & 0xFFFF);
            }
            cycles.intValue += 2;
            this.vecx.vectrexNonCPUStep(2);
        }
        if ((op & 0x40) != 0) {
            this.push16(sp, data2.intValue);
            cycles.intValue += 2;
            this.vecx.vectrexNonCPUStep(2);
        }
        if ((op & 0x20) != 0) {
            this.push16(sp, this.reg_y);
            cycles.intValue += 2;
            this.vecx.vectrexNonCPUStep(2);
        }
        if ((op & 0x10) != 0) {
            this.push16(sp, this.reg_x);
            cycles.intValue += 2;
            this.vecx.vectrexNonCPUStep(2);
        }
        if ((op & 8) != 0) {
            this.push8(sp, this.reg_dp);
            ++cycles.intValue;
            this.vecx.vectrexNonCPUStep(1);
        }
        if ((op & 4) != 0) {
            this.push8(sp, this.reg_b);
            ++cycles.intValue;
            this.vecx.vectrexNonCPUStep(1);
        }
        if ((op & 2) != 0) {
            this.push8(sp, this.reg_a);
            ++cycles.intValue;
            this.vecx.vectrexNonCPUStep(1);
        }
        if ((op & 1) != 0) {
            this.push8(sp, this.reg_cc);
            ++cycles.intValue;
            this.vecx.vectrexNonCPUStep(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void inst_pul(int op, ValuePointer sp, ValuePointer osp, ValuePointer cycles) {
        if ((op & 1) != 0) {
            this.reg_cc = this.pull8(sp);
            ++cycles.intValue;
            this.vecx.vectrexNonCPUStep(1);
        }
        if ((op & 2) != 0) {
            this.reg_a = this.pull8(sp);
            ++cycles.intValue;
            this.vecx.vectrexNonCPUStep(1);
        }
        if ((op & 4) != 0) {
            this.reg_b = this.pull8(sp);
            ++cycles.intValue;
            this.vecx.vectrexNonCPUStep(1);
        }
        if ((op & 8) != 0) {
            this.reg_dp = this.pull8(sp);
            ++cycles.intValue;
            this.vecx.vectrexNonCPUStep(1);
        }
        if ((op & 0x10) != 0) {
            this.reg_x = this.pull16(sp);
            cycles.intValue += 2;
            this.vecx.vectrexNonCPUStep(2);
        }
        if ((op & 0x20) != 0) {
            this.reg_y = this.pull16(sp);
            cycles.intValue += 2;
            this.vecx.vectrexNonCPUStep(2);
        }
        if ((op & 0x40) != 0) {
            osp.intValue = this.pull16(sp);
            cycles.intValue += 2;
            this.vecx.vectrexNonCPUStep(2);
        }
        if ((op & 0x80) != 0) {
            this.reg_pc = this.pull16(sp);
            ArrayList arrayList = this.callStack;
            synchronized (arrayList) {
                if (this.callStack.size() > 0) {
                    this.callStack.remove(this.callStack.size() - 1);
                }
            }
            cycles.intValue += 2;
            this.vecx.vectrexNonCPUStep(2);
        }
    }

    int exgtfr_read(int reg) {
        int data2;
        switch (reg) {
            case 0: {
                data2 = this.reg_a << 8 & 0xFF00 | this.reg_b & 0xFF;
                break;
            }
            case 1: {
                data2 = this.reg_x;
                break;
            }
            case 2: {
                data2 = this.reg_y;
                break;
            }
            case 3: {
                data2 = this.reg_u.intValue;
                break;
            }
            case 4: {
                data2 = this.reg_s.intValue;
                break;
            }
            case 5: {
                data2 = this.reg_pc;
                break;
            }
            case 8: {
                data2 = this.reg_a;
                break;
            }
            case 9: {
                data2 = this.reg_b;
                break;
            }
            case 10: {
                data2 = this.reg_cc;
                break;
            }
            case 11: {
                data2 = this.reg_dp;
                break;
            }
            default: {
                data2 = 65535;
                System.out.println("illegal exgtfr reg " + reg + "\n");
            }
        }
        return data2;
    }

    void exgtfr_write(int reg, int data2) {
        switch (reg) {
            case 0: {
                this.set_reg_d(data2);
                break;
            }
            case 1: {
                this.reg_x = data2;
                break;
            }
            case 2: {
                this.reg_y = data2;
                break;
            }
            case 3: {
                this.reg_u.intValue = data2;
                break;
            }
            case 4: {
                this.reg_s.intValue = data2;
                if (data2 >= this.lowestStackValue) break;
                this.lowestStackValue = data2;
                break;
            }
            case 5: {
                this.reg_pc = data2;
                break;
            }
            case 8: {
                this.reg_a = data2 & 0xFF;
                break;
            }
            case 9: {
                this.reg_b = data2 & 0xFF;
                break;
            }
            case 10: {
                this.reg_cc = data2 & 0xFF;
                break;
            }
            case 11: {
                this.reg_dp = data2 & 0xFF;
                break;
            }
            default: {
                System.out.println("illegal exgtfr reg " + reg + "\n");
            }
        }
    }

    void inst_exg() {
        int op = this.vecx.e6809_read8(this.reg_pc);
        this.reg_pc = this.reg_pc + 1 & 0xFFFF;
        int tmp = this.exgtfr_read(op & 0xF);
        this.exgtfr_write(op & 0xF, this.exgtfr_read(op >> 4));
        this.exgtfr_write(op >> 4, tmp);
    }

    void inst_tfr() {
        int op = this.vecx.e6809_read8(this.reg_pc);
        this.reg_pc = this.reg_pc + 1 & 0xFFFF;
        this.exgtfr_write(op & 0xF, this.exgtfr_read(op >> 4 & 0xF));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void e6809_reset() {
        this.profiler = null;
        this.reg_x = 0;
        this.reg_y = 0;
        this.reg_u.intValue = 0;
        this.reg_s.intValue = 0;
        this.lowestStackValue = 65536;
        this.reg_a = 0;
        this.reg_b = 0;
        this.reg_dp = 0;
        this.cyclesRunning = 0L;
        this.reg_cc = 80;
        this.irq_status = 0;
        ArrayList arrayList = this.callStack;
        synchronized (arrayList) {
            this.callStack.clear();
        }
        this.reg_pc = this.read16(65534);
    }

    void doNMI() {
        this.nmi = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int e6809_sstep(int irq_i, int irq_f) {
        if (this.nmi) {
            this.nmi = false;
            this.reg_cc |= 0x80;
            this.inst_psh(255, this.reg_s, this.reg_u, this.cycles);
            if (this.reg_s.intValue < this.lowestStackValue) {
                this.lowestStackValue = this.reg_s.intValue;
            }
            this.reg_cc = this.reg_cc | 0x10 | 0x40;
            this.reg_pc = this.read16(65532);
            this.irq_status = 0;
            this.cycles.intValue += 7;
        }
        this.cycles.intValue = 0;
        this.orgPC = this.reg_pc;
        if (irq_f != 0) {
            if ((this.reg_cc & 0x40) != 64) {
                if (this.irq_status != 2) {
                    this.reg_cc &= 0xFFFFFF7F;
                    this.inst_psh(129, this.reg_s, this.reg_u, this.cycles);
                    if (this.reg_s.intValue < this.lowestStackValue) {
                        this.lowestStackValue = this.reg_s.intValue;
                    }
                    if (this.profiler != null) {
                        this.profiler.addContext(this.read16(65526), this.reg_s.intValue + 1, this.reg_pc & 0xFFFF, this.orgPC & 0xFFFF);
                    }
                }
                this.reg_cc |= 0x10;
                this.reg_cc |= 0x40;
                this.reg_pc = this.read16(65526);
                this.irq_status = 0;
                this.cycles.intValue += 7;
            } else if (this.irq_status == 1) {
                this.irq_status = 0;
            }
        }
        if (irq_i != 0) {
            if ((this.reg_cc & 0x10) != 16) {
                if (this.irq_status != 2) {
                    this.reg_cc |= 0x80;
                    int olds = this.reg_s.intValue;
                    this.inst_psh(255, this.reg_s, this.reg_u, this.cycles);
                    if (this.reg_s.intValue < this.lowestStackValue) {
                        this.lowestStackValue = this.reg_s.intValue;
                    }
                    if (this.profiler != null) {
                        this.profiler.addContext(this.read16(65528), olds - 2, this.reg_pc & 0xFFFF, this.orgPC & 0xFFFF);
                    }
                }
                this.reg_cc |= 0x10;
                this.reg_pc = this.read16(65528);
                this.irq_status = 0;
                this.cycles.intValue += 7;
            } else if (this.irq_status == 1) {
                this.irq_status = 0;
            }
        }
        if (this.irq_status != 0) {
            this.cyclesRunning += (long)(this.cycles.intValue + 1);
            return this.cycles.intValue + 1;
        }
        this.op = this.pc_read8();
        block12 : switch (this.op) {
            case 0: {
                this.ea = this.ea_direct();
                this.vecx.vectrexNonCPUStep(3);
                this.r = this.inst_neg(this.read8(this.ea));
                this.vecx.vectrexNonCPUStep(3);
                this.write8(this.ea, this.r);
                this.cycles.intValue += 6;
                break;
            }
            case 64: {
                this.vecx.vectrexNonCPUStep(2);
                this.reg_a = this.inst_neg(this.reg_a) & 0xFF;
                this.cycles.intValue += 2;
                break;
            }
            case 80: {
                this.vecx.vectrexNonCPUStep(2);
                this.reg_b = this.inst_neg(this.reg_b) & 0xFF;
                this.cycles.intValue += 2;
                break;
            }
            case 96: {
                this.ea = this.ea_indexed(this.cycles);
                this.vecx.vectrexNonCPUStep(3);
                this.r = this.inst_neg(this.read8(this.ea));
                this.vecx.vectrexNonCPUStep(3);
                this.write8(this.ea, this.r);
                this.cycles.intValue += 6;
                break;
            }
            case 112: {
                this.ea = this.ea_extended();
                this.vecx.vectrexNonCPUStep(4);
                this.r = this.inst_neg(this.read8(this.ea));
                this.vecx.vectrexNonCPUStep(3);
                this.write8(this.ea, this.r);
                this.cycles.intValue += 7;
                break;
            }
            case 3: {
                this.ea = this.ea_direct();
                this.vecx.vectrexNonCPUStep(3);
                this.r = this.inst_com(this.read8(this.ea));
                this.vecx.vectrexNonCPUStep(3);
                this.write8(this.ea, this.r);
                this.cycles.intValue += 6;
                break;
            }
            case 67: {
                this.reg_a = this.inst_com(this.reg_a) & 0xFF;
                this.vecx.vectrexNonCPUStep(2);
                this.cycles.intValue += 2;
                break;
            }
            case 83: {
                this.reg_b = this.inst_com(this.reg_b) & 0xFF;
                this.vecx.vectrexNonCPUStep(2);
                this.cycles.intValue += 2;
                break;
            }
            case 99: {
                this.ea = this.ea_indexed(this.cycles);
                this.vecx.vectrexNonCPUStep(3);
                this.r = this.inst_com(this.read8(this.ea));
                this.vecx.vectrexNonCPUStep(3);
                this.write8(this.ea, this.r);
                this.cycles.intValue += 6;
                break;
            }
            case 115: {
                this.ea = this.ea_extended();
                this.vecx.vectrexNonCPUStep(4);
                this.r = this.inst_com(this.read8(this.ea));
                this.vecx.vectrexNonCPUStep(3);
                this.write8(this.ea, this.r);
                this.cycles.intValue += 7;
                break;
            }
            case 4: {
                this.ea = this.ea_direct();
                this.vecx.vectrexNonCPUStep(3);
                this.r = this.inst_lsr(this.read8(this.ea));
                this.vecx.vectrexNonCPUStep(3);
                this.write8(this.ea, this.r);
                this.cycles.intValue += 6;
                break;
            }
            case 68: {
                this.reg_a = this.inst_lsr(this.reg_a) & 0xFF;
                this.vecx.vectrexNonCPUStep(2);
                this.cycles.intValue += 2;
                break;
            }
            case 84: {
                this.reg_b = this.inst_lsr(this.reg_b) & 0xFF;
                this.vecx.vectrexNonCPUStep(2);
                this.cycles.intValue += 2;
                break;
            }
            case 100: {
                this.ea = this.ea_indexed(this.cycles);
                this.vecx.vectrexNonCPUStep(3);
                this.r = this.inst_lsr(this.read8(this.ea));
                this.vecx.vectrexNonCPUStep(3);
                this.write8(this.ea, this.r);
                this.cycles.intValue += 6;
                break;
            }
            case 116: {
                this.ea = this.ea_extended();
                this.vecx.vectrexNonCPUStep(4);
                this.r = this.inst_lsr(this.read8(this.ea));
                this.vecx.vectrexNonCPUStep(3);
                this.write8(this.ea, this.r);
                this.cycles.intValue += 7;
                break;
            }
            case 6: {
                this.ea = this.ea_direct();
                this.vecx.vectrexNonCPUStep(3);
                this.r = this.inst_ror(this.read8(this.ea));
                this.vecx.vectrexNonCPUStep(3);
                this.write8(this.ea, this.r);
                this.cycles.intValue += 6;
                break;
            }
            case 70: {
                this.reg_a = this.inst_ror(this.reg_a) & 0xFF;
                this.vecx.vectrexNonCPUStep(2);
                this.cycles.intValue += 2;
                break;
            }
            case 86: {
                this.reg_b = this.inst_ror(this.reg_b) & 0xFF;
                this.vecx.vectrexNonCPUStep(2);
                this.cycles.intValue += 2;
                break;
            }
            case 102: {
                this.ea = this.ea_indexed(this.cycles);
                this.vecx.vectrexNonCPUStep(3);
                this.r = this.inst_ror(this.read8(this.ea));
                this.vecx.vectrexNonCPUStep(3);
                this.write8(this.ea, this.r);
                this.cycles.intValue += 6;
                break;
            }
            case 118: {
                this.ea = this.ea_extended();
                this.vecx.vectrexNonCPUStep(4);
                this.r = this.inst_ror(this.read8(this.ea));
                this.vecx.vectrexNonCPUStep(3);
                this.write8(this.ea, this.r);
                this.cycles.intValue += 7;
                break;
            }
            case 7: {
                this.ea = this.ea_direct();
                this.vecx.vectrexNonCPUStep(3);
                this.r = this.inst_asr(this.read8(this.ea));
                this.vecx.vectrexNonCPUStep(3);
                this.write8(this.ea, this.r);
                this.cycles.intValue += 6;
                break;
            }
            case 71: {
                this.reg_a = this.inst_asr(this.reg_a) & 0xFF;
                this.vecx.vectrexNonCPUStep(2);
                this.cycles.intValue += 2;
                break;
            }
            case 87: {
                this.reg_b = this.inst_asr(this.reg_b) & 0xFF;
                this.vecx.vectrexNonCPUStep(2);
                this.cycles.intValue += 2;
                break;
            }
            case 103: {
                this.ea = this.ea_indexed(this.cycles);
                this.vecx.vectrexNonCPUStep(3);
                this.r = this.inst_asr(this.read8(this.ea));
                this.vecx.vectrexNonCPUStep(3);
                this.write8(this.ea, this.r);
                this.cycles.intValue += 6;
                break;
            }
            case 119: {
                this.ea = this.ea_extended();
                this.vecx.vectrexNonCPUStep(4);
                this.r = this.inst_asr(this.read8(this.ea));
                this.vecx.vectrexNonCPUStep(3);
                this.write8(this.ea, this.r);
                this.cycles.intValue += 7;
                break;
            }
            case 8: {
                this.ea = this.ea_direct();
                this.vecx.vectrexNonCPUStep(3);
                this.r = this.inst_asl(this.read8(this.ea));
                this.vecx.vectrexNonCPUStep(3);
                this.write8(this.ea, this.r);
                this.cycles.intValue += 6;
                break;
            }
            case 72: {
                this.reg_a = this.inst_asl(this.reg_a) & 0xFF;
                this.vecx.vectrexNonCPUStep(2);
                this.cycles.intValue += 2;
                break;
            }
            case 88: {
                this.reg_b = this.inst_asl(this.reg_b) & 0xFF;
                this.vecx.vectrexNonCPUStep(2);
                this.cycles.intValue += 2;
                break;
            }
            case 104: {
                this.ea = this.ea_indexed(this.cycles);
                this.vecx.vectrexNonCPUStep(3);
                this.r = this.inst_asl(this.read8(this.ea));
                this.vecx.vectrexNonCPUStep(3);
                this.write8(this.ea, this.r);
                this.cycles.intValue += 6;
                break;
            }
            case 120: {
                this.ea = this.ea_extended();
                this.vecx.vectrexNonCPUStep(4);
                this.r = this.inst_asl(this.read8(this.ea));
                this.vecx.vectrexNonCPUStep(3);
                this.write8(this.ea, this.r);
                this.cycles.intValue += 7;
                break;
            }
            case 9: {
                this.ea = this.ea_direct();
                this.vecx.vectrexNonCPUStep(3);
                this.r = this.inst_rol(this.read8(this.ea));
                this.vecx.vectrexNonCPUStep(3);
                this.write8(this.ea, this.r);
                this.cycles.intValue += 6;
                break;
            }
            case 73: {
                this.reg_a = this.inst_rol(this.reg_a) & 0xFF;
                this.cycles.intValue += 2;
                this.vecx.vectrexNonCPUStep(2);
                break;
            }
            case 89: {
                this.reg_b = this.inst_rol(this.reg_b) & 0xFF;
                this.vecx.vectrexNonCPUStep(2);
                this.cycles.intValue += 2;
                break;
            }
            case 105: {
                this.ea = this.ea_indexed(this.cycles);
                this.vecx.vectrexNonCPUStep(3);
                this.r = this.inst_rol(this.read8(this.ea));
                this.vecx.vectrexNonCPUStep(3);
                this.write8(this.ea, this.r);
                this.cycles.intValue += 6;
                break;
            }
            case 121: {
                this.ea = this.ea_extended();
                this.vecx.vectrexNonCPUStep(4);
                this.r = this.inst_rol(this.read8(this.ea));
                this.vecx.vectrexNonCPUStep(3);
                this.write8(this.ea, this.r);
                this.cycles.intValue += 7;
                break;
            }
            case 10: {
                this.ea = this.ea_direct();
                this.vecx.vectrexNonCPUStep(3);
                this.r = this.inst_dec(this.read8(this.ea));
                this.vecx.vectrexNonCPUStep(3);
                this.write8(this.ea, this.r);
                this.cycles.intValue += 6;
                break;
            }
            case 74: {
                this.reg_a = this.inst_dec(this.reg_a) & 0xFF;
                this.vecx.vectrexNonCPUStep(2);
                this.cycles.intValue += 2;
                break;
            }
            case 90: {
                this.reg_b = this.inst_dec(this.reg_b) & 0xFF;
                this.vecx.vectrexNonCPUStep(2);
                this.cycles.intValue += 2;
                break;
            }
            case 106: {
                this.ea = this.ea_indexed(this.cycles);
                this.vecx.vectrexNonCPUStep(3);
                this.r = this.inst_dec(this.read8(this.ea));
                this.vecx.vectrexNonCPUStep(3);
                this.write8(this.ea, this.r);
                this.cycles.intValue += 6;
                break;
            }
            case 122: {
                this.ea = this.ea_extended();
                this.vecx.vectrexNonCPUStep(4);
                this.r = this.inst_dec(this.read8(this.ea));
                this.vecx.vectrexNonCPUStep(3);
                this.write8(this.ea, this.r);
                this.cycles.intValue += 7;
                break;
            }
            case 12: {
                this.ea = this.ea_direct();
                this.vecx.vectrexNonCPUStep(3);
                this.r = this.inst_inc(this.read8(this.ea));
                this.vecx.vectrexNonCPUStep(3);
                this.write8(this.ea, this.r);
                this.cycles.intValue += 6;
                break;
            }
            case 76: {
                this.reg_a = this.inst_inc(this.reg_a) & 0xFF;
                this.vecx.vectrexNonCPUStep(2);
                this.cycles.intValue += 2;
                break;
            }
            case 92: {
                this.reg_b = this.inst_inc(this.reg_b) & 0xFF;
                this.vecx.vectrexNonCPUStep(2);
                this.cycles.intValue += 2;
                break;
            }
            case 108: {
                this.ea = this.ea_indexed(this.cycles);
                this.vecx.vectrexNonCPUStep(3);
                this.r = this.inst_inc(this.read8(this.ea));
                this.vecx.vectrexNonCPUStep(3);
                this.write8(this.ea, this.r);
                this.cycles.intValue += 6;
                break;
            }
            case 124: {
                this.ea = this.ea_extended();
                this.vecx.vectrexNonCPUStep(4);
                this.r = this.inst_inc(this.read8(this.ea));
                this.vecx.vectrexNonCPUStep(3);
                this.write8(this.ea, this.r);
                this.cycles.intValue += 7;
                break;
            }
            case 13: {
                this.ea = this.ea_direct();
                this.vecx.vectrexNonCPUStep(3);
                this.inst_tst8(this.read8(this.ea));
                this.vecx.vectrexNonCPUStep(3);
                this.cycles.intValue += 6;
                break;
            }
            case 77: {
                this.inst_tst8(this.reg_a);
                this.vecx.vectrexNonCPUStep(2);
                this.cycles.intValue += 2;
                break;
            }
            case 93: {
                this.inst_tst8(this.reg_b);
                this.vecx.vectrexNonCPUStep(2);
                this.cycles.intValue += 2;
                break;
            }
            case 109: {
                this.ea = this.ea_indexed(this.cycles);
                this.vecx.vectrexNonCPUStep(3);
                this.inst_tst8(this.read8(this.ea));
                this.vecx.vectrexNonCPUStep(3);
                this.cycles.intValue += 6;
                break;
            }
            case 125: {
                this.ea = this.ea_extended();
                this.vecx.vectrexNonCPUStep(4);
                this.inst_tst8(this.read8(this.ea));
                this.vecx.vectrexNonCPUStep(3);
                this.cycles.intValue += 7;
                break;
            }
            case 14: {
                this.reg_pc = this.ea_direct();
                this.vecx.vectrexNonCPUStep(3);
                this.cycles.intValue += 3;
                break;
            }
            case 110: {
                this.reg_pc = this.ea_indexed(this.cycles);
                this.vecx.vectrexNonCPUStep(3);
                this.cycles.intValue += 3;
                break;
            }
            case 126: {
                this.reg_pc = this.ea_extended();
                this.vecx.vectrexNonCPUStep(4);
                this.cycles.intValue += 4;
                break;
            }
            case 15: {
                this.ea = this.ea_direct();
                this.vecx.vectrexNonCPUStep(4);
                this.inst_clr();
                this.clear = 1;
                this.read8(this.ea);
                this.clear = 0;
                this.vecx.vectrexNonCPUStep(2);
                this.write8(this.ea, 0);
                this.cycles.intValue += 6;
                break;
            }
            case 79: {
                this.inst_clr();
                this.reg_a = 0;
                this.vecx.vectrexNonCPUStep(2);
                this.cycles.intValue += 2;
                break;
            }
            case 95: {
                this.inst_clr();
                this.reg_b = 0;
                this.vecx.vectrexNonCPUStep(2);
                this.cycles.intValue += 2;
                break;
            }
            case 111: {
                this.ea = this.ea_indexed(this.cycles);
                this.vecx.vectrexNonCPUStep(4);
                this.inst_clr();
                this.clear = 1;
                this.read8(this.ea);
                this.clear = 0;
                this.vecx.vectrexNonCPUStep(2);
                this.write8(this.ea, 0);
                this.cycles.intValue += 6;
                break;
            }
            case 127: {
                this.ea = this.ea_extended();
                this.vecx.vectrexNonCPUStep(5);
                this.inst_clr();
                this.clear = 1;
                this.read8(this.ea);
                this.clear = 0;
                this.vecx.vectrexNonCPUStep(2);
                this.write8(this.ea, 0);
                this.cycles.intValue += 7;
                break;
            }
            case 128: {
                this.reg_a = this.inst_sub8(this.reg_a, this.pc_read8()) & 0xFF;
                this.vecx.vectrexNonCPUStep(2);
                this.cycles.intValue += 2;
                break;
            }
            case 144: {
                this.ea = this.ea_direct();
                this.vecx.vectrexNonCPUStep(3);
                this.reg_a = this.inst_sub8(this.reg_a, this.read8(this.ea)) & 0xFF;
                this.vecx.vectrexNonCPUStep(1);
                this.cycles.intValue += 4;
                break;
            }
            case 160: {
                this.ea = this.ea_indexed(this.cycles);
                this.vecx.vectrexNonCPUStep(1);
                this.reg_a = this.inst_sub8(this.reg_a, this.read8(this.ea)) & 0xFF;
                this.vecx.vectrexNonCPUStep(1);
                this.cycles.intValue += 4;
                break;
            }
            case 176: {
                this.ea = this.ea_extended();
                this.vecx.vectrexNonCPUStep(4);
                this.reg_a = this.inst_sub8(this.reg_a, this.read8(this.ea)) & 0xFF;
                this.vecx.vectrexNonCPUStep(1);
                this.cycles.intValue += 5;
                break;
            }
            case 192: {
                this.vecx.vectrexNonCPUStep(2);
                this.reg_b = this.inst_sub8(this.reg_b, this.pc_read8()) & 0xFF;
                this.cycles.intValue += 2;
                break;
            }
            case 208: {
                this.ea = this.ea_direct();
                this.vecx.vectrexNonCPUStep(3);
                this.reg_b = this.inst_sub8(this.reg_b, this.read8(this.ea)) & 0xFF;
                this.vecx.vectrexNonCPUStep(1);
                this.cycles.intValue += 4;
                break;
            }
            case 224: {
                this.ea = this.ea_indexed(this.cycles);
                this.vecx.vectrexNonCPUStep(3);
                this.reg_b = this.inst_sub8(this.reg_b, this.read8(this.ea)) & 0xFF;
                this.vecx.vectrexNonCPUStep(1);
                this.cycles.intValue += 4;
                break;
            }
            case 240: {
                this.ea = this.ea_extended();
                this.vecx.vectrexNonCPUStep(1);
                this.reg_b = this.inst_sub8(this.reg_b, this.read8(this.ea)) & 0xFF;
                this.vecx.vectrexNonCPUStep(1);
                this.cycles.intValue += 5;
                break;
            }
            case 129: {
                this.vecx.vectrexNonCPUStep(2);
                this.inst_sub8(this.reg_a, this.pc_read8());
                this.cycles.intValue += 2;
                break;
            }
            case 145: {
                this.ea = this.ea_direct();
                this.vecx.vectrexNonCPUStep(1);
                this.inst_sub8(this.reg_a, this.read8(this.ea));
                this.vecx.vectrexNonCPUStep(1);
                this.cycles.intValue += 4;
                break;
            }
            case 161: {
                this.ea = this.ea_indexed(this.cycles);
                this.vecx.vectrexNonCPUStep(1);
                this.inst_sub8(this.reg_a, this.read8(this.ea));
                this.vecx.vectrexNonCPUStep(1);
                this.cycles.intValue += 4;
                break;
            }
            case 177: {
                this.ea = this.ea_extended();
                this.vecx.vectrexNonCPUStep(4);
                this.inst_sub8(this.reg_a, this.read8(this.ea));
                this.vecx.vectrexNonCPUStep(1);
                this.cycles.intValue += 5;
                break;
            }
            case 193: {
                this.vecx.vectrexNonCPUStep(2);
                this.inst_sub8(this.reg_b, this.pc_read8());
                this.cycles.intValue += 2;
                break;
            }
            case 209: {
                this.ea = this.ea_direct();
                this.vecx.vectrexNonCPUStep(3);
                this.inst_sub8(this.reg_b, this.read8(this.ea));
                this.vecx.vectrexNonCPUStep(1);
                this.cycles.intValue += 4;
                break;
            }
            case 225: {
                this.ea = this.ea_indexed(this.cycles);
                this.vecx.vectrexNonCPUStep(3);
                this.inst_sub8(this.reg_b, this.read8(this.ea));
                this.vecx.vectrexNonCPUStep(1);
                this.cycles.intValue += 4;
                break;
            }
            case 241: {
                this.ea = this.ea_extended();
                this.vecx.vectrexNonCPUStep(4);
                this.inst_sub8(this.reg_b, this.read8(this.ea));
                this.vecx.vectrexNonCPUStep(1);
                this.cycles.intValue += 5;
                break;
            }
            case 130: {
                this.vecx.vectrexNonCPUStep(2);
                this.reg_a = this.inst_sbc(this.reg_a, this.pc_read8()) & 0xFF;
                this.cycles.intValue += 2;
                break;
            }
            case 146: {
                this.ea = this.ea_direct();
                this.vecx.vectrexNonCPUStep(3);
                this.reg_a = this.inst_sbc(this.reg_a, this.read8(this.ea)) & 0xFF;
                this.vecx.vectrexNonCPUStep(1);
                this.cycles.intValue += 4;
                break;
            }
            case 162: {
                this.ea = this.ea_indexed(this.cycles);
                this.vecx.vectrexNonCPUStep(3);
                this.reg_a = this.inst_sbc(this.reg_a, this.read8(this.ea)) & 0xFF;
                this.vecx.vectrexNonCPUStep(1);
                this.cycles.intValue += 4;
                break;
            }
            case 178: {
                this.ea = this.ea_extended();
                this.vecx.vectrexNonCPUStep(4);
                this.reg_a = this.inst_sbc(this.reg_a, this.read8(this.ea)) & 0xFF;
                this.vecx.vectrexNonCPUStep(1);
                this.cycles.intValue += 5;
                break;
            }
            case 194: {
                this.vecx.vectrexNonCPUStep(2);
                this.reg_b = this.inst_sbc(this.reg_b, this.pc_read8()) & 0xFF;
                this.cycles.intValue += 2;
                break;
            }
            case 210: {
                this.ea = this.ea_direct();
                this.vecx.vectrexNonCPUStep(3);
                this.reg_b = this.inst_sbc(this.reg_b, this.read8(this.ea)) & 0xFF;
                this.vecx.vectrexNonCPUStep(1);
                this.cycles.intValue += 4;
                break;
            }
            case 226: {
                this.ea = this.ea_indexed(this.cycles);
                this.vecx.vectrexNonCPUStep(3);
                this.reg_b = this.inst_sbc(this.reg_b, this.read8(this.ea)) & 0xFF;
                this.vecx.vectrexNonCPUStep(1);
                this.cycles.intValue += 4;
                break;
            }
            case 242: {
                this.ea = this.ea_extended();
                this.vecx.vectrexNonCPUStep(4);
                this.reg_b = this.inst_sbc(this.reg_b, this.read8(this.ea)) & 0xFF;
                this.vecx.vectrexNonCPUStep(1);
                this.cycles.intValue += 5;
                break;
            }
            case 132: {
                this.vecx.vectrexNonCPUStep(2);
                this.reg_a = this.inst_and(this.reg_a, this.pc_read8()) & 0xFF;
                this.cycles.intValue += 2;
                break;
            }
            case 148: {
                this.ea = this.ea_direct();
                this.vecx.vectrexNonCPUStep(3);
                this.reg_a = this.inst_and(this.reg_a, this.read8(this.ea)) & 0xFF;
                this.vecx.vectrexNonCPUStep(1);
                this.cycles.intValue += 4;
                break;
            }
            case 164: {
                this.ea = this.ea_indexed(this.cycles);
                this.vecx.vectrexNonCPUStep(3);
                this.reg_a = this.inst_and(this.reg_a, this.read8(this.ea)) & 0xFF;
                this.vecx.vectrexNonCPUStep(1);
                this.cycles.intValue += 4;
                break;
            }
            case 180: {
                this.ea = this.ea_extended();
                this.vecx.vectrexNonCPUStep(4);
                this.reg_a = this.inst_and(this.reg_a, this.read8(this.ea)) & 0xFF;
                this.vecx.vectrexNonCPUStep(1);
                this.cycles.intValue += 5;
                break;
            }
            case 196: {
                this.vecx.vectrexNonCPUStep(2);
                this.reg_b = this.inst_and(this.reg_b, this.pc_read8()) & 0xFF;
                this.cycles.intValue += 2;
                break;
            }
            case 212: {
                this.ea = this.ea_direct();
                this.vecx.vectrexNonCPUStep(3);
                this.reg_b = this.inst_and(this.reg_b, this.read8(this.ea)) & 0xFF;
                this.vecx.vectrexNonCPUStep(1);
                this.cycles.intValue += 4;
                break;
            }
            case 228: {
                this.ea = this.ea_indexed(this.cycles);
                this.vecx.vectrexNonCPUStep(3);
                this.reg_b = this.inst_and(this.reg_b, this.read8(this.ea)) & 0xFF;
                this.vecx.vectrexNonCPUStep(1);
                this.cycles.intValue += 4;
                break;
            }
            case 244: {
                this.ea = this.ea_extended();
                this.vecx.vectrexNonCPUStep(4);
                this.reg_b = this.inst_and(this.reg_b, this.read8(this.ea)) & 0xFF;
                this.vecx.vectrexNonCPUStep(1);
                this.cycles.intValue += 5;
                break;
            }
            case 133: {
                this.vecx.vectrexNonCPUStep(2);
                this.inst_and(this.reg_a, this.pc_read8());
                this.cycles.intValue += 2;
                break;
            }
            case 149: {
                this.ea = this.ea_direct();
                this.vecx.vectrexNonCPUStep(3);
                this.inst_and(this.reg_a, this.read8(this.ea));
                this.vecx.vectrexNonCPUStep(1);
                this.cycles.intValue += 4;
                break;
            }
            case 165: {
                this.ea = this.ea_indexed(this.cycles);
                this.vecx.vectrexNonCPUStep(3);
                this.inst_and(this.reg_a, this.read8(this.ea));
                this.vecx.vectrexNonCPUStep(1);
                this.cycles.intValue += 4;
                break;
            }
            case 181: {
                this.ea = this.ea_extended();
                this.vecx.vectrexNonCPUStep(4);
                this.inst_and(this.reg_a, this.read8(this.ea));
                this.vecx.vectrexNonCPUStep(1);
                this.cycles.intValue += 5;
                break;
            }
            case 197: {
                this.vecx.vectrexNonCPUStep(2);
                this.inst_and(this.reg_b, this.pc_read8());
                this.cycles.intValue += 2;
                break;
            }
            case 213: {
                this.ea = this.ea_direct();
                this.vecx.vectrexNonCPUStep(3);
                this.inst_and(this.reg_b, this.read8(this.ea));
                this.vecx.vectrexNonCPUStep(1);
                this.cycles.intValue += 4;
                break;
            }
            case 229: {
                this.ea = this.ea_indexed(this.cycles);
                this.vecx.vectrexNonCPUStep(3);
                this.inst_and(this.reg_b, this.read8(this.ea));
                this.vecx.vectrexNonCPUStep(1);
                this.cycles.intValue += 4;
                break;
            }
            case 245: {
                this.ea = this.ea_extended();
                this.vecx.vectrexNonCPUStep(4);
                this.inst_and(this.reg_b, this.read8(this.ea));
                this.vecx.vectrexNonCPUStep(1);
                this.cycles.intValue += 5;
                break;
            }
            case 134: {
                this.dataBUS = this.reg_a = this.pc_read8();
                this.vecx.vectrexNonCPUStep(2);
                this.inst_tst8(this.reg_a);
                this.cycles.intValue += 2;
                break;
            }
            case 150: {
                this.ea = this.ea_direct();
                this.vecx.vectrexNonCPUStep(3);
                this.reg_a = this.read8(this.ea);
                this.vecx.vectrexNonCPUStep(1);
                this.inst_tst8(this.reg_a);
                this.cycles.intValue += 4;
                break;
            }
            case 166: {
                this.ea = this.ea_indexed(this.cycles);
                this.vecx.vectrexNonCPUStep(3);
                this.reg_a = this.read8(this.ea);
                this.vecx.vectrexNonCPUStep(1);
                this.inst_tst8(this.reg_a);
                this.cycles.intValue += 4;
                break;
            }
            case 182: {
                this.ea = this.ea_extended();
                this.vecx.vectrexNonCPUStep(4);
                this.reg_a = this.read8(this.ea);
                this.vecx.vectrexNonCPUStep(1);
                this.inst_tst8(this.reg_a);
                this.cycles.intValue += 5;
                break;
            }
            case 198: {
                this.dataBUS = this.reg_b = this.pc_read8();
                this.vecx.vectrexNonCPUStep(2);
                this.inst_tst8(this.reg_b);
                this.cycles.intValue += 2;
                break;
            }
            case 214: {
                this.ea = this.ea_direct();
                this.vecx.vectrexNonCPUStep(3);
                this.reg_b = this.read8(this.ea);
                this.vecx.vectrexNonCPUStep(1);
                this.inst_tst8(this.reg_b);
                this.cycles.intValue += 4;
                break;
            }
            case 230: {
                this.ea = this.ea_indexed(this.cycles);
                this.vecx.vectrexNonCPUStep(3);
                this.reg_b = this.read8(this.ea);
                this.vecx.vectrexNonCPUStep(1);
                this.inst_tst8(this.reg_b);
                this.cycles.intValue += 4;
                break;
            }
            case 246: {
                this.ea = this.ea_extended();
                this.vecx.vectrexNonCPUStep(4);
                this.reg_b = this.read8(this.ea);
                this.vecx.vectrexNonCPUStep(1);
                this.inst_tst8(this.reg_b);
                this.cycles.intValue += 5;
                break;
            }
            case 151: {
                this.ea = this.ea_direct();
                this.vecx.vectrexNonCPUStep(4);
                this.write8(this.ea, this.reg_a);
                this.inst_tst8(this.reg_a);
                this.cycles.intValue += 4;
                break;
            }
            case 167: {
                this.ea = this.ea_indexed(this.cycles);
                this.vecx.vectrexNonCPUStep(4);
                this.write8(this.ea, this.reg_a);
                this.inst_tst8(this.reg_a);
                this.cycles.intValue += 4;
                break;
            }
            case 183: {
                this.ea = this.ea_extended();
                this.vecx.vectrexNonCPUStep(5);
                this.write8(this.ea, this.reg_a);
                this.inst_tst8(this.reg_a);
                this.cycles.intValue += 5;
                break;
            }
            case 215: {
                this.ea = this.ea_direct();
                this.vecx.vectrexNonCPUStep(4);
                this.write8(this.ea, this.reg_b);
                this.inst_tst8(this.reg_b);
                this.cycles.intValue += 4;
                break;
            }
            case 231: {
                this.ea = this.ea_indexed(this.cycles);
                this.vecx.vectrexNonCPUStep(4);
                this.write8(this.ea, this.reg_b);
                this.inst_tst8(this.reg_b);
                this.cycles.intValue += 4;
                break;
            }
            case 247: {
                this.ea = this.ea_extended();
                this.vecx.vectrexNonCPUStep(5);
                this.write8(this.ea, this.reg_b);
                this.inst_tst8(this.reg_b);
                this.cycles.intValue += 5;
                break;
            }
            case 136: {
                this.reg_a = this.inst_eor(this.reg_a, this.pc_read8()) & 0xFF;
                this.vecx.vectrexNonCPUStep(2);
                this.cycles.intValue += 2;
                break;
            }
            case 152: {
                this.ea = this.ea_direct();
                this.vecx.vectrexNonCPUStep(3);
                this.reg_a = this.inst_eor(this.reg_a, this.read8(this.ea)) & 0xFF;
                this.vecx.vectrexNonCPUStep(1);
                this.cycles.intValue += 4;
                break;
            }
            case 168: {
                this.ea = this.ea_indexed(this.cycles);
                this.vecx.vectrexNonCPUStep(3);
                this.reg_a = this.inst_eor(this.reg_a, this.read8(this.ea)) & 0xFF;
                this.vecx.vectrexNonCPUStep(1);
                this.cycles.intValue += 4;
                break;
            }
            case 184: {
                this.ea = this.ea_extended();
                this.vecx.vectrexNonCPUStep(4);
                this.reg_a = this.inst_eor(this.reg_a, this.read8(this.ea)) & 0xFF;
                this.vecx.vectrexNonCPUStep(1);
                this.cycles.intValue += 5;
                break;
            }
            case 200: {
                this.reg_b = this.inst_eor(this.reg_b, this.pc_read8()) & 0xFF;
                this.vecx.vectrexNonCPUStep(2);
                this.cycles.intValue += 2;
                break;
            }
            case 216: {
                this.ea = this.ea_direct();
                this.vecx.vectrexNonCPUStep(3);
                this.reg_b = this.inst_eor(this.reg_b, this.read8(this.ea)) & 0xFF;
                this.vecx.vectrexNonCPUStep(1);
                this.cycles.intValue += 4;
                break;
            }
            case 232: {
                this.ea = this.ea_indexed(this.cycles);
                this.vecx.vectrexNonCPUStep(3);
                this.reg_b = this.inst_eor(this.reg_b, this.read8(this.ea)) & 0xFF;
                this.vecx.vectrexNonCPUStep(1);
                this.cycles.intValue += 4;
                break;
            }
            case 248: {
                this.ea = this.ea_extended();
                this.vecx.vectrexNonCPUStep(4);
                this.reg_b = this.inst_eor(this.reg_b, this.read8(this.ea)) & 0xFF;
                this.vecx.vectrexNonCPUStep(1);
                this.cycles.intValue += 5;
                break;
            }
            case 137: {
                this.reg_a = this.inst_adc(this.reg_a, this.pc_read8()) & 0xFF;
                this.vecx.vectrexNonCPUStep(2);
                this.cycles.intValue += 2;
                break;
            }
            case 153: {
                this.ea = this.ea_direct();
                this.vecx.vectrexNonCPUStep(3);
                this.reg_a = this.inst_adc(this.reg_a, this.read8(this.ea)) & 0xFF;
                this.vecx.vectrexNonCPUStep(1);
                this.cycles.intValue += 4;
                break;
            }
            case 169: {
                this.ea = this.ea_indexed(this.cycles);
                this.vecx.vectrexNonCPUStep(3);
                this.reg_a = this.inst_adc(this.reg_a, this.read8(this.ea)) & 0xFF;
                this.vecx.vectrexNonCPUStep(1);
                this.cycles.intValue += 4;
                break;
            }
            case 185: {
                this.ea = this.ea_extended();
                this.vecx.vectrexNonCPUStep(4);
                this.reg_a = this.inst_adc(this.reg_a, this.read8(this.ea)) & 0xFF;
                this.vecx.vectrexNonCPUStep(1);
                this.cycles.intValue += 5;
                break;
            }
            case 201: {
                this.reg_b = this.inst_adc(this.reg_b, this.pc_read8()) & 0xFF;
                this.vecx.vectrexNonCPUStep(2);
                this.cycles.intValue += 2;
                break;
            }
            case 217: {
                this.ea = this.ea_direct();
                this.vecx.vectrexNonCPUStep(3);
                this.reg_b = this.inst_adc(this.reg_b, this.read8(this.ea)) & 0xFF;
                this.vecx.vectrexNonCPUStep(1);
                this.cycles.intValue += 4;
                break;
            }
            case 233: {
                this.ea = this.ea_indexed(this.cycles);
                this.vecx.vectrexNonCPUStep(3);
                this.reg_b = this.inst_adc(this.reg_b, this.read8(this.ea)) & 0xFF;
                this.vecx.vectrexNonCPUStep(1);
                this.cycles.intValue += 4;
                break;
            }
            case 249: {
                this.ea = this.ea_extended();
                this.vecx.vectrexNonCPUStep(4);
                this.reg_b = this.inst_adc(this.reg_b, this.read8(this.ea)) & 0xFF;
                this.vecx.vectrexNonCPUStep(1);
                this.cycles.intValue += 5;
                break;
            }
            case 138: {
                this.reg_a = this.inst_or(this.reg_a, this.pc_read8()) & 0xFF;
                this.vecx.vectrexNonCPUStep(2);
                this.cycles.intValue += 2;
                break;
            }
            case 154: {
                this.ea = this.ea_direct();
                this.vecx.vectrexNonCPUStep(3);
                this.reg_a = this.inst_or(this.reg_a, this.read8(this.ea)) & 0xFF;
                this.vecx.vectrexNonCPUStep(1);
                this.cycles.intValue += 4;
                break;
            }
            case 170: {
                this.ea = this.ea_indexed(this.cycles);
                this.vecx.vectrexNonCPUStep(3);
                this.reg_a = this.inst_or(this.reg_a, this.read8(this.ea)) & 0xFF;
                this.vecx.vectrexNonCPUStep(1);
                this.cycles.intValue += 4;
                break;
            }
            case 186: {
                this.ea = this.ea_extended();
                this.vecx.vectrexNonCPUStep(4);
                this.reg_a = this.inst_or(this.reg_a, this.read8(this.ea)) & 0xFF;
                this.vecx.vectrexNonCPUStep(1);
                this.cycles.intValue += 5;
                break;
            }
            case 202: {
                this.reg_b = this.inst_or(this.reg_b, this.pc_read8()) & 0xFF;
                this.vecx.vectrexNonCPUStep(2);
                this.cycles.intValue += 2;
                break;
            }
            case 218: {
                this.ea = this.ea_direct();
                this.vecx.vectrexNonCPUStep(3);
                this.reg_b = this.inst_or(this.reg_b, this.read8(this.ea)) & 0xFF;
                this.vecx.vectrexNonCPUStep(1);
                this.cycles.intValue += 4;
                break;
            }
            case 234: {
                this.ea = this.ea_indexed(this.cycles);
                this.vecx.vectrexNonCPUStep(3);
                this.reg_b = this.inst_or(this.reg_b, this.read8(this.ea)) & 0xFF;
                this.vecx.vectrexNonCPUStep(1);
                this.cycles.intValue += 4;
                break;
            }
            case 250: {
                this.ea = this.ea_extended();
                this.vecx.vectrexNonCPUStep(4);
                this.reg_b = this.inst_or(this.reg_b, this.read8(this.ea)) & 0xFF;
                this.vecx.vectrexNonCPUStep(1);
                this.cycles.intValue += 5;
                break;
            }
            case 139: {
                this.reg_a = this.inst_add8(this.reg_a, this.pc_read8()) & 0xFF;
                this.vecx.vectrexNonCPUStep(2);
                this.cycles.intValue += 2;
                break;
            }
            case 155: {
                this.ea = this.ea_direct();
                this.vecx.vectrexNonCPUStep(3);
                this.reg_a = this.inst_add8(this.reg_a, this.read8(this.ea)) & 0xFF;
                this.vecx.vectrexNonCPUStep(1);
                this.cycles.intValue += 4;
                break;
            }
            case 171: {
                this.ea = this.ea_indexed(this.cycles);
                this.vecx.vectrexNonCPUStep(3);
                this.reg_a = this.inst_add8(this.reg_a, this.read8(this.ea)) & 0xFF;
                this.vecx.vectrexNonCPUStep(1);
                this.cycles.intValue += 4;
                break;
            }
            case 187: {
                this.ea = this.ea_extended();
                this.vecx.vectrexNonCPUStep(4);
                this.reg_a = this.inst_add8(this.reg_a, this.read8(this.ea)) & 0xFF;
                this.vecx.vectrexNonCPUStep(1);
                this.cycles.intValue += 5;
                break;
            }
            case 203: {
                this.reg_b = this.inst_add8(this.reg_b, this.pc_read8()) & 0xFF;
                this.vecx.vectrexNonCPUStep(2);
                this.cycles.intValue += 2;
                break;
            }
            case 219: {
                this.ea = this.ea_direct();
                this.vecx.vectrexNonCPUStep(3);
                this.reg_b = this.inst_add8(this.reg_b, this.read8(this.ea)) & 0xFF;
                this.vecx.vectrexNonCPUStep(1);
                this.cycles.intValue += 4;
                break;
            }
            case 235: {
                this.ea = this.ea_indexed(this.cycles);
                this.vecx.vectrexNonCPUStep(3);
                this.reg_b = this.inst_add8(this.reg_b, this.read8(this.ea)) & 0xFF;
                this.vecx.vectrexNonCPUStep(1);
                this.cycles.intValue += 4;
                break;
            }
            case 251: {
                this.ea = this.ea_extended();
                this.vecx.vectrexNonCPUStep(4);
                this.reg_b = this.inst_add8(this.reg_b, this.read8(this.ea)) & 0xFF;
                this.vecx.vectrexNonCPUStep(1);
                this.cycles.intValue += 5;
                break;
            }
            case 131: {
                this.set_reg_d(this.inst_sub16(this.get_reg_d(), this.pc_read16()));
                this.vecx.vectrexNonCPUStep(4);
                this.cycles.intValue += 4;
                break;
            }
            case 147: {
                this.ea = this.ea_direct();
                this.vecx.vectrexNonCPUStep(4);
                this.set_reg_d(this.inst_sub16(this.get_reg_d(), this.read16(this.ea)));
                this.vecx.vectrexNonCPUStep(2);
                this.cycles.intValue += 6;
                break;
            }
            case 163: {
                this.ea = this.ea_indexed(this.cycles);
                this.vecx.vectrexNonCPUStep(4);
                this.set_reg_d(this.inst_sub16(this.get_reg_d(), this.read16(this.ea)));
                this.vecx.vectrexNonCPUStep(2);
                this.cycles.intValue += 6;
                break;
            }
            case 179: {
                this.ea = this.ea_extended();
                this.vecx.vectrexNonCPUStep(5);
                this.set_reg_d(this.inst_sub16(this.get_reg_d(), this.read16(this.ea)));
                this.vecx.vectrexNonCPUStep(2);
                this.cycles.intValue += 7;
                break;
            }
            case 140: {
                this.inst_sub16(this.reg_x, this.pc_read16());
                this.vecx.vectrexNonCPUStep(4);
                this.cycles.intValue += 4;
                break;
            }
            case 156: {
                this.ea = this.ea_direct();
                this.vecx.vectrexNonCPUStep(4);
                this.inst_sub16(this.reg_x, this.read16(this.ea));
                this.vecx.vectrexNonCPUStep(2);
                this.cycles.intValue += 6;
                break;
            }
            case 172: {
                this.ea = this.ea_indexed(this.cycles);
                this.vecx.vectrexNonCPUStep(4);
                this.inst_sub16(this.reg_x, this.read16(this.ea));
                this.vecx.vectrexNonCPUStep(2);
                this.cycles.intValue += 6;
                break;
            }
            case 188: {
                this.ea = this.ea_extended();
                this.vecx.vectrexNonCPUStep(5);
                this.inst_sub16(this.reg_x, this.read16(this.ea));
                this.vecx.vectrexNonCPUStep(2);
                this.cycles.intValue += 7;
                break;
            }
            case 142: {
                this.reg_x = this.pc_read16();
                this.inst_tst16(this.reg_x);
                this.vecx.vectrexNonCPUStep(3);
                this.cycles.intValue += 3;
                break;
            }
            case 158: {
                this.ea = this.ea_direct();
                this.reg_x = this.read16(this.ea);
                this.vecx.vectrexNonCPUStep(5);
                this.inst_tst16(this.reg_x);
                this.cycles.intValue += 5;
                break;
            }
            case 174: {
                this.ea = this.ea_indexed(this.cycles);
                this.reg_x = this.read16(this.ea);
                this.inst_tst16(this.reg_x);
                this.vecx.vectrexNonCPUStep(5);
                this.cycles.intValue += 5;
                break;
            }
            case 190: {
                this.ea = this.ea_extended();
                this.reg_x = this.read16(this.ea);
                this.inst_tst16(this.reg_x);
                this.vecx.vectrexNonCPUStep(6);
                this.cycles.intValue += 6;
                break;
            }
            case 206: {
                this.reg_u.intValue = this.pc_read16();
                this.inst_tst16(this.reg_u.intValue);
                this.vecx.vectrexNonCPUStep(3);
                this.cycles.intValue += 3;
                break;
            }
            case 222: {
                this.ea = this.ea_direct();
                this.reg_u.intValue = this.read16(this.ea);
                this.inst_tst16(this.reg_u.intValue);
                this.vecx.vectrexNonCPUStep(5);
                this.cycles.intValue += 5;
                break;
            }
            case 238: {
                this.ea = this.ea_indexed(this.cycles);
                this.reg_u.intValue = this.read16(this.ea);
                this.inst_tst16(this.reg_u.intValue);
                this.vecx.vectrexNonCPUStep(5);
                this.cycles.intValue += 5;
                break;
            }
            case 254: {
                this.ea = this.ea_extended();
                this.reg_u.intValue = this.read16(this.ea);
                this.inst_tst16(this.reg_u.intValue);
                this.vecx.vectrexNonCPUStep(6);
                this.cycles.intValue += 6;
                break;
            }
            case 159: {
                this.ea = this.ea_direct();
                if (NO_SHADOW_STEP) {
                    this.vecx.vectrexNonCPUStep(4);
                    this.write16_cycloid(this.ea, this.reg_x);
                    this.inst_tst16(this.reg_x);
                } else if (RC3) {
                    this.vecx.vectrexNonCPUStep(4);
                    this.write16_cycloid(this.ea, this.reg_x);
                    this.inst_tst16(this.reg_x);
                } else {
                    if (R251_error) {
                        this.vecx.vectrexNonCPUStep(4);
                    } else {
                        this.vecx.vectrexNonCPUStep(3);
                    }
                    this.write16_cycloid(this.ea, this.reg_x);
                    this.inst_tst16(this.reg_x);
                    this.vecx.vectrexNonCPUStep(1);
                }
                this.cycles.intValue += 5;
                break;
            }
            case 175: {
                if (NO_SHADOW_STEP) {
                    this.ea = this.ea_indexed(this.cycles);
                    this.vecx.vectrexNonCPUStep(4);
                    this.write16_cycloid(this.ea, this.reg_x);
                    this.inst_tst16(this.reg_x);
                } else {
                    this.ea = this.ea_indexed(this.cycles);
                    this.vecx.vectrexNonCPUStep(3);
                    this.write16_cycloid(this.ea, this.reg_x);
                    this.inst_tst16(this.reg_x);
                    this.vecx.vectrexNonCPUStep(1);
                }
                this.cycles.intValue += 5;
                break;
            }
            case 191: {
                this.ea = this.ea_extended();
                if (NO_SHADOW_STEP) {
                    this.vecx.vectrexNonCPUStep(5);
                    this.write16_cycloid(this.ea, this.reg_x);
                    this.inst_tst16(this.reg_x);
                } else if (RC3) {
                    this.vecx.vectrexNonCPUStep(5);
                    this.write16_cycloid(this.ea, this.reg_x);
                    this.inst_tst16(this.reg_x);
                } else {
                    this.vecx.vectrexNonCPUStep(4);
                    this.write16_cycloid(this.ea, this.reg_x);
                    this.inst_tst16(this.reg_x);
                    this.vecx.vectrexNonCPUStep(1);
                }
                this.cycles.intValue += 6;
                break;
            }
            case 223: {
                this.ea = this.ea_direct();
                if (NO_SHADOW_STEP) {
                    this.vecx.vectrexNonCPUStep(4);
                    this.write16_cycloid(this.ea, this.reg_u.intValue);
                    this.inst_tst16(this.reg_u.intValue);
                } else if (RC3) {
                    this.vecx.vectrexNonCPUStep(4);
                    this.write16_cycloid(this.ea, this.reg_u.intValue);
                    this.inst_tst16(this.reg_u.intValue);
                } else {
                    this.vecx.vectrexNonCPUStep(3);
                    this.write16_cycloid(this.ea, this.reg_u.intValue);
                    this.inst_tst16(this.reg_u.intValue);
                    this.vecx.vectrexNonCPUStep(1);
                }
                this.cycles.intValue += 5;
                break;
            }
            case 239: {
                this.ea = this.ea_indexed(this.cycles);
                if (NO_SHADOW_STEP) {
                    this.vecx.vectrexNonCPUStep(4);
                    this.write16_cycloid(this.ea, this.reg_u.intValue);
                    this.inst_tst16(this.reg_u.intValue);
                } else if (RC3) {
                    this.vecx.vectrexNonCPUStep(4);
                    this.write16_cycloid(this.ea, this.reg_u.intValue);
                    this.inst_tst16(this.reg_u.intValue);
                } else {
                    this.vecx.vectrexNonCPUStep(3);
                    this.write16_cycloid(this.ea, this.reg_u.intValue);
                    this.inst_tst16(this.reg_u.intValue);
                    this.vecx.vectrexNonCPUStep(1);
                }
                this.cycles.intValue += 5;
                break;
            }
            case 255: {
                this.ea = this.ea_extended();
                if (NO_SHADOW_STEP) {
                    this.vecx.vectrexNonCPUStep(5);
                    this.write16_cycloid(this.ea, this.reg_u.intValue);
                    this.inst_tst16(this.reg_u.intValue);
                } else if (RC3) {
                    this.vecx.vectrexNonCPUStep(5);
                    this.write16_cycloid(this.ea, this.reg_u.intValue);
                    this.inst_tst16(this.reg_u.intValue);
                } else {
                    this.vecx.vectrexNonCPUStep(4);
                    this.write16_cycloid(this.ea, this.reg_u.intValue);
                    this.inst_tst16(this.reg_u.intValue);
                    this.vecx.vectrexNonCPUStep(1);
                }
                this.cycles.intValue += 6;
                break;
            }
            case 195: {
                this.set_reg_d(this.inst_add16(this.get_reg_d(), this.pc_read16()));
                this.vecx.vectrexNonCPUStep(4);
                this.cycles.intValue += 4;
                break;
            }
            case 211: {
                this.ea = this.ea_direct();
                this.vecx.vectrexNonCPUStep(3);
                this.set_reg_d(this.inst_add16(this.get_reg_d(), this.read16(this.ea)));
                this.vecx.vectrexNonCPUStep(3);
                this.cycles.intValue += 6;
                break;
            }
            case 227: {
                this.ea = this.ea_indexed(this.cycles);
                this.vecx.vectrexNonCPUStep(3);
                this.set_reg_d(this.inst_add16(this.get_reg_d(), this.read16(this.ea)));
                this.vecx.vectrexNonCPUStep(3);
                this.cycles.intValue += 6;
                break;
            }
            case 243: {
                this.ea = this.ea_extended();
                this.vecx.vectrexNonCPUStep(4);
                this.set_reg_d(this.inst_add16(this.get_reg_d(), this.read16(this.ea)));
                this.vecx.vectrexNonCPUStep(3);
                this.cycles.intValue += 7;
                break;
            }
            case 204: {
                this.set_reg_d(this.pc_read16());
                this.vecx.vectrexNonCPUStep(3);
                this.inst_tst16(this.get_reg_d());
                this.cycles.intValue += 3;
                break;
            }
            case 220: {
                this.ea = this.ea_direct();
                if (NO_SHADOW_STEP) {
                    this.vecx.vectrexNonCPUStep(4);
                    this.set_reg_d(this.read16_cycloid(this.ea));
                    this.inst_tst16(this.get_reg_d());
                } else if (RC3) {
                    this.vecx.vectrexNonCPUStep(3);
                    this.set_reg_d(this.read16_cycloid(this.ea));
                    this.vecx.vectrexNonCPUStep(1);
                    this.inst_tst16(this.get_reg_d());
                } else {
                    this.vecx.vectrexNonCPUStep(3);
                    this.set_reg_d(this.read16_cycloid(this.ea));
                    if (R251_error) {
                        this.vecx.vectrexNonCPUStep(2);
                    } else {
                        this.vecx.vectrexNonCPUStep(1);
                    }
                    this.inst_tst16(this.get_reg_d());
                }
                this.cycles.intValue += 5;
                break;
            }
            case 236: {
                this.ea = this.ea_indexed(this.cycles);
                if (NO_SHADOW_STEP) {
                    this.vecx.vectrexNonCPUStep(4);
                    this.set_reg_d(this.read16_cycloid(this.ea));
                    this.inst_tst16(this.get_reg_d());
                } else if (RC3) {
                    this.vecx.vectrexNonCPUStep(3);
                    this.set_reg_d(this.read16_cycloid(this.ea));
                    this.vecx.vectrexNonCPUStep(1);
                    this.inst_tst16(this.get_reg_d());
                } else {
                    this.vecx.vectrexNonCPUStep(3);
                    this.set_reg_d(this.read16_cycloid(this.ea));
                    if (R251_error) {
                        this.vecx.vectrexNonCPUStep(2);
                    } else {
                        this.vecx.vectrexNonCPUStep(1);
                    }
                    this.inst_tst16(this.get_reg_d());
                }
                this.cycles.intValue += 5;
                break;
            }
            case 252: {
                this.ea = this.ea_extended();
                if (NO_SHADOW_STEP) {
                    this.vecx.vectrexNonCPUStep(5);
                    this.set_reg_d(this.read16_cycloid(this.ea));
                    this.inst_tst16(this.get_reg_d());
                } else if (RC3) {
                    this.vecx.vectrexNonCPUStep(5);
                    this.set_reg_d(this.read16_cycloid(this.ea));
                    this.inst_tst16(this.get_reg_d());
                } else {
                    this.vecx.vectrexNonCPUStep(4);
                    this.set_reg_d(this.read16_cycloid(this.ea));
                    if (R251_error) {
                        this.vecx.vectrexNonCPUStep(2);
                    } else {
                        this.vecx.vectrexNonCPUStep(1);
                    }
                    this.inst_tst16(this.get_reg_d());
                }
                this.cycles.intValue += 6;
                break;
            }
            case 221: {
                this.ea = this.ea_direct();
                this.vecx.vectrexNonCPUStep(4);
                if (NO_SHADOW_STEP) {
                    this.write16_cycloid(this.ea, this.get_reg_d());
                } else {
                    this.write16_cycloid(this.ea, this.get_reg_d());
                }
                this.inst_tst16(this.get_reg_d());
                this.cycles.intValue += 5;
                break;
            }
            case 237: {
                this.ea = this.ea_indexed(this.cycles);
                this.vecx.vectrexNonCPUStep(4);
                if (NO_SHADOW_STEP) {
                    this.write16_cycloid(this.ea, this.get_reg_d());
                } else {
                    this.write16_cycloid(this.ea, this.get_reg_d());
                }
                this.inst_tst16(this.get_reg_d());
                this.cycles.intValue += 5;
                break;
            }
            case 253: {
                this.ea = this.ea_extended();
                this.vecx.vectrexNonCPUStep(5);
                if (NO_SHADOW_STEP) {
                    this.write16_cycloid(this.ea, this.get_reg_d());
                } else {
                    this.write16_cycloid(this.ea, this.get_reg_d());
                }
                this.inst_tst16(this.get_reg_d());
                this.cycles.intValue += 6;
                break;
            }
            case 18: {
                this.vecx.vectrexNonCPUStep(2);
                this.cycles.intValue += 2;
                break;
            }
            case 61: {
                this.r = (this.reg_a & 0xFF) * (this.reg_b & 0xFF);
                this.set_reg_d(this.r);
                this.set_cc(4, this.test_z16(this.r));
                this.set_cc(1, (this.r & 0x80) == 128);
                this.vecx.vectrexNonCPUStep(11);
                this.cycles.intValue += 11;
                break;
            }
            case 32: 
            case 33: {
                this.inst_bra8(false, this.op, this.cycles);
                this.vecx.vectrexNonCPUStep(3);
                break;
            }
            case 34: 
            case 35: {
                this.inst_bra8((this.reg_cc & 1) == 1 | (this.reg_cc & 4) == 4, this.op, this.cycles);
                this.vecx.vectrexNonCPUStep(3);
                break;
            }
            case 36: 
            case 37: {
                this.inst_bra8((this.reg_cc & 1) == 1, this.op, this.cycles);
                this.vecx.vectrexNonCPUStep(3);
                break;
            }
            case 38: 
            case 39: {
                this.inst_bra8((this.reg_cc & 4) == 4, this.op, this.cycles);
                this.vecx.vectrexNonCPUStep(3);
                break;
            }
            case 40: 
            case 41: {
                this.inst_bra8((this.reg_cc & 2) == 2, this.op, this.cycles);
                this.vecx.vectrexNonCPUStep(3);
                break;
            }
            case 42: 
            case 43: {
                this.inst_bra8((this.reg_cc & 8) == 8, this.op, this.cycles);
                this.vecx.vectrexNonCPUStep(3);
                break;
            }
            case 44: 
            case 45: {
                this.inst_bra8((this.reg_cc & 8) == 8 ^ (this.reg_cc & 2) == 2, this.op, this.cycles);
                this.vecx.vectrexNonCPUStep(3);
                break;
            }
            case 46: 
            case 47: {
                this.inst_bra8((this.reg_cc & 4) == 4 | (this.reg_cc & 8) == 8 ^ (this.reg_cc & 2) == 2, this.op, this.cycles);
                this.vecx.vectrexNonCPUStep(3);
                break;
            }
            case 22: {
                this.r = this.pc_read16();
                this.reg_pc = this.reg_pc + this.r & 0xFFFF;
                this.cycles.intValue += 5;
                this.vecx.vectrexNonCPUStep(5);
                break;
            }
            case 23: {
                this.r = this.pc_read16();
                this.push16(this.reg_s, this.reg_pc);
                if (this.reg_s.intValue < this.lowestStackValue) {
                    this.lowestStackValue = this.reg_s.intValue;
                }
                ArrayList arrayList = this.callStack;
                synchronized (arrayList) {
                    this.callStack.add(this.reg_pc & 0xFFFF);
                }
                this.reg_pc = this.reg_pc + this.r & 0xFFFF;
                this.vecx.vectrexNonCPUStep(9);
                this.cycles.intValue += 9;
                break;
            }
            case 141: {
                this.r = this.pc_read8();
                this.push16(this.reg_s, this.reg_pc);
                if (this.reg_s.intValue < this.lowestStackValue) {
                    this.lowestStackValue = this.reg_s.intValue;
                }
                ArrayList arrayList = this.callStack;
                synchronized (arrayList) {
                    this.callStack.add(this.reg_pc & 0xFFFF);
                }
                if (this.profiler != null) {
                    this.profiler.addContext(this.reg_pc + this.sign_extend(this.r) & 0xFFFF, this.reg_s.intValue, this.reg_pc & 0xFFFF, this.orgPC & 0xFFFF);
                }
                this.vecx.vectrexNonCPUStep(7);
                this.reg_pc = this.reg_pc + this.sign_extend(this.r) & 0xFFFF;
                this.cycles.intValue += 7;
                break;
            }
            case 157: {
                this.ea = this.ea_direct();
                this.push16(this.reg_s, this.reg_pc);
                if (this.reg_s.intValue < this.lowestStackValue) {
                    this.lowestStackValue = this.reg_s.intValue;
                }
                ArrayList arrayList = this.callStack;
                synchronized (arrayList) {
                    this.callStack.add(this.reg_pc & 0xFFFF);
                }
                if (this.profiler != null) {
                    this.profiler.addContext(this.ea, this.reg_s.intValue, this.reg_pc & 0xFFFF, this.orgPC & 0xFFFF);
                }
                this.vecx.vectrexNonCPUStep(7);
                this.reg_pc = this.ea;
                this.cycles.intValue += 7;
                break;
            }
            case 173: {
                this.ea = this.ea_indexed(this.cycles);
                this.push16(this.reg_s, this.reg_pc);
                if (this.reg_s.intValue < this.lowestStackValue) {
                    this.lowestStackValue = this.reg_s.intValue;
                }
                ArrayList arrayList = this.callStack;
                synchronized (arrayList) {
                    this.callStack.add(this.reg_pc & 0xFFFF);
                }
                if (this.profiler != null) {
                    this.profiler.addContext(this.ea, this.reg_s.intValue, this.reg_pc & 0xFFFF, this.orgPC & 0xFFFF);
                }
                this.vecx.vectrexNonCPUStep(7);
                this.reg_pc = this.ea;
                this.cycles.intValue += 7;
                break;
            }
            case 189: {
                this.ea = this.ea_extended();
                this.push16(this.reg_s, this.reg_pc);
                if (this.reg_s.intValue < this.lowestStackValue) {
                    this.lowestStackValue = this.reg_s.intValue;
                }
                ArrayList arrayList = this.callStack;
                synchronized (arrayList) {
                    this.callStack.add(this.reg_pc & 0xFFFF);
                }
                if (this.profiler != null) {
                    this.profiler.addContext(this.ea, this.reg_s.intValue, this.reg_pc & 0xFFFF, this.orgPC & 0xFFFF);
                }
                this.vecx.vectrexNonCPUStep(8);
                this.reg_pc = this.ea;
                this.cycles.intValue += 8;
                break;
            }
            case 48: {
                this.reg_x = this.ea_indexed(this.cycles);
                this.set_cc(4, this.test_z16(this.reg_x));
                this.vecx.vectrexNonCPUStep(4);
                this.cycles.intValue += 4;
                break;
            }
            case 49: {
                this.reg_y = this.ea_indexed(this.cycles);
                this.set_cc(4, this.test_z16(this.reg_y));
                this.vecx.vectrexNonCPUStep(4);
                this.cycles.intValue += 4;
                break;
            }
            case 50: {
                this.reg_s.intValue = this.ea_indexed(this.cycles);
                if (this.reg_s.intValue < this.lowestStackValue) {
                    this.lowestStackValue = this.reg_s.intValue;
                }
                this.vecx.vectrexNonCPUStep(4);
                this.cycles.intValue += 4;
                break;
            }
            case 51: {
                this.reg_u.intValue = this.ea_indexed(this.cycles);
                this.vecx.vectrexNonCPUStep(4);
                this.cycles.intValue += 4;
                break;
            }
            case 52: {
                this.inst_psh(this.pc_read8(), this.reg_s, this.reg_u, this.cycles);
                if (this.reg_s.intValue < this.lowestStackValue) {
                    this.lowestStackValue = this.reg_s.intValue;
                }
                this.vecx.vectrexNonCPUStep(5);
                this.cycles.intValue += 5;
                break;
            }
            case 53: {
                this.inst_pul(this.pc_read8(), this.reg_s, this.reg_u, this.cycles);
                if (this.reg_s.intValue < this.lowestStackValue) {
                    this.lowestStackValue = this.reg_s.intValue;
                }
                this.cycles.intValue += 5;
                this.vecx.vectrexNonCPUStep(5);
                break;
            }
            case 54: {
                this.inst_psh(this.pc_read8(), this.reg_u, this.reg_s, this.cycles);
                this.cycles.intValue += 5;
                this.vecx.vectrexNonCPUStep(5);
                break;
            }
            case 55: {
                this.inst_pul(this.pc_read8(), this.reg_u, this.reg_s, this.cycles);
                if (this.reg_s.intValue < this.lowestStackValue) {
                    this.lowestStackValue = this.reg_s.intValue;
                }
                this.cycles.intValue += 5;
                this.vecx.vectrexNonCPUStep(5);
                break;
            }
            case 57: {
                this.reg_pc = this.pull16(this.reg_s);
                if (this.reg_s.intValue < this.lowestStackValue) {
                    this.lowestStackValue = this.reg_s.intValue;
                }
                ArrayList arrayList = this.callStack;
                synchronized (arrayList) {
                    if (this.callStack.size() > 0) {
                        this.callStack.remove(this.callStack.size() - 1);
                    }
                }
                this.vecx.vectrexNonCPUStep(5);
                this.cycles.intValue += 5;
                break;
            }
            case 58: {
                this.reg_x += this.reg_b & 0xFF;
                this.vecx.vectrexNonCPUStep(3);
                this.cycles.intValue += 3;
                break;
            }
            case 26: {
                this.reg_cc |= this.pc_read8();
                this.vecx.vectrexNonCPUStep(3);
                this.cycles.intValue += 3;
                break;
            }
            case 28: {
                this.reg_cc &= this.pc_read8();
                this.vecx.vectrexNonCPUStep(3);
                this.cycles.intValue += 3;
                break;
            }
            case 29: {
                this.set_reg_d(this.sign_extend(this.reg_b));
                this.set_cc(8, this.test_n(this.reg_a));
                this.set_cc(4, this.test_z16(this.get_reg_d()));
                this.vecx.vectrexNonCPUStep(2);
                this.cycles.intValue += 2;
                break;
            }
            case 30: {
                this.inst_exg();
                if (this.reg_s.intValue < this.lowestStackValue) {
                    this.lowestStackValue = this.reg_s.intValue;
                }
                this.vecx.vectrexNonCPUStep(8);
                this.cycles.intValue += 8;
                break;
            }
            case 31: {
                this.inst_tfr();
                if (this.reg_s.intValue < this.lowestStackValue) {
                    this.lowestStackValue = this.reg_s.intValue;
                }
                this.vecx.vectrexNonCPUStep(6);
                this.cycles.intValue += 6;
                break;
            }
            case 59: {
                this.inst_pul(1, this.reg_s, this.reg_u, this.cycles);
                if ((this.reg_cc & 0x80) == 128) {
                    this.inst_pul(254, this.reg_s, this.reg_u, this.cycles);
                } else {
                    this.inst_pul(128, this.reg_s, this.reg_u, this.cycles);
                }
                if (this.reg_s.intValue < this.lowestStackValue) {
                    this.lowestStackValue = this.reg_s.intValue;
                }
                this.vecx.vectrexNonCPUStep(3);
                this.cycles.intValue += 3;
                break;
            }
            case 63: {
                this.set_cc(128, true);
                this.inst_psh(255, this.reg_s, this.reg_u, this.cycles);
                this.set_cc(16, true);
                this.set_cc(64, true);
                this.reg_pc = this.read16(65530);
                this.vecx.vectrexNonCPUStep(7);
                if (this.reg_s.intValue < this.lowestStackValue) {
                    this.lowestStackValue = this.reg_s.intValue;
                }
                this.cycles.intValue += 7;
                break;
            }
            case 19: {
                this.irq_status = 1;
                this.cycles.intValue += 2;
                this.vecx.vectrexNonCPUStep(2);
                break;
            }
            case 25: {
                this.i0 = this.reg_a;
                this.i1 = 0;
                if ((this.reg_a & 0xF) > 9 || (this.reg_cc & 0x20) == 32) {
                    this.i1 |= 6;
                }
                if ((this.reg_a & 0xF0) > 128 && (this.reg_a & 0xF) > 9) {
                    this.i1 |= 0x60;
                }
                if ((this.reg_a & 0xF0) > 144 || (this.reg_cc & 1) == 1) {
                    this.i1 |= 0x60;
                }
                this.reg_a = this.i0 + this.i1 & 0xFF;
                this.set_cc(8, this.test_n(this.reg_a));
                this.set_cc(4, this.test_z8(this.reg_a));
                this.reg_cc &= 0xFFFFFFFD;
                this.set_cc(1, this.test_c(this.i0, this.i1, this.reg_a, false));
                this.vecx.vectrexNonCPUStep(2);
                this.cycles.intValue += 2;
                break;
            }
            case 60: {
                this.reg_cc &= this.pc_read8();
                this.set_cc(128, true);
                this.inst_psh(255, this.reg_s, this.reg_u, this.cycles);
                this.irq_status = 2;
                this.vecx.vectrexNonCPUStep(4);
                this.cycles.intValue += 4;
                if (this.reg_s.intValue >= this.lowestStackValue) break;
                this.lowestStackValue = this.reg_s.intValue;
                break;
            }
            case 16: {
                this.op = this.pc_read8();
                switch (this.op) {
                    case 32: 
                    case 33: {
                        this.inst_bra16(false, this.op, this.cycles);
                        break block12;
                    }
                    case 34: 
                    case 35: {
                        this.inst_bra16((this.reg_cc & 1) == 1 | (this.reg_cc & 4) == 4, this.op, this.cycles);
                        break block12;
                    }
                    case 36: 
                    case 37: {
                        this.inst_bra16((this.reg_cc & 1) == 1, this.op, this.cycles);
                        break block12;
                    }
                    case 38: 
                    case 39: {
                        this.inst_bra16((this.reg_cc & 4) == 4, this.op, this.cycles);
                        break block12;
                    }
                    case 40: 
                    case 41: {
                        this.inst_bra16((this.reg_cc & 2) == 2, this.op, this.cycles);
                        break block12;
                    }
                    case 42: 
                    case 43: {
                        this.inst_bra16((this.reg_cc & 8) == 8, this.op, this.cycles);
                        break block12;
                    }
                    case 44: 
                    case 45: {
                        this.inst_bra16((this.reg_cc & 8) == 8 ^ (this.reg_cc & 2) == 2, this.op, this.cycles);
                        break block12;
                    }
                    case 46: 
                    case 47: {
                        this.inst_bra16((this.reg_cc & 4) == 4 | (this.reg_cc & 8) == 8 ^ (this.reg_cc & 2) == 2, this.op, this.cycles);
                        break block12;
                    }
                    case 131: {
                        this.vecx.vectrexNonCPUStep(4);
                        this.inst_sub16(this.get_reg_d(), this.pc_read16());
                        this.vecx.vectrexNonCPUStep(1);
                        this.cycles.intValue += 5;
                        break block12;
                    }
                    case 147: {
                        this.ea = this.ea_direct();
                        if (NO_SHADOW_STEP) {
                            this.vecx.vectrexNonCPUStep(6);
                            this.inst_sub16(this.get_reg_d(), this.read16_cycloid(this.ea));
                        } else if (RC3) {
                            this.vecx.vectrexNonCPUStep(5);
                            this.inst_sub16(this.get_reg_d(), this.read16_cycloid(this.ea));
                            this.vecx.vectrexNonCPUStep(1);
                        } else {
                            this.vecx.vectrexNonCPUStep(6);
                            this.inst_sub16(this.get_reg_d(), this.read16_cycloid(this.ea));
                            this.vecx.vectrexNonCPUStep(1);
                        }
                        this.cycles.intValue += 7;
                        break block12;
                    }
                    case 163: {
                        this.ea = this.ea_indexed(this.cycles);
                        if (NO_SHADOW_STEP) {
                            this.vecx.vectrexNonCPUStep(6);
                            this.inst_sub16(this.get_reg_d(), this.read16_cycloid(this.ea));
                        } else if (RC3) {
                            this.vecx.vectrexNonCPUStep(5);
                            this.inst_sub16(this.get_reg_d(), this.read16_cycloid(this.ea));
                            this.vecx.vectrexNonCPUStep(1);
                        } else {
                            this.vecx.vectrexNonCPUStep(6);
                            this.inst_sub16(this.get_reg_d(), this.read16_cycloid(this.ea));
                            this.vecx.vectrexNonCPUStep(1);
                        }
                        this.cycles.intValue += 7;
                        break block12;
                    }
                    case 179: {
                        this.ea = this.ea_extended();
                        if (NO_SHADOW_STEP) {
                            this.vecx.vectrexNonCPUStep(7);
                            this.inst_sub16(this.get_reg_d(), this.read16_cycloid(this.ea));
                        } else if (RC3) {
                            this.vecx.vectrexNonCPUStep(6);
                            this.inst_sub16(this.get_reg_d(), this.read16_cycloid(this.ea));
                            this.vecx.vectrexNonCPUStep(1);
                        } else {
                            this.vecx.vectrexNonCPUStep(7);
                            this.inst_sub16(this.get_reg_d(), this.read16_cycloid(this.ea));
                            this.vecx.vectrexNonCPUStep(1);
                        }
                        this.cycles.intValue += 8;
                        break block12;
                    }
                    case 140: {
                        this.inst_sub16(this.reg_y, this.pc_read16());
                        this.vecx.vectrexNonCPUStep(5);
                        this.cycles.intValue += 5;
                        break block12;
                    }
                    case 156: {
                        this.ea = this.ea_direct();
                        this.vecx.vectrexNonCPUStep(6);
                        this.inst_sub16(this.reg_y, this.read16(this.ea));
                        this.vecx.vectrexNonCPUStep(1);
                        this.cycles.intValue += 7;
                        break block12;
                    }
                    case 172: {
                        this.ea = this.ea_indexed(this.cycles);
                        this.vecx.vectrexNonCPUStep(6);
                        this.inst_sub16(this.reg_y, this.read16(this.ea));
                        this.vecx.vectrexNonCPUStep(1);
                        this.cycles.intValue += 7;
                        break block12;
                    }
                    case 188: {
                        this.ea = this.ea_extended();
                        this.vecx.vectrexNonCPUStep(7);
                        this.inst_sub16(this.reg_y, this.read16(this.ea));
                        this.vecx.vectrexNonCPUStep(1);
                        this.cycles.intValue += 8;
                        break block12;
                    }
                    case 142: {
                        this.reg_y = this.pc_read16();
                        this.vecx.vectrexNonCPUStep(3);
                        this.inst_tst16(this.reg_y);
                        this.vecx.vectrexNonCPUStep(1);
                        this.cycles.intValue += 4;
                        break block12;
                    }
                    case 158: {
                        this.ea = this.ea_direct();
                        this.vecx.vectrexNonCPUStep(5);
                        this.reg_y = this.read16(this.ea);
                        this.vecx.vectrexNonCPUStep(1);
                        this.inst_tst16(this.reg_y);
                        this.cycles.intValue += 6;
                        break block12;
                    }
                    case 174: {
                        this.ea = this.ea_indexed(this.cycles);
                        this.vecx.vectrexNonCPUStep(5);
                        this.reg_y = this.read16(this.ea);
                        this.inst_tst16(this.reg_y);
                        this.vecx.vectrexNonCPUStep(1);
                        this.cycles.intValue += 6;
                        break block12;
                    }
                    case 190: {
                        this.ea = this.ea_extended();
                        this.vecx.vectrexNonCPUStep(6);
                        this.reg_y = this.read16(this.ea);
                        this.vecx.vectrexNonCPUStep(1);
                        this.inst_tst16(this.reg_y);
                        this.cycles.intValue += 7;
                        break block12;
                    }
                    case 159: {
                        this.ea = this.ea_direct();
                        this.vecx.vectrexNonCPUStep(4);
                        this.write16(this.ea, this.reg_y);
                        this.vecx.vectrexNonCPUStep(2);
                        this.inst_tst16(this.reg_y);
                        this.cycles.intValue += 6;
                        break block12;
                    }
                    case 175: {
                        this.ea = this.ea_indexed(this.cycles);
                        this.vecx.vectrexNonCPUStep(4);
                        this.write16(this.ea, this.reg_y);
                        this.vecx.vectrexNonCPUStep(2);
                        this.inst_tst16(this.reg_y);
                        this.cycles.intValue += 6;
                        break block12;
                    }
                    case 191: {
                        this.ea = this.ea_extended();
                        this.vecx.vectrexNonCPUStep(5);
                        this.write16(this.ea, this.reg_y);
                        this.vecx.vectrexNonCPUStep(2);
                        this.inst_tst16(this.reg_y);
                        this.cycles.intValue += 7;
                        break block12;
                    }
                    case 206: {
                        this.reg_s.intValue = this.pc_read16();
                        this.vecx.vectrexNonCPUStep(3);
                        this.inst_tst16(this.reg_s.intValue);
                        if (this.reg_s.intValue < this.lowestStackValue) {
                            this.lowestStackValue = this.reg_s.intValue;
                        }
                        this.vecx.vectrexNonCPUStep(1);
                        this.cycles.intValue += 4;
                        this.resetCallstack();
                        break block12;
                    }
                    case 222: {
                        this.ea = this.ea_direct();
                        this.vecx.vectrexNonCPUStep(5);
                        this.reg_s.intValue = this.read16(this.ea);
                        if (this.reg_s.intValue < this.lowestStackValue) {
                            this.lowestStackValue = this.reg_s.intValue;
                        }
                        this.vecx.vectrexNonCPUStep(1);
                        this.inst_tst16(this.reg_s.intValue);
                        this.cycles.intValue += 6;
                        this.resetCallstack();
                        break block12;
                    }
                    case 238: {
                        this.ea = this.ea_indexed(this.cycles);
                        this.reg_s.intValue = this.read16(this.ea);
                        if (this.reg_s.intValue < this.lowestStackValue) {
                            this.lowestStackValue = this.reg_s.intValue;
                        }
                        this.vecx.vectrexNonCPUStep(5);
                        this.inst_tst16(this.reg_s.intValue);
                        this.vecx.vectrexNonCPUStep(1);
                        this.cycles.intValue += 6;
                        this.resetCallstack();
                        break block12;
                    }
                    case 254: {
                        this.ea = this.ea_extended();
                        this.reg_s.intValue = this.read16(this.ea);
                        if (this.reg_s.intValue < this.lowestStackValue) {
                            this.lowestStackValue = this.reg_s.intValue;
                        }
                        this.vecx.vectrexNonCPUStep(6);
                        this.inst_tst16(this.reg_s.intValue);
                        this.vecx.vectrexNonCPUStep(1);
                        this.cycles.intValue += 7;
                        this.resetCallstack();
                        break block12;
                    }
                    case 223: {
                        this.ea = this.ea_direct();
                        this.vecx.vectrexNonCPUStep(4);
                        this.write16(this.ea, this.reg_s.intValue);
                        this.vecx.vectrexNonCPUStep(2);
                        this.inst_tst16(this.reg_s.intValue);
                        this.cycles.intValue += 6;
                        break block12;
                    }
                    case 239: {
                        this.ea = this.ea_indexed(this.cycles);
                        this.vecx.vectrexNonCPUStep(4);
                        this.write16(this.ea, this.reg_s.intValue);
                        this.vecx.vectrexNonCPUStep(2);
                        this.inst_tst16(this.reg_s.intValue);
                        this.cycles.intValue += 6;
                        break block12;
                    }
                    case 255: {
                        this.ea = this.ea_extended();
                        this.vecx.vectrexNonCPUStep(5);
                        this.write16(this.ea, this.reg_s.intValue);
                        this.vecx.vectrexNonCPUStep(2);
                        this.inst_tst16(this.reg_s.intValue);
                        this.cycles.intValue += 7;
                        break block12;
                    }
                    case 63: {
                        this.set_cc(128, true);
                        this.inst_psh(255, this.reg_s, this.reg_u, this.cycles);
                        if (this.reg_s.intValue < this.lowestStackValue) {
                            this.lowestStackValue = this.reg_s.intValue;
                        }
                        this.reg_pc = this.read16(65524);
                        this.vecx.vectrexNonCPUStep(8);
                        this.cycles.intValue += 8;
                        break block12;
                    }
                }
                System.out.println("unknown page-1 op code: " + this.op + "\n");
                break;
            }
            case 17: {
                this.op = this.pc_read8();
                switch (this.op) {
                    case 131: {
                        this.vecx.vectrexNonCPUStep(4);
                        this.inst_sub16(this.reg_u.intValue, this.pc_read16());
                        this.vecx.vectrexNonCPUStep(1);
                        this.cycles.intValue += 5;
                        break block12;
                    }
                    case 147: {
                        this.ea = this.ea_direct();
                        this.vecx.vectrexNonCPUStep(6);
                        this.inst_sub16(this.reg_u.intValue, this.read16(this.ea));
                        this.vecx.vectrexNonCPUStep(1);
                        this.cycles.intValue += 7;
                        break block12;
                    }
                    case 163: {
                        this.ea = this.ea_indexed(this.cycles);
                        this.vecx.vectrexNonCPUStep(6);
                        this.inst_sub16(this.reg_u.intValue, this.read16(this.ea));
                        this.vecx.vectrexNonCPUStep(1);
                        this.cycles.intValue += 7;
                        break block12;
                    }
                    case 179: {
                        this.ea = this.ea_extended();
                        this.vecx.vectrexNonCPUStep(7);
                        this.inst_sub16(this.reg_u.intValue, this.read16(this.ea));
                        this.vecx.vectrexNonCPUStep(1);
                        this.cycles.intValue += 8;
                        break block12;
                    }
                    case 140: {
                        this.vecx.vectrexNonCPUStep(4);
                        this.inst_sub16(this.reg_s.intValue, this.pc_read16());
                        this.vecx.vectrexNonCPUStep(1);
                        this.cycles.intValue += 5;
                        break block12;
                    }
                    case 156: {
                        this.ea = this.ea_direct();
                        this.vecx.vectrexNonCPUStep(6);
                        this.inst_sub16(this.reg_s.intValue, this.read16(this.ea));
                        this.vecx.vectrexNonCPUStep(1);
                        this.cycles.intValue += 7;
                        break block12;
                    }
                    case 172: {
                        this.ea = this.ea_indexed(this.cycles);
                        this.vecx.vectrexNonCPUStep(5);
                        this.inst_sub16(this.reg_s.intValue, this.read16(this.ea));
                        this.vecx.vectrexNonCPUStep(2);
                        this.cycles.intValue += 7;
                        break block12;
                    }
                    case 188: {
                        this.ea = this.ea_extended();
                        this.vecx.vectrexNonCPUStep(6);
                        this.inst_sub16(this.reg_s.intValue, this.read16(this.ea));
                        this.vecx.vectrexNonCPUStep(2);
                        this.cycles.intValue += 8;
                        break block12;
                    }
                    case 63: {
                        this.set_cc(128, true);
                        this.inst_psh(255, this.reg_s, this.reg_u, this.cycles);
                        if (this.reg_s.intValue < this.lowestStackValue) {
                            this.lowestStackValue = this.reg_s.intValue;
                        }
                        this.reg_pc = this.read16(65522);
                        this.vecx.vectrexNonCPUStep(8);
                        this.cycles.intValue += 8;
                        break block12;
                    }
                }
                System.out.println("unknown page-2 op code: " + this.op + "\n");
                break;
            }
            default: {
                System.out.println("unknown page-0 op code: " + this.op + "PC: " + this.reg_pc + "\n");
            }
        }
        this.cyclesRunning += (long)this.cycles.intValue;
        return this.cycles.intValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int e6809_sstep_opt(int irq_i, int irq_f) {
        this.cycles.intValue = 0;
        this.orgPC = this.reg_pc;
        if (irq_f != 0) {
            if ((this.reg_cc & 0x40) != 64) {
                if (this.irq_status != 2) {
                    this.reg_cc &= 0xFFFFFF7F;
                    this.inst_psh(129, this.reg_s, this.reg_u, this.cycles);
                    if (this.profiler != null) {
                        this.profiler.addContext(this.read16(65526), this.reg_s.intValue + 1, this.reg_pc & 0xFFFF, this.orgPC & 0xFFFF);
                    }
                }
                this.reg_cc |= 0x10;
                this.reg_cc |= 0x40;
                this.reg_pc = this.vecx.e6809_read8(65526) << 8 | this.vecx.e6809_read8(65527);
                this.irq_status = 0;
                this.cycles.intValue += 7;
            } else if (this.irq_status == 1) {
                this.irq_status = 0;
            }
        }
        if (irq_i != 0) {
            if ((this.reg_cc & 0x10) != 16) {
                if (this.irq_status != 2) {
                    this.reg_cc |= 0x80;
                    int olds = this.reg_s.intValue;
                    this.inst_psh(255, this.reg_s, this.reg_u, this.cycles);
                    if (this.profiler != null) {
                        this.profiler.addContext(this.read16(65528), this.reg_s.intValue + 1, this.reg_pc & 0xFFFF, this.orgPC & 0xFFFF);
                    }
                }
                this.reg_cc |= 0x10;
                this.reg_pc = this.vecx.e6809_read8(65528) << 8 | this.vecx.e6809_read8(65529);
                this.irq_status = 0;
                this.cycles.intValue += 7;
            } else if (this.irq_status == 1) {
                this.irq_status = 0;
            }
        }
        if (this.irq_status != 0) {
            this.cyclesRunning += (long)(this.cycles.intValue + 1);
            return this.cycles.intValue + 1;
        }
        this.op = this.vecx.e6809_read8(this.reg_pc);
        this.reg_pc = this.reg_pc + 1 & 0xFFFF;
        block12 : switch (this.op) {
            case 0: {
                this.ea = this.reg_dp << 8 | this.vecx.e6809_read8(this.reg_pc);
                this.reg_pc = this.reg_pc + 1 & 0xFFFF;
                this.vecx.vectrexNonCPUStep(3);
                this.r = this.inst_neg(this.vecx.e6809_read8(this.ea));
                this.vecx.vectrexNonCPUStep(3);
                this.vecx.e6809_write8(this.ea, this.r);
                this.cycles.intValue += 6;
                break;
            }
            case 64: {
                this.reg_a = this.inst_neg(this.reg_a) & 0xFF;
                this.vecx.vectrexNonCPUStep(2);
                this.cycles.intValue += 2;
                break;
            }
            case 80: {
                this.reg_b = this.inst_neg(this.reg_b) & 0xFF;
                this.vecx.vectrexNonCPUStep(2);
                this.cycles.intValue += 2;
                break;
            }
            case 96: {
                this.ea = this.ea_indexed(this.cycles);
                this.vecx.vectrexNonCPUStep(3);
                this.r = this.inst_neg(this.vecx.e6809_read8(this.ea));
                this.vecx.vectrexNonCPUStep(3);
                this.vecx.e6809_write8(this.ea, this.r);
                this.cycles.intValue += 6;
                break;
            }
            case 112: {
                this.ea = this.vecx.e6809_read8(this.reg_pc) << 8 | this.vecx.e6809_read8(this.reg_pc + 1 & 0xFFFF);
                this.reg_pc = this.reg_pc + 2 & 0xFFFF;
                this.vecx.vectrexNonCPUStep(4);
                this.r = this.inst_neg(this.vecx.e6809_read8(this.ea));
                this.vecx.vectrexNonCPUStep(3);
                this.vecx.e6809_write8(this.ea, this.r);
                this.cycles.intValue += 7;
                break;
            }
            case 3: {
                this.ea = this.reg_dp << 8 | this.vecx.e6809_read8(this.reg_pc);
                this.reg_pc = this.reg_pc + 1 & 0xFFFF;
                this.vecx.vectrexNonCPUStep(3);
                this.r = this.inst_com(this.vecx.e6809_read8(this.ea));
                this.vecx.vectrexNonCPUStep(3);
                this.vecx.e6809_write8(this.ea, this.r);
                this.cycles.intValue += 6;
                break;
            }
            case 67: {
                this.reg_a = this.inst_com(this.reg_a) & 0xFF;
                this.cycles.intValue += 2;
                break;
            }
            case 83: {
                this.reg_b = this.inst_com(this.reg_b) & 0xFF;
                this.cycles.intValue += 2;
                break;
            }
            case 99: {
                this.ea = this.ea_indexed(this.cycles);
                this.vecx.vectrexNonCPUStep(3);
                this.r = this.inst_com(this.vecx.e6809_read8(this.ea));
                this.vecx.vectrexNonCPUStep(3);
                this.vecx.e6809_write8(this.ea, this.r);
                this.cycles.intValue += 6;
                break;
            }
            case 115: {
                this.ea = this.vecx.e6809_read8(this.reg_pc) << 8 | this.vecx.e6809_read8(this.reg_pc + 1 & 0xFFFF);
                this.reg_pc = this.reg_pc + 2 & 0xFFFF;
                this.vecx.vectrexNonCPUStep(4);
                this.r = this.inst_com(this.vecx.e6809_read8(this.ea));
                this.vecx.vectrexNonCPUStep(3);
                this.vecx.e6809_write8(this.ea, this.r);
                this.cycles.intValue += 7;
                break;
            }
            case 4: {
                this.ea = this.reg_dp << 8 | this.vecx.e6809_read8(this.reg_pc);
                this.reg_pc = this.reg_pc + 1 & 0xFFFF;
                this.vecx.vectrexNonCPUStep(3);
                this.r = this.inst_lsr(this.vecx.e6809_read8(this.ea));
                this.vecx.vectrexNonCPUStep(3);
                this.vecx.e6809_write8(this.ea, this.r);
                this.cycles.intValue += 6;
                break;
            }
            case 68: {
                this.reg_a = this.inst_lsr(this.reg_a) & 0xFF;
                this.cycles.intValue += 2;
                break;
            }
            case 84: {
                this.reg_b = this.inst_lsr(this.reg_b) & 0xFF;
                this.cycles.intValue += 2;
                break;
            }
            case 100: {
                this.ea = this.ea_indexed(this.cycles);
                this.vecx.vectrexNonCPUStep(3);
                this.r = this.inst_lsr(this.vecx.e6809_read8(this.ea));
                this.vecx.vectrexNonCPUStep(3);
                this.vecx.e6809_write8(this.ea, this.r);
                this.cycles.intValue += 6;
                break;
            }
            case 116: {
                this.ea = this.vecx.e6809_read8(this.reg_pc) << 8 | this.vecx.e6809_read8(this.reg_pc + 1 & 0xFFFF);
                this.reg_pc = this.reg_pc + 2 & 0xFFFF;
                this.vecx.vectrexNonCPUStep(4);
                this.r = this.inst_lsr(this.vecx.e6809_read8(this.ea));
                this.vecx.vectrexNonCPUStep(3);
                this.vecx.e6809_write8(this.ea, this.r);
                this.cycles.intValue += 7;
                break;
            }
            case 6: {
                this.ea = this.reg_dp << 8 | this.vecx.e6809_read8(this.reg_pc);
                this.reg_pc = this.reg_pc + 1 & 0xFFFF;
                this.vecx.vectrexNonCPUStep(3);
                this.r = this.inst_ror(this.vecx.e6809_read8(this.ea));
                this.vecx.vectrexNonCPUStep(3);
                this.vecx.e6809_write8(this.ea, this.r);
                this.cycles.intValue += 6;
                break;
            }
            case 70: {
                this.reg_a = this.inst_ror(this.reg_a) & 0xFF;
                this.cycles.intValue += 2;
                break;
            }
            case 86: {
                this.reg_b = this.inst_ror(this.reg_b) & 0xFF;
                this.cycles.intValue += 2;
                break;
            }
            case 102: {
                this.ea = this.ea_indexed(this.cycles);
                this.vecx.vectrexNonCPUStep(3);
                this.r = this.inst_ror(this.vecx.e6809_read8(this.ea));
                this.vecx.vectrexNonCPUStep(3);
                this.vecx.e6809_write8(this.ea, this.r);
                this.cycles.intValue += 6;
                break;
            }
            case 118: {
                this.ea = this.vecx.e6809_read8(this.reg_pc) << 8 | this.vecx.e6809_read8(this.reg_pc + 1 & 0xFFFF);
                this.reg_pc = this.reg_pc + 2 & 0xFFFF;
                this.vecx.vectrexNonCPUStep(4);
                this.r = this.inst_ror(this.vecx.e6809_read8(this.ea));
                this.vecx.vectrexNonCPUStep(3);
                this.vecx.e6809_write8(this.ea, this.r);
                this.cycles.intValue += 7;
                break;
            }
            case 7: {
                this.ea = this.reg_dp << 8 | this.vecx.e6809_read8(this.reg_pc);
                this.reg_pc = this.reg_pc + 1 & 0xFFFF;
                this.vecx.vectrexNonCPUStep(3);
                this.r = this.inst_asr(this.vecx.e6809_read8(this.ea));
                this.vecx.vectrexNonCPUStep(3);
                this.vecx.e6809_write8(this.ea, this.r);
                this.cycles.intValue += 6;
                break;
            }
            case 71: {
                this.reg_a = this.inst_asr(this.reg_a) & 0xFF;
                this.vecx.vectrexNonCPUStep(2);
                this.cycles.intValue += 2;
                break;
            }
            case 87: {
                this.reg_b = this.inst_asr(this.reg_b) & 0xFF;
                this.cycles.intValue += 2;
                break;
            }
            case 103: {
                this.ea = this.ea_indexed(this.cycles);
                this.vecx.vectrexNonCPUStep(3);
                this.r = this.inst_asr(this.vecx.e6809_read8(this.ea));
                this.vecx.vectrexNonCPUStep(3);
                this.vecx.e6809_write8(this.ea, this.r);
                this.cycles.intValue += 6;
                break;
            }
            case 119: {
                this.ea = this.vecx.e6809_read8(this.reg_pc) << 8 | this.vecx.e6809_read8(this.reg_pc + 1 & 0xFFFF);
                this.reg_pc = this.reg_pc + 2 & 0xFFFF;
                this.vecx.vectrexNonCPUStep(4);
                this.r = this.inst_asr(this.vecx.e6809_read8(this.ea));
                this.vecx.vectrexNonCPUStep(3);
                this.vecx.e6809_write8(this.ea, this.r);
                this.cycles.intValue += 7;
                break;
            }
            case 8: {
                this.ea = this.reg_dp << 8 | this.vecx.e6809_read8(this.reg_pc);
                this.reg_pc = this.reg_pc + 1 & 0xFFFF;
                this.vecx.vectrexNonCPUStep(3);
                this.r = this.inst_asl(this.vecx.e6809_read8(this.ea));
                this.vecx.vectrexNonCPUStep(3);
                this.vecx.e6809_write8(this.ea, this.r);
                this.cycles.intValue += 6;
                break;
            }
            case 72: {
                this.reg_a = this.inst_asl(this.reg_a) & 0xFF;
                this.cycles.intValue += 2;
                break;
            }
            case 88: {
                this.reg_b = this.inst_asl(this.reg_b) & 0xFF;
                this.cycles.intValue += 2;
                break;
            }
            case 104: {
                this.ea = this.ea_indexed(this.cycles);
                this.vecx.vectrexNonCPUStep(3);
                this.r = this.inst_asl(this.vecx.e6809_read8(this.ea));
                this.vecx.vectrexNonCPUStep(3);
                this.vecx.e6809_write8(this.ea, this.r);
                this.cycles.intValue += 6;
                break;
            }
            case 120: {
                this.ea = this.vecx.e6809_read8(this.reg_pc) << 8 | this.vecx.e6809_read8(this.reg_pc + 1 & 0xFFFF);
                this.reg_pc = this.reg_pc + 2 & 0xFFFF;
                this.vecx.vectrexNonCPUStep(4);
                this.r = this.inst_asl(this.vecx.e6809_read8(this.ea));
                this.vecx.vectrexNonCPUStep(3);
                this.vecx.e6809_write8(this.ea, this.r);
                this.cycles.intValue += 7;
                break;
            }
            case 9: {
                this.ea = this.reg_dp << 8 | this.vecx.e6809_read8(this.reg_pc);
                this.reg_pc = this.reg_pc + 1 & 0xFFFF;
                this.vecx.vectrexNonCPUStep(3);
                this.r = this.inst_rol(this.vecx.e6809_read8(this.ea));
                this.vecx.vectrexNonCPUStep(3);
                this.vecx.e6809_write8(this.ea, this.r);
                this.cycles.intValue += 6;
                break;
            }
            case 73: {
                this.reg_a = this.inst_rol(this.reg_a) & 0xFF;
                this.cycles.intValue += 2;
                break;
            }
            case 89: {
                this.reg_b = this.inst_rol(this.reg_b) & 0xFF;
                this.cycles.intValue += 2;
                break;
            }
            case 105: {
                this.ea = this.ea_indexed(this.cycles);
                this.vecx.vectrexNonCPUStep(3);
                this.r = this.inst_rol(this.vecx.e6809_read8(this.ea));
                this.vecx.vectrexNonCPUStep(3);
                this.vecx.e6809_write8(this.ea, this.r);
                this.cycles.intValue += 6;
                break;
            }
            case 121: {
                this.ea = this.vecx.e6809_read8(this.reg_pc) << 8 | this.vecx.e6809_read8(this.reg_pc + 1 & 0xFFFF);
                this.reg_pc = this.reg_pc + 2 & 0xFFFF;
                this.vecx.vectrexNonCPUStep(4);
                this.r = this.inst_rol(this.vecx.e6809_read8(this.ea));
                this.vecx.vectrexNonCPUStep(3);
                this.vecx.e6809_write8(this.ea, this.r);
                this.cycles.intValue += 7;
                break;
            }
            case 10: {
                this.ea = this.reg_dp << 8 | this.vecx.e6809_read8(this.reg_pc);
                this.reg_pc = this.reg_pc + 1 & 0xFFFF;
                this.vecx.vectrexNonCPUStep(3);
                this.r = this.inst_dec(this.vecx.e6809_read8(this.ea));
                this.vecx.vectrexNonCPUStep(3);
                this.vecx.e6809_write8(this.ea, this.r);
                this.cycles.intValue += 6;
                break;
            }
            case 74: {
                this.reg_a = this.inst_dec(this.reg_a) & 0xFF;
                this.cycles.intValue += 2;
                break;
            }
            case 90: {
                this.reg_b = this.inst_dec(this.reg_b) & 0xFF;
                this.cycles.intValue += 2;
                break;
            }
            case 106: {
                this.ea = this.ea_indexed(this.cycles);
                this.vecx.vectrexNonCPUStep(3);
                this.r = this.inst_dec(this.vecx.e6809_read8(this.ea));
                this.vecx.vectrexNonCPUStep(3);
                this.vecx.e6809_write8(this.ea, this.r);
                this.cycles.intValue += 6;
                break;
            }
            case 122: {
                this.ea = this.vecx.e6809_read8(this.reg_pc) << 8 | this.vecx.e6809_read8(this.reg_pc + 1 & 0xFFFF);
                this.reg_pc = this.reg_pc + 2 & 0xFFFF;
                this.vecx.vectrexNonCPUStep(4);
                this.r = this.inst_dec(this.vecx.e6809_read8(this.ea));
                this.vecx.vectrexNonCPUStep(3);
                this.vecx.e6809_write8(this.ea, this.r);
                this.cycles.intValue += 7;
                break;
            }
            case 12: {
                this.ea = this.reg_dp << 8 | this.vecx.e6809_read8(this.reg_pc);
                this.reg_pc = this.reg_pc + 1 & 0xFFFF;
                this.vecx.vectrexNonCPUStep(3);
                this.r = this.inst_inc(this.vecx.e6809_read8(this.ea));
                this.vecx.vectrexNonCPUStep(3);
                this.vecx.e6809_write8(this.ea, this.r);
                this.cycles.intValue += 6;
                break;
            }
            case 76: {
                this.reg_a = this.inst_inc(this.reg_a) & 0xFF;
                this.cycles.intValue += 2;
                break;
            }
            case 92: {
                this.reg_b = this.inst_inc(this.reg_b) & 0xFF;
                this.cycles.intValue += 2;
                break;
            }
            case 108: {
                this.ea = this.ea_indexed(this.cycles);
                this.vecx.vectrexNonCPUStep(3);
                this.r = this.inst_inc(this.vecx.e6809_read8(this.ea));
                this.vecx.vectrexNonCPUStep(3);
                this.vecx.e6809_write8(this.ea, this.r);
                this.cycles.intValue += 6;
                break;
            }
            case 124: {
                this.ea = this.vecx.e6809_read8(this.reg_pc) << 8 | this.vecx.e6809_read8(this.reg_pc + 1 & 0xFFFF);
                this.reg_pc = this.reg_pc + 2 & 0xFFFF;
                this.vecx.vectrexNonCPUStep(4);
                this.r = this.inst_inc(this.vecx.e6809_read8(this.ea));
                this.vecx.vectrexNonCPUStep(3);
                this.vecx.e6809_write8(this.ea, this.r);
                this.cycles.intValue += 7;
                break;
            }
            case 13: {
                this.ea = this.reg_dp << 8 | this.vecx.e6809_read8(this.reg_pc);
                this.reg_pc = this.reg_pc + 1 & 0xFFFF;
                this.vecx.vectrexNonCPUStep(3);
                this.tmp = this.vecx.e6809_read8(this.ea);
                this.reg_cc = (this.tmp & 0x80) == 128 ? this.reg_cc | 8 : this.reg_cc & 0xFFFFFFF7;
                this.reg_cc = (this.tmp & 0xFF) == 0 ? this.reg_cc | 4 : this.reg_cc & 0xFFFFFFFB;
                this.reg_cc &= 0xFFFFFFFD;
                this.cycles.intValue += 6;
                break;
            }
            case 77: {
                this.reg_cc = (this.reg_a & 0x80) == 128 ? this.reg_cc | 8 : this.reg_cc & 0xFFFFFFF7;
                this.reg_cc = (this.reg_a & 0xFF) == 0 ? this.reg_cc | 4 : this.reg_cc & 0xFFFFFFFB;
                this.reg_cc &= 0xFFFFFFFD;
                this.cycles.intValue += 2;
                break;
            }
            case 93: {
                this.reg_cc = (this.reg_b & 0x80) == 128 ? this.reg_cc | 8 : this.reg_cc & 0xFFFFFFF7;
                this.reg_cc = (this.reg_b & 0xFF) == 0 ? this.reg_cc | 4 : this.reg_cc & 0xFFFFFFFB;
                this.reg_cc &= 0xFFFFFFFD;
                this.cycles.intValue += 2;
                break;
            }
            case 109: {
                this.ea = this.ea_indexed(this.cycles);
                this.vecx.vectrexNonCPUStep(3);
                this.tmp = this.vecx.e6809_read8(this.ea);
                this.reg_cc = (this.tmp & 0x80) == 128 ? this.reg_cc | 8 : this.reg_cc & 0xFFFFFFF7;
                this.reg_cc = (this.tmp & 0xFF) == 0 ? this.reg_cc | 4 : this.reg_cc & 0xFFFFFFFB;
                this.reg_cc &= 0xFFFFFFFD;
                this.cycles.intValue += 6;
                break;
            }
            case 125: {
                this.ea = this.vecx.e6809_read8(this.reg_pc) << 8 | this.vecx.e6809_read8(this.reg_pc + 1 & 0xFFFF);
                this.reg_pc = this.reg_pc + 2 & 0xFFFF;
                this.vecx.vectrexNonCPUStep(4);
                this.tmp = this.vecx.e6809_read8(this.ea);
                this.reg_cc = (this.tmp & 0x80) == 128 ? this.reg_cc | 8 : this.reg_cc & 0xFFFFFFF7;
                this.reg_cc = (this.tmp & 0xFF) == 0 ? this.reg_cc | 4 : this.reg_cc & 0xFFFFFFFB;
                this.reg_cc &= 0xFFFFFFFD;
                this.cycles.intValue += 7;
                break;
            }
            case 14: {
                this.reg_pc = this.reg_dp << 8 | this.vecx.e6809_read8(this.reg_pc);
                this.cycles.intValue += 3;
                break;
            }
            case 110: {
                this.reg_pc = this.ea_indexed(this.cycles);
                this.cycles.intValue += 3;
                break;
            }
            case 126: {
                this.reg_pc = this.vecx.e6809_read8(this.reg_pc) << 8 | this.vecx.e6809_read8(this.reg_pc + 1 & 0xFFFF);
                this.cycles.intValue += 4;
                break;
            }
            case 15: {
                this.ea = this.reg_dp << 8 | this.vecx.e6809_read8(this.reg_pc);
                this.reg_pc = this.reg_pc + 1 & 0xFFFF;
                this.vecx.vectrexNonCPUStep(4);
                this.inst_clr();
                this.vecx.e6809_read8(this.ea);
                this.vecx.vectrexNonCPUStep(2);
                this.vecx.e6809_write8(this.ea, 0);
                this.cycles.intValue += 6;
                break;
            }
            case 79: {
                this.inst_clr();
                this.reg_a = 0;
                this.cycles.intValue += 2;
                break;
            }
            case 95: {
                this.inst_clr();
                this.reg_b = 0;
                this.cycles.intValue += 2;
                break;
            }
            case 111: {
                this.ea = this.ea_indexed(this.cycles);
                this.vecx.vectrexNonCPUStep(4);
                this.inst_clr();
                this.vecx.e6809_read8(this.ea);
                this.vecx.vectrexNonCPUStep(2);
                this.vecx.e6809_write8(this.ea, 0);
                this.cycles.intValue += 6;
                break;
            }
            case 127: {
                this.ea = this.vecx.e6809_read8(this.reg_pc) << 8 | this.vecx.e6809_read8(this.reg_pc + 1 & 0xFFFF);
                this.reg_pc = this.reg_pc + 2 & 0xFFFF;
                this.vecx.vectrexNonCPUStep(5);
                this.inst_clr();
                this.vecx.e6809_read8(this.ea);
                this.vecx.vectrexNonCPUStep(2);
                this.vecx.e6809_write8(this.ea, 0);
                this.cycles.intValue += 7;
                break;
            }
            case 128: {
                this.vecx.vectrexNonCPUStep(2);
                this.reg_a = this.inst_sub8(this.reg_a, this.vecx.e6809_read8(this.reg_pc)) & 0xFF;
                this.reg_pc = this.reg_pc + 1 & 0xFFFF;
                this.cycles.intValue += 2;
                break;
            }
            case 144: {
                this.ea = this.reg_dp << 8 | this.vecx.e6809_read8(this.reg_pc);
                this.reg_pc = this.reg_pc + 1 & 0xFFFF;
                this.vecx.vectrexNonCPUStep(4);
                this.reg_a = this.inst_sub8(this.reg_a, this.vecx.e6809_read8(this.ea)) & 0xFF;
                this.cycles.intValue += 4;
                break;
            }
            case 160: {
                this.ea = this.ea_indexed(this.cycles);
                this.vecx.vectrexNonCPUStep(4);
                this.reg_a = this.inst_sub8(this.reg_a, this.vecx.e6809_read8(this.ea)) & 0xFF;
                this.cycles.intValue += 4;
                break;
            }
            case 176: {
                this.ea = this.vecx.e6809_read8(this.reg_pc) << 8 | this.vecx.e6809_read8(this.reg_pc + 1 & 0xFFFF);
                this.reg_pc = this.reg_pc + 2 & 0xFFFF;
                this.vecx.vectrexNonCPUStep(5);
                this.reg_a = this.inst_sub8(this.reg_a, this.vecx.e6809_read8(this.ea)) & 0xFF;
                this.cycles.intValue += 5;
                break;
            }
            case 192: {
                this.vecx.vectrexNonCPUStep(2);
                this.reg_b = this.inst_sub8(this.reg_b, this.vecx.e6809_read8(this.reg_pc)) & 0xFF;
                this.reg_pc = this.reg_pc + 1 & 0xFFFF;
                this.cycles.intValue += 2;
                break;
            }
            case 208: {
                this.ea = this.reg_dp << 8 | this.vecx.e6809_read8(this.reg_pc);
                this.reg_pc = this.reg_pc + 1 & 0xFFFF;
                this.vecx.vectrexNonCPUStep(4);
                this.reg_b = this.inst_sub8(this.reg_b, this.vecx.e6809_read8(this.ea)) & 0xFF;
                this.cycles.intValue += 4;
                break;
            }
            case 224: {
                this.ea = this.ea_indexed(this.cycles);
                this.vecx.vectrexNonCPUStep(4);
                this.reg_b = this.inst_sub8(this.reg_b, this.vecx.e6809_read8(this.ea)) & 0xFF;
                this.cycles.intValue += 4;
                break;
            }
            case 240: {
                this.ea = this.vecx.e6809_read8(this.reg_pc) << 8 | this.vecx.e6809_read8(this.reg_pc + 1 & 0xFFFF);
                this.reg_pc = this.reg_pc + 2 & 0xFFFF;
                this.vecx.vectrexNonCPUStep(5);
                this.reg_b = this.inst_sub8(this.reg_b, this.vecx.e6809_read8(this.ea)) & 0xFF;
                this.cycles.intValue += 5;
                break;
            }
            case 129: {
                this.vecx.vectrexNonCPUStep(2);
                this.inst_sub8(this.reg_a, this.vecx.e6809_read8(this.reg_pc));
                this.reg_pc = this.reg_pc + 1 & 0xFFFF;
                this.cycles.intValue += 2;
                break;
            }
            case 145: {
                this.ea = this.reg_dp << 8 | this.vecx.e6809_read8(this.reg_pc);
                this.reg_pc = this.reg_pc + 1 & 0xFFFF;
                this.vecx.vectrexNonCPUStep(4);
                this.inst_sub8(this.reg_a, this.vecx.e6809_read8(this.ea));
                this.cycles.intValue += 4;
                break;
            }
            case 161: {
                this.ea = this.ea_indexed(this.cycles);
                this.vecx.vectrexNonCPUStep(4);
                this.inst_sub8(this.reg_a, this.vecx.e6809_read8(this.ea));
                this.cycles.intValue += 4;
                break;
            }
            case 177: {
                this.ea = this.vecx.e6809_read8(this.reg_pc) << 8 | this.vecx.e6809_read8(this.reg_pc + 1 & 0xFFFF);
                this.reg_pc = this.reg_pc + 2 & 0xFFFF;
                this.vecx.vectrexNonCPUStep(5);
                this.inst_sub8(this.reg_a, this.vecx.e6809_read8(this.ea));
                this.cycles.intValue += 5;
                break;
            }
            case 193: {
                this.vecx.vectrexNonCPUStep(2);
                this.inst_sub8(this.reg_b, this.vecx.e6809_read8(this.reg_pc));
                this.reg_pc = this.reg_pc + 1 & 0xFFFF;
                this.cycles.intValue += 2;
                break;
            }
            case 209: {
                this.ea = this.reg_dp << 8 | this.vecx.e6809_read8(this.reg_pc);
                this.reg_pc = this.reg_pc + 1 & 0xFFFF;
                this.vecx.vectrexNonCPUStep(4);
                this.inst_sub8(this.reg_b, this.vecx.e6809_read8(this.ea));
                this.cycles.intValue += 4;
                break;
            }
            case 225: {
                this.ea = this.ea_indexed(this.cycles);
                this.vecx.vectrexNonCPUStep(4);
                this.inst_sub8(this.reg_b, this.vecx.e6809_read8(this.ea));
                this.cycles.intValue += 4;
                break;
            }
            case 241: {
                this.ea = this.vecx.e6809_read8(this.reg_pc) << 8 | this.vecx.e6809_read8(this.reg_pc + 1 & 0xFFFF);
                this.reg_pc = this.reg_pc + 2 & 0xFFFF;
                this.vecx.vectrexNonCPUStep(5);
                this.inst_sub8(this.reg_b, this.vecx.e6809_read8(this.ea));
                this.cycles.intValue += 5;
                break;
            }
            case 130: {
                this.vecx.vectrexNonCPUStep(2);
                this.reg_a = this.inst_sbc(this.reg_a, this.vecx.e6809_read8(this.reg_pc)) & 0xFF;
                this.reg_pc = this.reg_pc + 1 & 0xFFFF;
                this.cycles.intValue += 2;
                break;
            }
            case 146: {
                this.ea = this.reg_dp << 8 | this.vecx.e6809_read8(this.reg_pc);
                this.reg_pc = this.reg_pc + 1 & 0xFFFF;
                this.vecx.vectrexNonCPUStep(4);
                this.reg_a = this.inst_sbc(this.reg_a, this.vecx.e6809_read8(this.ea)) & 0xFF;
                this.cycles.intValue += 4;
                break;
            }
            case 162: {
                this.ea = this.ea_indexed(this.cycles);
                this.vecx.vectrexNonCPUStep(4);
                this.reg_a = this.inst_sbc(this.reg_a, this.vecx.e6809_read8(this.ea)) & 0xFF;
                this.cycles.intValue += 4;
                break;
            }
            case 178: {
                this.ea = this.vecx.e6809_read8(this.reg_pc) << 8 | this.vecx.e6809_read8(this.reg_pc + 1 & 0xFFFF);
                this.reg_pc = this.reg_pc + 2 & 0xFFFF;
                this.vecx.vectrexNonCPUStep(5);
                this.reg_a = this.inst_sbc(this.reg_a, this.vecx.e6809_read8(this.ea)) & 0xFF;
                this.cycles.intValue += 5;
                break;
            }
            case 194: {
                this.vecx.vectrexNonCPUStep(2);
                this.reg_b = this.inst_sbc(this.reg_b, this.vecx.e6809_read8(this.reg_pc)) & 0xFF;
                this.reg_pc = this.reg_pc + 1 & 0xFFFF;
                this.cycles.intValue += 2;
                break;
            }
            case 210: {
                this.ea = this.reg_dp << 8 | this.vecx.e6809_read8(this.reg_pc);
                this.reg_pc = this.reg_pc + 1 & 0xFFFF;
                this.vecx.vectrexNonCPUStep(4);
                this.reg_b = this.inst_sbc(this.reg_b, this.vecx.e6809_read8(this.ea)) & 0xFF;
                this.cycles.intValue += 4;
                break;
            }
            case 226: {
                this.ea = this.ea_indexed(this.cycles);
                this.vecx.vectrexNonCPUStep(4);
                this.reg_b = this.inst_sbc(this.reg_b, this.vecx.e6809_read8(this.ea)) & 0xFF;
                this.cycles.intValue += 4;
                break;
            }
            case 242: {
                this.ea = this.vecx.e6809_read8(this.reg_pc) << 8 | this.vecx.e6809_read8(this.reg_pc + 1 & 0xFFFF);
                this.reg_pc = this.reg_pc + 2 & 0xFFFF;
                this.vecx.vectrexNonCPUStep(5);
                this.reg_b = this.inst_sbc(this.reg_b, this.vecx.e6809_read8(this.ea)) & 0xFF;
                this.cycles.intValue += 5;
                break;
            }
            case 132: {
                this.vecx.vectrexNonCPUStep(2);
                this.reg_a = this.inst_and(this.reg_a, this.vecx.e6809_read8(this.reg_pc)) & 0xFF;
                this.reg_pc = this.reg_pc + 1 & 0xFFFF;
                this.cycles.intValue += 2;
                break;
            }
            case 148: {
                this.ea = this.reg_dp << 8 | this.vecx.e6809_read8(this.reg_pc);
                this.reg_pc = this.reg_pc + 1 & 0xFFFF;
                this.vecx.vectrexNonCPUStep(4);
                this.reg_a = this.inst_and(this.reg_a, this.vecx.e6809_read8(this.ea)) & 0xFF;
                this.cycles.intValue += 4;
                break;
            }
            case 164: {
                this.ea = this.ea_indexed(this.cycles);
                this.vecx.vectrexNonCPUStep(4);
                this.reg_a = this.inst_and(this.reg_a, this.vecx.e6809_read8(this.ea)) & 0xFF;
                this.cycles.intValue += 4;
                break;
            }
            case 180: {
                this.ea = this.vecx.e6809_read8(this.reg_pc) << 8 | this.vecx.e6809_read8(this.reg_pc + 1 & 0xFFFF);
                this.reg_pc = this.reg_pc + 2 & 0xFFFF;
                this.vecx.vectrexNonCPUStep(5);
                this.reg_a = this.inst_and(this.reg_a, this.vecx.e6809_read8(this.ea)) & 0xFF;
                this.cycles.intValue += 5;
                break;
            }
            case 196: {
                this.vecx.vectrexNonCPUStep(2);
                this.reg_b = this.inst_and(this.reg_b, this.vecx.e6809_read8(this.reg_pc)) & 0xFF;
                this.reg_pc = this.reg_pc + 1 & 0xFFFF;
                this.cycles.intValue += 2;
                break;
            }
            case 212: {
                this.ea = this.reg_dp << 8 | this.vecx.e6809_read8(this.reg_pc);
                this.reg_pc = this.reg_pc + 1 & 0xFFFF;
                this.vecx.vectrexNonCPUStep(4);
                this.reg_b = this.inst_and(this.reg_b, this.vecx.e6809_read8(this.ea)) & 0xFF;
                this.cycles.intValue += 4;
                break;
            }
            case 228: {
                this.ea = this.ea_indexed(this.cycles);
                this.vecx.vectrexNonCPUStep(4);
                this.reg_b = this.inst_and(this.reg_b, this.vecx.e6809_read8(this.ea)) & 0xFF;
                this.cycles.intValue += 4;
                break;
            }
            case 244: {
                this.ea = this.vecx.e6809_read8(this.reg_pc) << 8 | this.vecx.e6809_read8(this.reg_pc + 1 & 0xFFFF);
                this.reg_pc = this.reg_pc + 2 & 0xFFFF;
                this.vecx.vectrexNonCPUStep(5);
                this.reg_b = this.inst_and(this.reg_b, this.vecx.e6809_read8(this.ea)) & 0xFF;
                this.cycles.intValue += 5;
                break;
            }
            case 133: {
                this.vecx.vectrexNonCPUStep(2);
                this.inst_and(this.reg_a, this.vecx.e6809_read8(this.reg_pc));
                this.reg_pc = this.reg_pc + 1 & 0xFFFF;
                this.cycles.intValue += 2;
                break;
            }
            case 149: {
                this.ea = this.reg_dp << 8 | this.vecx.e6809_read8(this.reg_pc);
                this.reg_pc = this.reg_pc + 1 & 0xFFFF;
                this.vecx.vectrexNonCPUStep(4);
                this.inst_and(this.reg_a, this.vecx.e6809_read8(this.ea));
                this.cycles.intValue += 4;
                break;
            }
            case 165: {
                this.ea = this.ea_indexed(this.cycles);
                this.vecx.vectrexNonCPUStep(4);
                this.inst_and(this.reg_a, this.vecx.e6809_read8(this.ea));
                this.cycles.intValue += 4;
                break;
            }
            case 181: {
                this.ea = this.vecx.e6809_read8(this.reg_pc) << 8 | this.vecx.e6809_read8(this.reg_pc + 1 & 0xFFFF);
                this.reg_pc = this.reg_pc + 2 & 0xFFFF;
                this.vecx.vectrexNonCPUStep(5);
                this.inst_and(this.reg_a, this.vecx.e6809_read8(this.ea));
                this.cycles.intValue += 5;
                break;
            }
            case 197: {
                this.vecx.vectrexNonCPUStep(2);
                this.inst_and(this.reg_b, this.vecx.e6809_read8(this.reg_pc));
                this.reg_pc = this.reg_pc + 1 & 0xFFFF;
                this.cycles.intValue += 2;
                break;
            }
            case 213: {
                this.ea = this.reg_dp << 8 | this.vecx.e6809_read8(this.reg_pc);
                this.reg_pc = this.reg_pc + 1 & 0xFFFF;
                this.vecx.vectrexNonCPUStep(4);
                this.inst_and(this.reg_b, this.vecx.e6809_read8(this.ea));
                this.cycles.intValue += 4;
                break;
            }
            case 229: {
                this.ea = this.ea_indexed(this.cycles);
                this.vecx.vectrexNonCPUStep(4);
                this.inst_and(this.reg_b, this.vecx.e6809_read8(this.ea));
                this.cycles.intValue += 4;
                break;
            }
            case 245: {
                this.ea = this.vecx.e6809_read8(this.reg_pc) << 8 | this.vecx.e6809_read8(this.reg_pc + 1 & 0xFFFF);
                this.reg_pc = this.reg_pc + 2 & 0xFFFF;
                this.vecx.vectrexNonCPUStep(5);
                this.inst_and(this.reg_b, this.vecx.e6809_read8(this.ea));
                this.cycles.intValue += 5;
                break;
            }
            case 134: {
                this.reg_a = this.vecx.e6809_read8(this.reg_pc);
                this.reg_pc = this.reg_pc + 1 & 0xFFFF;
                this.vecx.vectrexNonCPUStep(2);
                this.reg_cc = (this.reg_a & 0x80) == 128 ? this.reg_cc | 8 : this.reg_cc & 0xFFFFFFF7;
                this.reg_cc = (this.reg_a & 0xFF) == 0 ? this.reg_cc | 4 : this.reg_cc & 0xFFFFFFFB;
                this.reg_cc &= 0xFFFFFFFD;
                this.cycles.intValue += 2;
                break;
            }
            case 150: {
                this.ea = this.reg_dp << 8 | this.vecx.e6809_read8(this.reg_pc);
                this.reg_pc = this.reg_pc + 1 & 0xFFFF;
                this.vecx.vectrexNonCPUStep(3);
                this.reg_a = this.vecx.e6809_read8(this.ea);
                this.vecx.vectrexNonCPUStep(1);
                this.reg_cc = (this.reg_a & 0x80) == 128 ? this.reg_cc | 8 : this.reg_cc & 0xFFFFFFF7;
                this.reg_cc = (this.reg_a & 0xFF) == 0 ? this.reg_cc | 4 : this.reg_cc & 0xFFFFFFFB;
                this.reg_cc &= 0xFFFFFFFD;
                this.cycles.intValue += 4;
                break;
            }
            case 166: {
                this.ea = this.ea_indexed(this.cycles);
                this.vecx.vectrexNonCPUStep(3);
                this.reg_a = this.vecx.e6809_read8(this.ea);
                this.vecx.vectrexNonCPUStep(1);
                this.reg_cc = (this.reg_a & 0x80) == 128 ? this.reg_cc | 8 : this.reg_cc & 0xFFFFFFF7;
                this.reg_cc = (this.reg_a & 0xFF) == 0 ? this.reg_cc | 4 : this.reg_cc & 0xFFFFFFFB;
                this.reg_cc &= 0xFFFFFFFD;
                this.cycles.intValue += 4;
                break;
            }
            case 182: {
                this.ea = this.vecx.e6809_read8(this.reg_pc) << 8 | this.vecx.e6809_read8(this.reg_pc + 1 & 0xFFFF);
                this.reg_pc = this.reg_pc + 2 & 0xFFFF;
                this.vecx.vectrexNonCPUStep(4);
                this.reg_a = this.vecx.e6809_read8(this.ea);
                this.vecx.vectrexNonCPUStep(1);
                this.reg_cc = (this.reg_a & 0x80) == 128 ? this.reg_cc | 8 : this.reg_cc & 0xFFFFFFF7;
                this.reg_cc = (this.reg_a & 0xFF) == 0 ? this.reg_cc | 4 : this.reg_cc & 0xFFFFFFFB;
                this.reg_cc &= 0xFFFFFFFD;
                this.cycles.intValue += 5;
                break;
            }
            case 198: {
                this.reg_b = this.vecx.e6809_read8(this.reg_pc);
                this.reg_pc = this.reg_pc + 1 & 0xFFFF;
                this.vecx.vectrexNonCPUStep(2);
                this.reg_cc = (this.reg_b & 0x80) == 128 ? this.reg_cc | 8 : this.reg_cc & 0xFFFFFFF7;
                this.reg_cc = (this.reg_b & 0xFF) == 0 ? this.reg_cc | 4 : this.reg_cc & 0xFFFFFFFB;
                this.reg_cc &= 0xFFFFFFFD;
                this.cycles.intValue += 2;
                break;
            }
            case 214: {
                this.ea = this.reg_dp << 8 | this.vecx.e6809_read8(this.reg_pc);
                this.reg_pc = this.reg_pc + 1 & 0xFFFF;
                this.vecx.vectrexNonCPUStep(3);
                this.reg_b = this.vecx.e6809_read8(this.ea);
                this.vecx.vectrexNonCPUStep(1);
                this.reg_cc = (this.reg_b & 0x80) == 128 ? this.reg_cc | 8 : this.reg_cc & 0xFFFFFFF7;
                this.reg_cc = (this.reg_b & 0xFF) == 0 ? this.reg_cc | 4 : this.reg_cc & 0xFFFFFFFB;
                this.reg_cc &= 0xFFFFFFFD;
                this.cycles.intValue += 4;
                break;
            }
            case 230: {
                this.ea = this.ea_indexed(this.cycles);
                this.vecx.vectrexNonCPUStep(3);
                this.reg_b = this.vecx.e6809_read8(this.ea);
                this.vecx.vectrexNonCPUStep(1);
                this.reg_cc = (this.reg_b & 0x80) == 128 ? this.reg_cc | 8 : this.reg_cc & 0xFFFFFFF7;
                this.reg_cc = (this.reg_b & 0xFF) == 0 ? this.reg_cc | 4 : this.reg_cc & 0xFFFFFFFB;
                this.reg_cc &= 0xFFFFFFFD;
                this.cycles.intValue += 4;
                break;
            }
            case 246: {
                this.ea = this.vecx.e6809_read8(this.reg_pc) << 8 | this.vecx.e6809_read8(this.reg_pc + 1 & 0xFFFF);
                this.reg_pc = this.reg_pc + 2 & 0xFFFF;
                this.vecx.vectrexNonCPUStep(4);
                this.reg_b = this.vecx.e6809_read8(this.ea);
                this.vecx.vectrexNonCPUStep(1);
                this.reg_cc = (this.reg_b & 0x80) == 128 ? this.reg_cc | 8 : this.reg_cc & 0xFFFFFFF7;
                this.reg_cc = (this.reg_b & 0xFF) == 0 ? this.reg_cc | 4 : this.reg_cc & 0xFFFFFFFB;
                this.reg_cc &= 0xFFFFFFFD;
                this.cycles.intValue += 5;
                break;
            }
            case 151: {
                this.ea = this.reg_dp << 8 | this.vecx.e6809_read8(this.reg_pc);
                this.reg_pc = this.reg_pc + 1 & 0xFFFF;
                this.vecx.vectrexNonCPUStep(4);
                this.vecx.e6809_write8(this.ea, this.reg_a);
                this.reg_cc = (this.reg_a & 0x80) == 128 ? this.reg_cc | 8 : this.reg_cc & 0xFFFFFFF7;
                this.reg_cc = (this.reg_a & 0xFF) == 0 ? this.reg_cc | 4 : this.reg_cc & 0xFFFFFFFB;
                this.reg_cc &= 0xFFFFFFFD;
                this.cycles.intValue += 4;
                break;
            }
            case 167: {
                this.ea = this.ea_indexed(this.cycles);
                this.vecx.vectrexNonCPUStep(4);
                this.vecx.e6809_write8(this.ea, this.reg_a);
                this.reg_cc = (this.reg_a & 0x80) == 128 ? this.reg_cc | 8 : this.reg_cc & 0xFFFFFFF7;
                this.reg_cc = (this.reg_a & 0xFF) == 0 ? this.reg_cc | 4 : this.reg_cc & 0xFFFFFFFB;
                this.reg_cc &= 0xFFFFFFFD;
                this.cycles.intValue += 4;
                break;
            }
            case 183: {
                this.ea = this.vecx.e6809_read8(this.reg_pc) << 8 | this.vecx.e6809_read8(this.reg_pc + 1 & 0xFFFF);
                this.reg_pc = this.reg_pc + 2 & 0xFFFF;
                this.vecx.vectrexNonCPUStep(5);
                this.vecx.e6809_write8(this.ea, this.reg_a);
                this.reg_cc = (this.reg_a & 0x80) == 128 ? this.reg_cc | 8 : this.reg_cc & 0xFFFFFFF7;
                this.reg_cc = (this.reg_a & 0xFF) == 0 ? this.reg_cc | 4 : this.reg_cc & 0xFFFFFFFB;
                this.reg_cc &= 0xFFFFFFFD;
                this.cycles.intValue += 5;
                break;
            }
            case 215: {
                this.ea = this.reg_dp << 8 | this.vecx.e6809_read8(this.reg_pc);
                this.reg_pc = this.reg_pc + 1 & 0xFFFF;
                this.vecx.vectrexNonCPUStep(4);
                this.vecx.e6809_write8(this.ea, this.reg_b);
                this.reg_cc = (this.reg_b & 0x80) == 128 ? this.reg_cc | 8 : this.reg_cc & 0xFFFFFFF7;
                this.reg_cc = (this.reg_b & 0xFF) == 0 ? this.reg_cc | 4 : this.reg_cc & 0xFFFFFFFB;
                this.reg_cc &= 0xFFFFFFFD;
                this.cycles.intValue += 4;
                break;
            }
            case 231: {
                this.ea = this.ea_indexed(this.cycles);
                this.vecx.vectrexNonCPUStep(4);
                this.vecx.e6809_write8(this.ea, this.reg_b);
                this.reg_cc = (this.reg_b & 0x80) == 128 ? this.reg_cc | 8 : this.reg_cc & 0xFFFFFFF7;
                this.reg_cc = (this.reg_b & 0xFF) == 0 ? this.reg_cc | 4 : this.reg_cc & 0xFFFFFFFB;
                this.reg_cc &= 0xFFFFFFFD;
                this.cycles.intValue += 4;
                break;
            }
            case 247: {
                this.ea = this.vecx.e6809_read8(this.reg_pc) << 8 | this.vecx.e6809_read8(this.reg_pc + 1 & 0xFFFF);
                this.reg_pc = this.reg_pc + 2 & 0xFFFF;
                this.vecx.vectrexNonCPUStep(5);
                this.vecx.e6809_write8(this.ea, this.reg_b);
                this.reg_cc = (this.reg_b & 0x80) == 128 ? this.reg_cc | 8 : this.reg_cc & 0xFFFFFFF7;
                this.reg_cc = (this.reg_b & 0xFF) == 0 ? this.reg_cc | 4 : this.reg_cc & 0xFFFFFFFB;
                this.reg_cc &= 0xFFFFFFFD;
                this.cycles.intValue += 5;
                break;
            }
            case 136: {
                this.reg_a = this.inst_eor(this.reg_a, this.vecx.e6809_read8(this.reg_pc)) & 0xFF;
                this.reg_pc = this.reg_pc + 1 & 0xFFFF;
                this.cycles.intValue += 2;
                break;
            }
            case 152: {
                this.ea = this.reg_dp << 8 | this.vecx.e6809_read8(this.reg_pc);
                this.reg_pc = this.reg_pc + 1 & 0xFFFF;
                this.vecx.vectrexNonCPUStep(3);
                this.reg_a = this.inst_eor(this.reg_a, this.vecx.e6809_read8(this.ea)) & 0xFF;
                this.vecx.vectrexNonCPUStep(1);
                this.cycles.intValue += 4;
                break;
            }
            case 168: {
                this.ea = this.ea_indexed(this.cycles);
                this.vecx.vectrexNonCPUStep(3);
                this.reg_a = this.inst_eor(this.reg_a, this.vecx.e6809_read8(this.ea)) & 0xFF;
                this.vecx.vectrexNonCPUStep(1);
                this.cycles.intValue += 4;
                break;
            }
            case 184: {
                this.ea = this.vecx.e6809_read8(this.reg_pc) << 8 | this.vecx.e6809_read8(this.reg_pc + 1 & 0xFFFF);
                this.reg_pc = this.reg_pc + 2 & 0xFFFF;
                this.vecx.vectrexNonCPUStep(4);
                this.reg_a = this.inst_eor(this.reg_a, this.vecx.e6809_read8(this.ea)) & 0xFF;
                this.vecx.vectrexNonCPUStep(1);
                this.cycles.intValue += 5;
                break;
            }
            case 200: {
                this.reg_b = this.inst_eor(this.reg_b, this.vecx.e6809_read8(this.reg_pc)) & 0xFF;
                this.reg_pc = this.reg_pc + 1 & 0xFFFF;
                this.cycles.intValue += 2;
                break;
            }
            case 216: {
                this.ea = this.reg_dp << 8 | this.vecx.e6809_read8(this.reg_pc);
                this.reg_pc = this.reg_pc + 1 & 0xFFFF;
                this.vecx.vectrexNonCPUStep(3);
                this.reg_b = this.inst_eor(this.reg_b, this.vecx.e6809_read8(this.ea)) & 0xFF;
                this.vecx.vectrexNonCPUStep(1);
                this.cycles.intValue += 4;
                break;
            }
            case 232: {
                this.ea = this.ea_indexed(this.cycles);
                this.vecx.vectrexNonCPUStep(3);
                this.reg_b = this.inst_eor(this.reg_b, this.vecx.e6809_read8(this.ea)) & 0xFF;
                this.vecx.vectrexNonCPUStep(1);
                this.cycles.intValue += 4;
                break;
            }
            case 248: {
                this.ea = this.vecx.e6809_read8(this.reg_pc) << 8 | this.vecx.e6809_read8(this.reg_pc + 1 & 0xFFFF);
                this.reg_pc = this.reg_pc + 2 & 0xFFFF;
                this.vecx.vectrexNonCPUStep(4);
                this.reg_b = this.inst_eor(this.reg_b, this.vecx.e6809_read8(this.ea)) & 0xFF;
                this.vecx.vectrexNonCPUStep(1);
                this.cycles.intValue += 5;
                break;
            }
            case 137: {
                this.reg_a = this.inst_adc(this.reg_a, this.vecx.e6809_read8(this.reg_pc)) & 0xFF;
                this.reg_pc = this.reg_pc + 1 & 0xFFFF;
                this.cycles.intValue += 2;
                break;
            }
            case 153: {
                this.ea = this.reg_dp << 8 | this.vecx.e6809_read8(this.reg_pc);
                this.reg_pc = this.reg_pc + 1 & 0xFFFF;
                this.vecx.vectrexNonCPUStep(3);
                this.reg_a = this.inst_adc(this.reg_a, this.vecx.e6809_read8(this.ea)) & 0xFF;
                this.vecx.vectrexNonCPUStep(1);
                this.cycles.intValue += 4;
                break;
            }
            case 169: {
                this.ea = this.ea_indexed(this.cycles);
                this.vecx.vectrexNonCPUStep(3);
                this.reg_a = this.inst_adc(this.reg_a, this.vecx.e6809_read8(this.ea)) & 0xFF;
                this.vecx.vectrexNonCPUStep(1);
                this.cycles.intValue += 4;
                break;
            }
            case 185: {
                this.ea = this.vecx.e6809_read8(this.reg_pc) << 8 | this.vecx.e6809_read8(this.reg_pc + 1 & 0xFFFF);
                this.reg_pc = this.reg_pc + 2 & 0xFFFF;
                this.vecx.vectrexNonCPUStep(4);
                this.reg_a = this.inst_adc(this.reg_a, this.vecx.e6809_read8(this.ea)) & 0xFF;
                this.vecx.vectrexNonCPUStep(1);
                this.cycles.intValue += 5;
                break;
            }
            case 201: {
                this.reg_b = this.inst_adc(this.reg_b, this.vecx.e6809_read8(this.reg_pc)) & 0xFF;
                this.reg_pc = this.reg_pc + 1 & 0xFFFF;
                this.cycles.intValue += 2;
                break;
            }
            case 217: {
                this.ea = this.reg_dp << 8 | this.vecx.e6809_read8(this.reg_pc);
                this.reg_pc = this.reg_pc + 1 & 0xFFFF;
                this.vecx.vectrexNonCPUStep(3);
                this.reg_b = this.inst_adc(this.reg_b, this.vecx.e6809_read8(this.ea)) & 0xFF;
                this.vecx.vectrexNonCPUStep(1);
                this.cycles.intValue += 4;
                break;
            }
            case 233: {
                this.ea = this.ea_indexed(this.cycles);
                this.vecx.vectrexNonCPUStep(3);
                this.reg_b = this.inst_adc(this.reg_b, this.vecx.e6809_read8(this.ea)) & 0xFF;
                this.vecx.vectrexNonCPUStep(1);
                this.cycles.intValue += 4;
                break;
            }
            case 249: {
                this.ea = this.vecx.e6809_read8(this.reg_pc) << 8 | this.vecx.e6809_read8(this.reg_pc + 1 & 0xFFFF);
                this.reg_pc = this.reg_pc + 2 & 0xFFFF;
                this.vecx.vectrexNonCPUStep(4);
                this.reg_b = this.inst_adc(this.reg_b, this.vecx.e6809_read8(this.ea)) & 0xFF;
                this.vecx.vectrexNonCPUStep(1);
                this.cycles.intValue += 5;
                break;
            }
            case 138: {
                this.reg_a = this.inst_or(this.reg_a, this.vecx.e6809_read8(this.reg_pc)) & 0xFF;
                this.reg_pc = this.reg_pc + 1 & 0xFFFF;
                this.cycles.intValue += 2;
                break;
            }
            case 154: {
                this.ea = this.reg_dp << 8 | this.vecx.e6809_read8(this.reg_pc);
                this.reg_pc = this.reg_pc + 1 & 0xFFFF;
                this.vecx.vectrexNonCPUStep(3);
                this.reg_a = this.inst_or(this.reg_a, this.vecx.e6809_read8(this.ea)) & 0xFF;
                this.vecx.vectrexNonCPUStep(1);
                this.cycles.intValue += 4;
                break;
            }
            case 170: {
                this.ea = this.ea_indexed(this.cycles);
                this.vecx.vectrexNonCPUStep(3);
                this.reg_a = this.inst_or(this.reg_a, this.vecx.e6809_read8(this.ea)) & 0xFF;
                this.vecx.vectrexNonCPUStep(1);
                this.cycles.intValue += 4;
                break;
            }
            case 186: {
                this.ea = this.vecx.e6809_read8(this.reg_pc) << 8 | this.vecx.e6809_read8(this.reg_pc + 1 & 0xFFFF);
                this.reg_pc = this.reg_pc + 2 & 0xFFFF;
                this.vecx.vectrexNonCPUStep(4);
                this.reg_a = this.inst_or(this.reg_a, this.vecx.e6809_read8(this.ea)) & 0xFF;
                this.vecx.vectrexNonCPUStep(1);
                this.cycles.intValue += 5;
                break;
            }
            case 202: {
                this.reg_b = this.inst_or(this.reg_b, this.vecx.e6809_read8(this.reg_pc)) & 0xFF;
                this.reg_pc = this.reg_pc + 1 & 0xFFFF;
                this.cycles.intValue += 2;
                break;
            }
            case 218: {
                this.ea = this.reg_dp << 8 | this.vecx.e6809_read8(this.reg_pc);
                this.reg_pc = this.reg_pc + 1 & 0xFFFF;
                this.vecx.vectrexNonCPUStep(3);
                this.reg_b = this.inst_or(this.reg_b, this.vecx.e6809_read8(this.ea)) & 0xFF;
                this.vecx.vectrexNonCPUStep(1);
                this.cycles.intValue += 4;
                break;
            }
            case 234: {
                this.ea = this.ea_indexed(this.cycles);
                this.vecx.vectrexNonCPUStep(3);
                this.reg_b = this.inst_or(this.reg_b, this.vecx.e6809_read8(this.ea)) & 0xFF;
                this.vecx.vectrexNonCPUStep(1);
                this.cycles.intValue += 4;
                break;
            }
            case 250: {
                this.ea = this.vecx.e6809_read8(this.reg_pc) << 8 | this.vecx.e6809_read8(this.reg_pc + 1 & 0xFFFF);
                this.reg_pc = this.reg_pc + 2 & 0xFFFF;
                this.vecx.vectrexNonCPUStep(4);
                this.reg_b = this.inst_or(this.reg_b, this.vecx.e6809_read8(this.ea)) & 0xFF;
                this.vecx.vectrexNonCPUStep(1);
                this.cycles.intValue += 5;
                break;
            }
            case 139: {
                this.reg_a = this.inst_add8(this.reg_a, this.vecx.e6809_read8(this.reg_pc)) & 0xFF;
                this.reg_pc = this.reg_pc + 1 & 0xFFFF;
                this.cycles.intValue += 2;
                break;
            }
            case 155: {
                this.ea = this.reg_dp << 8 | this.vecx.e6809_read8(this.reg_pc);
                this.reg_pc = this.reg_pc + 1 & 0xFFFF;
                this.vecx.vectrexNonCPUStep(3);
                this.reg_a = this.inst_add8(this.reg_a, this.vecx.e6809_read8(this.ea)) & 0xFF;
                this.vecx.vectrexNonCPUStep(1);
                this.cycles.intValue += 4;
                break;
            }
            case 171: {
                this.ea = this.ea_indexed(this.cycles);
                this.vecx.vectrexNonCPUStep(3);
                this.reg_a = this.inst_add8(this.reg_a, this.vecx.e6809_read8(this.ea)) & 0xFF;
                this.vecx.vectrexNonCPUStep(1);
                this.cycles.intValue += 4;
                break;
            }
            case 187: {
                this.ea = this.vecx.e6809_read8(this.reg_pc) << 8 | this.vecx.e6809_read8(this.reg_pc + 1 & 0xFFFF);
                this.reg_pc = this.reg_pc + 2 & 0xFFFF;
                this.vecx.vectrexNonCPUStep(4);
                this.reg_a = this.inst_add8(this.reg_a, this.vecx.e6809_read8(this.ea)) & 0xFF;
                this.vecx.vectrexNonCPUStep(1);
                this.cycles.intValue += 5;
                break;
            }
            case 203: {
                this.reg_b = this.inst_add8(this.reg_b, this.vecx.e6809_read8(this.reg_pc)) & 0xFF;
                this.reg_pc = this.reg_pc + 1 & 0xFFFF;
                this.cycles.intValue += 2;
                break;
            }
            case 219: {
                this.ea = this.reg_dp << 8 | this.vecx.e6809_read8(this.reg_pc);
                this.reg_pc = this.reg_pc + 1 & 0xFFFF;
                this.vecx.vectrexNonCPUStep(3);
                this.reg_b = this.inst_add8(this.reg_b, this.vecx.e6809_read8(this.ea)) & 0xFF;
                this.vecx.vectrexNonCPUStep(1);
                this.cycles.intValue += 4;
                break;
            }
            case 235: {
                this.ea = this.ea_indexed(this.cycles);
                this.vecx.vectrexNonCPUStep(3);
                this.reg_b = this.inst_add8(this.reg_b, this.vecx.e6809_read8(this.ea)) & 0xFF;
                this.vecx.vectrexNonCPUStep(1);
                this.cycles.intValue += 4;
                break;
            }
            case 251: {
                this.ea = this.vecx.e6809_read8(this.reg_pc) << 8 | this.vecx.e6809_read8(this.reg_pc + 1 & 0xFFFF);
                this.reg_pc = this.reg_pc + 2 & 0xFFFF;
                this.vecx.vectrexNonCPUStep(4);
                this.reg_b = this.inst_add8(this.reg_b, this.vecx.e6809_read8(this.ea)) & 0xFF;
                this.vecx.vectrexNonCPUStep(1);
                this.cycles.intValue += 5;
                break;
            }
            case 131: {
                this.set_reg_d(this.inst_sub16(this.reg_a << 8 & 0xFF00 | this.reg_b & 0xFF, this.vecx.e6809_read8(this.reg_pc) << 8 | this.vecx.e6809_read8(this.reg_pc + 1 & 0xFFFF)));
                this.reg_pc = this.reg_pc + 2 & 0xFFFF;
                this.cycles.intValue += 4;
                break;
            }
            case 147: {
                this.ea = this.reg_dp << 8 | this.vecx.e6809_read8(this.reg_pc);
                this.reg_pc = this.reg_pc + 1 & 0xFFFF;
                this.vecx.vectrexNonCPUStep(4);
                this.set_reg_d(this.inst_sub16(this.reg_a << 8 & 0xFF00 | this.reg_b & 0xFF, this.vecx.e6809_read8(this.ea) << 8 | this.vecx.e6809_read8(this.ea + 1)));
                this.vecx.vectrexNonCPUStep(2);
                this.cycles.intValue += 6;
                break;
            }
            case 163: {
                this.ea = this.ea_indexed(this.cycles);
                this.vecx.vectrexNonCPUStep(4);
                this.set_reg_d(this.inst_sub16(this.reg_a << 8 & 0xFF00 | this.reg_b & 0xFF, this.vecx.e6809_read8(this.ea) << 8 | this.vecx.e6809_read8(this.ea + 1)));
                this.vecx.vectrexNonCPUStep(2);
                this.cycles.intValue += 6;
                break;
            }
            case 179: {
                this.ea = this.vecx.e6809_read8(this.reg_pc) << 8 | this.vecx.e6809_read8(this.reg_pc + 1 & 0xFFFF);
                this.reg_pc = this.reg_pc + 2 & 0xFFFF;
                this.vecx.vectrexNonCPUStep(5);
                this.set_reg_d(this.inst_sub16(this.reg_a << 8 & 0xFF00 | this.reg_b & 0xFF, this.vecx.e6809_read8(this.ea) << 8 | this.vecx.e6809_read8(this.ea + 1)));
                this.vecx.vectrexNonCPUStep(2);
                this.cycles.intValue += 7;
                break;
            }
            case 140: {
                this.inst_sub16(this.reg_x, this.vecx.e6809_read8(this.reg_pc) << 8 | this.vecx.e6809_read8(this.reg_pc + 1 & 0xFFFF));
                this.reg_pc = this.reg_pc + 2 & 0xFFFF;
                this.cycles.intValue += 4;
                break;
            }
            case 156: {
                this.ea = this.reg_dp << 8 | this.vecx.e6809_read8(this.reg_pc);
                this.reg_pc = this.reg_pc + 1 & 0xFFFF;
                this.inst_sub16(this.reg_x, this.vecx.e6809_read8(this.ea) << 8 | this.vecx.e6809_read8(this.ea + 1));
                this.cycles.intValue += 6;
                break;
            }
            case 172: {
                this.ea = this.ea_indexed(this.cycles);
                this.inst_sub16(this.reg_x, this.vecx.e6809_read8(this.ea) << 8 | this.vecx.e6809_read8(this.ea + 1));
                this.cycles.intValue += 6;
                break;
            }
            case 188: {
                this.ea = this.vecx.e6809_read8(this.reg_pc) << 8 | this.vecx.e6809_read8(this.reg_pc + 1 & 0xFFFF);
                this.reg_pc = this.reg_pc + 2 & 0xFFFF;
                this.inst_sub16(this.reg_x, this.vecx.e6809_read8(this.ea) << 8 | this.vecx.e6809_read8(this.ea + 1));
                this.cycles.intValue += 7;
                break;
            }
            case 142: {
                this.reg_x = this.vecx.e6809_read8(this.reg_pc) << 8 | this.vecx.e6809_read8(this.reg_pc + 1 & 0xFFFF);
                this.reg_pc = this.reg_pc + 2 & 0xFFFF;
                this.reg_cc = (this.reg_x & 0x8000) == 32768 ? this.reg_cc | 8 : this.reg_cc & 0xFFFFFFF7;
                this.reg_cc = (this.reg_x & 0xFFFF) == 0 ? this.reg_cc | 4 : this.reg_cc & 0xFFFFFFFB;
                this.reg_cc &= 0xFFFFFFFD;
                this.cycles.intValue += 3;
                break;
            }
            case 158: {
                this.ea = this.reg_dp << 8 | this.vecx.e6809_read8(this.reg_pc);
                this.reg_pc = this.reg_pc + 1 & 0xFFFF;
                this.reg_x = this.vecx.e6809_read8(this.ea) << 8 | this.vecx.e6809_read8(this.ea + 1);
                this.reg_cc = (this.reg_x & 0x8000) == 32768 ? this.reg_cc | 8 : this.reg_cc & 0xFFFFFFF7;
                this.reg_cc = (this.reg_x & 0xFFFF) == 0 ? this.reg_cc | 4 : this.reg_cc & 0xFFFFFFFB;
                this.reg_cc &= 0xFFFFFFFD;
                this.cycles.intValue += 5;
                break;
            }
            case 174: {
                this.ea = this.ea_indexed(this.cycles);
                this.reg_x = this.vecx.e6809_read8(this.ea) << 8 | this.vecx.e6809_read8(this.ea + 1);
                this.reg_cc = (this.reg_x & 0x8000) == 32768 ? this.reg_cc | 8 : this.reg_cc & 0xFFFFFFF7;
                this.reg_cc = (this.reg_x & 0xFFFF) == 0 ? this.reg_cc | 4 : this.reg_cc & 0xFFFFFFFB;
                this.reg_cc &= 0xFFFFFFFD;
                this.cycles.intValue += 5;
                break;
            }
            case 190: {
                this.ea = this.vecx.e6809_read8(this.reg_pc) << 8 | this.vecx.e6809_read8(this.reg_pc + 1 & 0xFFFF);
                this.reg_pc = this.reg_pc + 2 & 0xFFFF;
                this.reg_x = this.vecx.e6809_read8(this.ea) << 8 | this.vecx.e6809_read8(this.ea + 1);
                this.reg_cc = (this.reg_x & 0x8000) == 32768 ? this.reg_cc | 8 : this.reg_cc & 0xFFFFFFF7;
                this.reg_cc = (this.reg_x & 0xFFFF) == 0 ? this.reg_cc | 4 : this.reg_cc & 0xFFFFFFFB;
                this.reg_cc &= 0xFFFFFFFD;
                this.cycles.intValue += 6;
                break;
            }
            case 206: {
                this.reg_u.intValue = this.vecx.e6809_read8(this.reg_pc) << 8 | this.vecx.e6809_read8(this.reg_pc + 1 & 0xFFFF);
                this.reg_pc = this.reg_pc + 2 & 0xFFFF;
                this.reg_cc = (this.reg_u.intValue & 0x8000) == 32768 ? this.reg_cc | 8 : this.reg_cc & 0xFFFFFFF7;
                this.reg_cc = (this.reg_u.intValue & 0xFFFF) == 0 ? this.reg_cc | 4 : this.reg_cc & 0xFFFFFFFB;
                this.reg_cc &= 0xFFFFFFFD;
                this.cycles.intValue += 3;
                break;
            }
            case 222: {
                this.ea = this.reg_dp << 8 | this.vecx.e6809_read8(this.reg_pc);
                this.reg_pc = this.reg_pc + 1 & 0xFFFF;
                this.reg_u.intValue = this.vecx.e6809_read8(this.ea) << 8 | this.vecx.e6809_read8(this.ea + 1);
                this.reg_cc = (this.reg_u.intValue & 0x8000) == 32768 ? this.reg_cc | 8 : this.reg_cc & 0xFFFFFFF7;
                this.reg_cc = (this.reg_u.intValue & 0xFFFF) == 0 ? this.reg_cc | 4 : this.reg_cc & 0xFFFFFFFB;
                this.reg_cc &= 0xFFFFFFFD;
                this.cycles.intValue += 5;
                break;
            }
            case 238: {
                this.ea = this.ea_indexed(this.cycles);
                this.reg_u.intValue = this.vecx.e6809_read8(this.ea) << 8 | this.vecx.e6809_read8(this.ea + 1);
                this.reg_cc = (this.reg_u.intValue & 0x8000) == 32768 ? this.reg_cc | 8 : this.reg_cc & 0xFFFFFFF7;
                this.reg_cc = (this.reg_u.intValue & 0xFFFF) == 0 ? this.reg_cc | 4 : this.reg_cc & 0xFFFFFFFB;
                this.reg_cc &= 0xFFFFFFFD;
                this.cycles.intValue += 5;
                break;
            }
            case 254: {
                this.ea = this.vecx.e6809_read8(this.reg_pc) << 8 | this.vecx.e6809_read8(this.reg_pc + 1 & 0xFFFF);
                this.reg_pc = this.reg_pc + 2 & 0xFFFF;
                this.reg_u.intValue = this.vecx.e6809_read8(this.ea) << 8 | this.vecx.e6809_read8(this.ea + 1);
                this.reg_cc = (this.reg_u.intValue & 0x8000) == 32768 ? this.reg_cc | 8 : this.reg_cc & 0xFFFFFFF7;
                this.reg_cc = (this.reg_u.intValue & 0xFFFF) == 0 ? this.reg_cc | 4 : this.reg_cc & 0xFFFFFFFB;
                this.reg_cc &= 0xFFFFFFFD;
                this.cycles.intValue += 6;
                break;
            }
            case 159: {
                this.ea = this.reg_dp << 8 | this.vecx.e6809_read8(this.reg_pc);
                this.reg_pc = this.reg_pc + 1 & 0xFFFF;
                this.vecx.vectrexNonCPUStep(4);
                this.vecx.e6809_write8(this.ea, this.reg_x >> 8);
                this.vecx.vectrexNonCPUStep(1);
                this.vecx.e6809_write8(this.ea + 1 & 0xFFFF, this.reg_x);
                this.reg_cc = (this.reg_x & 0x8000) == 32768 ? this.reg_cc | 8 : this.reg_cc & 0xFFFFFFF7;
                this.reg_cc = (this.reg_x & 0xFFFF) == 0 ? this.reg_cc | 4 : this.reg_cc & 0xFFFFFFFB;
                this.reg_cc &= 0xFFFFFFFD;
                this.cycles.intValue += 5;
                break;
            }
            case 175: {
                this.ea = this.ea_indexed(this.cycles);
                this.vecx.vectrexNonCPUStep(4);
                this.vecx.e6809_write8(this.ea, this.reg_x >> 8);
                this.vecx.vectrexNonCPUStep(1);
                this.vecx.e6809_write8(this.ea + 1 & 0xFFFF, this.reg_x);
                this.reg_cc = (this.reg_x & 0x8000) == 32768 ? this.reg_cc | 8 : this.reg_cc & 0xFFFFFFF7;
                this.reg_cc = (this.reg_x & 0xFFFF) == 0 ? this.reg_cc | 4 : this.reg_cc & 0xFFFFFFFB;
                this.reg_cc &= 0xFFFFFFFD;
                this.cycles.intValue += 5;
                break;
            }
            case 191: {
                this.ea = this.vecx.e6809_read8(this.reg_pc) << 8 | this.vecx.e6809_read8(this.reg_pc + 1 & 0xFFFF);
                this.reg_pc = this.reg_pc + 2 & 0xFFFF;
                this.vecx.vectrexNonCPUStep(5);
                this.vecx.e6809_write8(this.ea, this.reg_x >> 8);
                this.vecx.vectrexNonCPUStep(1);
                this.vecx.e6809_write8(this.ea + 1 & 0xFFFF, this.reg_x);
                this.reg_cc = (this.reg_x & 0x8000) == 32768 ? this.reg_cc | 8 : this.reg_cc & 0xFFFFFFF7;
                this.reg_cc = (this.reg_x & 0xFFFF) == 0 ? this.reg_cc | 4 : this.reg_cc & 0xFFFFFFFB;
                this.reg_cc &= 0xFFFFFFFD;
                this.cycles.intValue += 6;
                break;
            }
            case 223: {
                this.ea = this.reg_dp << 8 | this.vecx.e6809_read8(this.reg_pc);
                this.reg_pc = this.reg_pc + 1 & 0xFFFF;
                this.vecx.vectrexNonCPUStep(4);
                this.vecx.e6809_write8(this.ea, this.reg_u.intValue >> 8);
                this.vecx.vectrexNonCPUStep(1);
                this.vecx.e6809_write8(this.ea + 1 & 0xFFFF, this.reg_u.intValue);
                this.reg_cc = (this.reg_u.intValue & 0x8000) == 32768 ? this.reg_cc | 8 : this.reg_cc & 0xFFFFFFF7;
                this.reg_cc = (this.reg_u.intValue & 0xFFFF) == 0 ? this.reg_cc | 4 : this.reg_cc & 0xFFFFFFFB;
                this.reg_cc &= 0xFFFFFFFD;
                this.cycles.intValue += 5;
                break;
            }
            case 239: {
                this.ea = this.ea_indexed(this.cycles);
                this.vecx.vectrexNonCPUStep(4);
                this.vecx.e6809_write8(this.ea, this.reg_u.intValue >> 8);
                this.vecx.vectrexNonCPUStep(1);
                this.vecx.e6809_write8(this.ea + 1 & 0xFFFF, this.reg_u.intValue);
                this.reg_cc = (this.reg_u.intValue & 0x8000) == 32768 ? this.reg_cc | 8 : this.reg_cc & 0xFFFFFFF7;
                this.reg_cc = (this.reg_u.intValue & 0xFFFF) == 0 ? this.reg_cc | 4 : this.reg_cc & 0xFFFFFFFB;
                this.reg_cc &= 0xFFFFFFFD;
                this.cycles.intValue += 5;
                break;
            }
            case 255: {
                this.ea = this.vecx.e6809_read8(this.reg_pc) << 8 | this.vecx.e6809_read8(this.reg_pc + 1 & 0xFFFF);
                this.reg_pc = this.reg_pc + 2 & 0xFFFF;
                this.vecx.vectrexNonCPUStep(5);
                this.vecx.e6809_write8(this.ea, this.reg_u.intValue >> 8);
                this.vecx.vectrexNonCPUStep(1);
                this.vecx.e6809_write8(this.ea + 1 & 0xFFFF, this.reg_u.intValue);
                this.reg_cc = (this.reg_u.intValue & 0x8000) == 32768 ? this.reg_cc | 8 : this.reg_cc & 0xFFFFFFF7;
                this.reg_cc = (this.reg_u.intValue & 0xFFFF) == 0 ? this.reg_cc | 4 : this.reg_cc & 0xFFFFFFFB;
                this.reg_cc &= 0xFFFFFFFD;
                this.cycles.intValue += 6;
                break;
            }
            case 195: {
                this.set_reg_d(this.inst_add16(this.reg_a << 8 & 0xFF00 | this.reg_b & 0xFF, this.vecx.e6809_read8(this.reg_pc) << 8 | this.vecx.e6809_read8(this.reg_pc + 1 & 0xFFFF)));
                this.reg_pc = this.reg_pc + 2 & 0xFFFF;
                this.cycles.intValue += 4;
                break;
            }
            case 211: {
                this.ea = this.reg_dp << 8 | this.vecx.e6809_read8(this.reg_pc);
                this.reg_pc = this.reg_pc + 1 & 0xFFFF;
                this.set_reg_d(this.inst_add16(this.reg_a << 8 & 0xFF00 | this.reg_b & 0xFF, this.vecx.e6809_read8(this.ea) << 8 | this.vecx.e6809_read8(this.ea + 1 & 0xFFFF)));
                this.cycles.intValue += 6;
                break;
            }
            case 227: {
                this.ea = this.ea_indexed(this.cycles);
                this.set_reg_d(this.inst_add16(this.reg_a << 8 & 0xFF00 | this.reg_b & 0xFF, this.vecx.e6809_read8(this.ea) << 8 | this.vecx.e6809_read8(this.ea + 1)));
                this.cycles.intValue += 6;
                break;
            }
            case 243: {
                this.ea = this.vecx.e6809_read8(this.reg_pc) << 8 | this.vecx.e6809_read8(this.reg_pc + 1 & 0xFFFF);
                this.reg_pc = this.reg_pc + 2 & 0xFFFF;
                this.set_reg_d(this.inst_add16(this.reg_a << 8 & 0xFF00 | this.reg_b & 0xFF, this.vecx.e6809_read8(this.ea) << 8 | this.vecx.e6809_read8(this.ea + 1)));
                this.cycles.intValue += 7;
                break;
            }
            case 204: {
                this.set_reg_d(this.vecx.e6809_read8(this.reg_pc) << 8 | this.vecx.e6809_read8(this.reg_pc + 1 & 0xFFFF));
                this.reg_pc = this.reg_pc + 2 & 0xFFFF;
                this.reg_cc = (this.reg_a & 0x80) == 128 ? this.reg_cc | 8 : this.reg_cc & 0xFFFFFFF7;
                this.reg_cc = (this.reg_a + this.reg_b & 0xFFFF) == 0 ? this.reg_cc | 4 : this.reg_cc & 0xFFFFFFFB;
                this.reg_cc &= 0xFFFFFFFD;
                this.cycles.intValue += 3;
                break;
            }
            case 220: {
                this.ea = this.reg_dp << 8 | this.vecx.e6809_read8(this.reg_pc);
                this.reg_pc = this.reg_pc + 1 & 0xFFFF;
                this.vecx.vectrexNonCPUStep(4);
                this.tmp = this.vecx.e6809_read8(this.ea);
                this.vecx.vectrexNonCPUStep(1);
                this.set_reg_d(this.tmp << 8 | this.vecx.e6809_read8(this.ea + 1 & 0xFFFF));
                this.reg_cc = (this.reg_a & 0x80) == 128 ? this.reg_cc | 8 : this.reg_cc & 0xFFFFFFF7;
                this.reg_cc = (this.reg_a + this.reg_b & 0xFFFF) == 0 ? this.reg_cc | 4 : this.reg_cc & 0xFFFFFFFB;
                this.reg_cc &= 0xFFFFFFFD;
                this.cycles.intValue += 5;
                break;
            }
            case 236: {
                this.ea = this.ea_indexed(this.cycles);
                this.vecx.vectrexNonCPUStep(4);
                this.tmp = this.vecx.e6809_read8(this.ea);
                this.vecx.vectrexNonCPUStep(1);
                this.set_reg_d(this.tmp << 8 | this.vecx.e6809_read8(this.ea + 1 & 0xFFFF));
                this.reg_cc = (this.reg_a & 0x80) == 128 ? this.reg_cc | 8 : this.reg_cc & 0xFFFFFFF7;
                this.reg_cc = (this.reg_a + this.reg_b & 0xFFFF) == 0 ? this.reg_cc | 4 : this.reg_cc & 0xFFFFFFFB;
                this.reg_cc &= 0xFFFFFFFD;
                this.cycles.intValue += 5;
                break;
            }
            case 252: {
                this.ea = this.vecx.e6809_read8(this.reg_pc) << 8 | this.vecx.e6809_read8(this.reg_pc + 1 & 0xFFFF);
                this.reg_pc = this.reg_pc + 2 & 0xFFFF;
                this.vecx.vectrexNonCPUStep(5);
                this.tmp = this.vecx.e6809_read8(this.ea);
                this.vecx.vectrexNonCPUStep(1);
                this.set_reg_d(this.tmp << 8 | this.vecx.e6809_read8(this.ea + 1 & 0xFFFF));
                this.reg_cc = (this.reg_a & 0x80) == 128 ? this.reg_cc | 8 : this.reg_cc & 0xFFFFFFF7;
                this.reg_cc = (this.reg_a + this.reg_b & 0xFFFF) == 0 ? this.reg_cc | 4 : this.reg_cc & 0xFFFFFFFB;
                this.reg_cc &= 0xFFFFFFFD;
                this.cycles.intValue += 6;
                break;
            }
            case 221: {
                this.ea = this.reg_dp << 8 | this.vecx.e6809_read8(this.reg_pc);
                this.reg_pc = this.reg_pc + 1 & 0xFFFF;
                this.vecx.vectrexNonCPUStep(4);
                this.vecx.e6809_write8(this.ea, this.reg_a);
                this.vecx.vectrexNonCPUStep(1);
                this.vecx.e6809_write8(this.ea + 1 & 0xFFFF, this.reg_b);
                this.reg_cc = (this.reg_a & 0x80) == 128 ? this.reg_cc | 8 : this.reg_cc & 0xFFFFFFF7;
                this.reg_cc = (this.reg_a + this.reg_b & 0xFFFF) == 0 ? this.reg_cc | 4 : this.reg_cc & 0xFFFFFFFB;
                this.reg_cc &= 0xFFFFFFFD;
                this.cycles.intValue += 5;
                break;
            }
            case 237: {
                this.ea = this.ea_indexed(this.cycles);
                this.vecx.vectrexNonCPUStep(4);
                this.vecx.e6809_write8(this.ea, this.reg_a);
                this.vecx.vectrexNonCPUStep(1);
                this.vecx.e6809_write8(this.ea + 1 & 0xFFFF, this.reg_b);
                this.reg_cc = (this.reg_a & 0x80) == 128 ? this.reg_cc | 8 : this.reg_cc & 0xFFFFFFF7;
                this.reg_cc = (this.reg_a + this.reg_b & 0xFFFF) == 0 ? this.reg_cc | 4 : this.reg_cc & 0xFFFFFFFB;
                this.reg_cc &= 0xFFFFFFFD;
                this.cycles.intValue += 5;
                break;
            }
            case 253: {
                this.ea = this.vecx.e6809_read8(this.reg_pc) << 8 | this.vecx.e6809_read8(this.reg_pc + 1 & 0xFFFF);
                this.reg_pc = this.reg_pc + 2 & 0xFFFF;
                this.vecx.vectrexNonCPUStep(5);
                this.vecx.e6809_write8(this.ea, this.reg_a);
                this.vecx.vectrexNonCPUStep(1);
                this.vecx.e6809_write8(this.ea + 1 & 0xFFFF, this.reg_b);
                this.reg_cc = (this.reg_a & 0x80) == 128 ? this.reg_cc | 8 : this.reg_cc & 0xFFFFFFF7;
                this.reg_cc = (this.reg_a + this.reg_b & 0xFFFF) == 0 ? this.reg_cc | 4 : this.reg_cc & 0xFFFFFFFB;
                this.reg_cc &= 0xFFFFFFFD;
                this.cycles.intValue += 6;
                break;
            }
            case 18: {
                this.cycles.intValue += 2;
                break;
            }
            case 61: {
                this.r = (this.reg_a & 0xFF) * (this.reg_b & 0xFF);
                this.set_reg_d(this.r);
                this.reg_cc = (this.r & 0xFFFF) == 0 ? this.reg_cc | 4 : this.reg_cc & 0xFFFFFFFB;
                this.reg_cc = (this.r & 0x80) == 128 ? this.reg_cc | 1 : this.reg_cc & 0xFFFFFFFE;
                this.cycles.intValue += 11;
                break;
            }
            case 32: 
            case 33: {
                this.inst_bra8(false, this.op, this.cycles);
                break;
            }
            case 34: 
            case 35: {
                this.inst_bra8((this.reg_cc & 1) == 1 | (this.reg_cc & 4) == 4, this.op, this.cycles);
                break;
            }
            case 36: 
            case 37: {
                this.inst_bra8((this.reg_cc & 1) == 1, this.op, this.cycles);
                break;
            }
            case 38: 
            case 39: {
                this.inst_bra8((this.reg_cc & 4) == 4, this.op, this.cycles);
                break;
            }
            case 40: 
            case 41: {
                this.inst_bra8((this.reg_cc & 2) == 2, this.op, this.cycles);
                break;
            }
            case 42: 
            case 43: {
                this.inst_bra8((this.reg_cc & 8) == 8, this.op, this.cycles);
                break;
            }
            case 44: 
            case 45: {
                this.inst_bra8((this.reg_cc & 8) == 8 ^ (this.reg_cc & 2) == 2, this.op, this.cycles);
                break;
            }
            case 46: 
            case 47: {
                this.inst_bra8((this.reg_cc & 4) == 4 | (this.reg_cc & 8) == 8 ^ (this.reg_cc & 2) == 2, this.op, this.cycles);
                break;
            }
            case 22: {
                this.r = this.vecx.e6809_read8(this.reg_pc) << 8 | this.vecx.e6809_read8(this.reg_pc + 1 & 0xFFFF);
                this.reg_pc = this.reg_pc + this.r + 2 & 0xFFFF;
                this.cycles.intValue += 5;
                break;
            }
            case 23: {
                this.r = this.vecx.e6809_read8(this.reg_pc) << 8 | this.vecx.e6809_read8(this.reg_pc + 1 & 0xFFFF);
                this.reg_pc = this.reg_pc + 2 & 0xFFFF;
                this.push16(this.reg_s, this.reg_pc);
                ArrayList arrayList = this.callStack;
                synchronized (arrayList) {
                    this.callStack.add(this.reg_pc & 0xFFFF);
                }
                this.reg_pc = this.reg_pc + this.r & 0xFFFF;
                this.cycles.intValue += 9;
                break;
            }
            case 141: {
                this.r = this.vecx.e6809_read8(this.reg_pc);
                this.reg_pc = this.reg_pc + 1 & 0xFFFF;
                this.push16(this.reg_s, this.reg_pc);
                ArrayList arrayList = this.callStack;
                synchronized (arrayList) {
                    this.callStack.add(this.reg_pc & 0xFFFF);
                }
                if (this.profiler != null) {
                    this.profiler.addContext(this.reg_pc + this.sign_extend(this.r) & 0xFFFF, this.reg_s.intValue, this.reg_pc & 0xFFFF, this.orgPC & 0xFFFF);
                }
                this.reg_pc = this.reg_pc + this.sign_extend(this.r) & 0xFFFF;
                this.cycles.intValue += 7;
                break;
            }
            case 157: {
                this.ea = this.reg_dp << 8 | this.vecx.e6809_read8(this.reg_pc);
                this.reg_pc = this.reg_pc + 1 & 0xFFFF;
                this.push16(this.reg_s, this.reg_pc);
                ArrayList arrayList = this.callStack;
                synchronized (arrayList) {
                    this.callStack.add(this.reg_pc & 0xFFFF);
                }
                if (this.profiler != null) {
                    this.profiler.addContext(this.ea, this.reg_s.intValue, this.reg_pc & 0xFFFF, this.orgPC & 0xFFFF);
                }
                this.reg_pc = this.ea;
                this.cycles.intValue += 7;
                break;
            }
            case 173: {
                this.ea = this.ea_indexed(this.cycles);
                this.push16(this.reg_s, this.reg_pc);
                ArrayList arrayList = this.callStack;
                synchronized (arrayList) {
                    this.callStack.add(this.reg_pc & 0xFFFF);
                }
                if (this.profiler != null) {
                    this.profiler.addContext(this.ea, this.reg_s.intValue, this.reg_pc & 0xFFFF, this.orgPC & 0xFFFF);
                }
                this.reg_pc = this.ea;
                this.cycles.intValue += 7;
                break;
            }
            case 189: {
                this.ea = this.vecx.e6809_read8(this.reg_pc) << 8 | this.vecx.e6809_read8(this.reg_pc + 1 & 0xFFFF);
                this.reg_pc = this.reg_pc + 2 & 0xFFFF;
                this.push16(this.reg_s, this.reg_pc);
                ArrayList arrayList = this.callStack;
                synchronized (arrayList) {
                    this.callStack.add(this.reg_pc & 0xFFFF);
                }
                if (this.profiler != null) {
                    this.profiler.addContext(this.ea, this.reg_s.intValue, this.reg_pc & 0xFFFF, this.orgPC & 0xFFFF);
                }
                this.reg_pc = this.ea;
                this.cycles.intValue += 8;
                break;
            }
            case 48: {
                this.reg_x = this.ea_indexed(this.cycles);
                this.reg_cc = (this.reg_x & 0xFFFF) == 0 ? this.reg_cc | 4 : this.reg_cc & 0xFFFFFFFB;
                this.cycles.intValue += 4;
                break;
            }
            case 49: {
                this.reg_y = this.ea_indexed(this.cycles);
                this.reg_cc = (this.reg_y & 0xFFFF) == 0 ? this.reg_cc | 4 : this.reg_cc & 0xFFFFFFFB;
                this.cycles.intValue += 4;
                break;
            }
            case 50: {
                this.reg_s.intValue = this.ea_indexed(this.cycles);
                this.cycles.intValue += 4;
                break;
            }
            case 51: {
                this.reg_u.intValue = this.ea_indexed(this.cycles);
                this.cycles.intValue += 4;
                break;
            }
            case 52: {
                this.inst_psh(this.vecx.e6809_read8(this.reg_pc), this.reg_s, this.reg_u, this.cycles);
                this.reg_pc = this.reg_pc + 1 & 0xFFFF;
                this.cycles.intValue += 5;
                break;
            }
            case 53: {
                this.inst_pul(this.vecx.e6809_read8(this.reg_pc++), this.reg_s, this.reg_u, this.cycles);
                this.reg_pc &= 0xFFFF;
                this.cycles.intValue += 5;
                break;
            }
            case 54: {
                this.inst_psh(this.vecx.e6809_read8(this.reg_pc), this.reg_u, this.reg_s, this.cycles);
                this.reg_pc = this.reg_pc + 1 & 0xFFFF;
                this.cycles.intValue += 5;
                break;
            }
            case 55: {
                this.inst_pul(this.vecx.e6809_read8(this.reg_pc++), this.reg_u, this.reg_s, this.cycles);
                this.reg_pc &= 0xFFFF;
                this.cycles.intValue += 5;
                break;
            }
            case 57: {
                this.reg_pc = this.pull16(this.reg_s);
                ArrayList arrayList = this.callStack;
                synchronized (arrayList) {
                    if (this.callStack.size() > 0) {
                        this.callStack.remove(this.callStack.size() - 1);
                    }
                }
                this.cycles.intValue += 5;
                break;
            }
            case 58: {
                this.reg_x += this.reg_b & 0xFF;
                this.cycles.intValue += 3;
                break;
            }
            case 26: {
                this.reg_cc |= this.vecx.e6809_read8(this.reg_pc);
                this.reg_pc = this.reg_pc + 1 & 0xFFFF;
                this.cycles.intValue += 3;
                break;
            }
            case 28: {
                this.reg_cc &= this.vecx.e6809_read8(this.reg_pc);
                this.reg_pc = this.reg_pc + 1 & 0xFFFF;
                this.cycles.intValue += 3;
                break;
            }
            case 29: {
                this.set_reg_d(this.sign_extend(this.reg_b));
                this.reg_cc = (this.reg_a & 0x80) == 128 ? this.reg_cc | 8 : this.reg_cc & 0xFFFFFFF7;
                this.reg_cc = (this.reg_a + this.reg_b & 0xFFFF) == 0 ? this.reg_cc | 4 : this.reg_cc & 0xFFFFFFFB;
                this.cycles.intValue += 2;
                break;
            }
            case 30: {
                this.inst_exg();
                this.cycles.intValue += 8;
                break;
            }
            case 31: {
                this.inst_tfr();
                this.cycles.intValue += 6;
                break;
            }
            case 59: {
                this.inst_pul(1, this.reg_s, this.reg_u, this.cycles);
                if ((this.reg_cc & 0x80) == 128) {
                    this.inst_pul(254, this.reg_s, this.reg_u, this.cycles);
                } else {
                    this.inst_pul(128, this.reg_s, this.reg_u, this.cycles);
                }
                this.cycles.intValue += 3;
                break;
            }
            case 63: {
                this.reg_cc |= 0x80;
                this.inst_psh(255, this.reg_s, this.reg_u, this.cycles);
                this.reg_cc |= 0x10;
                this.reg_cc |= 0x40;
                this.reg_pc = this.vecx.e6809_read8(65530) << 8 | this.vecx.e6809_read8(65531);
                this.cycles.intValue += 7;
                break;
            }
            case 19: {
                this.irq_status = 1;
                this.cycles.intValue += 2;
                break;
            }
            case 25: {
                this.i0 = this.reg_a;
                this.i1 = 0;
                if ((this.reg_a & 0xF) > 9 || (this.reg_cc & 0x20) == 32) {
                    this.i1 |= 6;
                }
                if ((this.reg_a & 0xF0) > 128 && (this.reg_a & 0xF) > 9) {
                    this.i1 |= 0x60;
                }
                if ((this.reg_a & 0xF0) > 144 || (this.reg_cc & 1) == 1) {
                    this.i1 |= 0x60;
                }
                this.reg_a = this.i0 + this.i1 & 0xFF;
                this.reg_cc = (this.reg_a & 0x80) == 128 ? this.reg_cc | 8 : this.reg_cc & 0xFFFFFFF7;
                this.reg_cc = (this.reg_a & 0xFF) == 0 ? this.reg_cc | 4 : this.reg_cc & 0xFFFFFFFB;
                this.reg_cc &= 0xFFFFFFFD;
                this.reg_cc = this.test_c(this.i0, this.i1, this.reg_a, false) ? this.reg_cc | 1 : this.reg_cc & 0xFFFFFFFE;
                this.cycles.intValue += 2;
                break;
            }
            case 60: {
                this.reg_cc &= this.vecx.e6809_read8(this.reg_pc);
                this.reg_pc = this.reg_pc + 1 & 0xFFFF;
                this.reg_cc |= 0x80;
                this.inst_psh(255, this.reg_s, this.reg_u, this.cycles);
                this.irq_status = 2;
                this.cycles.intValue += 4;
                break;
            }
            case 16: {
                this.op = this.vecx.e6809_read8(this.reg_pc);
                this.reg_pc = this.reg_pc + 1 & 0xFFFF;
                this.vecx.vectrexNonCPUStep(2);
                switch (this.op) {
                    case 32: 
                    case 33: {
                        this.inst_bra16(false, this.op, this.cycles);
                        break block12;
                    }
                    case 34: 
                    case 35: {
                        this.inst_bra16((this.reg_cc & 1) == 1 | (this.reg_cc & 4) == 4, this.op, this.cycles);
                        break block12;
                    }
                    case 36: 
                    case 37: {
                        this.inst_bra16((this.reg_cc & 1) == 1, this.op, this.cycles);
                        break block12;
                    }
                    case 38: 
                    case 39: {
                        this.inst_bra16((this.reg_cc & 4) == 4, this.op, this.cycles);
                        break block12;
                    }
                    case 40: 
                    case 41: {
                        this.inst_bra16((this.reg_cc & 2) == 2, this.op, this.cycles);
                        break block12;
                    }
                    case 42: 
                    case 43: {
                        this.inst_bra16((this.reg_cc & 8) == 8, this.op, this.cycles);
                        break block12;
                    }
                    case 44: 
                    case 45: {
                        this.inst_bra16((this.reg_cc & 8) == 8 ^ (this.reg_cc & 2) == 2, this.op, this.cycles);
                        break block12;
                    }
                    case 46: 
                    case 47: {
                        this.inst_bra16((this.reg_cc & 4) == 4 | (this.reg_cc & 8) == 8 ^ (this.reg_cc & 2) == 2, this.op, this.cycles);
                        break block12;
                    }
                    case 131: {
                        this.inst_sub16(this.reg_a << 8 & 0xFF00 | this.reg_b & 0xFF, this.vecx.e6809_read8(this.reg_pc) << 8 | this.vecx.e6809_read8(this.reg_pc + 1 & 0xFFFF));
                        this.reg_pc = this.reg_pc + 2 & 0xFFFF;
                        this.cycles.intValue += 5;
                        break block12;
                    }
                    case 147: {
                        this.ea = this.reg_dp << 8 | this.vecx.e6809_read8(this.reg_pc);
                        this.reg_pc = this.reg_pc + 1 & 0xFFFF;
                        this.vecx.vectrexNonCPUStep(5);
                        this.tmp = this.vecx.e6809_read8(this.ea);
                        this.vecx.vectrexNonCPUStep(1);
                        this.inst_sub16(this.reg_a << 8 & 0xFF00 | this.reg_b & 0xFF, this.tmp << 8 | this.vecx.e6809_read8(this.ea + 1 & 0xFFFF));
                        this.vecx.vectrexNonCPUStep(1);
                        this.cycles.intValue += 7;
                        break block12;
                    }
                    case 163: {
                        this.ea = this.ea_indexed(this.cycles);
                        this.vecx.vectrexNonCPUStep(5);
                        this.tmp = this.vecx.e6809_read8(this.ea);
                        this.vecx.vectrexNonCPUStep(1);
                        this.inst_sub16(this.reg_a << 8 & 0xFF00 | this.reg_b & 0xFF, this.tmp << 8 | this.vecx.e6809_read8(this.ea + 1 & 0xFFFF));
                        this.vecx.vectrexNonCPUStep(1);
                        this.cycles.intValue += 7;
                        break block12;
                    }
                    case 179: {
                        this.ea = this.vecx.e6809_read8(this.reg_pc) << 8 | this.vecx.e6809_read8(this.reg_pc + 1 & 0xFFFF);
                        this.reg_pc = this.reg_pc + 2 & 0xFFFF;
                        this.vecx.vectrexNonCPUStep(6);
                        this.tmp = this.vecx.e6809_read8(this.ea);
                        this.vecx.vectrexNonCPUStep(1);
                        this.inst_sub16(this.reg_a << 8 & 0xFF00 | this.reg_b & 0xFF, this.tmp << 8 | this.vecx.e6809_read8(this.ea + 1 & 0xFFFF));
                        this.vecx.vectrexNonCPUStep(1);
                        this.cycles.intValue += 8;
                        break block12;
                    }
                    case 140: {
                        this.inst_sub16(this.reg_y, this.vecx.e6809_read8(this.reg_pc) << 8 | this.vecx.e6809_read8(this.reg_pc + 1 & 0xFFFF));
                        this.reg_pc = this.reg_pc + 2 & 0xFFFF;
                        this.cycles.intValue += 5;
                        break block12;
                    }
                    case 156: {
                        this.ea = this.reg_dp << 8 | this.vecx.e6809_read8(this.reg_pc);
                        this.reg_pc = this.reg_pc + 1 & 0xFFFF;
                        this.inst_sub16(this.reg_y, this.vecx.e6809_read8(this.ea) << 8 | this.vecx.e6809_read8(this.ea + 1));
                        this.cycles.intValue += 7;
                        break block12;
                    }
                    case 172: {
                        this.ea = this.ea_indexed(this.cycles);
                        this.inst_sub16(this.reg_y, this.vecx.e6809_read8(this.ea) << 8 | this.vecx.e6809_read8(this.ea + 1));
                        this.cycles.intValue += 7;
                        break block12;
                    }
                    case 188: {
                        this.ea = this.vecx.e6809_read8(this.reg_pc) << 8 | this.vecx.e6809_read8(this.reg_pc + 1 & 0xFFFF);
                        this.reg_pc = this.reg_pc + 2 & 0xFFFF;
                        this.inst_sub16(this.reg_y, this.vecx.e6809_read8(this.ea) << 8 | this.vecx.e6809_read8(this.ea + 1));
                        this.cycles.intValue += 8;
                        break block12;
                    }
                    case 142: {
                        this.reg_y = this.vecx.e6809_read8(this.reg_pc) << 8 | this.vecx.e6809_read8(this.reg_pc + 1 & 0xFFFF);
                        this.reg_pc = this.reg_pc + 2 & 0xFFFF;
                        this.reg_cc = (this.reg_y & 0x8000) == 32768 ? this.reg_cc | 8 : this.reg_cc & 0xFFFFFFF7;
                        this.reg_cc = (this.reg_y & 0xFFFF) == 0 ? this.reg_cc | 4 : this.reg_cc & 0xFFFFFFFB;
                        this.reg_cc &= 0xFFFFFFFD;
                        this.cycles.intValue += 4;
                        break block12;
                    }
                    case 158: {
                        this.ea = this.reg_dp << 8 | this.vecx.e6809_read8(this.reg_pc);
                        this.reg_pc = this.reg_pc + 1 & 0xFFFF;
                        this.reg_y = this.vecx.e6809_read8(this.ea) << 8 | this.vecx.e6809_read8(this.ea + 1);
                        this.reg_cc = (this.reg_y & 0x8000) == 32768 ? this.reg_cc | 8 : this.reg_cc & 0xFFFFFFF7;
                        this.reg_cc = (this.reg_y & 0xFFFF) == 0 ? this.reg_cc | 4 : this.reg_cc & 0xFFFFFFFB;
                        this.reg_cc &= 0xFFFFFFFD;
                        this.cycles.intValue += 6;
                        break block12;
                    }
                    case 174: {
                        this.ea = this.ea_indexed(this.cycles);
                        this.reg_y = this.vecx.e6809_read8(this.ea) << 8 | this.vecx.e6809_read8(this.ea + 1);
                        this.reg_cc = (this.reg_y & 0x8000) == 32768 ? this.reg_cc | 8 : this.reg_cc & 0xFFFFFFF7;
                        this.reg_cc = (this.reg_y & 0xFFFF) == 0 ? this.reg_cc | 4 : this.reg_cc & 0xFFFFFFFB;
                        this.reg_cc &= 0xFFFFFFFD;
                        this.cycles.intValue += 6;
                        break block12;
                    }
                    case 190: {
                        this.ea = this.vecx.e6809_read8(this.reg_pc) << 8 | this.vecx.e6809_read8(this.reg_pc + 1 & 0xFFFF);
                        this.reg_pc = this.reg_pc + 2 & 0xFFFF;
                        this.reg_y = this.vecx.e6809_read8(this.ea) << 8 | this.vecx.e6809_read8(this.ea + 1 & 0xFFFF);
                        this.reg_cc = (this.reg_y & 0x8000) == 32768 ? this.reg_cc | 8 : this.reg_cc & 0xFFFFFFF7;
                        this.reg_cc = (this.reg_y & 0xFFFF) == 0 ? this.reg_cc | 4 : this.reg_cc & 0xFFFFFFFB;
                        this.reg_cc &= 0xFFFFFFFD;
                        this.cycles.intValue += 7;
                        break block12;
                    }
                    case 159: {
                        this.ea = this.reg_dp << 8 | this.vecx.e6809_read8(this.reg_pc);
                        this.reg_pc = this.reg_pc + 1 & 0xFFFF;
                        this.vecx.e6809_write8(this.ea, this.reg_y >> 8);
                        this.vecx.e6809_write8(this.ea + 1 & 0xFFFF, this.reg_y);
                        this.reg_cc = (this.reg_y & 0x8000) == 32768 ? this.reg_cc | 8 : this.reg_cc & 0xFFFFFFF7;
                        this.reg_cc = (this.reg_y & 0xFFFF) == 0 ? this.reg_cc | 4 : this.reg_cc & 0xFFFFFFFB;
                        this.reg_cc &= 0xFFFFFFFD;
                        this.cycles.intValue += 6;
                        break block12;
                    }
                    case 175: {
                        this.ea = this.ea_indexed(this.cycles);
                        this.vecx.e6809_write8(this.ea, this.reg_y >> 8);
                        this.vecx.e6809_write8(this.ea + 1 & 0xFFFF, this.reg_y);
                        this.reg_cc = (this.reg_y & 0x8000) == 32768 ? this.reg_cc | 8 : this.reg_cc & 0xFFFFFFF7;
                        this.reg_cc = (this.reg_y & 0xFFFF) == 0 ? this.reg_cc | 4 : this.reg_cc & 0xFFFFFFFB;
                        this.reg_cc &= 0xFFFFFFFD;
                        this.cycles.intValue += 6;
                        break block12;
                    }
                    case 191: {
                        this.ea = this.vecx.e6809_read8(this.reg_pc) << 8 | this.vecx.e6809_read8(this.reg_pc + 1 & 0xFFFF);
                        this.reg_pc = this.reg_pc + 2 & 0xFFFF;
                        this.vecx.e6809_write8(this.ea, this.reg_y >> 8);
                        this.vecx.e6809_write8(this.ea + 1 & 0xFFFF, this.reg_y);
                        this.reg_cc = (this.reg_y & 0x8000) == 32768 ? this.reg_cc | 8 : this.reg_cc & 0xFFFFFFF7;
                        this.reg_cc = (this.reg_y & 0xFFFF) == 0 ? this.reg_cc | 4 : this.reg_cc & 0xFFFFFFFB;
                        this.reg_cc &= 0xFFFFFFFD;
                        this.cycles.intValue += 7;
                        break block12;
                    }
                    case 206: {
                        this.reg_s.intValue = this.vecx.e6809_read8(this.reg_pc) << 8 | this.vecx.e6809_read8(this.reg_pc + 1 & 0xFFFF);
                        this.reg_pc = this.reg_pc + 2 & 0xFFFF;
                        this.reg_cc = (this.reg_s.intValue & 0x8000) == 32768 ? this.reg_cc | 8 : this.reg_cc & 0xFFFFFFF7;
                        this.reg_cc = (this.reg_s.intValue & 0xFFFF) == 0 ? this.reg_cc | 4 : this.reg_cc & 0xFFFFFFFB;
                        this.reg_cc &= 0xFFFFFFFD;
                        this.cycles.intValue += 4;
                        this.resetCallstack();
                        break block12;
                    }
                    case 222: {
                        this.ea = this.reg_dp << 8 | this.vecx.e6809_read8(this.reg_pc);
                        this.reg_pc = this.reg_pc + 1 & 0xFFFF;
                        this.reg_s.intValue = this.vecx.e6809_read8(this.ea) << 8 | this.vecx.e6809_read8(this.ea + 1);
                        this.reg_cc = (this.reg_s.intValue & 0x8000) == 32768 ? this.reg_cc | 8 : this.reg_cc & 0xFFFFFFF7;
                        this.reg_cc = (this.reg_s.intValue & 0xFFFF) == 0 ? this.reg_cc | 4 : this.reg_cc & 0xFFFFFFFB;
                        this.reg_cc &= 0xFFFFFFFD;
                        this.cycles.intValue += 6;
                        this.resetCallstack();
                        break block12;
                    }
                    case 238: {
                        this.ea = this.ea_indexed(this.cycles);
                        this.reg_s.intValue = this.vecx.e6809_read8(this.ea) << 8 | this.vecx.e6809_read8(this.ea + 1);
                        this.reg_cc = (this.reg_s.intValue & 0x8000) == 32768 ? this.reg_cc | 8 : this.reg_cc & 0xFFFFFFF7;
                        this.reg_cc = (this.reg_s.intValue & 0xFFFF) == 0 ? this.reg_cc | 4 : this.reg_cc & 0xFFFFFFFB;
                        this.reg_cc &= 0xFFFFFFFD;
                        this.cycles.intValue += 6;
                        this.resetCallstack();
                        break block12;
                    }
                    case 254: {
                        this.ea = this.vecx.e6809_read8(this.reg_pc) << 8 | this.vecx.e6809_read8(this.reg_pc + 1 & 0xFFFF);
                        this.reg_pc = this.reg_pc + 2 & 0xFFFF;
                        this.reg_s.intValue = this.vecx.e6809_read8(this.ea) << 8 | this.vecx.e6809_read8(this.ea + 1);
                        this.reg_cc = (this.reg_s.intValue & 0x8000) == 32768 ? this.reg_cc | 8 : this.reg_cc & 0xFFFFFFF7;
                        this.reg_cc = (this.reg_s.intValue & 0xFFFF) == 0 ? this.reg_cc | 4 : this.reg_cc & 0xFFFFFFFB;
                        this.reg_cc &= 0xFFFFFFFD;
                        this.cycles.intValue += 7;
                        this.resetCallstack();
                        break block12;
                    }
                    case 223: {
                        this.ea = this.reg_dp << 8 | this.vecx.e6809_read8(this.reg_pc);
                        this.reg_pc = this.reg_pc + 1 & 0xFFFF;
                        this.vecx.e6809_write8(this.ea, this.reg_s.intValue >> 8);
                        this.vecx.e6809_write8(this.ea + 1 & 0xFFFF, this.reg_s.intValue);
                        this.reg_cc = (this.reg_s.intValue & 0x8000) == 32768 ? this.reg_cc | 8 : this.reg_cc & 0xFFFFFFF7;
                        this.reg_cc = (this.reg_s.intValue & 0xFFFF) == 0 ? this.reg_cc | 4 : this.reg_cc & 0xFFFFFFFB;
                        this.reg_cc &= 0xFFFFFFFD;
                        this.cycles.intValue += 6;
                        break block12;
                    }
                    case 239: {
                        this.ea = this.ea_indexed(this.cycles);
                        this.vecx.e6809_write8(this.ea, this.reg_s.intValue >> 8);
                        this.vecx.e6809_write8(this.ea + 1 & 0xFFFF, this.reg_s.intValue);
                        this.reg_cc = (this.reg_s.intValue & 0x8000) == 32768 ? this.reg_cc | 8 : this.reg_cc & 0xFFFFFFF7;
                        this.reg_cc = (this.reg_s.intValue & 0xFFFF) == 0 ? this.reg_cc | 4 : this.reg_cc & 0xFFFFFFFB;
                        this.reg_cc &= 0xFFFFFFFD;
                        this.cycles.intValue += 6;
                        break block12;
                    }
                    case 255: {
                        this.ea = this.vecx.e6809_read8(this.reg_pc) << 8 | this.vecx.e6809_read8(this.reg_pc + 1 & 0xFFFF);
                        this.reg_pc = this.reg_pc + 2 & 0xFFFF;
                        this.vecx.e6809_write8(this.ea, this.reg_s.intValue >> 8);
                        this.vecx.e6809_write8(this.ea + 1 & 0xFFFF, this.reg_s.intValue);
                        this.reg_cc = (this.reg_s.intValue & 0x8000) == 32768 ? this.reg_cc | 8 : this.reg_cc & 0xFFFFFFF7;
                        this.reg_cc = (this.reg_s.intValue & 0xFFFF) == 0 ? this.reg_cc | 4 : this.reg_cc & 0xFFFFFFFB;
                        this.reg_cc &= 0xFFFFFFFD;
                        this.cycles.intValue += 7;
                        break block12;
                    }
                    case 63: {
                        this.reg_cc |= 0x80;
                        this.inst_psh(255, this.reg_s, this.reg_u, this.cycles);
                        this.reg_pc = this.vecx.e6809_read8(65524) << 8 | this.vecx.e6809_read8(65525);
                        this.cycles.intValue += 8;
                        break block12;
                    }
                }
                System.out.println("unknown page-1 op code: " + this.op + "\n");
                break;
            }
            case 17: {
                this.op = this.vecx.e6809_read8(this.reg_pc);
                this.reg_pc = this.reg_pc + 1 & 0xFFFF;
                this.vecx.vectrexNonCPUStep(2);
                switch (this.op) {
                    case 131: {
                        this.inst_sub16(this.reg_u.intValue, this.vecx.e6809_read8(this.reg_pc) << 8 | this.vecx.e6809_read8(this.reg_pc + 1 & 0xFFFF));
                        this.reg_pc = this.reg_pc + 2 & 0xFFFF;
                        this.cycles.intValue += 5;
                        break block12;
                    }
                    case 147: {
                        this.ea = this.reg_dp << 8 | this.vecx.e6809_read8(this.reg_pc);
                        this.reg_pc = this.reg_pc + 1 & 0xFFFF;
                        this.inst_sub16(this.reg_u.intValue, this.vecx.e6809_read8(this.ea) << 8 | this.vecx.e6809_read8(this.ea + 1));
                        this.cycles.intValue += 7;
                        break block12;
                    }
                    case 163: {
                        this.ea = this.ea_indexed(this.cycles);
                        this.inst_sub16(this.reg_u.intValue, this.vecx.e6809_read8(this.ea) << 8 | this.vecx.e6809_read8(this.ea + 1));
                        this.cycles.intValue += 7;
                        break block12;
                    }
                    case 179: {
                        this.ea = this.vecx.e6809_read8(this.reg_pc) << 8 | this.vecx.e6809_read8(this.reg_pc + 1 & 0xFFFF);
                        this.reg_pc = this.reg_pc + 2 & 0xFFFF;
                        this.inst_sub16(this.reg_u.intValue, this.vecx.e6809_read8(this.ea) << 8 | this.vecx.e6809_read8(this.ea + 1));
                        this.cycles.intValue += 8;
                        break block12;
                    }
                    case 140: {
                        this.inst_sub16(this.reg_s.intValue, this.vecx.e6809_read8(this.reg_pc) << 8 | this.vecx.e6809_read8(this.reg_pc + 1 & 0xFFFF));
                        this.reg_pc = this.reg_pc + 2 & 0xFFFF;
                        this.cycles.intValue += 5;
                        break block12;
                    }
                    case 156: {
                        this.ea = this.reg_dp << 8 | this.vecx.e6809_read8(this.reg_pc);
                        this.reg_pc = this.reg_pc + 1 & 0xFFFF;
                        this.inst_sub16(this.reg_s.intValue, this.vecx.e6809_read8(this.ea) << 8 | this.vecx.e6809_read8(this.ea + 1));
                        this.cycles.intValue += 7;
                        break block12;
                    }
                    case 172: {
                        this.ea = this.ea_indexed(this.cycles);
                        this.inst_sub16(this.reg_s.intValue, this.vecx.e6809_read8(this.ea) << 8 | this.vecx.e6809_read8(this.ea + 1));
                        this.cycles.intValue += 7;
                        break block12;
                    }
                    case 188: {
                        this.ea = this.vecx.e6809_read8(this.reg_pc) << 8 | this.vecx.e6809_read8(this.reg_pc + 1 & 0xFFFF);
                        this.reg_pc = this.reg_pc + 2 & 0xFFFF;
                        this.inst_sub16(this.reg_s.intValue, this.vecx.e6809_read8(this.ea) << 8 | this.vecx.e6809_read8(this.ea + 1));
                        this.cycles.intValue += 8;
                        break block12;
                    }
                    case 63: {
                        this.reg_cc |= 0x80;
                        this.inst_psh(255, this.reg_s, this.reg_u, this.cycles);
                        this.reg_pc = this.vecx.e6809_read8(65522) << 8 | this.vecx.e6809_read8(65523);
                        this.cycles.intValue += 8;
                        break block12;
                    }
                }
                System.out.println("unknown page-2 op code: " + this.op + "\n");
                break;
            }
            default: {
                System.out.println("unknown page-0 op code: " + this.op + "PC: " + this.reg_pc + "\n");
            }
        }
        this.cyclesRunning += (long)this.cycles.intValue;
        return this.cycles.intValue;
    }

    public int getAddressBUS() {
        return this.addressBUS;
    }

    public byte getDataBUS() {
        return (byte)(this.dataBUS & 0xFF);
    }
}

