/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.vecx;

import de.malban.vide.vecx.VecX;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;

public class Profiler
implements Serializable {
    public static HashMap<Integer, Integer> lockMap = new HashMap();
    public boolean finalOnly = false;
    public boolean trackingOnly = true;
    public long overallCycles = 0L;
    public long overallInstructions = 0L;
    public long track_overallCycles = 0L;
    public long track_overallInstructions = 0L;
    public long track_overallCycles_final = 0L;
    public long track_overallInstructions_final = 0L;
    public ProfilerMemoryLocation[] memory = new ProfilerMemoryLocation[65536];
    public ArrayList<ProfilerMemoryLocation> routines = new ArrayList();
    HashMap<ProfilerMemoryLocation, ProfilerMemoryLocation> routinesMap = new HashMap();
    ArrayList<Context> currentContext = new ArrayList();
    public static final int P_MEMORY = 0;
    public static final int P_INIT_SUBROUTINE = 1;
    public static final int P_EXIT_SUBROUTINE = 2;

    private static void deInitLock() {
        lockMap.clear();
    }

    private static void addLock(int address) {
        lockMap.put(address, address);
    }

    private static boolean isLocked(int address) {
        return lockMap.get(address) != null;
    }

    public void trackPointReached() {
        for (int i = 0; i < 65536; ++i) {
            this.memory[i].lastTrack_accessCount_final = this.memory[i].lastTrack_accessCount;
            this.memory[i].lastTrack_accessCountSum_final = this.memory[i].lastTrack_accessCountSum;
            this.memory[i].lastTrack_accessCycles_final = this.memory[i].lastTrack_accessCycles;
            this.memory[i].lastTrack_accessCyclesSum_final = this.memory[i].lastTrack_accessCyclesSum;
            this.memory[i].caller_lastTrack_accessCyclesSum_final = this.memory[i].caller_lastTrack_accessCyclesSum;
            this.memory[i].lastTrack_accessCount = 0L;
            this.memory[i].lastTrack_accessCountSum = 0L;
            this.memory[i].lastTrack_accessCycles = 0L;
            this.memory[i].lastTrack_accessCyclesSum = 0L;
            this.memory[i].caller_lastTrack_accessCyclesSum = 0L;
        }
        this.track_overallCycles_final = this.track_overallCycles;
        this.track_overallInstructions_final = this.track_overallInstructions;
        this.track_overallCycles = 0L;
        this.track_overallInstructions = 0L;
    }

    public void addName(int address, String name) {
        ProfilerMemoryLocation loc = this.memory[address];
        loc.name = name == null ? "_" + address : name;
    }

    public void addRoutine(int address, String name) {
        ProfilerMemoryLocation loc = this.memory[address];
        if (this.routinesMap.get(loc) == null) {
            if (name == null) {
                if (loc.name.length() == 0) {
                    loc.name = "_" + address;
                }
            } else {
                loc.name = name;
            }
            this.routinesMap.put(loc, loc);
            this.routines.add(loc);
            Collections.sort(this.routines, new Comparator<ProfilerMemoryLocation>(){

                @Override
                public int compare(ProfilerMemoryLocation p1, ProfilerMemoryLocation p2) {
                    return p1.address - p2.address;
                }
            });
        }
    }

    public void accessed(int address, int cycles) {
        this.accessed_internal(address, cycles);
        Profiler.deInitLock();
    }

    private void accessed_internal(int address, int cycles) {
        if (address == -1) {
            return;
        }
        this.overallCycles += (long)cycles;
        ++this.overallInstructions;
        this.track_overallCycles += (long)cycles;
        ++this.track_overallInstructions;
        this.memory[address].access(cycles);
        Profiler.addLock(address);
        for (Context c : this.currentContext) {
            c.mem.contextAccess(cycles);
            int callerAddress = c.callingAddress;
            if (callerAddress == -1) continue;
            this.memory[callerAddress].sumAccess(cycles);
            Profiler.addLock(callerAddress);
        }
    }

    public void addContext(int address, int stackAddress, int returnAddress, int callerAddress) {
        ProfilerMemoryLocation loc = this.memory[address];
        Context c = new Context();
        this.addRoutine(address, null);
        c.mem = loc;
        c.stackAddress = stackAddress;
        c.stackedAddress = returnAddress;
        c.startAddress = address;
        c.callingAddress = callerAddress;
        this.currentContext.add(c);
    }

    public void removeContext() {
        if (this.currentContext.size() <= 1) {
            return;
        }
        this.currentContext.remove(this.currentContext.size() - 1);
    }

    public void checkContext(VecX vecx) {
        for (int index = this.currentContext.size() - 1; index >= 1; --index) {
            int sAddress;
            boolean contextOK = true;
            Context c = this.currentContext.get(index);
            if (vecx.e6809.reg_s.intValue > c.stackAddress) {
                contextOK = false;
            }
            if ((sAddress = vecx.e6809_readOnly8(c.stackAddress & 0xFFFF) * 256 + vecx.e6809_readOnly8(c.stackAddress + 1 & 0xFFFF)) != c.stackedAddress) {
                contextOK = false;
            }
            if (contextOK) break;
            this.removeContext();
        }
    }

    private Profiler(int startAddress, String n) {
        for (int i = 0; i < 65536; ++i) {
            this.memory[i] = new ProfilerMemoryLocation(i);
        }
        ProfilerMemoryLocation loc = this.memory[startAddress];
        loc.name = n;
        Context c = new Context();
        c.mem = loc;
        c.stackAddress = -1;
        c.stackedAddress = -1;
        c.startAddress = -1;
        c.callingAddress = -1;
        this.currentContext.add(c);
    }

    public static Profiler buildProfiler(int startAddress) {
        return new Profiler(startAddress, "main");
    }

    public static Profiler buildProfiler(int startAddress, String n) {
        return new Profiler(startAddress, n);
    }

    class Context {
        int stackedAddress;
        int stackAddress;
        int startAddress;
        int callingAddress;
        ProfilerMemoryLocation mem;

        Context() {
        }
    }

    public class ProfilerMemoryLocation {
        public String name = "";
        public int address = 0;
        public long accessCount = 0L;
        public long accessCountSum = 0L;
        public long accessCycles = 0L;
        public long accessCyclesSum = 0L;
        public long caller_accessCyclesSum = 0L;
        public long lastTrack_accessCount = 0L;
        public long lastTrack_accessCountSum = 0L;
        public long lastTrack_accessCycles = 0L;
        public long lastTrack_accessCyclesSum = 0L;
        public long caller_lastTrack_accessCyclesSum = 0L;
        public long lastTrack_accessCount_final = 0L;
        public long lastTrack_accessCountSum_final = 0L;
        public long lastTrack_accessCycles_final = 0L;
        public long lastTrack_accessCyclesSum_final = 0L;
        public long caller_lastTrack_accessCyclesSum_final = 0L;

        public void access(long cycles) {
            ++this.accessCount;
            ++this.accessCountSum;
            this.accessCycles += cycles;
            this.accessCyclesSum += cycles;
            ++this.lastTrack_accessCount;
            ++this.lastTrack_accessCountSum;
            this.lastTrack_accessCycles += cycles;
            this.lastTrack_accessCyclesSum += cycles;
        }

        public void contextAccess(long cycles) {
            if (Profiler.isLocked(this.address)) {
                return;
            }
            ++this.accessCountSum;
            this.accessCyclesSum += cycles;
            ++this.lastTrack_accessCountSum;
            this.lastTrack_accessCyclesSum += cycles;
        }

        public void sumAccess(long cycles) {
            if (Profiler.isLocked(this.address)) {
                return;
            }
            this.caller_accessCyclesSum += cycles;
            this.caller_lastTrack_accessCyclesSum += cycles;
        }

        ProfilerMemoryLocation(String n) {
            this.name = n;
        }

        ProfilerMemoryLocation(int a) {
            this.address = a;
        }
    }
}

