/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.vecx;

import de.malban.config.Configuration;
import de.malban.graphics.SingleVectorPanel;
import de.malban.gui.ImageCache;
import de.malban.gui.Scaler;
import de.malban.gui.panels.LogPanel;
import de.malban.util.UtilityImage;
import de.malban.vide.VideConfig;
import de.malban.vide.vecx.DisplayPanelInterface;
import de.malban.vide.vecx.VecX;
import de.malban.vide.vecx.VecXPanel;
import de.malban.vide.vecx.VecXState;
import de.malban.vide.vecx.spline.CardinalSpline;
import de.malban.vide.vecx.spline.Pt;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JPanel;

public class VecxiPanel_JAVA
extends JPanel
implements DisplayPanelInterface {
    VideConfig config = VideConfig.getConfig();
    LogPanel log = (LogPanel)Configuration.getConfiguration().getDebugEntity();
    VecXPanel vpanel;
    int BASE_GLOW_OFFSET = 64;
    int SPEED_STRENGTH = 4;
    BufferedImage[] phosphor = new BufferedImage[2];
    int phosphorDraw = 0;
    int phosphorDisplay = 1;
    BufferedImage image;
    BufferedImage rotateImage;
    double scaleWidth = 0.0;
    double scaleHeight = 0.0;
    int vectrexDisplayWidth = 0;
    int vectrexDisplayHeight = 0;
    int orgVectrexDisplayWidth = 0;
    int orgVectrexDisplayHeight = 0;
    ArrayList<Point> spline = new ArrayList();
    HashMap<String, String> doubleCheck = new HashMap();
    StringBuilder sh = new StringBuilder();
    boolean forcedRedraw = false;
    BufferedImage overlayImageScaled = null;
    VecXState.vector_t directDrawVector = null;
    public static int ARR_SIZE = 10;
    int old_x1 = Integer.MAX_VALUE;
    int old_y1 = Integer.MAX_VALUE;

    private VecxiPanel_JAVA() {
    }

    public VecxiPanel_JAVA(VecXPanel vp) {
        this.vpanel = vp;
        this.init();
    }

    @Override
    public void resetDirectdraw() {
        this.directDrawVector = null;
    }

    @Override
    public void stopGraphics() {
        if (this.image != null) {
            Graphics2D g2 = this.image.createGraphics();
            g2.clearRect(0, 0, this.image.getWidth(), this.image.getHeight());
        }
    }

    @Override
    public void deinit() {
        if (this.vpanel != null) {
            // empty if block
        }
    }

    public void init() {
    }

    @Override
    public void overlayChanged() {
        this.overlayImageScaled = null;
        if (this.vpanel.getOverlayImageOrg() != null && this.config.overlayEnabled) {
            this.overlayImageScaled = ImageCache.getImageCache().getDerivatScale(this.vpanel.getOverlayImageOrg(), this.vectrexDisplayWidth, this.vectrexDisplayHeight);
        }
    }

    public void reset() {
        this.overlayImageScaled = null;
        if (this.vpanel.getWidth() == 0) {
            return;
        }
        if (this.vpanel.getHeight() == 0) {
            return;
        }
        Rectangle bounds = new Rectangle(0, this.vpanel.getYOffset() + 1, this.vpanel.getWidth(), this.vpanel.getHeight() - this.vpanel.getYOffset() + 1);
        this.setBounds(bounds);
        this.image = UtilityImage.getNewImage(this.getWidth(), this.getHeight());
        this.phosphor[0] = UtilityImage.getNewImage(this.getWidth(), this.getHeight());
        this.phosphor[1] = UtilityImage.getNewImage(this.getWidth(), this.getHeight());
        if (this.image == null) {
            return;
        }
        if (this.phosphor[0] == null) {
            return;
        }
        if (this.phosphor[1] == null) {
            return;
        }
        this.forcedRedraw = true;
        this.orgVectrexDisplayWidth = this.image.getWidth();
        this.orgVectrexDisplayHeight = this.image.getHeight();
        this.scaleWidth = (double)this.orgVectrexDisplayWidth / (double)this.config.ALG_MAX_X;
        this.scaleHeight = (double)this.orgVectrexDisplayHeight / (double)this.config.ALG_MAX_Y;
        this.setRotation(this.config.rotate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void drawCatmullRom(ArrayList<Point> spline, Graphics2D g2, int color, int speed, int left, int right) {
        ArrayList<Point> arrayList = spline;
        synchronized (arrayList) {
            if (this.config.useQuads) {
                this.drawAsQuads(spline, g2, color, speed, left, right);
                return;
            }
            Color c = this.vpanel.getColor(color, left, right, new Color(210, 210, 255, color));
            g2.setColor(c);
            if (spline.size() == 2) {
                this.drawAsQuads(spline, g2, color, speed, left, right);
                return;
            }
            CardinalSpline cs = new CardinalSpline();
            Pt po = null;
            for (Point p : spline) {
                double yDif;
                double xDif;
                double d;
                Pt pt = new Pt(p.x, p.y);
                if (po != null && (d = (double)((int)Math.sqrt((xDif = (double)p.x - po.x) * xDif + (yDif = (double)p.y - po.y) * yDif))) > (double)this.config.maxSplineSize) {
                    double div = d / (double)(this.config.maxSplineSize / 2);
                    int i = 1;
                    while ((double)i < div) {
                        cs.addPoint(new Pt(po.x + (double)i * (xDif / div), po.y + (double)i * (yDif / div)));
                        ++i;
                    }
                }
                po = pt;
                cs.addPoint(pt);
            }
            cs.caculate();
            ArrayList<Pt> pts = cs.getPoints();
            ArrayList<Point> nP = new ArrayList<Point>();
            for (int i = 0; i < pts.size(); ++i) {
                nP.add(new Point(pts.get(i).ix(), pts.get(i).iy()));
            }
            if (nP.size() > 0) {
                this.drawAsQuads(nP, g2, color, speed, left, right);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void drawAsQuads(ArrayList<Point> spline, Graphics2D g2, int color, int speed, int left, int right) {
        ArrayList<Point> arrayList = spline;
        synchronized (arrayList) {
            int counter = 0;
            GeneralPath path = new GeneralPath(1);
            Color c = this.vpanel.getColor(color, left, right, new Color(210, 210, 255, color));
            g2.setColor(c);
            path.moveTo(Scaler.scaleDoubleToInt(spline.get((int)counter).x, this.scaleWidth), Scaler.scaleDoubleToInt(spline.get((int)counter).y, this.scaleHeight));
            ++counter;
            boolean doIt = true;
            int circleX = 0;
            int circleY = 0;
            if (spline.size() == 2 && Scaler.scaleDoubleToInt(spline.get((int)0).x, this.scaleWidth) == Scaler.scaleDoubleToInt(spline.get((int)1).x, this.scaleWidth) && Scaler.scaleDoubleToInt(spline.get((int)0).y, this.scaleHeight) == Scaler.scaleDoubleToInt(spline.get((int)1).y, this.scaleHeight)) {
                circleX = Scaler.scaleDoubleToInt(spline.get((int)0).x, this.scaleWidth);
                circleY = Scaler.scaleDoubleToInt(spline.get((int)0).y, this.scaleHeight);
                if (circleX < 3) {
                    circleX = 0;
                }
                if (circleY < 3) {
                    circleY = 0;
                }
            }
            while (doIt) {
                int remaining = spline.size() - counter;
                if (remaining == 1) {
                    path.lineTo(Scaler.scaleDoubleToInt(spline.get((int)counter).x, this.scaleWidth), Scaler.scaleDoubleToInt(spline.get((int)counter).y, this.scaleHeight));
                    break;
                }
                if (remaining == 2) {
                    path.quadTo(Scaler.scaleDoubleToInt(spline.get((int)(counter + 0)).x, this.scaleWidth), Scaler.scaleDoubleToInt(spline.get((int)(counter + 0)).y, this.scaleHeight), Scaler.scaleDoubleToInt(spline.get((int)(counter + 1)).x, this.scaleWidth), Scaler.scaleDoubleToInt(spline.get((int)(counter + 1)).y, this.scaleHeight));
                    break;
                }
                if (remaining == 3) {
                    path.curveTo(Scaler.scaleDoubleToInt(spline.get((int)(counter + 0)).x, this.scaleWidth), Scaler.scaleDoubleToInt(spline.get((int)(counter + 0)).y, this.scaleHeight), Scaler.scaleDoubleToInt(spline.get((int)(counter + 1)).x, this.scaleWidth), Scaler.scaleDoubleToInt(spline.get((int)(counter + 1)).y, this.scaleHeight), Scaler.scaleDoubleToInt(spline.get((int)(counter + 2)).x, this.scaleWidth), Scaler.scaleDoubleToInt(spline.get((int)(counter + 2)).y, this.scaleHeight));
                    break;
                }
                if (remaining == 4) {
                    path.quadTo(Scaler.scaleDoubleToInt(spline.get((int)(counter + 0)).x, this.scaleWidth), Scaler.scaleDoubleToInt(spline.get((int)(counter + 0)).y, this.scaleHeight), Scaler.scaleDoubleToInt(spline.get((int)(counter + 1)).x, this.scaleWidth), Scaler.scaleDoubleToInt(spline.get((int)(counter + 1)).y, this.scaleHeight));
                    counter += 2;
                    continue;
                }
                path.curveTo(Scaler.scaleDoubleToInt(spline.get((int)(counter + 0)).x, this.scaleWidth), Scaler.scaleDoubleToInt(spline.get((int)(counter + 0)).y, this.scaleHeight), Scaler.scaleDoubleToInt(spline.get((int)(counter + 1)).x, this.scaleWidth), Scaler.scaleDoubleToInt(spline.get((int)(counter + 1)).y, this.scaleHeight), Scaler.scaleDoubleToInt(spline.get((int)(counter + 2)).x, this.scaleWidth), Scaler.scaleDoubleToInt(spline.get((int)(counter + 2)).y, this.scaleHeight));
                counter += 3;
            }
            if (this.config.useGlow) {
                color <<= 2;
                double speedFactor = speed > 128 ? (double)speed / 128.0 : 1.0 - (double)speed / 512.0;
                color = (int)((double)color * speedFactor);
                double brightness = this.vpanel.getBrightness();
                color = (int)((double)color * brightness);
                int halo = (color /= 3) / this.BASE_GLOW_OFFSET;
                halo *= 2;
                for (int i = 0; i < halo; ++i) {
                    int alpha = this.BASE_GLOW_OFFSET / (3 * (halo - i));
                    int width = (halo - i) * this.config.lineWidth;
                    if (alpha == 0) continue;
                    g2.setStroke(new BasicStroke(width, 1, 1));
                    if (alpha > 255) {
                        alpha = 255;
                    }
                    Color cc = this.vpanel.getColor(color, left, right, new Color(210, 210, 255, alpha));
                    g2.setColor(cc);
                    if (circleX != 0 || circleY != 0) {
                        g2.drawLine(circleX, circleY, circleX, circleY);
                        continue;
                    }
                    g2.draw(path);
                }
                g2.setStroke(new BasicStroke(this.config.lineWidth, 1, 1));
                if (color > this.BASE_GLOW_OFFSET) {
                    color = this.BASE_GLOW_OFFSET;
                }
                Color cc = this.vpanel.getColor(color, left, right, new Color(210, 210, 255, color));
                g2.setColor(cc);
                if (circleX != 0 || circleY != 0) {
                    g2.drawLine(circleX, circleY, circleX, circleY);
                } else {
                    g2.draw(path);
                }
                if (this.config.lineWidth % 2 != 0 && this.config.lineWidth != 1) {
                    g2.setStroke(new BasicStroke(this.config.lineWidth / 2));
                    int col = color * 2;
                    if (col > 255) {
                        col = 255;
                    }
                    cc = this.vpanel.getColor(color, left, right, new Color(210, 210, 255, color));
                    g2.setColor(cc);
                    if (circleX != 0 || circleY != 0) {
                        g2.drawLine(circleX, circleY, circleX, circleY);
                    } else {
                        g2.draw(path);
                    }
                }
            } else {
                g2.draw(path);
            }
        }
    }

    @Override
    public void switchDisplay() {
        this.phosphorDraw = (this.phosphorDraw + 1) % 2;
        this.phosphorDisplay = (this.phosphorDisplay + 1) % 2;
        if (this.phosphor[this.phosphorDraw] == null) {
            return;
        }
        Graphics2D g2 = this.phosphor[this.phosphorDraw].createGraphics();
        g2.drawImage((Image)this.phosphor[this.phosphorDisplay], 0, 0, null);
        Color cc = new Color(0, 0, 0, this.config.persistenceAlpha);
        g2.setColor(cc);
        g2.fillRect(0, 0, this.vectrexDisplayWidth, this.vectrexDisplayHeight);
        this.image = this.phosphor[this.phosphorDisplay];
    }

    @Override
    public void updateDisplay() {
        if (!this.config.useRayGun) {
            this.paintVectrex();
        }
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private synchronized void paintVectrex() {
        if (this.image == null) {
            return;
        }
        this.doubleCheck.clear();
        vList = this.vpanel.getDisplayList();
        g2 = this.image.createGraphics();
        if (!this.forcedRedraw && this.vpanel.isPausing()) {
            c = new Color(255, 0, 0, 255);
            g2.setColor(Color.RED);
            g2.setFont(this.vpanel.getFont());
            g2.drawString("PAUSED", this.image.getWidth() / 2 - 30, this.image.getHeight() / 3);
            return;
        }
        if (this.config.persistenceAlpha != 255) {
            cc = new Color(0, 0, 0, this.config.persistenceAlpha);
            g2.setColor(cc);
            g2.fillRect(0, 0, this.vectrexDisplayWidth, this.vectrexDisplayHeight);
        } else {
            cc = new Color(0, 0, 0, 255);
            g2.setBackground(cc);
            g2.clearRect(0, 0, this.vectrexDisplayWidth, this.vectrexDisplayHeight);
        }
        if (this.vpanel.isPausing()) {
            c = new Color(255, 0, 0, 255);
            g2.setColor(Color.RED);
            g2.setFont(this.getFont());
            g2.drawString("PAUSED", this.image.getWidth() / 2 - 30, this.image.getHeight() / 3);
        }
        if (this.vpanel.isDebuging()) {
            c = new Color(255, 0, 0, 255);
            g2.setColor(Color.GREEN);
            g2.setFont(this.getFont());
            g2.drawString("Debug", this.image.getWidth() / 2 - 20, this.image.getHeight() / 3);
        }
        if (this.vpanel.getDeviceList().get(VecXPanel.DEVICE_LIGHTPEN).isActive()) {
            c = new Color(255, 0, 0, 255);
            if (this.vpanel.isMousePressed()) {
                g2.setColor(Color.ORANGE);
            } else {
                g2.setColor(Color.YELLOW);
            }
            if (this.config.displayModeWriting) {
                g2.setFont(this.getFont());
                g2.drawString("Lightpen", this.image.getWidth() / 2 - 20, this.image.getHeight() / 3);
            }
        }
        if (this.vpanel.getDeviceList().get(VecXPanel.DEVICE_IMAGER).isActive() && this.config.displayModeWriting) {
            c = new Color(255, 0, 0, 255);
            g2.setColor(Color.YELLOW);
            g2.setFont(this.getFont());
            g2.drawString("Goggle", this.image.getWidth() / 2 - 20, this.image.getHeight() / 3);
        }
        if (this.config.antialiazing) {
            m = new HashMap<RenderingHints.Key, Object>();
            m.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            m.put(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED);
            m.put(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE);
            rh = new RenderingHints(m);
        } else {
            m = new HashMap<K, V>();
            m.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            m.put(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED);
            m.put(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE);
            rh = new RenderingHints(m);
        }
        g2.setRenderingHints(rh);
        g2.setStroke(new BasicStroke(this.config.lineWidth, 1, 1));
        inSpline = false;
        splineColor = 0;
        this.old_x1 = 0x7FFFFFFF;
        this.old_y1 = 0x7FFFFFFF;
        for (v = 0; v < vList.count; ++v) {
            block23: {
                if (!this.config.useSplines) break block23;
                var7_9 = this.spline;
                synchronized (var7_9) {
                    block25: {
                        block24: {
                            if (inSpline) break block24;
                            if (v != vList.count - 1 && vList.vectrexVectors[v + 1].midChange && vList.vectrexVectors[v].x1 == vList.vectrexVectors[v + 1].x0 && vList.vectrexVectors[v].y1 == vList.vectrexVectors[v + 1].y0) {
                                this.spline.clear();
                                this.spline.add(new Point(vList.vectrexVectors[v].x0, vList.vectrexVectors[v].y0));
                                splineColor = vList.vectrexVectors[v].color;
                                inSpline = true;
                                continue;
                            }
                            break block23;
                        }
                        if (!vList.vectrexVectors[v].midChange || vList.vectrexVectors[v - 1].x1 != vList.vectrexVectors[v].x0 || vList.vectrexVectors[v - 1].y1 != vList.vectrexVectors[v].y0) break block25;
                        this.spline.add(new Point(vList.vectrexVectors[v].x0, vList.vectrexVectors[v].y0));
                        if (v == vList.count - 1) {
                            this.spline.add(new Point(vList.vectrexVectors[v].x1, vList.vectrexVectors[v].y1));
                            this.drawCatmullRom(this.spline, g2, splineColor, vList.vectrexVectors[v].speed, vList.vectrexVectors[v].imagerColorLeft, vList.vectrexVectors[v].imagerColorRight);
                            inSpline = false;
                            continue;
                        }
                        break block23;
                    }
                    if (!vList.vectrexVectors[v].midChange) ** GOTO lbl-1000
                    if (Math.abs(vList.vectrexVectors[v - 1].x1 - vList.vectrexVectors[v].x0) >= VideConfig.DRIFT_CURVE_THRESHOLD) ** GOTO lbl-1000
                    if (Math.abs(vList.vectrexVectors[v - 1].y1 - vList.vectrexVectors[v].y0) < VideConfig.DRIFT_CURVE_THRESHOLD) {
                        this.spline.add(new Point(vList.vectrexVectors[v - 1].x1, vList.vectrexVectors[v - 1].y1));
                        if (v == vList.count - 1) {
                            this.spline.add(new Point(vList.vectrexVectors[v].x1, vList.vectrexVectors[v].y1));
                            this.drawCatmullRom(this.spline, g2, splineColor, vList.vectrexVectors[v].speed, vList.vectrexVectors[v].imagerColorLeft, vList.vectrexVectors[v].imagerColorRight);
                            inSpline = false;
                            continue;
                        }
                    } else lbl-1000:
                    // 3 sources

                    {
                        this.spline.add(new Point(vList.vectrexVectors[v - 1].x1, vList.vectrexVectors[v - 1].y1));
                        this.drawCatmullRom(this.spline, g2, splineColor, vList.vectrexVectors[v - 1].speed, vList.vectrexVectors[v - 1].imagerColorLeft, vList.vectrexVectors[v - 1].imagerColorRight);
                        inSpline = false;
                        if (v != vList.count - 1 && vList.vectrexVectors[v + 1].midChange) {
                            this.spline.clear();
                            this.spline.add(new Point(vList.vectrexVectors[v].x0, vList.vectrexVectors[v].y0));
                            splineColor = vList.vectrexVectors[v].color;
                            inSpline = true;
                            continue;
                        }
                    }
                }
            }
            if (inSpline) continue;
            this.drawOneLine(g2, vList.vectrexVectors[v]);
        }
        g2.dispose();
        this.forcedRedraw = false;
    }

    private void drawOneLine(Graphics2D g2, VecXState.vector_t v) {
        double x0 = Scaler.scaleDoubleToInt(v.x0, this.scaleWidth);
        double y0 = Scaler.scaleDoubleToInt(v.y0, this.scaleHeight);
        double x1 = Scaler.scaleDoubleToInt(v.x1, this.scaleWidth);
        double y1 = Scaler.scaleDoubleToInt(v.y1, this.scaleHeight);
        if (this.config.supressDoubleDraw && this.old_x1 == (int)x0 && this.old_y1 == (int)y0) {
            int SHORTEN = this.config.lineWidth;
            double dx = x1 - x0;
            double dy = y1 - y0;
            double length = Math.sqrt(dx * dx + dy * dy);
            if (length <= (double)this.config.lineWidth) {
                return;
            }
            if (length > 0.0) {
                dx /= length;
                dy /= length;
            }
            x0 = x1 - (dx *= length - (double)SHORTEN);
            y0 = y1 - (dy *= length - (double)SHORTEN);
        }
        this.old_x1 = (int)x1;
        this.old_y1 = (int)y1;
        this.sh.delete(0, this.sh.length());
        this.sh.append((int)x0);
        this.sh.append((int)x1);
        this.sh.append((int)y0);
        this.sh.append((int)y1);
        String key = this.sh.toString();
        if (this.doubleCheck.get(key) == null) {
            this.doubleCheck.put(key, key);
            if (!this.config.vectorsAsArrows) {
                if (this.config.useGlow) {
                    int color = v.color;
                    double speedFactor = v.speed > 128 ? (double)v.speed / 128.0 : 1.0 - (double)v.speed / 512.0;
                    color = (int)((double)color * speedFactor);
                    double brightness = this.vpanel.getBrightness();
                    color = (int)((double)color * brightness);
                    int halo = (color /= 3) * 2 / this.BASE_GLOW_OFFSET;
                    halo *= 2;
                    for (int i = 0; i < halo; ++i) {
                        int alpha = this.BASE_GLOW_OFFSET / (3 * (halo - i));
                        if (alpha == 0) continue;
                        int width = (halo - i) * this.config.lineWidth;
                        g2.setStroke(new BasicStroke(width, 1, 1));
                        Color c = this.vpanel.getColor(alpha, v.imagerColorLeft, v.imagerColorRight, new Color(210, 210, 255, alpha));
                        g2.setColor(c);
                        g2.drawLine((int)x0, (int)y0, (int)x1, (int)y1);
                    }
                    g2.setStroke(new BasicStroke(this.config.lineWidth, 1, 1));
                    if (color > this.BASE_GLOW_OFFSET) {
                        color = this.BASE_GLOW_OFFSET;
                    }
                    Color c = this.vpanel.getColor(color, v.imagerColorLeft, v.imagerColorRight, new Color(210, 210, 255, color));
                    g2.setColor(c);
                    g2.drawLine((int)x0, (int)y0, (int)x1, (int)y1);
                    if (this.config.lineWidth != 1) {
                        g2.setStroke(new BasicStroke(this.config.lineWidth / 2));
                        int col = color / 2;
                        if (col > 255) {
                            col = 255;
                        }
                        c = this.vpanel.getColor(col, v.imagerColorLeft, v.imagerColorRight, new Color(210, 210, 255, col));
                        g2.setColor(c);
                        g2.drawLine((int)x0, (int)y0, (int)x1, (int)y1);
                    }
                } else {
                    Color c = this.vpanel.getColor(v.color, v.imagerColorLeft, v.imagerColorRight, new Color(210, 210, 255, v.color));
                    g2.setColor(c);
                    g2.drawLine((int)x0, (int)y0, (int)x1, (int)y1);
                }
            } else {
                Color c = this.vpanel.getColor(v.color, v.imagerColorLeft, v.imagerColorRight, new Color(210, 210, 255, v.color));
                g2.setColor(c);
                this.drawArrow(g2, (int)x0, (int)y0, (int)x1, (int)y1);
            }
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        int offsetY = 0;
        Graphics gOrg = g;
        if (this.config.rotate != 0) {
            gOrg = g;
            if (this.rotateImage == null) {
                this.setRotation(this.config.rotate);
            }
            if (this.rotateImage != null) {
                g = this.rotateImage.createGraphics();
            }
            offsetY = 0;
        }
        if (this.image != null) {
            g.drawImage(this.image, 0, offsetY, null);
            if (this.overlayImageScaled != null && this.config.overlayEnabled) {
                g.drawImage(this.overlayImageScaled, 0, offsetY, null);
            }
            if (this.config.paintIntegrators) {
                double x0 = this.vpanel.getIntegratorX();
                double y0 = this.vpanel.getIntegratorY();
                x0 = Scaler.scaleDoubleToInt(x0, this.scaleWidth);
                y0 = Scaler.scaleDoubleToInt(y0, this.scaleHeight) + offsetY;
                int RADIUS = 3;
                g.setColor(Color.red);
                g.drawOval((int)x0 - RADIUS, (int)y0 - RADIUS, RADIUS * 2, RADIUS * 2);
            }
            if (this.vpanel.isMouseMode() && !this.vpanel.isCrossDisabled()) {
                double y1;
                double x1;
                double y0;
                int width = this.image.getWidth();
                int height = this.image.getHeight();
                double scaleWidth = (double)width / (double)this.config.ALG_MAX_X;
                double scaleHeight = (double)height / (double)this.config.ALG_MAX_Y;
                double distance = Double.MAX_VALUE;
                if (this.vpanel.getVinfi() != null) {
                    int x = this.vpanel.getMouseX();
                    int y = this.vpanel.getMouseY() - offsetY;
                    x = Scaler.unscaleDoubleToInt(x, scaleWidth);
                    y = Scaler.unscaleDoubleToInt(y, scaleHeight);
                    y -= this.config.ALG_MAX_Y / 2;
                    y = -y;
                    this.vpanel.getVinfi().setMouseCoordinates(x -= this.config.ALG_MAX_X / 2, y);
                }
                Color c = g.getColor();
                int x = this.vpanel.getMouseX();
                int y = this.vpanel.getMouseY();
                g.setColor(this.vpanel.getCrossColor());
                g.drawLine(0, y, width, y);
                g.drawLine(x, 0 + offsetY, x, height + offsetY);
                VecX.VectrexDisplayVectors vList = this.vpanel.getDisplayList();
                for (int i = 0; i < vList.count; ++i) {
                    VecXState.vector_t v = vList.vectrexVectors[i];
                    double x0 = v.x0;
                    double y02 = v.y0;
                    double x12 = v.x1;
                    double y12 = v.y1;
                    x0 = Scaler.scaleDoubleToInt(x0, scaleWidth);
                    y02 = Scaler.scaleDoubleToInt(y02, scaleHeight);
                    x12 = Scaler.scaleDoubleToInt(x12, scaleWidth);
                    y12 = Scaler.scaleDoubleToInt(y12, scaleHeight);
                    y02 += (double)offsetY;
                    y12 += (double)offsetY;
                    double d = SingleVectorPanel.getDistancePointToVector(this.vpanel.getMouseX(), this.vpanel.getMouseY(), x0, y02, x12, y12);
                    if (d < distance) {
                        distance = d;
                        this.vpanel.setFound(v);
                    }
                    if (distance == 0.0) break;
                }
                if (this.directDrawVector != null) {
                    double x0 = this.directDrawVector.x0;
                    y0 = this.directDrawVector.y0;
                    x1 = this.directDrawVector.x1;
                    y1 = this.directDrawVector.y1;
                    x0 = Scaler.scaleDoubleToInt(x0, scaleWidth);
                    y0 = Scaler.scaleDoubleToInt(y0, scaleHeight);
                    x1 = Scaler.scaleDoubleToInt(x1, scaleWidth);
                    y1 = Scaler.scaleDoubleToInt(y1, scaleHeight);
                    y0 += (double)offsetY;
                    y1 += (double)offsetY;
                    double d = SingleVectorPanel.getDistancePointToVector(this.vpanel.getMouseX(), this.vpanel.getMouseY(), x0, y0, x1, y1);
                    if (d < distance) {
                        distance = d;
                        this.vpanel.setFound(this.directDrawVector);
                    }
                }
                if (this.vpanel.getFound() != null && !(distance <= 5.0)) {
                    this.vpanel.setFound(null);
                }
                if (this.vpanel.getFound() != null) {
                    double x0 = this.vpanel.getFound().x0;
                    y0 = this.vpanel.getFound().y0;
                    x1 = this.vpanel.getFound().x1;
                    y1 = this.vpanel.getFound().y1;
                    x0 = Scaler.scaleDoubleToInt(x0, scaleWidth);
                    y0 = Scaler.scaleDoubleToInt(y0, scaleHeight);
                    x1 = Scaler.scaleDoubleToInt(x1, scaleWidth);
                    y1 = Scaler.scaleDoubleToInt(y1, scaleHeight);
                    g.setColor(Color.BLUE);
                    double py = x0 - x1;
                    double px = -((y0 += (double)offsetY) - (y1 += (double)offsetY));
                    double l = Math.sqrt(Math.pow(py, 2.0) + Math.pow(px, 2.0));
                    double transition = 3.0;
                    double px0 = x0 + transition / l * px;
                    double py0 = y0 + transition / l * py;
                    double px1 = x1 + transition / l * px;
                    double py1 = y1 + transition / l * py;
                    double transition2 = -3.0;
                    double px02 = x0 + transition2 / l * px;
                    double py02 = y0 + transition2 / l * py;
                    double px12 = x1 + transition2 / l * px;
                    double py12 = y1 + transition2 / l * py;
                    g.drawLine((int)px0, (int)py0, (int)px1, (int)py1);
                    g.drawLine((int)px02, (int)py02, (int)px12, (int)py12);
                    g.drawLine((int)px0, (int)py0, (int)px02, (int)py02);
                    g.drawLine((int)px1, (int)py1, (int)px12, (int)py12);
                }
            }
        }
        if (this.directDrawVector != null) {
            Color c = new Color(255, 255, 0, 255);
            g.setColor(c);
            double x0 = this.directDrawVector.x0;
            double y0 = this.directDrawVector.y0;
            double x1 = this.directDrawVector.x1;
            double y1 = this.directDrawVector.y1;
            x0 = Scaler.scaleDoubleToInt(x0, this.scaleWidth);
            y0 = Scaler.scaleDoubleToInt(y0, this.scaleHeight);
            x1 = Scaler.scaleDoubleToInt(x1, this.scaleWidth);
            y1 = Scaler.scaleDoubleToInt(y1, this.scaleHeight);
            g.drawLine((int)x0, (int)y0 + offsetY, (int)x1, (int)y1 + offsetY);
            this.directDrawVector = null;
        }
        if (this.vpanel.isLEDState()) {
            int alpha;
            if (this.vpanel.isLEDDir()) {
                for (int i = 22; i > 12; i -= 2) {
                    alpha = 250 - (i - 12) * 20 - this.vpanel.getLEDStep() * 2;
                    Color c = new Color(210, 210, 255, alpha);
                    g.setColor(c);
                    g.fillOval(this.getWidth() - 30 - i, this.getHeight() - 30 - i, (i - 10) * 2, (i - 10) * 2);
                }
                Color c = new Color(255, 255, 255, 255);
                g.setColor(c);
                g.fillOval(this.getWidth() - 30 - 12, this.getHeight() - 30 - 12, 4, 4);
                c = new Color(255, 255, 200, 255 - this.vpanel.getLEDStep());
                g.setColor(c);
                g.fillOval(this.getWidth() - 30 - 11, this.getHeight() - 30 - 11, 2, 2);
                this.vpanel.setLEDStep(this.vpanel.getLEDStep() + 1);
                if (this.vpanel.getLEDStep() >= 15) {
                    this.vpanel.setLEDDir(false);
                }
            } else if (!this.vpanel.isLEDDir()) {
                for (int i = 22; i > 12; i -= 2) {
                    alpha = 250 - (i - 12) * 20 - this.vpanel.getLEDStep() * 2;
                    Color c = new Color(210, 210, 255, alpha);
                    g.setColor(c);
                    g.fillOval(this.getWidth() - 30 - i, this.getHeight() - 30 - i, (i - 10) * 2, (i - 10) * 2);
                }
                Color c = new Color(255, 255, 255, 255 - this.vpanel.getLEDStep());
                g.setColor(c);
                g.fillOval(this.getWidth() - 30 - 12, this.getHeight() - 30 - 12, 4, 4);
                c = new Color(255, 255, 200, 255);
                g.setColor(c);
                g.fillOval(this.getWidth() - 30 - 11, this.getHeight() - 30 - 11, 2, 2);
                this.vpanel.setLEDStep(this.vpanel.getLEDStep() - 1);
                if (this.vpanel.getLEDStep() <= 0) {
                    this.vpanel.setLEDDir(true);
                }
            }
        }
        if (this.rotateImage != null && this.config.rotate != 0) {
            BufferedImage ri = this.getRotate(this.config.rotate);
            gOrg.drawImage(ri, 0, 0, null);
        }
    }

    @Override
    public void setRotation(int angle) {
        if (angle != 0 && angle != 90 && angle != 180 && angle != 270) {
            return;
        }
        if (angle == 90 || angle == 270) {
            this.vectrexDisplayWidth = this.orgVectrexDisplayHeight;
            this.vectrexDisplayHeight = this.orgVectrexDisplayWidth;
        } else {
            this.vectrexDisplayWidth = this.orgVectrexDisplayWidth;
            this.vectrexDisplayHeight = this.orgVectrexDisplayHeight;
        }
        if (this.vectrexDisplayWidth == 0) {
            return;
        }
        if (this.vectrexDisplayHeight == 0) {
            return;
        }
        this.image = UtilityImage.getNewImage(this.vectrexDisplayWidth, this.vectrexDisplayHeight);
        this.phosphor[0] = UtilityImage.getNewImage(this.vectrexDisplayWidth, this.vectrexDisplayHeight);
        this.phosphor[1] = UtilityImage.getNewImage(this.vectrexDisplayWidth, this.vectrexDisplayHeight);
        this.scaleWidth = (double)this.vectrexDisplayWidth / (double)this.config.ALG_MAX_X;
        this.scaleHeight = (double)this.vectrexDisplayHeight / (double)this.config.ALG_MAX_Y;
        this.overlayChanged();
        this.rotateImage = UtilityImage.getNewImage(this.vectrexDisplayWidth, this.vectrexDisplayHeight);
    }

    protected BufferedImage getRotate(int a) {
        int h = this.rotateImage.getHeight();
        int w = this.rotateImage.getWidth();
        int type = 2;
        BufferedImage dimg = new BufferedImage(this.orgVectrexDisplayWidth, this.orgVectrexDisplayHeight, type);
        Graphics2D g = dimg.createGraphics();
        double sw = w;
        double sh = h;
        g.translate((this.orgVectrexDisplayWidth - w) / 2, (this.orgVectrexDisplayHeight - h) / 2);
        g.rotate(Math.toRadians(a), w / 2, h / 2);
        g.drawImage(this.rotateImage, null, 0, 0);
        return dimg;
    }

    void drawArrow(Graphics g1, int x1, int y1, int x2, int y2) {
        Graphics2D g = (Graphics2D)g1.create();
        double dx = x2 - x1;
        double dy = y2 - y1;
        double angle = Math.atan2(dy, dx);
        int len = (int)Math.sqrt(dx * dx + dy * dy);
        AffineTransform at = AffineTransform.getTranslateInstance(x1, y1);
        at.concatenate(AffineTransform.getRotateInstance(angle));
        g.transform(at);
        g.drawLine(0, 0, len, 0);
        g.fillPolygon(new int[]{len, len - ARR_SIZE, len - ARR_SIZE, len}, new int[]{0, -ARR_SIZE / 3, ARR_SIZE / 3, 0}, 4);
    }

    @Override
    public void rayMove(int x0, int y0, int x1, int y1, int color, int dwell, boolean curved, int alg_vector_speed, int alg_leftEye, int alg_rightEye) {
        if (this.phosphor[this.phosphorDraw] == null) {
            return;
        }
        Graphics2D g2 = this.phosphor[this.phosphorDraw].createGraphics();
        x0 = Scaler.scaleDoubleToInt(x0, this.scaleWidth);
        y0 = Scaler.scaleDoubleToInt(y0, this.scaleHeight);
        x1 = Scaler.scaleDoubleToInt(x1, this.scaleWidth);
        y1 = Scaler.scaleDoubleToInt(y1, this.scaleHeight);
        Color c = this.vpanel.getColor(color, alg_leftEye, alg_rightEye, new Color(210, 210, 255, color));
        g2.setColor(c);
        g2.drawLine(x0, y0, x1, y1);
        g2.dispose();
    }

    @Override
    public void setLightPen() {
        if (this.image == null) {
            return;
        }
        int x = this.vpanel.getMouseX();
        int y = this.vpanel.getMouseY();
        x -= 4;
        if ((y -= 4) < 0) {
            this.vpanel.unsetLightPen();
            return;
        }
        int ux = Scaler.unscaleDoubleToInt(x, this.scaleWidth);
        int uy = Scaler.unscaleDoubleToInt(y, this.scaleHeight);
        this.vpanel.setLightPen(ux, uy);
    }

    @Override
    public void directDraw(VecXState.vector_t v) {
        this.directDrawVector = v;
        this.repaint();
    }

    @Override
    public void forceResize() {
        this.reset();
        this.paintVectrex();
        this.repaint();
    }

    public void internalReinit() {
    }
}

