/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.vecx;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.awt.GLJPanel;
import com.jogamp.opengl.util.FPSAnimator;
import com.jogamp.opengl.util.GLBuffers;
import com.jogamp.opengl.util.gl2.GLUT;
import com.jogamp.opengl.util.texture.Texture;
import com.jogamp.opengl.util.texture.awt.AWTTextureIO;
import de.malban.Global;
import de.malban.config.Configuration;
import de.malban.graphics.SingleVectorPanel;
import de.malban.gui.Scaler;
import de.malban.gui.panels.LogPanel;
import de.malban.jogl.JOGLSupport;
import de.malban.util.UtilityFiles;
import de.malban.util.UtilityImage;
import de.malban.util.UtilityString;
import de.malban.vide.VideConfig;
import de.malban.vide.vecx.DisplayPanelInterface;
import de.malban.vide.vecx.VecX;
import de.malban.vide.vecx.VecXPanel;
import de.malban.vide.vecx.VecXState;
import de.malban.vide.vecx.spline.CardinalSpline;
import de.malban.vide.vecx.spline.Pt;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GraphicsEnvironment;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.io.File;
import java.lang.reflect.Method;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.SwingUtilities;

public class VecxiPanel_JOGL
extends GLJPanel
implements DisplayPanelInterface {
    VideConfig config = VideConfig.getConfig();
    LogPanel log = (LogPanel)Configuration.getConfiguration().getDebugEntity();
    VecXPanel vpanel;
    float scaleWidthGL;
    float scaleHeightGL;
    float scaleWidth;
    float scaleHeight;
    GLEventListener glListener;
    VecXState.vector_t directDrawVector;
    boolean isInit;
    private boolean shadersInitialized;
    private boolean buffersInitialized;
    Texture fboTexture;
    int programId;
    int vertexShaderId;
    int fragmentShaderId;
    int positionAttribute;
    int colorAttribute;
    private boolean blurShadersInitialized;
    int blurProgramId;
    int blurPositionAttribute;
    int blurColorAttribute;
    int blurTextureAttribute;
    int blurVertexShaderId;
    int blurFragmentShaderId;
    int persitencyProgramId;
    int persitencyVertexShaderId;
    int persitencyFragmentShaderId;
    int thresholdProgramId;
    int thresholdVertexShaderId;
    int thresholdFragmentShaderId;
    int spillProgramId;
    int spillVertexShaderId;
    int spillFragmentShaderId;
    int spillFinalProgramId;
    int spillFinalVertexShaderId;
    int spillFinalFragmentShaderId;
    int overlayProgramId;
    int overlayVertexShaderId;
    int overlayFragmentShaderId;
    int screenProgramId;
    int screenVertexShaderId;
    int screenFragmentShaderId;
    boolean doDeinitBlurShaders;
    private IntBuffer overlayTextureObject;
    boolean overlayMustFlip;
    private boolean overlayInitialized;
    boolean screenMustFlip;
    private IntBuffer screenTextureObject;
    private IntBuffer vertexBufferObject;
    private IntBuffer lineBufferObject;
    private IntBuffer fboMSAABufferObject;
    private IntBuffer fboMSAATextureObject;
    LineFBO[] lineFBO;
    LineFBO[] borderFBO;
    GLAutoDrawable auddr;
    int gl2Width;
    int gl2Height;
    boolean framebufferInitialized;
    int MAXBUFFERSIZE_LINE;
    int MAXBUFFERSIZE_POINT;
    int MAXBUFFERSIZE_LINE_STRIP;
    float[] linesData;
    float[] pointsData;
    int MAX_LINE_STRIPS;
    LineStripBuffer[] lineStrips;
    int lineCount;
    int pointCount;
    int splineCount;
    FloatBuffer linesDataBuffer;
    FloatBuffer pointsDataBuffer;
    float COLOR_DIV;
    float SPEED_FACTOR_MAX;
    private static final int REFRESH_FPS = 60;
    FPSAnimator animator;
    static int MAX_RAY_VECTORS = 1000;
    VecXState.vector_t[][] vectrexVectors;
    int rayAddPos;
    int rayCount;
    int currentRayAdd;
    int currentRayDisplay;
    boolean rayInit;
    ArrayList<Point> spline;
    Color[] vectrexColorData;
    boolean capturing;
    static final float RADIUS = 8.0f;
    static final int SEGMENTS = 8;
    private static int DISK_SEGEMENTS = 10;
    float maxBorderIntensity;
    int topOffset;
    int leftOffset;

    void initLineStrips(int count, GL2 gl2) {
        this.deinitLineStrips(gl2);
        this.lineStrips = new LineStripBuffer[count];
        for (int i = 0; i < count; ++i) {
            this.lineStrips[i] = new LineStripBuffer();
            gl2.glGenBuffers(1, this.lineStrips[i].lineStripBufferObject);
            this.lineStrips[i].updateBuffer();
        }
    }

    void deinitLineStrips(GL2 gl2) {
        if (this.lineStrips == null) {
            return;
        }
        for (int i = 0; i < this.lineStrips.length; ++i) {
            gl2.glDeleteBuffers(1, this.lineStrips[i].lineStripBufferObject);
            this.lineStrips[i].lineStripData = null;
            this.lineStrips[i].lineStripDataBuffer = null;
            this.lineStrips[i].lineCount = 0;
            this.lineStrips[i].dataCount = 0;
            this.lineStrips[i] = null;
        }
        this.lineStrips = null;
    }

    void resetSplines() {
        for (int i = 0; i < this.splineCount; ++i) {
            this.lineStrips[i].lineCount = 0;
            this.lineStrips[i].dataCount = 0;
        }
        this.splineCount = 0;
    }

    public static VecxiPanel_JOGL getJOGLPanel(VecXPanel vp) {
        GLCapabilities caps = JOGLSupport.getJOGLSupport().glcapabilities;
        caps.setRedBits(8);
        caps.setBlueBits(8);
        caps.setGreenBits(8);
        caps.setAlphaBits(8);
        caps.setDepthBits(16);
        VecxiPanel_JOGL gljpanel = new VecxiPanel_JOGL(vp, caps);
        gljpanel.forceResize();
        if (gljpanel.config.JOGLAutoDisplay) {
            gljpanel.animator = new FPSAnimator((GLAutoDrawable)gljpanel, 60, true);
        }
        return gljpanel;
    }

    private VecxiPanel_JOGL() {
        this.scaleWidthGL = 1.0f / (float)this.config.ALG_MAX_X * 2.0f;
        this.scaleHeightGL = 1.0f / (float)this.config.ALG_MAX_Y * 2.0f;
        this.scaleWidth = 0.0f;
        this.scaleHeight = 0.0f;
        this.glListener = null;
        this.directDrawVector = null;
        this.isInit = false;
        this.shadersInitialized = false;
        this.buffersInitialized = false;
        this.fboTexture = null;
        this.programId = -1;
        this.blurShadersInitialized = false;
        this.blurProgramId = -1;
        this.persitencyProgramId = -1;
        this.thresholdProgramId = -1;
        this.spillProgramId = -1;
        this.spillFinalProgramId = -1;
        this.overlayProgramId = -1;
        this.screenProgramId = -1;
        this.doDeinitBlurShaders = false;
        this.overlayTextureObject = GLBuffers.newDirectIntBuffer((int)1);
        this.overlayMustFlip = false;
        this.overlayInitialized = false;
        this.screenMustFlip = false;
        this.screenTextureObject = GLBuffers.newDirectIntBuffer((int)1);
        this.vertexBufferObject = GLBuffers.newDirectIntBuffer((int)1);
        this.lineBufferObject = GLBuffers.newDirectIntBuffer((int)1);
        this.fboMSAABufferObject = GLBuffers.newDirectIntBuffer((int)1);
        this.fboMSAATextureObject = GLBuffers.newDirectIntBuffer((int)1);
        this.lineFBO = new LineFBO[6];
        this.borderFBO = new LineFBO[4];
        this.auddr = null;
        this.gl2Width = 0;
        this.gl2Height = 0;
        this.framebufferInitialized = false;
        this.MAXBUFFERSIZE_LINE = 1000;
        this.MAXBUFFERSIZE_POINT = 1000;
        this.MAXBUFFERSIZE_LINE_STRIP = 500;
        this.MAX_LINE_STRIPS = 10;
        this.lineStrips = null;
        this.lineCount = 0;
        this.pointCount = 0;
        this.splineCount = 0;
        this.COLOR_DIV = 127.0f;
        this.SPEED_FACTOR_MAX = 0.9f;
        this.animator = null;
        this.vectrexVectors = null;
        this.rayAddPos = 0;
        this.rayCount = 0;
        this.currentRayAdd = 0;
        this.currentRayDisplay = 1;
        this.rayInit = false;
        this.spline = new ArrayList();
        this.vectrexColorData = new Color[]{Color.BLUE, Color.BLUE, Color.BLUE, Color.BLUE, Color.BLUE, Color.BLUE, Color.BLUE, Color.BLUE, Color.BLUE, Color.BLUE, Color.RED, Color.RED, Color.RED, Color.RED, Color.RED, Color.RED, Color.RED, Color.RED, Color.RED, Color.RED, Color.RED, Color.RED, Color.RED, Color.RED, Color.RED, Color.RED, Color.RED, Color.RED, Color.RED, Color.RED, Color.RED, Color.YELLOW, Color.YELLOW, Color.YELLOW, Color.YELLOW, Color.YELLOW, Color.YELLOW, Color.YELLOW, Color.YELLOW, Color.YELLOW, Color.YELLOW, Color.YELLOW, Color.YELLOW, Color.YELLOW, Color.YELLOW, Color.YELLOW, Color.YELLOW, Color.YELLOW, Color.YELLOW, Color.YELLOW, Color.YELLOW, Color.YELLOW, Color.GREEN, Color.GREEN, Color.GREEN, Color.GREEN, Color.GREEN, Color.GREEN, Color.GREEN, Color.GREEN, Color.GREEN, Color.GREEN, Color.GREEN, Color.GREEN, Color.GREEN, Color.GREEN, Color.GREEN, Color.GREEN, Color.GREEN, Color.GREEN, Color.GREEN, Color.GREEN, Color.GREEN, Color.CYAN, Color.CYAN, Color.CYAN, Color.CYAN, Color.CYAN, Color.CYAN, Color.CYAN, Color.CYAN, Color.CYAN, Color.CYAN, Color.CYAN, Color.CYAN, Color.CYAN, Color.CYAN, Color.CYAN, Color.CYAN, Color.CYAN, Color.CYAN, Color.CYAN, Color.CYAN, Color.CYAN, Color.white, Color.white, Color.white, Color.white, Color.white, Color.white, Color.white, Color.white, Color.white, Color.white, Color.white, Color.white, Color.white, Color.white, Color.white, Color.white, Color.white, Color.white, Color.white, Color.white, Color.white, Color.magenta, Color.magenta, Color.magenta, Color.magenta, Color.magenta, Color.magenta, Color.magenta, Color.magenta, Color.magenta, Color.magenta, Color.magenta, Color.magenta, Color.magenta, Color.magenta, Color.magenta, Color.magenta, Color.magenta, Color.magenta, Color.magenta, Color.magenta, Color.magenta, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLUE, Color.BLUE, Color.BLUE, Color.BLUE, Color.BLUE, Color.BLUE, Color.BLUE, Color.BLUE, Color.BLUE, Color.BLUE, Color.BLUE};
        this.capturing = false;
        this.maxBorderIntensity = 0.8f;
        this.topOffset = 0;
        this.leftOffset = 0;
    }

    private VecxiPanel_JOGL(VecXPanel vp, GLCapabilities caps) {
        super((GLCapabilitiesImmutable)caps);
        this.scaleWidthGL = 1.0f / (float)this.config.ALG_MAX_X * 2.0f;
        this.scaleHeightGL = 1.0f / (float)this.config.ALG_MAX_Y * 2.0f;
        this.scaleWidth = 0.0f;
        this.scaleHeight = 0.0f;
        this.glListener = null;
        this.directDrawVector = null;
        this.isInit = false;
        this.shadersInitialized = false;
        this.buffersInitialized = false;
        this.fboTexture = null;
        this.programId = -1;
        this.blurShadersInitialized = false;
        this.blurProgramId = -1;
        this.persitencyProgramId = -1;
        this.thresholdProgramId = -1;
        this.spillProgramId = -1;
        this.spillFinalProgramId = -1;
        this.overlayProgramId = -1;
        this.screenProgramId = -1;
        this.doDeinitBlurShaders = false;
        this.overlayTextureObject = GLBuffers.newDirectIntBuffer((int)1);
        this.overlayMustFlip = false;
        this.overlayInitialized = false;
        this.screenMustFlip = false;
        this.screenTextureObject = GLBuffers.newDirectIntBuffer((int)1);
        this.vertexBufferObject = GLBuffers.newDirectIntBuffer((int)1);
        this.lineBufferObject = GLBuffers.newDirectIntBuffer((int)1);
        this.fboMSAABufferObject = GLBuffers.newDirectIntBuffer((int)1);
        this.fboMSAATextureObject = GLBuffers.newDirectIntBuffer((int)1);
        this.lineFBO = new LineFBO[6];
        this.borderFBO = new LineFBO[4];
        this.auddr = null;
        this.gl2Width = 0;
        this.gl2Height = 0;
        this.framebufferInitialized = false;
        this.MAXBUFFERSIZE_LINE = 1000;
        this.MAXBUFFERSIZE_POINT = 1000;
        this.MAXBUFFERSIZE_LINE_STRIP = 500;
        this.MAX_LINE_STRIPS = 10;
        this.lineStrips = null;
        this.lineCount = 0;
        this.pointCount = 0;
        this.splineCount = 0;
        this.COLOR_DIV = 127.0f;
        this.SPEED_FACTOR_MAX = 0.9f;
        this.animator = null;
        this.vectrexVectors = null;
        this.rayAddPos = 0;
        this.rayCount = 0;
        this.currentRayAdd = 0;
        this.currentRayDisplay = 1;
        this.rayInit = false;
        this.spline = new ArrayList();
        this.vectrexColorData = new Color[]{Color.BLUE, Color.BLUE, Color.BLUE, Color.BLUE, Color.BLUE, Color.BLUE, Color.BLUE, Color.BLUE, Color.BLUE, Color.BLUE, Color.RED, Color.RED, Color.RED, Color.RED, Color.RED, Color.RED, Color.RED, Color.RED, Color.RED, Color.RED, Color.RED, Color.RED, Color.RED, Color.RED, Color.RED, Color.RED, Color.RED, Color.RED, Color.RED, Color.RED, Color.RED, Color.YELLOW, Color.YELLOW, Color.YELLOW, Color.YELLOW, Color.YELLOW, Color.YELLOW, Color.YELLOW, Color.YELLOW, Color.YELLOW, Color.YELLOW, Color.YELLOW, Color.YELLOW, Color.YELLOW, Color.YELLOW, Color.YELLOW, Color.YELLOW, Color.YELLOW, Color.YELLOW, Color.YELLOW, Color.YELLOW, Color.YELLOW, Color.GREEN, Color.GREEN, Color.GREEN, Color.GREEN, Color.GREEN, Color.GREEN, Color.GREEN, Color.GREEN, Color.GREEN, Color.GREEN, Color.GREEN, Color.GREEN, Color.GREEN, Color.GREEN, Color.GREEN, Color.GREEN, Color.GREEN, Color.GREEN, Color.GREEN, Color.GREEN, Color.GREEN, Color.CYAN, Color.CYAN, Color.CYAN, Color.CYAN, Color.CYAN, Color.CYAN, Color.CYAN, Color.CYAN, Color.CYAN, Color.CYAN, Color.CYAN, Color.CYAN, Color.CYAN, Color.CYAN, Color.CYAN, Color.CYAN, Color.CYAN, Color.CYAN, Color.CYAN, Color.CYAN, Color.CYAN, Color.white, Color.white, Color.white, Color.white, Color.white, Color.white, Color.white, Color.white, Color.white, Color.white, Color.white, Color.white, Color.white, Color.white, Color.white, Color.white, Color.white, Color.white, Color.white, Color.white, Color.white, Color.magenta, Color.magenta, Color.magenta, Color.magenta, Color.magenta, Color.magenta, Color.magenta, Color.magenta, Color.magenta, Color.magenta, Color.magenta, Color.magenta, Color.magenta, Color.magenta, Color.magenta, Color.magenta, Color.magenta, Color.magenta, Color.magenta, Color.magenta, Color.magenta, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLUE, Color.BLUE, Color.BLUE, Color.BLUE, Color.BLUE, Color.BLUE, Color.BLUE, Color.BLUE, Color.BLUE, Color.BLUE, Color.BLUE};
        this.capturing = false;
        this.maxBorderIntensity = 0.8f;
        this.topOffset = 0;
        this.leftOffset = 0;
        this.vpanel = vp;
        this.vertexBufferObject.put(0, 0);
        this.lineBufferObject.put(0, 0);
        this.fboMSAABufferObject.put(0, 0);
        this.fboMSAATextureObject.put(0, 0);
        this.overlayTextureObject.put(0, 0);
        this.screenTextureObject.put(0, 0);
        this.lineFBO[0] = new LineFBO();
        this.lineFBO[1] = new LineFBO();
        this.lineFBO[2] = new LineFBO();
        this.lineFBO[3] = new LineFBO();
        this.lineFBO[4] = new LineFBO();
        this.lineFBO[5] = new LineFBO();
        this.borderFBO[0] = new LineFBO();
        this.borderFBO[1] = new LineFBO();
        this.borderFBO[2] = new LineFBO();
        this.borderFBO[3] = new LineFBO();
        this.glListener = new GLEventListener(){

            public void reshape(GLAutoDrawable glautodrawable, int x, int y, int width, int height) {
                VecxiPanel_JOGL.this.setup(glautodrawable, width, height);
                VecxiPanel_JOGL.this.auddr = glautodrawable;
                VecxiPanel_JOGL.this.getCorrectFocus();
            }

            public void init(GLAutoDrawable glautodrawable) {
            }

            public void dispose(GLAutoDrawable glautodrawable) {
            }

            public void display(GLAutoDrawable glautodrawable) {
                VecxiPanel_JOGL.this.render(glautodrawable, glautodrawable.getSurfaceWidth(), glautodrawable.getSurfaceHeight());
            }
        };
        this.addGLEventListener(this.glListener);
        this.isInit = true;
    }

    void getCorrectFocus() {
        boolean isInternal = false;
        Container internal = null;
        Component frame = null;
        for (Container p = this.getParent(); p != null; p = p.getParent()) {
            if (p instanceof JInternalFrame) {
                isInternal = true;
                internal = p;
            }
            if (!(p instanceof JFrame)) continue;
            frame = p;
        }
        if (isInternal) {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().setGlobalCurrentFocusCycleRoot(internal);
            internal.requestFocus();
        } else {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().setGlobalCurrentFocusCycleRoot((Container)frame);
            frame.requestFocus();
        }
    }

    @Override
    public void setRotation(int a) {
        this.scaleWidth = (float)((double)this.gl2Width / (double)this.config.ALG_MAX_X);
        this.scaleHeight = (float)((double)this.gl2Height / (double)this.config.ALG_MAX_Y);
    }

    @Override
    public void stopGraphics() {
    }

    @Override
    public synchronized void rayMove(int x0, int y0, int x1, int y1, int color, int dwell, boolean curved, int alg_vector_speed, int alg_leftEye, int alg_rightEye) {
        if (!this.rayInit) {
            return;
        }
        if (this.rayAddPos >= this.vectrexVectors[this.currentRayAdd].length - 1) {
            this.vectrexVectors = new VecXState.vector_t[2][MAX_RAY_VECTORS *= 2];
            for (int i = 0; i < MAX_RAY_VECTORS; ++i) {
                this.vectrexVectors[0][i] = new VecXState.vector_t();
                this.vectrexVectors[1][i] = new VecXState.vector_t();
            }
            this.rayAddPos = 0;
            this.rayCount = 0;
        }
        this.vectrexVectors[this.currentRayAdd][this.rayAddPos].x0 = x0;
        this.vectrexVectors[this.currentRayAdd][this.rayAddPos].y0 = y0;
        this.vectrexVectors[this.currentRayAdd][this.rayAddPos].x1 = x1;
        this.vectrexVectors[this.currentRayAdd][this.rayAddPos].y1 = y1;
        this.vectrexVectors[this.currentRayAdd][this.rayAddPos].color = color;
        this.vectrexVectors[this.currentRayAdd][this.rayAddPos].midChange = curved;
        this.vectrexVectors[this.currentRayAdd][this.rayAddPos].speed = alg_vector_speed;
        this.vectrexVectors[this.currentRayAdd][this.rayAddPos].imagerColorLeft = alg_leftEye;
        this.vectrexVectors[this.currentRayAdd][this.rayAddPos].imagerColorRight = alg_rightEye;
        ++this.rayAddPos;
    }

    @Override
    public synchronized void switchDisplay() {
        this.rayCount = this.rayAddPos;
        this.rayAddPos = 0;
        this.currentRayAdd = (this.currentRayAdd + 1) % 2;
        this.currentRayDisplay = (this.currentRayDisplay + 1) % 2;
        this.repaint();
    }

    @Override
    public void setLightPen() {
        int x = this.vpanel.getMouseX();
        int y = this.vpanel.getMouseY();
        y -= this.topOffset;
        x -= this.leftOffset;
        x -= 4;
        if ((y -= 4) < 0) {
            this.vpanel.unsetLightPen();
            return;
        }
        int ux = Scaler.unscaleDoubleToInt(x, this.scaleWidth);
        int uy = Scaler.unscaleDoubleToInt(y, this.scaleHeight);
        this.vpanel.setLightPen(ux, uy);
    }

    @Override
    public void resetDirectdraw() {
        this.directDrawVector = null;
    }

    @Override
    public void updateDisplay() {
        if (!this.config.useRayGun) {
            this.paintVectrex();
        }
        this.repaint();
    }

    @Override
    public void directDraw(VecXState.vector_t v) {
        this.directDrawVector = v;
    }

    @Override
    public void overlayChanged() {
        this.deinitOverlayTexture();
        this.doDeinitBlurShaders = true;
    }

    @Override
    public void deinit() {
        if (this.capturing) {
            // empty if block
        }
        if (this.animator != null) {
            this.animator.stop();
        }
        this.animator = null;
        this.deinitOverlayTexture();
        this.deinitBlurShaders();
        this.deinitShaders();
        this.deinitTextures();
        this.deinitFramebuffer();
        this.deinitMSAAFramebuffer();
        this.auddr = null;
        this.destroy();
        this.removeGLEventListener(this.glListener);
        this.glListener = null;
    }

    void deinitOverlayTexture() {
        if (this.auddr != null && this.auddr.getGL() != null) {
            GL2 gl2 = this.auddr.getGL().getGL2();
            if (this.overlayInitialized && this.overlayTextureObject.get(0) != 0) {
                gl2.glDeleteTextures(1, this.overlayTextureObject);
                this.overlayTextureObject.put(0, 0);
            }
        }
        this.overlayInitialized = false;
    }

    void deinitChassisTexture() {
        if (this.auddr != null && this.auddr.getGL() != null) {
            GL2 gl2 = this.auddr.getGL().getGL2();
            if (this.screenTextureObject.get(0) != 0) {
                gl2.glDeleteTextures(1, this.screenTextureObject);
                this.screenTextureObject.put(0, 0);
            }
        }
    }

    void deinitTextures() {
        this.deinitOverlayTexture();
        this.deinitChassisTexture();
    }

    void deinitShaders() {
        if (this.auddr != null && this.auddr.getGL() != null) {
            GL2 gl2 = this.auddr.getGL().getGL2();
            if (this.programId != -1) {
                gl2.glDetachShader(this.programId, this.vertexShaderId);
                gl2.glDetachShader(this.programId, this.fragmentShaderId);
                gl2.glDeleteProgram(this.programId);
                gl2.glDetachShader(this.persitencyProgramId, this.persitencyVertexShaderId);
                gl2.glDetachShader(this.persitencyProgramId, this.persitencyFragmentShaderId);
                gl2.glDeleteProgram(this.persitencyProgramId);
                gl2.glDetachShader(this.thresholdProgramId, this.thresholdVertexShaderId);
                gl2.glDetachShader(this.thresholdProgramId, this.thresholdFragmentShaderId);
                gl2.glDeleteProgram(this.thresholdProgramId);
                gl2.glDetachShader(this.spillProgramId, this.spillVertexShaderId);
                gl2.glDetachShader(this.spillProgramId, this.spillFragmentShaderId);
                gl2.glDeleteProgram(this.spillProgramId);
                gl2.glDetachShader(this.spillFinalProgramId, this.spillFinalVertexShaderId);
                gl2.glDetachShader(this.spillFinalProgramId, this.spillFinalFragmentShaderId);
                gl2.glDeleteProgram(this.spillFinalProgramId);
                gl2.glDetachShader(this.overlayProgramId, this.overlayVertexShaderId);
                gl2.glDetachShader(this.overlayProgramId, this.overlayFragmentShaderId);
                gl2.glDeleteProgram(this.overlayProgramId);
                gl2.glDetachShader(this.screenProgramId, this.screenVertexShaderId);
                gl2.glDetachShader(this.screenProgramId, this.screenFragmentShaderId);
                gl2.glDeleteProgram(this.screenProgramId);
            }
        }
        this.shadersInitialized = false;
        this.programId = -1;
    }

    void deinitMSAAFramebuffer() {
        if (!this.framebufferInitialized) {
            return;
        }
        if (this.auddr != null && this.auddr.getGL() != null) {
            GL2 gl2 = this.auddr.getGL().getGL2();
            if (this.fboMSAATextureObject.get(0) != 0) {
                gl2.glDeleteTextures(1, this.fboMSAATextureObject);
            }
            if (this.fboMSAABufferObject.get(0) != 0) {
                gl2.glDeleteFramebuffers(1, this.fboMSAABufferObject);
            }
            this.fboMSAABufferObject.put(0, 0);
            this.fboMSAATextureObject.put(0, 0);
        }
        this.framebufferInitialized = false;
    }

    void deinitFramebuffer() {
        if (this.auddr != null && this.auddr.getGL() != null) {
            GL2 gl2 = this.auddr.getGL().getGL2();
            if (this.lineFBO[0].texture.get(0) != 0) {
                gl2.glDeleteTextures(1, this.lineFBO[0].texture);
            }
            if (this.lineFBO[0].fbo.get(0) != 0) {
                gl2.glDeleteFramebuffers(1, this.lineFBO[0].fbo);
            }
            if (this.lineFBO[1].texture.get(0) != 0) {
                gl2.glDeleteTextures(1, this.lineFBO[1].texture);
            }
            if (this.lineFBO[1].fbo.get(0) != 0) {
                gl2.glDeleteFramebuffers(1, this.lineFBO[1].fbo);
            }
            if (this.lineFBO[2].texture.get(0) != 0) {
                gl2.glDeleteTextures(1, this.lineFBO[2].texture);
            }
            if (this.lineFBO[2].fbo.get(0) != 0) {
                gl2.glDeleteFramebuffers(1, this.lineFBO[2].fbo);
            }
            if (this.lineFBO[3].texture.get(0) != 0) {
                gl2.glDeleteTextures(1, this.lineFBO[3].texture);
            }
            if (this.lineFBO[3].fbo.get(0) != 0) {
                gl2.glDeleteFramebuffers(1, this.lineFBO[3].fbo);
            }
            if (this.lineFBO[4].texture.get(0) != 0) {
                gl2.glDeleteTextures(1, this.lineFBO[4].texture);
            }
            if (this.lineFBO[4].fbo.get(0) != 0) {
                gl2.glDeleteFramebuffers(1, this.lineFBO[4].fbo);
            }
            if (this.lineFBO[5].texture.get(0) != 0) {
                gl2.glDeleteTextures(1, this.lineFBO[5].texture);
            }
            if (this.lineFBO[5].fbo.get(0) != 0) {
                gl2.glDeleteFramebuffers(1, this.lineFBO[5].fbo);
            }
            if (this.borderFBO[0].texture.get(0) != 0) {
                gl2.glDeleteTextures(1, this.borderFBO[0].texture);
            }
            if (this.borderFBO[0].fbo.get(0) != 0) {
                gl2.glDeleteFramebuffers(1, this.borderFBO[0].fbo);
            }
            if (this.borderFBO[1].texture.get(0) != 0) {
                gl2.glDeleteTextures(1, this.borderFBO[1].texture);
            }
            if (this.borderFBO[1].fbo.get(0) != 0) {
                gl2.glDeleteFramebuffers(1, this.borderFBO[1].fbo);
            }
            if (this.borderFBO[2].texture.get(0) != 0) {
                gl2.glDeleteTextures(1, this.borderFBO[2].texture);
            }
            if (this.borderFBO[2].fbo.get(0) != 0) {
                gl2.glDeleteFramebuffers(1, this.borderFBO[2].fbo);
            }
            if (this.borderFBO[3].texture.get(0) != 0) {
                gl2.glDeleteTextures(1, this.borderFBO[3].texture);
            }
            if (this.borderFBO[3].fbo.get(0) != 0) {
                gl2.glDeleteFramebuffers(1, this.borderFBO[3].fbo);
            }
            this.lineFBO[0].texture.put(0, 0);
            this.lineFBO[0].fbo.put(0, 0);
            this.lineFBO[1].texture.put(0, 0);
            this.lineFBO[1].fbo.put(0, 0);
            this.lineFBO[2].texture.put(0, 0);
            this.lineFBO[2].fbo.put(0, 0);
            this.lineFBO[3].texture.put(0, 0);
            this.lineFBO[3].fbo.put(0, 0);
            this.lineFBO[4].texture.put(0, 0);
            this.lineFBO[4].fbo.put(0, 0);
            this.lineFBO[5].texture.put(0, 0);
            this.lineFBO[5].fbo.put(0, 0);
            this.borderFBO[0].texture.put(0, 0);
            this.borderFBO[0].fbo.put(0, 0);
            this.borderFBO[1].texture.put(0, 0);
            this.borderFBO[1].fbo.put(0, 0);
            this.borderFBO[2].texture.put(0, 0);
            this.borderFBO[2].fbo.put(0, 0);
            this.borderFBO[3].texture.put(0, 0);
            this.borderFBO[3].fbo.put(0, 0);
        }
    }

    boolean initShader(GL2 gl2, String vertexShaderFile, String fragmentShaderFile) {
        try {
            this.deinitShaders();
            String vertexShaderCode = UtilityString.readTextFileToOneString(new File(UtilityFiles.convertSeperator(vertexShaderFile)));
            String fragmentShaderCode = UtilityString.readTextFileToOneString(new File(UtilityFiles.convertSeperator(fragmentShaderFile)));
            this.programId = gl2.glCreateProgram();
            this.vertexShaderId = JOGLSupport.createShader(gl2, this.programId, vertexShaderCode, 35633);
            this.fragmentShaderId = JOGLSupport.createShader(gl2, this.programId, fragmentShaderCode, 35632);
            JOGLSupport.link(gl2, this.programId);
            this.positionAttribute = gl2.glGetAttribLocation(this.programId, "inPosition");
            this.colorAttribute = gl2.glGetAttribLocation(this.programId, "inColor");
            if (!JOGLSupport.checkError(gl2, "initShader()")) {
                return false;
            }
            String persitencyVertexShaderCode = UtilityString.readTextFileToOneString(new File(UtilityFiles.convertSeperator(Global.mainPathPrefix + "theme/shaders/blurShader.vs")));
            String persitencyFragmentShaderCode = UtilityString.readTextFileToOneString(new File(UtilityFiles.convertSeperator(Global.mainPathPrefix + "theme/shaders/persitencyShader.fs")));
            this.persitencyProgramId = gl2.glCreateProgram();
            this.persitencyVertexShaderId = JOGLSupport.createShader(gl2, this.persitencyProgramId, persitencyVertexShaderCode, 35633);
            this.persitencyFragmentShaderId = JOGLSupport.createShader(gl2, this.persitencyProgramId, persitencyFragmentShaderCode, 35632);
            JOGLSupport.link(gl2, this.persitencyProgramId);
            String thresholdVertexShaderCode = UtilityString.readTextFileToOneString(new File(UtilityFiles.convertSeperator(Global.mainPathPrefix + "theme/shaders/blurShader.vs")));
            String thresholdFragmentShaderCode = UtilityString.readTextFileToOneString(new File(UtilityFiles.convertSeperator(Global.mainPathPrefix + "theme/shaders/thresholdShader.fs")));
            this.thresholdProgramId = gl2.glCreateProgram();
            this.thresholdVertexShaderId = JOGLSupport.createShader(gl2, this.thresholdProgramId, thresholdVertexShaderCode, 35633);
            this.thresholdFragmentShaderId = JOGLSupport.createShader(gl2, this.thresholdProgramId, thresholdFragmentShaderCode, 35632);
            JOGLSupport.link(gl2, this.thresholdProgramId);
            String spillVertexShaderCode = UtilityString.readTextFileToOneString(new File(UtilityFiles.convertSeperator(Global.mainPathPrefix + "theme/shaders/blurShader.vs")));
            String spillFragmentShaderCode = UtilityString.readTextFileToOneString(new File(UtilityFiles.convertSeperator(Global.mainPathPrefix + "theme/shaders/spillShader.fs")));
            this.spillProgramId = gl2.glCreateProgram();
            this.spillVertexShaderId = JOGLSupport.createShader(gl2, this.spillProgramId, spillVertexShaderCode, 35633);
            this.spillFragmentShaderId = JOGLSupport.createShader(gl2, this.spillProgramId, spillFragmentShaderCode, 35632);
            JOGLSupport.link(gl2, this.spillProgramId);
            String spillFinalVertexShaderCode = UtilityString.readTextFileToOneString(new File(UtilityFiles.convertSeperator(Global.mainPathPrefix + "theme/shaders/blurShader.vs")));
            String spillFinalFragmentShaderCode = UtilityString.readTextFileToOneString(new File(UtilityFiles.convertSeperator(Global.mainPathPrefix + "theme/shaders/spillFinalShader.fs")));
            this.spillFinalProgramId = gl2.glCreateProgram();
            this.spillFinalVertexShaderId = JOGLSupport.createShader(gl2, this.spillFinalProgramId, spillFinalVertexShaderCode, 35633);
            this.spillFinalFragmentShaderId = JOGLSupport.createShader(gl2, this.spillFinalProgramId, spillFinalFragmentShaderCode, 35632);
            JOGLSupport.link(gl2, this.spillFinalProgramId);
            String overlayVertexShaderCode = UtilityString.readTextFileToOneString(new File(UtilityFiles.convertSeperator(Global.mainPathPrefix + "theme/shaders/blurShader.vs")));
            String overlayFragmentShaderCode = UtilityString.readTextFileToOneString(new File(UtilityFiles.convertSeperator(Global.mainPathPrefix + "theme/shaders/overlayShader.fs")));
            this.overlayProgramId = gl2.glCreateProgram();
            this.overlayVertexShaderId = JOGLSupport.createShader(gl2, this.overlayProgramId, overlayVertexShaderCode, 35633);
            this.overlayFragmentShaderId = JOGLSupport.createShader(gl2, this.overlayProgramId, overlayFragmentShaderCode, 35632);
            JOGLSupport.link(gl2, this.overlayProgramId);
            String screenVertexShaderCode = UtilityString.readTextFileToOneString(new File(UtilityFiles.convertSeperator(Global.mainPathPrefix + "theme/shaders/blurShader.vs")));
            String screenFragmentShaderCode = UtilityString.readTextFileToOneString(new File(UtilityFiles.convertSeperator(Global.mainPathPrefix + "theme/shaders/screenShader.fs")));
            this.screenProgramId = gl2.glCreateProgram();
            this.screenVertexShaderId = JOGLSupport.createShader(gl2, this.screenProgramId, screenVertexShaderCode, 35633);
            this.screenFragmentShaderId = JOGLSupport.createShader(gl2, this.screenProgramId, screenFragmentShaderCode, 35632);
            JOGLSupport.link(gl2, this.screenProgramId);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return false;
        }
        this.shadersInitialized = true;
        return true;
    }

    synchronized boolean initOverlay(GL2 gl2) {
        try {
            this.deinitOverlayTexture();
            if (!this.config.overlayEnabled) {
                return true;
            }
            if (this.vpanel.getOverlayImageOrg() != null) {
                Texture overlayTexture = AWTTextureIO.newTexture((GLProfile)gl2.getGLProfile(), (BufferedImage)this.vpanel.getOverlayImageOrg(), (boolean)false);
                this.overlayMustFlip = overlayTexture.getMustFlipVertically();
                overlayTexture.destroy((GL)gl2);
                overlayTexture = null;
                DataBufferByte ddb = (DataBufferByte)this.vpanel.getOverlayImageOrg().getData().getDataBuffer();
                ByteBuffer overlayTexturePixelBuffer = ByteBuffer.wrap(ddb.getData());
                gl2.glGenTextures(1, this.overlayTextureObject);
                gl2.glBindTexture(3553, this.overlayTextureObject.get(0));
                gl2.glTexParameteri(3553, 33084, 0);
                gl2.glTexParameteri(3553, 33085, 0);
                gl2.glTexImage2D(3553, 0, 6408, this.vpanel.getOverlayImageOrg().getWidth(), this.vpanel.getOverlayImageOrg().getHeight(), 0, 6408, 32821, (Buffer)overlayTexturePixelBuffer);
                gl2.glBindTexture(3553, 0);
                if (!JOGLSupport.checkError(gl2, "initOverlay()")) {
                    return false;
                }
                this.overlayInitialized = true;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    synchronized boolean initChassis(GL2 gl2) {
        try {
            this.deinitChassisTexture();
            if (!this.config.JOGLScreen) {
                return true;
            }
            String screenName = Global.mainPathPrefix + "theme/screen.png";
            BufferedImage screen = UtilityImage.loadImage(screenName);
            if (screen == null) {
                this.log.addLog("Screen not found!");
                VideConfig.CHASSIS_AVAILABLE = -1;
                return false;
            }
            Texture screenTexture = AWTTextureIO.newTexture((GLProfile)gl2.getGLProfile(), (BufferedImage)screen, (boolean)false);
            this.screenMustFlip = screenTexture.getMustFlipVertically();
            screenTexture.destroy((GL)gl2);
            screenTexture = null;
            DataBufferByte ddb = (DataBufferByte)screen.getData().getDataBuffer();
            ByteBuffer screenTexturePixelBuffer = ByteBuffer.wrap(ddb.getData());
            gl2.glGenTextures(1, this.screenTextureObject);
            gl2.glBindTexture(3553, this.screenTextureObject.get(0));
            gl2.glTexParameteri(3553, 33084, 0);
            gl2.glTexParameteri(3553, 33085, 0);
            gl2.glTexImage2D(3553, 0, 6408, screen.getWidth(), screen.getHeight(), 0, 6408, 32821, (Buffer)screenTexturePixelBuffer);
            gl2.glBindTexture(3553, 0);
            if (!JOGLSupport.checkError(gl2, "initChassis()")) {
                return false;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            return false;
        }
        if (VideConfig.CHASSIS_AVAILABLE != 1) {
            return true;
        }
        return true;
    }

    synchronized boolean initMSAAFramebuffer(GL2 gl2) {
        try {
            if (this.config.JOGLMSAA && JOGLSupport.getVersion() >= 210) {
                this.deinitMSAAFramebuffer();
                if (JOGLSupport.getVersion() >= 320) {
                    gl2.glGenTextures(1, this.fboMSAATextureObject);
                    gl2.glBindTexture(37120, this.fboMSAATextureObject.get(0));
                    gl2.glTexImage2DMultisample(37120, this.config.JOGLmultiSample, 6408, this.gl2Width, this.gl2Height, false);
                    if (!JOGLSupport.checkError(gl2, "initMSAAFramebuffer():320")) {
                        return false;
                    }
                    gl2.glBindTexture(37120, 0);
                    gl2.glGenFramebuffers(1, this.fboMSAABufferObject);
                    gl2.glBindFramebuffer(36160, this.fboMSAABufferObject.get(0));
                    gl2.glFramebufferTexture2D(36160, 36064, 37120, this.fboMSAATextureObject.get(0), 0);
                    gl2.glBindFramebuffer(36160, 0);
                } else if (JOGLSupport.getVersion() >= 210) {
                    gl2.glGenRenderbuffers(1, this.fboMSAATextureObject);
                    gl2.glBindRenderbuffer(36161, this.fboMSAATextureObject.get(0));
                    gl2.glRenderbufferStorageMultisample(36161, this.config.JOGLmultiSample, 6408, this.gl2Width, this.gl2Height);
                    if (!JOGLSupport.checkError(gl2, "initMSAAFramebuffer():210a")) {
                        return false;
                    }
                    gl2.glBindRenderbuffer(36161, 0);
                    gl2.glGenFramebuffers(1, this.fboMSAABufferObject);
                    gl2.glBindFramebuffer(36160, this.fboMSAABufferObject.get(0));
                    gl2.glFramebufferRenderbuffer(36160, 36064, 36161, this.fboMSAATextureObject.get(0));
                    gl2.glBindFramebuffer(36160, 0);
                    if (!JOGLSupport.checkError(gl2, "initMSAAFramebuffer():210b")) {
                        return false;
                    }
                    if (!JOGLSupport.checkFramebufferStatus(gl2, this.fboMSAABufferObject.get(0), "fboMSAABufferObject")) {
                        return false;
                    }
                }
                this.framebufferInitialized = true;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    synchronized boolean initFramebuffer(GL2 gl2) {
        try {
            this.deinitFramebuffer();
            gl2.glGenTextures(1, this.lineFBO[0].texture);
            gl2.glBindTexture(3553, this.lineFBO[0].texture.get(0));
            gl2.glTexImage2D(3553, 0, 6408, this.gl2Width, this.gl2Height, 0, 6408, 5121, null);
            gl2.glTexParameteri(3553, 10241, 9729);
            gl2.glTexParameteri(3553, 10240, 9729);
            gl2.glTexParameteri(3553, 33084, 0);
            gl2.glTexParameteri(3553, 33085, 0);
            gl2.glBindTexture(3553, 0);
            gl2.glGenTextures(1, this.lineFBO[1].texture);
            gl2.glBindTexture(3553, this.lineFBO[1].texture.get(0));
            gl2.glTexImage2D(3553, 0, 6408, this.gl2Width, this.gl2Height, 0, 6408, 5121, null);
            gl2.glTexParameteri(3553, 10241, 9729);
            gl2.glTexParameteri(3553, 10240, 9729);
            gl2.glTexParameteri(3553, 33084, 0);
            gl2.glTexParameteri(3553, 33085, 0);
            gl2.glBindTexture(3553, 0);
            gl2.glGenTextures(1, this.lineFBO[2].texture);
            gl2.glBindTexture(3553, this.lineFBO[2].texture.get(0));
            gl2.glTexImage2D(3553, 0, 6408, this.gl2Width, this.gl2Height, 0, 6408, 5121, null);
            gl2.glTexParameteri(3553, 10241, 9729);
            gl2.glTexParameteri(3553, 10240, 9729);
            gl2.glTexParameteri(3553, 33084, 0);
            gl2.glTexParameteri(3553, 33085, 0);
            gl2.glBindTexture(3553, 0);
            gl2.glGenTextures(1, this.lineFBO[3].texture);
            gl2.glBindTexture(3553, this.lineFBO[3].texture.get(0));
            gl2.glTexImage2D(3553, 0, 6408, this.gl2Width, this.gl2Height, 0, 6408, 5121, null);
            gl2.glTexParameteri(3553, 10241, 9729);
            gl2.glTexParameteri(3553, 10240, 9729);
            gl2.glTexParameteri(3553, 33084, 0);
            gl2.glTexParameteri(3553, 33085, 0);
            gl2.glBindTexture(3553, 0);
            if (this.config.JOGLMIP_RESOLUTION > 0) {
                int w = this.gl2Width / (1 << this.config.JOGLMIP_RESOLUTION);
                int h = this.gl2Height / (1 << this.config.JOGLMIP_RESOLUTION);
                gl2.glGenTextures(1, this.lineFBO[4].texture);
                gl2.glBindTexture(3553, this.lineFBO[4].texture.get(0));
                gl2.glTexImage2D(3553, 0, 6408, w, h, 0, 6408, 5121, null);
                gl2.glTexParameteri(3553, 10241, 9729);
                gl2.glTexParameteri(3553, 10240, 9729);
                gl2.glTexParameteri(3553, 33084, 0);
                gl2.glTexParameteri(3553, 33085, 0);
                gl2.glBindTexture(3553, 0);
                gl2.glGenTextures(1, this.lineFBO[5].texture);
                gl2.glBindTexture(3553, this.lineFBO[5].texture.get(0));
                gl2.glTexImage2D(3553, 0, 6408, w, h, 0, 6408, 5121, null);
                gl2.glTexParameteri(3553, 10241, 9729);
                gl2.glTexParameteri(3553, 10240, 9729);
                gl2.glTexParameteri(3553, 33084, 0);
                gl2.glTexParameteri(3553, 33085, 0);
                gl2.glBindTexture(3553, 0);
            }
            gl2.glGenTextures(1, this.borderFBO[0].texture);
            gl2.glBindTexture(3553, this.borderFBO[0].texture.get(0));
            gl2.glTexImage2D(3553, 0, 6408, VecX.OVERFLOW_BORDER_RAYWIDTH, VecX.OVERFLOW_SAMPLE_MAX, 0, 6408, 5121, null);
            gl2.glTexParameteri(3553, 10241, 9729);
            gl2.glTexParameteri(3553, 10240, 9729);
            gl2.glTexParameteri(3553, 33084, 0);
            gl2.glTexParameteri(3553, 33085, 0);
            gl2.glBindTexture(3553, 0);
            gl2.glGenTextures(1, this.borderFBO[1].texture);
            gl2.glBindTexture(3553, this.borderFBO[1].texture.get(0));
            gl2.glTexImage2D(3553, 0, 6408, VecX.OVERFLOW_BORDER_RAYWIDTH, VecX.OVERFLOW_SAMPLE_MAX, 0, 6408, 5121, null);
            gl2.glTexParameteri(3553, 10241, 9729);
            gl2.glTexParameteri(3553, 10240, 9729);
            gl2.glTexParameteri(3553, 33084, 0);
            gl2.glTexParameteri(3553, 33085, 0);
            gl2.glBindTexture(3553, 0);
            gl2.glGenTextures(1, this.borderFBO[2].texture);
            gl2.glBindTexture(3553, this.borderFBO[2].texture.get(0));
            gl2.glTexImage2D(3553, 0, 6408, VecX.OVERFLOW_SAMPLE_MAX, VecX.OVERFLOW_BORDER_RAYWIDTH, 0, 6408, 5121, null);
            gl2.glTexParameteri(3553, 10241, 9729);
            gl2.glTexParameteri(3553, 10240, 9729);
            gl2.glTexParameteri(3553, 33084, 0);
            gl2.glTexParameteri(3553, 33085, 0);
            gl2.glBindTexture(3553, 0);
            gl2.glGenTextures(1, this.borderFBO[3].texture);
            gl2.glBindTexture(3553, this.borderFBO[3].texture.get(0));
            gl2.glTexImage2D(3553, 0, 6408, VecX.OVERFLOW_SAMPLE_MAX, VecX.OVERFLOW_BORDER_RAYWIDTH, 0, 6408, 5121, null);
            gl2.glTexParameteri(3553, 10241, 9729);
            gl2.glTexParameteri(3553, 10240, 9729);
            gl2.glTexParameteri(3553, 33084, 0);
            gl2.glTexParameteri(3553, 33085, 0);
            gl2.glBindTexture(3553, 0);
            if (!JOGLSupport.checkError(gl2, "initFramebuffer():1")) {
                return false;
            }
            gl2.glBindRenderbuffer(36161, 0);
            gl2.glGenFramebuffers(1, this.lineFBO[0].fbo);
            gl2.glBindFramebuffer(36160, this.lineFBO[0].fbo.get(0));
            gl2.glFramebufferTexture2D(36160, 36064, 3553, this.lineFBO[0].texture.get(0), 0);
            gl2.glGenFramebuffers(1, this.lineFBO[1].fbo);
            gl2.glBindFramebuffer(36160, this.lineFBO[1].fbo.get(0));
            gl2.glFramebufferTexture2D(36160, 36064, 3553, this.lineFBO[1].texture.get(0), 0);
            gl2.glGenFramebuffers(1, this.lineFBO[2].fbo);
            gl2.glBindFramebuffer(36160, this.lineFBO[2].fbo.get(0));
            gl2.glFramebufferTexture2D(36160, 36064, 3553, this.lineFBO[2].texture.get(0), 0);
            gl2.glGenFramebuffers(1, this.lineFBO[3].fbo);
            gl2.glBindFramebuffer(36160, this.lineFBO[3].fbo.get(0));
            gl2.glFramebufferTexture2D(36160, 36064, 3553, this.lineFBO[3].texture.get(0), 0);
            if (this.config.JOGLMIP_RESOLUTION > 0) {
                gl2.glGenFramebuffers(1, this.lineFBO[4].fbo);
                gl2.glBindFramebuffer(36160, this.lineFBO[4].fbo.get(0));
                gl2.glFramebufferTexture2D(36160, 36064, 3553, this.lineFBO[4].texture.get(0), 0);
                gl2.glGenFramebuffers(1, this.lineFBO[5].fbo);
                gl2.glBindFramebuffer(36160, this.lineFBO[5].fbo.get(0));
                gl2.glFramebufferTexture2D(36160, 36064, 3553, this.lineFBO[5].texture.get(0), 0);
            }
            gl2.glGenFramebuffers(1, this.borderFBO[0].fbo);
            gl2.glBindFramebuffer(36160, this.borderFBO[0].fbo.get(0));
            gl2.glFramebufferTexture2D(36160, 36064, 3553, this.borderFBO[0].texture.get(0), 0);
            gl2.glGenFramebuffers(1, this.borderFBO[1].fbo);
            gl2.glBindFramebuffer(36160, this.borderFBO[1].fbo.get(0));
            gl2.glFramebufferTexture2D(36160, 36064, 3553, this.borderFBO[1].texture.get(0), 0);
            gl2.glGenFramebuffers(1, this.borderFBO[2].fbo);
            gl2.glBindFramebuffer(36160, this.borderFBO[2].fbo.get(0));
            gl2.glFramebufferTexture2D(36160, 36064, 3553, this.borderFBO[2].texture.get(0), 0);
            gl2.glGenFramebuffers(1, this.borderFBO[3].fbo);
            gl2.glBindFramebuffer(36160, this.borderFBO[3].fbo.get(0));
            gl2.glFramebufferTexture2D(36160, 36064, 3553, this.borderFBO[3].texture.get(0), 0);
            gl2.glBindFramebuffer(36160, 0);
            if (!JOGLSupport.checkError(gl2, "initFramebuffer():2")) {
                return false;
            }
            boolean ok = true;
            ok &= JOGLSupport.checkFramebufferStatus(gl2, this.lineFBO[0].fbo.get(0), "lineFBO[0]");
            ok &= JOGLSupport.checkFramebufferStatus(gl2, this.lineFBO[1].fbo.get(0), "lineFBO[1]");
            ok &= JOGLSupport.checkFramebufferStatus(gl2, this.lineFBO[2].fbo.get(0), "lineFBO[2]");
            ok &= JOGLSupport.checkFramebufferStatus(gl2, this.lineFBO[3].fbo.get(0), "lineFBO[3]");
            if (this.config.JOGLMIP_RESOLUTION > 0) {
                ok &= JOGLSupport.checkFramebufferStatus(gl2, this.lineFBO[4].fbo.get(0), "lineFBO[4]");
                ok &= JOGLSupport.checkFramebufferStatus(gl2, this.lineFBO[5].fbo.get(0), "lineFBO[5]");
            }
            ok &= JOGLSupport.checkFramebufferStatus(gl2, this.borderFBO[0].fbo.get(0), "borderFBO[0]");
            ok &= JOGLSupport.checkFramebufferStatus(gl2, this.borderFBO[1].fbo.get(0), "borderFBO[1]");
            ok &= JOGLSupport.checkFramebufferStatus(gl2, this.borderFBO[2].fbo.get(0), "borderFBO[2]");
            if (!(ok &= JOGLSupport.checkFramebufferStatus(gl2, this.borderFBO[3].fbo.get(0), "borderFBO[3]"))) {
                return false;
            }
            gl2.glBindFramebuffer(36160, this.lineFBO[3].fbo.get(0));
            gl2.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
            gl2.glClear(16384);
            gl2.glBindFramebuffer(36160, 0);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    protected synchronized void setup(GLAutoDrawable glautodrawable, int width, int height) {
        try {
            this.vectrexVectors = new VecXState.vector_t[2][MAX_RAY_VECTORS];
            for (int i = 0; i < MAX_RAY_VECTORS; ++i) {
                this.vectrexVectors[0][i] = new VecXState.vector_t();
                this.vectrexVectors[1][i] = new VecXState.vector_t();
            }
            this.currentRayAdd = 0;
            this.currentRayDisplay = 1;
            this.rayAddPos = 0;
            this.rayCount = 0;
            this.rayInit = true;
            this.gl2Width = width;
            this.gl2Height = height;
            this.scaleWidth = (float)((double)this.gl2Width / (double)this.config.ALG_MAX_X);
            this.scaleHeight = (float)((double)this.gl2Height / (double)this.config.ALG_MAX_Y);
            GL2 gl2 = glautodrawable.getGL().getGL2();
            JOGLSupport.dumpInfos((GL)gl2);
            gl2.glDisable(2848);
            gl2.glDisable(2881);
            gl2.glDisable(2832);
            gl2.glDisable(32925);
            gl2.glEnable(3553);
            gl2.glActiveTexture(33984);
            this.initBuffers(gl2);
            if (!this.shadersInitialized) {
                this.initShader(gl2, Global.mainPathPrefix + "theme/shaders/default.vs", Global.mainPathPrefix + "theme/shaders/default.fs");
            }
            if (!this.blurShadersInitialized) {
                this.initBlurShader(gl2, Global.mainPathPrefix + "theme/shaders/blurShader.vs", Global.mainPathPrefix + "theme/shaders/blurShader.fs");
            }
            if (!this.overlayInitialized) {
                this.initOverlay(gl2);
            }
            this.initChassis(gl2);
            this.initFramebuffer(gl2);
            this.initMSAAFramebuffer(gl2);
            if (this.animator != null) {
                this.animator.start();
            }
        }
        catch (Throwable e) {
            this.log.addLog("ERROR while handling JOGL!", 64);
            this.log.addLog(e, 64);
            this.log.addLog("Reverting to JAVA output!", 64);
            this.log.addLog("GL should support: ", 64);
            try {
                this.log.addLog(JOGLSupport.dumpInfos((GL)glautodrawable.getGL().getGL2()), 64);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    VecxiPanel_JOGL.this.config.tryJOGL = false;
                    ArrayList<Object> allVecxis = Configuration.getConfiguration().getMainFrame().getPanels(VecXPanel.class);
                    for (Object p : allVecxis) {
                        ((VecXPanel)p).changeDisplay();
                    }
                }
            });
        }
    }

    void deinitBuffers(GL2 gl2) {
        gl2.glDeleteBuffers(1, this.vertexBufferObject);
        gl2.glDeleteBuffers(1, this.lineBufferObject);
        this.deinitLineStrips(gl2);
        this.buffersInitialized = false;
    }

    void initBuffers(GL2 gl2) {
        if (this.buffersInitialized) {
            return;
        }
        gl2.glGenBuffers(1, this.vertexBufferObject);
        gl2.glGenBuffers(1, this.lineBufferObject);
        this.linesData = new float[this.MAXBUFFERSIZE_LINE * 10];
        this.linesDataBuffer = FloatBuffer.wrap(this.linesData);
        this.pointsData = new float[this.MAXBUFFERSIZE_POINT * 5];
        this.pointsDataBuffer = FloatBuffer.wrap(this.pointsData);
        this.initLineStrips(this.MAX_LINE_STRIPS, gl2);
        this.buffersInitialized = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addCatmullRom(ArrayList<Point> spline, int c, int s, int left, int right) {
        if (this.splineCount >= this.MAX_LINE_STRIPS) {
            return;
        }
        boolean isImager = this.vpanel.isImagerMode();
        float brightnessAdjustFactor = (100.0f + (float)this.config.brightness) / 100.0f;
        ArrayList<Point> arrayList = spline;
        synchronized (arrayList) {
            if (spline.size() == 2) {
                float x0 = Scaler.scaleFloatToFloat(spline.get((int)0).x - this.config.ALG_MAX_X / 2, this.scaleWidthGL);
                float y0 = Scaler.scaleFloatToFloat(-(spline.get((int)0).y - this.config.ALG_MAX_Y / 2), this.scaleHeightGL);
                float x1 = Scaler.scaleFloatToFloat(spline.get((int)1).x - this.config.ALG_MAX_X / 2, this.scaleWidthGL);
                float y1 = Scaler.scaleFloatToFloat(-(spline.get((int)1).y - this.config.ALG_MAX_Y / 2), this.scaleHeightGL);
                if (Math.abs(x0 * (float)this.gl2Width - x1 * (float)this.gl2Width) < (float)this.config.lineWidth && Math.abs(y0 * (float)this.gl2Height - y1 * (float)this.gl2Height) < (float)this.config.lineWidth) {
                    if (this.MAXBUFFERSIZE_POINT < this.pointCount - 1) {
                        this.MAXBUFFERSIZE_POINT *= 2;
                        this.pointsData = new float[this.MAXBUFFERSIZE_POINT * 5];
                        this.pointsDataBuffer = FloatBuffer.wrap(this.pointsData);
                    }
                    float bAdjust = brightnessAdjustFactor / this.COLOR_DIV;
                    Color drawColor = new Color(c, c, c, 255);
                    if (isImager) {
                        drawColor = this.vpanel.getColor(c, left, right, drawColor);
                    }
                    if (this.config.vectrexColorMode) {
                        drawColor = this.getColorVectrexColor(c);
                    }
                    if (this.config.JOGLuseSpillShader) {
                        bAdjust = (float)((double)bAdjust / this.config.JOGLInitialSpillDivisor);
                    }
                    if (s >= 128) {
                        int dotDwell = (int)((float)(s - 128) / this.config.JOGLDotDwellDivisor);
                        this.pointsData[this.pointCount++] = x0;
                        this.pointsData[this.pointCount++] = y0;
                        this.pointsData[this.pointCount++] = (float)drawColor.getRed() * bAdjust * (float)dotDwell;
                        this.pointsData[this.pointCount++] = (float)drawColor.getGreen() * bAdjust * (float)dotDwell;
                        this.pointsData[this.pointCount++] = (float)drawColor.getBlue() * bAdjust * (float)dotDwell;
                    } else {
                        float speed = s;
                        float speedFactor = this.SPEED_FACTOR_MAX - this.config.JOGL_speedMaxReduce * (speed / 127.0f);
                        this.pointsData[this.pointCount++] = x0;
                        this.pointsData[this.pointCount++] = y0;
                        this.pointsData[this.pointCount++] = (float)drawColor.getRed() * (bAdjust *= speedFactor);
                        this.pointsData[this.pointCount++] = (float)drawColor.getGreen() * bAdjust;
                        this.pointsData[this.pointCount++] = (float)drawColor.getBlue() * bAdjust;
                    }
                } else {
                    float bAdjust = brightnessAdjustFactor / this.COLOR_DIV;
                    Color drawColor = new Color(c, c, c, 255);
                    if (isImager) {
                        drawColor = this.vpanel.getColor(c, left, right, drawColor);
                    }
                    if (this.config.vectrexColorMode) {
                        drawColor = this.getColorVectrexColor(c);
                    }
                    if (this.config.JOGLuseSpillShader) {
                        bAdjust = (float)((double)bAdjust / this.config.JOGLInitialSpillDivisor);
                    }
                    float speed = s;
                    if (s >= 128) {
                        speed = 0.0f;
                    }
                    float speedFactor = this.SPEED_FACTOR_MAX - this.config.JOGL_speedMaxReduce * (speed / 127.0f);
                    this.linesData[this.lineCount++] = x0;
                    this.linesData[this.lineCount++] = y0;
                    this.linesData[this.lineCount++] = (float)drawColor.getRed() * (bAdjust *= speedFactor);
                    this.linesData[this.lineCount++] = (float)drawColor.getGreen() * bAdjust;
                    this.linesData[this.lineCount++] = (float)drawColor.getBlue() * bAdjust;
                    this.linesData[this.lineCount++] = x1;
                    this.linesData[this.lineCount++] = y1;
                    this.linesData[this.lineCount++] = (float)drawColor.getRed() * bAdjust;
                    this.linesData[this.lineCount++] = (float)drawColor.getGreen() * bAdjust;
                    this.linesData[this.lineCount++] = (float)drawColor.getBlue() * bAdjust;
                }
                return;
            }
            float bAdjust = brightnessAdjustFactor / this.COLOR_DIV;
            Color drawColor = new Color(c, c, c, 255);
            if (isImager) {
                drawColor = this.vpanel.getColor(c, left, right, drawColor);
            }
            if (this.config.vectrexColorMode) {
                drawColor = this.getColorVectrexColor(c);
            }
            if (this.config.JOGLuseSpillShader) {
                bAdjust = (float)((double)bAdjust / this.config.JOGLInitialSpillDivisor);
            }
            if (s >= 128) {
                for (int p = 0; p < spline.size(); ++p) {
                    float dotDwell = (float)(s - 128) / this.config.JOGLDotDwellDivisor;
                    dotDwell /= (float)spline.size();
                    float x0 = Scaler.scaleFloatToFloat(spline.get((int)p).x - this.config.ALG_MAX_X / 2, this.scaleWidthGL);
                    float y0 = Scaler.scaleFloatToFloat(-(spline.get((int)p).y - this.config.ALG_MAX_Y / 2), this.scaleHeightGL);
                    if (this.MAXBUFFERSIZE_POINT < this.pointCount - 1) {
                        this.MAXBUFFERSIZE_POINT *= 2;
                        this.pointsData = new float[this.MAXBUFFERSIZE_POINT * 5];
                        this.pointsDataBuffer = FloatBuffer.wrap(this.pointsData);
                    }
                    this.pointsData[this.pointCount++] = x0;
                    this.pointsData[this.pointCount++] = y0;
                    this.pointsData[this.pointCount++] = (float)drawColor.getRed() * bAdjust * dotDwell;
                    this.pointsData[this.pointCount++] = (float)drawColor.getGreen() * bAdjust * dotDwell;
                    this.pointsData[this.pointCount++] = (float)drawColor.getBlue() * bAdjust * dotDwell;
                }
                return;
            }
            float speed = s;
            if (s >= 128) {
                speed = 0.0f;
            }
            float speedFactor = this.SPEED_FACTOR_MAX - this.config.JOGL_speedMaxReduce * (speed / 127.0f);
            bAdjust *= speedFactor;
            CardinalSpline cs = new CardinalSpline();
            Pt po = null;
            for (Point p : spline) {
                double yDif;
                double xDif;
                double d;
                Pt pt = new Pt(p.x, p.y);
                if (po != null && (d = (double)((int)Math.sqrt((xDif = (double)p.x - po.x) * xDif + (yDif = (double)p.y - po.y) * yDif))) > (double)this.config.maxSplineSize) {
                    double div = d / (double)(this.config.maxSplineSize / 2);
                    int i = 1;
                    while ((double)i < div) {
                        cs.addPoint(new Pt(po.x + (double)i * (xDif / div), po.y + (double)i * (yDif / div)));
                        ++i;
                    }
                }
                po = pt;
                cs.addPoint(pt);
            }
            cs.caculate();
            ArrayList<Pt> pts = cs.getPoints();
            if (pts.size() == 0) {
                return;
            }
            LineStripBuffer lineStripBuffer = this.lineStrips[this.splineCount];
            if (pts.size() * 5 >= lineStripBuffer.lineStripData.length) {
                while (pts.size() * 5 >= this.MAXBUFFERSIZE_LINE_STRIP) {
                    this.MAXBUFFERSIZE_LINE_STRIP *= 2;
                }
                lineStripBuffer.updateBuffer();
            }
            lineStripBuffer.lineCount = pts.size();
            ++this.splineCount;
            for (int i = 0; i < pts.size(); ++i) {
                lineStripBuffer.lineStripData[lineStripBuffer.dataCount++] = Scaler.scaleFloatToFloat(pts.get(i).ix() - this.config.ALG_MAX_X / 2, this.scaleWidthGL);
                lineStripBuffer.lineStripData[lineStripBuffer.dataCount++] = Scaler.scaleFloatToFloat(-(pts.get(i).iy() - this.config.ALG_MAX_Y / 2), this.scaleHeightGL);
                lineStripBuffer.lineStripData[lineStripBuffer.dataCount++] = (float)drawColor.getRed() * bAdjust;
                lineStripBuffer.lineStripData[lineStripBuffer.dataCount++] = (float)drawColor.getGreen() * bAdjust;
                lineStripBuffer.lineStripData[lineStripBuffer.dataCount++] = (float)drawColor.getBlue() * bAdjust;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    void prepareData() {
        isImager = this.vpanel.isImagerMode();
        this.lineCount = 0;
        this.pointCount = 0;
        this.resetSplines();
        this.spline.clear();
        brightnessAdjustFactor = (100.0f + (float)this.config.brightness) / 100.0f;
        vList = this.vpanel.getDisplayList();
        list = vList.vectrexVectors;
        count = vList.count;
        if (this.config.useRayGun) {
            list = this.vectrexVectors[this.currentRayDisplay];
            count = this.rayCount;
        }
        if (count == 0) {
            return;
        }
        if (this.MAXBUFFERSIZE_LINE < count + (this.config.vectorsAsArrows != false ? 2 * count : 0)) {
            while (this.MAXBUFFERSIZE_LINE < count + (this.config.vectorsAsArrows != false ? 2 * count : 0)) {
                this.MAXBUFFERSIZE_LINE *= 2;
            }
            this.linesData = new float[this.MAXBUFFERSIZE_LINE * 10];
            this.linesDataBuffer = FloatBuffer.wrap(this.linesData);
        }
        inSpline = false;
        splineColor = 0;
        for (v = 0; v < count; ++v) {
            block24: {
                vector = list[v];
                if (!this.config.useSplines) break block24;
                var10_10 = this.spline;
                synchronized (var10_10) {
                    block26: {
                        block25: {
                            if (inSpline) break block25;
                            if (v != count - 1 && list[v + 1].midChange && list[v].x1 == list[v + 1].x0 && list[v].y1 == list[v + 1].y0 && list[v + 1].color == list[v].color) {
                                this.spline.clear();
                                this.spline.add(new Point(list[v].x0, list[v].y0));
                                splineColor = list[v].color;
                                inSpline = true;
                                continue;
                            }
                            break block24;
                        }
                        if (!list[v].midChange || list[v - 1].x1 != list[v].x0 || list[v - 1].y1 != list[v].y0 || list[v - 1].color != list[v].color) break block26;
                        this.spline.add(new Point(list[v].x0, list[v].y0));
                        if (v == count - 1) {
                            this.spline.add(new Point(list[v].x1, list[v].y1));
                            this.addCatmullRom(this.spline, splineColor, list[v].speed, list[v].imagerColorLeft, list[v].imagerColorRight);
                            inSpline = false;
                            continue;
                        }
                        break block24;
                    }
                    if (!list[v].midChange) ** GOTO lbl-1000
                    if (Math.abs(list[v - 1].x1 - list[v].x0) >= VideConfig.DRIFT_CURVE_THRESHOLD) ** GOTO lbl-1000
                    if (Math.abs(list[v - 1].y1 - list[v].y0) < VideConfig.DRIFT_CURVE_THRESHOLD && list[v - 1].color == list[v].color) {
                        this.spline.add(new Point(list[v - 1].x1, list[v - 1].y1));
                        if (v == count - 1) {
                            this.spline.add(new Point(list[v].x1, list[v].y1));
                            this.addCatmullRom(this.spline, splineColor, list[v].speed, list[v].imagerColorLeft, list[v].imagerColorRight);
                            inSpline = false;
                            continue;
                        }
                    } else lbl-1000:
                    // 3 sources

                    {
                        this.spline.add(new Point(list[v - 1].x1, list[v - 1].y1));
                        this.addCatmullRom(this.spline, splineColor, list[v - 1].speed, list[v - 1].imagerColorLeft, list[v - 1].imagerColorRight);
                        inSpline = false;
                        if (v != count - 1 && list[v + 1].midChange && list[v].midChange && list[v].color == list[v + 1].color) {
                            this.spline.clear();
                            this.spline.add(new Point(list[v].x0, list[v].y0));
                            splineColor = list[v].color;
                            inSpline = true;
                            continue;
                        }
                    }
                }
            }
            if (inSpline) continue;
            x0 = Scaler.scaleFloatToFloat(vector.x0 - this.config.ALG_MAX_X / 2, this.scaleWidthGL);
            y0 = Scaler.scaleFloatToFloat(-(vector.y0 - this.config.ALG_MAX_Y / 2), this.scaleHeightGL);
            x1 = Scaler.scaleFloatToFloat(vector.x1 - this.config.ALG_MAX_X / 2, this.scaleWidthGL);
            y1 = Scaler.scaleFloatToFloat(-(vector.y1 - this.config.ALG_MAX_Y / 2), this.scaleHeightGL);
            if (Math.abs(x0 * (float)this.gl2Width - x1 * (float)this.gl2Width) < (float)this.config.lineWidth && Math.abs(y0 * (float)this.gl2Height - y1 * (float)this.gl2Height) < (float)this.config.lineWidth) {
                if (this.MAXBUFFERSIZE_POINT < this.pointCount - 1) {
                    this.MAXBUFFERSIZE_POINT *= 2;
                    this.pointsData = new float[this.MAXBUFFERSIZE_POINT * 5];
                    this.pointsDataBuffer = FloatBuffer.wrap(this.pointsData);
                }
                bAdjust = brightnessAdjustFactor / this.COLOR_DIV;
                drawColor = new Color(vector.color, vector.color, vector.color, 255);
                if (isImager) {
                    drawColor = this.vpanel.getColor(vector.color, vector.imagerColorLeft, vector.imagerColorRight, drawColor);
                }
                if (this.config.vectrexColorMode) {
                    drawColor = this.getColorVectrexColor(vector.color);
                }
                if (this.config.JOGLuseSpillShader) {
                    bAdjust = (float)((double)bAdjust / this.config.JOGLInitialSpillDivisor);
                }
                if (vector.speed >= 128) {
                    dotDwell = (float)(vector.speed - 128) / this.config.JOGLDotDwellDivisor;
                    this.pointsData[this.pointCount++] = x0;
                    this.pointsData[this.pointCount++] = y0;
                    this.pointsData[this.pointCount++] = (float)drawColor.getRed() * bAdjust * dotDwell;
                    this.pointsData[this.pointCount++] = (float)drawColor.getGreen() * bAdjust * dotDwell;
                    this.pointsData[this.pointCount++] = (float)drawColor.getBlue() * bAdjust * dotDwell;
                    continue;
                }
                speed = vector.speed;
                speedFactor = this.SPEED_FACTOR_MAX - this.config.JOGL_speedMaxReduce * (speed / 127.0f);
                this.pointsData[this.pointCount++] = Scaler.scaleFloatToFloat(vector.x0 - this.config.ALG_MAX_X / 2, this.scaleWidthGL);
                this.pointsData[this.pointCount++] = Scaler.scaleFloatToFloat(-(vector.y0 - this.config.ALG_MAX_Y / 2), this.scaleHeightGL);
                this.pointsData[this.pointCount++] = (float)drawColor.getRed() * (bAdjust *= speedFactor);
                this.pointsData[this.pointCount++] = (float)drawColor.getGreen() * bAdjust;
                this.pointsData[this.pointCount++] = (float)drawColor.getBlue() * bAdjust;
                continue;
            }
            bAdjust = brightnessAdjustFactor / this.COLOR_DIV;
            drawColor = new Color(vector.color, vector.color, vector.color, 255);
            if (isImager) {
                drawColor = this.vpanel.getColor(vector.color, vector.imagerColorLeft, vector.imagerColorRight, drawColor);
            }
            if (this.config.vectrexColorMode) {
                drawColor = this.getColorVectrexColor(vector.color);
            }
            if (this.config.JOGLuseSpillShader) {
                bAdjust = (float)((double)bAdjust / this.config.JOGLInitialSpillDivisor);
            }
            speed = vector.speed;
            if (vector.speed >= 128) {
                speed = 0.0f;
            }
            speedFactor = this.SPEED_FACTOR_MAX - this.config.JOGL_speedMaxReduce * (speed / 127.0f);
            this.linesData[this.lineCount++] = Scaler.scaleFloatToFloat(vector.x0 - this.config.ALG_MAX_X / 2, this.scaleWidthGL);
            this.linesData[this.lineCount++] = Scaler.scaleFloatToFloat(-(vector.y0 - this.config.ALG_MAX_Y / 2), this.scaleHeightGL);
            this.linesData[this.lineCount++] = (float)drawColor.getRed() * (bAdjust *= speedFactor);
            this.linesData[this.lineCount++] = (float)drawColor.getGreen() * bAdjust;
            this.linesData[this.lineCount++] = (float)drawColor.getBlue() * bAdjust;
            this.linesData[this.lineCount++] = Scaler.scaleFloatToFloat(vector.x1 - this.config.ALG_MAX_X / 2, this.scaleWidthGL);
            this.linesData[this.lineCount++] = Scaler.scaleFloatToFloat(-(vector.y1 - this.config.ALG_MAX_Y / 2), this.scaleHeightGL);
            this.linesData[this.lineCount++] = (float)drawColor.getRed() * bAdjust;
            this.linesData[this.lineCount++] = (float)drawColor.getGreen() * bAdjust;
            this.linesData[this.lineCount++] = (float)drawColor.getBlue() * bAdjust;
            if (!this.config.vectorsAsArrows) continue;
            dx = vector.x1 - vector.x0;
            dy = vector.y1 - vector.y0;
            angle = (float)Math.atan2(dy, dx);
            len = (int)Math.sqrt(dx * dx + dy * dy);
            arrowHeadBoxSize = 200;
            unitDx = dx / (float)len;
            unitDy = dy / (float)len;
            arrowX1 = (float)vector.x1 - unitDx * (float)arrowHeadBoxSize - unitDy * (float)arrowHeadBoxSize;
            arrowY1 = (float)vector.y1 - unitDy * (float)arrowHeadBoxSize + unitDx * (float)arrowHeadBoxSize;
            arrowX2 = (float)vector.x1 - unitDx * (float)arrowHeadBoxSize + unitDy * (float)arrowHeadBoxSize;
            arrowY2 = (float)vector.y1 - unitDy * (float)arrowHeadBoxSize - unitDx * (float)arrowHeadBoxSize;
            this.linesData[this.lineCount++] = Scaler.scaleFloatToFloat(vector.x1 - this.config.ALG_MAX_X / 2, this.scaleWidthGL);
            this.linesData[this.lineCount++] = Scaler.scaleFloatToFloat(-(vector.y1 - this.config.ALG_MAX_Y / 2), this.scaleHeightGL);
            this.linesData[this.lineCount++] = (float)drawColor.getRed() * bAdjust;
            this.linesData[this.lineCount++] = (float)drawColor.getGreen() * bAdjust;
            this.linesData[this.lineCount++] = (float)drawColor.getBlue() * bAdjust;
            this.linesData[this.lineCount++] = Scaler.scaleFloatToFloat(arrowX1 - (float)(this.config.ALG_MAX_X / 2), this.scaleWidthGL);
            this.linesData[this.lineCount++] = Scaler.scaleFloatToFloat(-(arrowY1 - (float)(this.config.ALG_MAX_Y / 2)), this.scaleHeightGL);
            this.linesData[this.lineCount++] = (float)drawColor.getRed() * bAdjust;
            this.linesData[this.lineCount++] = (float)drawColor.getGreen() * bAdjust;
            this.linesData[this.lineCount++] = (float)drawColor.getBlue() * bAdjust;
            this.linesData[this.lineCount++] = Scaler.scaleFloatToFloat(vector.x1 - this.config.ALG_MAX_X / 2, this.scaleWidthGL);
            this.linesData[this.lineCount++] = Scaler.scaleFloatToFloat(-(vector.y1 - this.config.ALG_MAX_Y / 2), this.scaleHeightGL);
            this.linesData[this.lineCount++] = (float)drawColor.getRed() * bAdjust;
            this.linesData[this.lineCount++] = (float)drawColor.getGreen() * bAdjust;
            this.linesData[this.lineCount++] = (float)drawColor.getBlue() * bAdjust;
            this.linesData[this.lineCount++] = Scaler.scaleFloatToFloat(arrowX2 - (float)(this.config.ALG_MAX_X / 2), this.scaleWidthGL);
            this.linesData[this.lineCount++] = Scaler.scaleFloatToFloat(-(arrowY2 - (float)(this.config.ALG_MAX_Y / 2)), this.scaleHeightGL);
            this.linesData[this.lineCount++] = (float)drawColor.getRed() * bAdjust;
            this.linesData[this.lineCount++] = (float)drawColor.getGreen() * bAdjust;
            this.linesData[this.lineCount++] = (float)drawColor.getBlue() * bAdjust;
        }
    }

    Color getColorVectrexColor(int intensity) {
        return this.vectrexColorData[intensity];
    }

    private void renderLineStrips(GL2 gl2) {
        if (this.splineCount == 0) {
            return;
        }
        gl2.glUseProgram(this.programId);
        for (int i = 0; i < this.splineCount; ++i) {
            gl2.glBindBuffer(34962, this.lineStrips[i].lineStripBufferObject.get(0));
            gl2.glBufferData(34962, (long)(this.lineStrips[i].dataCount * 4), (Buffer)this.lineStrips[i].lineStripDataBuffer, 35044);
            gl2.glEnableVertexAttribArray(this.positionAttribute);
            gl2.glEnableVertexAttribArray(this.colorAttribute);
            gl2.glVertexAttribPointer(this.positionAttribute, 2, 5126, false, 20, 0L);
            gl2.glVertexAttribPointer(this.colorAttribute, 3, 5126, false, 20, 8L);
            gl2.glDrawArrays(3, 0, this.lineStrips[i].lineCount);
        }
        gl2.glDisableVertexAttribArray(this.positionAttribute);
        gl2.glDisableVertexAttribArray(this.colorAttribute);
        gl2.glUseProgram(0);
    }

    private void renderPoints(GL2 gl2) {
        if (this.pointCount == 0) {
            return;
        }
        gl2.glBindBuffer(34962, this.vertexBufferObject.get(0));
        gl2.glBufferData(34962, (long)(this.pointCount * 4), (Buffer)this.pointsDataBuffer, 35044);
        gl2.glUseProgram(this.programId);
        gl2.glEnableVertexAttribArray(this.positionAttribute);
        gl2.glEnableVertexAttribArray(this.colorAttribute);
        gl2.glVertexAttribPointer(this.positionAttribute, 2, 5126, false, 20, 0L);
        gl2.glVertexAttribPointer(this.colorAttribute, 3, 5126, false, 20, 8L);
        gl2.glDrawArrays(0, 0, this.pointCount / 5);
        gl2.glDisableVertexAttribArray(this.positionAttribute);
        gl2.glDisableVertexAttribArray(this.colorAttribute);
        gl2.glUseProgram(0);
    }

    private void renderLines(GL2 gl2) {
        if (this.lineCount == 0) {
            return;
        }
        gl2.glBindBuffer(34962, this.lineBufferObject.get(0));
        gl2.glBufferData(34962, (long)(this.lineCount * 4), (Buffer)this.linesDataBuffer, 35044);
        gl2.glUseProgram(this.programId);
        gl2.glEnableVertexAttribArray(this.positionAttribute);
        gl2.glEnableVertexAttribArray(this.colorAttribute);
        gl2.glVertexAttribPointer(this.positionAttribute, 2, 5126, false, 20, 0L);
        gl2.glVertexAttribPointer(this.colorAttribute, 3, 5126, false, 20, 8L);
        gl2.glDrawArrays(1, 0, 2 * (this.lineCount / 10));
        gl2.glDisableVertexAttribArray(this.positionAttribute);
        gl2.glDisableVertexAttribArray(this.colorAttribute);
        gl2.glUseProgram(0);
    }

    private void renderOverlay(GL2 gl2) {
        if (this.config.overlayEnabled && !this.overlayInitialized) {
            this.initOverlay(gl2);
            if (!this.overlayInitialized) {
                return;
            }
        } else if (!this.config.overlayEnabled) {
            if (this.overlayInitialized) {
                this.deinitOverlayTexture();
            }
            return;
        }
        gl2.glEnable(3042);
        gl2.glBlendFunc(770, 771);
        gl2.glLoadIdentity();
        gl2.glEnable(3553);
        gl2.glActiveTexture(33985);
        gl2.glBindTexture(3553, this.lineFBO[0].texture.get(0));
        if (this.config.JOGLOverlayAdjustment) {
            gl2.glUseProgram(this.overlayProgramId);
            gl2.glActiveTexture(33984);
            int i = gl2.glGetUniformLocation(this.overlayProgramId, "overlayTexture");
            gl2.glUniform1i(i, 0);
            i = gl2.glGetUniformLocation(this.overlayProgramId, "destinationTexture");
            gl2.glUniform1i(i, 1);
            i = gl2.glGetUniformLocation(this.overlayProgramId, "alphaThreshold");
            gl2.glUniform1f(i, this.config.JOGLOverlayAlphaThreshold);
            i = gl2.glGetUniformLocation(this.overlayProgramId, "overlayAlphaAdjust");
            gl2.glUniform1f(i, this.config.JOGLOverlayAlphaAdjustmentFactor);
            i = gl2.glGetUniformLocation(this.overlayProgramId, "destinationAlphaAdjust");
            gl2.glUniform1f(i, this.config.JOGLOverlayBrightnessAlphaAdjustmentFactor);
        }
        gl2.glActiveTexture(33984);
        gl2.glBindTexture(3553, this.overlayTextureObject.get(0));
        gl2.glBindFramebuffer(36160, this.lineFBO[0].fbo.get(0));
        gl2.glBegin(7);
        float y1 = this.overlayMustFlip ? 1.0f : -1.0f;
        float y2 = 1.0f - y1;
        y2 = y1 == 1.0f ? -1.0f : 1.0f;
        gl2.glTexCoord2f(0.0f, 0.0f);
        gl2.glVertex2f(-1.0f, y1);
        gl2.glTexCoord2f(1.0f, 0.0f);
        gl2.glVertex2f(1.0f, y1);
        gl2.glTexCoord2f(1.0f, 1.0f);
        gl2.glVertex2f(1.0f, y2);
        gl2.glTexCoord2f(0.0f, 1.0f);
        gl2.glVertex2f(-1.0f, y2);
        gl2.glEnd();
        gl2.glBindTexture(3553, 0);
        gl2.glBindFramebuffer(36160, 0);
        gl2.glUseProgram(0);
        gl2.glBlendFunc(770, 1);
        gl2.glDisable(3042);
    }

    private void setupRender(GL2 gl2) {
        gl2.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        gl2.glLineWidth((float)this.config.lineWidth);
        gl2.glPointSize((float)this.config.lineWidth);
        gl2.glDisable(2929);
        gl2.glEnable(3553);
        if (!this.config.JOGLMSAA) {
            if (this.config.antialiazing) {
                gl2.glEnable(3042);
                gl2.glBlendFunc(770, 771);
                gl2.glEnable(2881);
                gl2.glHint(3155, 4354);
                gl2.glEnable(2848);
                gl2.glHint(3154, 4354);
            } else {
                gl2.glDisable(3024);
                gl2.glDisable(3042);
                gl2.glHint(3155, 4353);
                gl2.glDisable(2881);
                gl2.glHint(3154, 4353);
                gl2.glDisable(2848);
                gl2.glHint(3153, 4353);
                gl2.glDisable(2832);
            }
        } else {
            gl2.glDisable(32925);
            gl2.glDisable(3024);
            gl2.glDisable(3042);
            gl2.glHint(3155, 4353);
            gl2.glDisable(2881);
            gl2.glHint(3154, 4353);
            gl2.glDisable(2848);
            gl2.glHint(3153, 4353);
            gl2.glDisable(2832);
        }
    }

    protected synchronized void render(GLAutoDrawable glautodrawable, int width, int height) {
        if (this.vpanel.getVecXState() == null) {
            return;
        }
        GL2 gl2 = glautodrawable.getGL().getGL2();
        this.setupRender(gl2);
        gl2.glClear(16640);
        this.prepareData();
        this.preDataRender(gl2);
        this.renderPoints(gl2);
        this.renderLineStrips(gl2);
        this.renderLines(gl2);
        this.postDataRender(gl2);
        this.renderChassis(gl2);
        this.renderOverlay(gl2);
        this.renderDebug(gl2);
        gl2.glPushMatrix();
        gl2.glRotatef((float)this.config.rotate, 0.0f, 0.0f, 1.0f);
        gl2.glBindFramebuffer(36160, 0);
        gl2.glBindTexture(3553, this.lineFBO[0].texture.get(0));
        gl2.glBegin(7);
        float y1 = -1.0f;
        float y2 = 1.0f;
        gl2.glTexCoord2f(0.0f, 0.0f);
        gl2.glVertex2f(-1.0f, y1);
        gl2.glTexCoord2f(1.0f, 0.0f);
        gl2.glVertex2f(1.0f, y1);
        gl2.glTexCoord2f(1.0f, 1.0f);
        gl2.glVertex2f(1.0f, y2);
        gl2.glTexCoord2f(0.0f, 1.0f);
        gl2.glVertex2f(-1.0f, y2);
        gl2.glEnd();
        gl2.glBindTexture(3553, 0);
        gl2.glPopMatrix();
        if (this.splineCount >= this.MAX_LINE_STRIPS) {
            while (this.splineCount >= this.MAX_LINE_STRIPS) {
                this.MAX_LINE_STRIPS *= 2;
            }
            this.initLineStrips(this.MAX_LINE_STRIPS, gl2);
        }
    }

    void preDataRender(GL2 gl2) {
        gl2.glBindFramebuffer(36160, this.lineFBO[0].fbo.get(0));
        gl2.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        gl2.glClear(16384);
        if (this.config.JOGLMSAA && JOGLSupport.getVersion() >= 210 && this.config.antialiazing) {
            gl2.glEnable(32925);
            gl2.glBindFramebuffer(36160, this.fboMSAABufferObject.get(0));
            gl2.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
            gl2.glClear(16384);
            if (!JOGLSupport.checkError(gl2, "preDataRender()")) {
                return;
            }
        }
        gl2.glEnable(3042);
        gl2.glBlendFunc(1, 1);
    }

    void postDataRender(GL2 gl2) {
        gl2.glDisable(3042);
        if (this.config.JOGLMSAA && JOGLSupport.getVersion() >= 210 && this.config.antialiazing) {
            gl2.glDisable(32925);
            gl2.glBindFramebuffer(36009, this.lineFBO[0].fbo.get(0));
            gl2.glBindFramebuffer(36008, this.fboMSAABufferObject.get(0));
            gl2.glBlitFramebuffer(0, 0, this.gl2Width, this.gl2Height, 0, 0, this.gl2Width, this.gl2Height, 16384, 9728);
            if (!JOGLSupport.checkError(gl2, "postDataRender(): 1")) {
                return;
            }
        }
        gl2.glBindFramebuffer(36009, 0);
        this.processSpill(gl2);
        this.processGlow(gl2);
        if (this.config.emulateBorders) {
            this.processBorderGlow(gl2);
        }
        if (this.config.persistenceAlpha != 255) {
            gl2.glEnable(3042);
            gl2.glBlendEquation(32776);
            gl2.glBlendFunc(1, 1);
            gl2.glBindFramebuffer(36009, this.lineFBO[0].fbo.get(0));
            gl2.glBindTexture(3553, this.lineFBO[3].texture.get(0));
            gl2.glBegin(7);
            gl2.glTexCoord2f(0.0f, 0.0f);
            gl2.glVertex2f(-1.0f, -1.0f);
            gl2.glTexCoord2f(1.0f, 0.0f);
            gl2.glVertex2f(1.0f, -1.0f);
            gl2.glTexCoord2f(1.0f, 1.0f);
            gl2.glVertex2f(1.0f, 1.0f);
            gl2.glTexCoord2f(0.0f, 1.0f);
            gl2.glVertex2f(-1.0f, 1.0f);
            gl2.glEnd();
            gl2.glBindTexture(3553, 0);
            gl2.glBlendEquation(32774);
            gl2.glDisable(3042);
            gl2.glBindFramebuffer(36160, this.lineFBO[3].fbo.get(0));
            gl2.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
            gl2.glClear(16384);
            gl2.glActiveTexture(33984);
            gl2.glBindTexture(3553, this.lineFBO[0].texture.get(0));
            gl2.glUseProgram(this.persitencyProgramId);
            int i = gl2.glGetUniformLocation(this.persitencyProgramId, "colorReduce");
            gl2.glUniform1f(i, 0.003921569f * (float)(255 - this.config.persistenceAlpha));
            int uit = gl2.glGetUniformLocation(this.persitencyProgramId, "uTexture");
            gl2.glUniform1i(uit, 0);
            float y1 = -1.0f;
            float y2 = 1.0f;
            gl2.glBegin(7);
            gl2.glTexCoord2f(0.0f, 0.0f);
            gl2.glVertex2f(-1.0f, y1);
            gl2.glTexCoord2f(1.0f, 0.0f);
            gl2.glVertex2f(1.0f, y1);
            gl2.glTexCoord2f(1.0f, 1.0f);
            gl2.glVertex2f(1.0f, y2);
            gl2.glTexCoord2f(0.0f, 1.0f);
            gl2.glVertex2f(-1.0f, y2);
            gl2.glEnd();
            gl2.glBindTexture(3553, 0);
            gl2.glUseProgram(0);
            gl2.glBindFramebuffer(36160, 0);
        }
        if (!JOGLSupport.checkError(gl2, "postDataRender(): 2")) {
            return;
        }
    }

    private synchronized void paintVectrex() {
        this.repaint();
    }

    void processGlow(GL2 gl2) {
        if (!this.config.JOGLuseGlowShader) {
            return;
        }
        if (this.config.JOGLaddBase) {
            gl2.glBindFramebuffer(36160, this.lineFBO[2].fbo.get(0));
            gl2.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
            gl2.glClear(16384);
            gl2.glBindFramebuffer(36009, this.lineFBO[2].fbo.get(0));
            gl2.glBindFramebuffer(36008, this.lineFBO[0].fbo.get(0));
            gl2.glBlitFramebuffer(0, 0, this.gl2Width, this.gl2Height, 0, 0, this.gl2Width, this.gl2Height, 16384, 9728);
            gl2.glBindFramebuffer(36160, 0);
        }
        if (this.config.JOGLGlowThreshold != 0.0) {
            gl2.glUseProgram(this.thresholdProgramId);
            int i = gl2.glGetUniformLocation(this.thresholdProgramId, "threshold");
            gl2.glUniform1f(i, (float)this.config.JOGLGlowThreshold);
            gl2.glActiveTexture(33984);
            i = gl2.glGetUniformLocation(this.blurProgramId, "uTexture");
            gl2.glUniform1i(i, 0);
            gl2.glBindFramebuffer(36160, this.lineFBO[1].fbo.get(0));
            gl2.glBindTexture(3553, this.lineFBO[0].texture.get(0));
            float y1 = -1.0f;
            float y2 = 1.0f;
            gl2.glBegin(7);
            gl2.glTexCoord2f(0.0f, 0.0f);
            gl2.glVertex2f(-1.0f, y1);
            gl2.glTexCoord2f(1.0f, 0.0f);
            gl2.glVertex2f(1.0f, y1);
            gl2.glTexCoord2f(1.0f, 1.0f);
            gl2.glVertex2f(1.0f, y2);
            gl2.glTexCoord2f(0.0f, 1.0f);
            gl2.glVertex2f(-1.0f, y2);
            gl2.glEnd();
            gl2.glBindTexture(3553, 0);
            gl2.glUseProgram(0);
            if (!JOGLSupport.checkError(gl2, "processGlow(): 1")) {
                return;
            }
            gl2.glBindFramebuffer(36160, this.lineFBO[0].fbo.get(0));
            gl2.glBindTexture(3553, this.lineFBO[1].texture.get(0));
            gl2.glBegin(7);
            gl2.glTexCoord2f(0.0f, 0.0f);
            gl2.glVertex2f(-1.0f, y1);
            gl2.glTexCoord2f(1.0f, 0.0f);
            gl2.glVertex2f(1.0f, y1);
            gl2.glTexCoord2f(1.0f, 1.0f);
            gl2.glVertex2f(1.0f, y2);
            gl2.glTexCoord2f(0.0f, 1.0f);
            gl2.glVertex2f(-1.0f, y2);
            gl2.glEnd();
            gl2.glBindTexture(3553, 0);
        }
        if (this.config.JOGLadditiveBlur) {
            gl2.glEnable(3042);
            gl2.glBlendFunc(1, 1);
        }
        if (this.doDeinitBlurShaders) {
            this.initBlurShader(gl2, Global.mainPathPrefix + "theme/shaders/blurShader.vs", Global.mainPathPrefix + "theme/shaders/blurShader.fs");
            this.doDeinitBlurShaders = false;
        }
        if (this.config.JOGLMIP_RESOLUTION != 0) {
            this.doScaledBlur(gl2);
            return;
        }
        gl2.glBindFramebuffer(36160, this.lineFBO[1].fbo.get(0));
        gl2.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        gl2.glClear(16384);
        gl2.glActiveTexture(33984);
        gl2.glUseProgram(this.blurProgramId);
        if (!JOGLSupport.checkError(gl2, "processGlow(): 2")) {
            return;
        }
        for (int bp = 0; bp < this.config.JOGLblurPass; ++bp) {
            gl2.glBindFramebuffer(36160, this.lineFBO[1].fbo.get(0));
            int i = gl2.glGetUniformLocation(this.blurProgramId, "uShift");
            gl2.glUniform2f(i, 1.0f / (float)this.gl2Width, 0.0f);
            i = gl2.glGetUniformLocation(this.blurProgramId, "uTexture");
            gl2.glUniform1i(i, 0);
            gl2.glBindTexture(3553, this.lineFBO[0].texture.get(0));
            float y1 = -1.0f;
            float y2 = 1.0f;
            gl2.glBegin(7);
            gl2.glTexCoord2f(0.0f, 0.0f);
            gl2.glVertex2f(-1.0f, y1);
            gl2.glTexCoord2f(1.0f, 0.0f);
            gl2.glVertex2f(1.0f, y1);
            gl2.glTexCoord2f(1.0f, 1.0f);
            gl2.glVertex2f(1.0f, y2);
            gl2.glTexCoord2f(0.0f, 1.0f);
            gl2.glVertex2f(-1.0f, y2);
            gl2.glEnd();
            gl2.glBindTexture(3553, 0);
            if (!JOGLSupport.checkError(gl2, "processGlow(): 3")) {
                return;
            }
            gl2.glBindFramebuffer(36160, this.lineFBO[0].fbo.get(0));
            i = gl2.glGetUniformLocation(this.blurProgramId, "uShift");
            gl2.glUniform2f(i, 0.0f, 1.0f / (float)this.gl2Height);
            i = gl2.glGetUniformLocation(this.blurProgramId, "uTexture");
            gl2.glUniform1i(i, 0);
            gl2.glBindTexture(3553, this.lineFBO[1].texture.get(0));
            gl2.glBegin(7);
            y1 = -1.0f;
            y2 = 1.0f;
            gl2.glTexCoord2f(0.0f, 0.0f);
            gl2.glVertex2f(-1.0f, y1);
            gl2.glTexCoord2f(1.0f, 0.0f);
            gl2.glVertex2f(1.0f, y1);
            gl2.glTexCoord2f(1.0f, 1.0f);
            gl2.glVertex2f(1.0f, y2);
            gl2.glTexCoord2f(0.0f, 1.0f);
            gl2.glVertex2f(-1.0f, y2);
            gl2.glEnd();
            gl2.glBindTexture(3553, 0);
            gl2.glBindFramebuffer(36160, 0);
        }
        if (!JOGLSupport.checkError(gl2, "processGlow(): 4")) {
            return;
        }
        gl2.glUseProgram(0);
        if (this.config.JOGLaddBase) {
            gl2.glEnable(3042);
            gl2.glBlendFunc(1, 1);
            gl2.glBindFramebuffer(36160, this.lineFBO[0].fbo.get(0));
            gl2.glBindTexture(3553, this.lineFBO[2].texture.get(0));
            gl2.glBegin(7);
            gl2.glTexCoord2f(0.0f, 0.0f);
            gl2.glVertex2f(-1.0f, -1.0f);
            gl2.glTexCoord2f(1.0f, 0.0f);
            gl2.glVertex2f(1.0f, -1.0f);
            gl2.glTexCoord2f(1.0f, 1.0f);
            gl2.glVertex2f(1.0f, 1.0f);
            gl2.glTexCoord2f(0.0f, 1.0f);
            gl2.glVertex2f(-1.0f, 1.0f);
            gl2.glEnd();
            gl2.glBindTexture(3553, 0);
            gl2.glBindFramebuffer(36160, 0);
        }
        gl2.glDisable(3042);
    }

    void deinitBlurShaders() {
        if (this.auddr != null && this.auddr.getGL() != null) {
            GL2 gl2 = this.auddr.getGL().getGL2();
            if (this.blurProgramId != -1) {
                gl2.glDetachShader(this.blurProgramId, this.blurVertexShaderId);
                gl2.glDetachShader(this.blurProgramId, this.blurFragmentShaderId);
                gl2.glDeleteProgram(this.blurProgramId);
            }
        }
        this.blurShadersInitialized = false;
        this.blurProgramId = -1;
    }

    boolean initBlurShader(GL2 gl2, String vertexShaderFile, String fragmentShaderFile) {
        try {
            this.deinitBlurShaders();
            String vertexShaderCode = UtilityString.readTextFileToOneString(new File(UtilityFiles.convertSeperator(vertexShaderFile)));
            String fragmentShaderCode_org = VecxiPanel_JOGL.buildBlurFragmentShader_org(VecxiPanel_JOGL.createGaussianKernel_org(this.config.JOGL_GAUSS_RADIUS, this.config.JOGL_SIGMA));
            String fragmentShaderCode = VecxiPanel_JOGL.buildBlurFragmentShader_lin(VecxiPanel_JOGL.createGaussianKernel_linWeight(this.config.JOGL_GAUSS_RADIUS, this.config.JOGL_SIGMA), VecxiPanel_JOGL.createGaussianKernel_linOffset(this.config.JOGL_GAUSS_RADIUS, this.config.JOGL_SIGMA));
            if (!this.config.JOGLUseLinearSampling) {
                fragmentShaderCode = fragmentShaderCode_org;
            }
            this.blurProgramId = gl2.glCreateProgram();
            this.blurVertexShaderId = JOGLSupport.createShader(gl2, this.blurProgramId, vertexShaderCode, 35633);
            this.blurFragmentShaderId = JOGLSupport.createShader(gl2, this.blurProgramId, fragmentShaderCode, 35632);
            JOGLSupport.link(gl2, this.blurProgramId);
            this.blurPositionAttribute = gl2.glGetAttribLocation(this.blurProgramId, "Position");
            this.blurColorAttribute = gl2.glGetAttribLocation(this.blurProgramId, "Color");
            this.blurTextureAttribute = gl2.glGetAttribLocation(this.blurProgramId, "TexCoord");
            if (!JOGLSupport.checkError(gl2, "initBlurShader()")) {
                return false;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            return false;
        }
        this.blurShadersInitialized = true;
        return true;
    }

    public static final float[] createGaussianKernel_org(int steps, double sigma) {
        float[] kernel = new float[steps * 2 + 1];
        double f1 = 1.0 / Math.sqrt(Math.PI * 2 * sigma * sigma);
        for (int i = 0; i < steps + 1; ++i) {
            double x2 = i * i;
            double s2 = 2.0 * sigma * sigma;
            double ex = -x2 / s2;
            double f2 = Math.exp(ex);
            double result = f1 * f2;
            kernel[steps - i] = (float)result;
            kernel[steps + i] = (float)result;
        }
        return kernel;
    }

    static String buildBlurFragmentShader_org(float[] kernalData) {
        int steps = kernalData.length;
        StringBuilder b = new StringBuilder();
        b.append("#version 120").append("\n");
        b.append("uniform sampler2D uTexture;").append("\n");
        b.append("uniform vec2 uShift;").append("\n");
        b.append("const int gaussRadius = " + steps + ";").append("\n");
        b.append("void main() ").append("\n");
        b.append("{").append("\n");
        b.append("vec2 texCoord = gl_TexCoord[0].xy - float(int(gaussRadius/2)) * uShift;").append("\n");
        b.append("vec3 color = vec3(0.0, 0.0, 0.0);").append("\n");
        for (int i = 0; i < steps; ++i) {
            b.append("color += " + kernalData[i] + " * texture2D(uTexture, texCoord).xyz;").append("\n");
            b.append("texCoord += uShift;").append("\n");
        }
        b.append("gl_FragColor = vec4(color,1.0);").append("\n");
        b.append("}").append("\n");
        return b.toString();
    }

    public static final float[] createGaussianKernel_linWeight(int steps, double sigma) {
        float[] kernel_org = VecxiPanel_JOGL.createGaussianKernel_org(steps, sigma);
        boolean even = steps % 2 == 0;
        float[] weight = new float[even ? steps / 2 + 1 : steps / 2 + 1];
        int c = 0;
        int start = steps;
        int end2 = steps * 2;
        if (even) {
            weight[c++] = kernel_org[steps];
            ++start;
        }
        for (int i = start; i < end2; i += 2) {
            weight[c++] = kernel_org[i] + kernel_org[i + 1];
        }
        return weight;
    }

    public static final float[] createGaussianKernel_linOffset(int steps, double sigma) {
        float[] kernel_org = VecxiPanel_JOGL.createGaussianKernel_org(steps, sigma);
        float[] weights = VecxiPanel_JOGL.createGaussianKernel_linWeight(steps, sigma);
        boolean even = steps % 2 == 0;
        float[] offsets = new float[even ? steps / 2 + 1 : steps / 2 + 1];
        offsets[0] = 0.0f;
        int c = 0;
        int end2 = steps * 2;
        int start = steps;
        if (even) {
            offsets[c++] = 0.0f;
            ++start;
        }
        for (int i = start; i < end2; i += 2) {
            int w = i - start;
            if (even) {
                ++w;
            }
            offsets[c] = ((float)w * kernel_org[i] + (float)(w + 1) * kernel_org[i + 1]) / weights[c];
            if (Float.isNaN(offsets[c])) {
                offsets[c] = (w + w + 1) / 2;
            }
            ++c;
        }
        return offsets;
    }

    static String buildBlurFragmentShader_lin(float[] kernalWeightData, float[] kernalOffsetData) {
        int i;
        int steps = kernalWeightData.length;
        StringBuilder b = new StringBuilder();
        b.append("#version 120").append("\n");
        b.append("uniform sampler2D uTexture;").append("\n");
        b.append("uniform vec2 uShift;").append("\n");
        b.append("const int gaussRadius = " + steps + ";").append("\n");
        b.append("void main() ").append("\n");
        b.append("{").append("\n");
        b.append("vec2 centreUV = gl_TexCoord[0].xy;").append("\n");
        b.append("float gOffsets[" + kernalOffsetData.length + "];").append("\n");
        b.append("float gWeights[" + kernalWeightData.length + "];").append("\n");
        for (i = 0; i < steps; ++i) {
            b.append("gOffsets[" + i + "] = " + kernalOffsetData[i] + ";").append("\n");
        }
        for (i = 0; i < steps; ++i) {
            b.append("gWeights[" + i + "] = " + kernalWeightData[i] + ";").append("\n");
        }
        b.append("vec2 texCoordOffset;\n");
        b.append("vec3 col;\n");
        b.append("vec3 color = vec3(0.0, 0.0, 0.0);\n");
        for (i = 0; i < steps; ++i) {
            b.append("texCoordOffset = gOffsets[" + i + "] * uShift;\n");
            b.append("col = texture2D(uTexture, centreUV + texCoordOffset).xyz + texture2D(uTexture, centreUV - texCoordOffset).xyz;").append("\n");
            b.append("color += gWeights[" + i + "] * col;").append("\n");
        }
        b.append("gl_FragColor = vec4(color,1.0);").append("\n");
        b.append("}").append("\n");
        return b.toString();
    }

    void processSpill(GL2 gl2) {
        int i;
        if (!this.config.JOGLuseSpillShader) {
            return;
        }
        if (this.config.JOGLSpillAddBase) {
            gl2.glBindFramebuffer(36160, this.lineFBO[2].fbo.get(0));
            gl2.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
            gl2.glClear(16384);
            if (this.config.JOGLSpillUnfactordAddBase) {
                gl2.glBindFramebuffer(36009, this.lineFBO[2].fbo.get(0));
                gl2.glBindFramebuffer(36008, this.lineFBO[0].fbo.get(0));
                gl2.glBlitFramebuffer(0, 0, this.gl2Width, this.gl2Height, 0, 0, this.gl2Width, this.gl2Height, 16384, 9728);
            } else {
                gl2.glUseProgram(this.spillFinalProgramId);
                gl2.glActiveTexture(33984);
                i = gl2.glGetUniformLocation(this.spillFinalProgramId, "uTexture");
                gl2.glUniform1i(i, 0);
                i = gl2.glGetUniformLocation(this.spillFinalProgramId, "factor");
                gl2.glUniform1f(i, (float)this.config.JOGLInitialSpillDivisor);
                gl2.glBindFramebuffer(36160, this.lineFBO[2].fbo.get(0));
                gl2.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
                gl2.glClear(16384);
                gl2.glBindTexture(3553, this.lineFBO[0].texture.get(0));
                gl2.glBegin(7);
                gl2.glTexCoord2f(0.0f, 0.0f);
                gl2.glVertex2f(-1.0f, -1.0f);
                gl2.glTexCoord2f(1.0f, 0.0f);
                gl2.glVertex2f(1.0f, -1.0f);
                gl2.glTexCoord2f(1.0f, 1.0f);
                gl2.glVertex2f(1.0f, 1.0f);
                gl2.glTexCoord2f(0.0f, 1.0f);
                gl2.glVertex2f(-1.0f, 1.0f);
                gl2.glEnd();
                gl2.glBindTexture(3553, 0);
                gl2.glBindFramebuffer(36160, 0);
                gl2.glUseProgram(0);
            }
            gl2.glBindFramebuffer(36160, 0);
        }
        gl2.glActiveTexture(33984);
        gl2.glUseProgram(this.spillProgramId);
        if (!JOGLSupport.checkError(gl2, "processSpill():1")) {
            return;
        }
        for (int bp = 0; bp < this.config.JOGLSpillPass; ++bp) {
            gl2.glBindFramebuffer(36160, this.lineFBO[1].fbo.get(0));
            gl2.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
            gl2.glClear(16384);
            int i2 = gl2.glGetUniformLocation(this.spillProgramId, "uShift");
            gl2.glUniform2f(i2, 1.0f / (float)this.gl2Width, 1.0f / (float)this.gl2Height);
            i2 = gl2.glGetUniformLocation(this.spillProgramId, "uTexture");
            gl2.glUniform1i(i2, 0);
            i2 = gl2.glGetUniformLocation(this.spillProgramId, "spillThreshold");
            gl2.glUniform1f(i2, (float)this.config.JOGLSpillThreshold);
            gl2.glBindTexture(3553, this.lineFBO[0].texture.get(0));
            float y1 = -1.0f;
            float y2 = 1.0f;
            gl2.glBegin(7);
            gl2.glTexCoord2f(0.0f, 0.0f);
            gl2.glVertex2f(-1.0f, y1);
            gl2.glTexCoord2f(1.0f, 0.0f);
            gl2.glVertex2f(1.0f, y1);
            gl2.glTexCoord2f(1.0f, 1.0f);
            gl2.glVertex2f(1.0f, y2);
            gl2.glTexCoord2f(0.0f, 1.0f);
            gl2.glVertex2f(-1.0f, y2);
            gl2.glEnd();
            gl2.glBindTexture(3553, 0);
            if (!JOGLSupport.checkError(gl2, "processSpill():2")) {
                return;
            }
            gl2.glBindFramebuffer(36160, this.lineFBO[0].fbo.get(0));
            gl2.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
            gl2.glClear(16384);
            i2 = gl2.glGetUniformLocation(this.spillProgramId, "uShift");
            gl2.glUniform2f(i2, 1.0f / (float)this.gl2Width, 1.0f / (float)this.gl2Height);
            i2 = gl2.glGetUniformLocation(this.spillProgramId, "uTexture");
            gl2.glUniform1i(i2, 0);
            i2 = gl2.glGetUniformLocation(this.spillProgramId, "spillThreshold");
            gl2.glUniform1f(i2, (float)this.config.JOGLSpillThreshold);
            gl2.glBindTexture(3553, this.lineFBO[1].texture.get(0));
            gl2.glBegin(7);
            y1 = -1.0f;
            y2 = 1.0f;
            gl2.glTexCoord2f(0.0f, 0.0f);
            gl2.glVertex2f(-1.0f, y1);
            gl2.glTexCoord2f(1.0f, 0.0f);
            gl2.glVertex2f(1.0f, y1);
            gl2.glTexCoord2f(1.0f, 1.0f);
            gl2.glVertex2f(1.0f, y2);
            gl2.glTexCoord2f(0.0f, 1.0f);
            gl2.glVertex2f(-1.0f, y2);
            gl2.glEnd();
            gl2.glBindTexture(3553, 0);
            gl2.glBindFramebuffer(36160, 0);
        }
        if (!JOGLSupport.checkError(gl2, "processSpill():3")) {
            return;
        }
        gl2.glUseProgram(this.spillFinalProgramId);
        gl2.glActiveTexture(33984);
        i = gl2.glGetUniformLocation(this.spillFinalProgramId, "uTexture");
        gl2.glUniform1i(i, 0);
        i = gl2.glGetUniformLocation(this.spillFinalProgramId, "factor");
        gl2.glUniform1f(i, (float)this.config.JOGLFinalSpillMultiplyer);
        gl2.glBindFramebuffer(36160, this.lineFBO[1].fbo.get(0));
        gl2.glClear(16384);
        gl2.glBindTexture(3553, this.lineFBO[0].texture.get(0));
        gl2.glBegin(7);
        gl2.glTexCoord2f(0.0f, 0.0f);
        gl2.glVertex2f(-1.0f, -1.0f);
        gl2.glTexCoord2f(1.0f, 0.0f);
        gl2.glVertex2f(1.0f, -1.0f);
        gl2.glTexCoord2f(1.0f, 1.0f);
        gl2.glVertex2f(1.0f, 1.0f);
        gl2.glTexCoord2f(0.0f, 1.0f);
        gl2.glVertex2f(-1.0f, 1.0f);
        gl2.glEnd();
        gl2.glBindTexture(3553, 0);
        gl2.glBindFramebuffer(36160, 0);
        gl2.glUseProgram(0);
        gl2.glBindFramebuffer(36160, this.lineFBO[0].fbo.get(0));
        gl2.glClear(16384);
        gl2.glBindTexture(3553, this.lineFBO[1].texture.get(0));
        gl2.glBegin(7);
        gl2.glTexCoord2f(0.0f, 0.0f);
        gl2.glVertex2f(-1.0f, -1.0f);
        gl2.glTexCoord2f(1.0f, 0.0f);
        gl2.glVertex2f(1.0f, -1.0f);
        gl2.glTexCoord2f(1.0f, 1.0f);
        gl2.glVertex2f(1.0f, 1.0f);
        gl2.glTexCoord2f(0.0f, 1.0f);
        gl2.glVertex2f(-1.0f, 1.0f);
        gl2.glEnd();
        gl2.glUseProgram(0);
        gl2.glBindTexture(3553, 0);
        gl2.glBindFramebuffer(36160, 0);
        if (this.config.JOGLSpillAddBase) {
            gl2.glEnable(3042);
            gl2.glBlendFunc(1, 1);
            gl2.glBindFramebuffer(36160, this.lineFBO[0].fbo.get(0));
            gl2.glBindTexture(3553, this.lineFBO[2].texture.get(0));
            gl2.glBegin(7);
            gl2.glTexCoord2f(0.0f, 0.0f);
            gl2.glVertex2f(-1.0f, -1.0f);
            gl2.glTexCoord2f(1.0f, 0.0f);
            gl2.glVertex2f(1.0f, -1.0f);
            gl2.glTexCoord2f(1.0f, 1.0f);
            gl2.glVertex2f(1.0f, 1.0f);
            gl2.glTexCoord2f(0.0f, 1.0f);
            gl2.glVertex2f(-1.0f, 1.0f);
            gl2.glEnd();
            gl2.glBindTexture(3553, 0);
            gl2.glBindFramebuffer(36160, 0);
        }
        gl2.glDisable(3042);
    }

    void drawCircle(GL2 gl2, float cx, float cy, float r, int num_segments) {
        float theta = (float)Math.PI * 2 / (float)num_segments;
        float tangetial_factor = (float)Math.tan(theta);
        float radial_factor = (float)Math.cos(theta);
        float x = r;
        float y = 0.0f;
        gl2.glBegin(2);
        for (int ii = 0; ii < num_segments; ++ii) {
            gl2.glVertex2f(x + cx, y + cy);
            float tx = -y;
            float ty = x;
            x += tx * tangetial_factor;
            y += ty * tangetial_factor;
            x *= radial_factor;
            y *= radial_factor;
        }
        gl2.glEnd();
    }

    private void renderDebug(GL2 gl2) {
        gl2.glBindFramebuffer(36160, this.lineFBO[0].fbo.get(0));
        gl2.glPushAttrib(1);
        if (this.config.paintIntegrators) {
            float xa = Scaler.scaleFloatToFloat((float)this.vpanel.getIntegratorX() - (float)(this.config.ALG_MAX_X / 2), this.scaleWidthGL);
            float ya = Scaler.scaleFloatToFloat(-((float)this.vpanel.getIntegratorY() - (float)(this.config.ALG_MAX_Y / 2)), this.scaleHeightGL);
            float r = Scaler.scaleFloatToFloat(8.0f, 1.0f / (float)this.gl2Width);
            gl2.glColor3f(1.0f, 0.0f, 0.0f);
            this.drawCircle(gl2, xa, ya, r, 8);
        }
        if (this.vpanel.isPausing()) {
            GLUT glut = new GLUT();
            gl2.glColor3f(1.0f, 0.0f, 0.0f);
            gl2.glRasterPos2f(-Scaler.scaleFloatToFloat((float)glut.glutBitmapLength(8, "PAUSE") / 2.0f, 1.0f / (float)this.gl2Width), Scaler.scaleFloatToFloat(this.gl2Height / 3, 1.0f / (float)this.gl2Height));
            glut.glutBitmapString(8, "PAUSE");
        }
        if (this.vpanel.isDebuging()) {
            GLUT glut = new GLUT();
            gl2.glColor3f(0.0f, 1.0f, 0.0f);
            gl2.glRasterPos2f(-Scaler.scaleFloatToFloat((float)glut.glutBitmapLength(8, "Debug") / 2.0f, 1.0f / (float)this.gl2Width), Scaler.scaleFloatToFloat(this.gl2Height / 3, 1.0f / (float)this.gl2Height));
            glut.glutBitmapString(8, "Debug");
        }
        if (this.vpanel.getDeviceList().get(VecXPanel.DEVICE_LIGHTPEN).isActive() && this.config.displayModeWriting) {
            GLUT glut = new GLUT();
            if (this.vpanel.isMousePressed()) {
                gl2.glColor3f(1.0f, 0.5f, 0.0f);
            } else {
                gl2.glColor3f(1.0f, 1.0f, 0.0f);
            }
            gl2.glRasterPos2f(-Scaler.scaleFloatToFloat((float)glut.glutBitmapLength(8, "Lightpen") / 2.0f, 1.0f / (float)this.gl2Width), Scaler.scaleFloatToFloat(this.gl2Height / 3, 1.0f / (float)this.gl2Height));
            glut.glutBitmapString(8, "Lightpen");
        }
        if (this.vpanel.getDeviceList().get(VecXPanel.DEVICE_IMAGER).isActive() && this.config.displayModeWriting) {
            GLUT glut = new GLUT();
            gl2.glColor3f(1.0f, 1.0f, 0.0f);
            gl2.glRasterPos2f(-Scaler.scaleFloatToFloat((float)glut.glutBitmapLength(8, "Goggle") / 2.0f, 1.0f / (float)this.gl2Width), Scaler.scaleFloatToFloat(this.gl2Height / 3, 1.0f / (float)this.gl2Height));
            glut.glutBitmapString(8, "Goggle");
        }
        if (this.vpanel.isMouseMode() && !this.vpanel.isCrossDisabled()) {
            double y1;
            double x1;
            double y0;
            int y;
            int x;
            int width = this.gl2Width;
            int height = this.gl2Height;
            double scaleWidth = (double)width / (double)this.config.ALG_MAX_X;
            double scaleHeight = (double)height / (double)this.config.ALG_MAX_Y;
            double distance = Double.MAX_VALUE;
            if (this.vpanel.getVinfi() != null) {
                x = this.vpanel.getMouseX();
                y = this.vpanel.getMouseY();
                y -= this.topOffset;
                x -= this.leftOffset;
                x = Scaler.unscaleDoubleToInt(x, scaleWidth);
                y = Scaler.unscaleDoubleToInt(y, scaleHeight);
                y -= this.config.ALG_MAX_Y / 2;
                y = -y;
                this.vpanel.getVinfi().setMouseCoordinates(x -= this.config.ALG_MAX_X / 2, y);
            }
            x = this.vpanel.getMouseX();
            y = this.vpanel.getMouseY();
            Color col = this.vpanel.getCrossColor();
            gl2.glColor3f((float)col.getRed() / 255.0f, (float)col.getGreen() / 255.0f, (float)col.getBlue() / 255.0f);
            gl2.glLineWidth(1.0f);
            this.drawLineInScreenCoordinates(gl2, 0.0f, y -= this.topOffset, this.gl2Width, y);
            this.drawLineInScreenCoordinates(gl2, x -= this.leftOffset, 0.0f, x, this.gl2Height);
            VecX.VectrexDisplayVectors vList = this.vpanel.getDisplayList();
            for (int i = 0; i < vList.count; ++i) {
                VecXState.vector_t v = vList.vectrexVectors[i];
                double x0 = v.x0;
                double y02 = v.y0;
                double x12 = v.x1;
                double y12 = v.y1;
                x0 = Scaler.scaleDoubleToInt(x0, scaleWidth);
                y02 = Scaler.scaleDoubleToInt(y02, scaleHeight);
                x12 = Scaler.scaleDoubleToInt(x12, scaleWidth);
                y12 = Scaler.scaleDoubleToInt(y12, scaleHeight);
                double d = SingleVectorPanel.getDistancePointToVector((double)this.vpanel.getMouseX() - (double)this.leftOffset, (double)this.vpanel.getMouseY() - (double)this.topOffset, x0, y02, x12, y12);
                if (d < distance) {
                    distance = d;
                    this.vpanel.setFound(v);
                }
                if (distance == 0.0) break;
            }
            if (this.directDrawVector != null) {
                double x0 = this.directDrawVector.x0;
                y0 = this.directDrawVector.y0;
                x1 = this.directDrawVector.x1;
                y1 = this.directDrawVector.y1;
                x0 = Scaler.scaleDoubleToInt(x0, scaleWidth);
                y0 = Scaler.scaleDoubleToInt(y0, scaleHeight);
                x1 = Scaler.scaleDoubleToInt(x1, scaleWidth);
                y1 = Scaler.scaleDoubleToInt(y1, scaleHeight);
                double d = SingleVectorPanel.getDistancePointToVector(this.vpanel.getMouseX(), this.vpanel.getMouseY(), x0, y0, x1, y1);
                if (d < distance) {
                    distance = d;
                    this.vpanel.setFound(this.directDrawVector);
                }
            }
            if (this.vpanel.getFound() != null && !(distance <= 5.0)) {
                this.vpanel.setFound(null);
            }
            if (this.vpanel.getFound() != null) {
                double x0 = this.vpanel.getFound().x0;
                y0 = this.vpanel.getFound().y0;
                x1 = this.vpanel.getFound().x1;
                y1 = this.vpanel.getFound().y1;
                x0 = Scaler.scaleDoubleToInt(x0, scaleWidth);
                y0 = Scaler.scaleDoubleToInt(y0, scaleHeight);
                x1 = Scaler.scaleDoubleToInt(x1, scaleWidth);
                y1 = Scaler.scaleDoubleToInt(y1, scaleHeight);
                gl2.glColor3f(0.0f, 0.0f, 1.0f);
                double py = x0 - x1;
                double px = -(y0 - y1);
                double l = Math.sqrt(Math.pow(py, 2.0) + Math.pow(px, 2.0));
                double transition = 3.0;
                double px0 = x0 + transition / l * px;
                double py0 = y0 + transition / l * py;
                double px1 = x1 + transition / l * px;
                double py1 = y1 + transition / l * py;
                double transition2 = -3.0;
                double px02 = x0 + transition2 / l * px;
                double py02 = y0 + transition2 / l * py;
                double px12 = x1 + transition2 / l * px;
                double py12 = y1 + transition2 / l * py;
                this.drawLineInScreenCoordinates(gl2, (float)px0, (float)py0, (float)px1, (float)py1);
                this.drawLineInScreenCoordinates(gl2, (float)px02, (float)py02, (float)px12, (float)py12);
                this.drawLineInScreenCoordinates(gl2, (float)px0, (float)py0, (float)px02, (float)py02);
                this.drawLineInScreenCoordinates(gl2, (float)px1, (float)py1, (float)px12, (float)py12);
            }
        }
        int LED_SCREEN_OFFSET = 40;
        if (this.vpanel.isLEDState()) {
            int alpha;
            float brightness = 1.0f;
            gl2.glEnable(3042);
            gl2.glBlendFunc(1, 0);
            if (this.vpanel.isLEDDir()) {
                for (int i = 22; i > 12; i -= 2) {
                    alpha = 250 - (i - 12) * 20 - this.vpanel.getLEDStep() * 2;
                    brightness = (float)alpha / 255.0f;
                    gl2.glColor3f(brightness, brightness, brightness);
                    this.drawDiskInScreenCoordinates(gl2, this.getWidth() - LED_SCREEN_OFFSET, this.getHeight() - LED_SCREEN_OFFSET, (i - 10) * 2);
                }
                gl2.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
                this.drawDiskInScreenCoordinates(gl2, this.getWidth() - LED_SCREEN_OFFSET, this.getHeight() - LED_SCREEN_OFFSET, 4.0f);
                brightness = (float)(255 - this.vpanel.getLEDStep()) / 255.0f;
                gl2.glColor3f(brightness, brightness, brightness);
                this.drawDiskInScreenCoordinates(gl2, this.getWidth() - LED_SCREEN_OFFSET, this.getHeight() - LED_SCREEN_OFFSET, 2.0f);
                this.vpanel.setLEDStep(this.vpanel.getLEDStep() + 1);
                if (this.vpanel.getLEDStep() >= 15) {
                    this.vpanel.setLEDDir(false);
                }
            } else if (!this.vpanel.isLEDDir()) {
                for (int i = 22; i > 12; i -= 2) {
                    alpha = 250 - (i - 12) * 20 - this.vpanel.getLEDStep() * 2;
                    brightness = (float)alpha / 255.0f;
                    gl2.glColor3f(brightness, brightness, brightness);
                    this.drawDiskInScreenCoordinates(gl2, this.getWidth() - LED_SCREEN_OFFSET, this.getHeight() - LED_SCREEN_OFFSET, (i - 10) * 2);
                }
                brightness = (float)(255 - this.vpanel.getLEDStep()) / 255.0f;
                gl2.glColor3f(brightness, brightness, brightness);
                this.drawDiskInScreenCoordinates(gl2, this.getWidth() - LED_SCREEN_OFFSET, this.getHeight() - LED_SCREEN_OFFSET, 4.0f);
                gl2.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
                this.drawDiskInScreenCoordinates(gl2, this.getWidth() - LED_SCREEN_OFFSET, this.getHeight() - LED_SCREEN_OFFSET, 2.0f);
                this.vpanel.setLEDStep(this.vpanel.getLEDStep() - 1);
                if (this.vpanel.getLEDStep() <= 0) {
                    this.vpanel.setLEDDir(true);
                }
            }
            gl2.glDisable(3042);
        }
        if (this.directDrawVector != null) {
            gl2.glColor3f(1.0f, 1.0f, 0.0f);
            gl2.glBegin(1);
            float _x0 = Scaler.scaleFloatToFloat(this.directDrawVector.x0 - this.config.ALG_MAX_X / 2, this.scaleWidthGL);
            float _y0 = Scaler.scaleFloatToFloat(-(this.directDrawVector.y0 - this.config.ALG_MAX_Y / 2), this.scaleHeightGL);
            float _x1 = Scaler.scaleFloatToFloat(this.directDrawVector.x1 - this.config.ALG_MAX_X / 2, this.scaleWidthGL);
            float _y1 = Scaler.scaleFloatToFloat(-(this.directDrawVector.y1 - this.config.ALG_MAX_Y / 2), this.scaleHeightGL);
            gl2.glVertex2f(_x0, _y0);
            gl2.glVertex2f(_x1, _y1);
            gl2.glEnd();
        }
        gl2.glPopAttrib();
    }

    private void drawDiskInScreenCoordinates(GL2 gl2, float xi, float yi, float radius) {
        gl2.glBegin(6);
        float x = xi / (0.5f * (float)this.gl2Width) - 1.0f;
        float y = -(yi / (0.5f * (float)this.gl2Height)) + 1.0f;
        float r = radius / (float)this.gl2Width;
        gl2.glVertex2f(x, y);
        for (int n = 0; n <= DISK_SEGEMENTS; ++n) {
            double t = Math.PI * 2 * (double)n / (double)DISK_SEGEMENTS;
            float xx = x + (float)Math.sin(t) * r;
            float yy = y + (float)Math.cos(t) * r;
            gl2.glVertex2f(xx, yy);
        }
        gl2.glEnd();
    }

    private void drawLineInScreenCoordinates(GL2 gl2, float px0, float py0, float px1, float py1) {
        gl2.glBegin(1);
        float _x0 = px0 / (0.5f * (float)this.gl2Width) - 1.0f;
        float _y0 = -(py0 / (0.5f * (float)this.gl2Height)) + 1.0f;
        float _x1 = px1 / (0.5f * (float)this.gl2Width) - 1.0f;
        float _y1 = -(py1 / (0.5f * (float)this.gl2Height)) + 1.0f;
        gl2.glVertex2f(_x0, _y0);
        gl2.glVertex2f(_x1, _y1);
        gl2.glEnd();
    }

    void doScaledBlur(GL2 gl2) {
        int w = this.gl2Width / (1 << this.config.JOGLMIP_RESOLUTION);
        int h = this.gl2Height / (1 << this.config.JOGLMIP_RESOLUTION);
        gl2.glBindFramebuffer(36160, this.lineFBO[4].fbo.get(0));
        gl2.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        gl2.glClear(16384);
        gl2.glBindFramebuffer(36160, this.lineFBO[5].fbo.get(0));
        gl2.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        gl2.glClear(16384);
        gl2.glActiveTexture(33984);
        gl2.glBindFramebuffer(36008, this.lineFBO[0].fbo.get(0));
        gl2.glBindFramebuffer(36009, this.lineFBO[4].fbo.get(0));
        gl2.glBlitFramebuffer(0, 0, this.gl2Width, this.gl2Height, 0, 0, w, h, 16384, 9729);
        gl2.glUseProgram(this.blurProgramId);
        if (!JOGLSupport.checkError(gl2, "doScaledBlur():1")) {
            return;
        }
        gl2.glViewport(0, 0, w, h);
        for (int bp = 0; bp < this.config.JOGLblurPass; ++bp) {
            gl2.glBindFramebuffer(36160, this.lineFBO[5].fbo.get(0));
            int i = gl2.glGetUniformLocation(this.blurProgramId, "uShift");
            gl2.glUniform2f(i, 1.0f / (float)w, 0.0f);
            i = gl2.glGetUniformLocation(this.blurProgramId, "uTexture");
            gl2.glUniform1i(i, 0);
            gl2.glBindTexture(3553, this.lineFBO[4].texture.get(0));
            float y1 = -1.0f;
            float y2 = 1.0f;
            gl2.glBegin(7);
            gl2.glTexCoord2f(0.0f, 0.0f);
            gl2.glVertex2f(-1.0f, y1);
            gl2.glTexCoord2f(1.0f, 0.0f);
            gl2.glVertex2f(1.0f, y1);
            gl2.glTexCoord2f(1.0f, 1.0f);
            gl2.glVertex2f(1.0f, y2);
            gl2.glTexCoord2f(0.0f, 1.0f);
            gl2.glVertex2f(-1.0f, y2);
            gl2.glEnd();
            gl2.glBindTexture(3553, 0);
            if (!JOGLSupport.checkError(gl2, "doScaledBlur():2")) {
                return;
            }
            gl2.glBindFramebuffer(36160, this.lineFBO[4].fbo.get(0));
            i = gl2.glGetUniformLocation(this.blurProgramId, "uShift");
            gl2.glUniform2f(i, 0.0f, 1.0f / (float)h);
            i = gl2.glGetUniformLocation(this.blurProgramId, "uTexture");
            gl2.glUniform1i(i, 0);
            gl2.glBindTexture(3553, this.lineFBO[5].texture.get(0));
            gl2.glBegin(7);
            y1 = -1.0f;
            y2 = 1.0f;
            gl2.glTexCoord2f(0.0f, 0.0f);
            gl2.glVertex2f(-1.0f, y1);
            gl2.glTexCoord2f(1.0f, 0.0f);
            gl2.glVertex2f(1.0f, y1);
            gl2.glTexCoord2f(1.0f, 1.0f);
            gl2.glVertex2f(1.0f, y2);
            gl2.glTexCoord2f(0.0f, 1.0f);
            gl2.glVertex2f(-1.0f, y2);
            gl2.glEnd();
            gl2.glBindTexture(3553, 0);
            gl2.glBindFramebuffer(36160, 0);
        }
        if (!JOGLSupport.checkError(gl2, "doScaledBlur():3")) {
            return;
        }
        gl2.glViewport(0, 0, this.gl2Width, this.gl2Height);
        gl2.glUseProgram(0);
        gl2.glDisable(3042);
        gl2.glBindFramebuffer(36160, this.lineFBO[0].fbo.get(0));
        gl2.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        gl2.glClear(16384);
        gl2.glBindFramebuffer(36008, this.lineFBO[4].fbo.get(0));
        gl2.glBindFramebuffer(36009, this.lineFBO[0].fbo.get(0));
        gl2.glBlitFramebuffer(0, 0, w, h, 0, 0, this.gl2Width, this.gl2Height, 16384, 9729);
        if (this.config.JOGLaddBase) {
            gl2.glEnable(3042);
            gl2.glBlendFunc(1, 1);
            gl2.glBindFramebuffer(36160, this.lineFBO[0].fbo.get(0));
            gl2.glBindTexture(3553, this.lineFBO[2].texture.get(0));
            gl2.glBegin(7);
            gl2.glTexCoord2f(0.0f, 0.0f);
            gl2.glVertex2f(-1.0f, -1.0f);
            gl2.glTexCoord2f(1.0f, 0.0f);
            gl2.glVertex2f(1.0f, -1.0f);
            gl2.glTexCoord2f(1.0f, 1.0f);
            gl2.glVertex2f(1.0f, 1.0f);
            gl2.glTexCoord2f(0.0f, 1.0f);
            gl2.glVertex2f(-1.0f, 1.0f);
            gl2.glEnd();
            gl2.glBindTexture(3553, 0);
            gl2.glBindFramebuffer(36160, 0);
        }
        gl2.glDisable(3042);
    }

    boolean needBorderGlow(float[] test) {
        for (int i = 0; i < test.length; ++i) {
            if (test[i] == 0.0f) continue;
            return true;
        }
        return false;
    }

    void processBorderGlow(GL2 gl2) {
        float y;
        float x;
        float intensity;
        int i;
        VecX.VectrexDisplayVectors vList = this.vpanel.getDisplayList();
        int BORDER_LEFT = 0;
        int BORDER_RIGHT = 1;
        int BORDER_TOP = 2;
        int BORDER_BOTTOM = 3;
        gl2.glBlendEquation(32774);
        gl2.glDisable(3042);
        gl2.glPointSize(2.0f);
        if (this.needBorderGlow(vList.left)) {
            gl2.glBindFramebuffer(36160, this.lineFBO[2].fbo.get(0));
            gl2.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
            gl2.glClear(16384);
            gl2.glBindFramebuffer(36160, this.borderFBO[BORDER_LEFT].fbo.get(0));
            gl2.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
            gl2.glClear(16384);
            gl2.glPushAttrib(1);
            gl2.glViewport(0, 0, VecX.OVERFLOW_BORDER_RAYWIDTH, VecX.OVERFLOW_SAMPLE_MAX);
            gl2.glBegin(0);
            for (i = 0; i < vList.left.length; ++i) {
                intensity = vList.left[i] / this.config.overflowIntensityDivider;
                if (intensity > this.maxBorderIntensity) {
                    intensity = this.maxBorderIntensity;
                }
                gl2.glColor3f(intensity, intensity, intensity);
                x = 1.0f;
                y = -(2.0f / (float)(VecX.OVERFLOW_SAMPLE_MAX - 1) * (float)i - 1.0f);
                gl2.glVertex2f(x, y);
            }
            gl2.glEnd();
            gl2.glPopAttrib();
            gl2.glViewport(0, 0, this.gl2Width, this.gl2Height);
            gl2.glBindTexture(3553, this.borderFBO[BORDER_LEFT].texture.get(0));
            gl2.glBindFramebuffer(36160, this.lineFBO[2].fbo.get(0));
            gl2.glBegin(7);
            gl2.glTexCoord2f(0.0f, 0.0f);
            gl2.glVertex2f(-1.0f, -1.0f);
            gl2.glTexCoord2f(1.0f, 0.0f);
            gl2.glVertex2f(1.0f, -1.0f);
            gl2.glTexCoord2f(1.0f, 1.0f);
            gl2.glVertex2f(1.0f, 1.0f);
            gl2.glTexCoord2f(0.0f, 1.0f);
            gl2.glVertex2f(-1.0f, 1.0f);
            gl2.glEnd();
            gl2.glBindTexture(3553, 0);
            gl2.glBindFramebuffer(36160, 0);
            gl2.glEnable(3042);
            gl2.glBlendFunc(1, 1);
            gl2.glBindTexture(3553, this.lineFBO[2].texture.get(0));
            gl2.glBindFramebuffer(36160, this.lineFBO[0].fbo.get(0));
            gl2.glBegin(7);
            gl2.glTexCoord2f(0.0f, 0.0f);
            gl2.glVertex2f(-1.0f, -1.0f);
            gl2.glTexCoord2f(0.5f, 0.0f);
            gl2.glVertex2f(1.0f, -1.0f);
            gl2.glTexCoord2f(0.5f, 1.0f);
            gl2.glVertex2f(1.0f, 1.0f);
            gl2.glTexCoord2f(0.0f, 1.0f);
            gl2.glVertex2f(-1.0f, 1.0f);
            gl2.glEnd();
            if (!JOGLSupport.checkError(gl2, "processBorderGlow(): left")) {
                return;
            }
            gl2.glBindTexture(3553, 0);
            gl2.glBindFramebuffer(36160, 0);
            gl2.glDisable(3042);
        }
        if (this.needBorderGlow(vList.right)) {
            gl2.glBindFramebuffer(36160, this.lineFBO[2].fbo.get(0));
            gl2.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
            gl2.glClear(16384);
            gl2.glBindFramebuffer(36160, this.borderFBO[BORDER_RIGHT].fbo.get(0));
            gl2.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
            gl2.glClear(16384);
            gl2.glPushAttrib(1);
            gl2.glViewport(0, 0, VecX.OVERFLOW_BORDER_RAYWIDTH, VecX.OVERFLOW_SAMPLE_MAX);
            gl2.glBegin(0);
            for (i = 0; i < vList.right.length; ++i) {
                intensity = vList.right[i] / this.config.overflowIntensityDivider;
                if (intensity > this.maxBorderIntensity) {
                    intensity = this.maxBorderIntensity;
                }
                gl2.glColor3f(intensity, intensity, intensity);
                x = -1.0f;
                y = -(2.0f / (float)(VecX.OVERFLOW_SAMPLE_MAX - 1) * (float)i - 1.0f);
                gl2.glVertex2f(x, y);
            }
            gl2.glEnd();
            gl2.glPopAttrib();
            gl2.glEnable(3042);
            gl2.glBlendFunc(1, 1);
            gl2.glViewport(0, 0, this.gl2Width, this.gl2Height);
            gl2.glBindTexture(3553, this.borderFBO[BORDER_RIGHT].texture.get(0));
            gl2.glBindFramebuffer(36160, this.lineFBO[2].fbo.get(0));
            gl2.glBegin(7);
            gl2.glTexCoord2f(0.0f, 0.0f);
            gl2.glVertex2f(-1.0f, -1.0f);
            gl2.glTexCoord2f(1.0f, 0.0f);
            gl2.glVertex2f(1.0f, -1.0f);
            gl2.glTexCoord2f(1.0f, 1.0f);
            gl2.glVertex2f(1.0f, 1.0f);
            gl2.glTexCoord2f(0.0f, 1.0f);
            gl2.glVertex2f(-1.0f, 1.0f);
            gl2.glEnd();
            gl2.glBindTexture(3553, 0);
            gl2.glBindFramebuffer(36160, 0);
            gl2.glBindTexture(3553, this.lineFBO[2].texture.get(0));
            gl2.glBindFramebuffer(36160, this.lineFBO[0].fbo.get(0));
            gl2.glBegin(7);
            gl2.glTexCoord2f(0.5f, 0.0f);
            gl2.glVertex2f(-1.0f, -1.0f);
            gl2.glTexCoord2f(1.0f, 0.0f);
            gl2.glVertex2f(1.0f, -1.0f);
            gl2.glTexCoord2f(1.0f, 1.0f);
            gl2.glVertex2f(1.0f, 1.0f);
            gl2.glTexCoord2f(0.5f, 1.0f);
            gl2.glVertex2f(-1.0f, 1.0f);
            gl2.glEnd();
            if (!JOGLSupport.checkError(gl2, "processBorderGlow(): right")) {
                return;
            }
            gl2.glBindTexture(3553, 0);
            gl2.glBindFramebuffer(36160, 0);
            gl2.glDisable(3042);
        }
        if (this.needBorderGlow(vList.top)) {
            gl2.glBindFramebuffer(36160, this.lineFBO[2].fbo.get(0));
            gl2.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
            gl2.glClear(16384);
            gl2.glBindFramebuffer(36160, this.borderFBO[BORDER_TOP].fbo.get(0));
            gl2.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
            gl2.glClear(16384);
            gl2.glPushAttrib(1);
            gl2.glViewport(0, 0, VecX.OVERFLOW_SAMPLE_MAX, VecX.OVERFLOW_BORDER_RAYWIDTH);
            gl2.glBegin(0);
            for (i = 0; i < vList.top.length; ++i) {
                intensity = vList.top[i] / this.config.overflowIntensityDivider;
                if (intensity > this.maxBorderIntensity) {
                    intensity = this.maxBorderIntensity;
                }
                gl2.glColor3f(intensity, intensity, intensity);
                x = 2.0f / (float)(VecX.OVERFLOW_SAMPLE_MAX - 1) * (float)i - 1.0f;
                y = 1.0f;
                gl2.glVertex2f(x, y);
            }
            gl2.glEnd();
            gl2.glPopAttrib();
            gl2.glEnable(3042);
            gl2.glBlendFunc(1, 1);
            gl2.glViewport(0, 0, this.gl2Width, this.gl2Height);
            gl2.glBindTexture(3553, this.borderFBO[BORDER_TOP].texture.get(0));
            gl2.glBindFramebuffer(36160, this.lineFBO[2].fbo.get(0));
            gl2.glBegin(7);
            gl2.glTexCoord2f(0.0f, 0.0f);
            gl2.glVertex2f(-1.0f, -1.0f);
            gl2.glTexCoord2f(1.0f, 0.0f);
            gl2.glVertex2f(1.0f, -1.0f);
            gl2.glTexCoord2f(1.0f, 1.0f);
            gl2.glVertex2f(1.0f, 1.0f);
            gl2.glTexCoord2f(0.0f, 1.0f);
            gl2.glVertex2f(-1.0f, 1.0f);
            gl2.glEnd();
            gl2.glBindTexture(3553, 0);
            gl2.glBindFramebuffer(36160, 0);
            gl2.glBindTexture(3553, this.lineFBO[2].texture.get(0));
            gl2.glBindFramebuffer(36160, this.lineFBO[0].fbo.get(0));
            gl2.glBegin(7);
            gl2.glTexCoord2f(0.0f, 0.5f);
            gl2.glVertex2f(-1.0f, -1.0f);
            gl2.glTexCoord2f(1.0f, 0.5f);
            gl2.glVertex2f(1.0f, -1.0f);
            gl2.glTexCoord2f(1.0f, 0.0f);
            gl2.glVertex2f(1.0f, 1.0f);
            gl2.glTexCoord2f(0.0f, 0.0f);
            gl2.glVertex2f(-1.0f, 1.0f);
            gl2.glEnd();
            if (!JOGLSupport.checkError(gl2, "processBorderGlow(): top")) {
                return;
            }
            gl2.glBindTexture(3553, 0);
            gl2.glBindFramebuffer(36160, 0);
            gl2.glDisable(3042);
        }
        if (this.needBorderGlow(vList.bottom)) {
            gl2.glBindFramebuffer(36160, this.lineFBO[2].fbo.get(0));
            gl2.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
            gl2.glClear(16384);
            gl2.glBindFramebuffer(36160, this.borderFBO[BORDER_BOTTOM].fbo.get(0));
            gl2.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
            gl2.glClear(16384);
            gl2.glPushAttrib(1);
            gl2.glViewport(0, 0, VecX.OVERFLOW_SAMPLE_MAX, VecX.OVERFLOW_BORDER_RAYWIDTH);
            gl2.glBegin(0);
            for (i = 0; i < vList.bottom.length; ++i) {
                intensity = vList.bottom[i] / this.config.overflowIntensityDivider;
                if (intensity > this.maxBorderIntensity) {
                    intensity = this.maxBorderIntensity;
                }
                gl2.glColor3f(intensity, intensity, intensity);
                x = 2.0f / (float)(VecX.OVERFLOW_SAMPLE_MAX - 1) * (float)i - 1.0f;
                y = 1.0f;
                gl2.glVertex2f(x, y);
            }
            gl2.glEnd();
            gl2.glPopAttrib();
            gl2.glEnable(3042);
            gl2.glBlendFunc(1, 1);
            gl2.glViewport(0, 0, this.gl2Width, this.gl2Height);
            gl2.glBindTexture(3553, this.borderFBO[BORDER_BOTTOM].texture.get(0));
            gl2.glBindFramebuffer(36160, this.lineFBO[2].fbo.get(0));
            gl2.glBegin(7);
            gl2.glTexCoord2f(0.0f, 0.0f);
            gl2.glVertex2f(-1.0f, -1.0f);
            gl2.glTexCoord2f(1.0f, 0.0f);
            gl2.glVertex2f(1.0f, -1.0f);
            gl2.glTexCoord2f(1.0f, 1.0f);
            gl2.glVertex2f(1.0f, 1.0f);
            gl2.glTexCoord2f(0.0f, 1.0f);
            gl2.glVertex2f(-1.0f, 1.0f);
            gl2.glEnd();
            gl2.glBindTexture(3553, 0);
            gl2.glBindFramebuffer(36160, 0);
            gl2.glBindTexture(3553, this.lineFBO[2].texture.get(0));
            gl2.glBindFramebuffer(36160, this.lineFBO[0].fbo.get(0));
            gl2.glBegin(7);
            gl2.glTexCoord2f(0.0f, 0.0f);
            gl2.glVertex2f(-1.0f, -1.0f);
            gl2.glTexCoord2f(1.0f, 0.0f);
            gl2.glVertex2f(1.0f, -1.0f);
            gl2.glTexCoord2f(1.0f, 0.5f);
            gl2.glVertex2f(1.0f, 1.0f);
            gl2.glTexCoord2f(0.0f, 0.5f);
            gl2.glVertex2f(-1.0f, 1.0f);
            gl2.glEnd();
            if (!JOGLSupport.checkError(gl2, "processBorderGlow(): bottom")) {
                return;
            }
            gl2.glBindTexture(3553, 0);
            gl2.glBindFramebuffer(36160, 0);
            gl2.glDisable(3042);
        }
        gl2.glPointSize((float)this.config.lineWidth);
    }

    void renderChassis(GL2 gl2) {
        if (this.config.JOGLScreen) {
            gl2.glEnable(3042);
            gl2.glBlendFunc(770, 771);
            gl2.glLoadIdentity();
            gl2.glEnable(3553);
            gl2.glActiveTexture(33984);
            gl2.glBindTexture(3553, this.screenTextureObject.get(0));
            if (this.config.JOGLScreenAdjustment) {
                gl2.glUseProgram(this.screenProgramId);
                int i = gl2.glGetUniformLocation(this.screenProgramId, "screenTexture");
                gl2.glUniform1i(i, 0);
                i = gl2.glGetUniformLocation(this.screenProgramId, "screenBrightnessAdjust");
                gl2.glUniform1f(i, this.config.JOGLScreenBrightnessAdjustmentFactor);
            }
            gl2.glBindFramebuffer(36160, this.lineFBO[0].fbo.get(0));
            gl2.glBegin(7);
            float y1 = this.screenMustFlip ? 1.0f : -1.0f;
            float y2 = 1.0f - y1;
            y2 = y1 == 1.0f ? -1.0f : 1.0f;
            gl2.glTexCoord2f(0.0f, 0.0f);
            gl2.glVertex2f(-1.0f, y1);
            gl2.glTexCoord2f(1.0f, 0.0f);
            gl2.glVertex2f(1.0f, y1);
            gl2.glTexCoord2f(1.0f, 1.0f);
            gl2.glVertex2f(1.0f, y2);
            gl2.glTexCoord2f(0.0f, 1.0f);
            gl2.glVertex2f(-1.0f, y2);
            gl2.glEnd();
            gl2.glBindTexture(3553, 0);
            gl2.glBindFramebuffer(36160, 0);
            gl2.glUseProgram(0);
            gl2.glBlendFunc(770, 1);
            gl2.glBlendEquation(32774);
            gl2.glDisable(3042);
        }
        if (VideConfig.CHASSIS_AVAILABLE != 1) {
            return;
        }
    }

    public static int getScaleFactor() {
        try {
            Object screen = Class.forName("sun.awt.CGraphicsDevice").cast(GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice());
            Method getScaleFactor = screen.getClass().getDeclaredMethod("getScaleFactor", new Class[0]);
            Object obj = getScaleFactor.invoke(screen, new Object[0]);
            if (obj instanceof Integer) {
                return (Integer)obj;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 1;
    }

    @Override
    public void forceResize() {
        Rectangle bounds = new Rectangle(0, this.vpanel.getYOffset(), this.vpanel.getWidth(), this.vpanel.getHeight() - this.vpanel.getYOffset());
        if (bounds.width != 0 && bounds.height != 0) {
            int scaleFactor = VecxiPanel_JOGL.getScaleFactor();
            if (this.config.keepAspectRatio) {
                float width = bounds.width;
                float height = bounds.height;
                float ratio = 1.3333334f;
                if (this.config.rotate == 0 || this.config.rotate == 180) {
                    float naturalRatio = (float)bounds.height / (float)bounds.width;
                    if (naturalRatio > ratio) {
                        height = width * ratio;
                    }
                    if (naturalRatio < ratio) {
                        width = height / ratio;
                    }
                } else {
                    float naturalRatio = (float)bounds.width / (float)bounds.height;
                    if (naturalRatio > ratio) {
                        width = height * ratio;
                    }
                    if (naturalRatio < ratio) {
                        height = width / ratio;
                    }
                }
                this.topOffset = 0 + (int)(((float)bounds.height - height) / 2.0f);
                bounds.x = this.leftOffset = 0 + (int)(((float)bounds.width - width) / 2.0f);
                bounds.y = this.vpanel.getYOffset() + this.topOffset;
                bounds.width = (int)width;
                bounds.height = (int)height;
            } else {
                this.topOffset = 0;
                this.leftOffset = 0;
            }
            bounds.width *= scaleFactor;
            bounds.height *= scaleFactor;
        }
        this.gl2Width = bounds.width;
        this.gl2Height = bounds.height;
        this.scaleWidth = (float)((double)this.gl2Width / (double)this.config.ALG_MAX_X);
        this.scaleHeight = (float)((double)this.gl2Height / (double)this.config.ALG_MAX_Y);
        this.setBounds(bounds);
    }

    class LineStripBuffer {
        public IntBuffer lineStripBufferObject = GLBuffers.newDirectIntBuffer((int)1);
        public float[] lineStripData;
        public FloatBuffer lineStripDataBuffer;
        public int lineCount;
        public int dataCount;

        LineStripBuffer() {
        }

        public void updateBuffer() {
            this.lineStripData = null;
            this.lineStripDataBuffer = null;
            this.lineStripData = new float[VecxiPanel_JOGL.this.MAXBUFFERSIZE_LINE_STRIP * 5];
            this.lineStripDataBuffer = FloatBuffer.wrap(this.lineStripData);
            this.lineCount = 0;
            this.dataCount = 0;
        }
    }

    class LineFBO {
        IntBuffer fbo = GLBuffers.newDirectIntBuffer((int)1);
        IntBuffer texture = GLBuffers.newDirectIntBuffer((int)1);

        public LineFBO() {
            this.fbo.put(0, 0);
            this.texture.put(0, 0);
        }
    }
}

