/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.vecx.cartridge;

import de.malban.config.Configuration;
import de.malban.gui.CSAMainFrame;
import de.malban.gui.panels.LogPanel;
import de.malban.vide.dissy.DissiPanel;
import de.malban.vide.vecx.cartridge.Cartridge;
import de.malban.vide.vecx.cartridge.CartridgeInternalInterface;
import java.io.Serializable;

public class AT24C02
implements Serializable,
CartridgeInternalInterface {
    transient LogPanel log = (LogPanel)Configuration.getConfiguration().getDebugEntity();
    public static final transient int MAX_DATA_LEN = 256;
    public transient Cartridge cart;
    EpromData epromData = new EpromData();
    boolean line = false;
    boolean old_line = false;
    boolean lineIn = false;
    boolean lineOut = false;
    boolean irqLine = false;
    boolean irqLineOld = false;
    public static final transient int LOW_NOTHING = 0;
    public static final transient int LOW_GET_BYTE_FROM_VECTREX = 1;
    public static final transient int LOW_SEND_BYTE_TO_VECTREX = 2;
    public static final transient int LOW_SEND_ACK_TO_VECTREX = 3;
    public static final transient int LOW_GET_ACK_FROM_VECTREX = 4;
    int lowLevelState = 0;
    public static final transient String[] low_names = new String[]{"NOTHING", "GET_BYTE_FROM_VECTREX", "SEND_BYTE_TO_VECTREX", "SEND_ACK_TO_VECTREX", "GET_ACK_FROM_VECTREX"};
    public static final transient int HI_STANDBY_MODE = 0;
    public static final transient int HI_GET_DEVICE_ADDRESS = 1;
    public static final transient int HI_GET_WRITE_ADDRESS = 2;
    public static final transient int HI_GET_BYTE_WRITE = 3;
    public static final transient int HI_READ_CURRENT_BYTE = 4;
    public static final transient String[] hi_names = new String[]{"STANDBY_MODE", "GET_DEVICE_ADDRESS", "GET_WRITE_ADDRESS", "GET_BYTE_WRITE", "READ_CURRENT_BYTE"};
    int hiLevelState = 0;
    int internalAddressPointer = 0;
    int bitCount = 0;
    byte transportByte = 0;
    boolean lastTransportedBit = false;
    public static final transient int WRITE_CYCLE_DELAY = 2500;
    boolean writeAck = false;
    boolean inWriteCycle = false;
    boolean delayedAck = false;
    int writeCycleCounter = 0;
    int resetCount = 0;
    int periodCounter = 0;
    public static final transient int FREQ_PERIOD = 15;
    int consecutiveHigh = 0;
    public static final transient int RW_UNKOWN = 0;
    public static final transient int RW_READ_FROM_DEVICE = 1;
    public static final transient int RW_WRITE_TO_DEVICE = 2;
    int rwMode = 0;
    boolean lowStarting = false;
    boolean hiStarting = false;
    int sdaLowCounter = 0;
    int sdaHiCounter = 0;
    boolean currentRecievedBit = false;
    boolean outputBit = false;
    int consecutiveBytesReceived = 0;

    @Override
    public void init() {
        if (this.log == null) {
            this.log = (LogPanel)Configuration.getConfiguration().getDebugEntity();
        }
    }

    @Override
    public void deinit() {
    }

    public byte[] getData() {
        return this.epromData.data;
    }

    @Override
    public void reset() {
        this.line = false;
        this.old_line = false;
        this.lineIn = false;
        this.lineOut = false;
        this.irqLineOld = false;
        this.irqLine = false;
        this.outputBit = false;
        this.writeAck = false;
        this.currentRecievedBit = false;
    }

    public AT24C02(Cartridge c) {
        this.cart = c;
        this.loadBytesFromDisk();
    }

    public AT24C02(Cartridge c, boolean donotload) {
        this.cart = c;
    }

    @Override
    public AT24C02 clone() {
        AT24C02 c = new AT24C02(this.cart, false);
        for (int i = 0; i < 256; ++i) {
            c.epromData.data[i] = this.epromData.data[i];
        }
        c.line = this.line;
        c.old_line = this.old_line;
        c.lineIn = this.lineIn;
        c.lineOut = this.lineOut;
        c.irqLine = this.irqLine;
        c.irqLineOld = this.irqLineOld;
        c.lowLevelState = this.lowLevelState;
        c.hiLevelState = this.hiLevelState;
        c.internalAddressPointer = this.internalAddressPointer;
        c.bitCount = this.bitCount;
        c.transportByte = this.transportByte;
        c.inWriteCycle = this.inWriteCycle;
        c.delayedAck = this.delayedAck;
        c.writeCycleCounter = this.writeCycleCounter;
        c.resetCount = this.resetCount;
        c.periodCounter = this.periodCounter;
        c.consecutiveHigh = this.consecutiveHigh;
        c.rwMode = this.rwMode;
        c.sdaLowCounter = this.sdaLowCounter;
        c.sdaHiCounter = this.sdaHiCounter;
        c.lastTransportedBit = this.lastTransportedBit;
        c.lowStarting = this.lowStarting;
        c.hiStarting = this.hiStarting;
        c.currentRecievedBit = this.currentRecievedBit;
        c.outputBit = this.outputBit;
        c.writeAck = this.writeAck;
        return c;
    }

    @Override
    public void linePB6In(boolean l) {
        this.line = l;
        this.lineIn = l;
    }

    @Override
    public void linePB6Out(boolean l) {
        this.line = l;
        this.lineOut = l;
        this.cart.setPB6FromCartridge(this.line);
    }

    public static EpromData loadData(String serialname) {
        return (EpromData)CSAMainFrame.deserialize(serialname);
    }

    public static boolean saveData(String serialname, EpromData d) {
        return CSAMainFrame.serialize(d, serialname);
    }

    void loadBytesFromDisk() {
        this.epromData = AT24C02.loadData(this.getSaveName());
        if (this.epromData == null) {
            this.epromData = new EpromData();
        } else {
            this.epromData.isNew = false;
        }
    }

    void saveBytestoDisk() {
        this.epromData.isNew = false;
        AT24C02.saveData(this.getSaveName(), this.epromData);
    }

    public String getSaveName() {
        return this.cart.cartName + ".at24c02.ser";
    }

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    public boolean usesPB6() {
        return true;
    }

    public String getSyncCycles() {
        return "";
    }

    public String getLineIn() {
        if (this.lineIn) {
            return "1";
        }
        return "0";
    }

    public String getLineOut() {
        if (this.lineOut) {
            return "1";
        }
        return "0";
    }

    public String getSDA() {
        if (this.line) {
            return "1";
        }
        return "0";
    }

    public String getSCL() {
        if (this.irqLine) {
            return "1";
        }
        return "0";
    }

    public String getLowLevelName() {
        return low_names[this.lowLevelState];
    }

    public String getHighLevelName() {
        return hi_names[this.hiLevelState];
    }

    public boolean isInputToAtmel() {
        return this.rwMode == 2;
    }

    public int getBitCounter() {
        return this.bitCount;
    }

    public int getLastTransportedBit() {
        return this.lastTransportedBit ? 1 : 0;
    }

    public boolean isWriting() {
        return this.inWriteCycle;
    }

    public int getWriteCyclesLeft() {
        return this.writeCycleCounter;
    }

    public int getTransportByte() {
        return this.transportByte;
    }

    public int getInternalAddress() {
        return this.internalAddressPointer;
    }

    @Override
    public void lineIRQIn(boolean i) {
        this.irqLine = i;
    }

    @Override
    public void step(long c) {
        if (DissiPanel.specialDebugMode) {
            int sdaI = this.line ? 1 : 0;
            int sclI = this.irqLine ? 1 : 0;
            this.log.addLog("SDA: " + sdaI + ", SCL: " + sclI, LogPanel.INFO);
            System.out.println("SDA: " + sdaI + ", SCL: " + sclI);
        }
        if (this.inWriteCycle) {
            ++this.writeCycleCounter;
            if (this.writeCycleCounter > 2500) {
                this.inWriteCycle = false;
                this.saveBytestoDisk();
                if (this.delayedAck) {
                    this.delayedAck = false;
                    this.lowLevelState = 3;
                    this.rwMode = 1;
                    this.linePB6Out(this.outputBit);
                    this.log.addLog("ATMEL: delayed ack started ", LogPanel.INFO);
                }
            }
        }
        if (this.delayedAck) {
            return;
        }
        if (this.irqLineOld != this.irqLine) {
            this.periodCounter = 0;
        }
        boolean sda = this.line;
        boolean scl = this.irqLine;
        if (this.periodCounter > 135) {
            // empty if block
        }
        if (!scl) {
            if (this.lowStarting) {
                this.lowStarting = false;
                this.sdaHiCounter = 0;
                this.sdaLowCounter = 0;
            }
            this.hiStarting = true;
            if (sda) {
                ++this.sdaHiCounter;
            } else {
                ++this.sdaLowCounter;
            }
            this.currentRecievedBit = sda;
            if (this.rwMode == 1) {
                this.linePB6Out(this.outputBit);
            }
        } else {
            if (this.hiStarting) {
                this.lowStarting = true;
                this.hiStarting = false;
                if (this.rwMode == 2) {
                    this.doLowLevelDataStep(this.currentRecievedBit);
                } else if (this.rwMode == 1) {
                    this.doLowLevelDataStep(this.currentRecievedBit);
                }
            }
            if (sda && !this.old_line) {
                this.initStopCondition();
            } else if (!sda && this.old_line) {
                this.initStartCondition();
            }
        }
        ++this.periodCounter;
        this.irqLineOld = this.irqLine;
        this.old_line = this.line;
    }

    void initStartCondition() {
        this.writeAck = false;
        this.lowStarting = true;
        this.bitCount = 0;
        this.transportByte = 0;
        this.lowLevelState = 1;
        this.hiLevelState = 1;
        this.rwMode = 2;
        this.log.addLog("ATMEL: start", LogPanel.INFO);
    }

    void initStopCondition() {
        if (this.rwMode == 2 && this.writeAck) {
            this.log.addLog("ATMEL: Write cycle initiated", LogPanel.INFO);
            this.inWriteCycle = true;
            this.writeCycleCounter = 0;
        }
        this.lowLevelState = 0;
        this.hiLevelState = 0;
        this.rwMode = 0;
        this.hiStarting = false;
        this.lowStarting = false;
        this.log.addLog("ATMEL: stop", LogPanel.INFO);
    }

    void doLowLevelDataStep(boolean recievedBit) {
        switch (this.lowLevelState) {
            case 0: {
                break;
            }
            case 1: {
                if (this.bitCount > 0) {
                    this.writeAck = false;
                }
                this.lastTransportedBit = recievedBit;
                int bit = recievedBit ? 1 : 0;
                this.log.addLog("ATMEL: low, received bit: " + bit, LogPanel.INFO);
                this.transportByte = (byte)(this.transportByte << 1);
                this.transportByte = (byte)(this.transportByte + bit);
                ++this.bitCount;
                if (this.bitCount != 8) break;
                if (this.inWriteCycle) {
                    this.log.addLog("ATMEL: low, ack delayed, waiting for write ", LogPanel.INFO);
                    this.lowLevelState = 0;
                    this.delayedAck = true;
                    break;
                }
                this.log.addLog("ATMEL: low, ack word from device expected inititated ", LogPanel.INFO);
                this.lowLevelState = 3;
                this.rwMode = 1;
                this.outputBit = false;
                break;
            }
            case 2: {
                int bit = 0;
                if (this.bitCount == 0) {
                    bit = this.transportByte & 0x80;
                } else if (this.bitCount == 1) {
                    bit = this.transportByte & 0x40;
                } else if (this.bitCount == 2) {
                    bit = this.transportByte & 0x20;
                } else if (this.bitCount == 3) {
                    bit = this.transportByte & 0x10;
                } else if (this.bitCount == 4) {
                    bit = this.transportByte & 8;
                } else if (this.bitCount == 5) {
                    bit = this.transportByte & 4;
                } else if (this.bitCount == 6) {
                    bit = this.transportByte & 2;
                } else if (this.bitCount == 7) {
                    bit = this.transportByte & 1;
                }
                this.rwMode = 1;
                this.lastTransportedBit = bit != 0;
                this.outputBit = bit != 0;
                this.linePB6Out(this.outputBit);
                this.log.addLog("ATMEL: low, bit send to vectrex: " + (this.outputBit ? 1 : 0), LogPanel.INFO);
                ++this.bitCount;
                if (this.bitCount != 8) break;
                this.log.addLog("ATMEL: low, ack word from vectrex expected inititated ", LogPanel.INFO);
                this.lowLevelState = 4;
                this.rwMode = 2;
                this.internalAddressPointer = (this.internalAddressPointer + 1) % 256;
                break;
            }
            case 4: {
                int bit = recievedBit ? 1 : 0;
                this.log.addLog("ATMEL: low, ack bit from vectrex received: " + bit, LogPanel.INFO);
                if (bit == 1) {
                    this.log.addLog("ATMEL: error Ack bit = 1 - repeating ", LogPanel.INFO);
                    this.lowLevelState = 4;
                    this.rwMode = 2;
                    break;
                }
                this.log.addLog("ATMEL: low, ack recieved from vectrex finished", LogPanel.INFO);
                this.doHiLevelStep();
                break;
            }
            case 3: {
                this.log.addLog("ATMEL: low, ack send to vectrex finished", LogPanel.INFO);
                if (this.hiLevelState == 3) {
                    this.writeAck = true;
                }
                this.doHiLevelStep();
                break;
            }
        }
    }

    void doHiLevelStep() {
        switch (this.hiLevelState) {
            case 0: {
                break;
            }
            case 1: {
                this.log.addLog("ATMEL: hi, get device address finished: " + this.transportByte + "(" + String.format("%02X", this.transportByte) + ")", LogPanel.INFO);
                if ((this.transportByte & 0xA0) != 160) {
                    this.log.addLog("ATMEL: hi, get device address finished but ERROR " + this.transportByte, LogPanel.INFO);
                    this.lowLevelState = 0;
                    this.hiLevelState = 0;
                    this.rwMode = 0;
                    return;
                }
                if ((this.transportByte & 1) == 1) {
                    this.log.addLog("ATMEL: hi mode read from device", LogPanel.INFO);
                    this.bitCount = 0;
                    this.transportByte = this.epromData.data[this.internalAddressPointer];
                    this.lowLevelState = 2;
                    this.hiLevelState = 4;
                    this.rwMode = 1;
                    break;
                }
                this.bitCount = 0;
                this.transportByte = 0;
                this.lowLevelState = 1;
                this.hiLevelState = 2;
                this.rwMode = 2;
                this.log.addLog("ATMEL: hi mode write to device", LogPanel.INFO);
                break;
            }
            case 2: {
                if (this.epromData.isNew) {
                    this.loadBytesFromDisk();
                }
                this.internalAddressPointer = this.transportByte;
                this.log.addLog("ATMEL: hi write address got: " + this.transportByte + "(" + String.format("%02X", this.transportByte) + ")", LogPanel.INFO);
                this.bitCount = 0;
                this.transportByte = 0;
                this.lowLevelState = 1;
                this.hiLevelState = 3;
                this.rwMode = 2;
                this.consecutiveBytesReceived = 0;
                break;
            }
            case 3: {
                this.log.addLog("ATMEL: hi byte recieved: " + this.transportByte + "(" + String.format("%02X", this.transportByte) + ") (to: " + String.format("%02X", this.internalAddressPointer) + ")", LogPanel.INFO);
                if (this.consecutiveBytesReceived >= 8) {
                    this.log.addLog("ATMEL: WARNING page write exceeds 8", LogPanel.WARN);
                }
                try {
                    this.epromData.data[this.internalAddressPointer] = this.transportByte;
                    int adrHi = this.internalAddressPointer & 0xF8;
                    int adrLo = this.internalAddressPointer & 7;
                    ++adrLo;
                    this.internalAddressPointer = adrHi | (adrLo &= 7);
                    ++this.consecutiveBytesReceived;
                    this.bitCount = 0;
                    this.transportByte = 0;
                    this.lowLevelState = 1;
                    this.hiLevelState = 3;
                    this.rwMode = 2;
                }
                catch (Throwable e) {
                    this.log.addLog(e, LogPanel.ERROR);
                }
                break;
            }
            case 4: {
                int la = this.internalAddressPointer - 1;
                if (la < 0) {
                    la += 256;
                }
                this.log.addLog("ATMEL: current byte sent to vectrex: " + this.transportByte + "(" + String.format("%02X", this.transportByte) + ") (from: " + String.format("%02X", la) + ")", LogPanel.INFO);
                this.bitCount = 0;
                this.transportByte = this.epromData.data[this.internalAddressPointer];
                this.lowLevelState = 2;
                this.hiLevelState = 4;
                this.rwMode = 1;
                this.log.addLog("ATMEL: hi mode read from device", LogPanel.INFO);
                break;
            }
        }
    }

    static class EpromData
    implements Serializable {
        byte[] data = new byte[256];
        public boolean isNew = true;

        EpromData() {
            for (int i = 0; i < 256; ++i) {
            }
        }
    }
}

