/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.vecx.cartridge;

import de.malban.Global;
import de.malban.gui.ImageCache;
import de.malban.util.UtilityString;
import de.malban.vide.vecx.cartridge.CartridgePropertiesXMLHandler;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.helpers.DefaultHandler;

public class CartridgeProperties
implements Serializable {
    protected String mClass = "";
    public String mName = "";
    protected String mCartName = "";
    protected String mAuthor = "";
    protected String mYear = "";
    protected int mCRC = 0;
    protected int mTypeFlags = 0;
    protected Vector<String> mFullFilename = new Vector();
    protected String mInformation = "";
    protected String mCheats = "";
    protected String mEastereggs = "";
    protected String mHomepage = "";
    protected String mInstructionFile = "";
    protected String mFrontImage = "";
    protected String mBackImage = "";
    protected String mOverlay = "";
    protected String mInGameImage = "";
    protected String mCritic = "";
    protected String mOther = "";
    protected String mBinaryLink = "";
    protected String mLicence = "";
    protected String mCopyrightType = "";
    protected String mPDFLink = "";
    protected String mPDFFile = "";
    protected String mCartridgeImage = "";
    protected boolean mHomebrew = false;
    protected boolean mDemo = false;
    protected boolean mSnippet = false;
    protected boolean mCompleteGame = false;
    protected String mextremeVecFileImage = "";
    protected String mWheelName = "";
    protected boolean mConfigOverwrite = false;
    protected boolean mCF_AutoSync = false;
    protected boolean mCF_AllowROMWrite = false;
    protected boolean mCF_ROM_PC_BreakPoints = false;
    protected int mCF_IntegratorMaxX = 0;
    protected int mCF_IntegratorMaxY = 0;
    protected float mCF_OverlayThreshold = 0.0f;
    protected int mCF_DotdwellDivisor = 0;
    private static CartridgePropertiesXMLHandler XMLHANDLER = new CartridgePropertiesXMLHandler();
    transient BufferedImage mSmallCartridgeImage = null;
    transient BufferedImage mSmallFrontImage = null;
    transient BufferedImage mSmallBackImage = null;
    transient BufferedImage mSmallInGameImage = null;

    public String getName() {
        return this.mName;
    }

    public void setName(String n) {
        this.mName = n;
    }

    public String getCClass() {
        return this.mClass;
    }

    public void setCClass(String c) {
        this.mClass = c;
    }

    public String getCartName() {
        return this.mCartName;
    }

    public void setCartName(String CartName) {
        this.mCartName = CartName;
    }

    public String getAuthor() {
        return this.mAuthor;
    }

    public void setAuthor(String Author) {
        this.mAuthor = Author;
    }

    public String getYear() {
        return this.mYear;
    }

    public void setYear(String Year) {
        this.mYear = Year;
    }

    public int getCRC() {
        return this.mCRC;
    }

    public void setCRC(int CRC) {
        this.mCRC = CRC;
    }

    public int getTypeFlags() {
        return this.mTypeFlags;
    }

    public void setTypeFlags(int TypeFlags) {
        this.mTypeFlags = TypeFlags;
    }

    public Vector<String> getFullFilename() {
        return this.mFullFilename;
    }

    public void setFullFilename(Vector<String> FullFilename) {
        this.mFullFilename = FullFilename;
    }

    public String getInformation() {
        return this.mInformation;
    }

    public void setInformation(String Information) {
        this.mInformation = Information;
    }

    public String getCheats() {
        return this.mCheats;
    }

    public void setCheats(String Cheats) {
        this.mCheats = Cheats;
    }

    public String getEastereggs() {
        return this.mEastereggs;
    }

    public void setEastereggs(String Eastereggs) {
        this.mEastereggs = Eastereggs;
    }

    public String getHomepage() {
        return this.mHomepage;
    }

    public void setHomepage(String Homepage) {
        this.mHomepage = Homepage;
    }

    public String getInstructionFile() {
        return this.mInstructionFile;
    }

    public void setInstructionFile(String InstructionFile) {
        this.mInstructionFile = InstructionFile;
    }

    public void setFrontImage(String FrontImage) {
        this.mFrontImage = FrontImage;
    }

    public void setBackImage(String BackImage) {
        this.mBackImage = BackImage;
    }

    public void setOverlay(String Overlay) {
        this.mOverlay = Overlay;
    }

    public void setInGameImage(String InGameImage) {
        this.mInGameImage = InGameImage;
    }

    public String getCritic() {
        return this.mCritic;
    }

    public void setCritic(String Critic) {
        this.mCritic = Critic;
    }

    public String getOther() {
        return this.mOther;
    }

    public void setOther(String Other) {
        this.mOther = Other;
    }

    public String getBinaryLink() {
        return this.mBinaryLink;
    }

    public void setBinaryLink(String BinaryLink) {
        this.mBinaryLink = BinaryLink;
    }

    public String getLicence() {
        return this.mLicence;
    }

    public void setLicence(String Licence) {
        this.mLicence = Licence;
    }

    public String getCopyrightType() {
        return this.mCopyrightType;
    }

    public void setCopyrightType(String CopyrightType) {
        this.mCopyrightType = CopyrightType;
    }

    public String getPDFLink() {
        return this.mPDFLink;
    }

    public void setPDFLink(String PDFLink) {
        this.mPDFLink = PDFLink;
    }

    public String getPDFFile() {
        return this.mPDFFile;
    }

    public void setPDFFile(String PDFFile) {
        this.mPDFFile = PDFFile;
    }

    public void setCartridgeImage(String CartridgeImage) {
        this.mCartridgeImage = CartridgeImage;
    }

    public boolean getHomebrew() {
        return this.mHomebrew;
    }

    public void setHomebrew(boolean Homebrew) {
        this.mHomebrew = Homebrew;
    }

    public boolean getDemo() {
        return this.mDemo;
    }

    public void setDemo(boolean Demo) {
        this.mDemo = Demo;
    }

    public boolean getSnippet() {
        return this.mSnippet;
    }

    public void setSnippet(boolean Snippet) {
        this.mSnippet = Snippet;
    }

    public boolean getCompleteGame() {
        return this.mCompleteGame;
    }

    public void setCompleteGame(boolean CompleteGame) {
        this.mCompleteGame = CompleteGame;
    }

    public String getextremeVecFileImage() {
        return this.mextremeVecFileImage;
    }

    public void setextremeVecFileImage(String extremeVecFileImage) {
        this.mextremeVecFileImage = extremeVecFileImage;
    }

    public String getWheelName() {
        return this.mWheelName;
    }

    public void setWheelName(String WheelName) {
        this.mWheelName = WheelName;
    }

    public boolean getConfigOverwrite() {
        return this.mConfigOverwrite;
    }

    public void setConfigOverwrite(boolean ConfigOverwrite) {
        this.mConfigOverwrite = ConfigOverwrite;
    }

    public boolean getCF_AutoSync() {
        return this.mCF_AutoSync;
    }

    public void setCF_AutoSync(boolean CF_AutoSync) {
        this.mCF_AutoSync = CF_AutoSync;
    }

    public boolean getCF_AllowROMWrite() {
        return this.mCF_AllowROMWrite;
    }

    public void setCF_AllowROMWrite(boolean CF_AllowROMWrite) {
        this.mCF_AllowROMWrite = CF_AllowROMWrite;
    }

    public boolean getCF_ROM_PC_BreakPoints() {
        return this.mCF_ROM_PC_BreakPoints;
    }

    public void setCF_ROM_PC_BreakPoints(boolean CF_ROM_PC_BreakPoints) {
        this.mCF_ROM_PC_BreakPoints = CF_ROM_PC_BreakPoints;
    }

    public int getCF_IntegratorMaxX() {
        return this.mCF_IntegratorMaxX;
    }

    public void setCF_IntegratorMaxX(int CF_IntegratorMaxX) {
        this.mCF_IntegratorMaxX = CF_IntegratorMaxX;
    }

    public int getCF_IntegratorMaxY() {
        return this.mCF_IntegratorMaxY;
    }

    public void setCF_IntegratorMaxY(int CF_IntegratorMaxY) {
        this.mCF_IntegratorMaxY = CF_IntegratorMaxY;
    }

    public float getCF_OverlayThreshold() {
        return this.mCF_OverlayThreshold;
    }

    public void setCF_OverlayThreshold(float CF_OverlayThreshold) {
        this.mCF_OverlayThreshold = CF_OverlayThreshold;
    }

    public int getCF_DotdwellDivisor() {
        return this.mCF_DotdwellDivisor;
    }

    public void setCF_DotdwellDivisor(int CF_DotdwellDivisor) {
        this.mCF_DotdwellDivisor = CF_DotdwellDivisor;
    }

    private String exportXML() {
        StringBuffer s = new StringBuffer();
        s.append("\t<CartridgeProperties>\n");
        s.append("\t\t<Class>" + UtilityString.toXML(this.mClass) + "</Class>\n");
        s.append("\t\t<Name>" + UtilityString.toXML(this.mName) + "</Name>\n");
        s.append("\t\t<CartName>" + UtilityString.toXML(this.mCartName) + "</CartName>\n");
        s.append("\t\t<Author>" + UtilityString.toXML(this.mAuthor) + "</Author>\n");
        s.append("\t\t<Year>" + UtilityString.toXML(this.mYear) + "</Year>\n");
        s.append("\t\t<CRC>" + this.mCRC + "</CRC>\n");
        s.append("\t\t<TypeFlags>" + this.mTypeFlags + "</TypeFlags>\n");
        s.append("\t\t<FullFilenames>\n");
        for (int i = 0; i < this.mFullFilename.size(); ++i) {
            s.append("\t\t\t<FullFilename>" + UtilityString.toXML(this.mFullFilename.elementAt(i)) + "</FullFilename>\n");
        }
        s.append("\t\t</FullFilenames>\n");
        s.append("\t\t<Information>" + UtilityString.toXML(this.mInformation) + "</Information>\n");
        s.append("\t\t<Cheats>" + UtilityString.toXML(this.mCheats) + "</Cheats>\n");
        s.append("\t\t<Eastereggs>" + UtilityString.toXML(this.mEastereggs) + "</Eastereggs>\n");
        s.append("\t\t<Homepage>" + UtilityString.toXML(this.mHomepage) + "</Homepage>\n");
        s.append("\t\t<InstructionFile>" + UtilityString.toXML(this.mInstructionFile) + "</InstructionFile>\n");
        s.append("\t\t<FrontImage>" + UtilityString.toXML(this.mFrontImage) + "</FrontImage>\n");
        s.append("\t\t<BackImage>" + UtilityString.toXML(this.mBackImage) + "</BackImage>\n");
        s.append("\t\t<Overlay>" + UtilityString.toXML(this.mOverlay) + "</Overlay>\n");
        s.append("\t\t<InGameImage>" + UtilityString.toXML(this.mInGameImage) + "</InGameImage>\n");
        s.append("\t\t<Critic>" + UtilityString.toXML(this.mCritic) + "</Critic>\n");
        s.append("\t\t<Other>" + UtilityString.toXML(this.mOther) + "</Other>\n");
        s.append("\t\t<BinaryLink>" + UtilityString.toXML(this.mBinaryLink) + "</BinaryLink>\n");
        s.append("\t\t<Licence>" + UtilityString.toXML(this.mLicence) + "</Licence>\n");
        s.append("\t\t<CopyrightType>" + UtilityString.toXML(this.mCopyrightType) + "</CopyrightType>\n");
        s.append("\t\t<PDFLink>" + UtilityString.toXML(this.mPDFLink) + "</PDFLink>\n");
        s.append("\t\t<PDFFile>" + UtilityString.toXML(this.mPDFFile) + "</PDFFile>\n");
        s.append("\t\t<CartridgeImage>" + UtilityString.toXML(this.mCartridgeImage) + "</CartridgeImage>\n");
        s.append("\t\t<Homebrew>" + this.mHomebrew + "</Homebrew>\n");
        s.append("\t\t<Demo>" + this.mDemo + "</Demo>\n");
        s.append("\t\t<Snippet>" + this.mSnippet + "</Snippet>\n");
        s.append("\t\t<CompleteGame>" + this.mCompleteGame + "</CompleteGame>\n");
        s.append("\t\t<extremeVecFileImage>" + UtilityString.toXML(this.mextremeVecFileImage) + "</extremeVecFileImage>\n");
        s.append("\t\t<WheelName>" + UtilityString.toXML(this.mWheelName) + "</WheelName>\n");
        s.append("\t\t<ConfigOverwrite>" + this.mConfigOverwrite + "</ConfigOverwrite>\n");
        s.append("\t\t<CF_AutoSync>" + this.mCF_AutoSync + "</CF_AutoSync>\n");
        s.append("\t\t<CF_AllowROMWrite>" + this.mCF_AllowROMWrite + "</CF_AllowROMWrite>\n");
        s.append("\t\t<CF_ROM_PC_BreakPoints>" + this.mCF_ROM_PC_BreakPoints + "</CF_ROM_PC_BreakPoints>\n");
        s.append("\t\t<CF_IntegratorMaxX>" + this.mCF_IntegratorMaxX + "</CF_IntegratorMaxX>\n");
        s.append("\t\t<CF_IntegratorMaxY>" + this.mCF_IntegratorMaxY + "</CF_IntegratorMaxY>\n");
        s.append("\t\t<CF_OverlayThreshold>" + this.mCF_OverlayThreshold + "</CF_OverlayThreshold>\n");
        s.append("\t\t<CF_DotdwellDivisor>" + this.mCF_DotdwellDivisor + "</CF_DotdwellDivisor>\n");
        s.append("\t</CartridgeProperties>\n");
        return s.toString();
    }

    public String toString() {
        return this.mName;
    }

    public static CartridgePropertiesXMLHandler getXMLParseHandler() {
        return XMLHANDLER;
    }

    public static boolean saveCollectionAsXML(String filename, Collection<CartridgeProperties> col) {
        return CartridgeProperties.saveCollectionAsXML(Global.mBaseDir, filename, col);
    }

    public static boolean saveCollectionAsXML(String pathName, String filename, Collection<CartridgeProperties> col) {
        try {
            PrintWriter pw = new PrintWriter(pathName + filename, "UTF-8");
            pw.print("<?xml version=\"1.0\"?>\n");
            pw.print("<AllCartridgeProperties>\n");
            for (CartridgeProperties item : col) {
                pw.print(item.exportXML());
            }
            pw.print("</AllCartridgeProperties>\n");
            pw.close();
        }
        catch (IOException e) {
            System.err.println(e.toString());
            return false;
        }
        return true;
    }

    public static HashMap<String, CartridgeProperties> getHashMapFromXML(String filename) {
        HashMap<String, CartridgeProperties> filters = new HashMap<String, CartridgeProperties>();
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            CartridgePropertiesXMLHandler h = CartridgeProperties.getXMLParseHandler();
            saxParser.parse(Global.mBaseDir + filename, (DefaultHandler)h);
            filters = h.getLastHashMap();
        }
        catch (Throwable e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, e.toString(), "CartridgeProperties Load Error...", 1);
        }
        return filters;
    }

    public String getOverlay() {
        return this.mOverlay;
    }

    public String getCartridgeImage() {
        return this.mCartridgeImage;
    }

    public String getFrontImage() {
        return this.mFrontImage;
    }

    public String getBackImage() {
        return this.mBackImage;
    }

    public String getInGameImage() {
        return this.mInGameImage;
    }

    BufferedImage getImage(String filename, int w, int h) {
        File f = new File(Global.mainPathPrefix + filename);
        if (!f.exists()) {
            return null;
        }
        BufferedImage org2 = ImageCache.getImageCache().getImage(Global.mainPathPrefix + filename);
        return ImageCache.getImageCache().getDerivatScale(org2, w, h);
    }

    public static String convertSeperator(String filename) {
        String ret = UtilityString.replace(filename, "/", File.separator);
        ret = UtilityString.replace(ret, "\\", File.separator);
        return ret;
    }

    public BufferedImage getSmallCartridgeImage() {
        if (this.mSmallCartridgeImage == null) {
            this.mSmallCartridgeImage = this.getImage(CartridgeProperties.convertSeperator(this.getCartridgeImage()), 100, 100);
        }
        return this.mSmallCartridgeImage;
    }

    public BufferedImage getSmallFrontImage() {
        if (this.mSmallFrontImage == null) {
            this.mSmallFrontImage = this.getImage(CartridgeProperties.convertSeperator(this.getFrontImage()), 60, 100);
        }
        return this.mSmallFrontImage;
    }

    public BufferedImage getSmallBackImage() {
        if (this.mSmallBackImage == null) {
            this.mSmallBackImage = this.getImage(CartridgeProperties.convertSeperator(this.getBackImage()), 60, 100);
        }
        return this.mSmallBackImage;
    }

    public BufferedImage getSmallInGameImage() {
        if (this.mSmallInGameImage == null) {
            this.mSmallInGameImage = this.getImage(CartridgeProperties.convertSeperator(this.getInGameImage()), 60, 100);
        }
        return this.mSmallInGameImage;
    }
}

