/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.vecx.cartridge;

import de.malban.Global;
import de.malban.config.Configuration;
import de.malban.graphics.SingleImagePanel;
import de.malban.gui.CSAMainFrame;
import de.malban.gui.HotKey;
import de.malban.gui.Stateable;
import de.malban.gui.Windowable;
import de.malban.gui.components.CSAView;
import de.malban.gui.dialogs.InternalFrameFileChoser;
import de.malban.gui.panels.LogPanel;
import de.malban.util.Downloader;
import de.malban.util.DownloaderPanel;
import de.malban.util.Utility;
import de.malban.util.UtilityFiles;
import de.malban.util.UtilityImage;
import de.malban.util.UtilityString;
import de.malban.vide.VideConfig;
import de.malban.vide.vecx.cartridge.Cartridge;
import de.malban.vide.vecx.cartridge.CartridgeProperties;
import de.malban.vide.vecx.cartridge.CartridgePropertiesPool;
import de.malban.vide.vedi.project.FileChooserCellEditor;
import de.muntjak.tinylookandfeel.Theme;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;

public class CartridgePropertiesPanel
extends JPanel
implements Windowable,
Stateable {
    transient LogPanel log = (LogPanel)Configuration.getConfiguration().getDebugEntity();
    private CartridgeProperties mCartridgeProperties = new CartridgeProperties();
    private CartridgePropertiesPool mCartridgePropertiesPool;
    private int mClassSetting = 0;
    private CSAView mParent = null;
    private boolean init = false;
    private JMenuItem mParentMenuItem = null;
    BankMainTableModel model = new BankMainTableModel();
    public static String SID = "Cartridge Editor";
    String lastImagePath = "";
    private JButton jButtonDelete;
    private JButton jButtonDownloadConfig;
    private JButton jButtonFileSelect1;
    private JButton jButtonFileSelect10;
    private JButton jButtonFileSelect11;
    private JButton jButtonFileSelect12;
    private JButton jButtonFileSelect13;
    private JButton jButtonFileSelect14;
    private JButton jButtonFileSelect15;
    private JButton jButtonFileSelect3;
    private JButton jButtonFileSelect4;
    private JButton jButtonFileSelect5;
    private JButton jButtonFileSelect6;
    private JButton jButtonFileSelect7;
    private JButton jButtonFileSelect8;
    private JButton jButtonFileSelect9;
    private JButton jButtonNew;
    private JButton jButtonNew1;
    private JButton jButtonNew2;
    private JButton jButtonNew3;
    private JButton jButtonNew4;
    private JButton jButtonSave;
    private JButton jButtonSaveAsNew;
    private JCheckBox jCheckBox1;
    private JCheckBox jCheckBox10;
    private JCheckBox jCheckBox11;
    private JCheckBox jCheckBox12;
    private JCheckBox jCheckBox13;
    private JCheckBox jCheckBox14;
    private JCheckBox jCheckBox15;
    private JCheckBox jCheckBox16;
    private JCheckBox jCheckBox17;
    private JCheckBox jCheckBox18;
    private JCheckBox jCheckBox19;
    private JCheckBox jCheckBox2;
    private JCheckBox jCheckBox20;
    private JCheckBox jCheckBox21;
    private JCheckBox jCheckBox22;
    private JCheckBox jCheckBox23;
    private JCheckBox jCheckBox24;
    private JCheckBox jCheckBox25;
    private JCheckBox jCheckBox26;
    private JCheckBox jCheckBox3;
    private JCheckBox jCheckBox4;
    private JCheckBox jCheckBox5;
    private JCheckBox jCheckBox6;
    private JCheckBox jCheckBox7;
    private JCheckBox jCheckBox8;
    private JCheckBox jCheckBox9;
    private JCheckBox jCheckBoxAllowROMWrite;
    private JCheckBox jCheckBoxAutoSync;
    private JCheckBox jCheckBoxBreakpoint;
    private JCheckBox jCheckBoxEnableOverwrite;
    private JCheckBox jCheckBoxPB6IRQ;
    private JCheckBox jCheckBoxXmas;
    private JCheckBox jCheckBoxXmas1;
    private JComboBox jComboBoxImager;
    private JComboBox jComboBoxKlasse;
    private JComboBox jComboBoxName;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel16;
    private JLabel jLabel17;
    private JLabel jLabel18;
    private JLabel jLabel19;
    private JLabel jLabel2;
    private JLabel jLabel20;
    private JLabel jLabel21;
    private JLabel jLabel22;
    private JLabel jLabel3;
    private JLabel jLabel31;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel85;
    private JLabel jLabel86;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel10;
    private JPanel jPanel11;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JPanel jPanel8;
    private JPanel jPanel9;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane4;
    private JScrollPane jScrollPane5;
    private JScrollPane jScrollPane6;
    private JTabbedPane jTabbedPane1;
    private JTable jTable1;
    private JTextField jTextField1;
    private JTextField jTextField11;
    private JTextField jTextField12;
    private JTextField jTextField2;
    private JTextField jTextField29;
    private JTextField jTextField3;
    private JTextField jTextField30;
    private JTextField jTextField4;
    private JTextField jTextFieldKlasse;
    private JTextField jTextFieldName;
    private JTextField jTextFieldPath;
    private JTextField jTextFieldPath1;
    private JTextField jTextFieldPath10;
    private JTextField jTextFieldPath11;
    private JTextField jTextFieldPath12;
    private JTextField jTextFieldPath2;
    private JTextField jTextFieldPath3;
    private JTextField jTextFieldPath4;
    private JTextField jTextFieldPath5;
    private JTextField jTextFieldPath6;
    private JTextField jTextFieldPath7;
    private JTextField jTextFieldPath8;
    private JTextField jTextFieldPath9;
    private JTextPane jTextPane1;
    private JTextPane jTextPane2;
    private JTextPane jTextPane3;
    private JTextPane jTextPane4;
    private JTextPane jTextPane5;
    private SingleImagePanel singleImagePanel1;
    private SingleImagePanel singleImagePanel2;
    private SingleImagePanel singleImagePanel3;
    private SingleImagePanel singleImagePanel4;
    private SingleImagePanel singleImagePanel5;
    private PropertyChangeListener pListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            CartridgePropertiesPanel.this.updateMyUI();
        }
    };

    @Override
    public boolean isLoadSettings() {
        return true;
    }

    @Override
    public String getID() {
        return SID;
    }

    @Override
    public String getFileID() {
        return UtilityString.replace(UtilityString.replace(UtilityString.replace(UtilityString.replaceWhiteSpaces(SID, ""), ":", ""), "(", ""), ")", "");
    }

    @Override
    public Serializable getAdditionalStateinfo() {
        return null;
    }

    @Override
    public void setAdditionalStateinfo(Serializable ser) {
    }

    @Override
    public void closing() {
        this.deinit();
    }

    @Override
    public void setParentWindow(CSAView jpv) {
        this.mParent = jpv;
    }

    @Override
    public void setMenuItem(JMenuItem item) {
        this.mParentMenuItem = item;
        this.mParentMenuItem.setText(SID);
    }

    @Override
    public JMenuItem getMenuItem() {
        return this.mParentMenuItem;
    }

    @Override
    public boolean isIcon() {
        CSAMainFrame frame = Configuration.getConfiguration().getMainFrame();
        if (frame.getInternalFrame(this) == null) {
            return false;
        }
        return frame.getInternalFrame(this).isIcon();
    }

    @Override
    public void setIcon(boolean b) {
        CSAMainFrame frame = Configuration.getConfiguration().getMainFrame();
        if (frame.getInternalFrame(this) == null) {
            return;
        }
        try {
            frame.getInternalFrame(this).setIcon(b);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public JPanel getPanel() {
        return this;
    }

    public void deinit() {
        this.init = false;
        this.removeUIListerner();
    }

    public CartridgePropertiesPanel() {
        this.initComponents();
        if (Global.getOSName().toUpperCase().contains("MAC")) {
            HotKey.addMacDefaults(this.jTextFieldName);
            HotKey.addMacDefaults(this.jTextField1);
            HotKey.addMacDefaults(this.jTextField2);
            HotKey.addMacDefaults(this.jTextField3);
            HotKey.addMacDefaults(this.jTextField4);
            HotKey.addMacDefaults(this.jTextField12);
            HotKey.addMacDefaults(this.jTextFieldPath);
            HotKey.addMacDefaults(this.jTextFieldPath1);
            HotKey.addMacDefaults(this.jTextFieldPath2);
            HotKey.addMacDefaults(this.jTextFieldPath3);
            HotKey.addMacDefaults(this.jTextPane1);
            HotKey.addMacDefaults(this.jTextFieldPath4);
            HotKey.addMacDefaults(this.jTextFieldPath5);
            HotKey.addMacDefaults(this.jTextFieldPath6);
            HotKey.addMacDefaults(this.jTextFieldPath7);
            HotKey.addMacDefaults(this.jTextFieldPath8);
            HotKey.addMacDefaults(this.jTextFieldPath9);
            HotKey.addMacDefaults(this.jTextPane2);
            HotKey.addMacDefaults(this.jTextFieldPath10);
            HotKey.addMacDefaults(this.jTextFieldPath11);
            HotKey.addMacDefaults(this.jTextFieldPath4);
            HotKey.addMacDefaults(this.jTextPane3);
            HotKey.addMacDefaults(this.jTextPane4);
            HotKey.addMacDefaults(this.jTextPane5);
            HotKey.addMacDefaults(this.jTextField11);
            HotKey.addMacDefaults(this.jTextField12);
            HotKey.addMacDefaults(this.jTextField29);
            HotKey.addMacDefaults(this.jTextField30);
        }
        this.jTable1.setModel(this.model);
        this.updateTable();
        this.initImager();
        this.mCartridgePropertiesPool = new CartridgePropertiesPool();
        this.singleImagePanel3.setPreferredSize(new Dimension(138, 198));
        this.singleImagePanel3.setBounds(this.singleImagePanel3.getBounds().x, this.singleImagePanel3.getBounds().y, 138, 198);
        this.resetConfigPool(true, "Cartridge");
        this.init = true;
        UIManager.addPropertyChangeListener(this.pListener);
        this.updateMyUI();
    }

    private void updateTable() {
        this.jTable1.getColumnModel().getColumn(1).setCellEditor(new FileChooserCellEditor("." + File.separator));
        this.jTable1.getColumnModel().getColumn(0).setPreferredWidth(5);
        this.jTable1.getColumnModel().getColumn(0).setWidth(5);
        this.jTable1.getColumnModel().getColumn(1).setPreferredWidth(200);
        this.jTable1.getColumnModel().getColumn(1).setWidth(200);
    }

    public static CartridgeProperties getCartridgeProp(String someName) {
        CartridgeProperties cart = null;
        try {
            CartridgePropertiesPool pool = new CartridgePropertiesPool();
            Collection<CartridgeProperties> colC = pool.getHashMap().values();
            Iterator<CartridgeProperties> iterC = colC.iterator();
            Path p = Paths.get(someName, new String[0]);
            String nameOnly = p.getFileName().toString().toLowerCase();
            String justName = nameOnly.substring(0, nameOnly.length() - 4);
            while (iterC.hasNext()) {
                CartridgeProperties item = iterC.next();
                if (item.getFullFilename().size() <= 0) continue;
                p = Paths.get(UtilityFiles.convertSeperator(item.getFullFilename().elementAt(0)), new String[0]);
                String itemNameOnly = p.getFileName().toString().toLowerCase();
                if (nameOnly.equals(itemNameOnly)) {
                    return item;
                }
                String justItemName = itemNameOnly.substring(0, itemNameOnly.length() - 4);
                if (!justName.equals(justItemName)) continue;
                return item;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return cart;
    }

    private void resetConfigPool(boolean select, String klasseToSet) {
        ++this.mClassSetting;
        Collection<String> collectionKlasse = this.mCartridgePropertiesPool.getKlassenHashMap().values();
        Iterator<String> iterKlasse = collectionKlasse.iterator();
        int i = 0;
        String klasse = "";
        this.jComboBoxKlasse.removeAllItems();
        while (iterKlasse.hasNext()) {
            String item = iterKlasse.next();
            this.jComboBoxKlasse.addItem(item);
            if (select) {
                if (klasseToSet.length() == 0) {
                    if (i == 0) {
                        this.jComboBoxKlasse.setSelectedIndex(i);
                        this.jTextFieldKlasse.setText(item);
                        klasse = item;
                    }
                } else if (klasseToSet.equalsIgnoreCase(item)) {
                    this.jComboBoxKlasse.setSelectedIndex(i);
                    this.jTextFieldKlasse.setText(item);
                    klasse = item;
                }
            }
            ++i;
        }
        if (select && klasse.length() == 0 && this.jComboBoxKlasse.getItemCount() > 0) {
            this.jComboBoxKlasse.setSelectedIndex(0);
            this.jTextFieldKlasse.setText(this.jComboBoxKlasse.getSelectedItem().toString());
            klasse = this.jComboBoxKlasse.getSelectedItem().toString();
        }
        if (!select) {
            this.jComboBoxKlasse.setSelectedIndex(-1);
        }
        Collection<CartridgeProperties> colC = this.mCartridgePropertiesPool.getMapForKlasse(klasse).values();
        Iterator<CartridgeProperties> iterC = colC.iterator();
        Vector<String> nnames = new Vector<String>();
        while (iterC.hasNext()) {
            nnames.addElement(iterC.next().mName);
        }
        Collections.sort(nnames, new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                return s1.compareTo(s2);
            }
        });
        this.jComboBoxName.removeAllItems();
        i = 0;
        for (int j = 0; j < nnames.size(); ++j) {
            String name = (String)nnames.elementAt(j);
            this.jComboBoxName.addItem(name);
            if (i == 0 && select) {
                this.jComboBoxName.setSelectedIndex(0);
                this.mCartridgeProperties = this.mCartridgePropertiesPool.get(name);
                this.setAllFromCurrent();
            }
            ++i;
        }
        if (!select) {
            this.jComboBoxName.setSelectedIndex(-1);
        }
        --this.mClassSetting;
    }

    private void clearAll() {
        ++this.mClassSetting;
        this.mCartridgeProperties = new CartridgeProperties();
        this.mCartridgeProperties.mClass = "Cartridge";
        this.jTextPane2.setText("");
        this.jTextPane3.setText("");
        this.singleImagePanel1.unsetImage();
        this.singleImagePanel2.unsetImage();
        this.singleImagePanel3.unsetImage();
        this.singleImagePanel4.unsetImage();
        this.singleImagePanel5.unsetImage();
        this.setAllFromCurrent();
        --this.mClassSetting;
    }

    private void setAllFromCurrent() {
        FileReader fr;
        String name;
        ++this.mClassSetting;
        this.jComboBoxKlasse.setSelectedItem(this.mCartridgeProperties.mClass);
        this.jTextFieldKlasse.setText(this.mCartridgeProperties.mClass);
        this.jComboBoxName.setSelectedItem(this.mCartridgeProperties.mName);
        this.jTextFieldName.setText(this.mCartridgeProperties.mName);
        this.jTextField2.setText(this.mCartridgeProperties.mCartName);
        this.jTextField1.setText(this.mCartridgeProperties.mAuthor);
        this.jTextField3.setText(this.mCartridgeProperties.mYear);
        this.jTextField4.setText("" + this.mCartridgeProperties.mCRC);
        this.jTextField1.setText(this.mCartridgeProperties.mInformation);
        this.jTextPane4.setText(this.mCartridgeProperties.mCheats);
        this.jTextPane5.setText(this.mCartridgeProperties.mEastereggs);
        this.jTextFieldPath.setText(this.mCartridgeProperties.mHomepage);
        this.jTextFieldPath4.setText(this.mCartridgeProperties.mInstructionFile);
        this.jTextFieldPath10.setText(this.mCartridgeProperties.mCartridgeImage);
        this.jTextFieldPath5.setText(this.mCartridgeProperties.mFrontImage);
        this.jTextFieldPath6.setText(this.mCartridgeProperties.mBackImage);
        this.jTextFieldPath2.setText(this.mCartridgeProperties.mOverlay);
        this.jTextFieldPath7.setText(this.mCartridgeProperties.mCritic);
        this.jTextFieldPath1.setText(this.mCartridgeProperties.mBinaryLink);
        this.jTextPane1.setText(this.mCartridgeProperties.mLicence);
        this.jTextFieldPath3.setText(this.mCartridgeProperties.mCopyrightType);
        this.jTextFieldPath8.setText(this.mCartridgeProperties.mPDFLink);
        this.jTextFieldPath9.setText(this.mCartridgeProperties.mPDFFile);
        this.jTextFieldPath11.setText(this.mCartridgeProperties.mInGameImage);
        this.jCheckBox11.setSelected(this.mCartridgeProperties.mCompleteGame);
        this.jCheckBox12.setSelected(this.mCartridgeProperties.mDemo);
        this.jCheckBox13.setSelected(this.mCartridgeProperties.mSnippet);
        this.jCheckBox14.setSelected(this.mCartridgeProperties.mHomebrew);
        int flag = this.mCartridgeProperties.mTypeFlags;
        this.jCheckBox1.setSelected((flag & Cartridge.FLAG_VEC_VOICE) != 0);
        this.jCheckBox2.setSelected((flag & Cartridge.FLAG_DS2430A) != 0);
        this.jCheckBox16.setSelected((flag & Cartridge.FLAG_MICROCHIP) != 0);
        this.jCheckBox9.setSelected((flag & Cartridge.FLAG_RAM_ANIMACTION) != 0);
        this.jCheckBox10.setSelected((flag & Cartridge.FLAG_RAM_RA_SPECTRUM) != 0);
        this.jCheckBox3.setSelected((flag & Cartridge.FLAG_LIGHTPEN1) != 0);
        this.jCheckBox4.setSelected((flag & Cartridge.FLAG_LIGHTPEN2) != 0);
        this.jCheckBox5.setSelected((flag & Cartridge.FLAG_IMAGER) != 0);
        this.jCheckBox6.setSelected((flag & Cartridge.FLAG_EXTREME_MULTI) != 0);
        this.jCheckBox7.setSelected((flag & Cartridge.FLAG_BANKSWITCH_DONDZILA) != 0);
        this.jCheckBox8.setSelected((flag & Cartridge.FLAG_BANKSWITCH_VECFLASH) != 0);
        this.jCheckBox15.setSelected((flag & Cartridge.FLAG_VEC_VOX) != 0);
        this.jCheckBox17.setSelected((flag & Cartridge.FLAG_DUALVEC1) != 0);
        this.jCheckBox18.setSelected((flag & Cartridge.FLAG_DUALVEC2) != 0);
        this.jCheckBox19.setSelected((flag & Cartridge.FLAG_LOGO) != 0);
        this.jCheckBoxXmas.setSelected((flag & Cartridge.FLAG_XMAS) != 0);
        this.jCheckBox20.setSelected((flag & Cartridge.FLAG_DS2431) != 0);
        this.jCheckBox21.setSelected((flag & Cartridge.FLAG_32K_ONLY) != 0);
        this.jCheckBox22.setSelected((flag & Cartridge.FLAG_SID) != 0);
        this.jCheckBox23.setSelected((flag & Cartridge.FLAG_48K) != 0);
        this.jCheckBoxPB6IRQ.setSelected((flag & Cartridge.FLAG_BS_PB6_IRQ) != 0);
        this.jCheckBox26.setSelected((flag & Cartridge.FLAG_ATMEL_EEPROM) != 0);
        this.jCheckBox25.setSelected((flag & Cartridge.FLAG_PIC_EEPROM) != 0);
        this.jCheckBoxXmas1.setSelected((flag & Cartridge.FLAG_V4E_16K_BS) != 0);
        this.jCheckBox24.setSelected((flag & Cartridge.FLAG_KEYBOARD) != 0);
        this.jCheckBoxEnableOverwrite.setSelected(this.mCartridgeProperties.mConfigOverwrite);
        this.jCheckBoxAutoSync.setSelected(this.mCartridgeProperties.mCF_AutoSync);
        this.jCheckBoxAllowROMWrite.setSelected(this.mCartridgeProperties.mCF_AllowROMWrite);
        this.jCheckBoxBreakpoint.setSelected(this.mCartridgeProperties.mCF_ROM_PC_BreakPoints);
        VideConfig config = VideConfig.getConfig();
        if (this.mCartridgeProperties.mCF_IntegratorMaxX == 0 || this.mCartridgeProperties.mCF_IntegratorMaxY == 0) {
            this.jTextField11.setText("" + config.ALG_MAX_X);
            this.jTextField12.setText("" + config.ALG_MAX_Y);
        } else {
            this.jTextField11.setText("" + this.mCartridgeProperties.mCF_IntegratorMaxX);
            this.jTextField12.setText("" + this.mCartridgeProperties.mCF_IntegratorMaxY);
        }
        if (this.mCartridgeProperties.mCF_OverlayThreshold == 0.0f) {
            this.jTextField30.setText("" + config.JOGLOverlayAlphaThreshold);
        } else {
            this.jTextField30.setText("" + this.mCartridgeProperties.mCF_OverlayThreshold);
        }
        if (this.mCartridgeProperties.mCF_DotdwellDivisor == 0) {
            this.jTextField29.setText("" + config.JOGLDotDwellDivisor);
        } else {
            this.jTextField29.setText("" + this.mCartridgeProperties.mCF_DotdwellDivisor);
        }
        this.jComboBoxImager.setSelectedIndex(-1);
        if ((flag & Cartridge.FLAG_IMAGER) != 0 && (name = this.mCartridgeProperties.mWheelName.trim()).length() > 0) {
            this.jComboBoxImager.setSelectedItem(name);
        }
        if (this.jTextFieldPath2.getText().trim().length() > 2) {
            this.singleImagePanel3.setImage(Global.mainPathPrefix + CartridgePropertiesPanel.convertSeperator(this.jTextFieldPath2.getText()), true);
        }
        if (this.jTextFieldPath5.getText().trim().length() > 2) {
            this.singleImagePanel1.setImage(Global.mainPathPrefix + CartridgePropertiesPanel.convertSeperator(this.jTextFieldPath5.getText()), true);
        }
        if (this.jTextFieldPath6.getText().trim().length() > 2) {
            this.singleImagePanel2.setImage(Global.mainPathPrefix + CartridgePropertiesPanel.convertSeperator(this.jTextFieldPath6.getText()), true);
        }
        if (this.jTextFieldPath10.getText().trim().length() > 2) {
            this.singleImagePanel4.setImage(Global.mainPathPrefix + CartridgePropertiesPanel.convertSeperator(this.jTextFieldPath10.getText()), true);
        }
        if (this.jTextFieldPath11.getText().trim().length() > 2) {
            this.singleImagePanel5.setImage(Global.mainPathPrefix + CartridgePropertiesPanel.convertSeperator(this.jTextFieldPath11.getText()), true);
        }
        if (this.jTextFieldPath4.getText().trim().length() > 2) {
            try {
                fr = new FileReader(Global.mainPathPrefix + CartridgePropertiesPanel.convertSeperator(this.jTextFieldPath4.getText()));
                this.jTextPane2.read(fr, null);
                fr.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (this.jTextFieldPath7.getText().trim().length() > 2) {
            try {
                fr = new FileReader(Global.mainPathPrefix + CartridgePropertiesPanel.convertSeperator(this.jTextFieldPath7.getText()));
                this.jTextPane3.read(fr, null);
                fr.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.jComboBoxImager.setEnabled(this.jCheckBox5.isSelected());
        this.jButtonFileSelect15.setEnabled(this.jCheckBox6.isSelected());
        this.jTextFieldPath12.setEnabled(this.jCheckBox6.isSelected());
        this.jTextFieldPath12.setText(this.mCartridgeProperties.mextremeVecFileImage);
        this.updateTable();
        --this.mClassSetting;
    }

    private void readAllToCurrent() {
        String filename;
        String videFilenameBase = "documents" + File.separator + "games" + File.separator + this.mCartridgeProperties.mName + "_";
        String textFilenameBase = Global.mainPathPrefix + videFilenameBase;
        if (this.jTextPane2.getText().trim().length() > 2) {
            if (this.jTextFieldPath4.getText().trim().length() < 2) {
                filename = textFilenameBase + "instructions.txt";
                UtilityFiles.createTextFile(filename, this.jTextPane2.getText());
                this.jTextFieldPath4.setText(videFilenameBase + "instructions.txt");
            } else {
                filename = this.jTextFieldPath4.getText();
                filename = UtilityFiles.convertSeperator(filename);
                UtilityFiles.createTextFile(Global.mainPathPrefix + filename, this.jTextPane2.getText());
                this.jTextFieldPath4.setText(filename);
            }
        }
        if (this.jTextPane3.getText().trim().length() > 2) {
            if (this.jTextFieldPath7.getText().trim().length() < 2) {
                filename = textFilenameBase + "critics.txt";
                UtilityFiles.createTextFile(filename, this.jTextPane3.getText());
                this.jTextFieldPath7.setText(videFilenameBase + "critics.txt");
            } else {
                filename = this.jTextFieldPath7.getText();
                filename = UtilityFiles.convertSeperator(filename);
                UtilityFiles.createTextFile(Global.mainPathPrefix + filename, this.jTextPane3.getText());
                this.jTextFieldPath7.setText(filename);
            }
        }
        this.mCartridgeProperties.mClass = this.jTextFieldKlasse.getText();
        this.mCartridgeProperties.mName = this.jTextFieldName.getText();
        this.mCartridgeProperties.mConfigOverwrite = this.jCheckBoxEnableOverwrite.isSelected();
        this.mCartridgeProperties.mCF_AutoSync = this.jCheckBoxAutoSync.isSelected();
        this.mCartridgeProperties.mCF_AllowROMWrite = this.jCheckBoxAllowROMWrite.isSelected();
        this.mCartridgeProperties.mCF_ROM_PC_BreakPoints = this.jCheckBoxBreakpoint.isSelected();
        this.mCartridgeProperties.mCF_IntegratorMaxX = UtilityString.IntX(this.jTextField11.getText(), 38000);
        this.mCartridgeProperties.mCF_IntegratorMaxY = UtilityString.IntX(this.jTextField12.getText(), 41000);
        this.mCartridgeProperties.mCF_IntegratorMaxX = UtilityString.IntX(this.jTextField11.getText(), 38000);
        this.mCartridgeProperties.mCF_IntegratorMaxY = UtilityString.IntX(this.jTextField12.getText(), 41000);
        this.mCartridgeProperties.mCF_OverlayThreshold = UtilityString.FloatX(this.jTextField30.getText(), 0.8f);
        this.mCartridgeProperties.mCF_DotdwellDivisor = UtilityString.IntX(this.jTextField29.getText(), 25);
        this.mCartridgeProperties.mCartName = this.jTextField2.getText();
        this.mCartridgeProperties.mAuthor = this.jTextField1.getText();
        this.mCartridgeProperties.mYear = this.jTextField3.getText();
        this.mCartridgeProperties.mCRC = UtilityString.Int0(this.jTextField4.getText());
        this.mCartridgeProperties.mInformation = this.jTextField1.getText();
        this.mCartridgeProperties.mCheats = this.jTextPane4.getText();
        this.mCartridgeProperties.mEastereggs = this.jTextPane5.getText();
        this.mCartridgeProperties.mHomepage = this.jTextFieldPath.getText();
        this.mCartridgeProperties.mInstructionFile = this.jTextFieldPath4.getText();
        this.mCartridgeProperties.mCartridgeImage = this.jTextFieldPath10.getText();
        this.mCartridgeProperties.mFrontImage = this.jTextFieldPath5.getText();
        this.mCartridgeProperties.mBackImage = this.jTextFieldPath6.getText();
        this.mCartridgeProperties.mOverlay = this.jTextFieldPath2.getText();
        this.mCartridgeProperties.mCritic = this.jTextFieldPath7.getText();
        this.mCartridgeProperties.mBinaryLink = this.jTextFieldPath1.getText();
        this.mCartridgeProperties.mLicence = this.jTextPane1.getText();
        this.mCartridgeProperties.mCopyrightType = this.jTextFieldPath3.getText();
        this.mCartridgeProperties.mPDFLink = this.jTextFieldPath8.getText();
        this.mCartridgeProperties.mPDFFile = this.jTextFieldPath9.getText();
        this.mCartridgeProperties.mInGameImage = this.jTextFieldPath11.getText();
        this.mCartridgeProperties.mCompleteGame = this.jCheckBox11.isSelected();
        this.mCartridgeProperties.mDemo = this.jCheckBox12.isSelected();
        this.mCartridgeProperties.mSnippet = this.jCheckBox13.isSelected();
        this.mCartridgeProperties.mHomebrew = this.jCheckBox14.isSelected();
        String name = "";
        if (this.jComboBoxImager.getSelectedItem() != null) {
            name = this.jComboBoxImager.getSelectedItem().toString();
        }
        this.mCartridgeProperties.mWheelName = name;
        this.mCartridgeProperties.mextremeVecFileImage = this.jTextFieldPath12.getText();
        this.mCartridgeProperties.mOther = "";
        int flag = 0;
        if (this.jCheckBox1.isSelected()) {
            flag += Cartridge.FLAG_VEC_VOICE;
        }
        if (this.jCheckBox2.isSelected()) {
            flag += Cartridge.FLAG_DS2430A;
        }
        if (this.jCheckBox16.isSelected()) {
            flag += Cartridge.FLAG_MICROCHIP;
        }
        if (this.jCheckBox9.isSelected()) {
            flag += Cartridge.FLAG_RAM_ANIMACTION;
        }
        if (this.jCheckBox10.isSelected()) {
            flag += Cartridge.FLAG_RAM_RA_SPECTRUM;
        }
        if (this.jCheckBox3.isSelected()) {
            flag += Cartridge.FLAG_LIGHTPEN1;
        }
        if (this.jCheckBox4.isSelected()) {
            flag += Cartridge.FLAG_LIGHTPEN2;
        }
        if (this.jCheckBox5.isSelected()) {
            flag += Cartridge.FLAG_IMAGER;
        }
        if (this.jCheckBox6.isSelected()) {
            flag += Cartridge.FLAG_EXTREME_MULTI;
        }
        if (this.jCheckBox7.isSelected()) {
            flag += Cartridge.FLAG_BANKSWITCH_DONDZILA;
        }
        if (this.jCheckBox8.isSelected()) {
            flag += Cartridge.FLAG_BANKSWITCH_VECFLASH;
        }
        if (this.jCheckBox15.isSelected()) {
            flag += Cartridge.FLAG_VEC_VOX;
        }
        if (this.jCheckBox17.isSelected()) {
            flag += Cartridge.FLAG_DUALVEC1;
        }
        if (this.jCheckBox18.isSelected()) {
            flag += Cartridge.FLAG_DUALVEC2;
        }
        if (this.jCheckBox19.isSelected()) {
            flag += Cartridge.FLAG_LOGO;
        }
        if (this.jCheckBoxXmas.isSelected()) {
            flag += Cartridge.FLAG_XMAS;
        }
        if (this.jCheckBox20.isSelected()) {
            flag += Cartridge.FLAG_DS2431;
        }
        if (this.jCheckBox21.isSelected()) {
            flag += Cartridge.FLAG_32K_ONLY;
        }
        if (this.jCheckBox22.isSelected()) {
            flag += Cartridge.FLAG_SID;
        }
        if (this.jCheckBox23.isSelected()) {
            flag += Cartridge.FLAG_48K;
        }
        if (this.jCheckBox26.isSelected()) {
            flag += Cartridge.FLAG_ATMEL_EEPROM;
        }
        if (this.jCheckBox25.isSelected()) {
            flag += Cartridge.FLAG_PIC_EEPROM;
        }
        if (this.jCheckBoxXmas1.isSelected()) {
            flag += Cartridge.FLAG_V4E_16K_BS;
        }
        if (this.jCheckBox24.isSelected()) {
            flag += Cartridge.FLAG_KEYBOARD;
        }
        if (this.jCheckBoxPB6IRQ.isSelected()) {
            flag += Cartridge.FLAG_BS_PB6_IRQ + Cartridge.FLAG_FLASH_SUPPORT;
        }
        this.mCartridgeProperties.mTypeFlags = flag;
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jComboBoxKlasse = new JComboBox();
        this.jComboBoxName = new JComboBox();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jTextFieldName = new JTextField();
        this.jTextFieldKlasse = new JTextField();
        this.jButtonNew = new JButton();
        this.jButtonSave = new JButton();
        this.jButtonSaveAsNew = new JButton();
        this.jButtonDelete = new JButton();
        this.jPanel2 = new JPanel();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel3 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jTextField1 = new JTextField();
        this.jTextField2 = new JTextField();
        this.jLabel2 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jTextField3 = new JTextField();
        this.jLabel6 = new JLabel();
        this.jTextField4 = new JTextField();
        this.jPanel5 = new JPanel();
        this.jCheckBox1 = new JCheckBox();
        this.jCheckBox2 = new JCheckBox();
        this.jCheckBox3 = new JCheckBox();
        this.jCheckBox4 = new JCheckBox();
        this.jCheckBox5 = new JCheckBox();
        this.jCheckBox6 = new JCheckBox();
        this.jCheckBox7 = new JCheckBox();
        this.jCheckBox8 = new JCheckBox();
        this.jCheckBox9 = new JCheckBox();
        this.jCheckBox10 = new JCheckBox();
        this.jCheckBox15 = new JCheckBox();
        this.jCheckBox16 = new JCheckBox();
        this.jCheckBox17 = new JCheckBox();
        this.jCheckBox18 = new JCheckBox();
        this.jCheckBox19 = new JCheckBox();
        this.jComboBoxImager = new JComboBox();
        this.jTextFieldPath12 = new JTextField();
        this.jButtonFileSelect15 = new JButton();
        this.singleImagePanel3 = new SingleImagePanel();
        this.jCheckBoxXmas = new JCheckBox();
        this.jCheckBox20 = new JCheckBox();
        this.jCheckBox21 = new JCheckBox();
        this.jCheckBox22 = new JCheckBox();
        this.jCheckBox23 = new JCheckBox();
        this.jCheckBox24 = new JCheckBox();
        this.jCheckBoxXmas1 = new JCheckBox();
        this.jCheckBox25 = new JCheckBox();
        this.jCheckBox26 = new JCheckBox();
        this.jCheckBoxPB6IRQ = new JCheckBox();
        this.jButtonFileSelect1 = new JButton();
        this.jTextFieldPath = new JTextField();
        this.jLabel7 = new JLabel();
        this.jLabel8 = new JLabel();
        this.jTextFieldPath1 = new JTextField();
        this.jScrollPane2 = new JScrollPane();
        this.jTable1 = new JTable();
        this.jLabel9 = new JLabel();
        this.jLabel10 = new JLabel();
        this.jTextFieldPath2 = new JTextField();
        this.jButtonFileSelect3 = new JButton();
        this.jLabel11 = new JLabel();
        this.jTextFieldPath3 = new JTextField();
        this.jScrollPane1 = new JScrollPane();
        this.jTextPane1 = new JTextPane();
        this.jLabel12 = new JLabel();
        this.jButtonFileSelect10 = new JButton();
        this.jButtonFileSelect11 = new JButton();
        this.jButtonDownloadConfig = new JButton();
        this.jCheckBox11 = new JCheckBox();
        this.jCheckBox12 = new JCheckBox();
        this.jCheckBox13 = new JCheckBox();
        this.jCheckBox14 = new JCheckBox();
        this.jPanel4 = new JPanel();
        this.jLabel13 = new JLabel();
        this.jTextFieldPath4 = new JTextField();
        this.jButtonFileSelect4 = new JButton();
        this.jScrollPane3 = new JScrollPane();
        this.jTextPane2 = new JTextPane();
        this.jLabel19 = new JLabel();
        this.jTextFieldPath8 = new JTextField();
        this.jButtonFileSelect8 = new JButton();
        this.jLabel20 = new JLabel();
        this.jTextFieldPath9 = new JTextField();
        this.jButtonFileSelect9 = new JButton();
        this.jButtonFileSelect12 = new JButton();
        this.jPanel10 = new JPanel();
        this.singleImagePanel4 = new SingleImagePanel();
        this.jButtonNew3 = new JButton();
        this.jButtonFileSelect13 = new JButton();
        this.jTextFieldPath10 = new JTextField();
        this.jLabel21 = new JLabel();
        this.jPanel6 = new JPanel();
        this.jLabel14 = new JLabel();
        this.jTextFieldPath5 = new JTextField();
        this.jButtonFileSelect5 = new JButton();
        this.singleImagePanel1 = new SingleImagePanel();
        this.jButtonNew1 = new JButton();
        this.jPanel7 = new JPanel();
        this.jLabel15 = new JLabel();
        this.jTextFieldPath6 = new JTextField();
        this.jButtonFileSelect6 = new JButton();
        this.singleImagePanel2 = new SingleImagePanel();
        this.jButtonNew2 = new JButton();
        this.jPanel8 = new JPanel();
        this.jLabel16 = new JLabel();
        this.jTextFieldPath7 = new JTextField();
        this.jButtonFileSelect7 = new JButton();
        this.jScrollPane4 = new JScrollPane();
        this.jTextPane3 = new JTextPane();
        this.jPanel9 = new JPanel();
        this.jLabel17 = new JLabel();
        this.jLabel18 = new JLabel();
        this.jScrollPane5 = new JScrollPane();
        this.jTextPane4 = new JTextPane();
        this.jScrollPane6 = new JScrollPane();
        this.jTextPane5 = new JTextPane();
        this.jLabel22 = new JLabel();
        this.jTextFieldPath11 = new JTextField();
        this.jButtonFileSelect14 = new JButton();
        this.jButtonNew4 = new JButton();
        this.singleImagePanel5 = new SingleImagePanel();
        this.jPanel11 = new JPanel();
        this.jCheckBoxEnableOverwrite = new JCheckBox();
        this.jCheckBoxAutoSync = new JCheckBox();
        this.jCheckBoxAllowROMWrite = new JCheckBox();
        this.jCheckBoxBreakpoint = new JCheckBox();
        this.jLabel31 = new JLabel();
        this.jTextField11 = new JTextField();
        this.jTextField12 = new JTextField();
        this.jLabel86 = new JLabel();
        this.jTextField30 = new JTextField();
        this.jLabel85 = new JLabel();
        this.jTextField29 = new JTextField();
        this.jPanel1.setBorder(BorderFactory.createEtchedBorder());
        this.jComboBoxKlasse.setModel(new DefaultComboBoxModel<String>(new String[]{"Cartridge"}));
        this.jComboBoxKlasse.setEnabled(false);
        this.jComboBoxKlasse.setPreferredSize(new Dimension(130, 21));
        this.jComboBoxKlasse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CartridgePropertiesPanel.this.jComboBoxKlasseActionPerformed(evt);
            }
        });
        this.jComboBoxName.setPreferredSize(new Dimension(130, 21));
        this.jComboBoxName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CartridgePropertiesPanel.this.jComboBoxNameActionPerformed(evt);
            }
        });
        this.jLabel3.setText("Name");
        this.jLabel4.setText("Class");
        this.jTextFieldName.setPreferredSize(new Dimension(110, 21));
        this.jTextFieldKlasse.setText("Cartridge");
        this.jTextFieldKlasse.setEnabled(false);
        this.jTextFieldKlasse.setPreferredSize(new Dimension(110, 21));
        this.jButtonNew.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/new.png")));
        this.jButtonNew.setText("New");
        this.jButtonNew.setPreferredSize(new Dimension(140, 21));
        this.jButtonNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CartridgePropertiesPanel.this.jButtonNewActionPerformed(evt);
            }
        });
        this.jButtonSave.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/disk.png")));
        this.jButtonSave.setText("Save");
        this.jButtonSave.setPreferredSize(new Dimension(140, 21));
        this.jButtonSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CartridgePropertiesPanel.this.jButtonSaveActionPerformed(evt);
            }
        });
        this.jButtonSaveAsNew.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/disk_add.png")));
        this.jButtonSaveAsNew.setText("Save new");
        this.jButtonSaveAsNew.setPreferredSize(new Dimension(140, 21));
        this.jButtonSaveAsNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CartridgePropertiesPanel.this.jButtonSaveAsNewActionPerformed(evt);
            }
        });
        this.jButtonDelete.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/cross.png")));
        this.jButtonDelete.setText("Delete");
        this.jButtonDelete.setPreferredSize(new Dimension(140, 21));
        this.jButtonDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CartridgePropertiesPanel.this.jButtonDeleteActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(6, 6, 6).addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldKlasse, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBoxKlasse, -2, -1, -2)).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldName, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBoxName, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonSave, -2, -1, -2).addComponent(this.jButtonNew, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonSaveAsNew, -2, -1, -2).addComponent(this.jButtonDelete, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonNew, -2, -1, -2).addComponent(this.jButtonDelete, -2, -1, -2).addGroup(jPanel1Layout.createSequentialGroup().addGap(1, 1, 1).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jComboBoxKlasse, -1, -1, Short.MAX_VALUE).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldKlasse, -1, -1, -2).addComponent(this.jLabel4))))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jComboBoxName, -1, -1, Short.MAX_VALUE).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldName, -1, -1, -2).addComponent(this.jLabel3)).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonSave, -2, -1, -2).addComponent(this.jButtonSaveAsNew, -2, -1, -2))).addGap(11, 11, 11)));
        this.jPanel3.setLayout(null);
        this.jLabel1.setText("Author");
        this.jLabel1.setPreferredSize(new Dimension(0, 21));
        this.jPanel3.add(this.jLabel1);
        this.jLabel1.setBounds(10, 40, 100, 21);
        this.jPanel3.add(this.jTextField1);
        this.jTextField1.setBounds(110, 40, 145, 21);
        this.jTextField2.setPreferredSize(new Dimension(6, 21));
        this.jPanel3.add(this.jTextField2);
        this.jTextField2.setBounds(110, 10, 145, 21);
        this.jLabel2.setText("Cart name");
        this.jLabel2.setPreferredSize(new Dimension(0, 21));
        this.jPanel3.add(this.jLabel2);
        this.jLabel2.setBounds(10, 14, 100, 21);
        this.jLabel5.setText("Year");
        this.jPanel3.add(this.jLabel5);
        this.jLabel5.setBounds(270, 40, 40, 21);
        this.jPanel3.add(this.jTextField3);
        this.jTextField3.setBounds(310, 40, 59, 21);
        this.jLabel6.setText("CRC");
        this.jPanel3.add(this.jLabel6);
        this.jLabel6.setBounds(270, 10, 40, 21);
        this.jPanel3.add(this.jTextField4);
        this.jTextField4.setBounds(310, 10, 59, 21);
        this.jCheckBox1.setText("VecVoice");
        this.jCheckBox1.setToolTipText("1. Generation Voice device, based on SPO256-AL2");
        this.jCheckBox1.setMargin(new Insets(0, 2, 1, 0));
        this.jCheckBox2.setText("DS2430A");
        this.jCheckBox2.setMargin(new Insets(0, 2, 1, 0));
        this.jCheckBox2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CartridgePropertiesPanel.this.jCheckBox2ActionPerformed(evt);
            }
        });
        this.jCheckBox3.setText("Lightpen 1");
        this.jCheckBox3.setMargin(new Insets(0, 2, 1, 0));
        this.jCheckBox4.setText("Lightpen 2");
        this.jCheckBox4.setMargin(new Insets(0, 2, 1, 0));
        this.jCheckBox5.setText("3d Imager");
        this.jCheckBox5.setMargin(new Insets(0, 2, 1, 0));
        this.jCheckBox5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CartridgePropertiesPanel.this.jCheckBox5ActionPerformed(evt);
            }
        });
        this.jCheckBox6.setText("extr. multi");
        this.jCheckBox6.setMargin(new Insets(0, 2, 1, 0));
        this.jCheckBox6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CartridgePropertiesPanel.this.jCheckBox6ActionPerformed(evt);
            }
        });
        this.jCheckBox7.setText("BS Dondzila");
        this.jCheckBox7.setMargin(new Insets(0, 2, 1, 0));
        this.jCheckBox8.setText("BS VecFlash");
        this.jCheckBox8.setMargin(new Insets(0, 2, 1, 0));
        this.jCheckBox9.setText("RAM Anim.");
        this.jCheckBox9.setMargin(new Insets(0, 2, 1, 0));
        this.jCheckBox9.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CartridgePropertiesPanel.this.jCheckBox9ActionPerformed(evt);
            }
        });
        this.jCheckBox10.setText("RAM RA ");
        this.jCheckBox10.setMargin(new Insets(0, 2, 1, 0));
        this.jCheckBox15.setText("VecVox");
        this.jCheckBox15.setToolTipText("2. Generation Voice device based on SpeakJet");
        this.jCheckBox15.setMargin(new Insets(0, 2, 1, 0));
        this.jCheckBox16.setText("Microchip");
        this.jCheckBox16.setMargin(new Insets(0, 2, 1, 0));
        this.jCheckBox17.setText("DualVec1");
        this.jCheckBox17.setMargin(new Insets(0, 2, 1, 0));
        this.jCheckBox18.setText("2");
        this.jCheckBox18.setMargin(new Insets(0, 2, 1, 0));
        this.jCheckBox18.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CartridgePropertiesPanel.this.jCheckBox18ActionPerformed(evt);
            }
        });
        this.jCheckBox19.setText("RAM Logo");
        this.jCheckBox19.setMargin(new Insets(0, 2, 1, 0));
        this.jComboBoxImager.setToolTipText("imager default wheel for the cartridge");
        this.jTextFieldPath12.setToolTipText("Bin file for extreme multi (in case of \"a la big apple\")");
        this.jTextFieldPath12.setEnabled(false);
        this.jTextFieldPath12.setPreferredSize(new Dimension(6, 21));
        this.jButtonFileSelect15.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/folder_go.png")));
        this.jButtonFileSelect15.setEnabled(false);
        this.jButtonFileSelect15.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonFileSelect15.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CartridgePropertiesPanel.this.jButtonFileSelect15ActionPerformed(evt);
            }
        });
        this.singleImagePanel3.setDrawCheckers(true);
        this.singleImagePanel3.setMaximumSize(new Dimension(138, 198));
        this.singleImagePanel3.setMinimumSize(new Dimension(138, 198));
        GroupLayout singleImagePanel3Layout = new GroupLayout(this.singleImagePanel3);
        this.singleImagePanel3.setLayout(singleImagePanel3Layout);
        singleImagePanel3Layout.setHorizontalGroup(singleImagePanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        singleImagePanel3Layout.setVerticalGroup(singleImagePanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 219, Short.MAX_VALUE));
        this.jCheckBoxXmas.setText("XMas LED");
        this.jCheckBoxXmas.setMargin(new Insets(0, 2, 1, 0));
        this.jCheckBoxXmas.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CartridgePropertiesPanel.this.jCheckBoxXmasActionPerformed(evt);
            }
        });
        this.jCheckBox20.setText("DS2431");
        this.jCheckBox20.setMargin(new Insets(0, 2, 1, 0));
        this.jCheckBox20.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CartridgePropertiesPanel.this.jCheckBox20ActionPerformed(evt);
            }
        });
        this.jCheckBox21.setText("32k forced");
        this.jCheckBox21.setMargin(new Insets(0, 2, 1, 0));
        this.jCheckBox22.setText("SID");
        this.jCheckBox22.setMargin(new Insets(0, 2, 1, 0));
        this.jCheckBox22.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CartridgePropertiesPanel.this.jCheckBox22ActionPerformed(evt);
            }
        });
        this.jCheckBox23.setText("48k ROM");
        this.jCheckBox23.setMargin(new Insets(0, 2, 1, 0));
        this.jCheckBox23.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CartridgePropertiesPanel.this.jCheckBox23ActionPerformed(evt);
            }
        });
        this.jCheckBox24.setText("Keyboard");
        this.jCheckBox24.setEnabled(false);
        this.jCheckBox24.setMargin(new Insets(0, 2, 1, 0));
        this.jCheckBox24.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CartridgePropertiesPanel.this.jCheckBox24ActionPerformed(evt);
            }
        });
        this.jCheckBoxXmas1.setText("16k BS");
        this.jCheckBoxXmas1.setMargin(new Insets(0, 2, 1, 0));
        this.jCheckBoxXmas1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CartridgePropertiesPanel.this.jCheckBoxXmas1ActionPerformed(evt);
            }
        });
        this.jCheckBox25.setText("PIC");
        this.jCheckBox25.setEnabled(false);
        this.jCheckBox25.setMargin(new Insets(0, 2, 1, 0));
        this.jCheckBox26.setText("Atmel");
        this.jCheckBox26.setMargin(new Insets(0, 2, 1, 0));
        this.jCheckBox26.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CartridgePropertiesPanel.this.jCheckBox26ActionPerformed(evt);
            }
        });
        this.jCheckBoxPB6IRQ.setText("BS PB6 & IRQ");
        this.jCheckBoxPB6IRQ.setMargin(new Insets(0, 2, 1, 0));
        this.jCheckBoxPB6IRQ.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CartridgePropertiesPanel.this.jCheckBoxPB6IRQActionPerformed(evt);
            }
        });
        GroupLayout jPanel5Layout = new GroupLayout(this.jPanel5);
        this.jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addGap(6, 6, 6).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBox5).addComponent(this.jCheckBox1).addComponent(this.jCheckBox2).addComponent(this.jCheckBox7).addComponent(this.jCheckBox19).addComponent(this.jCheckBox17).addComponent(this.jCheckBox8).addComponent(this.jCheckBox16).addComponent(this.jCheckBox9).addComponent(this.jCheckBox10).addComponent(this.jCheckBox3).addComponent(this.jCheckBox6).addComponent(this.jCheckBox4)).addGap(14, 14, 14).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBox24, -1, -1, Short.MAX_VALUE).addComponent(this.jCheckBox25, -1, 105, Short.MAX_VALUE).addComponent(this.jCheckBoxPB6IRQ, -1, -1, Short.MAX_VALUE).addGroup(jPanel5Layout.createSequentialGroup().addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBox18).addComponent(this.jCheckBoxXmas1).addComponent(this.jCheckBox26, -2, 96, -2).addComponent(this.jCheckBox23, -2, 82, -2).addComponent(this.jCheckBoxXmas).addComponent(this.jCheckBox21, -2, 96, -2).addComponent(this.jCheckBox22, -2, 96, -2).addComponent(this.jCheckBox20).addComponent(this.jCheckBox15)).addGap(0, 0, Short.MAX_VALUE)))).addGroup(jPanel5Layout.createSequentialGroup().addGap(10, 10, 10).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jComboBoxImager, 0, 180, Short.MAX_VALUE).addComponent(this.singleImagePanel3, -1, -1, Short.MAX_VALUE)).addGroup(jPanel5Layout.createSequentialGroup().addComponent(this.jTextFieldPath12, -2, 106, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonFileSelect15))))).addGap(51, 51, 51)));
        jPanel5Layout.setVerticalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addContainerGap().addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBox1).addComponent(this.jCheckBox15)).addGap(0, 0, 0).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBox2).addComponent(this.jCheckBox20)).addGap(0, 0, 0).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBox16).addComponent(this.jCheckBox22)).addGap(0, 0, 0).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBox9).addComponent(this.jCheckBox21)).addGap(0, 0, 0).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBox10).addComponent(this.jCheckBoxXmas)).addGap(0, 0, 0).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBox3).addComponent(this.jCheckBox23)).addGap(0, 0, 0).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBox4).addComponent(this.jCheckBox26)).addGap(0, 0, 0).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBox5).addComponent(this.jCheckBox25)).addGap(0, 0, 0).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBox6).addComponent(this.jCheckBoxXmas1)).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBox7).addComponent(this.jCheckBoxPB6IRQ)).addGap(0, 0, 0).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBox8).addComponent(this.jCheckBox24)).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBox17).addComponent(this.jCheckBox18)).addGap(0, 0, 0).addComponent(this.jCheckBox19).addGap(4, 4, 4).addComponent(this.jComboBoxImager, -2, -1, -2).addGap(4, 4, 4).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jButtonFileSelect15).addComponent(this.jTextFieldPath12, -2, -1, -2)).addGap(5, 5, 5).addComponent(this.singleImagePanel3, -2, -1, -2).addGap(56, 56, 56)));
        this.jPanel3.add(this.jPanel5);
        this.jPanel5.setBounds(380, 0, 260, 590);
        this.jButtonFileSelect1.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/page_link.png")));
        this.jButtonFileSelect1.setToolTipText("opens system browser to homepage");
        this.jButtonFileSelect1.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonFileSelect1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CartridgePropertiesPanel.this.jButtonFileSelect1ActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.jButtonFileSelect1);
        this.jButtonFileSelect1.setBounds(350, 70, 20, 20);
        this.jPanel3.add(this.jTextFieldPath);
        this.jTextFieldPath.setBounds(110, 70, 234, 21);
        this.jLabel7.setText("Homepage");
        this.jLabel7.setPreferredSize(new Dimension(0, 21));
        this.jPanel3.add(this.jLabel7);
        this.jLabel7.setBounds(10, 70, 100, 21);
        this.jLabel8.setText("Binary link");
        this.jLabel8.setPreferredSize(new Dimension(0, 21));
        this.jPanel3.add(this.jLabel8);
        this.jLabel8.setBounds(10, 100, 100, 21);
        this.jTextFieldPath1.setToolTipText("As of now only links for ONE file can be added.\nI know of no multi bank downloadable files for vectrex yet.");
        this.jPanel3.add(this.jTextFieldPath1);
        this.jTextFieldPath1.setBounds(110, 100, 234, 21);
        this.jTable1.setModel(new DefaultTableModel(new Object[][]{{null}, {null}, {null}, {null}}, new String[]{"Main for Bank"}){
            Class[] types;
            {
                this.types = new Class[]{String.class};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }
        });
        this.jTable1.setAutoResizeMode(3);
        this.jScrollPane2.setViewportView(this.jTable1);
        this.jPanel3.add(this.jScrollPane2);
        this.jScrollPane2.setBounds(110, 130, 266, 99);
        this.jLabel9.setText("Filename(s)");
        this.jLabel9.setPreferredSize(new Dimension(0, 21));
        this.jPanel3.add(this.jLabel9);
        this.jLabel9.setBounds(10, 130, 100, 21);
        this.jLabel10.setText("Overlay");
        this.jLabel10.setPreferredSize(new Dimension(0, 21));
        this.jPanel3.add(this.jLabel10);
        this.jLabel10.setBounds(10, 233, 100, 21);
        this.jPanel3.add(this.jTextFieldPath2);
        this.jTextFieldPath2.setBounds(110, 233, 233, 21);
        this.jButtonFileSelect3.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/folder_go.png")));
        this.jButtonFileSelect3.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonFileSelect3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CartridgePropertiesPanel.this.jButtonFileSelect3ActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.jButtonFileSelect3);
        this.jButtonFileSelect3.setBounds(350, 233, 20, 20);
        this.jLabel11.setText("Rights");
        this.jLabel11.setPreferredSize(new Dimension(0, 21));
        this.jPanel3.add(this.jLabel11);
        this.jLabel11.setBounds(10, 260, 100, 21);
        this.jPanel3.add(this.jTextFieldPath3);
        this.jTextFieldPath3.setBounds(110, 260, 265, 21);
        this.jScrollPane1.setViewportView(this.jTextPane1);
        this.jPanel3.add(this.jScrollPane1);
        this.jScrollPane1.setBounds(110, 290, 265, 200);
        this.jLabel12.setText("Licence");
        this.jLabel12.setPreferredSize(new Dimension(0, 21));
        this.jPanel3.add(this.jLabel12);
        this.jLabel12.setBounds(10, 290, 100, 21);
        this.jButtonFileSelect10.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/add.png")));
        this.jButtonFileSelect10.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonFileSelect10.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CartridgePropertiesPanel.this.jButtonFileSelect10ActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.jButtonFileSelect10);
        this.jButtonFileSelect10.setBounds(80, 160, 20, 20);
        this.jButtonFileSelect11.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/delete.png")));
        this.jButtonFileSelect11.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonFileSelect11.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CartridgePropertiesPanel.this.jButtonFileSelect11ActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.jButtonFileSelect11);
        this.jButtonFileSelect11.setBounds(80, 180, 20, 20);
        this.jButtonDownloadConfig.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/folder_link.png")));
        this.jButtonDownloadConfig.setToolTipText("if link to a binary is given, the link the binary is downloaded");
        this.jButtonDownloadConfig.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonDownloadConfig.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CartridgePropertiesPanel.this.jButtonDownloadConfigActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.jButtonDownloadConfig);
        this.jButtonDownloadConfig.setBounds(350, 100, 20, 20);
        this.jCheckBox11.setText("Complete game");
        this.jPanel3.add(this.jCheckBox11);
        this.jCheckBox11.setBounds(110, 490, 120, 19);
        this.jCheckBox12.setText("Demo");
        this.jPanel3.add(this.jCheckBox12);
        this.jCheckBox12.setBounds(110, 510, 120, 19);
        this.jCheckBox13.setText("Snippet");
        this.jPanel3.add(this.jCheckBox13);
        this.jCheckBox13.setBounds(230, 490, 140, 19);
        this.jCheckBox14.setText("Homebrew");
        this.jPanel3.add(this.jCheckBox14);
        this.jCheckBox14.setBounds(230, 510, 140, 19);
        this.jTabbedPane1.addTab("General", this.jPanel3);
        this.jLabel13.setText("Textfile");
        this.jTextFieldPath4.setPreferredSize(new Dimension(6, 21));
        this.jButtonFileSelect4.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/folder_go.png")));
        this.jButtonFileSelect4.setToolTipText("select text file");
        this.jButtonFileSelect4.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonFileSelect4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CartridgePropertiesPanel.this.jButtonFileSelect4ActionPerformed(evt);
            }
        });
        this.jScrollPane3.setViewportView(this.jTextPane2);
        this.jLabel19.setText("PDFLink");
        this.jTextFieldPath8.setPreferredSize(new Dimension(6, 21));
        this.jButtonFileSelect8.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/folder_link.png")));
        this.jButtonFileSelect8.setToolTipText("link to a downloadable pdf");
        this.jButtonFileSelect8.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonFileSelect8.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CartridgePropertiesPanel.this.jButtonFileSelect8ActionPerformed(evt);
            }
        });
        this.jLabel20.setText("PDFFile");
        this.jTextFieldPath9.setPreferredSize(new Dimension(6, 21));
        this.jButtonFileSelect9.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/folder_go.png")));
        this.jButtonFileSelect9.setToolTipText("select pdf file");
        this.jButtonFileSelect9.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonFileSelect9.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CartridgePropertiesPanel.this.jButtonFileSelect9ActionPerformed(evt);
            }
        });
        this.jButtonFileSelect12.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/gui/Adobe_PDF_file_icon_16x16.png")));
        this.jButtonFileSelect12.setToolTipText("open system pdf viewer");
        this.jButtonFileSelect12.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonFileSelect12.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CartridgePropertiesPanel.this.jButtonFileSelect12ActionPerformed(evt);
            }
        });
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addComponent(this.jScrollPane3).addGap(12, 12, 12)).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel13).addComponent(this.jLabel19).addComponent(this.jLabel20)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(jPanel4Layout.createSequentialGroup().addComponent(this.jTextFieldPath4, -2, 355, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonFileSelect4)).addGroup(jPanel4Layout.createSequentialGroup().addComponent(this.jTextFieldPath8, -2, 355, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonFileSelect8, -1, -1, Short.MAX_VALUE)).addGroup(jPanel4Layout.createSequentialGroup().addComponent(this.jTextFieldPath9, -2, 355, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonFileSelect9))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonFileSelect12).addContainerGap(122, Short.MAX_VALUE)));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel13).addComponent(this.jTextFieldPath4, -2, -1, -2).addComponent(this.jButtonFileSelect4)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel19).addComponent(this.jTextFieldPath8, -2, -1, -2).addComponent(this.jButtonFileSelect8)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldPath9, -2, -1, -2).addComponent(this.jLabel20).addComponent(this.jButtonFileSelect9).addComponent(this.jButtonFileSelect12)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane3, -1, 488, Short.MAX_VALUE).addContainerGap()));
        this.jTabbedPane1.addTab("Instruction", this.jPanel4);
        GroupLayout singleImagePanel4Layout = new GroupLayout(this.singleImagePanel4);
        this.singleImagePanel4.setLayout(singleImagePanel4Layout);
        singleImagePanel4Layout.setHorizontalGroup(singleImagePanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        singleImagePanel4Layout.setVerticalGroup(singleImagePanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 542, Short.MAX_VALUE));
        this.jButtonNew3.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/paste_plain.png")));
        this.jButtonNew3.setToolTipText("paste from clipboard and save");
        this.jButtonNew3.setPreferredSize(new Dimension(20, 20));
        this.jButtonNew3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CartridgePropertiesPanel.this.jButtonNew3ActionPerformed(evt);
            }
        });
        this.jButtonFileSelect13.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/folder_go.png")));
        this.jButtonFileSelect13.setToolTipText("select picture of box front");
        this.jButtonFileSelect13.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonFileSelect13.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CartridgePropertiesPanel.this.jButtonFileSelect13ActionPerformed(evt);
            }
        });
        this.jTextFieldPath10.setPreferredSize(new Dimension(6, 21));
        this.jLabel21.setText("File");
        GroupLayout jPanel10Layout = new GroupLayout(this.jPanel10);
        this.jPanel10.setLayout(jPanel10Layout);
        jPanel10Layout.setHorizontalGroup(jPanel10Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel10Layout.createSequentialGroup().addContainerGap().addGroup(jPanel10Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.singleImagePanel4, -1, -1, Short.MAX_VALUE).addGroup(jPanel10Layout.createSequentialGroup().addComponent(this.jLabel21).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldPath10, -1, 477, Short.MAX_VALUE).addGap(18, 18, 18).addComponent(this.jButtonFileSelect13).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonNew3, -2, -1, -2))).addContainerGap()));
        jPanel10Layout.setVerticalGroup(jPanel10Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel10Layout.createSequentialGroup().addContainerGap().addGroup(jPanel10Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonFileSelect13).addComponent(this.jButtonNew3, -2, -1, -2).addGroup(jPanel10Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel21).addComponent(this.jTextFieldPath10, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.singleImagePanel4, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.jTabbedPane1.addTab("Cartridge", this.jPanel10);
        this.jLabel14.setText("File");
        this.jTextFieldPath5.setPreferredSize(new Dimension(6, 21));
        this.jButtonFileSelect5.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/folder_go.png")));
        this.jButtonFileSelect5.setToolTipText("select picture of box front");
        this.jButtonFileSelect5.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonFileSelect5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CartridgePropertiesPanel.this.jButtonFileSelect5ActionPerformed(evt);
            }
        });
        GroupLayout singleImagePanel1Layout = new GroupLayout(this.singleImagePanel1);
        this.singleImagePanel1.setLayout(singleImagePanel1Layout);
        singleImagePanel1Layout.setHorizontalGroup(singleImagePanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        singleImagePanel1Layout.setVerticalGroup(singleImagePanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 542, Short.MAX_VALUE));
        this.jButtonNew1.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/paste_plain.png")));
        this.jButtonNew1.setToolTipText("paste from clipboard and save");
        this.jButtonNew1.setPreferredSize(new Dimension(20, 20));
        this.jButtonNew1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CartridgePropertiesPanel.this.jButtonNew1ActionPerformed(evt);
            }
        });
        GroupLayout jPanel6Layout = new GroupLayout(this.jPanel6);
        this.jPanel6.setLayout(jPanel6Layout);
        jPanel6Layout.setHorizontalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addContainerGap().addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addComponent(this.jLabel14).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldPath5, -1, 477, Short.MAX_VALUE).addGap(18, 18, 18).addComponent(this.jButtonFileSelect5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonNew1, -2, -1, -2)).addComponent(this.singleImagePanel1, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel6Layout.setVerticalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addContainerGap().addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel14).addComponent(this.jTextFieldPath5, -2, -1, -2).addComponent(this.jButtonFileSelect5).addComponent(this.jButtonNew1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.singleImagePanel1, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.jTabbedPane1.addTab("Front", this.jPanel6);
        this.jLabel15.setText("File");
        this.jTextFieldPath6.setPreferredSize(new Dimension(6, 21));
        this.jButtonFileSelect6.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/folder_go.png")));
        this.jButtonFileSelect6.setToolTipText("select picture of box back");
        this.jButtonFileSelect6.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonFileSelect6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CartridgePropertiesPanel.this.jButtonFileSelect6ActionPerformed(evt);
            }
        });
        GroupLayout singleImagePanel2Layout = new GroupLayout(this.singleImagePanel2);
        this.singleImagePanel2.setLayout(singleImagePanel2Layout);
        singleImagePanel2Layout.setHorizontalGroup(singleImagePanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        singleImagePanel2Layout.setVerticalGroup(singleImagePanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 542, Short.MAX_VALUE));
        this.jButtonNew2.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/paste_plain.png")));
        this.jButtonNew2.setToolTipText("paste from clipboard and save");
        this.jButtonNew2.setPreferredSize(new Dimension(20, 20));
        this.jButtonNew2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CartridgePropertiesPanel.this.jButtonNew2ActionPerformed(evt);
            }
        });
        GroupLayout jPanel7Layout = new GroupLayout(this.jPanel7);
        this.jPanel7.setLayout(jPanel7Layout);
        jPanel7Layout.setHorizontalGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel7Layout.createSequentialGroup().addContainerGap().addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel7Layout.createSequentialGroup().addComponent(this.jLabel15).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldPath6, -1, 477, Short.MAX_VALUE).addGap(18, 18, 18).addComponent(this.jButtonFileSelect6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonNew2, -2, -1, -2)).addComponent(this.singleImagePanel2, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel7Layout.setVerticalGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel7Layout.createSequentialGroup().addContainerGap().addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel15).addComponent(this.jTextFieldPath6, -2, -1, -2).addComponent(this.jButtonFileSelect6).addComponent(this.jButtonNew2, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.singleImagePanel2, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.jTabbedPane1.addTab("Back", this.jPanel7);
        this.jLabel16.setText("File");
        this.jTextFieldPath7.setPreferredSize(new Dimension(6, 21));
        this.jButtonFileSelect7.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/folder_go.png")));
        this.jButtonFileSelect7.setToolTipText("select text file");
        this.jButtonFileSelect7.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonFileSelect7.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CartridgePropertiesPanel.this.jButtonFileSelect7ActionPerformed(evt);
            }
        });
        this.jScrollPane4.setViewportView(this.jTextPane3);
        GroupLayout jPanel8Layout = new GroupLayout(this.jPanel8);
        this.jPanel8.setLayout(jPanel8Layout);
        jPanel8Layout.setHorizontalGroup(jPanel8Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel8Layout.createSequentialGroup().addContainerGap().addGroup(jPanel8Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel8Layout.createSequentialGroup().addComponent(this.jLabel16).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldPath7, -1, 503, Short.MAX_VALUE).addGap(18, 18, 18).addComponent(this.jButtonFileSelect7)).addComponent(this.jScrollPane4)).addContainerGap()));
        jPanel8Layout.setVerticalGroup(jPanel8Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel8Layout.createSequentialGroup().addContainerGap().addGroup(jPanel8Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonFileSelect7).addGroup(jPanel8Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel16).addComponent(this.jTextFieldPath7, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jScrollPane4, -1, 537, Short.MAX_VALUE).addContainerGap()));
        this.jTabbedPane1.addTab("Critics", this.jPanel8);
        this.jLabel17.setText("Eastereggs");
        this.jLabel18.setText("Cheats");
        this.jScrollPane5.setViewportView(this.jTextPane4);
        this.jScrollPane6.setViewportView(this.jTextPane5);
        this.jLabel22.setText("In game image");
        this.jButtonFileSelect14.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/folder_go.png")));
        this.jButtonFileSelect14.setToolTipText("select picture of box back");
        this.jButtonFileSelect14.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonFileSelect14.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CartridgePropertiesPanel.this.jButtonFileSelect14ActionPerformed(evt);
            }
        });
        this.jButtonNew4.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/paste_plain.png")));
        this.jButtonNew4.setToolTipText("paste from clipboard and save");
        this.jButtonNew4.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonNew4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CartridgePropertiesPanel.this.jButtonNew4ActionPerformed(evt);
            }
        });
        GroupLayout singleImagePanel5Layout = new GroupLayout(this.singleImagePanel5);
        this.singleImagePanel5.setLayout(singleImagePanel5Layout);
        singleImagePanel5Layout.setHorizontalGroup(singleImagePanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        singleImagePanel5Layout.setVerticalGroup(singleImagePanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        GroupLayout jPanel9Layout = new GroupLayout(this.jPanel9);
        this.jPanel9.setLayout(jPanel9Layout);
        jPanel9Layout.setHorizontalGroup(jPanel9Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel9Layout.createSequentialGroup().addContainerGap().addGroup(jPanel9Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane6, GroupLayout.Alignment.TRAILING).addGroup(jPanel9Layout.createSequentialGroup().addComponent(this.jLabel17).addGap(0, 0, Short.MAX_VALUE)).addGroup(jPanel9Layout.createSequentialGroup().addComponent(this.jLabel18).addGap(264, 264, 264).addComponent(this.jLabel22).addGap(110, 110, 110)).addGroup(jPanel9Layout.createSequentialGroup().addComponent(this.jScrollPane5, -2, 288, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel9Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel9Layout.createSequentialGroup().addComponent(this.jTextFieldPath11).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonFileSelect14).addGap(3, 3, 3).addComponent(this.jButtonNew4)).addComponent(this.singleImagePanel5, -1, -1, Short.MAX_VALUE)))).addContainerGap()));
        jPanel9Layout.setVerticalGroup(jPanel9Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel9Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel17).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane6, -1, 223, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel9Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel18).addComponent(this.jLabel22)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel9Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane5, -1, 300, Short.MAX_VALUE).addGroup(jPanel9Layout.createSequentialGroup().addGroup(jPanel9Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonFileSelect14).addComponent(this.jTextFieldPath11, -2, -1, -2).addComponent(this.jButtonNew4)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.singleImagePanel5, -1, -1, Short.MAX_VALUE))).addContainerGap()));
        this.jTabbedPane1.addTab("Other", this.jPanel9);
        this.jCheckBoxEnableOverwrite.setText("enable overwrite");
        this.jCheckBoxAutoSync.setText("Try autoSync");
        this.jCheckBoxAutoSync.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CartridgePropertiesPanel.this.jCheckBoxAutoSyncActionPerformed(evt);
            }
        });
        this.jCheckBoxAllowROMWrite.setText("allow ROM write");
        this.jCheckBoxAllowROMWrite.setToolTipText("if enabled, ROM can be written to (in general) from cartdigde (which is BAD!)");
        this.jCheckBoxAllowROMWrite.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CartridgePropertiesPanel.this.jCheckBoxAllowROMWriteActionPerformed(evt);
            }
        });
        this.jCheckBoxBreakpoint.setText("ROM and PC breakpoints switch on by default");
        this.jCheckBoxBreakpoint.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CartridgePropertiesPanel.this.jCheckBoxBreakpointActionPerformed(evt);
            }
        });
        this.jLabel31.setText("emulated vectrex integrator max (w/h)");
        this.jTextField11.setText("38000");
        this.jTextField11.setPreferredSize(new Dimension(80, 21));
        this.jTextField11.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                CartridgePropertiesPanel.this.jTextField11FocusLost(evt);
            }
        });
        this.jTextField11.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CartridgePropertiesPanel.this.jTextField11ActionPerformed(evt);
            }
        });
        this.jTextField12.setText("41000");
        this.jTextField12.setPreferredSize(new Dimension(80, 21));
        this.jTextField12.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                CartridgePropertiesPanel.this.jTextField12FocusLost(evt);
            }
        });
        this.jTextField12.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CartridgePropertiesPanel.this.jTextField12ActionPerformed(evt);
            }
        });
        this.jLabel86.setText("overlay alpha threshold");
        this.jTextField30.setText("0.8");
        this.jTextField30.setToolTipText("needed for sub pixel opaque lines, which are rendered to \"half\" transparent");
        this.jTextField30.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CartridgePropertiesPanel.this.jTextField30ActionPerformed(evt);
            }
        });
        this.jLabel85.setText("dot dwell divisor");
        this.jTextField29.setText("25");
        this.jTextField29.setToolTipText("<html>\nbetween 1 and 256, (between 20-30 is sensible)<BR>\nDwell information of the vector beam is kept internally, <BR>\nthe longer the beam stays at the same position the higher the value.\n<BR>\nEach \"cycle\" adds \"4\" to the dwell value.\n</html>\n");
        this.jTextField29.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CartridgePropertiesPanel.this.jTextField29ActionPerformed(evt);
            }
        });
        GroupLayout jPanel11Layout = new GroupLayout(this.jPanel11);
        this.jPanel11.setLayout(jPanel11Layout);
        jPanel11Layout.setHorizontalGroup(jPanel11Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel11Layout.createSequentialGroup().addGroup(jPanel11Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel11Layout.createSequentialGroup().addContainerGap().addComponent(this.jCheckBoxEnableOverwrite)).addGroup(jPanel11Layout.createSequentialGroup().addGap(46, 46, 46).addGroup(jPanel11Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBoxAllowROMWrite).addComponent(this.jCheckBoxAutoSync).addComponent(this.jCheckBoxBreakpoint).addGroup(jPanel11Layout.createSequentialGroup().addGroup(jPanel11Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel11Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel86, GroupLayout.Alignment.LEADING).addComponent(this.jLabel31)).addComponent(this.jLabel85)).addGap(35, 35, 35).addGroup(jPanel11Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel11Layout.createSequentialGroup().addComponent(this.jTextField11, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jTextField12, -2, -1, -2)).addGroup(jPanel11Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jTextField29, GroupLayout.Alignment.LEADING).addComponent(this.jTextField30, GroupLayout.Alignment.LEADING, -1, 48, Short.MAX_VALUE))))))).addContainerGap(131, Short.MAX_VALUE)));
        jPanel11Layout.setVerticalGroup(jPanel11Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel11Layout.createSequentialGroup().addContainerGap().addComponent(this.jCheckBoxEnableOverwrite).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxAutoSync).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxAllowROMWrite).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxBreakpoint).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel11Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel31).addComponent(this.jTextField11, -2, -1, -2).addComponent(this.jTextField12, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel11Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextField30, -2, -1, -2).addComponent(this.jLabel86)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel11Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel85).addComponent(this.jTextField29, -2, -1, -2)).addContainerGap(433, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab("Config overwrite", this.jPanel11);
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTabbedPane1, -2, 0, Short.MAX_VALUE));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addGap(2, 2, 2).addComponent(this.jTabbedPane1)));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addGap(2, 2, 2).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE)));
    }

    private void jButtonNewActionPerformed(ActionEvent evt) {
        ++this.mClassSetting;
        this.mCartridgeProperties = new CartridgeProperties();
        this.clearAll();
        this.resetConfigPool(false, "Cartridge");
        --this.mClassSetting;
    }

    private void jButtonSaveActionPerformed(ActionEvent evt) {
        this.readAllToCurrent();
        this.mCartridgePropertiesPool.put(this.mCartridgeProperties);
        String currentName = this.mCartridgeProperties.mName;
        this.mCartridgePropertiesPool.save();
        ++this.mClassSetting;
        String klasse = this.jTextFieldKlasse.getText();
        this.resetConfigPool(true, klasse);
        --this.mClassSetting;
        this.jComboBoxName.setSelectedItem(currentName);
    }

    private void jButtonSaveAsNewActionPerformed(ActionEvent evt) {
        this.mCartridgeProperties = new CartridgeProperties();
        this.readAllToCurrent();
        this.mCartridgePropertiesPool.putAsNew(this.mCartridgeProperties);
        this.mCartridgePropertiesPool.save();
        ++this.mClassSetting;
        String klasse = this.jTextFieldKlasse.getText();
        this.resetConfigPool(true, klasse);
        this.jComboBoxName.setSelectedItem(this.mCartridgeProperties.mName);
        --this.mClassSetting;
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        this.readAllToCurrent();
        this.mCartridgePropertiesPool.remove(this.mCartridgeProperties);
        this.mCartridgePropertiesPool.save();
        ++this.mClassSetting;
        String klasse = this.jTextFieldKlasse.getText();
        this.resetConfigPool(true, klasse);
        if (this.jComboBoxName.getSelectedIndex() == -1) {
            this.clearAll();
        }
        String key = this.jComboBoxName.getSelectedItem().toString();
        this.mCartridgeProperties = this.mCartridgePropertiesPool.get(key);
        this.setAllFromCurrent();
        --this.mClassSetting;
    }

    private void jComboBoxKlasseActionPerformed(ActionEvent evt) {
        if (this.mClassSetting > 0) {
            return;
        }
        ++this.mClassSetting;
        String selected = this.jComboBoxKlasse.getSelectedItem().toString();
        this.clearAll();
        this.resetConfigPool(true, selected);
        this.jTextFieldKlasse.setText(this.jComboBoxKlasse.getSelectedItem().toString());
        String key = this.jComboBoxName.getSelectedItem().toString();
        this.mCartridgeProperties = this.mCartridgePropertiesPool.get(key);
        this.setAllFromCurrent();
        --this.mClassSetting;
    }

    private void jComboBoxNameActionPerformed(ActionEvent evt) {
        if (this.mClassSetting > 0) {
            return;
        }
        String key = this.jComboBoxName.getSelectedItem().toString();
        this.clearAll();
        this.mCartridgeProperties = this.mCartridgePropertiesPool.get(key);
        this.setAllFromCurrent();
    }

    private void jButtonFileSelect1ActionPerformed(ActionEvent evt) {
        if (this.jTextFieldPath.getText().trim().length() <= 7) {
            return;
        }
        try {
            if (Desktop.isDesktopSupported()) {
                Desktop.getDesktop().browse(new URI(this.jTextFieldPath.getText()));
            } else {
                Runtime runtime = Runtime.getRuntime();
                runtime.exec("/usr/bin/firefox -new-window " + this.jTextFieldPath.getText());
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private void jButtonFileSelect3ActionPerformed(ActionEvent evt) {
        InternalFrameFileChoser fc = new InternalFrameFileChoser();
        fc.setMultiSelectionEnabled(false);
        if (this.lastImagePath.length() == 0) {
            fc.setCurrentDirectory(new File(Global.mainPathPrefix + "overlays" + File.separator));
        } else {
            fc.setCurrentDirectory(new File(this.lastImagePath));
        }
        FileNameExtensionFilter filter = new FileNameExtensionFilter("Images", "png");
        fc.setFileFilter(filter);
        int r = fc.showOpenDialog(Configuration.getConfiguration().getMainFrame());
        if (r != 0) {
            return;
        }
        File files = fc.getSelectedFile();
        if (files != null) {
            String fullPath;
            this.lastImagePath = fullPath = fc.getSelectedFile().getAbsolutePath();
            this.jTextFieldPath2.setText(Utility.makeVideRelative(fullPath));
            this.singleImagePanel3.setImage(this.jTextFieldPath2.getText(), true);
        }
    }

    private void jButtonFileSelect4ActionPerformed(ActionEvent evt) {
        InternalFrameFileChoser fc = new InternalFrameFileChoser();
        fc.setMultiSelectionEnabled(false);
        if (this.lastImagePath.length() == 0) {
            fc.setCurrentDirectory(new File(Global.mainPathPrefix));
        } else {
            fc.setCurrentDirectory(new File(this.lastImagePath));
        }
        int r = fc.showOpenDialog(Configuration.getConfiguration().getMainFrame());
        if (r != 0) {
            return;
        }
        File files = fc.getSelectedFile();
        if (files != null) {
            String fullPath = fc.getSelectedFile().getAbsolutePath();
            this.jTextFieldPath4.setText(Utility.makeVideRelative(fullPath));
        }
        try {
            FileReader fr = new FileReader(Global.mainPathPrefix + CartridgePropertiesPanel.convertSeperator(this.jTextFieldPath4.getText()));
            this.jTextPane2.read(fr, null);
            fr.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void jButtonFileSelect5ActionPerformed(ActionEvent evt) {
        InternalFrameFileChoser fc = new InternalFrameFileChoser();
        fc.setMultiSelectionEnabled(false);
        if (this.lastImagePath.length() == 0) {
            fc.setCurrentDirectory(new File(Global.mainPathPrefix));
        } else {
            fc.setCurrentDirectory(new File(this.lastImagePath));
        }
        FileNameExtensionFilter filter = new FileNameExtensionFilter("Images", "jpg", "jpeg", "png", "bmp", "gif");
        fc.setFileFilter(filter);
        int r = fc.showOpenDialog(Configuration.getConfiguration().getMainFrame());
        if (r != 0) {
            return;
        }
        File files = fc.getSelectedFile();
        if (files != null) {
            String fullPath;
            this.lastImagePath = fullPath = fc.getSelectedFile().getAbsolutePath();
            this.jTextFieldPath5.setText(Utility.makeVideRelative(fullPath));
            this.singleImagePanel1.setImage(Global.mainPathPrefix + CartridgePropertiesPanel.convertSeperator(this.jTextFieldPath5.getText()));
            this.singleImagePanel1.scaleToFit();
        }
    }

    private void jButtonFileSelect6ActionPerformed(ActionEvent evt) {
        InternalFrameFileChoser fc = new InternalFrameFileChoser();
        fc.setMultiSelectionEnabled(false);
        if (this.lastImagePath.length() == 0) {
            fc.setCurrentDirectory(new File(Global.mainPathPrefix));
        } else {
            fc.setCurrentDirectory(new File(this.lastImagePath));
        }
        FileNameExtensionFilter filter = new FileNameExtensionFilter("Images", "jpg", "jpeg", "png", "bmp", "gif");
        fc.setFileFilter(filter);
        int r = fc.showOpenDialog(Configuration.getConfiguration().getMainFrame());
        if (r != 0) {
            return;
        }
        File files = fc.getSelectedFile();
        if (files != null) {
            String fullPath;
            this.lastImagePath = fullPath = fc.getSelectedFile().getAbsolutePath();
            this.jTextFieldPath6.setText(Utility.makeVideRelative(fullPath));
            this.singleImagePanel2.setImage(Global.mainPathPrefix + CartridgePropertiesPanel.convertSeperator(this.jTextFieldPath6.getText()));
            this.singleImagePanel2.scaleToFit();
        }
    }

    private void jButtonFileSelect7ActionPerformed(ActionEvent evt) {
        InternalFrameFileChoser fc = new InternalFrameFileChoser();
        fc.setMultiSelectionEnabled(false);
        if (this.lastImagePath.length() == 0) {
            fc.setCurrentDirectory(new File(Global.mainPathPrefix));
        } else {
            fc.setCurrentDirectory(new File(this.lastImagePath));
        }
        int r = fc.showOpenDialog(Configuration.getConfiguration().getMainFrame());
        if (r != 0) {
            return;
        }
        File files = fc.getSelectedFile();
        if (files != null) {
            String fullPath = fc.getSelectedFile().getAbsolutePath();
            this.jTextFieldPath7.setText(Utility.makeVideRelative(fullPath));
        }
        try {
            FileReader fr = new FileReader(Global.mainPathPrefix + CartridgePropertiesPanel.convertSeperator(this.jTextFieldPath7.getText()));
            this.jTextPane3.read(fr, null);
            fr.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void jButtonFileSelect8ActionPerformed(ActionEvent evt) {
        DownloaderPanel panel = new DownloaderPanel();
        panel.setValues("PDF", this.jTextFieldPath8.getText(), true);
        ((CSAMainFrame)this.mParent).showPanelModal(panel, "PDF Download config", 700, 400);
        Downloader d = panel.getDownloader();
        this.jTextFieldPath8.setText(d.mName);
        this.mCartridgeProperties.mFullFilename.clear();
        if (!d.getisZip()) {
            this.jTextFieldPath9.setText(d.getDestinationDirAll());
        } else {
            for (int i = 0; i < d.getFileUnpacked().size(); ++i) {
                this.jTextFieldPath9.setText(d.getFileUnpacked().elementAt(0));
            }
        }
    }

    private void jButtonFileSelect9ActionPerformed(ActionEvent evt) {
        InternalFrameFileChoser fc = new InternalFrameFileChoser();
        fc.setMultiSelectionEnabled(false);
        if (this.lastImagePath.length() == 0) {
            fc.setCurrentDirectory(new File(Global.mainPathPrefix));
        } else {
            fc.setCurrentDirectory(new File(this.lastImagePath));
        }
        FileNameExtensionFilter filter = new FileNameExtensionFilter("PDF", "PDF");
        fc.setFileFilter(filter);
        int r = fc.showOpenDialog(Configuration.getConfiguration().getMainFrame());
        if (r != 0) {
            return;
        }
        File files = fc.getSelectedFile();
        if (files != null) {
            String fullPath = fc.getSelectedFile().getAbsolutePath();
            this.jTextFieldPath9.setText(Utility.makeVideRelative(fullPath));
        }
    }

    private void jButtonNew1ActionPerformed(ActionEvent evt) {
        Transferable t = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
        if (t != null && t.isDataFlavorSupported(DataFlavor.imageFlavor)) {
            try {
                Image img = (Image)t.getTransferData(DataFlavor.imageFlavor);
                this.singleImagePanel1.setImage(UtilityImage.toBufferedImage(img));
                this.singleImagePanel1.scaleToFit();
                this.jTextFieldPath5.setText("cartridges" + File.separator + "images" + File.separator + "" + this.jTextField2.getText() + Global.getRand().nextLong() + ".png");
                BufferedImage image = this.singleImagePanel1.getImage();
                try {
                    File outputfile = new File(Global.mainPathPrefix + CartridgePropertiesPanel.convertSeperator(this.jTextFieldPath5.getText()));
                    ImageIO.write((RenderedImage)image, "png", outputfile);
                }
                catch (IOException e) {
                    System.out.println(e);
                }
            }
            catch (Exception x) {
                System.out.println("Paste not successful");
            }
        }
    }

    private void jButtonNew2ActionPerformed(ActionEvent evt) {
        Transferable t = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
        if (t != null && t.isDataFlavorSupported(DataFlavor.imageFlavor)) {
            try {
                Image img = (Image)t.getTransferData(DataFlavor.imageFlavor);
                this.singleImagePanel2.setImage(UtilityImage.toBufferedImage(img));
                this.singleImagePanel2.scaleToFit();
                this.jTextFieldPath6.setText("cartridges" + File.separator + "images" + File.separator + "" + this.jTextField2.getText() + Global.getRand().nextLong() + ".png");
                BufferedImage image = this.singleImagePanel2.getImage();
                try {
                    File outputfile = new File(Global.mainPathPrefix + CartridgePropertiesPanel.convertSeperator(this.jTextFieldPath6.getText()));
                    ImageIO.write((RenderedImage)image, "png", outputfile);
                }
                catch (IOException e) {
                    System.out.println(e);
                }
            }
            catch (Exception x) {
                System.out.println("Paste not successful");
            }
        }
    }

    private void jButtonFileSelect10ActionPerformed(ActionEvent evt) {
        this.mCartridgeProperties.mFullFilename.addElement("");
        this.updateTable();
    }

    private void jButtonFileSelect11ActionPerformed(ActionEvent evt) {
        if (this.mCartridgeProperties.mFullFilename.size() <= 0) {
            return;
        }
        this.mCartridgeProperties.mFullFilename.removeElementAt(this.mCartridgeProperties.mFullFilename.size() - 1);
        this.updateTable();
    }

    private void jButtonFileSelect12ActionPerformed(ActionEvent evt) {
        boolean ok = DownloaderPanel.ensureLocalFile("PDF", this.mCartridgeProperties.mPDFLink, Global.mainPathPrefix + CartridgePropertiesPanel.convertSeperator(this.jTextFieldPath9.getText()));
        if (!ok) {
            this.log.addLog("CartridgeProperties: files could not be downloaded to local", LogPanel.WARN);
            return;
        }
        String file = Global.mainPathPrefix + CartridgePropertiesPanel.convertSeperator(this.jTextFieldPath9.getText());
        CSAMainFrame.invokeSystemFile(new File(file));
    }

    private void jButtonNew3ActionPerformed(ActionEvent evt) {
        Transferable t = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
        if (t != null && t.isDataFlavorSupported(DataFlavor.imageFlavor)) {
            try {
                Image img = (Image)t.getTransferData(DataFlavor.imageFlavor);
                this.singleImagePanel4.setImage(UtilityImage.toBufferedImage(img));
                this.singleImagePanel4.scaleToFit();
                this.jTextFieldPath10.setText("cartridges" + File.separator + "images" + File.separator + "" + this.jTextField2.getText() + Global.getRand().nextLong() + ".png");
                BufferedImage image = this.singleImagePanel4.getImage();
                try {
                    File outputfile = new File(Global.mainPathPrefix + CartridgePropertiesPanel.convertSeperator(this.jTextFieldPath10.getText()));
                    ImageIO.write((RenderedImage)image, "png", outputfile);
                }
                catch (IOException e) {
                    System.out.println(e);
                }
            }
            catch (Exception x) {
                System.out.println("Paste not successful");
            }
        }
    }

    private void jButtonFileSelect13ActionPerformed(ActionEvent evt) {
        InternalFrameFileChoser fc = new InternalFrameFileChoser();
        fc.setMultiSelectionEnabled(false);
        if (this.lastImagePath.length() == 0) {
            fc.setCurrentDirectory(new File(Global.mainPathPrefix));
        } else {
            fc.setCurrentDirectory(new File(this.lastImagePath));
        }
        FileNameExtensionFilter filter = new FileNameExtensionFilter("Images", "jpg", "jpeg", "png", "bmp", "gif");
        fc.setFileFilter(filter);
        int r = fc.showOpenDialog(Configuration.getConfiguration().getMainFrame());
        if (r != 0) {
            return;
        }
        File files = fc.getSelectedFile();
        if (files != null) {
            String fullPath;
            this.lastImagePath = fullPath = fc.getSelectedFile().getAbsolutePath();
            this.jTextFieldPath10.setText(Utility.makeVideRelative(fullPath));
            this.singleImagePanel4.setImage(Global.mainPathPrefix + CartridgePropertiesPanel.convertSeperator(this.jTextFieldPath10.getText()));
            this.singleImagePanel4.scaleToFit();
        }
    }

    private void jButtonFileSelect14ActionPerformed(ActionEvent evt) {
        InternalFrameFileChoser fc = new InternalFrameFileChoser();
        fc.setMultiSelectionEnabled(false);
        if (this.lastImagePath.length() == 0) {
            fc.setCurrentDirectory(new File(Global.mainPathPrefix));
        } else {
            fc.setCurrentDirectory(new File(this.lastImagePath));
        }
        FileNameExtensionFilter filter = new FileNameExtensionFilter("Images", "jpg", "jpeg", "png", "bmp", "gif");
        fc.setFileFilter(filter);
        int r = fc.showOpenDialog(Configuration.getConfiguration().getMainFrame());
        if (r != 0) {
            return;
        }
        File files = fc.getSelectedFile();
        if (files != null) {
            String fullPath;
            this.lastImagePath = fullPath = fc.getSelectedFile().getAbsolutePath();
            this.jTextFieldPath11.setText(Utility.makeVideRelative(fullPath));
            this.singleImagePanel5.setImage(Global.mainPathPrefix + CartridgePropertiesPanel.convertSeperator(this.jTextFieldPath11.getText()));
            this.singleImagePanel5.scaleToFit();
        }
    }

    private void jButtonNew4ActionPerformed(ActionEvent evt) {
        Transferable t = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
        if (t != null && t.isDataFlavorSupported(DataFlavor.imageFlavor)) {
            try {
                Image img = (Image)t.getTransferData(DataFlavor.imageFlavor);
                this.singleImagePanel5.setImage(UtilityImage.toBufferedImage(img));
                this.singleImagePanel5.scaleToFit();
                this.jTextFieldPath11.setText("cartridges" + File.separator + "images" + File.separator + "" + this.jTextField2.getText() + Global.getRand().nextLong() + ".png");
                BufferedImage image = this.singleImagePanel5.getImage();
                try {
                    File outputfile = new File(Global.mainPathPrefix + CartridgePropertiesPanel.convertSeperator(this.jTextFieldPath11.getText()));
                    ImageIO.write((RenderedImage)image, "png", outputfile);
                }
                catch (IOException e) {
                    this.log.addLog(e, LogPanel.WARN);
                }
            }
            catch (Exception x) {
                this.log.addLog(x, LogPanel.WARN);
            }
        }
    }

    private void jButtonDownloadConfigActionPerformed(ActionEvent evt) {
        DownloaderPanel panel = new DownloaderPanel();
        panel.setValues("Cartridge", this.jTextFieldPath1.getText(), false);
        ((CSAMainFrame)this.mParent).showPanelModal(panel, "Bin Download config", 700, 400);
        Downloader d = panel.getDownloader();
        this.jTextFieldPath1.setText(d.mName);
        this.mCartridgeProperties.mFullFilename.clear();
        if (!d.getisZip()) {
            this.mCartridgeProperties.mFullFilename.addElement(d.getDestinationDirAll());
        } else {
            for (int i = 0; i < d.getFileUnpacked().size(); ++i) {
                this.mCartridgeProperties.mFullFilename.addElement(d.getFileUnpacked().elementAt(i));
            }
        }
        this.updateTable();
    }

    private void jButtonFileSelect15ActionPerformed(ActionEvent evt) {
        InternalFrameFileChoser fc = new InternalFrameFileChoser();
        fc.setMultiSelectionEnabled(false);
        fc.setCurrentDirectory(new File(Global.mainPathPrefix));
        int r = fc.showOpenDialog(Configuration.getConfiguration().getMainFrame());
        if (r != 0) {
            return;
        }
        File files = fc.getSelectedFile();
        if (files != null) {
            String fullPath = fc.getSelectedFile().getAbsolutePath();
            this.jTextFieldPath12.setText(Utility.makeVideRelative(fullPath));
        }
    }

    private void jCheckBox5ActionPerformed(ActionEvent evt) {
        this.jComboBoxImager.setEnabled(this.jCheckBox5.isSelected());
    }

    private void jCheckBox6ActionPerformed(ActionEvent evt) {
        this.jButtonFileSelect15.setEnabled(this.jCheckBox6.isSelected());
        this.jTextFieldPath12.setEnabled(this.jCheckBox6.isSelected());
    }

    private void jCheckBoxXmasActionPerformed(ActionEvent evt) {
    }

    private void jCheckBox20ActionPerformed(ActionEvent evt) {
    }

    private void jCheckBox2ActionPerformed(ActionEvent evt) {
    }

    private void jCheckBox22ActionPerformed(ActionEvent evt) {
    }

    private void jCheckBoxAutoSyncActionPerformed(ActionEvent evt) {
    }

    private void jCheckBoxAllowROMWriteActionPerformed(ActionEvent evt) {
    }

    private void jCheckBoxBreakpointActionPerformed(ActionEvent evt) {
    }

    private void jTextField11FocusLost(FocusEvent evt) {
    }

    private void jTextField11ActionPerformed(ActionEvent evt) {
    }

    private void jTextField12FocusLost(FocusEvent evt) {
    }

    private void jTextField12ActionPerformed(ActionEvent evt) {
    }

    private void jTextField30ActionPerformed(ActionEvent evt) {
    }

    private void jTextField29ActionPerformed(ActionEvent evt) {
    }

    private void jCheckBox23ActionPerformed(ActionEvent evt) {
    }

    private void jCheckBox18ActionPerformed(ActionEvent evt) {
    }

    private void jCheckBox9ActionPerformed(ActionEvent evt) {
    }

    private void jCheckBox24ActionPerformed(ActionEvent evt) {
    }

    private void jCheckBoxXmas1ActionPerformed(ActionEvent evt) {
    }

    private void jCheckBox26ActionPerformed(ActionEvent evt) {
    }

    private void jCheckBoxPB6IRQActionPerformed(ActionEvent evt) {
    }

    public static String convertSeperator(String filename) {
        String ret = UtilityString.replace(filename, "/", File.separator);
        ret = UtilityString.replace(ret, "\\", File.separator);
        return ret;
    }

    void initImager() {
        String path = Global.mainPathPrefix + "xml" + File.separator + "wheels";
        ArrayList<String> files = UtilityFiles.getXMLFileList(path);
        this.jComboBoxImager.removeAllItems();
        for (String name : files) {
            this.jComboBoxImager.addItem(UtilityString.replace(name.toLowerCase(), ".xml", ""));
        }
        this.jComboBoxImager.setSelectedIndex(-1);
    }

    public void removeUIListerner() {
        UIManager.removePropertyChangeListener(this.pListener);
    }

    void updateMyUI() {
        int fontSize = Theme.textFieldFont.getFont().getSize();
        int rowHeight = fontSize + 2;
        this.jTable1.setRowHeight(rowHeight);
    }

    @Override
    public void deIconified() {
    }

    class BankMainTableModel
    extends AbstractTableModel {
        private BankMainTableModel() {
        }

        @Override
        public int getRowCount() {
            if (CartridgePropertiesPanel.this.mCartridgeProperties == null) {
                return 0;
            }
            if (((CartridgePropertiesPanel)CartridgePropertiesPanel.this).mCartridgeProperties.mFullFilename == null) {
                return 0;
            }
            return ((CartridgePropertiesPanel)CartridgePropertiesPanel.this).mCartridgeProperties.mFullFilename.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (col == 0) {
                return "" + row;
            }
            if (CartridgePropertiesPanel.this.mCartridgeProperties == null) {
                return "";
            }
            if (((CartridgePropertiesPanel)CartridgePropertiesPanel.this).mCartridgeProperties.mFullFilename == null) {
                return "";
            }
            if (col == 1) {
                String name = ((CartridgePropertiesPanel)CartridgePropertiesPanel.this).mCartridgeProperties.mFullFilename.elementAt(row);
                Path p = Paths.get(name, new String[0]);
                return p.getFileName();
            }
            return "-";
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return "#";
            }
            if (column == 1) {
                return "main file for bank";
            }
            return "";
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return String.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 1;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (CartridgePropertiesPanel.this.mCartridgeProperties == null) {
                return;
            }
            if (((CartridgePropertiesPanel)CartridgePropertiesPanel.this).mCartridgeProperties.mFullFilename == null) {
                return;
            }
            if (((CartridgePropertiesPanel)CartridgePropertiesPanel.this).mCartridgeProperties.mFullFilename.size() <= rowIndex) {
                return;
            }
            if (columnIndex == 1) {
                String path = aValue.toString();
                path = Utility.makeVideRelative(path);
                ((CartridgePropertiesPanel)CartridgePropertiesPanel.this).mCartridgeProperties.mFullFilename.setElementAt(path, rowIndex);
            }
        }
    }
}

