/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.vecx.cartridge;

import de.malban.Global;
import de.malban.vide.vecx.cartridge.CartridgeProperties;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.JOptionPane;

public class CartridgePropertiesPool {
    public static final String DEFAULT_XML_NAME = new String("CartridgeProperties.xml");
    private String mFileName = DEFAULT_XML_NAME;
    private HashMap<String, CartridgeProperties> mCartridgeProperties = new HashMap();
    private HashMap<String, String> mKlassenMap = new HashMap();

    public CartridgePropertiesPool(String name) {
        this.mFileName = name;
        this.init();
    }

    public CartridgePropertiesPool() {
        this.init();
    }

    public void setFilename(String n) {
        this.mFileName = n;
    }

    private boolean init() {
        try {
            return this.load();
        }
        catch (Throwable e) {
            JOptionPane.showMessageDialog(null, e.toString(), "Load Error CartridgeProperties...", 1);
            return false;
        }
    }

    public boolean load() {
        File f = new File(Global.mBaseDir + this.mFileName);
        if (!f.exists()) {
            return false;
        }
        this.mCartridgeProperties = CartridgeProperties.getHashMapFromXML(this.mFileName);
        return true;
    }

    public void save() {
        CartridgeProperties.saveCollectionAsXML(this.mFileName, this.mCartridgeProperties.values());
        this.buildKlassenMap();
    }

    public void remove(CartridgeProperties st) {
        this.mCartridgeProperties.remove(st.mName);
    }

    public void put(CartridgeProperties st) {
        this.mCartridgeProperties.remove(st.mName);
        this.mCartridgeProperties.put(st.mName, st);
    }

    public void putAsNew(CartridgeProperties st) {
        this.mCartridgeProperties.put(st.mName, st);
    }

    public CartridgeProperties get(String key) {
        return this.mCartridgeProperties.get(key);
    }

    public HashMap<String, CartridgeProperties> getHashMap() {
        return this.mCartridgeProperties;
    }

    private void buildKlassenMap() {
        this.mKlassenMap = new HashMap();
        Set<Map.Entry<String, CartridgeProperties>> entries = this.mCartridgeProperties.entrySet();
        for (Map.Entry<String, CartridgeProperties> entry : entries) {
            CartridgeProperties value = entry.getValue();
            this.mKlassenMap.put(value.mClass, value.mClass);
        }
    }

    public HashMap<String, String> getKlassenHashMap() {
        this.buildKlassenMap();
        return this.mKlassenMap;
    }

    public HashMap<String, CartridgeProperties> getMapForKlasse(String klasse) {
        HashMap<String, CartridgeProperties> ret = new HashMap<String, CartridgeProperties>();
        Set<Map.Entry<String, CartridgeProperties>> entries = this.mCartridgeProperties.entrySet();
        for (Map.Entry<String, CartridgeProperties> entry : entries) {
            CartridgeProperties value = entry.getValue();
            if (!value.mClass.equalsIgnoreCase(klasse)) continue;
            ret.put(value.mName, value);
        }
        return ret;
    }
}

