/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.vecx.cartridge;

import de.malban.config.Configuration;
import de.malban.gui.CSAMainFrame;
import de.malban.gui.panels.LogPanel;
import de.malban.vide.vecx.cartridge.Cartridge;
import de.malban.vide.vecx.cartridge.CartridgeInternalInterface;
import java.io.Serializable;

public class DS2430A
implements Serializable,
CartridgeInternalInterface {
    transient LogPanel log = (LogPanel)Configuration.getConfiguration().getDebugEntity();
    public static final int LL_UNKOWN = 0;
    public static final int LL_RESET_START = 1;
    public static final int LL_RESETED = 2;
    public static final int LL_PULSE_GENERATION = 3;
    public static final int LL_PULSE_GENERATION_DONE = 4;
    public static final int LL_READY_FOR_BITREAD = 5;
    public static final int LL_BITREAD_STARTED = 6;
    public static final int LL_READY_FOR_BITREAD_CONTINUE = 7;
    public static final int LL_WAIT_FOR_BITWRITE_PULSE_START = 8;
    public static final int LL_WAIT_FOR_BITWRITE_PULSE_END = 9;
    public static final int LL_WAIT_FOR_BITWRITE_FINISH = 10;
    String[] ll_names = new String[]{"UNKOWN", "RESET_START", "RESETED", "PULSE_GENERATION", "PULSE_GENERATION_DONE", "READY_FOR_BITREAD", "BITREAD_STARTED", "READY_FOR_BITREAD_CONTINUE", "WAIT_FOR_BITWRITE_PULSE_START", "WAIT_FOR_BITWRITE_PULSE_END", "WAIT_FOR_BITWRITE_FINISH"};
    public static int RESET_CYCLE_DURATION = 720;
    public static int WAIT_TO_GO_LOW_AFTER_RESET_CYCLES = 50;
    public static int PULSE_PRESENT_DURATION_CYCLES = 700;
    public static int BIT_TIMESLOT = 120;
    public static int HIGH_BIT_CYLCE = 40;
    public static final int HL_WAIT_FOR_1W_COMMAND = 0;
    public static final int HL_WAIT_FOR_2430_COMMAND = 1;
    public static final int HL_WAIT_FOR_READ_ADDRESS = 2;
    public static final int HL_READ_BYTE_FROM_SP = 3;
    public static final int HL_WAIT_FOR_WRITE_ADDRESS = 4;
    public static final int HL_WRITE_BYTE_TO_SP = 5;
    public static final int HL_WAIT_FOR_REG_READ_ADDRESS = 6;
    public static final int HL_READ_BYTE_FROM_REG = 7;
    String[] hl_names = new String[]{"WAIT_FOR_1W_COMMAND", "WAIT_FOR_2430_COMMAND", "WAIT_FOR_READ_ADDRESS", "READ_BYTE_FROM_SP", "WAIT_FOR_WRITE_ADDRESS", "WRITE_BYTE_TO_SP", "HL_WAIT_FOR_REG_READ_ADDRESS", "HL_READ_BYTE_FROM_REG"};
    public static final int DS1W_NONE = 0;
    public static final int DS1W_SKIPROM = 204;
    public static final int DS1W_MATCHROM = 85;
    public static final int DS1W_SEARCHROM = 240;
    public static final int DS1W_READROM = 51;
    public static final int DS1W_NOT_SUPPORTED = -1;
    public static final int DS2430_NONE = 0;
    public static final int DS2430_READMEM = 240;
    public static final int DS2430_WRITESP = 15;
    public static final int DS2430_READSP = 170;
    public static final int DS2430_COPYSP = 85;
    public static final int DS2430_VALKEY = 165;
    public static final int DS2430_READ_REGISTER = 195;
    public static final int DS2430_COPY_LOCK_REGISTER = 90;
    public static final int DS2430_NOT_SUPPORTED = -1;
    int FAMILY_CODE = 20;
    int SERIAL_NUMBER = 0;
    public static final int MAX_DATA_LEN = 32;
    public transient Cartridge cart;
    public EpromData epromData;
    long cycles = 0L;
    boolean line = false;
    boolean old_line = false;
    boolean lineIn = false;
    boolean lineOut = false;
    int lowLevelState = 0;
    int highLevelState = 0;
    int currentByteRead = 0;
    int bitsLoaded = 0;
    int currentRegAddress = 0;
    int currentOutputAddress = 0;
    int currentInputAddress = 0;
    int currentByteOutput = 0;
    int bitsOutputDone = 0;
    int current1WCommand = 0;
    int current2430Command = 0;
    long dif = 0L;
    int currentWriteByteComplete = 0;
    boolean isReadFromDS = false;

    public String getLowLevelName() {
        return this.ll_names[this.lowLevelState];
    }

    public String getHighLevelName() {
        return this.hl_names[this.highLevelState];
    }

    public String get1WCommandName() {
        if (this.current1WCommand == 0) {
            return "NONE";
        }
        if (this.current1WCommand == 204) {
            return "SKIPROM";
        }
        if (this.current1WCommand == 85) {
            return "MATCHROM";
        }
        if (this.current1WCommand == 240) {
            return "SEARCHROM";
        }
        if (this.current1WCommand == 51) {
            return "READROM";
        }
        return "NOT SUPPORTED ($" + String.format("$%02X", this.current1WCommand & 0xFF) + ")";
    }

    public String get2430CommandName() {
        if (this.current2430Command == 0) {
            return "NONE";
        }
        if (this.current2430Command == 240) {
            return "READMEM";
        }
        if (this.current2430Command == 15) {
            return "WRITESP";
        }
        if (this.current2430Command == 170) {
            return "READSP";
        }
        if (this.current2430Command == 85) {
            return "COPYSP";
        }
        if (this.current2430Command == 165) {
            return "VALKEY";
        }
        if (this.current2430Command == 195) {
            return "READ_REG";
        }
        if (this.current2430Command == 90) {
            return "CPY_LOCK_REG";
        }
        return "NOT SUPPORTED ($" + String.format("$%02X", this.current2430Command & 0xFF) + ")";
    }

    @Override
    public void init() {
        if (this.log == null) {
            this.log = (LogPanel)Configuration.getConfiguration().getDebugEntity();
        }
    }

    @Override
    public void deinit() {
    }

    public boolean isInputToDS() {
        return this.isReadFromDS;
    }

    public String getSyncCycles() {
        return "" + this.dif;
    }

    public String getLineIn() {
        if (this.lineIn) {
            return "1";
        }
        return "0";
    }

    public String getLineOut() {
        if (this.lineOut) {
            return "1";
        }
        return "0";
    }

    public String getBitCounterFromVectrex() {
        return "" + this.bitsLoaded;
    }

    public String getBitCounterFromDS() {
        return "" + this.bitsOutputDone;
    }

    public String getBitFromDS() {
        return "" + (this.currentByteOutput & 1);
    }

    public String getBitFromVectrex() {
        return "" + (this.currentByteRead & 1);
    }

    public byte[] getData() {
        return this.epromData.data;
    }

    public int getRegPointer() {
        return this.currentRegAddress;
    }

    public int getCurrentOutValue() {
        return this.currentWriteByteComplete;
    }

    public byte[] getRegs() {
        return this.epromData.reg;
    }

    public void setRegs(int reg, int data2) {
        this.epromData.reg[reg & 7] = (byte)(data2 & 0xFF);
    }

    @Override
    public void reset() {
        this.cycles = 0L;
        this.line = false;
        this.old_line = false;
        this.lineIn = false;
        this.lineOut = false;
        this.lowLevelState = 0;
        this.highLevelState = 0;
        this.currentByteRead = 0;
        this.bitsLoaded = 0;
        this.currentOutputAddress = 0;
        this.currentInputAddress = 0;
        this.currentByteOutput = 0;
        this.bitsOutputDone = 0;
        this.currentRegAddress = 0;
        this.current1WCommand = 0;
        this.current2430Command = 0;
        this.dif = 0L;
        this.currentWriteByteComplete = 0;
        this.isReadFromDS = false;
    }

    public DS2430A(Cartridge c) {
        this.cart = c;
        this.epromData = new EpromData();
    }

    public long getRegSum() {
        return this.epromData.reg[0] + this.epromData.reg[1] * 256 + this.epromData.reg[2] * 256 * 256 + this.epromData.reg[3] * 256 * 256 * 256 + this.epromData.reg[4] * 256 * 256 * 256 * 256 + this.epromData.reg[5] * 256 * 256 * 256 * 256 * 256 + this.epromData.reg[6] * 256 * 256 * 256 * 256 * 256 * 256 + this.epromData.reg[7] * 256 * 256 * 256 * 256 * 256 * 256 * 256;
    }

    @Override
    public DS2430A clone() {
        int i;
        DS2430A c = new DS2430A(this.cart);
        for (i = 0; i < 32; ++i) {
            c.epromData.data[i] = this.epromData.data[i];
        }
        for (i = 0; i < 8; ++i) {
            c.epromData.reg[i] = this.epromData.reg[i];
        }
        c.cycles = this.cycles;
        c.lineOut = this.lineOut;
        c.line = this.line;
        c.old_line = this.old_line;
        c.lowLevelState = this.lowLevelState;
        c.highLevelState = this.highLevelState;
        c.isReadFromDS = this.isReadFromDS;
        c.dif = this.dif;
        c.currentRegAddress = this.currentRegAddress;
        c.currentByteRead = this.currentByteRead;
        c.bitsLoaded = this.bitsLoaded;
        c.currentOutputAddress = this.currentOutputAddress;
        c.currentInputAddress = this.currentInputAddress;
        c.currentByteOutput = this.currentByteOutput;
        c.bitsOutputDone = this.bitsOutputDone;
        c.currentWriteByteComplete = this.currentWriteByteComplete;
        c.current1WCommand = this.current1WCommand;
        c.current2430Command = this.current2430Command;
        return c;
    }

    @Override
    public void linePB6In(boolean l) {
        this.line = l;
        this.lineIn = l;
    }

    @Override
    public void linePB6Out(boolean l) {
        this.line = l;
        this.lineOut = l;
        this.cart.setPB6FromCartridge(this.line);
    }

    @Override
    public void step(long c) {
        this.dif = c - this.cycles;
        if (this.line != this.old_line) {
            this.cycles = c;
        }
        if (!this.line && !this.old_line) {
            if (this.lowLevelState == 1) {
                return;
            }
            if (this.dif > (long)RESET_CYCLE_DURATION) {
                this.log.addLog("DS2430 Reset sequence 1) - start!", LogPanel.INFO);
                this.lowLevelState = 1;
                this.highLevelState = 0;
            }
        }
        switch (this.lowLevelState) {
            case 8: {
                if (this.line) break;
                this.lowLevelState = 9;
                this.log.addLog("DS2430 write byte pulse started!", LogPanel.INFO);
                break;
            }
            case 9: {
                if (!this.line) break;
                this.lowLevelState = 10;
                this.log.addLog("DS2430 write bit pulse ended, starting bit out...!", LogPanel.INFO);
                boolean bit = (this.currentByteOutput & 1) == 1;
                this.currentByteOutput >>= 1;
                this.linePB6Out(bit);
                ++this.bitsOutputDone;
                break;
            }
            case 10: {
                if (this.dif < (long)BIT_TIMESLOT) break;
                this.linePB6Out(true);
                if (this.old_line) {
                    this.log.addLog("DS2430 Write bit timeslot done (1)!", LogPanel.INFO);
                } else {
                    this.log.addLog("DS2430 Write bit timeslot done (0)!", LogPanel.INFO);
                }
                if (this.bitsOutputDone == 8) {
                    this.log.addLog("DS2430 Write completed: " + String.format("$%02X", this.currentWriteByteComplete), LogPanel.INFO);
                    this.highLevelStep();
                    break;
                }
                this.lowLevelState = 8;
                break;
            }
            case 5: {
                if (this.line) break;
                this.lowLevelState = 6;
                this.log.addLog("DS2430 Read command 1) - bit start!", LogPanel.INFO);
                break;
            }
            case 7: {
                if (this.line) break;
                this.lowLevelState = 6;
                this.log.addLog("DS2430 Read command 1b) - bit start!", LogPanel.INFO);
                break;
            }
            case 6: {
                if (!this.line) break;
                this.currentByteRead >>= 1;
                if (this.dif <= (long)HIGH_BIT_CYLCE) {
                    this.currentByteRead += 128;
                    this.log.addLog("DS2430 Read command 2) - load 1!", LogPanel.INFO);
                } else {
                    this.currentByteRead += 0;
                    this.log.addLog("DS2430 Read command 2) - load 0!", LogPanel.INFO);
                }
                this.lowLevelState = 7;
                ++this.bitsLoaded;
                if (this.bitsLoaded != 8) break;
                this.log.addLog("DS2430 Read command 3) - loaded: " + String.format("$%02X", this.currentByteRead), LogPanel.INFO);
                this.highLevelStep();
                break;
            }
            case 1: {
                if (!this.line) break;
                this.lowLevelState = 2;
                this.log.addLog("DS2430 Reset sequence 2) - reset!", LogPanel.INFO);
                break;
            }
            case 2: {
                if (this.dif <= (long)WAIT_TO_GO_LOW_AFTER_RESET_CYCLES) break;
                this.lowLevelState = 3;
                this.linePB6Out(false);
                this.log.addLog("DS2430 Reset sequence 3) - pulse start!", LogPanel.INFO);
                break;
            }
            case 3: {
                if (this.dif <= (long)PULSE_PRESENT_DURATION_CYCLES) break;
                this.lowLevelState = 5;
                this.currentByteRead = 0;
                this.bitsLoaded = 0;
                this.linePB6Out(true);
                this.log.addLog("DS2430 Reset sequence 4) - pulse end!", LogPanel.INFO);
                break;
            }
        }
        this.old_line = this.line;
    }

    void highLevelStep() {
        this.isReadFromDS = true;
        if (this.highLevelState == 0) {
            switch (this.currentByteRead) {
                case 204: {
                    this.current1WCommand = 204;
                    this.lowLevelState = 5;
                    this.highLevelState = 1;
                    this.current2430Command = 0;
                    this.currentByteRead = 0;
                    this.bitsLoaded = 0;
                    this.log.addLog("DS2430 Command DS1W_SKIPROM - ignored (ROM read not supported anyway)!", LogPanel.INFO);
                    break;
                }
                case 85: {
                    this.current1WCommand = 85;
                    this.current2430Command = 0;
                    this.lowLevelState = 5;
                    this.highLevelState = 0;
                    this.currentByteRead = 0;
                    this.bitsLoaded = 0;
                    this.log.addLog("DS2430 Command DS1W_MATCHROM - not supported!", LogPanel.INFO);
                    break;
                }
                case 240: {
                    this.current1WCommand = 240;
                    this.current2430Command = 0;
                    this.lowLevelState = 5;
                    this.highLevelState = 0;
                    this.currentByteRead = 0;
                    this.bitsLoaded = 0;
                    this.log.addLog("DS2430 Command DS1W_SEARCHROM - not supported!", LogPanel.INFO);
                    break;
                }
                case 51: {
                    this.current1WCommand = 51;
                    this.current2430Command = 0;
                    this.lowLevelState = 5;
                    this.highLevelState = 0;
                    this.currentByteRead = 0;
                    this.bitsLoaded = 0;
                    this.log.addLog("DS2430 Command DS1W_READROM - not supported!", LogPanel.INFO);
                    break;
                }
                default: {
                    this.current1WCommand = -1;
                    break;
                }
            }
        } else if (this.highLevelState == 1) {
            switch (this.currentByteRead) {
                case 240: {
                    this.current2430Command = 240;
                    this.loadBytesFromDisk();
                    this.lowLevelState = 5;
                    this.highLevelState = 2;
                    this.currentByteRead = 0;
                    this.bitsLoaded = 0;
                    this.log.addLog("DS2430 Command DS2430_READMEM - accepted!", LogPanel.INFO);
                    break;
                }
                case 170: {
                    this.current2430Command = 170;
                    this.lowLevelState = 5;
                    this.highLevelState = 2;
                    this.currentByteRead = 0;
                    this.bitsLoaded = 0;
                    this.log.addLog("DS2430 Command DS2430_READSP - accepted!", LogPanel.INFO);
                    break;
                }
                case 15: {
                    this.isReadFromDS = true;
                    this.current2430Command = 15;
                    this.lowLevelState = 5;
                    this.highLevelState = 4;
                    this.currentByteRead = 0;
                    this.bitsLoaded = 0;
                    this.log.addLog("DS2430 Command DS2430_WRITESP - accepted!", LogPanel.INFO);
                    break;
                }
                case 85: {
                    this.current2430Command = 85;
                    this.saveBytestoDisk();
                    this.lowLevelState = 5;
                    this.highLevelState = 1;
                    this.currentByteRead = 0;
                    this.bitsLoaded = 0;
                    this.log.addLog("DS2430 Command DS2430_COPYSP - accepted!", LogPanel.INFO);
                    break;
                }
                case 165: {
                    this.current2430Command = 165;
                    this.lowLevelState = 5;
                    this.highLevelState = 1;
                    this.currentByteRead = 0;
                    this.bitsLoaded = 0;
                    this.log.addLog("DS2430 Command DS2430_VALKEY - accepted!", LogPanel.INFO);
                    break;
                }
                case 195: {
                    this.current2430Command = 195;
                    this.lowLevelState = 5;
                    this.highLevelState = 6;
                    this.currentByteRead = 0;
                    this.bitsLoaded = 0;
                    this.log.addLog("DS2430 Command DS2430_READ_REGISTER - accepted!", LogPanel.INFO);
                    break;
                }
                case 90: {
                    this.current2430Command = 165;
                    this.lowLevelState = 5;
                    this.highLevelState = 1;
                    this.currentByteRead = 0;
                    this.bitsLoaded = 0;
                    this.log.addLog("DS2430 Command DS2430_COPY_LOCK_REGISTER - not supported!", LogPanel.INFO);
                    break;
                }
                default: {
                    this.current2430Command = -1;
                    this.log.addLog("DS2430 Command NOT SUPPORTED - accepted! (" + String.format("$%02X", this.current2430Command & 0xFF) + ")", LogPanel.INFO);
                    break;
                }
            }
        } else if (this.highLevelState == 6) {
            this.currentRegAddress = this.currentByteRead;
            this.log.addLog("DS2430 Command READ Reg Address received!", LogPanel.INFO);
            this.initOutputNextRegByte();
        } else if (this.highLevelState == 7) {
            this.log.addLog("DS2430 Continuing read (reg) from DS2430...", LogPanel.INFO);
            this.initOutputNextRegByte();
        } else if (this.highLevelState == 2) {
            this.currentOutputAddress = this.currentByteRead;
            this.log.addLog("DS2430 Command READ Address received!", LogPanel.INFO);
            this.initOutputNextByte();
        } else if (this.highLevelState == 3) {
            this.log.addLog("DS2430 Continuing read from DS2430...", LogPanel.INFO);
            this.initOutputNextByte();
        } else if (this.highLevelState == 4) {
            this.currentInputAddress = this.currentByteRead;
            this.log.addLog("DS2430 Command WRITE Address received!", LogPanel.INFO);
            this.initInputNextByte();
        } else if (this.highLevelState == 5) {
            this.log.addLog("DS2430 Continuing write to DS2430...", LogPanel.INFO);
            this.epromData.data[this.currentInputAddress % 32] = (byte)this.currentByteRead;
            ++this.currentInputAddress;
            this.initInputNextByte();
        }
    }

    public static EpromData loadData(String serialname) {
        return (EpromData)CSAMainFrame.deserialize(serialname);
    }

    public static boolean saveData(String serialname, EpromData d) {
        return CSAMainFrame.serialize(d, serialname);
    }

    void loadBytesFromDisk() {
        this.epromData = DS2430A.loadData(this.getSaveName());
        if (this.epromData == null) {
            this.epromData = new EpromData();
        }
    }

    void saveBytestoDisk() {
        DS2430A.saveData(this.getSaveName(), this.epromData);
    }

    void initOutputNextByte() {
        this.highLevelState = 3;
        this.currentWriteByteComplete = this.currentByteOutput = this.epromData.data[this.currentOutputAddress % 32];
        this.bitsOutputDone = 0;
        ++this.currentOutputAddress;
        this.lowLevelState = 8;
        this.isReadFromDS = false;
    }

    void initOutputNextRegByte() {
        this.highLevelState = 7;
        this.currentWriteByteComplete = this.currentByteOutput = this.epromData.reg[this.currentRegAddress % 8];
        this.bitsOutputDone = 0;
        this.currentRegAddress = (this.currentRegAddress + 1) % 8;
        this.lowLevelState = 8;
        this.isReadFromDS = false;
    }

    void initInputNextByte() {
        this.highLevelState = 5;
        this.bitsLoaded = 0;
        this.currentByteRead = 0;
        this.lowLevelState = 5;
        this.isReadFromDS = true;
    }

    public String getSaveName() {
        return this.cart.cartName + ".ds2430.ser";
    }

    @Override
    public boolean isActive() {
        return this.highLevelState != 0;
    }

    @Override
    public boolean usesPB6() {
        return true;
    }

    @Override
    public void lineIRQIn(boolean i) {
    }

    public static class EpromData
    implements Serializable {
        byte[] data = new byte[32];
        public byte[] reg = new byte[8];

        public EpromData() {
            this.reg[0] = 25;
            this.reg[1] = 27;
            this.reg[2] = 24;
            this.reg[3] = 29;
            this.reg[4] = 14;
            this.reg[5] = 12;
            this.reg[6] = 0;
            this.reg[7] = 0;
        }
    }
}

