/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.vecx.cartridge;

import de.malban.config.Configuration;
import de.malban.gui.CSAMainFrame;
import de.malban.gui.panels.LogPanel;
import de.malban.vide.vecx.cartridge.Cartridge;
import de.malban.vide.vecx.cartridge.CartridgeInternalInterface;
import java.io.Serializable;

public class DS2431
implements Serializable,
CartridgeInternalInterface {
    transient LogPanel log = (LogPanel)Configuration.getConfiguration().getDebugEntity();
    public static final int LL_UNKOWN = 0;
    public static final int LL_RESET_START = 1;
    public static final int LL_RESETED = 2;
    public static final int LL_PULSE_GENERATION = 3;
    public static final int LL_PULSE_GENERATION_DONE = 4;
    public static final int LL_READY_FOR_BITREAD = 5;
    public static final int LL_BITREAD_STARTED = 6;
    public static final int LL_READY_FOR_BITREAD_CONTINUE = 7;
    public static final int LL_WAIT_FOR_BITWRITE_PULSE_START = 8;
    public static final int LL_WAIT_FOR_BITWRITE_PULSE_END = 9;
    public static final int LL_WAIT_FOR_BITWRITE_FINISH = 10;
    String[] ll_names = new String[]{"UNKOWN", "RESET_START", "RESETED", "PULSE_GENERATION", "PULSE_GENERATION_DONE", "READY_FOR_BITREAD", "BITREAD_STARTED", "READY_FOR_BITREAD_CONTINUE", "WAIT_FOR_BITWRITE_PULSE_START", "WAIT_FOR_BITWRITE_PULSE_END", "WAIT_FOR_BITWRITE_FINISH"};
    public static int RESET_CYCLE_DURATION = 720;
    public static int WAIT_TO_GO_LOW_AFTER_RESET_CYCLES = 50;
    public static int PULSE_PRESENT_DURATION_CYCLES = 700;
    public static int BIT_TIMESLOT = 120;
    public static int HIGH_BIT_CYLCE = 40;
    public static final int HL_WAIT_FOR_1W_COMMAND = 0;
    public static final int HL_WAIT_FOR_2431_COMMAND = 1;
    public static final int HL_WAIT_FOR_READ_ADDRESSTA1 = 2;
    public static final int HL_WAIT_FOR_READ_ADDRESSTA2 = 3;
    public static final int HL_WAIT_FOR_WRITESP_ADDRESSTAES1 = 4;
    public static final int HL_WAIT_FOR_WRITESP_ADDRESSTAES2 = 5;
    public static final int HL_WAIT_FOR_WRITESP_ADDRESSTAES3 = 6;
    public static final int HL_WAIT_FOR_WRITESP_ADDRESSTAES4 = 7;
    public static final int HL_READ_BYTE_FROM_SP = 8;
    public static final int HL_WAIT_FOR_WRITE_ADDRESSTA1 = 9;
    public static final int HL_WAIT_FOR_WRITE_ADDRESSTA2 = 10;
    public static final int HL_WAIT_FOR_WRITE_ADDRESSTAES1 = 11;
    public static final int HL_WAIT_FOR_WRITE_ADDRESSTAES2 = 12;
    public static final int HL_WAIT_FOR_WRITE_ADDRESSTAES3 = 13;
    public static final int HL_WRITE_BYTE_TO_SP = 14;
    public static final int HL_SERIAL_1 = 15;
    public static final int HL_SERIAL_2 = 16;
    public static final int HL_SERIAL_3 = 17;
    public static final int HL_SERIAL_4 = 18;
    public static final int HL_SERIAL_5 = 19;
    public static final int HL_SERIAL_6 = 20;
    public static final int HL_SERIAL_7 = 21;
    public static final int HL_SERIAL_8 = 22;
    public static final int HL_SERIAL_END = 23;
    String[] hl_names = new String[]{"WAIT_FOR_1W_COMMAND", "WAIT_FOR_2431_COMMAND", "WAIT_FOR_READ_ADDRESSTA1", "WAIT_FOR_READ_ADDRESSTA2", "WAIT_FOR_WRITESP_ADDRESSTAES1", "WAIT_FOR_WRITESP_ADDRESSTAES2", "WAIT_FOR_WRITESP_ADDRESSTAES3", "WAIT_FOR_WRITESP_ADDRESSTAES4", "READ_BYTE_FROM_SP", "WAIT_FOR_WRITE_ADDRESSTA1", "WAIT_FOR_WRITE_ADDRESSTA2", "WAIT_FOR_WRITE_ADDRESSTAES1", "WAIT_FOR_WRITE_ADDRESSTAES2", "WAIT_FOR_WRITE_ADDRESSTAES3", "WRITE_BYTE_TO_SP", "HL_SERIAL_1", "HL_SERIAL_2", "HL_SERIAL_3", "HL_SERIAL_4", "HL_SERIAL_5", "HL_SERIAL_6", "HL_SERIAL_7", "HL_SERIAL_8", "HL_SERIAL_END"};
    public static final int DS1W_NONE = 0;
    public static final int DS1W_SKIPROM = 204;
    public static final int DS1W_MATCHROM = 85;
    public static final int DS1W_SEARCHROM = 240;
    public static final int DS1W_READROM = 51;
    public static final int DS1W_NOT_SUPPORTED = -1;
    public static final int DS2431_NONE = 0;
    public static final int DS2431_READMEM = 240;
    public static final int DS2431_WRITESP = 15;
    public static final int DS2431_READSP = 170;
    public static final int DS2431_COPYSP = 85;
    public static final int DS2431_VALKEY = 165;
    public static final int DS2431_NOT_SUPPORTED = -1;
    int FAMILY_CODE = 45;
    public byte[] SERIAL_NUMBER = new byte[6];
    int CRC8_DALLAS_MSB = 49;
    int CRC8_DALLAS_LSB = 140;
    public static final int MAX_DATA_LEN = 144;
    public transient Cartridge cart;
    EpromData epromData = new EpromData();
    long cycles = 0L;
    boolean line = false;
    boolean old_line = false;
    boolean lineIn = false;
    boolean lineOut = false;
    int lowLevelState = 0;
    int highLevelState = 0;
    int currentByteRead = 0;
    int bitsLoaded = 0;
    int currentOutputAddress = 0;
    int currentInputAddress = 0;
    int currentByteOutput = 0;
    int bitsOutputDone = 0;
    int current1WCommand = 0;
    int current2431Command = 0;
    long dif = 0L;
    int currentWriteByteComplete = 0;
    int currentWriteByteCompleteAddress = 255;
    boolean isReadFromDS = false;
    int TA1 = 0;
    int TA2 = 0;
    int ES = 0;

    int getCrc8() {
        int crc = 0;
        crc = this.oneCRC8Step(crc, this.FAMILY_CODE);
        crc = this.oneCRC8Step(crc, this.SERIAL_NUMBER[0]);
        crc = this.oneCRC8Step(crc, this.SERIAL_NUMBER[1]);
        crc = this.oneCRC8Step(crc, this.SERIAL_NUMBER[2]);
        crc = this.oneCRC8Step(crc, this.SERIAL_NUMBER[3]);
        crc = this.oneCRC8Step(crc, this.SERIAL_NUMBER[4]);
        crc = this.oneCRC8Step(crc, this.SERIAL_NUMBER[5]);
        return crc;
    }

    public long getSerial() {
        return this.SERIAL_NUMBER[0] + this.SERIAL_NUMBER[1] * 256 + this.SERIAL_NUMBER[2] * 256 * 256 + this.SERIAL_NUMBER[3] * 256 * 256 * 256 + this.SERIAL_NUMBER[4] * 256 * 256 * 256 * 256 + this.SERIAL_NUMBER[5] * 256 * 256 * 256 * 256 * 256;
    }

    int oneCRC8Step(int crc, int data2) {
        crc ^= data2;
        for (int i = 0; i < 8; ++i) {
            if ((crc & 1) == 1) {
                crc = crc >> 1 ^ this.CRC8_DALLAS_LSB;
                continue;
            }
            crc >>= 1;
        }
        return crc;
    }

    public int getTA1() {
        return this.TA1;
    }

    public int getTA2() {
        return this.TA2;
    }

    public int getES() {
        return this.ES;
    }

    public int getCurrentOutValue() {
        return this.currentWriteByteComplete;
    }

    public void setIDByte1(int id) {
        this.epromData.data[134] = (byte)(id & 0xFF);
    }

    public void setIDByte2(int id) {
        this.epromData.data[135] = (byte)(id & 0xFF);
    }

    public String getLowLevelName() {
        return this.ll_names[this.lowLevelState];
    }

    public String getHighLevelName() {
        return this.hl_names[this.highLevelState];
    }

    public String get1WCommandName() {
        if (this.current1WCommand == 0) {
            return "NONE";
        }
        if (this.current1WCommand == 204) {
            return "SKIPROM";
        }
        if (this.current1WCommand == 85) {
            return "MATCHROM";
        }
        if (this.current1WCommand == 240) {
            return "SEARCHROM";
        }
        if (this.current1WCommand == 51) {
            return "READROM";
        }
        return "NOT SUPPORTED ($" + String.format("$%02X", this.current1WCommand & 0xFF) + ")";
    }

    @Override
    public void init() {
        if (this.log == null) {
            this.log = (LogPanel)Configuration.getConfiguration().getDebugEntity();
        }
    }

    @Override
    public void deinit() {
    }

    public String get2431CommandName() {
        if (this.current2431Command == 0) {
            return "NONE";
        }
        if (this.current2431Command == 240) {
            return "READMEM";
        }
        if (this.current2431Command == 15) {
            return "WRITESP";
        }
        if (this.current2431Command == 170) {
            return "READSP";
        }
        if (this.current2431Command == 85) {
            return "COPYSP";
        }
        if (this.current2431Command == 165) {
            return "VALKEY";
        }
        return "NOT SUPPORTED ($" + String.format("$%02X", this.current2431Command & 0xFF) + ")";
    }

    public boolean isInputToDS() {
        return this.isReadFromDS;
    }

    public String getSyncCycles() {
        return "" + this.dif;
    }

    public String getLineIn() {
        if (this.lineIn) {
            return "1";
        }
        return "0";
    }

    public String getLineOut() {
        if (this.lineOut) {
            return "1";
        }
        return "0";
    }

    public String getBitCounterFromVectrex() {
        return "" + this.bitsLoaded;
    }

    public String getBitCounterFromDS() {
        return "" + this.bitsOutputDone;
    }

    public String getBitFromDS() {
        return "" + (this.currentByteOutput & 1);
    }

    public String getBitFromVectrex() {
        return "" + (this.currentByteRead & 1);
    }

    public byte[] getData() {
        return this.epromData.data;
    }

    @Override
    public void reset() {
        this.cycles = 0L;
        this.line = false;
        this.old_line = false;
        this.lineIn = false;
        this.lineOut = false;
        this.lowLevelState = 0;
        this.highLevelState = 0;
        this.currentByteRead = 0;
        this.bitsLoaded = 0;
        this.currentOutputAddress = 0;
        this.currentInputAddress = 0;
        this.currentByteOutput = 0;
        this.bitsOutputDone = 0;
        this.current1WCommand = 0;
        this.current2431Command = 0;
        this.dif = 0L;
        this.currentWriteByteComplete = 0;
        this.isReadFromDS = false;
    }

    public DS2431(Cartridge c) {
        this.cart = c;
        this.SERIAL_NUMBER[0] = 76;
        this.SERIAL_NUMBER[1] = -95;
        this.SERIAL_NUMBER[2] = 127;
        this.SERIAL_NUMBER[3] = 21;
        this.SERIAL_NUMBER[4] = 0;
        this.SERIAL_NUMBER[5] = 0;
        this.SERIAL_NUMBER[0] = 59;
        this.SERIAL_NUMBER[1] = 80;
        this.SERIAL_NUMBER[2] = 67;
        this.SERIAL_NUMBER[3] = 20;
        this.SERIAL_NUMBER[4] = 0;
        this.SERIAL_NUMBER[5] = 0;
        this.SERIAL_NUMBER[0] = 96;
        this.SERIAL_NUMBER[1] = -98;
        this.SERIAL_NUMBER[2] = 127;
        this.SERIAL_NUMBER[3] = 21;
        this.SERIAL_NUMBER[4] = 0;
        this.SERIAL_NUMBER[5] = 0;
    }

    @Override
    public DS2431 clone() {
        DS2431 c = new DS2431(this.cart);
        for (int i = 0; i < 144; ++i) {
            c.epromData.data[i] = this.epromData.data[i];
        }
        c.cycles = this.cycles;
        c.lineOut = this.lineOut;
        c.line = this.line;
        c.old_line = this.old_line;
        c.lowLevelState = this.lowLevelState;
        c.highLevelState = this.highLevelState;
        c.isReadFromDS = this.isReadFromDS;
        c.dif = this.dif;
        c.currentByteRead = this.currentByteRead;
        c.bitsLoaded = this.bitsLoaded;
        c.currentOutputAddress = this.currentOutputAddress;
        c.currentInputAddress = this.currentInputAddress;
        c.currentByteOutput = this.currentByteOutput;
        c.bitsOutputDone = this.bitsOutputDone;
        c.currentWriteByteComplete = this.currentWriteByteComplete;
        c.current1WCommand = this.current1WCommand;
        c.current2431Command = this.current2431Command;
        return c;
    }

    @Override
    public void linePB6In(boolean l) {
        this.line = l;
        this.lineIn = l;
    }

    @Override
    public void linePB6Out(boolean l) {
        this.line = l;
        this.lineOut = l;
        this.cart.setPB6FromCartridge(this.line);
    }

    @Override
    public void step(long c) {
        this.dif = c - this.cycles;
        if (this.line != this.old_line) {
            this.cycles = c;
        }
        if (!this.line && !this.old_line) {
            if (this.lowLevelState == 1) {
                return;
            }
            if (this.dif > (long)RESET_CYCLE_DURATION) {
                this.log.addLog("DS2431 Reset sequence 1) - start!", LogPanel.INFO);
                this.lowLevelState = 1;
                this.highLevelState = 0;
            }
        }
        switch (this.lowLevelState) {
            case 8: {
                if (this.line) break;
                this.lowLevelState = 9;
                this.log.addLog("DS2431 write byte pulse started!", LogPanel.INFO);
                break;
            }
            case 9: {
                if (!this.line) break;
                this.lowLevelState = 10;
                this.log.addLog("DS2431 write bit pulse ended, starting bit out...!", LogPanel.INFO);
                boolean bit = (this.currentByteOutput & 1) == 1;
                this.currentByteOutput >>= 1;
                this.linePB6Out(bit);
                ++this.bitsOutputDone;
                break;
            }
            case 10: {
                if (this.dif < (long)BIT_TIMESLOT) break;
                this.linePB6Out(true);
                if (this.old_line) {
                    this.log.addLog("DS2431 Write bit timeslot done (1)!", LogPanel.INFO);
                } else {
                    this.log.addLog("DS2431 Write bit timeslot done (0)!", LogPanel.INFO);
                }
                if (this.bitsOutputDone == 8) {
                    this.log.addLog("DS2431 Write completed: " + String.format("$%02X", this.currentWriteByteCompleteAddress) + "->" + String.format("$%02X", this.currentWriteByteComplete), LogPanel.INFO);
                    this.highLevelStep();
                    break;
                }
                this.lowLevelState = 8;
                break;
            }
            case 5: {
                if (this.line) break;
                this.lowLevelState = 6;
                this.log.addLog("DS2431 Read command 1) - bit start!", LogPanel.INFO);
                break;
            }
            case 7: {
                if (this.line) break;
                this.lowLevelState = 6;
                this.log.addLog("DS2431 Read command 1b) - bit start!", LogPanel.INFO);
                break;
            }
            case 6: {
                if (!this.line) break;
                this.currentByteRead >>= 1;
                if (this.dif <= (long)HIGH_BIT_CYLCE) {
                    this.currentByteRead += 128;
                    this.log.addLog("DS2431 Read command 2) - load 1!", LogPanel.INFO);
                } else {
                    this.currentByteRead += 0;
                    this.log.addLog("DS2431 Read command 2) - load 0!", LogPanel.INFO);
                }
                this.lowLevelState = 7;
                ++this.bitsLoaded;
                if (this.bitsLoaded != 8) break;
                this.log.addLog("DS2431 Read command 3) - loaded: " + String.format("$%02X", this.currentByteRead), LogPanel.INFO);
                this.highLevelStep();
                break;
            }
            case 1: {
                if (!this.line) break;
                this.lowLevelState = 2;
                this.log.addLog("DS2431 Reset sequence 2) - reset!", LogPanel.INFO);
                break;
            }
            case 2: {
                if (this.dif <= (long)WAIT_TO_GO_LOW_AFTER_RESET_CYCLES) break;
                this.lowLevelState = 3;
                this.linePB6Out(false);
                this.log.addLog("DS2431 Reset sequence 3) - pulse start!", LogPanel.INFO);
                break;
            }
            case 3: {
                if (this.dif <= (long)PULSE_PRESENT_DURATION_CYCLES) break;
                this.lowLevelState = 5;
                this.currentByteRead = 0;
                this.bitsLoaded = 0;
                this.linePB6Out(true);
                this.log.addLog("DS2431 Reset sequence 4) - pulse end!", LogPanel.INFO);
                break;
            }
        }
        this.old_line = this.line;
    }

    void highLevelStep() {
        this.isReadFromDS = true;
        if (this.highLevelState == 0) {
            switch (this.currentByteRead) {
                case 204: {
                    this.current1WCommand = 204;
                    this.lowLevelState = 5;
                    this.highLevelState = 1;
                    this.current2431Command = 0;
                    this.currentByteRead = 0;
                    this.bitsLoaded = 0;
                    this.log.addLog("DS2431 Command DS1W_SKIPROM - ignored (ROM read not supported anyway)! (" + this.cart.getPC() + ")", LogPanel.INFO);
                    break;
                }
                case 85: {
                    this.current1WCommand = 85;
                    this.current2431Command = 0;
                    this.lowLevelState = 5;
                    this.highLevelState = 0;
                    this.currentByteRead = 0;
                    this.bitsLoaded = 0;
                    this.log.addLog("DS2431 Command DS1W_MATCHROM - not supported! (" + this.cart.getPC() + ")", LogPanel.INFO);
                    break;
                }
                case 240: {
                    this.current1WCommand = 240;
                    this.current2431Command = 0;
                    this.lowLevelState = 5;
                    this.highLevelState = 0;
                    this.currentByteRead = 0;
                    this.bitsLoaded = 0;
                    this.log.addLog("DS2431 Command DS1W_SEARCHROM - not supported! (" + this.cart.getPC() + ")", LogPanel.INFO);
                    break;
                }
                case 51: {
                    this.current1WCommand = 51;
                    this.current2431Command = 0;
                    this.highLevelState = 16;
                    this.currentByteOutput = this.FAMILY_CODE;
                    this.currentWriteByteComplete = this.FAMILY_CODE;
                    this.currentWriteByteCompleteAddress = 255;
                    this.bitsOutputDone = 0;
                    this.lowLevelState = 8;
                    this.isReadFromDS = false;
                    this.log.addLog("DS2431 Command DS1W_READROM! (" + this.cart.getPC() + ")", LogPanel.INFO);
                    break;
                }
                default: {
                    this.current1WCommand = -1;
                    break;
                }
            }
        } else if (this.highLevelState == 15) {
            this.log.addLog("1W Command READROM 1. byte!", LogPanel.INFO);
            this.highLevelState = 16;
            this.currentByteOutput = this.FAMILY_CODE;
            this.currentWriteByteComplete = this.FAMILY_CODE;
            this.bitsOutputDone = 0;
            this.lowLevelState = 8;
            this.isReadFromDS = false;
        } else if (this.highLevelState == 16) {
            this.log.addLog("1W Command READROM 2. byte!", LogPanel.INFO);
            this.highLevelState = 17;
            this.currentByteOutput = this.SERIAL_NUMBER[0];
            this.currentWriteByteComplete = this.SERIAL_NUMBER[0];
            this.bitsOutputDone = 0;
            this.lowLevelState = 8;
            this.isReadFromDS = false;
        } else if (this.highLevelState == 17) {
            this.log.addLog("1W Command READROM 3. byte!", LogPanel.INFO);
            this.highLevelState = 18;
            this.currentByteOutput = this.SERIAL_NUMBER[1];
            this.currentWriteByteComplete = this.SERIAL_NUMBER[1];
            this.bitsOutputDone = 0;
            this.lowLevelState = 8;
            this.isReadFromDS = false;
        } else if (this.highLevelState == 18) {
            this.log.addLog("1W Command READROM 4. byte!", LogPanel.INFO);
            this.highLevelState = 19;
            this.currentByteOutput = this.SERIAL_NUMBER[2];
            this.currentWriteByteComplete = this.SERIAL_NUMBER[2];
            this.bitsOutputDone = 0;
            this.lowLevelState = 8;
            this.isReadFromDS = false;
        } else if (this.highLevelState == 19) {
            this.log.addLog("1W Command READROM 5. byte!", LogPanel.INFO);
            this.highLevelState = 20;
            this.currentByteOutput = this.SERIAL_NUMBER[3];
            this.currentWriteByteComplete = this.SERIAL_NUMBER[3];
            this.bitsOutputDone = 0;
            this.lowLevelState = 8;
            this.isReadFromDS = false;
        } else if (this.highLevelState == 20) {
            this.log.addLog("1W Command READROM 6. byte!", LogPanel.INFO);
            this.highLevelState = 21;
            this.currentByteOutput = this.SERIAL_NUMBER[4];
            this.currentWriteByteComplete = this.SERIAL_NUMBER[4];
            this.bitsOutputDone = 0;
            this.lowLevelState = 8;
            this.isReadFromDS = false;
        } else if (this.highLevelState == 21) {
            this.log.addLog("1W Command READROM 7. byte!", LogPanel.INFO);
            this.highLevelState = 22;
            this.currentByteOutput = this.SERIAL_NUMBER[5];
            this.currentWriteByteComplete = this.SERIAL_NUMBER[5];
            this.bitsOutputDone = 0;
            this.lowLevelState = 8;
            this.isReadFromDS = false;
        } else if (this.highLevelState == 22) {
            this.log.addLog("1W Command READROM 8. byte!", LogPanel.INFO);
            this.highLevelState = 23;
            this.currentWriteByteComplete = this.currentByteOutput = this.getCrc8();
            this.bitsOutputDone = 0;
            this.lowLevelState = 8;
            this.isReadFromDS = false;
        } else if (this.highLevelState == 23) {
            this.current1WCommand = 51;
            this.current2431Command = 0;
            this.lowLevelState = 5;
            this.highLevelState = 1;
            this.currentByteRead = 0;
            this.bitsLoaded = 0;
            this.log.addLog("DS2431 Command READROM - finished!", LogPanel.INFO);
        } else if (this.highLevelState == 1) {
            switch (this.currentByteRead) {
                case 240: {
                    this.current2431Command = 240;
                    this.loadBytesFromDisk();
                    this.lowLevelState = 5;
                    this.highLevelState = 2;
                    this.currentByteRead = 0;
                    this.bitsLoaded = 0;
                    this.log.addLog("DS2431 Command DS2431_READMEM - accepted! (" + this.cart.getPC() + ")", LogPanel.INFO);
                    break;
                }
                case 170: {
                    this.current2431Command = 170;
                    this.log.addLog("DS2431 Command DS2431_READSP - accepted! (" + this.cart.getPC() + ")", LogPanel.INFO);
                    this.highLevelState = 5;
                    this.lowLevelState = 8;
                    this.currentByteOutput = this.TA1;
                    this.currentWriteByteComplete = this.TA1;
                    this.currentWriteByteCompleteAddress = 255;
                    this.bitsOutputDone = 0;
                    this.isReadFromDS = false;
                    break;
                }
                case 15: {
                    this.isReadFromDS = true;
                    this.current2431Command = 15;
                    this.lowLevelState = 5;
                    this.highLevelState = 9;
                    this.currentByteRead = 0;
                    this.bitsLoaded = 0;
                    this.log.addLog("DS2431 Command DS2431_WRITESP - accepted! (" + this.cart.getPC() + ")", LogPanel.INFO);
                    break;
                }
                case 85: {
                    this.current2431Command = 85;
                    this.lowLevelState = 5;
                    this.highLevelState = 11;
                    this.currentByteRead = 0;
                    this.bitsLoaded = 0;
                    this.log.addLog("DS2431 Command DS2431_COPYSP - accepted! (" + this.cart.getPC() + ")", LogPanel.INFO);
                    break;
                }
                case 165: {
                    this.current2431Command = 165;
                    this.lowLevelState = 5;
                    this.highLevelState = 1;
                    this.currentByteRead = 0;
                    this.bitsLoaded = 0;
                    this.log.addLog("DS2431 Command DS2431_VALKEY - accepted! (" + this.cart.getPC() + ")", LogPanel.INFO);
                    break;
                }
                default: {
                    this.current2431Command = -1;
                    break;
                }
            }
        } else if (this.highLevelState == 2) {
            this.TA1 = this.currentByteRead;
            this.log.addLog("DS2431 Command READ TA1 Address received!", LogPanel.INFO);
            this.current2431Command = 170;
            this.lowLevelState = 5;
            this.highLevelState = 3;
            this.currentByteRead = 0;
            this.bitsLoaded = 0;
        } else if (this.highLevelState == 3) {
            this.TA2 = this.currentByteRead;
            this.currentOutputAddress = this.TA1 + 256 * this.TA2;
            this.log.addLog("DS2431 Command READ TA2 Address received!", LogPanel.INFO);
            if (this.current2431Command == 240) {
                this.initOutputNextByte();
            } else {
                this.initOutputNextByte();
            }
        } else if (this.highLevelState == 4) {
            this.highLevelState = 5;
            this.currentByteOutput = this.TA1;
            this.currentWriteByteComplete = this.TA1;
            this.currentWriteByteCompleteAddress = 255;
            this.bitsOutputDone = 0;
            this.lowLevelState = 8;
            this.isReadFromDS = false;
            this.log.addLog("DS2431 Command WRITE TA1 Address started!", LogPanel.INFO);
        } else if (this.highLevelState == 5) {
            this.log.addLog("TA1 Address written:" + String.format("$%02X", this.currentWriteByteComplete), LogPanel.INFO);
            this.highLevelState = 6;
            this.currentByteOutput = this.TA2;
            this.currentWriteByteComplete = this.TA2;
            this.currentWriteByteCompleteAddress = 255;
            this.bitsOutputDone = 0;
            this.lowLevelState = 8;
            this.isReadFromDS = false;
            this.log.addLog("DS2431 Command WRITE TA2 Address started!", LogPanel.INFO);
        } else if (this.highLevelState == 6) {
            this.log.addLog("TA2 Address written:" + String.format("$%02X", this.currentWriteByteComplete), LogPanel.INFO);
            this.highLevelState = 7;
            this.currentByteOutput = this.ES;
            this.currentWriteByteComplete = this.ES;
            this.currentWriteByteCompleteAddress = 255;
            this.bitsOutputDone = 0;
            this.lowLevelState = 8;
            this.isReadFromDS = false;
            this.log.addLog("DS2431 Command WRITE ES Address started!", LogPanel.INFO);
        } else if (this.highLevelState == 7) {
            this.log.addLog("ES Address written:" + String.format("$%02X", this.currentWriteByteComplete), LogPanel.INFO);
            this.currentOutputAddress = this.TA1 + 256 * this.TA2;
            this.log.addLog("DS2431 Continuing read from DS2431...", LogPanel.INFO);
            this.initOutputNextByte();
        } else if (this.highLevelState == 8) {
            this.log.addLog("DS2431 Continuing read from DS2431...", LogPanel.INFO);
            this.initOutputNextByte();
        } else if (this.highLevelState == 9) {
            this.TA1 = this.currentByteRead;
            this.isReadFromDS = true;
            this.current2431Command = 15;
            this.lowLevelState = 5;
            this.highLevelState = 10;
            this.currentByteRead = 0;
            this.bitsLoaded = 0;
            this.log.addLog("DS2431 Command WRITE Address TA1 received!", LogPanel.INFO);
        } else if (this.highLevelState == 10) {
            this.TA2 = this.currentByteRead;
            this.currentInputAddress = this.TA1 + 256 * this.TA2;
            this.log.addLog("DS2431 Command WRITE Address TA2 received!", LogPanel.INFO);
            this.initInputNextByte();
        } else if (this.highLevelState == 11) {
            this.TA1 = this.currentByteRead;
            this.isReadFromDS = true;
            this.lowLevelState = 5;
            this.highLevelState = 12;
            this.currentByteRead = 0;
            this.bitsLoaded = 0;
            this.log.addLog("DS2431 Command WRITE Address TA1 received!", LogPanel.INFO);
        } else if (this.highLevelState == 12) {
            this.TA2 = this.currentByteRead;
            this.currentInputAddress = this.TA1 + 256 * this.TA2;
            this.isReadFromDS = true;
            this.lowLevelState = 5;
            this.highLevelState = 13;
            this.currentByteRead = 0;
            this.bitsLoaded = 0;
            this.log.addLog("DS2431 Command WRITE Address TA2 received!", LogPanel.INFO);
        } else if (this.highLevelState == 13) {
            this.ES = this.currentByteRead;
            this.log.addLog("DS2431 Command WRITE Address ES received!", LogPanel.INFO);
            if (this.current2431Command == 85) {
                this.highLevelState = 1;
                this.saveBytestoDisk();
                this.log.addLog("Scratchpad DS2431 saved to disk!", LogPanel.INFO);
            } else {
                this.initInputNextByte();
            }
        } else if (this.highLevelState == 14) {
            this.log.addLog("DS2431 Continuing write to DS2431..., byte written " + String.format("$%02X", this.currentByteRead) + "->" + String.format("$%02X", this.currentInputAddress), LogPanel.INFO);
            this.epromData.data[this.currentInputAddress % 144] = (byte)this.currentByteRead;
            ++this.currentInputAddress;
            this.initInputNextByte();
        }
    }

    public static EpromData loadData(String serialname) {
        return (EpromData)CSAMainFrame.deserialize(serialname);
    }

    public static boolean saveData(String serialname, EpromData d) {
        return CSAMainFrame.serialize(d, serialname);
    }

    void loadBytesFromDisk() {
        this.epromData = DS2431.loadData(this.getSaveName());
        if (this.epromData == null) {
            this.epromData = new EpromData();
        }
    }

    void saveBytestoDisk() {
        DS2431.saveData(this.getSaveName(), this.epromData);
    }

    void initOutputNextByte() {
        this.highLevelState = 8;
        this.currentWriteByteComplete = this.currentByteOutput = this.epromData.data[this.currentOutputAddress % 144];
        this.currentWriteByteCompleteAddress = this.currentOutputAddress % 144;
        this.bitsOutputDone = 0;
        ++this.currentOutputAddress;
        this.lowLevelState = 8;
        this.isReadFromDS = false;
    }

    void initInputNextByte() {
        this.highLevelState = 14;
        this.bitsLoaded = 0;
        this.currentByteRead = 0;
        this.lowLevelState = 5;
        this.isReadFromDS = true;
    }

    public String getSaveName() {
        return this.cart.cartName + ".ds2431.ser";
    }

    @Override
    public boolean isActive() {
        return this.highLevelState != 0;
    }

    @Override
    public boolean usesPB6() {
        return true;
    }

    @Override
    public void lineIRQIn(boolean i) {
    }

    static class EpromData
    implements Serializable {
        byte[] data = new byte[144];

        EpromData() {
            int[] ast = new int[]{64, 96, 72, 0, 0, 143, 24, 52, 209, 237, 4, 0, 0, 14, 83, 3, 0, 0, 28, 175, 2, 0, 0, 36, 46, 1, 0, 0, 209, 237, 4, 0, 0, 14, 83, 3, 0, 0, 28, 175, 2, 0, 0, 36, 46, 1, 0, 0, 209, 237, 4, 0, 0, 14, 83, 3, 0, 0, 28, 175, 2, 0, 0, 36, 46, 1, 0, 0, 209, 237, 4, 0, 0, 14, 83, 3, 0, 0, 28, 175, 2, 0, 0, 36, 46, 1, 0, 0, 88, 163, 0, 80, 0, 82, 88, 0, 32, 0, 209, 237, 4, 0, 0, 14, 83, 3, 0, 0, 28, 175, 2, 0, 0, 36, 46, 1, 0, 0, 88, 163, 0, 80, 0, 82, 88, 0, 32, 0};
            for (int i = 0; i < 128; ++i) {
                this.data[i] = (byte)(ast[i] & 0xFF);
            }
        }
    }
}

