/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.vecx.cartridge;

import de.malban.vide.vecx.cartridge.Cartridge;
import de.malban.vide.vecx.cartridge.CartridgeInternalInterface;
import java.io.Serializable;

public class DualVec
implements Serializable,
CartridgeInternalInterface {
    private static DualVec[] dualVec = null;
    int side = 0;
    int otherSide = 1;
    Cartridge cart = null;
    boolean lineOut = true;
    static volatile boolean[] sync = new boolean[2];
    static volatile boolean[] syncDone = new boolean[2];
    public static boolean exitSync = false;
    boolean oldLine = true;

    public static DualVec getDualVec(int side, Cartridge c) {
        if (dualVec == null) {
            dualVec = new DualVec[2];
            DualVec.dualVec[0] = new DualVec();
            DualVec.dualVec[0].side = 0;
            DualVec.dualVec[0].otherSide = 1;
            DualVec.dualVec[1] = new DualVec();
            DualVec.dualVec[1].side = 1;
            DualVec.dualVec[1].otherSide = 0;
        }
        if (side < 0) {
            return null;
        }
        if (side > 1) {
            return null;
        }
        if (c != null) {
            dualVec[side].setCartridge(c);
        }
        return dualVec[side];
    }

    @Override
    public DualVec clone() {
        DualVec c = DualVec.getDualVec(this.side, null);
        return c;
    }

    public void setCartridge(Cartridge c) {
        this.cart = c;
    }

    private DualVec() {
    }

    @Override
    public void init() {
    }

    @Override
    public void deinit() {
    }

    @Override
    public void reset() {
    }

    @Override
    public void linePB6Out(boolean b) {
    }

    public String toString() {
        if (this.side == 0) {
            return "DualVec 1";
        }
        return "DualVec 2";
    }

    @Override
    public void step(long cycles) {
        this.syncStep();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncStep() {
        if (dualVec == null) {
            return;
        }
        if (dualVec[this.otherSide] == null) {
            return;
        }
        if (DualVec.dualVec[this.otherSide].cart == null) {
            return;
        }
        if (DualVec.dualVec[this.otherSide].cart.vecx == null) {
            return;
        }
        if (dualVec[this.side] == null) {
            return;
        }
        if (DualVec.dualVec[this.side].cart == null) {
            return;
        }
        if (DualVec.dualVec[this.side].cart.vecx == null) {
            return;
        }
        DualVec.sync[this.side] = true;
        DualVec.syncDone[this.side] = false;
        try {
            while (!sync[this.otherSide]) {
                if (dualVec == null) {
                    return;
                }
                if (dualVec[this.otherSide] == null) {
                    return;
                }
                if (DualVec.dualVec[this.otherSide].cart == null) {
                    return;
                }
                if (exitSync) {
                    return;
                }
                if (!DualVec.dualVec[this.otherSide].cart.vecx.isDebugging() || !DualVec.dualVec[this.side].cart.vecx.isDebugging()) continue;
            }
            DualVec[] dualVecArray = dualVec;
            synchronized (dualVec) {
                if (this.oldLine != this.lineOut) {
                    DualVec.dualVec[this.otherSide].cart.setPB6FromCartridge(this.lineOut);
                }
                this.oldLine = this.lineOut;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                DualVec.syncDone[this.side] = true;
                while (!syncDone[this.otherSide]) {
                    if (dualVec == null) {
                        return;
                    }
                    if (dualVec[this.otherSide] == null) {
                        return;
                    }
                    if (DualVec.dualVec[this.otherSide].cart == null) {
                        return;
                    }
                    if (exitSync) {
                        return;
                    }
                    if (!DualVec.dualVec[this.otherSide].cart.vecx.isDebugging() || !DualVec.dualVec[this.side].cart.vecx.isDebugging()) continue;
                    break;
                }
            }
        }
        catch (Throwable e) {
            DualVec.syncDone[this.side] = true;
        }
        {
            DualVec.sync[this.side] = false;
            return;
        }
    }

    @Override
    public void linePB6In(boolean b) {
        this.lineOut = b;
    }

    @Override
    public boolean usesPB6() {
        return true;
    }

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    public void lineIRQIn(boolean i) {
    }
}

