/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.vecx.cartridge;

import de.malban.config.Configuration;
import de.malban.gui.CSAMainFrame;
import de.malban.gui.panels.LogPanel;
import de.malban.vide.dissy.DASM6809;
import de.malban.vide.vecx.cartridge.Cartridge;
import de.malban.vide.vecx.cartridge.CartridgeInternalInterface;
import java.io.Serializable;

public class Microchip11AA010
implements Serializable,
CartridgeInternalInterface {
    transient LogPanel log = (LogPanel)Configuration.getConfiguration().getDebugEntity();
    public static final int MAX_DATA_LEN = 128;
    public transient Cartridge cart;
    EpromData epromData = new EpromData();
    public static final transient int LL_NONE = 0;
    public static final transient int LL_STANDBY = 1;
    public static final transient int LL_ACTIVE = 2;
    public static final transient int LL_START_HEADER = 3;
    public static final transient int LL_IN_HEADER_0 = 4;
    public static final transient int LL_IN_HEADER_1 = 5;
    public static final transient int LL_IN_HEADER_FINISH = 6;
    public static final transient int LL_DELAY = 7;
    String[] ll_names = new String[]{"NONE", "STANDBY", "ACTIVE", "START_HEADER", "IN_HEADER_0", "IN_HEADER_1", "IN_HEADER_FINISH", "DELAY"};
    public static final transient int maxFreqCycles = 15;
    public static final transient int minFreqCycles = 150;
    public static final transient int standByPulseTimerCycles = 900;
    public static final transient int startHeaderLowPulseCycles = 8;
    public static final transient int startHeaderSetupCycles = 15;
    public static final transient int writeCycleTimeByteCycles = 7500;
    public static final transient int writeCycleTimePageCycles = 15000;
    public static final transient int COMMAND_NONE = 0;
    public static final transient int COMMAND_READ = 3;
    public static final transient int COMMAND_CRRD = 6;
    public static final transient int COMMAND_WRITE = 108;
    public static final transient int COMMAND_WREN = 150;
    public static final transient int COMMAND_WRDI = 145;
    public static final transient int COMMAND_RDSR = 5;
    public static final transient int COMMAND_WRSR = 110;
    public static final transient int COMMAND_ERAL = 109;
    public static final transient int COMMAND_SETAL = 103;
    int currentCommand = 0;
    public static final transient int ML_NONE = 0;
    public static final transient int ML_MAK = 1;
    public static final transient int ML_SAK = 2;
    public static final transient int ML_NOMAK = 3;
    public static final transient int ML_NOSAK = 4;
    public static final transient int ML_DEV_ADDRESS = 5;
    public static final transient int ML_DELAY_TSS = 6;
    public static final transient int ML_DELAY_THDR = 7;
    public static final transient int ML_COMMAND = 8;
    public static final transient int ML_ADDRESS_HI = 9;
    public static final transient int ML_ADDRESS_LO = 10;
    public static final transient int ML_BYTE_FROM_MC = 11;
    public static final transient int ML_BYTE_TO_MC = 12;
    public static final transient int ML_DELAY_BYTE_WRITE = 13;
    public static final transient int ML_DELAY_PAGE_WRITE = 14;
    public static final transient int ML_WAIT_FOR_HEADER = 15;
    public static final transient int ML_MAK_OR_NO_MAK = 16;
    String[] ml_names = new String[]{"NONE", "MAK", "SAK", "NOMAK", "NOSAK", "DEV_ADDRESS", "DELAY_TSS", "DELAY_THDR", "COMMAND", "ADDRESS_HI", "ADDRESS_LO", "BYTE_FROM_MC", "BYTE_TO_MC", "DELAY_BYTE_WRITE", "DELAY_PAGE_WRITE", "WAIT_FOR_HEADER", "MAK_OR_NO_MAK"};
    public static final transient int HL_NONE = 0;
    public static final transient int HL_HEADER_FINISH = 1;
    public static final transient int HL_COMMAND = 2;
    public static final transient int HL_ADDRESS = 3;
    public static final transient int HL_BYTE_FROM_MC = 4;
    public static final transient int HL_BYTE_TO_MC_NOMAK = 5;
    public static final transient int HL_BYTE_DELAY = 6;
    public static final transient int HL_PAGE_DELAY = 7;
    public static final transient int HL_WAIT_FOR_HEADER = 8;
    public static final transient int HL_BYTE_TO_MC = 9;
    public static final transient int HL_LAST = 10;
    String[] hl_names = new String[]{"NONE", "HEADER_FINISH", "COMMAND", "ADDRESS", "BYTE_FROM_MC", "BYTE_TO_MC_NOMAK", "BYTE_DELAY", "PAGE_DELAY", "WAIT_FOR_HEADER", "BYTE_TO_MC"};
    static transient int[][] high_level_stateSequence;
    static final transient int[] hl_none;
    static final transient int[] hl_header_finish;
    static final transient int[] hl_command;
    static final transient int[] hl_address;
    static final transient int[] hl_byte_from_mc;
    static final transient int[] hl_byte_to_mc_nomak;
    static final transient int[] hl_byte_to_mc;
    static final transient int[] hl_byte_delay;
    static final transient int[] hl_page_delay;
    static final transient int[] hl_wait_for_header;
    int mc_status_register = 0;
    int mc_address_register = 0;
    int mc_writeTimer = 0;
    boolean mc_writeEnable = false;
    long cycles = 0L;
    boolean lineIn = false;
    boolean old_lineIn = false;
    boolean lineOut = false;
    int bitSequenceTimer = 0;
    boolean commandStart = true;
    int lowLevelState = 1;
    int mediumLevelState = 0;
    int highLevelState = 0;
    int highLevelSequenceCounter;
    public static transient int MAK;
    public static transient int NOMAK;
    public static transient int NONE;
    int lastMasterAk = NONE;
    boolean isInputToMicrochip = true;
    public static final transient int MANCHESTER_SWITCH_NONE = 0;
    public static final transient int MANCHESTER_SWITCH_TRUE = 1;
    public static final transient int MANCHESTER_SWITCH_FALSE = -1;
    int lowLevelSwitch;
    int manchester0 = 0;
    int manchester1 = 0;
    int bitCounter = 0;
    long syncCounter = 0L;
    long headerSyncCounter = 0L;
    int dataByte = 0;
    long lastCalledCycles = 0L;
    boolean firstChangeDone = false;
    int delayValue = 0;
    int writeState = 0;

    public byte[] getData() {
        return this.epromData.data;
    }

    @Override
    public void init() {
        if (this.log == null) {
            this.log = (LogPanel)Configuration.getConfiguration().getDebugEntity();
        }
    }

    @Override
    public void deinit() {
    }

    public Microchip11AA010(Cartridge c) {
        this.cart = c;
    }

    @Override
    public Microchip11AA010 clone() {
        Microchip11AA010 c = new Microchip11AA010(this.cart);
        for (int i = 0; i < 128; ++i) {
            c.epromData.data[i] = this.epromData.data[i];
        }
        c.cycles = this.cycles;
        c.lineIn = this.lineIn;
        c.old_lineIn = this.old_lineIn;
        c.lineOut = this.lineOut;
        c.mc_status_register = this.mc_status_register;
        c.mc_address_register = this.mc_address_register;
        c.mc_writeEnable = this.mc_writeEnable;
        c.mc_writeTimer = this.mc_writeTimer;
        c.bitSequenceTimer = this.bitSequenceTimer;
        c.currentCommand = this.currentCommand;
        c.lowLevelState = this.lowLevelState;
        c.mediumLevelState = this.mediumLevelState;
        c.highLevelState = this.highLevelState;
        c.highLevelSequenceCounter = this.highLevelSequenceCounter;
        c.isInputToMicrochip = this.isInputToMicrochip;
        c.lowLevelSwitch = this.lowLevelSwitch;
        c.bitCounter = this.bitCounter;
        c.syncCounter = this.syncCounter;
        c.headerSyncCounter = this.headerSyncCounter;
        c.dataByte = this.dataByte;
        c.lastCalledCycles = this.lastCalledCycles;
        c.firstChangeDone = this.firstChangeDone;
        c.delayValue = this.delayValue;
        c.writeState = this.writeState;
        c.manchester0 = this.manchester0;
        c.manchester1 = this.manchester1;
        c.lastMasterAk = this.lastMasterAk;
        c.commandStart = this.commandStart;
        return c;
    }

    void doError() {
        this.resetStandby();
        this.log.addLog("Microchip11AA010: ERROR - Standby entered!", LogPanel.ERROR);
    }

    @Override
    public void reset() {
        this.loadBytesFromDisk();
        this.resetStandby();
        this.mc_writeEnable = false;
        this.mc_writeTimer = 0;
    }

    public void resetStandby() {
        this.manchester0 = 0;
        this.manchester1 = 0;
        this.lowLevelState = 1;
        this.highLevelState = 0;
        this.currentCommand = 0;
        this.mediumLevelState = 0;
        this.lowLevelSwitch = 0;
        this.syncCounter = 0L;
        this.bitSequenceTimer = 0;
    }

    boolean checkCommand() {
        boolean ok = false;
        if (this.currentCommand == 3) {
            this.log.addLog("Microchip11AA010: Command got: READ!", LogPanel.INFO);
            ok = true;
        } else if (this.currentCommand == 6) {
            this.log.addLog("Microchip11AA010: Command got: CRRD!", LogPanel.INFO);
            ok = true;
        } else if (this.currentCommand == 108) {
            this.log.addLog("Microchip11AA010: Command got: WRITE!", LogPanel.INFO);
            ok = true;
        } else if (this.currentCommand == 150) {
            this.log.addLog("Microchip11AA010: Command got: WREN!", LogPanel.INFO);
            ok = true;
        } else if (this.currentCommand == 145) {
            this.log.addLog("Microchip11AA010: Command got: WRDI!", LogPanel.INFO);
            ok = true;
        } else if (this.currentCommand == 5) {
            this.log.addLog("Microchip11AA010: Command got: RDSR!", LogPanel.INFO);
            ok = true;
        } else if (this.currentCommand == 110) {
            this.log.addLog("Microchip11AA010: Command got: WRSR!", LogPanel.INFO);
            ok = true;
        } else if (this.currentCommand == 109) {
            this.log.addLog("Microchip11AA010: Command got: ERAL!", LogPanel.INFO);
            ok = true;
        } else if (this.currentCommand == 103) {
            this.log.addLog("Microchip11AA010: Command got: SETAL!", LogPanel.INFO);
            ok = true;
        }
        return ok;
    }

    public String getLowLevelName() {
        return this.ll_names[this.lowLevelState];
    }

    public String getMediumLevelName() {
        return this.ml_names[this.mediumLevelState];
    }

    public String getHighLevelName() {
        return this.hl_names[this.highLevelState];
    }

    public String getCommandName() {
        if (this.currentCommand == 3) {
            return "READ";
        }
        if (this.currentCommand == 6) {
            return "CRRD";
        }
        if (this.currentCommand == 108) {
            return "WRITE";
        }
        if (this.currentCommand == 150) {
            return "WREN";
        }
        if (this.currentCommand == 145) {
            return "WRDI";
        }
        if (this.currentCommand == 5) {
            return "RDSR";
        }
        if (this.currentCommand == 110) {
            return "WRSR";
        }
        if (this.currentCommand == 109) {
            return "ERAL";
        }
        if (this.currentCommand == 103) {
            return "SETAL";
        }
        return "unkown";
    }

    public String getStatusRegister() {
        int reg = this.mc_status_register & 0xC;
        if (this.mc_writeEnable) {
            reg |= 2;
        }
        if (this.mc_writeTimer > 0) {
            reg |= 1;
        }
        return "" + DASM6809.printbinary(reg);
    }

    public String getAddressRegister() {
        return "" + this.mc_address_register;
    }

    public String getManchester0() {
        if (this.manchester0 == -1) {
            return "false";
        }
        if (this.manchester0 == 1) {
            return "true";
        }
        return "none";
    }

    public String getManchester1() {
        if (this.manchester1 == -1) {
            return "false";
        }
        if (this.manchester1 == 1) {
            return "true";
        }
        return "none";
    }

    public boolean isInputToMicrochip() {
        return this.isInputToMicrochip;
    }

    public String getWriteTimer() {
        if (this.mc_writeTimer <= 0) {
            return "none";
        }
        return "" + this.mc_writeTimer;
    }

    public String getSyncBase() {
        return "" + this.bitSequenceTimer;
    }

    public String getSyncCounter() {
        if (this.syncCounter <= 0L) {
            return "no sync";
        }
        return "" + this.syncCounter;
    }

    public String getLineIn() {
        if (this.lineIn) {
            return "1";
        }
        return "0";
    }

    public String getLineOut() {
        if (this.lineOut) {
            return "1";
        }
        return "0";
    }

    public String getBitCounter() {
        return "" + this.bitCounter;
    }

    public String getBit() {
        if (this.lowLevelSwitch == -1) {
            return "false";
        }
        if (this.lowLevelSwitch == 1) {
            return "true";
        }
        return "none";
    }

    @Override
    public void linePB6In(boolean l) {
        this.lineIn = l;
    }

    @Override
    public void linePB6Out(boolean l) {
        this.lineOut = l;
        this.cart.setPB6FromCartridge(this.lineOut);
    }

    public static EpromData loadData(String serialname) {
        return (EpromData)CSAMainFrame.deserialize(serialname);
    }

    public static boolean saveData(String serialname, EpromData d) {
        return CSAMainFrame.serialize(d, serialname);
    }

    void loadBytesFromDisk() {
        this.epromData = Microchip11AA010.loadData(this.getSaveName());
        if (this.epromData == null) {
            this.epromData = new EpromData();
        }
    }

    void saveBytestoDisk() {
        Microchip11AA010.saveData(this.getSaveName(), this.epromData);
    }

    public String getSaveName() {
        return this.cart.cartName + ".microchip.ser";
    }

    @Override
    public void step(long c) {
        long difLast = c - this.lastCalledCycles;
        this.mc_writeTimer = (int)((long)this.mc_writeTimer - difLast);
        if (this.mc_writeTimer < 0) {
            this.mc_writeTimer = 0;
        }
        this.syncCounter += difLast;
        this.lastCalledCycles = c;
        long difLastChange = c - this.cycles;
        boolean change = this.lineIn != this.old_lineIn;
        this.old_lineIn = this.lineIn;
        if (!this.isInputToMicrochip) {
            this.cycles = c;
        }
        if (change) {
            this.cycles = c;
        }
        if (this.lineIn && difLastChange > 900L) {
            if (this.lowLevelState == 1) {
                return;
            }
            this.resetStandby();
            this.log.addLog("Microchip11AA010: Standby entered!", LogPanel.INFO);
            return;
        }
        if (this.lowLevelState == 7) {
            if (this.syncCounter >= (long)this.delayValue) {
                this.handleOneSequence();
            } else {
                return;
            }
        }
        if (this.highLevelState == 0) {
            this.checkHeaderSteps(c, change);
            return;
        }
        int mediumCycles = this.bitSequenceTimer / 2;
        int mediumRange = mediumCycles / 10;
        if (this.isInputToMicrochip) {
            if (change) {
                if (this.syncCounter <= (long)mediumRange) {
                    this.manchester0 = this.lineIn ? 1 : -1;
                }
                if (this.firstChangeDone) {
                    this.manchester1 = this.lineIn ? 1 : -1;
                } else if (this.syncCounter + (long)mediumRange >= (long)this.bitSequenceTimer) {
                    this.manchester1 = this.lineIn ? 1 : -1;
                }
                if (Math.abs(this.syncCounter - (long)mediumCycles) <= (long)mediumRange || this.syncCounter > (long)mediumCycles && !this.firstChangeDone) {
                    this.lowLevelSwitch = this.lineIn ? 1 : -1;
                    this.syncCounter = this.bitSequenceTimer / 2;
                    this.firstChangeDone = true;
                } else if (this.syncCounter <= (long)mediumRange) {
                    this.syncCounter = 0L;
                    this.firstChangeDone = true;
                } else if (this.syncCounter + (long)mediumRange >= (long)this.bitSequenceTimer) {
                    this.syncCounter = this.bitSequenceTimer;
                }
            }
        } else if (this.syncCounter <= (long)mediumRange) {
            if (this.writeState == 0) {
                if (this.lowLevelSwitch == 1) {
                    this.linePB6Out(false);
                } else if (this.lowLevelSwitch == -1) {
                    this.linePB6Out(true);
                } else if (this.lowLevelSwitch == 0) {
                    // empty if block
                }
                this.syncCounter = 0L;
                ++this.writeState;
                this.manchester0 = this.lineOut ? 1 : -1;
            }
        } else if (this.syncCounter >= (long)mediumCycles) {
            if (this.writeState == 1) {
                if (this.lowLevelSwitch == 1) {
                    this.linePB6Out(true);
                } else if (this.lowLevelSwitch == -1) {
                    this.linePB6Out(false);
                } else if (this.lowLevelSwitch == 0) {
                    // empty if block
                }
                ++this.writeState;
                this.syncCounter = this.bitSequenceTimer / 2;
            }
            this.manchester1 = this.lineOut ? 1 : -1;
        } else if (this.syncCounter >= (long)this.bitSequenceTimer && this.writeState == 2) {
            ++this.writeState;
        }
        if (this.syncCounter >= (long)this.bitSequenceTimer) {
            this.handleOneSequence();
            this.firstChangeDone = false;
        }
    }

    void checkHeaderSteps(long c, boolean change) {
        this.bitSequenceTimer = 0;
        this.lastMasterAk = NONE;
        this.currentCommand = 0;
        if (!(this.lowLevelState != 1 && this.lowLevelState != 0 || this.lineIn)) {
            if (this.lowLevelState == 1) {
                this.log.addLog("Microchip11AA010: Activation impulse found (from standby)!", LogPanel.INFO);
            } else {
                this.log.addLog("Microchip11AA010: Activation impulse found (from 'wait for header')!", LogPanel.INFO);
            }
            this.lowLevelState = 3;
            return;
        }
        if (!change) {
            return;
        }
        if (this.lowLevelState == 3 && this.lineIn) {
            this.log.addLog("Microchip11AA010: Activation impulse ended, reading bit 0 of header!", LogPanel.VERBOSE);
            this.lowLevelState = 4;
            this.headerSyncCounter = this.cycles;
            this.manchester0 = 1;
            this.manchester1 = 0;
            this.bitCounter = 0;
            this.dataByte = 0;
            return;
        }
        if (this.lowLevelState == 4 && !this.lineIn) {
            this.log.addLog("Microchip11AA010: Receive header bit (" + this.bitCounter + ") =  0!", LogPanel.VERBOSE);
            this.lowLevelState = 5;
            this.dataByte <<= 1;
            this.dataByte += 0;
            this.manchester0 = 1;
            this.manchester1 = -1;
            ++this.bitCounter;
            return;
        }
        if (this.lowLevelState == 5 && this.lineIn) {
            this.lowLevelState = 4;
            this.log.addLog("Microchip11AA010: Receive header bit (" + this.bitCounter + ") =  1!", LogPanel.VERBOSE);
            this.manchester0 = -1;
            this.manchester1 = 1;
            this.dataByte <<= 1;
            ++this.dataByte;
            ++this.bitCounter;
            if (this.bitCounter == 8) {
                this.lowLevelState = 6;
            }
            return;
        }
        if (this.lowLevelState == 6 && !this.lineIn) {
            if (this.dataByte != 85) {
                this.log.addLog("Microchip11AA010: header byte is incorrect (" + DASM6809.printbinary(this.dataByte) + ")!", LogPanel.INFO);
                this.doError();
                return;
            }
            this.log.addLog("Microchip11AA010: header byte is correct (0101 0101)!", LogPanel.INFO);
            int periodLength = (int)(this.cycles - this.headerSyncCounter);
            this.bitSequenceTimer = periodLength / 8;
            this.bitSequenceTimer += 2;
            this.log.addLog("Microchip11AA010: Receive header finish: sequence length in vectrex cycles: " + this.bitSequenceTimer, LogPanel.INFO);
            this.initHighLevel(1);
            return;
        }
    }

    void initHighLevel(int hl) {
        this.lastMasterAk = NONE;
        this.highLevelState = hl;
        this.highLevelSequenceCounter = 0;
        this.initMediumLevel(high_level_stateSequence[this.highLevelState][this.highLevelSequenceCounter]);
    }

    void initMediumLevel(int ml) {
        this.lowLevelState = 0;
        this.mediumLevelState = ml;
        if (this.mediumLevelState == 0) {
            this.isInputToMicrochip = true;
        }
        if (this.mediumLevelState == 1) {
            this.isInputToMicrochip = true;
        }
        if (this.mediumLevelState == 3) {
            this.isInputToMicrochip = true;
        }
        if (this.mediumLevelState == 16) {
            this.isInputToMicrochip = true;
        }
        if (this.mediumLevelState == 2) {
            this.isInputToMicrochip = false;
        }
        if (this.mediumLevelState == 4) {
            this.isInputToMicrochip = false;
        }
        if (this.mediumLevelState == 8) {
            this.isInputToMicrochip = true;
        }
        if (this.mediumLevelState == 5) {
            this.isInputToMicrochip = true;
        }
        if (this.mediumLevelState == 6) {
            this.isInputToMicrochip = true;
        }
        if (this.mediumLevelState == 7) {
            this.isInputToMicrochip = true;
        }
        if (this.mediumLevelState == 13) {
            this.isInputToMicrochip = true;
        }
        if (this.mediumLevelState == 14) {
            this.isInputToMicrochip = true;
        }
        if (this.mediumLevelState == 15) {
            this.isInputToMicrochip = true;
        }
        if (this.mediumLevelState == 9) {
            this.isInputToMicrochip = true;
        }
        if (this.mediumLevelState == 10) {
            this.isInputToMicrochip = true;
        }
        if (this.mediumLevelState == 11) {
            this.isInputToMicrochip = false;
        }
        if (this.mediumLevelState == 12) {
            this.isInputToMicrochip = true;
        }
        switch (this.mediumLevelState) {
            case 11: {
                if (this.currentCommand == 5) {
                    int reg = this.mc_status_register & 0xC;
                    if (this.mc_writeEnable) {
                        reg |= 2;
                    }
                    if (this.mc_writeTimer > 0) {
                        reg |= 1;
                    }
                    this.dataByte = reg;
                    this.log.addLog("Microchip11AA010: initMediumLevel() byte write initiated " + this.mediumLevelState + ", from status register, value: $" + String.format("%02X", reg), LogPanel.VERBOSE);
                }
                if (this.currentCommand == 3) {
                    this.log.addLog("Microchip11AA010: initMediumLevel() byte write initiated " + this.mediumLevelState + ", from address $" + String.format("%04X", this.mc_address_register), LogPanel.VERBOSE);
                    this.dataByte = this.epromData.data[this.mc_address_register];
                }
                this.bitCounter = 0;
                if ((this.dataByte & 0x80) == 128) {
                    this.lowLevelSwitch = 1;
                    this.log.addLog("Microchip11AA010: bit(" + this.bitCounter + ") write 1", LogPanel.VERBOSE);
                    break;
                }
                this.lowLevelSwitch = -1;
                this.log.addLog("Microchip11AA010: bit(" + this.bitCounter + ") write 0", LogPanel.VERBOSE);
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 12: {
                this.log.addLog("Microchip11AA010: initMediumLevel() byte read initiated " + this.mediumLevelState, LogPanel.VERBOSE);
                this.bitCounter = 0;
                this.dataByte = 0;
                break;
            }
            case 13: {
                this.log.addLog("Microchip11AA010: initMediumLevel() byte delay initiated " + this.mediumLevelState, LogPanel.VERBOSE);
                this.lowLevelState = 7;
                this.delayValue = 7500;
                break;
            }
            case 14: {
                this.log.addLog("Microchip11AA010: initMediumLevel() page delay initiated " + this.mediumLevelState, LogPanel.VERBOSE);
                this.lowLevelState = 7;
                this.delayValue = 15000;
                break;
            }
            case 6: {
                this.log.addLog("Microchip11AA010: initMediumLevel() tss delay initiated " + this.mediumLevelState, LogPanel.VERBOSE);
                this.lowLevelState = 7;
                this.delayValue = 15;
                break;
            }
            case 7: {
                this.log.addLog("Microchip11AA010: initMediumLevel() thdr delay initiated " + this.mediumLevelState, LogPanel.VERBOSE);
                this.lowLevelState = 7;
                this.delayValue = 8;
                break;
            }
            case 15: {
                this.log.addLog("Microchip11AA010: initMediumLevel() wait for header initiated " + this.mediumLevelState, LogPanel.VERBOSE);
                this.highLevelState = 0;
                break;
            }
            case 16: {
                this.lastMasterAk = NONE;
                this.log.addLog("Microchip11AA010: initMediumLevel() MAK OR NOMAK initiated " + this.mediumLevelState, LogPanel.VERBOSE);
                break;
            }
            case 1: {
                this.log.addLog("Microchip11AA010: initMediumLevel() MAK initiated " + this.mediumLevelState, LogPanel.VERBOSE);
                break;
            }
            case 3: {
                this.log.addLog("Microchip11AA010: initMediumLevel() NOMAK initiated " + this.mediumLevelState, LogPanel.VERBOSE);
                break;
            }
            case 2: {
                this.log.addLog("Microchip11AA010: initMediumLevel() SAK initiated " + this.mediumLevelState, LogPanel.VERBOSE);
                this.lowLevelSwitch = 1;
                break;
            }
            case 4: {
                this.log.addLog("Microchip11AA010: initMediumLevel() NOSAK initiated " + this.mediumLevelState, LogPanel.VERBOSE);
                this.lowLevelSwitch = 0;
                break;
            }
            default: {
                this.log.addLog("Microchip11AA010: initMediumLevel() ERROR unkown ML STATUS: " + this.mediumLevelState, LogPanel.ERROR);
            }
        }
        if (this.isInputToMicrochip) {
            this.initLowLevelRead();
        } else {
            this.initLowLevelWrite();
        }
    }

    void initLowLevelWrite() {
        this.syncCounter = 0L;
        this.writeState = 0;
    }

    void initLowLevelRead() {
        this.syncCounter = 0L;
        this.lowLevelSwitch = 0;
    }

    void handleOneSequence() {
        boolean ok = false;
        this.manchester0 = 0;
        this.manchester1 = 0;
        switch (this.mediumLevelState) {
            case 16: {
                int hi;
                if (this.commandStart) {
                    if (this.lowLevelSwitch == -1) {
                        ok = true;
                        this.log.addLog("Microchip11AA010: NOMAK received!", LogPanel.INFO);
                        this.lastMasterAk = NOMAK;
                    } else if (this.lowLevelSwitch == 1) {
                        ok = true;
                        this.log.addLog("Microchip11AA010: MAK received!", LogPanel.INFO);
                        this.lastMasterAk = MAK;
                    } else {
                        this.log.addLog("Microchip11AA010: no (MAK or NOMAK) received!", LogPanel.INFO);
                    }
                    this.commandStart = false;
                    break;
                }
                if (this.currentCommand == 108) {
                    this.log.addLog("Microchip11AA010: WRITE data ($" + String.format("%02X", this.dataByte) + ") to MC address: $" + String.format("%04X", this.mc_address_register) + "!", LogPanel.INFO);
                    int block = 0;
                    if (this.mc_address_register >= 32) {
                        ++block;
                    }
                    if (this.mc_address_register >= 64) {
                        ++block;
                    }
                    if (this.mc_address_register >= 96) {
                        ++block;
                    }
                    if (!this.isProtected(block)) {
                        this.epromData.data[this.mc_address_register] = (byte)this.dataByte;
                    } else {
                        this.log.addLog("Microchip11AA010: WRITE error, address is write protected!", LogPanel.INFO);
                    }
                }
                if (this.lowLevelSwitch == -1) {
                    ok = true;
                    this.log.addLog("Microchip11AA010: NOMAK received!", LogPanel.INFO);
                    if (this.currentCommand == 3 || this.currentCommand == 6) {
                        ++this.mc_address_register;
                    }
                    if (this.currentCommand == 108) {
                        hi = this.mc_address_register & 0xF0;
                        int lo = this.mc_address_register & 0xF;
                        lo = (lo + 1) % 16;
                        this.mc_address_register = hi + lo;
                    }
                    this.mc_address_register %= 128;
                    this.lastMasterAk = NOMAK;
                    break;
                }
                if (this.lowLevelSwitch == 1) {
                    ok = true;
                    this.log.addLog("Microchip11AA010: MAK received - high level command repeated!", LogPanel.INFO);
                    if (this.currentCommand == 3 || this.currentCommand == 6) {
                        ++this.mc_address_register;
                    }
                    if (this.currentCommand == 108) {
                        hi = this.mc_address_register & 0xF0;
                        int lo = this.mc_address_register & 0xF;
                        lo = (lo + 1) % 16;
                        this.mc_address_register = hi + lo;
                    }
                    this.mc_address_register %= 128;
                    this.lastMasterAk = MAK;
                    break;
                }
                this.log.addLog("Microchip11AA010: no (MAK or NOMAK) received!", LogPanel.INFO);
                break;
            }
            case 11: {
                ++this.bitCounter;
                if (this.bitCounter < 8) {
                    this.dataByte = this.dataByte << 1 & 0xFF;
                    if ((this.dataByte & 0x80) == 128) {
                        this.lowLevelSwitch = 1;
                        this.log.addLog("Microchip11AA010: bit(" + this.bitCounter + ") write 1", LogPanel.VERBOSE);
                    } else {
                        this.lowLevelSwitch = -1;
                        this.log.addLog("Microchip11AA010: bit(" + this.bitCounter + ") write 0", LogPanel.VERBOSE);
                    }
                    this.initLowLevelWrite();
                    return;
                }
                ok = true;
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 12: {
                if (this.bitCounter < 8) {
                    this.dataByte <<= 1;
                    if (this.lowLevelSwitch == 1) {
                        ++this.dataByte;
                        this.log.addLog("Microchip11AA010: bit(" + this.bitCounter + ") received: 1", LogPanel.VERBOSE);
                    } else if (this.lowLevelSwitch == -1) {
                        this.log.addLog("Microchip11AA010: bit(" + this.bitCounter + ") received: 0", LogPanel.VERBOSE);
                    } else {
                        this.log.addLog("Microchip11AA010: bit(" + this.bitCounter + ") received: ?", LogPanel.VERBOSE);
                        this.doError();
                        return;
                    }
                    this.initLowLevelRead();
                    ++this.bitCounter;
                }
                if (this.bitCounter < 8) {
                    return;
                }
                if (this.mediumLevelState == 10) {
                    this.mc_address_register = (this.mc_address_register & 0xFF00) + this.dataByte;
                    ok = true;
                    break;
                }
                if (this.mediumLevelState == 9) {
                    this.mc_address_register = (this.mc_address_register & 0xFF) + (this.dataByte << 8);
                    ok = true;
                    break;
                }
                if (this.mediumLevelState == 5) {
                    boolean bl = ok = this.dataByte == 160;
                    if (ok) {
                        this.log.addLog("Microchip11AA010: device byte correctly received (1010 0000)!", LogPanel.INFO);
                        break;
                    }
                    this.log.addLog("Microchip11AA010: device byte is incorrect (" + DASM6809.printbinary(this.dataByte) + ")!", LogPanel.INFO);
                    break;
                }
                if (this.mediumLevelState == 8) {
                    this.currentCommand = this.dataByte;
                    ok = this.checkCommand();
                    if (!ok) {
                        this.log.addLog("Microchip11AA010: Command unkown ($" + String.format("%02X", this.dataByte) + ")!", LogPanel.WARN);
                        break;
                    }
                    this.commandStart = true;
                    break;
                }
                this.log.addLog("Microchip11AA010: byte received ($" + String.format("%02X", this.dataByte) + ")!", LogPanel.INFO);
                ok = true;
                break;
            }
            case 3: {
                if (this.lowLevelSwitch == -1) {
                    ok = true;
                    this.log.addLog("Microchip11AA010: NOMAK received!", LogPanel.INFO);
                    break;
                }
                this.log.addLog("Microchip11AA010: NOMAK not received!", LogPanel.INFO);
                break;
            }
            case 1: {
                if (this.lowLevelSwitch == 1) {
                    ok = true;
                    this.log.addLog("Microchip11AA010: MAK received!", LogPanel.INFO);
                    break;
                }
                this.log.addLog("Microchip11AA010: MAK not received!", LogPanel.INFO);
                break;
            }
            case 2: {
                ok = true;
                this.log.addLog("Microchip11AA010: SAK sent!", LogPanel.INFO);
                break;
            }
            case 4: {
                ok = true;
                this.log.addLog("Microchip11AA010: NOSAK sent!", LogPanel.INFO);
                break;
            }
            case 6: {
                ok = true;
                this.log.addLog("Microchip11AA010: TSS wait!", LogPanel.INFO);
                break;
            }
            case 7: {
                ok = true;
                this.log.addLog("Microchip11AA010: THDR wait!", LogPanel.INFO);
                break;
            }
            case 15: {
                --this.highLevelSequenceCounter;
                ok = true;
                this.log.addLog("Microchip11AA010: Header wait!", LogPanel.INFO);
                break;
            }
            default: {
                this.log.addLog("Microchip11AA010: handleOneSequence() ERROR unkown ML STATUS: " + this.mediumLevelState, LogPanel.ERROR);
            }
        }
        if (ok) {
            if (this.highLevelSequenceCounter + 1 < high_level_stateSequence[this.highLevelState].length) {
                ++this.highLevelSequenceCounter;
                this.initMediumLevel(high_level_stateSequence[this.highLevelState][this.highLevelSequenceCounter]);
            } else {
                this.nextHighlevel();
            }
        } else {
            this.doError();
        }
    }

    void nextHighlevel() {
        block0 : switch (this.highLevelState) {
            case 1: {
                this.log.addLog("Microchip11AA010: HL_HEADER_FINISH done", LogPanel.VERBOSE);
                this.initHighLevel(2);
                break;
            }
            case 5: {
                switch (this.currentCommand) {
                    case 110: {
                        this.log.addLog("Microchip11AA010: HL_BYTE_TO_MC_NOMAK->WRSR done", LogPanel.VERBOSE);
                        this.mc_status_register = this.dataByte & 0xC;
                        this.mc_writeTimer = 7500;
                        this.log.addLog("Microchip11AA010: Status register set to: $" + String.format("%02X", this.dataByte), LogPanel.INFO);
                        this.initHighLevel(6);
                        this.mc_writeEnable = false;
                        break block0;
                    }
                }
                this.log.addLog("Microchip11AA010: done, HL_BYTE_TO_MC_NOMAK-> command not found", LogPanel.ERROR);
                this.doError();
                break;
            }
            case 9: {
                switch (this.currentCommand) {
                    case 108: {
                        if (this.lastMasterAk == MAK) {
                            this.initHighLevel(9);
                            break block0;
                        }
                        this.mc_writeTimer = 7500;
                        this.mc_writeEnable = false;
                        this.saveBytestoDisk();
                        this.initHighLevel(8);
                        break block0;
                    }
                }
                this.log.addLog("Microchip11AA010: done, HL_BYTE_TO_MC-> command not found", LogPanel.ERROR);
                this.doError();
                break;
            }
            case 4: {
                switch (this.currentCommand) {
                    case 3: {
                        if (this.lastMasterAk == MAK) {
                            this.initHighLevel(4);
                            break block0;
                        }
                        this.initHighLevel(8);
                        break block0;
                    }
                    case 5: {
                        if (this.lastMasterAk == MAK) {
                            this.initHighLevel(4);
                            break block0;
                        }
                        this.initHighLevel(8);
                        break block0;
                    }
                }
                this.log.addLog("Microchip11AA010: done, HL_BYTE_FROM_MC-> command not found", LogPanel.ERROR);
                this.doError();
                break;
            }
            case 3: {
                switch (this.currentCommand) {
                    case 3: {
                        this.mc_address_register %= 128;
                        this.log.addLog("Microchip11AA010: Address register set to: $" + String.format("%04X", this.mc_address_register), LogPanel.INFO);
                        this.log.addLog("Microchip11AA010: HL_ADDRESS->READ done", LogPanel.VERBOSE);
                        this.initHighLevel(4);
                        break block0;
                    }
                    case 108: {
                        this.mc_address_register %= 128;
                        this.log.addLog("Microchip11AA010: Address register set to: $" + String.format("%04X", this.mc_address_register), LogPanel.INFO);
                        this.log.addLog("Microchip11AA010: HL_ADDRESS->WRITE done", LogPanel.VERBOSE);
                        this.initHighLevel(9);
                        break block0;
                    }
                }
                this.log.addLog("Microchip11AA010: done, HL_ADDRESS-> command not found", LogPanel.ERROR);
                this.doError();
                break;
            }
            case 2: {
                switch (this.currentCommand) {
                    case 5: {
                        this.log.addLog("Microchip11AA010: HL_COMMAND->RDSR) done", LogPanel.VERBOSE);
                        this.initHighLevel(4);
                        break block0;
                    }
                    case 110: {
                        this.log.addLog("Microchip11AA010: HL_COMMAND->WRSR done", LogPanel.VERBOSE);
                        this.initHighLevel(5);
                        break block0;
                    }
                    case 3: {
                        this.log.addLog("Microchip11AA010: HL_COMMAND->READ done", LogPanel.VERBOSE);
                        this.mc_address_register = 0;
                        this.initHighLevel(3);
                        break block0;
                    }
                    case 150: {
                        this.log.addLog("Microchip11AA010: HL_COMMAND->WREN done", LogPanel.VERBOSE);
                        if (this.lastMasterAk == NOMAK) {
                            this.initHighLevel(8);
                            this.mc_writeEnable = true;
                            break block0;
                        }
                        this.log.addLog("Microchip11AA010: done, HL_COMMAND->WREN NOMAK not found!", LogPanel.ERROR);
                        this.doError();
                        break block0;
                    }
                    case 145: {
                        this.log.addLog("Microchip11AA010: HL_COMMAND->WRDI done", LogPanel.VERBOSE);
                        if (this.lastMasterAk == NOMAK) {
                            this.initHighLevel(8);
                            this.mc_writeEnable = false;
                            break block0;
                        }
                        this.log.addLog("Microchip11AA010: done,  HL_COMMAND->WRDI NOMAK not found!", LogPanel.ERROR);
                        this.doError();
                        break block0;
                    }
                    case 108: {
                        this.log.addLog("Microchip11AA010: HL_COMMAND->WRITE done", LogPanel.VERBOSE);
                        this.mc_address_register = 0;
                        this.initHighLevel(3);
                        break block0;
                    }
                }
                this.log.addLog("Microchip11AA010: done, HL_COMMAND->command not found!", LogPanel.ERROR);
                this.doError();
                break;
            }
            default: {
                this.log.addLog("Microchip11AA010: ERROR unkown HL STATUS: " + this.highLevelState, LogPanel.ERROR);
                this.doError();
            }
        }
    }

    boolean isProtected(int block) {
        int reg = this.mc_status_register & 0xC;
        if (this.mc_writeEnable) {
            reg |= 2;
        }
        if (this.mc_writeTimer > 0) {
            reg |= 1;
        }
        if ((reg & 2) == 0) {
            return true;
        }
        if ((reg & 1) == 1) {
            return true;
        }
        int protBloc = reg >> 2;
        if (block == 3 && protBloc > 0) {
            return true;
        }
        if (block == 2 && protBloc > 1) {
            return true;
        }
        if (block == 1 && protBloc > 2) {
            return true;
        }
        return block == 0 && protBloc > 2;
    }

    @Override
    public boolean isActive() {
        return this.highLevelState != 0;
    }

    @Override
    public boolean usesPB6() {
        return true;
    }

    @Override
    public void lineIRQIn(boolean i) {
    }

    static {
        hl_none = new int[]{0};
        hl_header_finish = new int[]{1, 4, 5, 1, 2};
        hl_command = new int[]{8, 16, 2};
        hl_address = new int[]{9, 1, 2, 10, 1, 2};
        hl_byte_from_mc = new int[]{11, 16, 2};
        hl_byte_to_mc_nomak = new int[]{12, 3, 2};
        hl_byte_to_mc = new int[]{12, 16, 2};
        hl_byte_delay = new int[]{13};
        hl_page_delay = new int[]{14};
        hl_wait_for_header = new int[]{6, 7, 15};
        high_level_stateSequence = new int[10][];
        Microchip11AA010.high_level_stateSequence[0] = hl_none;
        Microchip11AA010.high_level_stateSequence[1] = hl_header_finish;
        Microchip11AA010.high_level_stateSequence[2] = hl_command;
        Microchip11AA010.high_level_stateSequence[3] = hl_address;
        Microchip11AA010.high_level_stateSequence[4] = hl_byte_from_mc;
        Microchip11AA010.high_level_stateSequence[5] = hl_byte_to_mc_nomak;
        Microchip11AA010.high_level_stateSequence[6] = hl_byte_delay;
        Microchip11AA010.high_level_stateSequence[7] = hl_page_delay;
        Microchip11AA010.high_level_stateSequence[8] = hl_wait_for_header;
        Microchip11AA010.high_level_stateSequence[9] = hl_byte_to_mc;
        MAK = 1;
        NOMAK = 0;
        NONE = -1;
    }

    public static class EpromData
    implements Serializable {
        byte[] data = new byte[128];
    }
}

