/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.vecx.cartridge;

import de.malban.Global;
import de.malban.util.UtilityString;
import de.malban.vide.vecx.cartridge.SystemRomXMLHandler;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.HashMap;
import javax.swing.JOptionPane;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.helpers.DefaultHandler;

public class SystemRom {
    protected String mClass = "";
    public String mName = "";
    protected String mCartName = "";
    protected String mVersion = "";
    protected String mComment = "";
    private static SystemRomXMLHandler XMLHANDLER = new SystemRomXMLHandler();

    public String getName() {
        return this.mName;
    }

    public void setName(String n) {
        this.mName = n;
    }

    public String getCClass() {
        return this.mClass;
    }

    public void setCClass(String c) {
        this.mClass = c;
    }

    public String getCartName() {
        return this.mCartName;
    }

    public void setCartName(String CartName) {
        this.mCartName = CartName;
    }

    public String getVersion() {
        return this.mVersion;
    }

    public void setVersion(String Version2) {
        this.mVersion = Version2;
    }

    public String getComment() {
        return this.mComment;
    }

    public void setComment(String Comment2) {
        this.mComment = Comment2;
    }

    private String exportXML() {
        StringBuffer s = new StringBuffer();
        s.append("\t<SystemRom>\n");
        s.append("\t\t<Class>" + UtilityString.toXML(this.mClass) + "</Class>\n");
        s.append("\t\t<Name>" + UtilityString.toXML(this.mName) + "</Name>\n");
        s.append("\t\t<CartName>" + UtilityString.toXML(this.mCartName) + "</CartName>\n");
        s.append("\t\t<Version>" + UtilityString.toXML(this.mVersion) + "</Version>\n");
        s.append("\t\t<Comment>" + UtilityString.toXML(this.mComment) + "</Comment>\n");
        s.append("\t</SystemRom>\n");
        return s.toString();
    }

    public String toString() {
        return this.mName;
    }

    public static SystemRomXMLHandler getXMLParseHandler() {
        return XMLHANDLER;
    }

    public static boolean saveCollectionAsXML(String filename, Collection<SystemRom> col) {
        return SystemRom.saveCollectionAsXML(Global.mBaseDir, filename, col);
    }

    public static boolean saveCollectionAsXML(String pathName, String filename, Collection<SystemRom> col) {
        try {
            PrintWriter pw = new PrintWriter(pathName + filename, "UTF-8");
            pw.print("<?xml version=\"1.0\"?>\n");
            pw.print("<AllSystemRom>\n");
            for (SystemRom item : col) {
                pw.print(item.exportXML());
            }
            pw.print("</AllSystemRom>\n");
            pw.close();
        }
        catch (IOException e) {
            System.err.println(e.toString());
            return false;
        }
        return true;
    }

    public static HashMap<String, SystemRom> getHashMapFromXML(String filename) {
        HashMap<String, SystemRom> filters = new HashMap<String, SystemRom>();
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            SystemRomXMLHandler h = SystemRom.getXMLParseHandler();
            saxParser.parse(Global.mBaseDir + filename, (DefaultHandler)h);
            filters = h.getLastHashMap();
        }
        catch (Throwable e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, e.toString(), "SystemRom Load Error...", 1);
        }
        return filters;
    }
}

