/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.vecx.cartridge;

import de.malban.sound.tinysound.Stream;
import de.malban.sound.tinysound.TinySound;
import de.malban.vide.vecx.cartridge.Cartridge;
import de.malban.vide.vecx.cartridge.CartridgeInternalInterface;
import de.malban.vide.vecx.cartridge.resid.ISIDDefs;
import de.malban.vide.vecx.cartridge.resid.SID;
import java.io.Serializable;

public class VSID
implements Serializable,
CartridgeInternalInterface {
    static transient Stream line = null;
    public static final int MOS6581 = 0;
    public static final int MOS8580 = 1;
    public static final int SID_ADDRESS = 32768;
    static final int SAMPLE_RATE = 44100;
    static final int UPDATE_PER_SECOND = 40;
    byte[] buffer = new byte[4416];
    public SID.State oldState = null;
    transient SID sid;
    int SIDFRQ = 985248;
    int VECFREQ = 1500000;
    int clocksPerSample = this.VECFREQ / 44100;
    int clocksPerSampleRest = 0;
    long nextSample = 1L;
    long lastCycles = 5L;
    private int nextRest = 0;
    private int pos = 0;
    int lastsl = 0;
    public transient Cartridge cart;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void lineOff() {
        if (line == null) {
            return;
        }
        Stream stream = line;
        synchronized (stream) {
            line.stop();
            line = null;
        }
    }

    public void rememberState() {
        this.oldState = this.sid.read_state();
    }

    public void recallState() {
        if (this.oldState == null) {
            return;
        }
        this.sid.write_state(this.oldState);
    }

    private VSID() {
    }

    public VSID(Cartridge c) {
        this.cart = c;
        this.init();
    }

    @Override
    public void init() {
        this.sid = new SID();
        if (line == null) {
            line = TinySound.getOutStream();
            line.start();
        }
        this.sid.set_sampling_parameters(this.SIDFRQ, ISIDDefs.sampling_method.SAMPLE_RESAMPLE_INTERPOLATE, 44100.0, -1.0, 0.97);
        this.clocksPerSampleRest = (int)((long)this.VECFREQ * 1000L / 44100L);
        this.clocksPerSampleRest -= this.clocksPerSample * 1000;
        this.reset();
        if (this.cart.vecx == null) {
            return;
        }
        this.lastCycles = this.cart.vecx.getCycles();
        this.nextSample = this.cart.vecx.getCycles() + 5L;
    }

    @Override
    public void linePB6In(boolean l) {
    }

    @Override
    public void linePB6Out(boolean l) {
    }

    @Override
    public void deinit() {
        this.stop();
    }

    @Override
    public VSID clone() {
        VSID s = new VSID();
        s.lastCycles = this.lastCycles;
        s.nextSample = this.nextSample;
        s.clocksPerSampleRest = this.clocksPerSampleRest;
        s.clocksPerSample = this.clocksPerSample;
        s.nextRest = this.nextRest;
        s.pos = this.pos;
        s.lastsl = this.lastsl;
        s.SIDFRQ = this.SIDFRQ;
        s.VECFREQ = this.VECFREQ;
        s.sid = this.cloneSid();
        return s;
    }

    SID cloneSid() {
        SID s = new SID();
        s.set_sampling_parameters(this.SIDFRQ, ISIDDefs.sampling_method.SAMPLE_RESAMPLE_INTERPOLATE, 44100.0, -1.0, 0.97);
        if (this.sid == null) {
            return s;
        }
        SID.State state = this.sid.read_state();
        s.write_state(state);
        return s;
    }

    @Override
    public void step(long cycles) {
        if (this.nextSample == 0L) {
            return;
        }
        if (this.nextSample <= cycles) {
            double sidfactor;
            double sidCycles;
            this.nextSample += (long)(this.clocksPerSample - 1);
            this.nextRest += this.clocksPerSampleRest;
            if (this.nextRest > 1000) {
                this.nextRest -= 1000;
                ++this.nextSample;
            }
            if ((sidCycles = (double)cycles * (sidfactor = 1.0 / ((double)this.VECFREQ / (double)this.SIDFRQ))) - (double)this.lastCycles > 5000.0) {
                this.lastCycles = (long)sidCycles - 100L;
            }
            while (this.lastCycles < (long)sidCycles) {
                this.sid.clock();
                ++this.lastCycles;
            }
            int sample = this.sid.output();
            if (this.pos < this.buffer.length) {
                this.buffer[this.pos++] = (byte)(sample & 0xFF);
                this.buffer[this.pos++] = (byte)(sample >> 8);
            }
            if (this.pos == this.buffer.length) {
                // empty if block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSound() {
        if (line == null) {
            return;
        }
        Stream stream = line;
        synchronized (stream) {
            double v = 1.0;
            line.setVolume(v);
            int soundLength = line.available();
            int bufLength = this.pos;
            if (this.lastsl != soundLength) {
                this.lastsl = soundLength;
            }
            soundLength = soundLength > bufLength ? bufLength : soundLength;
            int n = soundLength = soundLength > this.pos ? this.pos : soundLength;
            if (soundLength > 0) {
                line.write(this.buffer, 0, soundLength);
            }
        }
        this.pos = 0;
    }

    public int performRead(int address, long cycles) {
        return this.sid.read(address - 32768);
    }

    public void performWrite(int address, int data2, long cycles) {
        this.sid.write(address - 32768, data2);
    }

    @Override
    public void reset() {
        if (this.cart == null) {
            return;
        }
        if (this.cart.vecx == null) {
            return;
        }
        this.nextSample = this.cart.vecx.getCycles() + 10L;
        double sidfactor = 1.0 / ((double)this.VECFREQ / (double)this.SIDFRQ);
        double sidCycles = (double)this.cart.vecx.getCycles() * sidfactor;
        this.lastCycles = (int)sidCycles;
        this.sid.reset();
    }

    public void setCyclesRunning(long n) {
        if (this.cart == null) {
            return;
        }
        if (this.cart.vecx == null) {
            return;
        }
        double sidfactor = 1.0 / ((double)this.VECFREQ / (double)this.SIDFRQ);
        double sidCycles = (double)n * sidfactor;
        this.nextSample = n + 10L;
        this.lastCycles = (int)sidCycles;
    }

    public void stop() {
        this.nextSample = 0L;
    }

    public void setChipVersion(int version2) {
        if (version2 == 0) {
            this.sid.set_chip_model(ISIDDefs.chip_model.MOS6581);
        } else {
            this.sid.set_chip_model(ISIDDefs.chip_model.MOS8580);
        }
    }

    @Override
    public boolean usesPB6() {
        return false;
    }

    @Override
    public void lineIRQIn(boolean i) {
    }

    @Override
    public boolean isActive() {
        return false;
    }
}

