/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.vecx.devices;

import de.malban.vide.VideConfig;
import de.malban.vide.vecx.VecX;
import de.malban.vide.vecx.VecXPanel;
import de.malban.vide.vecx.devices.AbstractDevice;
import de.malban.vide.vecx.devices.ImagerWheel;
import de.malban.vide.vecx.devices.VectrexJoyport;
import de.malban.vide.vecx.devices.WheelData;
import java.io.Serializable;

public class Imager3dDevice
extends AbstractDevice
implements Serializable {
    public static final boolean ONLY_OUTPUT_VALUES = false;
    long changeStartCycle = 0L;
    public static int STATE_TRUE = 1;
    public static int STATE_FALSE = -1;
    public static int STATE_UNKOWN = 0;
    int oldState3Int = STATE_UNKOWN;
    public static final int TRANSISTOR_RANGE = 500;
    public static final int DEFAULT_TRANSISTOR_ANGLE = 339;
    WheelData currentWheel = ImagerWheel.NARROW_ESCAPE;
    long pulseLenCycles = -1L;
    long waveLenCycles = -1L;
    double imagerAngle = 0.0;
    double spinPerSecond = 0.0;
    long spinCycleCount = 0L;
    double incPerCycle = 0.0;
    double playLeftEyeAngle = 90.0;
    double playRightEyeAngle = 270.0;
    boolean automaticMode = true;
    int indexInterruptCycles = 0;
    public static double photoReceiverAngleStart = 339.0;
    public static double indexAngleWidth = 5.0;
    private boolean leftEnabled = true;
    private boolean rightEnabled = true;
    private boolean bwEnabled = false;
    private boolean anaglyphicEnabled = false;
    int lastPulseChanges = 0;
    long lastCycles = 0L;
    long lastIndexPulseCycles = 0L;
    long reallylastIndexPulseCycles = 0L;
    long indexPulseStart = 0L;
    boolean lastIndex = false;
    long indexReceivedCycleCount = 0L;
    long waveStartCycle = 0L;
    long waveLoadEndCycle = 0L;
    double adjustFreq = 0.0;
    boolean resetResistent = false;
    boolean inputFromDeviceToVectrex = true;

    public void setIgnoreReset(boolean b) {
        this.resetResistent = b;
    }

    void reset() {
        if (this.resetResistent) {
            return;
        }
        this.changeStartCycle = 0L;
        this.oldState3Int = STATE_UNKOWN;
        this.pulseLenCycles = -1L;
        this.waveLenCycles = -1L;
        this.imagerAngle = 0.0;
        this.spinPerSecond = 0.0;
        this.spinCycleCount = 0L;
        this.incPerCycle = 0.0;
        this.automaticMode = VideConfig.getConfig().imagerAutoOnDefault;
        this.indexInterruptCycles = 0;
        this.leftEnabled = true;
        this.rightEnabled = true;
        this.bwEnabled = false;
        this.lastPulseChanges = 0;
        this.lastCycles = 0L;
        this.lastIndexPulseCycles = 0L;
        this.reallylastIndexPulseCycles = 0L;
        this.indexPulseStart = 0L;
        this.lastIndex = false;
        this.indexReceivedCycleCount = 0L;
        this.waveStartCycle = 0L;
        this.waveLoadEndCycle = 0L;
        this.adjustFreq = 0.0;
    }

    public WheelData getWheel() {
        return this.currentWheel;
    }

    public void setWheel(WheelData w) {
        this.currentWheel = w;
        if (!this.automaticMode) {
            this.forceSpinPerSecond(this.currentWheel.defaultFrequency);
        }
    }

    public void setWheel(String wheel) {
        this.currentWheel = WheelData.getWheel(wheel);
        if (!this.automaticMode) {
            this.forceSpinPerSecond(this.currentWheel.defaultFrequency);
        }
    }

    @Override
    public void setJoyport(VectrexJoyport j) {
        super.setJoyport(j);
        if (j != null && j.vecx != null) {
            j.vecx.setImager(true);
        }
    }

    @Override
    public void deinit() {
        if (this.inDeinit) {
            return;
        }
        this.reset();
        if (this.joyport != null && this.joyport.vecx != null) {
            this.joyport.vecx.setImager(false);
        }
        super.deinit();
    }

    @Override
    public int getDeviceID() {
        return VecXPanel.DEVICE_IMAGER;
    }

    @Override
    public String getDeviceName() {
        return "Imager";
    }

    public void setAuto(boolean a) {
        this.automaticMode = a;
    }

    public boolean isAuto() {
        return this.automaticMode;
    }

    @Override
    public void step() {
        double indexAngle;
        if (this.joyport == null) {
            return;
        }
        VecX vectrex = this.joyport.vecx;
        long c = vectrex.getCycles();
        long dif = c - this.lastCycles;
        this.lastCycles = c;
        double lastAngle = this.imagerAngle;
        this.imagerAngle -= (double)dif * this.incPerCycle;
        if (this.imagerAngle < 0.0) {
            this.imagerAngle += 360.0;
        }
        if (Math.abs((indexAngle = (this.currentWheel.indexAngle + this.imagerAngle) % 360.0) - photoReceiverAngleStart) < indexAngleWidth) {
            if (this.indexInterruptCycles < 500) {
                this.joyport.setButton4(true, true);
                if (!this.lastIndex) {
                    this.indexPulseStart = c;
                    this.reallylastIndexPulseCycles = 0L;
                    this.indexReceivedCycleCount = c;
                }
            } else {
                this.joyport.setButton4(false, true);
                if (this.reallylastIndexPulseCycles == 0L) {
                    this.reallylastIndexPulseCycles = c - this.indexPulseStart;
                }
            }
            ++this.indexInterruptCycles;
            this.lastIndex = true;
        } else {
            this.joyport.setButton4(false, true);
            if (this.lastIndex) {
                this.lastIndexPulseCycles = c - this.indexPulseStart;
            }
            this.lastIndex = false;
            this.indexInterruptCycles = 0;
        }
        boolean currentState3Boolean = this.joyport.isButton3(true);
        int currentState3Int = currentState3Boolean ? STATE_TRUE : STATE_FALSE;
        if (currentState3Int == this.oldState3Int) {
            return;
        }
        if (currentState3Int == STATE_UNKOWN) {
            if (this.oldState3Int == STATE_FALSE && this.waveLoadEndCycle == 0L) {
                this.waveLoadEndCycle = c;
            }
            this.oldState3Int = currentState3Int;
            return;
        }
        if (currentState3Int == STATE_TRUE) {
            if (this.waveLoadEndCycle == 0L) {
                this.waveLoadEndCycle = c;
            }
            this.oldState3Int = currentState3Int;
            return;
        }
        if (currentState3Int == STATE_FALSE) {
            this.pulseLenCycles = this.waveLoadEndCycle - this.waveStartCycle;
            this.waveLenCycles = c - this.waveStartCycle;
            this.waveStartCycle = c;
            this.waveLoadEndCycle = 0L;
            this.oldState3Int = currentState3Int;
        }
        if (this.automaticMode) {
            this.adjustSpeed((double)this.waveLenCycles / 1500000.0, (double)this.pulseLenCycles / 1500000.0);
        }
    }

    public int getRightColor() {
        if (!this.rightEnabled) {
            return -1;
        }
        double start = 0.0;
        double end2 = 0.0;
        double cuurentAngle = this.imagerAngle;
        for (int i = 0; i < this.currentWheel.startAngle.length; ++i) {
            start = this.currentWheel.startAngle[i];
            double s1 = (start + cuurentAngle) % 360.0;
            end2 = this.currentWheel.startAngle[(i + 1) % this.currentWheel.startAngle.length];
            double e1 = (end2 + cuurentAngle) % 360.0;
            if (s1 > e1) {
                e1 += 360.0;
            }
            if (!(s1 < this.playRightEyeAngle) || !(e1 > this.playRightEyeAngle)) continue;
            if (i == 0) {
                return 0;
            }
            if (this.bwEnabled) {
                return -2;
            }
            return i;
        }
        return -1;
    }

    public int getLeftColor() {
        if (!this.leftEnabled) {
            return -1;
        }
        double start = 0.0;
        double end2 = 0.0;
        double cuurentAngle = this.imagerAngle;
        for (int i = 0; i < this.currentWheel.startAngle.length; ++i) {
            start = this.currentWheel.startAngle[i];
            double s1 = (start + cuurentAngle) % 360.0;
            end2 = this.currentWheel.startAngle[(i + 1) % this.currentWheel.startAngle.length];
            double e1 = (end2 + cuurentAngle) % 360.0;
            if (s1 > e1) {
                s1 -= 360.0;
            }
            if (!(s1 < this.playLeftEyeAngle) || !(e1 > this.playLeftEyeAngle)) continue;
            if (i == 0) {
                return 0;
            }
            if (this.bwEnabled) {
                return -2;
            }
            return i;
        }
        return -1;
    }

    public long getLastIndexPulse() {
        return this.lastIndexPulseCycles;
    }

    public long getReallyLastIndexPulse() {
        return this.reallylastIndexPulseCycles;
    }

    public long getPulseLen() {
        return this.pulseLenCycles;
    }

    public long getWaveLen() {
        return this.waveLenCycles;
    }

    public double getAnglePerCycle() {
        return this.incPerCycle;
    }

    public long getCyclePerSpin() {
        return this.spinCycleCount;
    }

    public void forceSpinPerSecond(double d) {
        this.adjustFreq = this.spinPerSecond = d;
        this.spinCycleCount = (int)(1500000.0 / this.spinPerSecond);
        this.incPerCycle = 360.0 / (1500000.0 / this.spinPerSecond);
    }

    public double getSpinPerSecond() {
        return this.spinPerSecond;
    }

    public double getAngle() {
        return this.imagerAngle;
    }

    @Override
    public String toString() {
        return this.getDeviceName();
    }

    @Override
    public void setInputMode(boolean i) {
        this.inputFromDeviceToVectrex = i;
    }

    public boolean isLeftEnabled() {
        return this.leftEnabled;
    }

    public void setLeftEnabled(boolean leftEnabled) {
        this.leftEnabled = leftEnabled;
    }

    public boolean isRightEnabled() {
        return this.rightEnabled;
    }

    public void setRightEnabled(boolean rightEnabled) {
        this.rightEnabled = rightEnabled;
    }

    public boolean isBwEnabled() {
        return this.bwEnabled;
    }

    public void setBwEnabled(boolean bwEnabled) {
        this.bwEnabled = bwEnabled;
    }

    public boolean isAnaglyphicEnabled() {
        return this.anaglyphicEnabled;
    }

    public void setAnaglyphicEnabled(boolean anaglyphicEnabled) {
        this.anaglyphicEnabled = anaglyphicEnabled;
    }

    void adjustSpeed(double waveLen, double pulseLen) {
        double DAMPC = -0.2;
        double MMI = 5.0;
        double ang_acc = (50.0 - 1.55 * this.adjustFreq) / MMI;
        this.adjustFreq += ang_acc * pulseLen + DAMPC * this.adjustFreq / MMI * waveLen;
        this.forceSpinPerSecond(this.adjustFreq);
    }
}

