/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.vecx.devices;

import de.malban.input.ControllerEvent;
import de.malban.input.ControllerListern;
import de.malban.input.EventController;
import de.malban.input.SystemController;
import de.malban.vide.ControllerConfig;
import de.malban.vide.vecx.VecXPanel;
import de.malban.vide.vecx.devices.AbstractDevice;
import de.malban.vide.vecx.devices.VectrexJoyport;
import net.java.games.input.Controller;

public class JInputJoystickDevice
extends AbstractDevice
implements ControllerListern {
    public String usedInputID = "JInputJoystickDevice";
    ControllerConfig cConfig = null;
    EventController eController = null;
    boolean mouseMode = false;
    static double FACTOR = 2.54;

    @Override
    public int getDeviceID() {
        return VecXPanel.DEVICE_JINPUT_JOYSTICK;
    }

    @Override
    public String getDeviceName() {
        if (this.cConfig == null) {
            return "n/a";
        }
        return this.cConfig.name;
    }

    @Override
    public String toString() {
        if (this.cConfig == null) {
            return "JInputJoystickDevice";
        }
        return this.cConfig.toString();
    }

    @Override
    public void deinit() {
        super.deinit();
        if (this.eController != null) {
            this.eController.setActive(false);
            this.eController = null;
        }
    }

    @Override
    public void setJoyport(VectrexJoyport j) {
        if (this.eController != null) {
            this.eController.setActive(false);
            this.eController = null;
        }
        super.setJoyport(j);
        Controller controller = SystemController.getController(this.cConfig.JInputId);
        if (controller != null || (controller = SystemController.getControllerReload(this.cConfig.JInputId)) == null) {
            // empty if block
        }
        this.eController = new EventController(controller);
        this.mouseMode = this.cConfig.inputMapping.get("mouseMode") != null;
        this.eController.setMouseMode(this.mouseMode);
        this.eController.addEventListerner(this);
        this.eController.setActive(true);
    }

    public static JInputJoystickDevice getDevice(ControllerConfig c) {
        JInputJoystickDevice device = new JInputJoystickDevice();
        device.cConfig = c;
        c.initEventMapping();
        return device;
    }

    @Override
    public void controllerEvent(ControllerEvent e) {
        if (this.mouseMode && e.isRelative) {
            this.joyport.setVertical(e.y, true);
            this.joyport.setHorizontal(e.x, true);
            return;
        }
        String evenId = e.componentId;
        String vectrexTarget = this.cConfig.eventMapping.get(evenId);
        if (vectrexTarget == null) {
            if (e.type == 0) {
                Controller controller = SystemController.getControllerReload(this.cConfig.JInputId);
                if (controller == null) {
                    return;
                }
                if (this.eController != null) {
                    this.eController.setRemoved(true);
                    this.eController.setActive(false);
                    this.eController = null;
                }
                this.eController = new EventController(controller);
                this.eController.addEventListerner(this);
                this.eController.setActive(true);
            }
            return;
        }
        if (this.joyportIsInInputMode) {
            if (vectrexTarget.equals("1")) {
                this.joyport.setButton1(!e.currentButtonState, true);
            }
            if (vectrexTarget.equals("2")) {
                this.joyport.setButton2(!e.currentButtonState, true);
            }
            if (vectrexTarget.equals("3")) {
                this.joyport.setButton3(!e.currentButtonState, true);
            }
            if (vectrexTarget.equals("4")) {
                this.joyport.setButton4(!e.currentButtonState, true);
            }
        }
        if (e.componentId.equals("x") && (vectrexTarget.equals("left") || vectrexTarget.equals("right"))) {
            if (e.currentAxisPercent > 60) {
                this.joyport.setHorizontal(255, true);
            } else if (e.currentAxisPercent < 40) {
                this.joyport.setHorizontal(0, true);
            } else {
                this.joyport.setHorizontal(127, true);
            }
        } else if (e.componentId.equals("y") && (vectrexTarget.equals("up") || vectrexTarget.equals("down"))) {
            if (e.currentAxisPercent > 60) {
                this.joyport.setVertical(0, true);
            } else if (e.currentAxisPercent < 40) {
                this.joyport.setVertical(255, true);
            } else {
                this.joyport.setVertical(127, true);
            }
        } else {
            int value;
            int val;
            if (vectrexTarget.equals("left")) {
                this.joyport.setHorizontal(e.currentButtonState ? 0 : 127, true);
            }
            if (vectrexTarget.equals("right")) {
                this.joyport.setHorizontal(e.currentButtonState ? 255 : 127, true);
            }
            if (vectrexTarget.equals("down")) {
                this.joyport.setVertical(e.currentButtonState ? 0 : 127, true);
            }
            if (vectrexTarget.equals("up")) {
                this.joyport.setVertical(e.currentButtonState ? 255 : 127, true);
            }
            if (vectrexTarget.equals("vertical")) {
                if (e.isRelative) {
                    val = -((int)e.currentRelative);
                    if (val < 0 && val < -128) {
                        val = -127;
                    }
                    if (val > 0 && val > 127) {
                        val = 128;
                    }
                    this.joyport.setVertical(127 + val & 0xFF, true);
                } else {
                    value = (int)((e.currentValue + 1.0f) * 255.0f / 2.0f);
                    this.joyport.setHorizontal(value & 0xFF, true);
                }
            }
            if (vectrexTarget.equals("horizontal")) {
                if (e.isRelative) {
                    val = (int)e.currentRelative;
                    if (val < 0 && val < -128) {
                        val = -127;
                    }
                    if (val > 0 && val > 127) {
                        val = 128;
                    }
                    this.joyport.setHorizontal(127 + val & 0xFF, true);
                } else {
                    value = (int)((e.currentValue + 1.0f) * 255.0f / 2.0f);
                    this.joyport.setHorizontal(value & 0xFF, true);
                }
            }
        }
    }
}

