/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.vecx.devices;

import de.malban.gui.HotKey;
import de.malban.vide.VideConfig;
import de.malban.vide.vecx.VecX;
import de.malban.vide.vecx.VecXPanel;
import de.malban.vide.vecx.devices.AbstractDevice;
import de.malban.vide.vecx.devices.VectrexJoyport;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;

public class KeyboardSpinnerDevice
extends AbstractDevice {
    public static final int NONE = 0;
    public static final int RIGHT = 1;
    public static final int LEFT = 2;
    int moveDirection = 0;
    int currentCount = 0;
    int[] pinMoveLeft = new int[]{1, 3, 0, 2};
    int[] pinMoveRight = new int[]{2, 0, 3, 1};
    int out = 0;
    long lastCycles = 0L;
    VecXPanel panel;

    @Override
    public void setJoyport(VectrexJoyport j) {
        super.setJoyport(j);
        this.currentCount = VideConfig.getConfig().minimumSpinnerChangeCycles;
        this.out = 0;
    }

    @Override
    public void step() {
        if (this.joyport == null) {
            return;
        }
        VecX vectrex = this.joyport.vecx;
        long c = vectrex.getCycles();
        int dif = (int)(c - this.lastCycles);
        this.lastCycles = c;
        this.currentCount -= dif;
        if (this.currentCount <= 0) {
            this.currentCount = VideConfig.getConfig().minimumSpinnerChangeCycles;
            if (this.moveDirection == 0) {
                // empty if block
            }
            if (this.moveDirection == 1) {
                this.out = this.pinMoveRight[this.out];
            }
            if (this.moveDirection == 2) {
                this.out = this.pinMoveLeft[this.out];
            }
            this.joyport.setButton1((this.out & 1) != 1, true);
            this.joyport.setButton2((this.out & 2) != 2, true);
        }
    }

    @Override
    public int getDeviceID() {
        return VecXPanel.DEVICE_KEYBOARD_SPINNER;
    }

    @Override
    public String getDeviceName() {
        return "keyboard spinner";
    }

    public KeyboardSpinnerDevice(VecXPanel p) {
        this.panel = p;
        this.setupKeyEvents();
    }

    private void setupKeyEvents() {
        new HotKey("SpinnerButton_1_pressed", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (KeyboardSpinnerDevice.this.joyport != null && KeyboardSpinnerDevice.this.joyportIsInInputMode) {
                    KeyboardSpinnerDevice.this.joyport.setButton3(false, true);
                }
            }
        }, this.panel);
        new HotKey("SpinnerButton_2_pressed", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (KeyboardSpinnerDevice.this.joyport != null && KeyboardSpinnerDevice.this.joyportIsInInputMode) {
                    KeyboardSpinnerDevice.this.joyport.setButton4(false, true);
                }
            }
        }, this.panel);
        new HotKey("SpinnerButton_1_released", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (KeyboardSpinnerDevice.this.joyport != null && KeyboardSpinnerDevice.this.joyportIsInInputMode) {
                    KeyboardSpinnerDevice.this.joyport.setButton3(true, true);
                }
            }
        }, this.panel);
        new HotKey("SpinnerButton_2_released", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (KeyboardSpinnerDevice.this.joyport != null && KeyboardSpinnerDevice.this.joyportIsInInputMode) {
                    KeyboardSpinnerDevice.this.joyport.setButton4(true, true);
                }
            }
        }, this.panel);
        new HotKey("Spinner_Left_pressed", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KeyboardSpinnerDevice.this.moveDirection = 2;
            }
        }, this.panel);
        new HotKey("Spinner_Right_pressed", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KeyboardSpinnerDevice.this.moveDirection = 1;
            }
        }, this.panel);
        new HotKey("Spinner_Left_released", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KeyboardSpinnerDevice.this.moveDirection = 0;
                KeyboardSpinnerDevice.this.currentCount = -1;
            }
        }, this.panel);
        new HotKey("Spinner_Right_released", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KeyboardSpinnerDevice.this.moveDirection = 0;
                KeyboardSpinnerDevice.this.currentCount = -1;
            }
        }, this.panel);
    }

    @Override
    public String toString() {
        return "Spinner Keyboard";
    }
}

