/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.vecx.devices;

import de.malban.vide.vecx.VecX;
import de.malban.vide.vecx.VecXPanel;
import de.malban.vide.vecx.devices.AbstractDevice;
import java.io.Serializable;

public class LightpenDevice
extends AbstractDevice
implements Serializable {
    public static final int LIGHTPEN_OUT_OF_BOUNDS = -100000;
    public int lightpenX = -100000;
    public int lightpenY = -100000;

    @Override
    public int getDeviceID() {
        return VecXPanel.DEVICE_LIGHTPEN;
    }

    @Override
    public String getDeviceName() {
        return "lightpen";
    }

    @Override
    public void step() {
        if (this.joyport == null) {
            return;
        }
        VecX vectrex = this.joyport.vecx;
        if (Math.abs(vectrex.getBeamPosX() - (double)this.lightpenX) < 256.0 && Math.abs(vectrex.getBeamPosY() - (double)this.lightpenY) < 256.0) {
            if (vectrex.sig_blank.intValue == 1) {
                this.joyport.setButton4(false, true);
            } else {
                this.joyport.setButton4(true, true);
            }
        } else {
            this.joyport.setButton4(true, true);
        }
    }

    public void setCoordinates(int x, int y) {
        this.lightpenX = x;
        this.lightpenY = y;
    }

    @Override
    public String toString() {
        return "Lightpen";
    }
}

