/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.vecx.devices;

import be.tarsos.dsp.AudioDispatcher;
import be.tarsos.dsp.AudioEvent;
import be.tarsos.dsp.AudioProcessor;
import be.tarsos.dsp.WaveformSimilarityBasedOverlapAdd;
import be.tarsos.dsp.io.jvm.AudioDispatcherFactory;
import be.tarsos.dsp.resample.RateTransposer;
import de.malban.config.Configuration;
import de.malban.gui.panels.LogPanel;
import de.malban.sound.tinysound.Stream;
import de.malban.sound.tinysound.TinySound;
import de.malban.sound.tinysound.internal.MemSound;
import de.malban.vide.vecx.VecX;
import de.malban.vide.vecx.VecXPanel;
import de.malban.vide.vecx.devices.AbstractDevice;
import de.malban.vide.vecx.devices.VecVoiceSamples;
import de.malban.vide.vecx.devices.VecVoxSamples;
import de.malban.vide.vedi.sound.SampleJPanel;
import de.malban.vide.vedi.sound.ibxm.IBXM;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;

public class VecSpeechDevice
extends AbstractDevice
implements Serializable {
    public static boolean DEBUG_WAV_OUT = false;
    public static byte[] output = new byte[0];
    static int sampleCount = 0;
    public static boolean saveWave = false;
    public static boolean enableCommands = true;
    public static boolean blendEnable = true;
    public static final int BLEND_DEFAULT = 15;
    public static int blendLen = 15;
    public static boolean removeSilence = true;
    public static int maxNoise = 5;
    public static boolean alignBlendToAmplitude = true;
    public static int amplitudeThreshold = 10;
    boolean doSampleBlending = false;
    boolean removeSilenceFromSample = true;
    boolean afterPause = true;
    int lastCommand = -1;
    boolean isVoiced = false;
    private static transient int UID_C = 0;
    static final transient int LINE_OFFLINE = 0;
    static final transient int LINE_WAIT_FOR_START_BIT = 1;
    static final transient int LINE_WAIT_FOR_START_BIT_END = 2;
    static final transient int LINE_RECEIVING_BITS = 3;
    static final transient int LINE_READ_NEXT_BYTE_BIT = 4;
    static final transient int LINE_WAIT_FOR_STOP_BIT = 5;
    String[] stateNames = new String[]{"OFFLINE", "WAIT_FOR_START_BIT", "WAIT_FOR_START_BIT_END", "RECEIVING_BITS", "READ_NEXT_BYTE_BIT", "WAIT_FOR_STOP_BIT"};
    static final transient int BAUD_IN_CYCLES = 156;
    static final transient int MID_BAUD_IN_CYCLES = 78;
    private boolean SPO256AL2 = false;
    private final transient int UID = UID_C++;
    String deviceName = "VecVox";
    int lowLevelState = 0;
    long cycles = 0L;
    long receiveCycleStart = 0L;
    boolean dataLineInput = true;
    boolean old_dataLineInput = true;
    int currentByteRead = 0;
    int bitsLoaded = 0;
    boolean inputMode = true;
    boolean midBaudSet = false;
    boolean midBaudValue = false;
    transient Stream line = null;
    private int C_LEN = 64;
    private static final transient int BUFFER_LEN_VECVOX = 64;
    private static final transient int BUFFER_LEN_VECVOICE = 32;
    int[] commands = null;
    int nextComandPoint = 0;
    int currentComandPoint = 0;
    long soundCycles = 0L;
    long oldCycles = 0L;
    int currentSamplePos = -1;
    byte[] wavData = null;
    byte[] wavDataUsage = null;
    byte[] wavDataLastEnd = null;
    public static final int NO_COMMAND = -1;
    transient byte[] soundBytes = null;
    private boolean spNextFast = false;
    private boolean spNextSlow = false;
    private boolean spNextStress = false;
    private boolean spNextRelax = false;
    private boolean spCommandMode = false;
    private double spVolume = 0.7559055118110236;
    private int spCommand = 0;
    private int spPitch = 88;
    private int spTempo = 114;
    private int spBend = 5;
    private int spRepeat = 0;
    private int spDelay = 0;
    public static final int NONE = 256;
    long difi = 0L;
    static final transient AudioFormat audioFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 44100.0f, 16, 1, 2, 44100.0f, false);
    static Thread speaker = null;
    static boolean stop = false;
    static boolean running = false;

    @Override
    public int getDeviceID() {
        if (this.SPO256AL2) {
            return VecXPanel.DEVICE_VECVOICE;
        }
        return VecXPanel.DEVICE_VECVOX;
    }

    public String getLowLevelState() {
        return this.stateNames[this.lowLevelState];
    }

    public String getCommand() {
        if (this.SPO256AL2) {
            return VecVoiceSamples.getMnemonic(this.lastCommand);
        }
        return VecVoxSamples.getMnemonic(this.lastCommand);
    }

    public int getQueueLength() {
        int tmp_nextComandPoint = this.nextComandPoint;
        int tmp_currentComandPoint = this.currentComandPoint;
        int counter = 0;
        while (tmp_nextComandPoint != tmp_currentComandPoint) {
            int command = this.commands[tmp_currentComandPoint];
            if ((tmp_currentComandPoint = (tmp_currentComandPoint + 1) % this.C_LEN) == this.currentComandPoint) {
                return counter;
            }
            if (command == -1) {
                return counter;
            }
            ++counter;
        }
        return counter;
    }

    public String getSyncCycles() {
        return "" + this.difi;
    }

    public String getBitCounterFromVectrex() {
        return "" + this.bitsLoaded;
    }

    public String getBitFromVectrex() {
        if ((this.currentByteRead & 0x80) == 128) {
            return "1";
        }
        return "0";
    }

    public String getInputLine() {
        if (this.dataLineInput) {
            return "1";
        }
        return "0";
    }

    @Override
    public void deinit() {
        super.deinit();
        if (!this.inDeinit) {
            if (this.line != null) {
                this.line.stop();
                this.line.unload();
                this.line = null;
            }
            this.reset();
        }
    }

    @Override
    public String getDeviceName() {
        return this.deviceName;
    }

    @Override
    public String toString() {
        return this.deviceName;
    }

    public VecSpeechDevice(boolean clone) {
    }

    void reset() {
        this.doSampleBlending = false;
        this.removeSilenceFromSample = true;
        this.afterPause = true;
        this.lastCommand = -1;
        this.isVoiced = false;
        this.lowLevelState = 0;
        this.cycles = 0L;
        this.receiveCycleStart = 0L;
        this.dataLineInput = true;
        this.old_dataLineInput = true;
        this.currentByteRead = 0;
        this.bitsLoaded = 0;
        this.inputMode = true;
        this.midBaudSet = false;
        this.midBaudValue = false;
        this.nextComandPoint = 0;
        this.currentComandPoint = 0;
        this.soundCycles = 0L;
        this.oldCycles = 0L;
        this.currentSamplePos = -1;
        this.wavData = null;
        this.wavDataUsage = null;
        this.wavDataLastEnd = null;
        this.soundBytes = null;
        this.spNextFast = false;
        this.spNextSlow = false;
        this.spNextStress = false;
        this.spNextRelax = false;
        this.spCommandMode = false;
        this.spVolume = 0.7559055118110236;
        this.spCommand = 0;
        this.spPitch = 88;
        this.spTempo = 114;
        this.spBend = 5;
        this.spRepeat = 0;
        this.spDelay = 0;
        this.difi = 0L;
        this.commands = new int[this.C_LEN];
        this.soundBytes = new byte[IBXM.IBXM_MAXBUFFER / 2];
        if (this.line != null) {
            this.line.stop();
            this.line.unload();
            this.line = null;
        }
    }

    public VecSpeechDevice() {
        VecVoiceSamples.loadSamples();
        this.commands = new int[this.C_LEN];
        this.soundBytes = new byte[IBXM.IBXM_MAXBUFFER / 2];
        for (int i = 0; i < this.C_LEN; ++i) {
            this.commands[i] = -1;
        }
    }

    public VecSpeechDevice clone() {
        VecSpeechDevice vv = new VecSpeechDevice(true);
        vv.currentByteRead = this.currentByteRead;
        vv.bitsLoaded = this.bitsLoaded;
        vv.inputMode = this.inputMode;
        vv.midBaudSet = this.midBaudSet;
        vv.midBaudValue = this.midBaudValue;
        vv.cycles = this.cycles;
        vv.dataLineInput = this.dataLineInput;
        vv.old_dataLineInput = this.old_dataLineInput;
        vv.receiveCycleStart = this.receiveCycleStart;
        vv.SPO256AL2 = this.SPO256AL2;
        vv.lowLevelState = this.lowLevelState;
        vv.difi = this.difi;
        vv.deviceName = this.deviceName;
        vv.nextComandPoint = 0;
        vv.currentComandPoint = 0;
        vv.soundCycles = this.soundCycles;
        vv.oldCycles = this.oldCycles;
        vv.wavData = null;
        vv.currentSamplePos = -1;
        vv.C_LEN = this.C_LEN;
        vv.spDelay = this.spDelay;
        vv.spNextRelax = this.isSpNextRelax();
        vv.spNextStress = this.isSpNextStress();
        vv.spNextFast = this.isSpNextFast();
        vv.spNextSlow = this.isSpNextSlow();
        vv.spCommandMode = this.isSpCommandMode();
        vv.spVolume = this.getSpVolume();
        vv.spCommand = this.getSpCommand();
        vv.spPitch = this.getSpPitch();
        vv.spTempo = this.getSpTempo();
        vv.spBend = this.getSpBend();
        vv.spRepeat = this.getSpRepeat();
        return vv;
    }

    public void initClone() {
        VecVoiceSamples.loadSamples();
        this.commands = new int[this.C_LEN];
        this.soundBytes = new byte[IBXM.IBXM_MAXBUFFER / 2];
    }

    public void setVecVoice(boolean b) {
        this.SPO256AL2 = b;
        if (b) {
            this.deviceName = "VecVoice";
            this.C_LEN = 32;
        } else {
            this.C_LEN = 64;
            this.deviceName = "VecVox";
        }
        this.commands = new int[this.C_LEN];
        for (int i = 0; i < this.C_LEN; ++i) {
            this.commands[i] = -1;
        }
    }

    public boolean isVecVoice() {
        return this.SPO256AL2;
    }

    int mapSPOToSpeakJet(int in) {
        if (in == 0) {
            return 4;
        }
        if (in == 1) {
            return 5;
        }
        if (in == 2) {
            return 6;
        }
        if (in == 3) {
            return 1;
        }
        if (in == 4) {
            return 2;
        }
        if (in == 5) {
            return 156;
        }
        if (in == 6) {
            return 155;
        }
        if (in == 7) {
            return 131;
        }
        if (in == 8) {
            return 195;
        }
        if (in == 9) {
            return 199;
        }
        if (in == 10) {
            return 165;
        }
        if (in == 11) {
            return 141;
        }
        if (in == 12) {
            return 129;
        }
        if (in == 13) {
            return 192;
        }
        if (in == 14) {
            return 153;
        }
        if (in == 15) {
            return 134;
        }
        if (in == 16) {
            return 140;
        }
        if (in == 17) {
            return 191;
        }
        if (in == 18) {
            return 169;
        }
        if (in == 19) {
            return 128;
        }
        if (in == 20) {
            return 154;
        }
        if (in == 21) {
            return 176;
        }
        if (in == 22) {
            return 139;
        }
        if (in == 23) {
            return 135;
        }
        if (in == 24) {
            return 136;
        }
        if (in == 25) {
            return 128;
        }
        if (in == 26) {
            return 132;
        }
        if (in == 27) {
            return 183;
        }
        if (in == 28) {
            return 170;
        }
        if (in == 29) {
            return 190;
        }
        if (in == 30) {
            return 138;
        }
        if (in == 31) {
            return 160;
        }
        if (in == 32) {
            return 163;
        }
        if (in == 33) {
            return 175;
        }
        if (in == 34) {
            return 180;
        }
        if (in == 35) {
            return 166;
        }
        if (in == 36) {
            return 179;
        }
        if (in == 37) {
            return 189;
        }
        if (in == 38) {
            return 168;
        }
        if (in == 39) {
            return 148;
        }
        if (in == 40) {
            return 186;
        }
        if (in == 41) {
            return 194;
        }
        if (in == 42) {
            return 194;
        }
        if (in == 43) {
            return 167;
        }
        if (in == 44) {
            return 144;
        }
        if (in == 45) {
            return 145;
        }
        if (in == 46) {
            return 147;
        }
        if (in == 47) {
            return 150;
        }
        if (in == 48) {
            return 185;
        }
        if (in == 49) {
            return 128;
        }
        if (in == 50) {
            return 182;
        }
        if (in == 51) {
            return 133;
        }
        if (in == 52) {
            return 151;
        }
        if (in == 53) {
            return 164;
        }
        if (in == 54) {
            return 169;
        }
        if (in == 55) {
            return 187;
        }
        if (in == 56) {
            return 142;
        }
        if (in == 57) {
            return 184;
        }
        if (in == 58) {
            return 153;
        }
        if (in == 59) {
            return 152;
        }
        if (in == 60) {
            return 149;
        }
        if (in == 61) {
            return 178;
        }
        if (in == 62) {
            return 159;
        }
        if (in == 63) {
            return 170;
        }
        return 0;
    }

    @Override
    public void updateInputDataFromDevice() {
        if (!this.inputMode) {
            return;
        }
        if (!this.isReady()) {
            this.joyport.setButton2(true, true);
            this.joyport.setButton3(true, true);
            this.joyport.setButton4(true, true);
            this.joyport.setButton1(true, true);
            return;
        }
        this.joyport.setButton2(false, true);
        if (!this.dataLineInput) {
            this.joyport.setButton1(true, true);
        } else {
            this.joyport.setButton1(false, true);
        }
    }

    @Override
    public void setInputMode(boolean i) {
        if (this.inputMode == i) {
            return;
        }
        this.inputMode = i;
        this.dataLineInput = !this.inputMode ? this.joyport.isButton1(true) : true;
    }

    @Override
    public void step() {
        long dif;
        if (this.joyport == null) {
            return;
        }
        VecX vectrex = this.joyport.vecx;
        long c = vectrex.getCycles();
        this.stepSound(c);
        this.difi = dif = c - this.cycles;
        if (this.lowLevelState <= 2 && this.dataLineInput != this.old_dataLineInput) {
            this.cycles = c;
        }
        switch (this.lowLevelState) {
            case 0: {
                this.lowLevelState = 1;
                this.cycles = c;
                Configuration.getConfiguration().getDebugEntity().addLog(this.deviceName + ": Offline -> wait for startbit ", LogPanel.INFO);
                break;
            }
            case 1: {
                if (this.dataLineInput) break;
                Configuration.getConfiguration().getDebugEntity().addLog(this.deviceName + ": Offline -> startbit started", LogPanel.INFO);
                this.lowLevelState = 2;
                if (this.old_dataLineInput) {
                    this.cycles = c;
                }
                this.midBaudSet = false;
                break;
            }
            case 2: {
                if (dif > 78L && !this.midBaudSet) {
                    this.midBaudSet = true;
                    this.midBaudValue = this.dataLineInput;
                }
                if (dif < 156L) break;
                if (!this.midBaudValue) {
                    Configuration.getConfiguration().getDebugEntity().addLog(this.deviceName + ": startbit received, waiting for byte data ", LogPanel.INFO);
                    this.midBaudSet = false;
                    this.bitsLoaded = 0;
                    this.currentByteRead = 0;
                    this.lowLevelState = 4;
                    this.cycles = c;
                    break;
                }
                this.midBaudSet = false;
                this.lowLevelState = 1;
                Configuration.getConfiguration().getDebugEntity().addLog(this.deviceName + ": startbit broken, waiting again ", LogPanel.INFO);
                break;
            }
            case 4: {
                if (dif > 78L && !this.midBaudSet) {
                    this.midBaudSet = true;
                    this.midBaudValue = this.dataLineInput;
                }
                if (dif < 156L) break;
                this.currentByteRead >>= 1;
                if (this.midBaudValue) {
                    this.currentByteRead += 128;
                    Configuration.getConfiguration().getDebugEntity().addLog(this.deviceName + ": Byte receiving (bit: " + this.bitsLoaded + " = " + 1 + ")", LogPanel.INFO);
                } else {
                    Configuration.getConfiguration().getDebugEntity().addLog(this.deviceName + ": Byte receiving (bit: " + this.bitsLoaded + " = " + 0 + ")", LogPanel.INFO);
                }
                ++this.bitsLoaded;
                this.cycles = c;
                this.midBaudSet = false;
                if (this.bitsLoaded != 8) break;
                this.midBaudSet = false;
                this.lowLevelState = 5;
                Configuration.getConfiguration().getDebugEntity().addLog(this.deviceName + ": Byte received, waiting for stop bit", LogPanel.INFO);
                break;
            }
            case 5: {
                this.midBaudSet = false;
                if (this.dataLineInput) {
                    this.lowLevelState = 0;
                    this.cycles = c;
                    Configuration.getConfiguration().getDebugEntity().addLog(this.deviceName + ": stop bit received", LogPanel.INFO);
                    Configuration.getConfiguration().getDebugEntity().addLog(this.deviceName + ": completely received: " + this.currentByteRead + " (going offline)", LogPanel.INFO);
                    this.finalizeByteRead();
                    break;
                }
                if (dif < 156L) break;
                this.lowLevelState = 0;
                this.cycles = c;
                Configuration.getConfiguration().getDebugEntity().addLog(this.deviceName + ": stop bit not received (going offline)", LogPanel.INFO);
                break;
            }
        }
        this.old_dataLineInput = this.dataLineInput;
    }

    boolean isReady() {
        int nc = (this.nextComandPoint + 1) % this.C_LEN;
        return nc != this.currentComandPoint;
    }

    void finalizeByteRead() {
        Configuration.getConfiguration().getDebugEntity().addLog(this.deviceName + ": byte received: " + this.currentByteRead, LogPanel.INFO);
        this.addCommand(this.currentByteRead);
    }

    void addCommand(int c) {
        if (!this.isReady()) {
            Configuration.getConfiguration().getDebugEntity().addLog(this.deviceName + ": Buffer overflow ", LogPanel.WARN);
            return;
        }
        this.commands[this.nextComandPoint] = c;
        this.nextComandPoint = (this.nextComandPoint + 1) % this.C_LEN;
    }

    int getNextCommand() {
        if (this.nextComandPoint == this.currentComandPoint) {
            return -1;
        }
        this.commands[(this.currentComandPoint + this.C_LEN - 1) % this.C_LEN] = -1;
        int command = this.commands[this.currentComandPoint];
        this.currentComandPoint = (this.currentComandPoint + 1) % this.C_LEN;
        if (command == -1) {
            return -1;
        }
        return command;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stepSound(long cycles) {
        this.soundCycles -= cycles - this.oldCycles;
        this.oldCycles = cycles;
        if (this.soundCycles <= 0L) {
            this.soundCycles = 50000L;
            if (this.line == null && TinySound.isInitialized()) {
                this.line = TinySound.getOutStream();
                if (this.line == null) {
                    return;
                }
                this.line.start();
                if (!this.SPO256AL2) {
                    this.line.setVolume(this.getSpVolume());
                }
            }
            if (this.line != null) {
                Stream stream = this.line;
                synchronized (stream) {
                    int soundLength = this.line.available();
                    soundLength = this.fillSoundBuffer(soundLength);
                    int n = soundLength = soundLength > this.soundBytes.length ? this.soundBytes.length : soundLength;
                    if (soundLength >= 0) {
                        this.line.write(this.soundBytes, 0, soundLength);
                    }
                }
            }
        }
    }

    public static void resetWaveCollector() {
        output = new byte[0];
    }

    public static void saveWaveCollector(byte[] out, String n) {
        if (!DEBUG_WAV_OUT) {
            return;
        }
        String name = n + sampleCount++ + ".wav";
        try {
            byte[] orgData16Bit2Channel = out;
            AudioFormat tinyformat = audioFormat;
            AudioInputStream audioStream = new AudioInputStream(new ByteArrayInputStream(orgData16Bit2Channel), tinyformat, orgData16Bit2Channel.length / 2);
            AudioFileFormat.Type targetType = SampleJPanel.findTargetType("wav");
            AudioSystem.write(audioStream, targetType, new File(name));
        }
        catch (Throwable e) {
            Configuration.getConfiguration().getDebugEntity().addLog(e, LogPanel.WARN);
        }
    }

    public static void saveWaveCollector() {
        if (output.length > 0) {
            VecSpeechDevice.saveWaveCollector(output, "Sample");
        }
    }

    int getLastPreviousNegativeToPositivePass(byte[] data2, int ms) {
        int posFound;
        int sampleStartSearch = ms * 44;
        int backPos = data2.length - (sampleStartSearch *= 2);
        if (backPos < 0) {
            return -1;
        }
        if (backPos % 2 == 1) {
            --backPos;
        }
        int lastValue = 1;
        for (posFound = backPos; posFound < data2.length; posFound += 2) {
            int newValue = this.bit16(data2, posFound);
            if (Math.abs(newValue) < amplitudeThreshold) {
                newValue = 0;
            }
            if (lastValue <= 0 && newValue > 0) break;
            lastValue = newValue;
        }
        if (posFound == data2.length) {
            return backPos;
        }
        return posFound;
    }

    int getNextPreviousNegativeToPositivePass(byte[] data2, int maxSearch) {
        int posFound;
        maxSearch /= 2;
        maxSearch *= 2;
        int lastValue = 1;
        for (posFound = 0; posFound < data2.length; posFound += 2) {
            int val = this.bit16(data2, posFound);
            if (Math.abs(val) < amplitudeThreshold) {
                val = 0;
            }
            if (lastValue <= 0 && val > 0) break;
            lastValue = val;
        }
        if (posFound == data2.length) {
            return -1;
        }
        if (posFound > maxSearch) {
            posFound = maxSearch;
        }
        return posFound;
    }

    int bit16(byte[] loHi, int pos) {
        int lo = loHi[pos] & 0xFF;
        int hi = (loHi[pos + 1] & 0xFF) * 256;
        int val = lo + hi;
        if (val > Short.MAX_VALUE) {
            val -= 65536;
        }
        return val;
    }

    byte[] blendWavStartFrequence(byte[] smallArray, byte[] largeArray, boolean seekStartWave) {
        int pos = 0;
        if (seekStartWave) {
            pos = this.getNextPreviousNegativeToPositivePass(largeArray, smallArray.length);
        }
        if (pos == -1) {
            return VecSpeechDevice.concat(smallArray, largeArray);
        }
        byte[] newArray = Arrays.copyOfRange(largeArray, pos, largeArray.length);
        int i = 0;
        while (i + 1 < smallArray.length && i + 1 < newArray.length) {
            int val1 = this.bit16(newArray, i);
            int val2 = this.bit16(smallArray, i);
            int val = (val1 + val2) / 2;
            newArray[i] = (byte)(val & 0xFF);
            newArray[i + 1] = (byte)(val >> 8 & 0xFF);
            i += 2;
        }
        return newArray;
    }

    byte[] removeSilence(byte[] data2, int maximumNoise) {
        int start = 0;
        int end2 = data2.length - 2;
        if (end2 % 2 == 1) {
            --end2;
        }
        int value = 0;
        while (start < end2 && Math.abs(value = this.bit16(data2, start)) <= maximumNoise) {
            start += 2;
        }
        if (value < 0) {
            while (start > 0 && (value = this.bit16(data2, start)) < 0) {
                start -= 2;
            }
        }
        while (start > 0 && (value = this.bit16(data2, start)) >= 0) {
            start -= 2;
        }
        while (end2 > start && Math.abs(value = this.bit16(data2, end2)) <= maximumNoise) {
            end2 -= 2;
        }
        if (value > 0) {
            while (end2 < data2.length && (value = this.bit16(data2, end2)) > 0) {
                end2 += 2;
            }
        }
        while (end2 < data2.length && (value = this.bit16(data2, end2)) <= 0) {
            end2 += 2;
        }
        byte[] outArray = Arrays.copyOfRange(data2, start, end2);
        return outArray;
    }

    int fillSoundBuffer(int maxSoundLength) {
        int outBufferPos = 0;
        int restBuffer = maxSoundLength;
        int size = 0;
        while (true) {
            int command;
            if (this.currentSamplePos != -1) {
                int rest;
                if (this.currentSamplePos == 0) {
                    if (removeSilence && !this.afterPause && this.removeSilenceFromSample) {
                        this.wavData = this.removeSilence(this.wavData, maxNoise);
                    }
                    if (this.lastCommand >= 128) {
                        this.afterPause = false;
                    }
                }
                if (!this.SPO256AL2 && enableCommands) {
                    this.speakjetPreprocessWavWithCommand();
                }
                if (this.currentSamplePos == 0) {
                    if (!blendEnable) {
                        this.wavDataUsage = this.wavData;
                        this.wavDataLastEnd = new byte[0];
                        this.doSampleBlending = false;
                    } else {
                        int pos = this.getLastPreviousNegativeToPositivePass(this.wavData, blendLen);
                        if (this.lastCommand >= 128) {
                            blendLen = 15;
                        }
                        if (pos == -1) {
                            this.wavDataUsage = this.wavData;
                            if (this.wavDataLastEnd != null) {
                                this.wavDataUsage = VecSpeechDevice.concat(this.wavDataLastEnd, this.wavDataUsage);
                            }
                            this.wavDataLastEnd = null;
                            this.doSampleBlending = false;
                        } else {
                            this.wavDataUsage = new byte[pos];
                            System.arraycopy(this.wavData, 0, this.wavDataUsage, 0, pos);
                            if (this.doSampleBlending) {
                                this.wavDataUsage = this.blendWavStartFrequence(this.wavDataLastEnd, this.wavDataUsage, alignBlendToAmplitude);
                            } else if (this.wavDataLastEnd != null) {
                                this.wavDataUsage = VecSpeechDevice.concat(this.wavDataLastEnd, this.wavDataUsage);
                            }
                            this.wavDataLastEnd = new byte[this.wavData.length - pos];
                            this.doSampleBlending = true;
                            System.arraycopy(this.wavData, pos, this.wavDataLastEnd, 0, this.wavData.length - pos);
                        }
                    }
                    this.removeSilenceFromSample = true;
                }
                if ((rest = this.wavDataUsage.length - this.currentSamplePos) > restBuffer) {
                    System.arraycopy(this.wavDataUsage, this.currentSamplePos, this.soundBytes, outBufferPos, restBuffer);
                    this.currentSamplePos += restBuffer;
                    size = maxSoundLength;
                    outBufferPos += restBuffer;
                    restBuffer = 0;
                    break;
                }
                System.arraycopy(this.wavDataUsage, this.currentSamplePos, this.soundBytes, outBufferPos, rest);
                outBufferPos += rest;
                this.currentSamplePos = -1;
                this.wavDataUsage = null;
                restBuffer -= rest;
                size += rest;
                continue;
            }
            this.lastCommand = command = this.getNextCommand();
            if (command == -1) {
                if (!this.doSampleBlending) break;
                this.doSampleBlending = false;
                this.wavDataUsage = this.wavDataLastEnd;
                this.currentSamplePos = 0;
                int rest = this.wavDataUsage.length - this.currentSamplePos;
                if (rest > restBuffer) {
                    System.arraycopy(this.wavDataUsage, this.currentSamplePos, this.soundBytes, outBufferPos, restBuffer);
                    this.currentSamplePos += restBuffer;
                    size = maxSoundLength;
                    outBufferPos += restBuffer;
                    restBuffer = 0;
                    break;
                }
                System.arraycopy(this.wavDataUsage, this.currentSamplePos, this.soundBytes, outBufferPos, rest);
                outBufferPos += rest;
                this.currentSamplePos = -1;
                this.wavDataUsage = null;
                restBuffer -= rest;
                size += rest;
                continue;
            }
            MemSound sample = null;
            if (this.SPO256AL2) {
                if (command > 63) continue;
                sample = VecVoiceSamples.getSample(command);
            } else {
                if (this.isSpCommandMode()) {
                    int param = command;
                    this.speakJetdoCommandWithParameter(param);
                    continue;
                }
                if (command < 128) {
                    this.spCommand = command;
                    if (!enableCommands) continue;
                    this.speakJetAcceptCommand(command);
                    continue;
                }
                sample = VecVoxSamples.getSample(command);
                if (command >= 128) {
                    if (command < 255) {
                        VecVoxSamples.SpeakJetMSA sp = VecVoxSamples.allSamples[command - 128];
                        if (!this.afterPause && sp.stoppedSound) {
                            this.removeSilenceFromSample = false;
                        }
                        this.isVoiced = command < 182;
                    } else {
                        this.isVoiced = false;
                    }
                }
            }
            if (sample == null) continue;
            this.wavData = Arrays.copyOf(sample.getLeftData(), sample.getLeftData().length);
            this.currentSamplePos = 0;
        }
        return size;
    }

    void speakjetPreprocessWavWithCommand() {
        double tmp;
        int i;
        if (this.currentSamplePos != 0) {
            return;
        }
        this.spDelay = 0;
        boolean enabled = false;
        if (this.getSpBend() > 5) {
            int shift = this.getSpBend() - 5;
            shift = 360 / shift;
            double freqShiftPhase = 0.0;
            double freqShiftDeltaPhase = (double)(shift * 2) * Math.PI / 44100.0;
            for (i = 0; i < this.wavData.length; i += 2) {
                int lo = this.wavData[i] & 0xFF;
                int hi = this.wavData[i + 1] & 0xFF;
                int sampleI = lo + (hi << 8);
                if (sampleI > Short.MAX_VALUE) {
                    sampleI -= 65536;
                }
                double sampled = (double)sampleI / 32767.0;
                double newSample = sampled * Math.sin(freqShiftPhase += freqShiftDeltaPhase);
                sampleI = (int)(newSample * 32767.0);
                this.wavData[i + 1] = (byte)(sampleI >> 8 & 0xFF);
                this.wavData[i + 0] = (byte)(sampleI & 0xFF);
            }
        }
        boolean doTarsos = false;
        double currentFactor = 1.0;
        RateTransposer rateTransposer = null;
        if (this.getSpPitch() != 88 && this.isVoiced) {
            doTarsos = true;
            tmp = 1.0 / ((double)this.getSpPitch() / 88.0);
            tmp -= 1.0;
            tmp /= 5.0;
            doTarsos = true;
            currentFactor *= (tmp += 1.0);
            if ((currentFactor *= tmp) < 0.1) {
                currentFactor = 0.1;
            }
            if (currentFactor > 4.0) {
                currentFactor = 4.0;
            }
            rateTransposer = new RateTransposer(currentFactor);
        }
        if (this.getSpTempo() != 114) {
            tmp = (double)this.getSpTempo() / 114.0;
            if (tmp < 1.0) {
                tmp *= 0.9;
            }
            if (tmp > 1.0) {
                tmp *= 1.1;
            }
            currentFactor *= tmp;
            doTarsos = true;
        }
        if (this.isSpNextSlow()) {
            this.spNextSlow = false;
            currentFactor *= 0.8;
            doTarsos = true;
        }
        if (this.isSpNextFast()) {
            this.spNextFast = false;
            currentFactor *= 1.2;
            doTarsos = true;
        }
        this.spNextStress = false;
        this.spNextRelax = false;
        if (doTarsos) {
            try {
                TarsosReceiver receiver = new TarsosReceiver();
                int sampleRate = 44100;
                int sequenceWindowInMS = 20;
                int overlapSeekingWindowsSizeInMS = 15;
                int overlapLength = 10;
                if (currentFactor < 1.0) {
                    sequenceWindowInMS = 30;
                    overlapSeekingWindowsSizeInMS = 15;
                    overlapLength = 5;
                }
                if (currentFactor > 1.0) {
                    sequenceWindowInMS = 15;
                    overlapSeekingWindowsSizeInMS = 8;
                    overlapLength = 4;
                }
                WaveformSimilarityBasedOverlapAdd.Parameters wparam = new WaveformSimilarityBasedOverlapAdd.Parameters(currentFactor, sampleRate, sequenceWindowInMS, overlapSeekingWindowsSizeInMS, overlapLength);
                WaveformSimilarityBasedOverlapAdd wsola = new WaveformSimilarityBasedOverlapAdd(wparam);
                AudioDispatcher dispatcher = AudioDispatcherFactory.fromByteArray(this.wavData, audioFormat, wsola.getInputBufferSize(), wsola.getOverlap());
                wsola.setDispatcher(dispatcher);
                if (rateTransposer != null) {
                    dispatcher.addAudioProcessor(rateTransposer);
                }
                dispatcher.addAudioProcessor(wsola);
                dispatcher.addAudioProcessor(receiver);
                dispatcher.run();
                this.wavData = receiver.finalBuffer;
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        if (this.getSpRepeat() > 1) {
            byte[] dummy = new byte[]{};
            for (i = 0; i < this.getSpRepeat(); ++i) {
                dummy = VecSpeechDevice.concat(dummy, this.wavData);
            }
            this.wavData = dummy;
            this.spRepeat = 0;
        }
    }

    void speakJetdoCommandWithParameter(int param) {
        this.spCommandMode = false;
        if (this.getSpCommand() == 20) {
            this.spVolume = (double)(param & 0x7F) / 127.0;
            if (this.line != null) {
                this.line.setVolume(this.getSpVolume());
            }
        } else if (this.getSpCommand() == 21) {
            this.spTempo = param;
        } else if (this.getSpCommand() == 22) {
            this.spPitch = param;
        } else if (this.getSpCommand() == 23) {
            this.spBend = param;
        } else if (this.getSpCommand() == 26) {
            this.spRepeat = param;
        } else if (this.getSpCommand() == 30) {
            this.spDelay = param;
            int delay = param;
            int delaySamples = delay * 441;
            byte[] delayBuffer = new byte[delaySamples * 2];
            this.wavData = delayBuffer;
            this.currentSamplePos = 0;
            this.isVoiced = false;
        }
    }

    void speakJetAcceptCommand(int command) {
        this.spCommand = command;
        if (command == 0) {
            this.removeSilenceFromSample = false;
            this.afterPause = true;
            blendEnable = false;
        } else if (command == 1) {
            MemSound sample = VecVoxSamples.getPauseSample(1);
            this.wavData = Arrays.copyOf(sample.getLeftData(), sample.getLeftData().length);
            this.currentSamplePos = 0;
            this.removeSilenceFromSample = false;
            this.afterPause = true;
            blendEnable = true;
            blendLen = 30;
            this.isVoiced = false;
        } else if (command == 2) {
            MemSound sample = VecVoxSamples.getPauseSample(2);
            this.wavData = Arrays.copyOf(sample.getLeftData(), sample.getLeftData().length);
            this.currentSamplePos = 0;
            this.removeSilenceFromSample = false;
            this.afterPause = true;
            blendEnable = true;
            blendLen = 60;
            this.isVoiced = false;
        } else if (command == 3) {
            MemSound sample = VecVoxSamples.getPauseSample(3);
            this.wavData = Arrays.copyOf(sample.getLeftData(), sample.getLeftData().length);
            this.currentSamplePos = 0;
            this.removeSilenceFromSample = false;
            this.afterPause = true;
            blendEnable = true;
            blendLen = 200;
            this.isVoiced = false;
        } else if (command == 4) {
            MemSound sample = VecVoxSamples.getPauseSample(4);
            this.wavData = Arrays.copyOf(sample.getLeftData(), sample.getLeftData().length);
            this.currentSamplePos = 0;
            this.removeSilenceFromSample = false;
            this.afterPause = true;
            blendEnable = true;
            blendLen = 10;
            this.isVoiced = false;
        } else if (command == 5) {
            MemSound sample = VecVoxSamples.getPauseSample(5);
            this.wavData = Arrays.copyOf(sample.getLeftData(), sample.getLeftData().length);
            this.currentSamplePos = 0;
            this.removeSilenceFromSample = false;
            this.afterPause = true;
            blendEnable = true;
            blendLen = 20;
            this.isVoiced = false;
        } else if (command == 6) {
            MemSound sample = VecVoxSamples.getPauseSample(6);
            this.wavData = Arrays.copyOf(sample.getLeftData(), sample.getLeftData().length);
            this.currentSamplePos = 0;
            this.removeSilenceFromSample = false;
            this.afterPause = true;
            blendEnable = true;
            blendLen = 30;
            this.isVoiced = false;
        } else if (command == 7) {
            this.spNextFast = true;
        } else if (command == 8) {
            this.spNextSlow = true;
        } else if (command == 14) {
            this.spNextStress = true;
        } else if (command == 15) {
            this.spNextRelax = true;
        } else if (command == 20) {
            this.spCommandMode = true;
            this.spCommand = command;
        } else if (command == 21) {
            this.spCommandMode = true;
            this.spCommand = command;
        } else if (command == 22) {
            this.spCommandMode = true;
            this.spCommand = command;
        } else if (command == 23) {
            this.spCommandMode = true;
            this.spCommand = command;
        } else if (command == 26) {
            this.spCommandMode = true;
            this.spCommand = command;
        } else if (command == 30) {
            this.spCommandMode = true;
            this.spCommand = command;
        } else if (command == 31) {
            this.spVolume = 0.7559055118110236;
            this.spPitch = 88;
            this.spTempo = 114;
            this.spBend = 5;
            if (this.line != null) {
                this.line.setVolume(this.getSpVolume());
            }
            blendEnable = true;
            this.afterPause = true;
            blendLen = 15;
            this.isVoiced = false;
            this.spDelay = 0;
            this.spNextStress = false;
            this.spNextRelax = false;
            this.spNextSlow = false;
            this.spNextFast = false;
        }
    }

    public static byte[] concat(byte[] a, byte[] b) {
        int aLen = a.length;
        int bLen = b.length;
        byte[] c = new byte[aLen + bLen];
        System.arraycopy(a, 0, c, 0, aLen);
        System.arraycopy(b, 0, c, aLen, bLen);
        return c;
    }

    public static byte[] concat(byte[] a, byte[] b, int bMax) {
        int aLen = a.length;
        int bLen = bMax;
        byte[] c = new byte[aLen + bLen];
        System.arraycopy(a, 0, c, 0, aLen);
        System.arraycopy(b, 0, c, aLen, bLen);
        return c;
    }

    public boolean isSpNextFast() {
        return this.spNextFast;
    }

    public boolean isSpNextSlow() {
        return this.spNextSlow;
    }

    public boolean isSpNextStress() {
        return this.spNextStress;
    }

    public boolean isSpNextRelax() {
        return this.spNextRelax;
    }

    public boolean isSpCommandMode() {
        return this.spCommandMode;
    }

    public double getSpVolume() {
        return this.spVolume;
    }

    public int getSpCommand() {
        return this.spCommand;
    }

    public int getSpPitch() {
        return this.spPitch;
    }

    public int getSpTempo() {
        return this.spTempo;
    }

    public int getSpBend() {
        return this.spBend;
    }

    public int getSpRepeat() {
        return this.spRepeat;
    }

    public int getSpDelay() {
        return this.spDelay;
    }

    public static void speak(final ArrayList<Integer> commands, final boolean isVecVoice) {
        VecSpeechDevice.stopSpeaking();
        if (speaker != null) {
            return;
        }
        if (running) {
            return;
        }
        running = true;
        speaker = new Thread(){

            @Override
            public void run() {
                VecSpeechDevice vecSpeech = new VecSpeechDevice();
                vecSpeech.setVecVoice(isVecVoice);
                vecSpeech.commands = new int[vecSpeech.C_LEN];
                vecSpeech.soundBytes = new byte[IBXM.IBXM_MAXBUFFER / 2];
                for (int i = 0; i < vecSpeech.C_LEN; ++i) {
                    vecSpeech.commands[i] = -1;
                }
                int commandPointer = 0;
                long cycles = 0L;
                try {
                    Thread.sleep(10L);
                    try {
                        int overloop = 0;
                        while (running) {
                            if (commandPointer < commands.size() && vecSpeech.isReady()) {
                                vecSpeech.addCommand((Integer)commands.get(commandPointer++));
                            }
                            vecSpeech.stepSound(cycles);
                            Thread.sleep(5L);
                            cycles += 7500L;
                            if (commandPointer != commands.size() || vecSpeech.nextComandPoint != vecSpeech.currentComandPoint || ++overloop != 50) continue;
                            Thread.sleep(500L);
                            running = false;
                        }
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (saveWave) {
                    VecSpeechDevice.saveWaveCollector();
                }
                speaker = null;
                running = false;
            }
        };
        speaker.setName("SpeakJet speaker...");
        speaker.start();
    }

    public static void stopSpeaking() {
        if (speaker == null) {
            return;
        }
        running = false;
        try {
            while (speaker != null) {
                Thread.sleep(10L);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    class TarsosReceiver
    implements AudioProcessor {
        byte[] finalBuffer = new byte[0];

        @Override
        public boolean process(AudioEvent audioEvent) {
            this.finalBuffer = VecSpeechDevice.concat(this.finalBuffer, audioEvent.getByteBuffer());
            return true;
        }

        @Override
        public void processingFinished() {
        }
    }
}

