/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.vecx.devices;

import de.malban.Global;
import de.malban.config.Configuration;
import de.malban.gui.panels.LogPanel;
import de.malban.sound.tinysound.TinySound;
import de.malban.sound.tinysound.internal.MemSound;
import java.io.File;
import java.util.HashMap;

public class VecVoiceSamples {
    LogPanel log = (LogPanel)Configuration.getConfiguration().getDebugEntity();
    static SP0256AL[] allSamples;
    static HashMap<Integer, MemSound> playList;
    static final HashMap<String, String> codeMap;
    static boolean init;

    public static SP0256AL[] getAllSamples() {
        VecVoiceSamples.loadSamples();
        return allSamples;
    }

    public static boolean loadSamples() {
        if (init) {
            return true;
        }
        int s = 0;
        VecVoiceSamples.allSamples[s++] = new SP0256AL(0, "PA1", "PAUSE 10ms", 10);
        VecVoiceSamples.allSamples[s++] = new SP0256AL(1, "PA2", "PAUSE 30ms", 30);
        VecVoiceSamples.allSamples[s++] = new SP0256AL(2, "PA3", "PAUSE 50ms", 50);
        VecVoiceSamples.allSamples[s++] = new SP0256AL(3, "PA4", "PAUSE 100ms", 100);
        VecVoiceSamples.allSamples[s++] = new SP0256AL(4, "PA5", "PAUSE 200ms", 200);
        VecVoiceSamples.allSamples[s++] = new SP0256AL(5, "OY", "BOY", 420);
        VecVoiceSamples.allSamples[s++] = new SP0256AL(6, "AY", "Sky", 260);
        VecVoiceSamples.allSamples[s++] = new SP0256AL(7, "EH", "End", 70);
        VecVoiceSamples.allSamples[s++] = new SP0256AL(8, "KK3", "Comb", 120);
        VecVoiceSamples.allSamples[s++] = new SP0256AL(9, "PP", "Pow", 210);
        VecVoiceSamples.allSamples[s++] = new SP0256AL(10, "JH", "Dodge", 140);
        VecVoiceSamples.allSamples[s++] = new SP0256AL(11, "NN1", "Thin", 140);
        VecVoiceSamples.allSamples[s++] = new SP0256AL(12, "IH", "Sit", 70);
        VecVoiceSamples.allSamples[s++] = new SP0256AL(13, "TT2", "To", 140);
        VecVoiceSamples.allSamples[s++] = new SP0256AL(14, "RR1", "Rural", 170);
        VecVoiceSamples.allSamples[s++] = new SP0256AL(15, "AX", "Succeed", 70);
        VecVoiceSamples.allSamples[s++] = new SP0256AL(16, "MM", "Milk", 180);
        VecVoiceSamples.allSamples[s++] = new SP0256AL(17, "TT1", "Part", 100);
        VecVoiceSamples.allSamples[s++] = new SP0256AL(18, "DH1", "They", 290);
        VecVoiceSamples.allSamples[s++] = new SP0256AL(19, "IY", "See", 250);
        VecVoiceSamples.allSamples[s++] = new SP0256AL(20, "EY", "Beige", 280);
        VecVoiceSamples.allSamples[s++] = new SP0256AL(21, "DD1", "Could", 70);
        VecVoiceSamples.allSamples[s++] = new SP0256AL(22, "UW1", "To", 100);
        VecVoiceSamples.allSamples[s++] = new SP0256AL(23, "AO", "Aught", 100);
        VecVoiceSamples.allSamples[s++] = new SP0256AL(24, "AA", "Hot", 100);
        VecVoiceSamples.allSamples[s++] = new SP0256AL(25, "YY2", "Yes", 180);
        VecVoiceSamples.allSamples[s++] = new SP0256AL(26, "AE", "Hat", 120);
        VecVoiceSamples.allSamples[s++] = new SP0256AL(27, "HH1", "He", 130);
        VecVoiceSamples.allSamples[s++] = new SP0256AL(28, "BB1", "Business", 80);
        VecVoiceSamples.allSamples[s++] = new SP0256AL(29, "TH", "Thin", 180);
        VecVoiceSamples.allSamples[s++] = new SP0256AL(30, "UH", "Book", 100);
        VecVoiceSamples.allSamples[s++] = new SP0256AL(31, "UW2", "Food", 260);
        VecVoiceSamples.allSamples[s++] = new SP0256AL(32, "AW", "Out", 370);
        VecVoiceSamples.allSamples[s++] = new SP0256AL(33, "DD2", "Do", 160);
        VecVoiceSamples.allSamples[s++] = new SP0256AL(34, "GG3", "Wig", 140);
        VecVoiceSamples.allSamples[s++] = new SP0256AL(35, "VV", "Vest", 190);
        VecVoiceSamples.allSamples[s++] = new SP0256AL(36, "GG1", "Got", 80);
        VecVoiceSamples.allSamples[s++] = new SP0256AL(37, "SH", "Ship", 160);
        VecVoiceSamples.allSamples[s++] = new SP0256AL(38, "ZH", "Azure", 190);
        VecVoiceSamples.allSamples[s++] = new SP0256AL(39, "RR2", "Brain", 120);
        VecVoiceSamples.allSamples[s++] = new SP0256AL(40, "FF", "Food", 150);
        VecVoiceSamples.allSamples[s++] = new SP0256AL(41, "KK2", "Sky", 190);
        VecVoiceSamples.allSamples[s++] = new SP0256AL(42, "KK1", "Can't", 160);
        VecVoiceSamples.allSamples[s++] = new SP0256AL(43, "ZZ", "Zoo", 210);
        VecVoiceSamples.allSamples[s++] = new SP0256AL(44, "NG", "Anchor", 220);
        VecVoiceSamples.allSamples[s++] = new SP0256AL(45, "LL", "Lake", 110);
        VecVoiceSamples.allSamples[s++] = new SP0256AL(46, "WW", "Wool", 180);
        VecVoiceSamples.allSamples[s++] = new SP0256AL(47, "XR", "Repair", 360);
        VecVoiceSamples.allSamples[s++] = new SP0256AL(48, "WH", "Whig", 200);
        VecVoiceSamples.allSamples[s++] = new SP0256AL(49, "YY1", "Yes", 130);
        VecVoiceSamples.allSamples[s++] = new SP0256AL(50, "CH", "Church", 190);
        VecVoiceSamples.allSamples[s++] = new SP0256AL(51, "ER1", "Fir", 160);
        VecVoiceSamples.allSamples[s++] = new SP0256AL(52, "ER2", "Fir", 300);
        VecVoiceSamples.allSamples[s++] = new SP0256AL(53, "OW", "Beau", 240);
        VecVoiceSamples.allSamples[s++] = new SP0256AL(54, "DH2", "They", 240);
        VecVoiceSamples.allSamples[s++] = new SP0256AL(55, "SS", "Vest", 90);
        VecVoiceSamples.allSamples[s++] = new SP0256AL(56, "NN2", "No", 190);
        VecVoiceSamples.allSamples[s++] = new SP0256AL(57, "HH2", "Hoe", 180);
        VecVoiceSamples.allSamples[s++] = new SP0256AL(58, "OR", "Store", 330);
        VecVoiceSamples.allSamples[s++] = new SP0256AL(59, "AR", "Alarm", 290);
        VecVoiceSamples.allSamples[s++] = new SP0256AL(60, "YR", "Clear", 350);
        VecVoiceSamples.allSamples[s++] = new SP0256AL(61, "GG2", "Guest", 40);
        VecVoiceSamples.allSamples[s++] = new SP0256AL(62, "EL", "Saddle", 190);
        VecVoiceSamples.allSamples[s++] = new SP0256AL(63, "BB2", "Business", 50);
        codeMap.put("VOICE_TERM", "255");
        ((LogPanel)Configuration.getConfiguration().getDebugEntity()).addLog("VecVoice: samples loaded.", LogPanel.INFO);
        init = true;
        return true;
    }

    public static HashMap<String, String> getCodeMap() {
        VecVoiceSamples.loadSamples();
        return codeMap;
    }

    public static String getMnemonic(int code2) {
        if (code2 == -1) {
            return "EOP";
        }
        if (code2 == 255) {
            return "EOP";
        }
        if (code2 > 63) {
            return "n/a (" + code2 + ")";
        }
        if (code2 < 0) {
            return "n/a (" + code2 + ")";
        }
        SP0256AL sample = allSamples[code2];
        if (sample == null) {
            return "error (" + code2 + ")";
        }
        return sample.phoneme;
    }

    public static MemSound getSample(int code2) {
        if (playList == null) {
            ((LogPanel)Configuration.getConfiguration().getDebugEntity()).addLog("VecVoice: samples not initialized", LogPanel.INFO);
            return null;
        }
        MemSound sample = playList.get(code2);
        if (sample == null) {
            ((LogPanel)Configuration.getConfiguration().getDebugEntity()).addLog("VecVoice: sample for code: " + code2 + " not found", LogPanel.INFO);
            return null;
        }
        return sample;
    }

    public static MemSound playSample(int code2) {
        MemSound sample = VecVoiceSamples.getSample(code2);
        if (sample == null) {
            return null;
        }
        sample.play();
        ((LogPanel)Configuration.getConfiguration().getDebugEntity()).addLog("VecVoice: playing sample for code: " + code2, LogPanel.INFO);
        return sample;
    }

    static {
        init = false;
        codeMap = new HashMap();
        allSamples = new SP0256AL[64];
        playList = new HashMap();
        VecVoiceSamples.loadSamples();
    }

    public static class SP0256AL {
        public int code = -1;
        public String phoneme = "";
        public String sampleWords = "";
        int timing = -1;
        MemSound sample = null;
        String filename = "";

        SP0256AL(int c, String p, String sw, int t) {
            this.code = c;
            this.phoneme = p;
            codeMap.put(this.phoneme, "" + c);
            this.sampleWords = sw;
            this.timing = t;
            this.filename = this.phoneme;
            String loadname = Global.mainPathPrefix + "samples" + File.separator + "SPO256AL2" + File.separator + this.filename + ".wav";
            this.sample = (MemSound)TinySound.loadSound(new File(loadname), false);
            if (this.sample != null) {
                playList.put(this.code, this.sample);
            }
        }
    }
}

