/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.vecx.devices;

import de.malban.Global;
import de.malban.config.Configuration;
import de.malban.gui.panels.LogPanel;
import de.malban.sound.tinysound.TinySound;
import de.malban.sound.tinysound.internal.MemSound;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;

public class VecVoxSamples {
    LogPanel log = (LogPanel)Configuration.getConfiguration().getDebugEntity();
    static final SpeakJetMSA[] allSamples;
    static final SpeakJetMSA[] pauseSamples;
    static final ArrayList<SpeakSpecials> allSpecials;
    static final HashMap<Integer, MemSound> playList;
    static final HashMap<String, String> codeMap;
    static final HashMap<String, Integer> notes;
    static final ArrayList<SpeakSpecials> notesList;
    static boolean init;

    public static ArrayList<SpeakSpecials> getAllSpecials() {
        VecVoxSamples.loadSamples();
        return allSpecials;
    }

    public static SpeakJetMSA[] getAllSamples() {
        VecVoxSamples.loadSamples();
        return allSamples;
    }

    public static HashMap<String, String> getCodeMap() {
        VecVoxSamples.loadSamples();
        return codeMap;
    }

    private static boolean loadSamples() {
        if (init) {
            return true;
        }
        for (int i = 0; i < 256; ++i) {
            codeMap.put("" + i, "" + i);
        }
        allSpecials.add(new SpeakSpecials("\\P0", "0"));
        allSpecials.add(new SpeakSpecials("\\P1", "1"));
        allSpecials.add(new SpeakSpecials("\\P2", "2"));
        allSpecials.add(new SpeakSpecials("\\P3", "3"));
        allSpecials.add(new SpeakSpecials("\\P4", "4"));
        allSpecials.add(new SpeakSpecials("\\P5", "5"));
        allSpecials.add(new SpeakSpecials("\\P6", "6"));
        allSpecials.add(new SpeakSpecials("\\FAST", "7"));
        allSpecials.add(new SpeakSpecials("\\SLOW", "8"));
        allSpecials.add(new SpeakSpecials("\\SOFT", "8"));
        allSpecials.add(new SpeakSpecials("\\STRESS", "14"));
        allSpecials.add(new SpeakSpecials("\\RELAX", "15"));
        allSpecials.add(new SpeakSpecials("\\VOLUME", "20, x (96)"));
        allSpecials.add(new SpeakSpecials("\\SPEED", "21, x (114)"));
        allSpecials.add(new SpeakSpecials("\\PITCH", "22, x (88)"));
        allSpecials.add(new SpeakSpecials("\\BEND", "23, x (5)"));
        allSpecials.add(new SpeakSpecials("\\REPEAT", "26, x (1)"));
        allSpecials.add(new SpeakSpecials("\\DELAY", "30, x (0)"));
        allSpecials.add(new SpeakSpecials("\\RESET", "31"));
        allSpecials.add(new SpeakSpecials("\\VOX_TERM", "255"));
        for (SpeakSpecials sps : notesList) {
            allSpecials.add(sps);
        }
        int s = 0;
        VecVoxSamples.allSamples[s++] = new SpeakJetMSA(128, "IY", "See, Even, Feed", 70, "Voiced Long Vowel");
        VecVoxSamples.allSamples[s++] = new SpeakJetMSA(129, "IH", "Sit, Fix, Pin", 70, "Voiced Short Vowel");
        VecVoxSamples.allSamples[s++] = new SpeakJetMSA(130, "EY", "Hair, Gate, Beige", 70, "Voiced Long Vowel");
        VecVoxSamples.allSamples[s++] = new SpeakJetMSA(131, "EH", "Met, Check, Red", 70, "Voiced Short Vowel");
        VecVoxSamples.allSamples[s++] = new SpeakJetMSA(132, "AY", "Hat, Fast, Fan", 70, "Voiced Short Vowel");
        VecVoxSamples.allSamples[s++] = new SpeakJetMSA(133, "AX", "Cotten", 70, "Voiced Short Vowel");
        VecVoxSamples.allSamples[s++] = new SpeakJetMSA(134, "UX", "Luck, Up, Uncle", 70, "Voiced Short Vowel");
        VecVoxSamples.allSamples[s++] = new SpeakJetMSA(135, "OH", "Hot, Clock, Fox", 70, "Voiced Short Vowel");
        VecVoxSamples.allSamples[s++] = new SpeakJetMSA(136, "AW", "Father, Fall", 70, "Voiced Short Vowel");
        VecVoxSamples.allSamples[s++] = new SpeakJetMSA(137, "OW", "Comb, Over, Hold", 70, "Voiced Long Vowel");
        VecVoxSamples.allSamples[s++] = new SpeakJetMSA(138, "UH", "Book, Could, Should", 70, "Voiced Short Vowel");
        VecVoxSamples.allSamples[s++] = new SpeakJetMSA(139, "UW", "Food, June", 70, "Voiced Long Vowel");
        VecVoxSamples.allSamples[s++] = new SpeakJetMSA(140, "MM", "Milk, Famous,", 70, "Voiced Nasal");
        VecVoxSamples.allSamples[s++] = new SpeakJetMSA(141, "NE", "Nip, Danger, Thin", 70, "Voiced Nasal");
        VecVoxSamples.allSamples[s++] = new SpeakJetMSA(142, "NO", "No, Snow, On", 70, "Voiced Nasal");
        VecVoxSamples.allSamples[s++] = new SpeakJetMSA(143, "NGE", "Think, Ping", 70, "Voiced Nasal");
        VecVoxSamples.allSamples[s++] = new SpeakJetMSA(144, "NGO", "Hung, Song", 70, "Voiced Nasal");
        VecVoxSamples.allSamples[s++] = new SpeakJetMSA(145, "LE", "Lake, Alarm, Lapel", 70, "Voiced Resonate");
        VecVoxSamples.allSamples[s++] = new SpeakJetMSA(146, "LO", "Clock, Plus, Hello", 70, "Voiced Resonate");
        VecVoxSamples.allSamples[s++] = new SpeakJetMSA(147, "WW", "Wool, Sweat", 70, "Voiced Resonate");
        VecVoxSamples.allSamples[s++] = new SpeakJetMSA(148, "RR", "Ray, Brain, Over", 70, "Voiced Resonate");
        VecVoxSamples.allSamples[s++] = new SpeakJetMSA(149, "IYRR", "Clear, Hear, Year", 200, "Voiced R Color Vowel");
        VecVoxSamples.allSamples[s++] = new SpeakJetMSA(150, "EYRR", "Hair, Stair, Repair", 200, "Voiced R Color Vowel");
        VecVoxSamples.allSamples[s++] = new SpeakJetMSA(151, "AXRR", "Fir, Bird, Burn", 190, "Voiced R Color Vowel");
        VecVoxSamples.allSamples[s++] = new SpeakJetMSA(152, "AWRR", "Part, Farm, Yarn", 200, "Voiced R Color Vowel");
        VecVoxSamples.allSamples[s++] = new SpeakJetMSA(153, "OWRR", "Corn, Four, Your", 185, "Voiced R Color Vowel");
        VecVoxSamples.allSamples[s++] = new SpeakJetMSA(154, "EYIY", "Gate, Ate, Ray", 165, "Voiced Diphthong");
        VecVoxSamples.allSamples[s++] = new SpeakJetMSA(155, "OHIY", "Mice, Fight, White", 200, "Voiced Diphthong");
        VecVoxSamples.allSamples[s++] = new SpeakJetMSA(156, "OWIY", "Boy, Toy, Voice", 225, "Voiced Diphthong");
        VecVoxSamples.allSamples[s++] = new SpeakJetMSA(157, "OHIH", "Sky, Five, I", 185, "Voiced Diphthong");
        VecVoxSamples.allSamples[s++] = new SpeakJetMSA(158, "IYEH", "Yes, Yarn, Million", 170, "Voiced Diphthong");
        VecVoxSamples.allSamples[s++] = new SpeakJetMSA(159, "EHLL", "Saddle, Angle, Spell", 140, "Voiced Diphthong");
        VecVoxSamples.allSamples[s++] = new SpeakJetMSA(160, "IYUW", "Cute, Few,", 180, "Voiced Diphthong");
        VecVoxSamples.allSamples[s++] = new SpeakJetMSA(161, "AXUW", "Brown, Clown, Thousand", 170, "Voiced Diphthong");
        VecVoxSamples.allSamples[s++] = new SpeakJetMSA(162, "IHWW", "Two, New, Zoo", 170, "Voiced Diphthong");
        VecVoxSamples.allSamples[s++] = new SpeakJetMSA(163, "AYWW", "Our, Ouch, Owl", 200, "Voiced Diphthong");
        VecVoxSamples.allSamples[s++] = new SpeakJetMSA(164, "OWWW", "Go, Hello, Snow", 131, "Voiced Diphthong");
        VecVoxSamples.allSamples[s++] = new SpeakJetMSA(165, "JH", "Dodge, Jet, Savage", 70, "Voiced Affricate  STOP");
        VecVoxSamples.allSamples[s++] = new SpeakJetMSA(166, "VV", "Vest, Even,", 70, "Voiced Fictive");
        VecVoxSamples.allSamples[s++] = new SpeakJetMSA(167, "ZZ", "Zoo, Zap", 70, "Voiced Fictive");
        VecVoxSamples.allSamples[s++] = new SpeakJetMSA(168, "ZH", "Azure, Treasure", 70, "Voiced Fictive");
        VecVoxSamples.allSamples[s++] = new SpeakJetMSA(169, "DH", "There, That, This", 70, "Voiced Fictive");
        VecVoxSamples.allSamples[s++] = new SpeakJetMSA(170, "BE", "Bear, Bird, Beed", 45, "Voiced Stop");
        VecVoxSamples.allSamples[s++] = new SpeakJetMSA(171, "BO", "Bone, Book Brown", 45, "Voiced Stop");
        VecVoxSamples.allSamples[s++] = new SpeakJetMSA(172, "EB", "Cab, Crib, Web", 10, "Voiced Stop");
        VecVoxSamples.allSamples[s++] = new SpeakJetMSA(173, "OB", "Bob, Sub, Tub", 10, "Voiced Stop");
        VecVoxSamples.allSamples[s++] = new SpeakJetMSA(174, "DE", "Deep, Date, Divide", 45, "Voiced Stop");
        VecVoxSamples.allSamples[s++] = new SpeakJetMSA(175, "DO", "Do, Dust, Dog", 45, "Voiced Stop");
        VecVoxSamples.allSamples[s++] = new SpeakJetMSA(176, "ED", "Could, Bird", 10, "Voiced Stop");
        VecVoxSamples.allSamples[s++] = new SpeakJetMSA(177, "OD", "Bud, Food", 10, "Voiced Stop");
        VecVoxSamples.allSamples[s++] = new SpeakJetMSA(178, "GE", "Get, Gate, Guest,", 55, "Voiced Stop");
        VecVoxSamples.allSamples[s++] = new SpeakJetMSA(179, "GO", "Got, Glue, Goo", 55, "Voiced Stop");
        VecVoxSamples.allSamples[s++] = new SpeakJetMSA(180, "EG", "Peg, Wig", 55, "Voiced Stop");
        VecVoxSamples.allSamples[s++] = new SpeakJetMSA(181, "OG", "Dog, Peg", 55, "Voiced Stop");
        VecVoxSamples.allSamples[s++] = new SpeakJetMSA(182, "CH", "Church, Feature, March", 70, "Voiceless Affricate STOP");
        VecVoxSamples.allSamples[s++] = new SpeakJetMSA(183, "HE", "Help, Hand, Hair", 70, "Voiceless Fricative");
        VecVoxSamples.allSamples[s++] = new SpeakJetMSA(184, "HO", "Hoe, Hot, Hug", 70, "Voiceless Fricative");
        VecVoxSamples.allSamples[s++] = new SpeakJetMSA(185, "WH", "Who, Whale, White", 70, "Voiceless Fricative");
        VecVoxSamples.allSamples[s++] = new SpeakJetMSA(186, "FF", "Food, Effort, Off", 70, "Voiceless Fricative");
        VecVoxSamples.allSamples[s++] = new SpeakJetMSA(187, "SE", "See, Vest, Plus", 40, "Voiceless Fricative");
        VecVoxSamples.allSamples[s++] = new SpeakJetMSA(188, "SO", "So, Sweat", 40, "Voiceless Fricative");
        VecVoxSamples.allSamples[s++] = new SpeakJetMSA(189, "SH", "Ship, Fiction, Leash", 50, "Voiceless Fricative");
        VecVoxSamples.allSamples[s++] = new SpeakJetMSA(190, "TH", "Thin, month", 40, "Voiceless Fricative");
        VecVoxSamples.allSamples[s++] = new SpeakJetMSA(191, "TT", "Part, Little, Sit", 50, "Voiceless Stop");
        VecVoxSamples.allSamples[s++] = new SpeakJetMSA(192, "TU", "To, Talk, Ten", 70, "Voiceless Stop");
        VecVoxSamples.allSamples[s++] = new SpeakJetMSA(193, "TS", "Parts, Costs, Robots", 170, "Voiceless Stop");
        VecVoxSamples.allSamples[s++] = new SpeakJetMSA(194, "KE", "Can't, Clown, Key", 55, "Voiceless Stop");
        VecVoxSamples.allSamples[s++] = new SpeakJetMSA(195, "KO", "Comb, Quick, Fox", 55, "Voiceless Stop");
        VecVoxSamples.allSamples[s++] = new SpeakJetMSA(196, "EK", "Speak, Task", 55, "Voiceless Stop");
        VecVoxSamples.allSamples[s++] = new SpeakJetMSA(197, "OK", "Book, Took, October", 45, "Voiceless Stop");
        VecVoxSamples.allSamples[s++] = new SpeakJetMSA(198, "PE", "People, Computer", 99, "Voiceless Stop");
        VecVoxSamples.allSamples[s++] = new SpeakJetMSA(199, "PO", "Paw, Copy", 99, "Voiceless Stop");
        VecVoxSamples.allSamples[s++] = new SpeakJetMSA(200, "R0", "", 80, "Robot");
        VecVoxSamples.allSamples[s++] = new SpeakJetMSA(201, "R1", "", 80, "Robot");
        VecVoxSamples.allSamples[s++] = new SpeakJetMSA(202, "R2", "", 80, "Robot");
        VecVoxSamples.allSamples[s++] = new SpeakJetMSA(203, "R3", "", 80, "Robot");
        VecVoxSamples.allSamples[s++] = new SpeakJetMSA(204, "R4", "", 80, "Robot");
        VecVoxSamples.allSamples[s++] = new SpeakJetMSA(205, "R5", "", 80, "Robot");
        VecVoxSamples.allSamples[s++] = new SpeakJetMSA(206, "R6", "", 80, "Robot");
        VecVoxSamples.allSamples[s++] = new SpeakJetMSA(207, "R7", "", 80, "Robot");
        VecVoxSamples.allSamples[s++] = new SpeakJetMSA(208, "R8", "", 80, "Robot");
        VecVoxSamples.allSamples[s++] = new SpeakJetMSA(209, "R9", "", 80, "Robot");
        VecVoxSamples.allSamples[s++] = new SpeakJetMSA(210, "A0", "", 300, "Alarm");
        VecVoxSamples.allSamples[s++] = new SpeakJetMSA(211, "A1", "", 101, "Alarm");
        VecVoxSamples.allSamples[s++] = new SpeakJetMSA(212, "A2", "", 102, "Alarm");
        VecVoxSamples.allSamples[s++] = new SpeakJetMSA(213, "A3", "", 540, "Alarm");
        VecVoxSamples.allSamples[s++] = new SpeakJetMSA(214, "A4", "", 530, "Alarm");
        VecVoxSamples.allSamples[s++] = new SpeakJetMSA(215, "A5", "", 500, "Alarm");
        VecVoxSamples.allSamples[s++] = new SpeakJetMSA(216, "A6", "", 135, "Alarm");
        VecVoxSamples.allSamples[s++] = new SpeakJetMSA(217, "A7", "", 600, "Alarm");
        VecVoxSamples.allSamples[s++] = new SpeakJetMSA(218, "A8", "", 300, "Alarm");
        VecVoxSamples.allSamples[s++] = new SpeakJetMSA(219, "A9", "", 250, "Alarm");
        VecVoxSamples.allSamples[s++] = new SpeakJetMSA(220, "B0", "", 200, "Beeps");
        VecVoxSamples.allSamples[s++] = new SpeakJetMSA(221, "B1", "", 270, "Beeps");
        VecVoxSamples.allSamples[s++] = new SpeakJetMSA(222, "B2", "", 280, "Beeps");
        VecVoxSamples.allSamples[s++] = new SpeakJetMSA(223, "B3", "", 260, "Beeps");
        VecVoxSamples.allSamples[s++] = new SpeakJetMSA(224, "B4", "", 300, "Beeps");
        VecVoxSamples.allSamples[s++] = new SpeakJetMSA(225, "B5", "", 100, "Beeps");
        VecVoxSamples.allSamples[s++] = new SpeakJetMSA(226, "B6", "", 104, "Beeps");
        VecVoxSamples.allSamples[s++] = new SpeakJetMSA(227, "B7", "", 100, "Beeps");
        VecVoxSamples.allSamples[s++] = new SpeakJetMSA(228, "B8", "", 270, "Beeps");
        VecVoxSamples.allSamples[s++] = new SpeakJetMSA(229, "B9", "", 262, "Beeps");
        VecVoxSamples.allSamples[s++] = new SpeakJetMSA(230, "C0", "", 160, "Biological");
        VecVoxSamples.allSamples[s++] = new SpeakJetMSA(231, "C1", "", 300, "Biological");
        VecVoxSamples.allSamples[s++] = new SpeakJetMSA(232, "C2", "", 182, "Biological");
        VecVoxSamples.allSamples[s++] = new SpeakJetMSA(233, "C3", "", 120, "Biological");
        VecVoxSamples.allSamples[s++] = new SpeakJetMSA(234, "C4", "", 175, "Biological");
        VecVoxSamples.allSamples[s++] = new SpeakJetMSA(235, "C5", "", 350, "Biological");
        VecVoxSamples.allSamples[s++] = new SpeakJetMSA(236, "C6", "", 160, "Biological");
        VecVoxSamples.allSamples[s++] = new SpeakJetMSA(237, "C7", "", 260, "Biological");
        VecVoxSamples.allSamples[s++] = new SpeakJetMSA(238, "C8", "", 95, "Biological");
        VecVoxSamples.allSamples[s++] = new SpeakJetMSA(239, "C9", "", 75, "Biological");
        VecVoxSamples.allSamples[s++] = new SpeakJetMSA(240, "D0", "0", 95, "DTMF");
        VecVoxSamples.allSamples[s++] = new SpeakJetMSA(241, "D1", "1", 95, "DTMF");
        VecVoxSamples.allSamples[s++] = new SpeakJetMSA(242, "D2", "2", 95, "DTMF");
        VecVoxSamples.allSamples[s++] = new SpeakJetMSA(243, "D3", "3", 95, "DTMF");
        VecVoxSamples.allSamples[s++] = new SpeakJetMSA(244, "D4", "4", 95, "DTMF");
        VecVoxSamples.allSamples[s++] = new SpeakJetMSA(245, "D5", "5", 95, "DTMF");
        VecVoxSamples.allSamples[s++] = new SpeakJetMSA(246, "D6", "6", 95, "DTMF");
        VecVoxSamples.allSamples[s++] = new SpeakJetMSA(247, "D7", "7", 95, "DTMF");
        VecVoxSamples.allSamples[s++] = new SpeakJetMSA(248, "D8", "8", 95, "DTMF");
        VecVoxSamples.allSamples[s++] = new SpeakJetMSA(249, "D9", "9", 95, "DTMF");
        VecVoxSamples.allSamples[s++] = new SpeakJetMSA(250, "D10", "*", 95, "DTMF");
        VecVoxSamples.allSamples[s++] = new SpeakJetMSA(251, "D11", "#", 95, "DTMF");
        VecVoxSamples.allSamples[s++] = new SpeakJetMSA(252, "M0", "Sonar Ping", 125, "Miscellaneous");
        VecVoxSamples.allSamples[s++] = new SpeakJetMSA(253, "M1", "Pistol Shot", 250, "Miscellaneous");
        VecVoxSamples.allSamples[s++] = new SpeakJetMSA(254, "M2", "WOW", 530, "Miscellaneous");
        VecVoxSamples.pauseSamples[1] = new SpeakJetMSA(1, "PA1", "Pause1", 100, "Pause");
        VecVoxSamples.pauseSamples[2] = new SpeakJetMSA(2, "PA2", "Pause2", 200, "Pause");
        VecVoxSamples.pauseSamples[3] = new SpeakJetMSA(3, "PA3", "Pause3", 700, "Pause");
        VecVoxSamples.pauseSamples[4] = new SpeakJetMSA(4, "PA4", "Pause4", 30, "Pause");
        VecVoxSamples.pauseSamples[5] = new SpeakJetMSA(5, "PA5", "Pause5", 60, "Pause");
        VecVoxSamples.pauseSamples[6] = new SpeakJetMSA(6, "PA6", "Pause6", 90, "Pause");
        ((LogPanel)Configuration.getConfiguration().getDebugEntity()).addLog("VecVox: samples loaded.", LogPanel.INFO);
        init = true;
        return true;
    }

    public static String getMnemonic(int code2) {
        if (code2 >= 128) {
            for (SpeakJetMSA s : allSamples) {
                if (s.code != code2) continue;
                return s.phoneme;
            }
        }
        if (code2 == -1) {
            return "EOP";
        }
        if (code2 < 7) {
            return "PAUSE" + code2;
        }
        if (code2 == 255) {
            return "EOP";
        }
        if (code2 == 7) {
            return "FAST";
        }
        if (code2 == 8) {
            return "SLOW";
        }
        if (code2 == 14) {
            return "STRESS";
        }
        if (code2 == 15) {
            return "RELAX";
        }
        if (code2 == 16) {
            return "WAIT";
        }
        if (code2 == 20) {
            return "VOLUME";
        }
        if (code2 == 21) {
            return "SPEED";
        }
        if (code2 == 22) {
            return "PITCH";
        }
        if (code2 == 23) {
            return "BEND";
        }
        if (code2 == 26) {
            return "RPT";
        }
        if (code2 == 30) {
            return "DELAY";
        }
        if (code2 == 31) {
            return "RESET";
        }
        return "" + code2;
    }

    public static MemSound getPauseSample(int pause) {
        return VecVoxSamples.getSample(pause);
    }

    public static MemSound getSample(int code2) {
        if (playList == null) {
            ((LogPanel)Configuration.getConfiguration().getDebugEntity()).addLog("VecVox: samples not initialized", LogPanel.INFO);
            return null;
        }
        MemSound sample = playList.get(code2);
        if (sample == null) {
            ((LogPanel)Configuration.getConfiguration().getDebugEntity()).addLog("VecVox: sample for code: " + code2 + " not found", LogPanel.INFO);
            return null;
        }
        return sample;
    }

    public static MemSound playSample(int code2) {
        MemSound sample = VecVoxSamples.getSample(code2);
        if (sample == null) {
            return null;
        }
        sample.play();
        ((LogPanel)Configuration.getConfiguration().getDebugEntity()).addLog("VecVox: playing sample for code: " + code2, LogPanel.INFO);
        return sample;
    }

    static {
        init = false;
        notes = new HashMap();
        notesList = new ArrayList();
        codeMap = new HashMap();
        allSamples = new SpeakJetMSA[127];
        allSpecials = new ArrayList();
        pauseSamples = new SpeakJetMSA[7];
        playList = new HashMap();
        notes.put("C0", 16);
        notes.put("C#0", 17);
        notes.put("D0", 18);
        notes.put("D#0", 19);
        notes.put("E0", 21);
        notes.put("F0", 22);
        notes.put("F#0", 23);
        notes.put("G0", 24);
        notes.put("G#0", 26);
        notes.put("A0", 28);
        notes.put("A#0", 29);
        notes.put("B0", 31);
        notes.put("C1", 33);
        notes.put("C#1", 35);
        notes.put("D1", 37);
        notes.put("D#1", 39);
        notes.put("E1", 41);
        notes.put("F1", 44);
        notes.put("F#1", 46);
        notes.put("G1", 49);
        notes.put("G#1", 52);
        notes.put("A1", 55);
        notes.put("A#1", 58);
        notes.put("B1", 62);
        notes.put("C2", 65);
        notes.put("C#2", 69);
        notes.put("D2", 73);
        notes.put("D#2", 78);
        notes.put("E2", 82);
        notes.put("F2", 87);
        notes.put("F#2", 93);
        notes.put("G2", 98);
        notes.put("G#2", 104);
        notes.put("A2", 110);
        notes.put("A#2", 117);
        notes.put("B2", 123);
        notes.put("C3", 131);
        notes.put("C#3", 139);
        notes.put("D3", 147);
        notes.put("D#3", 156);
        notes.put("E3", 165);
        notes.put("F3", 175);
        notes.put("F#3", 185);
        notes.put("G3", 196);
        notes.put("G#3", 208);
        notes.put("A3", 220);
        notes.put("A#3", 233);
        notes.put("B3", 247);
        notesList.add(new SpeakSpecials("\\NTC0", "22, 16"));
        notesList.add(new SpeakSpecials("\\NTC#0", "22, 17"));
        notesList.add(new SpeakSpecials("\\NTD0", "22, 18"));
        notesList.add(new SpeakSpecials("\\NTD#0", "22, 19"));
        notesList.add(new SpeakSpecials("\\NTE0", "22, 21"));
        notesList.add(new SpeakSpecials("\\NTF0", "22, 22"));
        notesList.add(new SpeakSpecials("\\NTF#0", "22, 23"));
        notesList.add(new SpeakSpecials("\\NTG0", "22, 24"));
        notesList.add(new SpeakSpecials("\\NTG#0", "22, 26"));
        notesList.add(new SpeakSpecials("\\NTA0", "22, 28"));
        notesList.add(new SpeakSpecials("\\NTA#0", "22, 29"));
        notesList.add(new SpeakSpecials("\\NTB0", "22, 31"));
        notesList.add(new SpeakSpecials("\\NTC1", "22, 33"));
        notesList.add(new SpeakSpecials("\\NTC#1", "22, 35"));
        notesList.add(new SpeakSpecials("\\NTD1", "22, 37"));
        notesList.add(new SpeakSpecials("\\NTD#1", "22, 39"));
        notesList.add(new SpeakSpecials("\\NTE1", "22, 41"));
        notesList.add(new SpeakSpecials("\\NTF1", "22, 44"));
        notesList.add(new SpeakSpecials("\\NTF#1", "22, 46"));
        notesList.add(new SpeakSpecials("\\NTG1", "22, 49"));
        notesList.add(new SpeakSpecials("\\NTG#1", "22, 52"));
        notesList.add(new SpeakSpecials("\\NTA1", "22, 55"));
        notesList.add(new SpeakSpecials("\\NTA#1", "22, 58"));
        notesList.add(new SpeakSpecials("\\NTB1", "22, 62"));
        notesList.add(new SpeakSpecials("\\NTC2", "22, 65"));
        notesList.add(new SpeakSpecials("\\NTC#2", "22, 69"));
        notesList.add(new SpeakSpecials("\\NTD2", "22, 73"));
        notesList.add(new SpeakSpecials("\\NTD#2", "22, 78"));
        notesList.add(new SpeakSpecials("\\NTE2", "22, 82"));
        notesList.add(new SpeakSpecials("\\NTF2", "22, 87"));
        notesList.add(new SpeakSpecials("\\NTF#2", "22, 93"));
        notesList.add(new SpeakSpecials("\\NTG2", "22, 98"));
        notesList.add(new SpeakSpecials("\\NTG#2", "22, 104"));
        notesList.add(new SpeakSpecials("\\NTA2", "22, 110"));
        notesList.add(new SpeakSpecials("\\NTA#2", "22, 117"));
        notesList.add(new SpeakSpecials("\\NTB2", "22, 123"));
        notesList.add(new SpeakSpecials("\\NTC3", "22, 131"));
        notesList.add(new SpeakSpecials("\\NTC#3", "22, 139"));
        notesList.add(new SpeakSpecials("\\NTD3", "22, 147"));
        notesList.add(new SpeakSpecials("\\NTD#3", "22, 156"));
        notesList.add(new SpeakSpecials("\\NTE3", "22, 165"));
        notesList.add(new SpeakSpecials("\\NTF3", "22, 175"));
        notesList.add(new SpeakSpecials("\\NTF#3", "22, 185"));
        notesList.add(new SpeakSpecials("\\NTG3", "22, 196"));
        notesList.add(new SpeakSpecials("\\NTG#3", "22, 208"));
        notesList.add(new SpeakSpecials("\\NTA3", "22, 220"));
        notesList.add(new SpeakSpecials("\\NTA#3", "22, 233"));
        notesList.add(new SpeakSpecials("\\NTB3", "22, 247"));
        VecVoxSamples.loadSamples();
    }

    public static class SpeakJetMSA {
        public int code = -1;
        public String phoneme = "";
        public String sampleWords = "";
        public boolean stoppedSound = false;
        int timing = -1;
        String type = "";
        MemSound sample = null;
        String filename = "";

        SpeakJetMSA(int c, String p, String sw, int t, String ty) {
            this.code = c;
            this.phoneme = p;
            codeMap.put(this.phoneme, "" + c);
            this.stoppedSound = ty.toUpperCase().contains("STOP");
            this.sampleWords = sw;
            this.timing = t;
            this.type = ty;
            this.filename = this.phoneme;
            String loadname = Global.mainPathPrefix + "samples" + File.separator + "SpeakJet" + File.separator + this.filename + ".wav";
            this.sample = (MemSound)TinySound.loadSound(new File(loadname), false);
            if (this.sample != null) {
                playList.put(this.code, this.sample);
            }
        }
    }

    public static class SpeakSpecials {
        public String mnemonic;
        public String codes;

        SpeakSpecials(String m, String c) {
            this.mnemonic = m;
            this.codes = c;
            codeMap.put(this.mnemonic.substring(1), this.codes);
        }
    }
}

