/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.vecx.devices;

import de.malban.vide.vecx.Breakpoint;
import de.malban.vide.vecx.VecX;
import de.malban.vide.vecx.devices.JoyportDevice;
import java.io.Serializable;
import java.util.ArrayList;

public class VectrexJoyport
implements Serializable {
    int port = 0;
    private boolean[] outputFromVectrexButton = new boolean[4];
    private boolean[] outputFromDeviceButton = new boolean[4];
    private int horizontal = 127;
    private int vertical = 127;
    boolean inputMode = false;
    boolean outputMode = !this.inputMode;
    VecX vecx = null;
    volatile JoyportDevice device = null;

    public VectrexJoyport(int p, VecX v) {
        this.port = p;
        this.vecx = v;
        this.reset();
    }

    public void deinit() {
        if (this.device != null) {
            this.device.deinit();
        }
        this.device = null;
    }

    public JoyportDevice getDevice() {
        return this.device;
    }

    public void reset() {
        this.outputFromVectrexButton[0] = true;
        this.outputFromVectrexButton[1] = true;
        this.outputFromVectrexButton[2] = true;
        this.outputFromVectrexButton[3] = true;
        this.outputFromDeviceButton[0] = true;
        this.outputFromDeviceButton[1] = true;
        this.outputFromDeviceButton[2] = true;
        this.outputFromDeviceButton[3] = true;
        this.horizontal = 127;
        this.vertical = 127;
    }

    public void plugIn(JoyportDevice d) {
        this.reset();
        if (this.device != null) {
            this.device.deinit();
        }
        this.device = null;
        if (d == null) {
            if (this.vecx != null && this.vecx.getDisplayer() != null) {
                this.vecx.getDisplayer().setJoyportDevice(this.port, null);
            }
            return;
        }
        d.deinit();
        d.setJoyport(this);
        this.device = d;
        this.setInputMode(this.inputMode);
    }

    public void step() {
        if (this.device == null) {
            return;
        }
        this.device.step();
        if (this.device != null) {
            this.device.updateInputDataFromDevice();
        }
        if (this.port == 1) {
            this.vecx.via_ca1 = this.outputFromDeviceButton[3] ? 1 : 0;
        }
        if (this.port == 0) {
            this.vecx.setFIRQ(!this.outputFromDeviceButton[3]);
        }
        if (this.vecx.config.breakpointsActive) {
            this.checkPortBreakpoint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkPortBreakpoint() {
        ArrayList<Breakpoint> arrayList = this.vecx.breakpoints[Breakpoint.BP_TARGET_PORT];
        synchronized (arrayList) {
            for (Breakpoint bp : this.vecx.breakpoints[Breakpoint.BP_TARGET_PORT]) {
                boolean compareTo;
                if ((bp.type & Breakpoint.BP_BITCOMPARE) != Breakpoint.BP_BITCOMPARE || (bp.type & Breakpoint.BP_MULTI) != Breakpoint.BP_MULTI) continue;
                int bit = bp.getTargetAddress();
                boolean bl = compareTo = bp.getCompareValue() == 1;
                if (this.port == 1) {
                    bit -= 4;
                }
                if (bit < 0 || bit > 3) continue;
                boolean valueBit = false;
                if ((bp.targetSubType & Breakpoint.BP_SUBTARGET_PORT_IN) == Breakpoint.BP_SUBTARGET_PORT_IN) {
                    valueBit = this.outputFromDeviceButton[bit];
                } else if ((bp.targetSubType & Breakpoint.BP_SUBTARGET_PORT_OUT) == Breakpoint.BP_SUBTARGET_PORT_OUT) {
                    valueBit = this.outputFromVectrexButton[bit];
                }
                if (valueBit != compareTo) continue;
                this.vecx.activeBreakpoint.add(bp);
                if (this.vecx.breakpointExit >= bp.exitType) continue;
                this.vecx.breakpointExit = bp.exitType;
            }
        }
    }

    public void setInputMode(boolean b) {
        this.inputMode = b;
        boolean bl = this.outputMode = !this.inputMode;
        if (this.device != null) {
            this.device.setInputMode(b);
        }
    }

    public boolean isInpuMode() {
        return this.inputMode;
    }

    public boolean isButtonInRO(int no) {
        return this.outputFromDeviceButton[no];
    }

    public boolean isButtonOutRO(int no) {
        return this.outputFromVectrexButton[no];
    }

    private boolean isButton(int no, boolean fromDevice) {
        boolean fromVectrex;
        boolean bl = fromVectrex = !fromDevice;
        if (this.device != null) {
            this.device.updateInputDataFromDevice();
        }
        if (fromDevice && this.inputMode) {
            return true;
        }
        if (fromVectrex && this.outputMode) {
            if (this.port == 0) {
                return true;
            }
            return this.outputFromDeviceButton[no];
        }
        if (fromDevice && this.outputMode) {
            return this.outputFromVectrexButton[no];
        }
        if (fromVectrex && this.inputMode) {
            return this.outputFromDeviceButton[no];
        }
        System.out.println("isButton is fucked");
        return true;
    }

    private void setButton(int no, boolean button, boolean fromDevice) {
        boolean fromVectrex;
        boolean bl = fromVectrex = !fromDevice;
        if (fromDevice) {
            this.outputFromDeviceButton[no] = button;
        }
        if (fromVectrex) {
            this.outputFromVectrexButton[no] = button;
        }
    }

    public boolean isButton1(boolean fromDevice) {
        return this.isButton(0, fromDevice);
    }

    public void setButton1(boolean button1, boolean fromDevice) {
        this.setButton(0, button1, fromDevice);
    }

    public boolean isButton2(boolean fromDevice) {
        return this.isButton(1, fromDevice);
    }

    public void setButton2(boolean button2, boolean fromDevice) {
        this.setButton(1, button2, fromDevice);
    }

    public boolean isButton3(boolean fromDevice) {
        return this.isButton(2, fromDevice);
    }

    public void setButton3(boolean button3, boolean fromDevice) {
        this.setButton(2, button3, fromDevice);
    }

    public boolean isButton4(boolean fromDevice) {
        return this.isButton(3, fromDevice);
    }

    public void setButton4(boolean button4, boolean fromDevice) {
        this.setButton(3, button4, fromDevice);
    }

    public int getHorizontal() {
        if (this.device != null) {
            this.device.updateInputDataFromDevice();
        }
        return this.horizontal;
    }

    public void setHorizontal(int horizontal, boolean fromDevice) {
        this.horizontal = horizontal;
    }

    public int getVertical() {
        if (this.device != null) {
            this.device.updateInputDataFromDevice();
        }
        return this.vertical;
    }

    public void setVertical(int vertical, boolean fromDevice) {
        this.vertical = vertical;
    }
}

