/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.vecx.devices;

import de.malban.Global;
import de.malban.config.Configuration;
import de.malban.gui.panels.LogPanel;
import de.malban.util.UtilityFiles;
import de.malban.util.UtilityString;
import de.malban.util.XMLSupport;
import java.awt.Color;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;

public class WheelData
implements Serializable {
    transient LogPanel log = (LogPanel)Configuration.getConfiguration().getDebugEntity();
    public String name = "Narrow Escape";
    public int id = 1;
    public double indexAngle;
    public double[] startAngle = new double[4];
    public Color[] colors = new Color[4];
    public double defaultFrequency;

    private WheelData() {
        this.startAngle[0] = 0.0;
        this.colors[0] = new Color(0, 0, 0, 255);
        this.startAngle[1] = 180.0;
        this.colors[1] = new Color(0, 0, 255, 100);
        this.startAngle[2] = 240.0;
        this.colors[2] = new Color(0, 255, 0, 100);
        this.startAngle[3] = 304.0;
        this.colors[3] = new Color(255, 0, 0, 100);
        this.defaultFrequency = 26.1579;
        this.indexAngle = 254.0;
    }

    public void addSection(Color newColor) {
        double[] nstartAngle = new double[this.startAngle.length + 1];
        Color[] ncolors = new Color[this.colors.length + 1];
        for (int i = 0; i < this.colors.length; ++i) {
            nstartAngle[i] = this.startAngle[i];
            ncolors[i] = this.colors[i];
        }
        nstartAngle[this.startAngle.length] = 360.0;
        ncolors[this.startAngle.length] = newColor;
        this.startAngle = nstartAngle;
        this.colors = ncolors;
    }

    public void removeSection(int s) {
        if (s < 1) {
            return;
        }
        if (s >= this.startAngle.length) {
            return;
        }
        double[] nstartAngle = new double[this.startAngle.length - 1];
        Color[] ncolors = new Color[this.colors.length - 1];
        int target = 0;
        for (int i = 0; i < this.colors.length; ++i) {
            if (i == s) continue;
            nstartAngle[target] = this.startAngle[i];
            ncolors[target] = this.colors[i];
            ++target;
        }
        this.startAngle = nstartAngle;
        this.colors = ncolors;
    }

    public static WheelData createNewWheel() {
        WheelData wd = new WheelData();
        return wd;
    }

    public boolean toXML(StringBuilder s, String tag) {
        s.append("<").append(tag).append(">\n");
        boolean ok = true;
        ok &= XMLSupport.addElement(s, "name", this.name);
        ok &= XMLSupport.addElement(s, "id", this.id);
        ok &= XMLSupport.addElement(s, "indexAngle", this.indexAngle);
        ok &= XMLSupport.addElement(s, "defaultFrequency", this.defaultFrequency);
        for (int i = 0; i < this.colors.length; ++i) {
            s.append("<").append("colorsection").append(">\n");
            ok &= XMLSupport.addElement(s, "wheelplacing", i);
            ok &= XMLSupport.addElement(s, "startAngle", this.startAngle[i]);
            ok &= XMLSupport.addElement(s, "red", this.colors[i].getRed());
            ok &= XMLSupport.addElement(s, "green", this.colors[i].getGreen());
            ok &= XMLSupport.addElement(s, "blue", this.colors[i].getBlue());
            s.append("</").append("colorsection").append(">\n");
        }
        s.append("</").append(tag).append(">\n");
        return ok;
    }

    public boolean fromXML(StringBuilder xml, XMLSupport xmlSupport) {
        int errorCode = 0;
        this.name = xmlSupport.getStringElement("name", xml);
        errorCode |= xmlSupport.errorCode;
        this.id = xmlSupport.getIntElement("id", xml);
        errorCode |= xmlSupport.errorCode;
        this.defaultFrequency = xmlSupport.getDoubleElement("defaultFrequency", xml);
        errorCode |= xmlSupport.errorCode;
        this.indexAngle = xmlSupport.getDoubleElement("indexAngle", xml);
        errorCode |= xmlSupport.errorCode;
        ArrayList<Color> col = new ArrayList<Color>();
        ArrayList<Double> ang = new ArrayList<Double>();
        ArrayList<Integer> ord = new ArrayList<Integer>();
        StringBuilder oneElement = null;
        while ((oneElement = xmlSupport.removeTag("colorsection", xml)) != null) {
            errorCode |= xmlSupport.errorCode;
            double a = xmlSupport.getDoubleElement("startAngle", oneElement);
            errorCode |= xmlSupport.errorCode;
            int o = xmlSupport.getIntElement("wheelplacing", oneElement);
            errorCode |= xmlSupport.errorCode;
            int r = xmlSupport.getIntElement("red", oneElement);
            errorCode |= xmlSupport.errorCode;
            int g = xmlSupport.getIntElement("green", oneElement);
            errorCode |= xmlSupport.errorCode;
            int b = xmlSupport.getIntElement("blue", oneElement);
            errorCode |= xmlSupport.errorCode;
            col.add(new Color(r, g, b));
            ang.add(a);
            ord.add(o);
        }
        if (errorCode != 0) {
            return false;
        }
        this.startAngle = new double[ang.size()];
        this.colors = new Color[ang.size()];
        int count = 0;
        block1: while (ang.size() > 0) {
            for (int i = 0; i < ang.size(); ++i) {
                if ((Integer)ord.get(i) != count) continue;
                this.startAngle[count] = (Double)ang.get(i);
                this.colors[count] = (Color)col.get(i);
                ++count;
                ang.remove(i);
                col.remove(i);
                ord.remove(i);
                continue block1;
            }
        }
        return true;
    }

    public boolean saveAsXML(String filename) {
        StringBuilder xml = new StringBuilder();
        boolean ok = this.toXML(xml, "WheelData");
        if (!ok) {
            this.log.addLog("WheelData save 'toXML' return false", LogPanel.WARN);
            return false;
        }
        ok = UtilityFiles.createTextFile(filename, xml.toString());
        if (!ok) {
            this.log.addLog("WheelData create file '" + filename + "' return false", LogPanel.WARN);
            return false;
        }
        return true;
    }

    public static WheelData loadWheel(String filename) {
        WheelData w = new WheelData();
        if (w.loadFromXML(filename)) {
            return w;
        }
        return null;
    }

    public boolean loadFromXML(String filename) {
        String xml = UtilityString.readTextFileToOneString(new File(filename));
        boolean ok = this.fromXML(new StringBuilder(xml), new XMLSupport());
        if (!ok) {
            this.log.addLog("WheelData load from xml '" + filename + "' return false", LogPanel.WARN);
            return false;
        }
        return true;
    }

    public static WheelData getWheel(String name) {
        WheelData wheel = WheelData.loadWheel(Global.mainPathPrefix + "xml" + File.separator + "wheels" + File.separator + name + ".xml");
        if (wheel == null) {
            wheel = new WheelData();
        }
        return wheel;
    }
}

