/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.vecx.libayemu;

import de.malban.vide.VideConfig;
import de.malban.vide.vecx.libayemu.RegData;
import de.malban.vide.vecx.libayemu.SndFmt;

public class AY {
    VideConfig config = VideConfig.getConfig();
    public static int MSX = 0x1B11B0;
    public static int ZX = 1773400;
    public static int CPC = 1000000;
    public static int VECTREX = 1500000;
    public static int NONE = 0;
    public static int TONE_A = 1;
    public static int TONE_B = 2;
    public static int TONE_C = 4;
    public static int NOISE_A = 8;
    public static int NOISE_B = 16;
    public static int NOISE_C = 32;
    private static double[] table = new double[32];
    private static Chip type = Chip.AY;
    private int ChipFreq = VECTREX;
    private double[] eq = new double[6];
    RegData regs = new RegData();
    SndFmt sndfmt = new SndFmt();
    private static boolean defaultChip;
    private boolean defaultStereo;
    private boolean defaultSoundFormat;
    private static boolean dirty;
    private int bit_a;
    private int bit_b;
    private int bit_c;
    private int bit_n;
    private int noiseSeed;
    private double cnt_a;
    private double cnt_b;
    private double cnt_c;
    private double cnt_n;
    private double cnt_e;
    private double[][] vols = this.vols = new double[6][32];
    private double env_pos;
    private double remainderMixL;
    private double remainderMixR;
    private final int MAX_AMP = Integer.MAX_VALUE;
    private boolean envGenInit = false;
    private int[][] envelope = new int[16][128];
    private final int INTERPOLATION_length = 3;
    public static double[] LION17_AY_TABLE;
    public static double[] LION17_YM_TABLE;
    public static double[] KAY_AY_TABLE;
    public static double[] KAY_YM_TABLE;
    public static double[][][] DEFAULT_LAYOUT;

    public AY() {
        this.genEnv();
        this.Init();
    }

    public RegData getRegs() {
        return this.regs;
    }

    public void Init() {
        this.ChipFreq = VECTREX;
        defaultChip = true;
        this.defaultStereo = false;
        this.defaultSoundFormat = true;
        dirty = true;
        this.SetStereo(Stereo.Mono, null);
        this.Reset();
        VideConfig config = VideConfig.getConfig();
        if (config.useLibAYEmuTable.equals("AY_Kay")) {
            AY.SetChipType(Chip.AY_Kay, null);
        } else if (config.useLibAYEmuTable.equals("YM_Kay")) {
            AY.SetChipType(Chip.YM_Kay, null);
        } else if (config.useLibAYEmuTable.equals("AY_Lion17")) {
            AY.SetChipType(Chip.AY_Lion17, null);
        } else if (config.useLibAYEmuTable.equals("YM_Lion17")) {
            AY.SetChipType(Chip.YM_Lion17, null);
        }
    }

    public void Reset() {
        this.cnt_e = 0.0;
        this.cnt_n = 0.0;
        this.cnt_c = 0.0;
        this.cnt_b = 0.0;
        this.cnt_a = 0.0;
        this.bit_n = 0;
        this.bit_c = 0;
        this.bit_b = 0;
        this.bit_a = 0;
        this.env_pos = 0.0;
        this.noiseSeed = 65535;
        this.remainderMixL = 0.0;
        this.remainderMixR = 0.0;
    }

    public static boolean SetChipType(Chip chipType, double[] customTable) {
        if (chipType != Chip.AY_Custom && chipType != Chip.YM_Custom && customTable != null) {
            return false;
        }
        switch (chipType) {
            case AY: 
            case AY_Lion17: {
                AY.SetTableAY(LION17_AY_TABLE);
                break;
            }
            case YM: 
            case YM_Lion17: {
                AY.SetTableYM(LION17_YM_TABLE);
                break;
            }
            case AY_Kay: {
                AY.SetTableAY(KAY_AY_TABLE);
                break;
            }
            case YM_Kay: {
                AY.SetTableYM(KAY_YM_TABLE);
                break;
            }
            case AY_Custom: {
                AY.SetTableAY(customTable);
                break;
            }
            case YM_Custom: {
                AY.SetTableYM(customTable);
                break;
            }
            default: {
                return false;
            }
        }
        type = chipType;
        defaultChip = false;
        dirty = true;
        return true;
    }

    public void SetChipFreq(int chipFreq) {
        this.ChipFreq = chipFreq;
        dirty = true;
    }

    public boolean SetStereo(Stereo stereoType, int[] customEQ) {
        if (stereoType != Stereo.StereoCustom && customEQ != null) {
            return false;
        }
        int chip = type == Chip.AY ? 0 : 1;
        switch (stereoType) {
            case Mono: 
            case ABC: 
            case ACB: 
            case BAC: 
            case BCA: 
            case CAB: 
            case CBA: {
                for (int i = 0; i < 6; ++i) {
                    this.eq[i] = DEFAULT_LAYOUT[chip][stereoType.ordinal()][i];
                }
                break;
            }
            case StereoCustom: {
                for (int i = 0; i < 6; ++i) {
                    this.eq[i] = customEQ[i];
                }
                break;
            }
            default: {
                return false;
            }
        }
        this.defaultStereo = false;
        dirty = true;
        return true;
    }

    public void SetSoundFormat(SndFmt fmt) {
        this.sndfmt.setChannels(fmt.getChannels());
        this.sndfmt.setFreq(fmt.getFreq());
        this.defaultSoundFormat = false;
    }

    public void SetSoundFormat(int freq, int chans) {
        SndFmt tmp = new SndFmt();
        tmp.setChannels(chans);
        tmp.setFreq(freq);
        this.SetSoundFormat(tmp);
    }

    public void SetRegs(int[] regs) {
        this.WarnIfRegisterGreaterThan(regs[1], 15, 1);
        this.WarnIfRegisterGreaterThan(regs[3], 15, 3);
        this.WarnIfRegisterGreaterThan(regs[5], 15, 3);
        this.WarnIfRegisterGreaterThan(regs[8], 31, 8);
        this.WarnIfRegisterGreaterThan(regs[9], 31, 9);
        this.WarnIfRegisterGreaterThan(regs[10], 31, 10);
        this.regs.setTone_a(regs[0] + ((regs[1] & 0xF) << 8));
        this.regs.setTone_b(regs[2] + ((regs[3] & 0xF) << 8));
        this.regs.setTone_c(regs[4] + ((regs[5] & 0xF) << 8));
        this.regs.setNoise(regs[6] & 0x1F);
        this.regs.setR7_tone_a((regs[7] & 1) == 0 ? 1 : 0);
        this.regs.setR7_tone_b((regs[7] & 2) == 0 ? 1 : 0);
        this.regs.setR7_tone_c((regs[7] & 4) == 0 ? 1 : 0);
        this.regs.setR7_noise_a((regs[7] & 8) == 0 ? 1 : 0);
        this.regs.setR7_noise_b((regs[7] & 0x10) == 0 ? 1 : 0);
        this.regs.setR7_noise_c((regs[7] & 0x20) == 0 ? 1 : 0);
        this.regs.setVol_a(regs[8] & 0xF);
        this.regs.setVol_b(regs[9] & 0xF);
        this.regs.setVol_c(regs[10] & 0xF);
        this.regs.setEnv_a(regs[8] & 0x10);
        this.regs.setEnv_b(regs[9] & 0x10);
        this.regs.setEnv_c(regs[10] & 0x10);
        this.regs.setEnv_freq(regs[11] + (regs[12] << 8));
        if (regs[13] != 255) {
            this.regs.setEnv_style(regs[13] & 0xF);
            this.cnt_e = 0.0;
            this.env_pos = 0.0;
        }
    }

    private void WarnIfRegisterGreaterThan(int regValue, int maxValue, int regOrder) {
        if (regValue > maxValue) {
            System.out.println("SetRegs: warning: possible bad register data R" + regOrder + " > " + maxValue);
        }
    }

    public int GenSound(double[] buffer, int bufSize, int bufPos) {
        this.prepareGeneration();
        int curPos = bufPos;
        double remaining = 0.0;
        double[] tmpBuf = new double[bufSize];
        double ticksPerSample = (double)this.ChipFreq / (double)this.sndfmt.getFreq() / 8.0;
        int snd_numcount = bufSize / this.sndfmt.getChannels();
        double samplesUsed = 0.0;
        while (snd_numcount-- > 0) {
            samplesUsed = -remaining;
            remaining += ticksPerSample;
            double mixL = this.remainderMixL;
            double mixR = this.remainderMixR;
            double tempMixR = 0.0;
            double tempMixL = 0.0;
            while (remaining > 0.0) {
                int volIdx;
                this.updateCounters();
                remaining -= 1.0;
                samplesUsed += 1.0;
                double rC = 0.0;
                double rB = 0.0;
                double rA = 0.0;
                double lC = 0.0;
                double lB = 0.0;
                double lA = 0.0;
                if (((this.bit_a | (this.regs.getR7_tone_a() == 0 ? 1 : 0)) & (this.bit_n | (this.regs.getR7_noise_a() == 0 ? 1 : 0))) != 0) {
                    volIdx = this.regs.getEnv_a() != 0 ? this.envelope[this.regs.getEnv_style()][(int)this.env_pos] : this.regs.getVol_a() * 2 + 1;
                    lA = this.vols[0][volIdx];
                    rA = this.vols[1][volIdx];
                }
                if (((this.bit_b | (this.regs.getR7_tone_b() == 0 ? 1 : 0)) & (this.bit_n | (this.regs.getR7_noise_b() == 0 ? 1 : 0))) != 0) {
                    volIdx = this.regs.getEnv_b() != 0 ? this.envelope[this.regs.getEnv_style()][(int)this.env_pos] : this.regs.getVol_b() * 2 + 1;
                    lB = this.vols[2][volIdx];
                    rB = this.vols[3][volIdx];
                }
                if (((this.bit_c | (this.regs.getR7_tone_c() == 0 ? 1 : 0)) & (this.bit_n | (this.regs.getR7_noise_c() == 0 ? 1 : 0))) != 0) {
                    volIdx = this.regs.getEnv_c() != 0 ? this.envelope[this.regs.getEnv_style()][(int)this.env_pos] : this.regs.getVol_c() * 2 + 1;
                    lC = this.vols[4][volIdx];
                    rC = this.vols[5][volIdx];
                }
                tempMixL = (lA + lB + lC) / 3.0;
                tempMixR = (rA + rB + rC) / 3.0;
                if (remaining <= 0.0) {
                    this.remainderMixL = -remaining * tempMixL;
                    this.remainderMixR = -remaining * tempMixR;
                    tempMixL = (1.0 + remaining) * tempMixL;
                    tempMixR = (1.0 + remaining) * tempMixR;
                    samplesUsed += remaining;
                }
                mixL += tempMixL;
                mixR += tempMixR;
            }
            mixR /= samplesUsed;
            buffer[curPos++] = mixL /= samplesUsed;
            if (this.sndfmt.getChannels() == 1) continue;
            buffer[curPos++] = mixR;
        }
        return curPos;
    }

    public int GenSound(byte[] buffer, int bufSize, int bufPos) {
        this.prepareGeneration();
        int curPos = bufPos;
        double remaining = 0.0;
        double[] tmpBuf = new double[bufSize];
        double ticksPerSample = (double)this.ChipFreq / (double)this.sndfmt.getFreq() / 8.0;
        int snd_numcount = bufSize / this.sndfmt.getChannels();
        double samplesUsed = 0.0;
        while (snd_numcount-- > 0) {
            int oneSample16Bit;
            samplesUsed = -remaining;
            remaining += ticksPerSample;
            double mixL = this.remainderMixL;
            double mixR = this.remainderMixR;
            double tempMixR = 0.0;
            double tempMixL = 0.0;
            while (remaining > 0.0) {
                int volIdx;
                this.updateCounters();
                remaining -= 1.0;
                samplesUsed += 1.0;
                double rC = 0.0;
                double rB = 0.0;
                double rA = 0.0;
                double lC = 0.0;
                double lB = 0.0;
                double lA = 0.0;
                if (((this.bit_a | (this.regs.getR7_tone_a() == 0 ? 1 : 0)) & (this.bit_n | (this.regs.getR7_noise_a() == 0 ? 1 : 0))) != 0) {
                    volIdx = this.regs.getEnv_a() != 0 ? this.envelope[this.regs.getEnv_style()][(int)this.env_pos] : this.regs.getVol_a() * 2 + 1;
                    lA = this.vols[0][volIdx];
                    rA = this.vols[1][volIdx];
                }
                if (((this.bit_b | (this.regs.getR7_tone_b() == 0 ? 1 : 0)) & (this.bit_n | (this.regs.getR7_noise_b() == 0 ? 1 : 0))) != 0) {
                    volIdx = this.regs.getEnv_b() != 0 ? this.envelope[this.regs.getEnv_style()][(int)this.env_pos] : this.regs.getVol_b() * 2 + 1;
                    lB = this.vols[2][volIdx];
                    rB = this.vols[3][volIdx];
                }
                if (((this.bit_c | (this.regs.getR7_tone_c() == 0 ? 1 : 0)) & (this.bit_n | (this.regs.getR7_noise_c() == 0 ? 1 : 0))) != 0) {
                    volIdx = this.regs.getEnv_c() != 0 ? this.envelope[this.regs.getEnv_style()][(int)this.env_pos] : this.regs.getVol_c() * 2 + 1;
                    lC = this.vols[4][volIdx];
                    rC = this.vols[5][volIdx];
                }
                tempMixL = (lA + lB + lC) / 3.0;
                tempMixR = (rA + rB + rC) / 3.0;
                if (remaining <= 0.0) {
                    this.remainderMixL = -remaining * tempMixL;
                    this.remainderMixR = -remaining * tempMixR;
                    tempMixL = (1.0 + remaining) * tempMixL;
                    tempMixR = (1.0 + remaining) * tempMixR;
                    samplesUsed += remaining;
                }
                mixL += tempMixL;
                mixR += tempMixR;
            }
            mixL /= samplesUsed;
            mixR /= samplesUsed;
            mixL *= 0.8;
            mixR *= 0.8;
            if (!this.config.psgSound) {
                mixL = 0.0;
                mixR = 0.0;
            }
            if ((oneSample16Bit = (int)(mixL * 32767.0)) > Short.MAX_VALUE) {
                System.out.println(":" + oneSample16Bit);
                oneSample16Bit = Short.MAX_VALUE;
            }
            if (oneSample16Bit < Short.MIN_VALUE) {
                System.out.println(":" + oneSample16Bit);
                oneSample16Bit = Short.MIN_VALUE;
            }
            buffer[curPos++] = (byte)(oneSample16Bit & 0xFF);
            buffer[curPos++] = (byte)(oneSample16Bit >> 8 & 0xFF);
            if (this.sndfmt.getChannels() == 1) continue;
            oneSample16Bit = (int)(mixR * 32767.0);
            buffer[curPos++] = (byte)(oneSample16Bit & 0xFF);
            buffer[curPos++] = (byte)(oneSample16Bit >> 8 & 0xFF);
        }
        return curPos;
    }

    private void updateCounters() {
        this.cnt_a += 1.0;
        if (this.cnt_a >= (double)this.regs.getTone_a()) {
            this.cnt_a = 0.0;
            this.bit_a ^= 1;
        }
        this.cnt_b += 1.0;
        if (this.cnt_b >= (double)this.regs.getTone_b()) {
            this.cnt_b = 0.0;
            this.bit_b ^= 1;
        }
        this.cnt_c += 1.0;
        if (this.cnt_c >= (double)this.regs.getTone_c()) {
            this.cnt_c = 0.0;
            this.bit_c ^= 1;
        }
        this.cnt_n += 1.0;
        if (this.regs.getNoise() != 0 && this.cnt_n >= (double)this.regs.getNoise()) {
            this.cnt_n = 0.0;
            this.bit_n ^= this.noiseSeed & 1;
            this.noiseSeed = (this.noiseSeed >> 1) + (((this.noiseSeed ^ this.noiseSeed >> 3) & 1) << 16) & 0x1FFFF;
        }
        this.cnt_e += 1.0;
        if (this.cnt_e >= (double)this.regs.getEnv_freq()) {
            double d;
            this.cnt_e = 0.0;
            this.env_pos += 1.0;
            if (d > 127.0) {
                this.env_pos = 64.0;
            }
        }
    }

    private void prepareGeneration() {
        if (!dirty) {
            return;
        }
        if (!this.envGenInit) {
            this.genEnv();
        }
        if (defaultChip) {
            AY.SetChipType(Chip.AY, null);
        }
        if (this.defaultStereo) {
            this.SetStereo(Stereo.ABC, null);
        }
        if (this.defaultSoundFormat) {
            this.SetSoundFormat(44100, 1);
        }
        for (int n = 0; n < 32; ++n) {
            for (int m = 0; m < 6; ++m) {
                this.vols[m][n] = table[n] * this.eq[m];
            }
        }
        dirty = false;
    }

    private void genEnv() {
        for (int env = 0; env < 16; ++env) {
            boolean hold = false;
            int dir = (env & 4) == 4 ? 1 : -1;
            int vol = (env & 4) == 4 ? -1 : 32;
            for (int pos = 0; pos < 128; ++pos) {
                if (!(hold || (vol += dir) >= 0 && vol < 32)) {
                    if ((env & 8) == 8) {
                        if ((env & 2) == 2) {
                            dir = -dir;
                        }
                        int n = vol = dir > 0 ? 0 : 31;
                        if ((env & 1) == 1) {
                            hold = true;
                            vol = dir > 0 ? 31 : 0;
                        }
                    } else {
                        vol = 0;
                        hold = true;
                    }
                }
                this.envelope[env][pos] = vol;
            }
        }
        this.envGenInit = true;
    }

    private static void SetTableAY(double[] tbl) {
        for (int n = 0; n < 32; ++n) {
            AY.table[n] = tbl[n / 2];
        }
        type = Chip.AY;
    }

    private static void SetTableYM(double[] tbl) {
        for (int n = 0; n < 32; ++n) {
            AY.table[n] = tbl[n];
        }
        type = Chip.YM;
    }

    static {
        LION17_AY_TABLE = new double[]{0.0, 0.007827878, 0.01263447, 0.018905928, 0.029343099, 0.049408713, 0.075165942, 0.139009689, 0.157839322, 0.272770275, 0.376623178, 0.464515145, 0.592721447, 0.721293965, 0.860639353, 1.0};
        LION17_YM_TABLE = new double[]{0.0, 0.0, 0.002899214, 0.00436408, 0.005722133, 0.00717174, 0.008545052, 0.010131991, 0.013214313, 0.017242695, 0.023117418, 0.027512016, 0.034378576, 0.043457694, 0.051132982, 0.058930343, 0.073914702, 0.092439155, 0.11123827, 0.130601968, 0.159822995, 0.196505684, 0.233417258, 0.271412222, 0.328068971, 0.399359121, 0.47098497, 0.544380865, 0.65101091, 0.77799649, 0.897871366, 1.0};
        KAY_AY_TABLE = new double[]{0.0, 0.012756542, 0.018493935, 0.027054246, 0.039963378, 0.05912871, 0.082352941, 0.13463035, 0.158571756, 0.25491722, 0.356130312, 0.446967269, 0.56411078, 0.708339055, 0.842221714, 1.0};
        KAY_YM_TABLE = new double[]{0.0, 0.0, 0.003784237, 0.00686656, 0.010223545, 0.012603952, 0.015411612, 0.018905928, 0.023682002, 0.029282063, 0.035309377, 0.040070192, 0.047775998, 0.057648585, 0.067246509, 0.076768139, 0.091065843, 0.109269856, 0.128404669, 0.146822309, 0.174273289, 0.208880751, 0.243488212, 0.27893492, 0.332021057, 0.398992905, 0.465751125, 0.532219425, 0.632242313, 0.753856718, 0.877271687, 1.0};
        DEFAULT_LAYOUT = new double[][][]{new double[][]{{1.0, 1.0, 1.0, 1.0, 1.0, 1.0}, {1.0, 0.35, 0.7, 0.7, 0.35, 1.0}, {1.0, 0.35, 0.35, 1.0, 0.7, 0.7}, {0.7, 0.7, 1.0, 0.35, 0.35, 1.0}, {0.35, 1.0, 1.0, 0.35, 0.7, 0.7}, {0.7, 0.7, 0.35, 1.0, 1.0, 0.35}, {0.35, 1.0, 0.7, 0.7, 1.0, 0.35}}, new double[][]{{1.0, 1.0, 1.0, 1.0, 1.0, 1.0}, {1.0, 0.5, 0.7, 0.7, 0.5, 1.0}, {1.0, 0.5, 0.5, 1.0, 0.7, 0.7}, {0.7, 0.7, 1.0, 0.5, 0.5, 1.0}, {0.5, 1.0, 1.0, 0.5, 0.7, 0.7}, {0.7, 0.7, 0.5, 1.0, 1.0, 0.5}, {0.5, 1.0, 0.7, 0.7, 1.0, 0.5}}};
    }

    public static enum Chip {
        AY,
        YM,
        AY_Lion17,
        YM_Lion17,
        AY_Kay,
        YM_Kay,
        AY_Custom,
        YM_Custom;

    }

    public static enum Stereo {
        Mono,
        ABC,
        ACB,
        BAC,
        BCA,
        CAB,
        CBA,
        StereoCustom;

    }
}

