/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.vecx.panels;

import de.malban.config.Configuration;
import de.malban.gui.CSAMainFrame;
import de.malban.gui.Stateable;
import de.malban.gui.Windowable;
import de.malban.gui.components.CSAView;
import de.malban.util.UtilityString;
import de.malban.vide.VideConfig;
import de.malban.vide.vecx.Breakpoint;
import de.malban.vide.vecx.Updatable;
import de.malban.vide.vecx.VecX;
import de.malban.vide.vecx.VecXPanel;
import de.malban.vide.vecx.VecXState;
import de.malban.vide.vecx.devices.VectrexJoyport;
import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class AnalogJPanel
extends JPanel
implements Windowable,
Stateable,
Updatable {
    private CSAView mParent = null;
    public VideConfig config = VideConfig.getConfig();
    private JMenuItem mParentMenuItem = null;
    private int mClassSetting = 0;
    private VecXPanel vecxPanel = null;
    public static String SID = "Debug: Analog";
    int ramp;
    int blank;
    int zero = 0;
    int x_sh = 0;
    int y_sh;
    int z_sh;
    int r_sh;
    int s_sh;
    int x_int;
    int y_int;
    int dac;
    int joy0;
    int joy1;
    int joy2;
    int joy3;
    int jsh;
    int buttonIn = 0;
    int buttonOut = 0;
    String popUpName = "";
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel16;
    private JLabel jLabel17;
    private JLabel jLabel18;
    private JLabel jLabel19;
    private JLabel jLabel2;
    private JLabel jLabel20;
    private JLabel jLabel21;
    private JLabel jLabel22;
    private JLabel jLabel23;
    private JLabel jLabel24;
    private JLabel jLabel25;
    private JLabel jLabel26;
    private JLabel jLabel27;
    private JLabel jLabel28;
    private JLabel jLabel29;
    private JLabel jLabel3;
    private JLabel jLabel30;
    private JLabel jLabel31;
    private JLabel jLabel32;
    private JLabel jLabel33;
    private JLabel jLabel34;
    private JLabel jLabel35;
    private JLabel jLabel36;
    private JLabel jLabel37;
    private JLabel jLabel38;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JMenuItem jMenuItemGoHigh;
    private JMenuItem jMenuItemGoLow;
    private JPopupMenu jPopupMenu1;
    private JTextField jTextField107;
    private JTextField jTextField108;
    private JTextField jTextField109;
    private JTextField jTextField110;
    private JTextField jTextField111;
    private JTextField jTextField112;
    private JTextField jTextField113;
    private JTextField jTextField114;
    private JTextField jTextField115;
    private JTextField jTextField116;
    private JTextField jTextField117;
    private JTextField jTextField118;
    private JTextField jTextField119;
    private JTextField jTextField120;
    private JTextField jTextField121;
    private JTextField jTextField122;
    private JToggleButton jToggleButton1;
    private boolean updateEnabled = false;
    private PropertyChangeListener pListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            AnalogJPanel.this.updateMyUI();
        }
    };

    @Override
    public boolean isLoadSettings() {
        return true;
    }

    @Override
    public String getID() {
        return SID;
    }

    @Override
    public String getFileID() {
        return UtilityString.replace(UtilityString.replace(UtilityString.replace(UtilityString.replaceWhiteSpaces(SID, ""), ":", ""), "(", ""), ")", "");
    }

    @Override
    public Serializable getAdditionalStateinfo() {
        return null;
    }

    @Override
    public void setAdditionalStateinfo(Serializable ser) {
    }

    public void setVecxy(VecXPanel v) {
        this.vecxPanel = v;
    }

    @Override
    public boolean isIcon() {
        CSAMainFrame frame = Configuration.getConfiguration().getMainFrame();
        if (frame.getInternalFrame(this) == null) {
            return false;
        }
        return frame.getInternalFrame(this).isIcon();
    }

    @Override
    public void setIcon(boolean b) {
        CSAMainFrame frame = Configuration.getConfiguration().getMainFrame();
        if (frame.getInternalFrame(this) == null) {
            return;
        }
        try {
            frame.getInternalFrame(this).setIcon(b);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void closing() {
        if (this.vecxPanel != null) {
            this.vecxPanel.resetAni();
        }
        this.deinit();
    }

    @Override
    public void setParentWindow(CSAView jpv) {
        this.mParent = jpv;
    }

    @Override
    public void setMenuItem(JMenuItem item) {
        this.mParentMenuItem = item;
        this.mParentMenuItem.setText(SID);
    }

    @Override
    public JMenuItem getMenuItem() {
        return this.mParentMenuItem;
    }

    @Override
    public JPanel getPanel() {
        return this;
    }

    public void deinit() {
        this.removeUIListerner();
    }

    public AnalogJPanel() {
        this.initComponents();
        UIManager.addPropertyChangeListener(this.pListener);
        this.updateMyUI();
    }

    private void update() {
        if (this.vecxPanel == null) {
            return;
        }
        VecXState state = this.vecxPanel.getVecXState();
        this.jLabel11.setText("" + (state.sig_ramp.intValue != 0 ? "1" : "0"));
        if (state.sig_ramp.intValue != this.ramp) {
            this.jLabel11.setForeground(this.config.getValueChangedColor());
        } else {
            this.jLabel11.setForeground(this.config.getValueNotChangedColor());
        }
        this.ramp = state.sig_ramp.intValue;
        if (this.ramp == 0) {
            this.jLabel1.setBackground(Color.orange);
        } else {
            this.jLabel1.setBackground(this.jLabel34.getBackground());
        }
        this.jLabel12.setText("" + (state.sig_zero.intValue != 0 ? "1" : "0"));
        if (state.sig_zero.intValue != this.zero) {
            this.jLabel12.setForeground(this.config.getValueChangedColor());
        } else {
            this.jLabel12.setForeground(this.config.getValueNotChangedColor());
        }
        this.zero = state.sig_zero.intValue;
        if (this.zero == 0) {
            this.jLabel2.setBackground(Color.orange);
        } else {
            this.jLabel2.setBackground(this.jLabel34.getBackground());
        }
        this.jLabel15.setText("" + (state.sig_blank.intValue != 0 ? "1" : "0"));
        if (state.sig_blank.intValue != this.blank) {
            this.jLabel15.setForeground(this.config.getValueChangedColor());
        } else {
            this.jLabel15.setForeground(this.config.getValueNotChangedColor());
        }
        this.blank = state.sig_blank.intValue;
        if (this.blank == 0) {
            this.jLabel3.setBackground(Color.orange);
        } else {
            this.jLabel3.setBackground(this.jLabel34.getBackground());
        }
        this.jLabel14.setText("$" + String.format("%02X", state.alg_DAC.intValue & 0xFF));
        if (state.alg_DAC.intValue != this.dac) {
            this.jLabel14.setForeground(this.config.getValueChangedColor());
        } else {
            this.jLabel14.setForeground(this.config.getValueNotChangedColor());
        }
        this.dac = state.alg_DAC.intValue;
        this.jLabel14.setToolTipText("decimal: " + this.dac);
        this.jLabel13.setText("$" + String.format("%02X", state.alg_xsh.intValue & 0xFF));
        if (state.alg_xsh.intValue != this.x_sh) {
            this.jLabel13.setForeground(this.config.getValueChangedColor());
        } else {
            this.jLabel13.setForeground(this.config.getValueNotChangedColor());
        }
        this.x_sh = state.alg_xsh.intValue;
        this.jLabel13.setToolTipText("decimal: " + this.x_sh);
        this.jLabel16.setText("$" + String.format("%02X", state.alg_ysh.intValue & 0xFF));
        if (state.alg_ysh.intValue != this.y_sh) {
            this.jLabel16.setForeground(this.config.getValueChangedColor());
        } else {
            this.jLabel16.setForeground(this.config.getValueNotChangedColor());
        }
        this.y_sh = state.alg_ysh.intValue;
        this.jLabel16.setToolTipText("decimal: " + this.y_sh);
        this.jLabel17.setText("$" + String.format("%02X", state.alg_zsh.intValue & 0xFF));
        if (state.alg_zsh.intValue != this.z_sh) {
            this.jLabel17.setForeground(this.config.getValueChangedColor());
        } else {
            this.jLabel17.setForeground(this.config.getValueNotChangedColor());
        }
        this.z_sh = state.alg_zsh.intValue;
        this.jLabel17.setToolTipText("decimal: " + this.z_sh);
        this.jLabel18.setText("$" + String.format("%02X", state.alg_ssh.intValue & 0xFF));
        if (state.alg_ssh.intValue != this.s_sh) {
            this.jLabel18.setForeground(this.config.getValueChangedColor());
        } else {
            this.jLabel18.setForeground(this.config.getValueNotChangedColor());
        }
        this.s_sh = state.alg_ssh.intValue;
        this.jLabel18.setToolTipText("decimal: " + this.s_sh);
        this.jLabel19.setText("$" + String.format("%02X", state.c_alg_rsh.getDigitalIntValue() & 0xFF));
        if (state.c_alg_rsh.getDigitalIntValue() != this.r_sh) {
            this.jLabel19.setForeground(this.config.getValueChangedColor());
        } else {
            this.jLabel19.setForeground(this.config.getValueNotChangedColor());
        }
        this.r_sh = state.c_alg_rsh.getDigitalIntValue();
        this.jLabel19.setToolTipText("decimal: " + this.r_sh + "(d: " + state.c_alg_rsh.getDigitalValue() + ")");
        if (state instanceof VecX) {
            VectrexJoyport[] joyport = ((VecX)state).joyport;
            this.jLabel24.setText("$" + String.format("%02X", joyport[0].getHorizontal() & 0xFF));
            if (joyport[0].getHorizontal() != this.joy0) {
                this.jLabel24.setForeground(this.config.getValueChangedColor());
            } else {
                this.jLabel24.setForeground(this.config.getValueNotChangedColor());
            }
            this.joy0 = joyport[0].getHorizontal();
            this.jLabel24.setToolTipText("decimal: " + joyport[0].getHorizontal());
            this.jLabel26.setText("$" + String.format("%02X", joyport[0].getVertical() & 0xFF));
            if (joyport[0].getVertical() != this.joy1) {
                this.jLabel26.setForeground(this.config.getValueChangedColor());
            } else {
                this.jLabel26.setForeground(this.config.getValueNotChangedColor());
            }
            this.joy1 = joyport[0].getVertical();
            this.jLabel26.setToolTipText("decimal: " + joyport[0].getVertical());
            this.jLabel29.setText("$" + String.format("%02X", joyport[1].getHorizontal() & 0xFF));
            if (joyport[1].getHorizontal() != this.joy2) {
                this.jLabel29.setForeground(this.config.getValueChangedColor());
            } else {
                this.jLabel29.setForeground(this.config.getValueNotChangedColor());
            }
            this.joy2 = joyport[1].getHorizontal();
            this.jLabel29.setToolTipText("decimal: " + joyport[1].getHorizontal() + "");
            this.jLabel30.setText("$" + String.format("%02X", joyport[1].getVertical() & 0xFF));
            if (joyport[1].getVertical() != this.joy3) {
                this.jLabel30.setForeground(this.config.getValueChangedColor());
            } else {
                this.jLabel30.setForeground(this.config.getValueNotChangedColor());
            }
            this.joy3 = joyport[1].getVertical();
            this.jLabel30.setToolTipText("decimal: " + joyport[1].getVertical() + "");
            this.jTextField110.setText("" + (joyport[0].isButtonInRO(0) ? "1" : "0"));
            this.jTextField109.setText("" + (joyport[0].isButtonInRO(1) ? "1" : "0"));
            this.jTextField107.setText("" + (joyport[0].isButtonInRO(2) ? "1" : "0"));
            this.jTextField108.setText("" + (joyport[0].isButtonInRO(3) ? "1" : "0"));
            this.jTextField114.setText("" + (joyport[1].isButtonInRO(0) ? "1" : "0"));
            this.jTextField113.setText("" + (joyport[1].isButtonInRO(1) ? "1" : "0"));
            this.jTextField112.setText("" + (joyport[1].isButtonInRO(2) ? "1" : "0"));
            this.jTextField111.setText("" + (joyport[1].isButtonInRO(3) ? "1" : "0"));
            this.jTextField107.setEnabled(joyport[0].isInpuMode());
            this.jTextField108.setEnabled(joyport[0].isInpuMode());
            this.jTextField109.setEnabled(joyport[0].isInpuMode());
            this.jTextField110.setEnabled(joyport[0].isInpuMode());
            this.jTextField111.setEnabled(joyport[1].isInpuMode());
            this.jTextField112.setEnabled(joyport[1].isInpuMode());
            this.jTextField113.setEnabled(joyport[1].isInpuMode());
            this.jTextField114.setEnabled(joyport[1].isInpuMode());
            if (joyport[0].isButtonInRO(0) != ((this.buttonIn & 1) == 1)) {
                this.jTextField110.setForeground(this.config.getValueChangedColor());
            } else {
                this.jTextField110.setForeground(this.config.getValueNotChangedColor());
            }
            if (joyport[0].isButtonInRO(1) != ((this.buttonIn & 2) == 2)) {
                this.jTextField109.setForeground(this.config.getValueChangedColor());
            } else {
                this.jTextField109.setForeground(this.config.getValueNotChangedColor());
            }
            if (joyport[0].isButtonInRO(2) != ((this.buttonIn & 4) == 4)) {
                this.jTextField107.setForeground(this.config.getValueChangedColor());
            } else {
                this.jTextField107.setForeground(this.config.getValueNotChangedColor());
            }
            if (joyport[0].isButtonInRO(3) != ((this.buttonIn & 8) == 8)) {
                this.jTextField108.setForeground(this.config.getValueChangedColor());
            } else {
                this.jTextField108.setForeground(this.config.getValueNotChangedColor());
            }
            if (joyport[1].isButtonInRO(0) != ((this.buttonIn & 0x10) == 16)) {
                this.jTextField114.setForeground(this.config.getValueChangedColor());
            } else {
                this.jTextField114.setForeground(this.config.getValueNotChangedColor());
            }
            if (joyport[1].isButtonInRO(1) != ((this.buttonIn & 0x20) == 32)) {
                this.jTextField113.setForeground(this.config.getValueChangedColor());
            } else {
                this.jTextField113.setForeground(this.config.getValueNotChangedColor());
            }
            if (joyport[1].isButtonInRO(2) != ((this.buttonIn & 0x40) == 64)) {
                this.jTextField112.setForeground(this.config.getValueChangedColor());
            } else {
                this.jTextField112.setForeground(this.config.getValueNotChangedColor());
            }
            if (joyport[1].isButtonInRO(3) != ((this.buttonIn & 0x80) == 128)) {
                this.jTextField111.setForeground(this.config.getValueChangedColor());
            } else {
                this.jTextField111.setForeground(this.config.getValueNotChangedColor());
            }
            this.buttonIn = 0;
            this.buttonIn += joyport[0].isButtonInRO(0) ? 1 : 0;
            this.buttonIn += joyport[0].isButtonInRO(1) ? 2 : 0;
            this.buttonIn += joyport[0].isButtonInRO(2) ? 4 : 0;
            this.buttonIn += joyport[0].isButtonInRO(3) ? 8 : 0;
            this.buttonIn += joyport[1].isButtonInRO(0) ? 16 : 0;
            this.buttonIn += joyport[1].isButtonInRO(1) ? 32 : 0;
            this.buttonIn += joyport[1].isButtonInRO(2) ? 64 : 0;
            this.buttonIn += joyport[1].isButtonInRO(3) ? 128 : 0;
            this.jTextField115.setEnabled(!joyport[0].isInpuMode());
            this.jTextField116.setEnabled(!joyport[0].isInpuMode());
            this.jTextField117.setEnabled(!joyport[0].isInpuMode());
            this.jTextField118.setEnabled(!joyport[0].isInpuMode());
            this.jTextField119.setEnabled(!joyport[1].isInpuMode());
            this.jTextField120.setEnabled(!joyport[1].isInpuMode());
            this.jTextField121.setEnabled(!joyport[1].isInpuMode());
            this.jTextField122.setEnabled(!joyport[1].isInpuMode());
            this.jTextField115.setText("" + (joyport[0].isButtonOutRO(0) ? "1" : "0"));
            this.jTextField116.setText("" + (joyport[0].isButtonOutRO(1) ? "1" : "0"));
            this.jTextField117.setText("" + (joyport[0].isButtonOutRO(2) ? "1" : "0"));
            this.jTextField118.setText("" + (joyport[0].isButtonOutRO(3) ? "1" : "0"));
            this.jTextField119.setText("" + (joyport[1].isButtonOutRO(0) ? "1" : "0"));
            this.jTextField120.setText("" + (joyport[1].isButtonOutRO(1) ? "1" : "0"));
            this.jTextField121.setText("" + (joyport[1].isButtonOutRO(2) ? "1" : "0"));
            this.jTextField122.setText("" + (joyport[1].isButtonOutRO(3) ? "1" : "0"));
            if (joyport[0].isButtonOutRO(0) != ((this.buttonOut & 1) == 1)) {
                this.jTextField115.setForeground(this.config.getValueChangedColor());
            } else {
                this.jTextField115.setForeground(this.config.getValueNotChangedColor());
            }
            if (joyport[0].isButtonOutRO(1) != ((this.buttonOut & 2) == 2)) {
                this.jTextField116.setForeground(this.config.getValueChangedColor());
            } else {
                this.jTextField116.setForeground(this.config.getValueNotChangedColor());
            }
            if (joyport[0].isButtonOutRO(2) != ((this.buttonOut & 4) == 4)) {
                this.jTextField117.setForeground(this.config.getValueChangedColor());
            } else {
                this.jTextField117.setForeground(this.config.getValueNotChangedColor());
            }
            if (joyport[0].isButtonOutRO(3) != ((this.buttonOut & 8) == 8)) {
                this.jTextField118.setForeground(this.config.getValueChangedColor());
            } else {
                this.jTextField118.setForeground(this.config.getValueNotChangedColor());
            }
            if (joyport[1].isButtonOutRO(0) != ((this.buttonOut & 0x10) == 16)) {
                this.jTextField119.setForeground(this.config.getValueChangedColor());
            } else {
                this.jTextField119.setForeground(this.config.getValueNotChangedColor());
            }
            if (joyport[1].isButtonOutRO(1) != ((this.buttonOut & 0x20) == 32)) {
                this.jTextField120.setForeground(this.config.getValueChangedColor());
            } else {
                this.jTextField120.setForeground(this.config.getValueNotChangedColor());
            }
            if (joyport[1].isButtonOutRO(2) != ((this.buttonOut & 0x40) == 64)) {
                this.jTextField121.setForeground(this.config.getValueChangedColor());
            } else {
                this.jTextField121.setForeground(this.config.getValueNotChangedColor());
            }
            if (joyport[1].isButtonOutRO(3) != ((this.buttonOut & 0x80) == 128)) {
                this.jTextField122.setForeground(this.config.getValueChangedColor());
            } else {
                this.jTextField122.setForeground(this.config.getValueNotChangedColor());
            }
            this.buttonOut = 0;
            this.buttonOut += joyport[0].isButtonOutRO(0) ? 1 : 0;
            this.buttonOut += joyport[0].isButtonOutRO(1) ? 2 : 0;
            this.buttonOut += joyport[0].isButtonOutRO(2) ? 4 : 0;
            this.buttonOut += joyport[0].isButtonOutRO(3) ? 8 : 0;
            this.buttonOut += joyport[1].isButtonOutRO(0) ? 16 : 0;
            this.buttonOut += joyport[1].isButtonOutRO(1) ? 32 : 0;
            this.buttonOut += joyport[1].isButtonOutRO(2) ? 64 : 0;
            this.buttonOut += joyport[1].isButtonOutRO(3) ? 128 : 0;
        }
        this.jLabel32.setText("$" + String.format("%02X", state.alg_jsh & 0xFF));
        if (state.alg_jsh != this.jsh) {
            this.jLabel32.setForeground(this.config.getValueChangedColor());
        } else {
            this.jLabel32.setForeground(this.config.getValueNotChangedColor());
        }
        this.jsh = state.alg_jsh;
        this.jLabel32.setToolTipText("decimal: " + state.alg_jsh);
        int calc_x = (int)state.alg_curr_x - this.config.ALG_MAX_X / 2;
        boolean neg = calc_x < 0;
        int pos = Math.abs(calc_x) & 0xFFFF;
        if (neg) {
            this.jLabel20.setText("-$" + String.format("%04X", pos));
        } else {
            this.jLabel20.setText("$" + String.format("%04X", pos));
        }
        if (calc_x != this.x_int) {
            this.jLabel20.setForeground(this.config.getValueChangedColor());
        } else {
            this.jLabel20.setForeground(this.config.getValueNotChangedColor());
        }
        this.x_int = calc_x;
        this.jLabel20.setToolTipText("decimal: " + this.x_int);
        int cacl_y = (int)state.alg_curr_y - this.config.ALG_MAX_Y / 2;
        neg = cacl_y < 0;
        pos = Math.abs(cacl_y) & 0xFFFF;
        if (neg) {
            this.jLabel22.setText("-$" + String.format("%04X", pos));
        } else {
            this.jLabel22.setText("$" + String.format("%04X", pos));
        }
        if (cacl_y != this.y_int) {
            this.jLabel22.setForeground(this.config.getValueChangedColor());
        } else {
            this.jLabel22.setForeground(this.config.getValueNotChangedColor());
        }
        this.y_int = cacl_y;
        this.jLabel22.setToolTipText("decimal: " + this.y_int);
        this.repaint();
    }

    private void initComponents() {
        this.jPopupMenu1 = new JPopupMenu();
        this.jMenuItemGoLow = new JMenuItem();
        this.jMenuItemGoHigh = new JMenuItem();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jLabel8 = new JLabel();
        this.jLabel9 = new JLabel();
        this.jLabel10 = new JLabel();
        this.jLabel11 = new JLabel();
        this.jLabel12 = new JLabel();
        this.jLabel13 = new JLabel();
        this.jLabel14 = new JLabel();
        this.jLabel15 = new JLabel();
        this.jLabel16 = new JLabel();
        this.jLabel17 = new JLabel();
        this.jLabel18 = new JLabel();
        this.jLabel19 = new JLabel();
        this.jLabel20 = new JLabel();
        this.jLabel21 = new JLabel();
        this.jLabel22 = new JLabel();
        this.jLabel23 = new JLabel();
        this.jLabel24 = new JLabel();
        this.jLabel25 = new JLabel();
        this.jLabel26 = new JLabel();
        this.jLabel27 = new JLabel();
        this.jLabel28 = new JLabel();
        this.jLabel29 = new JLabel();
        this.jLabel30 = new JLabel();
        this.jLabel31 = new JLabel();
        this.jLabel32 = new JLabel();
        this.jLabel33 = new JLabel();
        this.jTextField107 = new JTextField();
        this.jTextField108 = new JTextField();
        this.jTextField109 = new JTextField();
        this.jTextField110 = new JTextField();
        this.jTextField111 = new JTextField();
        this.jTextField112 = new JTextField();
        this.jTextField113 = new JTextField();
        this.jTextField114 = new JTextField();
        this.jLabel34 = new JLabel();
        this.jToggleButton1 = new JToggleButton();
        this.jTextField115 = new JTextField();
        this.jTextField116 = new JTextField();
        this.jTextField117 = new JTextField();
        this.jTextField118 = new JTextField();
        this.jLabel35 = new JLabel();
        this.jLabel36 = new JLabel();
        this.jLabel37 = new JLabel();
        this.jTextField119 = new JTextField();
        this.jTextField120 = new JTextField();
        this.jTextField121 = new JTextField();
        this.jTextField122 = new JTextField();
        this.jLabel38 = new JLabel();
        this.jMenuItemGoLow.setLabel("Add Breakpoint on low");
        this.jMenuItemGoLow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AnalogJPanel.this.jMenuItemGoLowActionPerformed(evt);
            }
        });
        this.jPopupMenu1.add(this.jMenuItemGoLow);
        this.jMenuItemGoHigh.setText("Add Breakpoint on high");
        this.jMenuItemGoHigh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AnalogJPanel.this.jMenuItemGoHighActionPerformed(evt);
            }
        });
        this.jPopupMenu1.add(this.jMenuItemGoHigh);
        this.setName("regi");
        this.jLabel1.setFont(new Font("Courier", 0, 12));
        this.jLabel1.setText("~RAMP");
        this.jLabel1.setToolTipText("If 0 the integrators are integrating, if 1 not!");
        this.jLabel2.setFont(new Font("Courier", 0, 12));
        this.jLabel2.setText("~ZERO");
        this.jLabel2.setToolTipText("If 0 the integrators are grounded and kept to 0, no matter what, if one, integration is possible!");
        this.jLabel3.setFont(new Font("Courier", 0, 12));
        this.jLabel3.setText("~BLANK");
        this.jLabel3.setToolTipText("If 0 BLANK is active, meaning the color of the vector beam is allways OFF. If 1 the color of the beam is what is currently in Z-SH.");
        this.jLabel4.setFont(new Font("Courier", 0, 12));
        this.jLabel4.setText("DAC");
        this.jLabel5.setFont(new Font("Courier", 0, 12));
        this.jLabel5.setText("X-SH");
        this.jLabel5.setToolTipText("always = DAC, the value that is added to X-integrators\n");
        this.jLabel6.setFont(new Font("Courier", 0, 12));
        this.jLabel6.setText("Y-SH");
        this.jLabel6.setToolTipText("if MUX bits = 00, the value that is added to the y integrators");
        this.jLabel7.setFont(new Font("Courier", 0, 12));
        this.jLabel7.setText("Int X");
        this.jLabel8.setFont(new Font("Courier", 0, 12));
        this.jLabel8.setText("Z-SH");
        this.jLabel8.setToolTipText("if MUX bits = 10, Color of the vector beam. If bit 7 is set (0x80) than color is OFF.\n");
        this.jLabel9.setFont(new Font("Courier", 0, 12));
        this.jLabel9.setText("S-SH");
        this.jLabel9.setToolTipText("if MUX bits = 11, value that is put to the soundchip");
        this.jLabel10.setFont(new Font("Courier", 0, 12));
        this.jLabel10.setText("R-SH");
        this.jLabel10.setToolTipText("if MUX bits = 01");
        this.jLabel11.setFont(new Font("Courier", 0, 12));
        this.jLabel11.setText("0");
        this.jLabel11.setToolTipText("");
        this.jLabel12.setFont(new Font("Courier", 0, 12));
        this.jLabel12.setText("0");
        this.jLabel13.setFont(new Font("Courier", 0, 12));
        this.jLabel13.setText("$ff");
        this.jLabel13.setToolTipText("always = DAC");
        this.jLabel14.setFont(new Font("Courier", 0, 12));
        this.jLabel14.setText("$ff");
        this.jLabel15.setFont(new Font("Courier", 0, 12));
        this.jLabel15.setText("0");
        this.jLabel16.setFont(new Font("Courier", 0, 12));
        this.jLabel16.setText("$ff");
        this.jLabel16.setToolTipText("if MUX bits = 00");
        this.jLabel17.setFont(new Font("Courier", 0, 12));
        this.jLabel17.setText("$ff");
        this.jLabel17.setToolTipText("if MUX bits = 10");
        this.jLabel18.setFont(new Font("Courier", 0, 12));
        this.jLabel18.setText("$ff");
        this.jLabel18.setToolTipText("if MUX bits = 11");
        this.jLabel19.setFont(new Font("Courier", 0, 12));
        this.jLabel19.setText("$ff");
        this.jLabel19.setToolTipText("if MUX bits = 01, value that is used as offsets for the integrators");
        this.jLabel20.setFont(new Font("Courier", 0, 12));
        this.jLabel20.setText("$ffff");
        this.jLabel20.setToolTipText("Current X coordinate");
        this.jLabel21.setFont(new Font("Courier", 0, 12));
        this.jLabel21.setText("Int Y");
        this.jLabel22.setFont(new Font("Courier", 0, 12));
        this.jLabel22.setText("$ffff");
        this.jLabel22.setToolTipText("current y coordinate");
        this.jLabel23.setFont(new Font("Courier", 0, 12));
        this.jLabel23.setText("Joy0 X");
        this.jLabel23.setToolTipText("if MUX bits = 01");
        this.jLabel24.setFont(new Font("Courier", 0, 12));
        this.jLabel24.setText("$ff");
        this.jLabel24.setToolTipText("positive left, negative right(0x80 middle)");
        this.jLabel25.setFont(new Font("Courier", 0, 12));
        this.jLabel25.setText("Joy0 Y");
        this.jLabel25.setToolTipText("if MUX bits = 01");
        this.jLabel26.setFont(new Font("Courier", 0, 12));
        this.jLabel26.setText("$ff");
        this.jLabel26.setToolTipText("positive down, negative up (0x80 middle)");
        this.jLabel27.setFont(new Font("Courier", 0, 12));
        this.jLabel27.setText("Joy1 Y");
        this.jLabel27.setToolTipText("if MUX bits = 01");
        this.jLabel28.setFont(new Font("Courier", 0, 12));
        this.jLabel28.setText("Joy1 X");
        this.jLabel28.setToolTipText("if MUX bits = 01");
        this.jLabel29.setFont(new Font("Courier", 0, 12));
        this.jLabel29.setText("$ff");
        this.jLabel29.setToolTipText("positive left, negative right(0x80 middle)");
        this.jLabel30.setFont(new Font("Courier", 0, 12));
        this.jLabel30.setText("$ff");
        this.jLabel30.setToolTipText("positive down, negative up (0x80 middle)");
        this.jLabel31.setFont(new Font("Courier", 0, 12));
        this.jLabel31.setText("J-SH");
        this.jLabel31.setToolTipText("if MUX bits = 01");
        this.jLabel32.setFont(new Font("Courier", 0, 12));
        this.jLabel32.setText("$ff");
        this.jLabel32.setToolTipText("if MUX bits = 01, value that is used as offsets for the integrators");
        this.jLabel33.setFont(new Font("Courier", 0, 12));
        this.jLabel33.setText("But0");
        this.jLabel33.setToolTipText("if MUX bits = 01");
        this.jTextField107.setFont(new Font("Courier", 0, 11));
        this.jTextField107.setText("0");
        this.jTextField107.setName("2_in");
        this.jTextField107.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                AnalogJPanel.this.jTextField119MousePressed(evt);
            }
        });
        this.jTextField108.setFont(new Font("Courier", 0, 11));
        this.jTextField108.setText("0");
        this.jTextField108.setName("3_in");
        this.jTextField108.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                AnalogJPanel.this.jTextField119MousePressed(evt);
            }
        });
        this.jTextField109.setFont(new Font("Courier", 0, 11));
        this.jTextField109.setText("0");
        this.jTextField109.setName("1_in");
        this.jTextField109.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                AnalogJPanel.this.jTextField119MousePressed(evt);
            }
        });
        this.jTextField110.setFont(new Font("Courier", 0, 11));
        this.jTextField110.setText("0");
        this.jTextField110.setName("0_in");
        this.jTextField110.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                AnalogJPanel.this.jTextField119MousePressed(evt);
            }
        });
        this.jTextField111.setFont(new Font("Courier", 0, 11));
        this.jTextField111.setText("0");
        this.jTextField111.setToolTipText("");
        this.jTextField111.setName("7_in");
        this.jTextField111.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                AnalogJPanel.this.jTextField119MousePressed(evt);
            }
        });
        this.jTextField112.setFont(new Font("Courier", 0, 11));
        this.jTextField112.setText("0");
        this.jTextField112.setToolTipText("");
        this.jTextField112.setName("6_in");
        this.jTextField112.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                AnalogJPanel.this.jTextField119MousePressed(evt);
            }
        });
        this.jTextField113.setFont(new Font("Courier", 0, 11));
        this.jTextField113.setText("0");
        this.jTextField113.setToolTipText("");
        this.jTextField113.setName("5_in");
        this.jTextField113.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                AnalogJPanel.this.jTextField119MousePressed(evt);
            }
        });
        this.jTextField114.setFont(new Font("Courier", 0, 11));
        this.jTextField114.setText("0");
        this.jTextField114.setToolTipText("");
        this.jTextField114.setName("4_in");
        this.jTextField114.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                AnalogJPanel.this.jTextField119MousePressed(evt);
            }
        });
        this.jLabel34.setFont(new Font("Courier", 0, 12));
        this.jLabel34.setText("But1");
        this.jLabel34.setToolTipText("not implemented");
        this.jToggleButton1.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/webcam.png")));
        this.jToggleButton1.setToolTipText("Toggle Update (always or only while debug)");
        this.jToggleButton1.setMargin(new Insets(0, 1, 0, -1));
        this.jToggleButton1.setSelectedIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/webcamSelect.png")));
        this.jToggleButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AnalogJPanel.this.jToggleButton1ActionPerformed(evt);
            }
        });
        this.jTextField115.setFont(new Font("Courier", 0, 11));
        this.jTextField115.setText("0");
        this.jTextField115.setName("0_out");
        this.jTextField115.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                AnalogJPanel.this.jTextField119MousePressed(evt);
            }
        });
        this.jTextField116.setFont(new Font("Courier", 0, 11));
        this.jTextField116.setText("0");
        this.jTextField116.setName("1_out");
        this.jTextField116.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                AnalogJPanel.this.jTextField119MousePressed(evt);
            }
        });
        this.jTextField117.setFont(new Font("Courier", 0, 11));
        this.jTextField117.setText("0");
        this.jTextField117.setName("2_out");
        this.jTextField117.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                AnalogJPanel.this.jTextField119MousePressed(evt);
            }
        });
        this.jTextField118.setFont(new Font("Courier", 0, 11));
        this.jTextField118.setText("0");
        this.jTextField118.setName("3_out");
        this.jTextField118.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                AnalogJPanel.this.jTextField119MousePressed(evt);
            }
        });
        this.jLabel35.setFont(new Font("Courier", 0, 12));
        this.jLabel35.setText("In");
        this.jLabel35.setToolTipText("input from device to vectrex");
        this.jLabel36.setFont(new Font("Courier", 0, 12));
        this.jLabel36.setText("Out");
        this.jLabel36.setToolTipText("from vectrex to device");
        this.jLabel37.setFont(new Font("Courier", 0, 12));
        this.jLabel37.setText("In");
        this.jLabel37.setToolTipText("input from device to vectrex");
        this.jTextField119.setFont(new Font("Courier", 0, 11));
        this.jTextField119.setText("0");
        this.jTextField119.setToolTipText("");
        this.jTextField119.setName("4_out");
        this.jTextField119.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                AnalogJPanel.this.jTextField119MousePressed(evt);
            }
        });
        this.jTextField120.setFont(new Font("Courier", 0, 11));
        this.jTextField120.setText("0");
        this.jTextField120.setToolTipText("");
        this.jTextField120.setName("5_out");
        this.jTextField120.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                AnalogJPanel.this.jTextField119MousePressed(evt);
            }
        });
        this.jTextField121.setFont(new Font("Courier", 0, 11));
        this.jTextField121.setText("0");
        this.jTextField121.setToolTipText("");
        this.jTextField121.setName("6_out");
        this.jTextField121.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                AnalogJPanel.this.jTextField119MousePressed(evt);
            }
        });
        this.jTextField122.setFont(new Font("Courier", 0, 11));
        this.jTextField122.setText("0");
        this.jTextField122.setToolTipText("");
        this.jTextField122.setName("7_out");
        this.jTextField122.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                AnalogJPanel.this.jTextField119MousePressed(evt);
            }
        });
        this.jLabel38.setFont(new Font("Courier", 0, 12));
        this.jLabel38.setText("Out");
        this.jLabel38.setToolTipText("from vectrex to device");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(48, 48, 48).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel22, -1, -1, Short.MAX_VALUE).addContainerGap(-1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel24, -1, -1, Short.MAX_VALUE).addContainerGap(-1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel26, -1, -1, Short.MAX_VALUE).addContainerGap(-1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel29, -1, -1, Short.MAX_VALUE).addContainerGap(-1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel30, -1, -1, Short.MAX_VALUE).addContainerGap(-1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel32, -1, -1, Short.MAX_VALUE).addContainerGap(-1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel11, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel12, -1, -1, Short.MAX_VALUE)).addContainerGap(-1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel15, -2, 14, -2).addComponent(this.jLabel14).addComponent(this.jLabel13).addComponent(this.jLabel16).addComponent(this.jLabel17).addComponent(this.jLabel18).addComponent(this.jLabel19).addComponent(this.jLabel20)).addContainerGap(-1, Short.MAX_VALUE)))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jLabel31, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel27, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel28, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel33, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel34, -1, -1, Short.MAX_VALUE)).addGap(6, 6, 6).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jTextField110, -2, 15, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextField109, -2, 15, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextField107, -2, 15, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextField108, -2, 15, -2).addGap(5, 5, 5).addComponent(this.jLabel35, -2, 23, -2)).addGroup(layout.createSequentialGroup().addComponent(this.jTextField114, -2, 15, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextField113, -2, 15, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextField112, -2, 15, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextField111, -2, 15, -2).addGap(5, 5, 5).addComponent(this.jLabel37, -2, 23, -2)).addGroup(layout.createSequentialGroup().addComponent(this.jTextField115, -2, 15, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextField116, -2, 15, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextField117, -2, 15, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextField118, -2, 15, -2).addGap(5, 5, 5).addComponent(this.jLabel36, -2, 33, -2)).addGroup(layout.createSequentialGroup().addComponent(this.jTextField119, -2, 15, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextField120, -2, 15, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextField121, -2, 15, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextField122, -2, 15, -2).addGap(5, 5, 5).addComponent(this.jLabel38, -2, 33, -2)))).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jLabel25, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel23, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel21, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel10, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel9, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel8, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel6, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel5, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel4, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel3, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel2, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel1, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel7, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addComponent(this.jToggleButton1, -2, 20, -2)).addContainerGap(24, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jToggleButton1, -2, 20, -2).addGap(7, 7, 7).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jLabel11)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jLabel12)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.jLabel14))).addComponent(this.jLabel15)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.jLabel13)).addGap(4, 4, 4).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.jLabel16)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel8).addComponent(this.jLabel17)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel9).addComponent(this.jLabel18)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel10).addComponent(this.jLabel19)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7).addComponent(this.jLabel20)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel21).addComponent(this.jLabel22)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel23).addComponent(this.jLabel24)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel25).addComponent(this.jLabel26)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel28).addComponent(this.jLabel29)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel27).addComponent(this.jLabel30)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel31).addComponent(this.jLabel32)).addGap(2, 2, 2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel33).addComponent(this.jTextField110, -2, -1, -2).addComponent(this.jTextField109, -2, -1, -2).addComponent(this.jTextField107, -2, -1, -2).addComponent(this.jTextField108, -2, -1, -2).addComponent(this.jLabel35)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextField115, -2, -1, -2).addComponent(this.jTextField116, -2, -1, -2).addComponent(this.jTextField117, -2, -1, -2).addComponent(this.jTextField118, -2, -1, -2).addComponent(this.jLabel36)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel34).addComponent(this.jTextField114, -2, -1, -2).addComponent(this.jTextField113, -2, -1, -2).addComponent(this.jTextField112, -2, -1, -2).addComponent(this.jTextField111, -2, -1, -2).addComponent(this.jLabel37)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextField119, -2, -1, -2).addComponent(this.jTextField120, -2, -1, -2).addComponent(this.jTextField121, -2, -1, -2).addComponent(this.jTextField122, -2, -1, -2).addComponent(this.jLabel38)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void jToggleButton1ActionPerformed(ActionEvent evt) {
        this.updateEnabled = this.jToggleButton1.isSelected();
    }

    private void jTextField119MousePressed(MouseEvent evt) {
        if (evt.getButton() == 3) {
            JTextField tf = (JTextField)evt.getSource();
            this.popUpName = tf.getName();
            this.jPopupMenu1.show(tf, evt.getX() - 20, evt.getY() - 20);
        }
    }

    private void jMenuItemGoLowActionPerformed(ActionEvent evt) {
        boolean in = this.popUpName.contains("in");
        int bit = UtilityString.Int0(this.popUpName.substring(0, 1));
        Breakpoint bp = new Breakpoint();
        bp.targetAddress = bit;
        bp.targetBank = 0;
        bp.compareValue = 0;
        if (in) {
            bp.name = "port bit " + bit + " in low";
            bp.targetType = Breakpoint.BP_TARGET_PORT;
            bp.targetSubType = Breakpoint.BP_SUBTARGET_PORT_IN;
        } else {
            bp.name = "port bit " + bit + " out low";
            bp.targetType = Breakpoint.BP_TARGET_PORT;
            bp.targetSubType = Breakpoint.BP_SUBTARGET_PORT_OUT;
        }
        bp.targetSubType = 0;
        bp.type = Breakpoint.BP_BITCOMPARE | Breakpoint.BP_MULTI;
        this.vecxPanel.breakpointSet(bp);
        this.popUpName = "";
    }

    private void jMenuItemGoHighActionPerformed(ActionEvent evt) {
        boolean in = this.popUpName.contains("in");
        int bit = UtilityString.Int0(this.popUpName.substring(0, 1));
        Breakpoint bp = new Breakpoint();
        bp.targetAddress = bit;
        bp.targetBank = 0;
        bp.compareValue = 1;
        if (in) {
            bp.name = "port bit " + bit + " in high";
            bp.targetType = Breakpoint.BP_TARGET_PORT;
            bp.targetSubType = Breakpoint.BP_SUBTARGET_PORT_IN;
        } else {
            bp.name = "port bit " + bit + " out high";
            bp.targetType = Breakpoint.BP_TARGET_PORT;
            bp.targetSubType = Breakpoint.BP_SUBTARGET_PORT_OUT;
        }
        bp.targetSubType = 0;
        bp.type = Breakpoint.BP_BITCOMPARE | Breakpoint.BP_MULTI;
        this.vecxPanel.breakpointSet(bp);
        this.popUpName = "";
    }

    @Override
    public void updateValues(boolean forceUpdate) {
        if (!forceUpdate && !this.updateEnabled) {
            return;
        }
        this.update();
    }

    @Override
    public void setUpdateEnabled(boolean b) {
        this.updateEnabled = b;
    }

    public void removeUIListerner() {
        UIManager.removePropertyChangeListener(this.pListener);
    }

    void updateMyUI() {
        SwingUtilities.updateComponentTreeUI(this.jPopupMenu1);
    }

    @Override
    public void deIconified() {
    }
}

