/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.vecx.panels;

import de.malban.Global;
import de.malban.config.Configuration;
import de.malban.gui.CSAMainFrame;
import de.malban.gui.Stateable;
import de.malban.gui.Windowable;
import de.malban.gui.components.CSAView;
import de.malban.gui.dialogs.InternalFrameFileChoser;
import de.malban.gui.panels.LogPanel;
import de.malban.util.UtilityString;
import de.malban.vide.dissy.DissiPanel;
import de.malban.vide.vecx.Breakpoint;
import de.malban.vide.vecx.Updatable;
import de.malban.vide.vecx.VecXPanel;
import de.malban.vide.vecx.panels.OneBreakpointPanel;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;
import javax.swing.filechooser.FileNameExtensionFilter;

public class BreakpointJPanel
extends JPanel
implements Windowable,
Stateable,
Updatable {
    private CSAView mParent = null;
    private JMenuItem mParentMenuItem = null;
    private int mClassSetting = 0;
    private DissiPanel dissi = null;
    private VecXPanel vecxPanel = null;
    public static String SID = "Debug: Breakpoints";
    long checksum = 0L;
    private JButton jButtonFileSelect10;
    private JButton jButtonLoad;
    private JButton jButtonSave;
    private JPanel jPanel1;
    private JScrollPane jScrollPane2;
    private JToggleButton jToggleButton3;
    private OneBreakpointPanel oneBreakpointPanel1;
    private OneBreakpointPanel oneBreakpointPanel2;
    private boolean updateEnabled = false;

    @Override
    public boolean isLoadSettings() {
        return true;
    }

    @Override
    public String getID() {
        return SID;
    }

    @Override
    public String getFileID() {
        return UtilityString.replace(UtilityString.replace(UtilityString.replace(UtilityString.replaceWhiteSpaces(SID, ""), ":", ""), "(", ""), ")", "");
    }

    @Override
    public Serializable getAdditionalStateinfo() {
        return null;
    }

    @Override
    public void setAdditionalStateinfo(Serializable ser) {
    }

    public void setVecxy(VecXPanel v) {
        this.vecxPanel = v;
        this.init();
    }

    public void setDissi(DissiPanel v) {
        this.dissi = v;
    }

    @Override
    public boolean isIcon() {
        CSAMainFrame frame = Configuration.getConfiguration().getMainFrame();
        if (frame.getInternalFrame(this) == null) {
            return false;
        }
        return frame.getInternalFrame(this).isIcon();
    }

    @Override
    public void setIcon(boolean b) {
        CSAMainFrame frame = Configuration.getConfiguration().getMainFrame();
        if (frame.getInternalFrame(this) == null) {
            return;
        }
        try {
            frame.getInternalFrame(this).setIcon(b);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void closing() {
        if (this.vecxPanel != null) {
            this.vecxPanel.resetBreaki();
        }
        this.deinit();
    }

    @Override
    public void setParentWindow(CSAView jpv) {
        this.mParent = jpv;
    }

    @Override
    public void setMenuItem(JMenuItem item) {
        this.mParentMenuItem = item;
        this.mParentMenuItem.setText(SID);
    }

    @Override
    public JMenuItem getMenuItem() {
        return this.mParentMenuItem;
    }

    @Override
    public JPanel getPanel() {
        return this;
    }

    public void deinit() {
    }

    public BreakpointJPanel() {
        this.initComponents();
        this.init();
    }

    public void init() {
        this.checksum = 0L;
        this.jPanel1.removeAll();
        if (this.vecxPanel == null) {
            return;
        }
        ArrayList<Breakpoint>[] allBreakpoints = this.vecxPanel.getAllBreakpoints();
        int y = 0;
        ArrayList tmp = new ArrayList();
        for (ArrayList<Breakpoint> list2 : allBreakpoints) {
            for (Breakpoint bp : list2) {
                this.checksum += (this.checksum << 2) + (long)bp.uid;
                OneBreakpointPanel panel = new OneBreakpointPanel();
                panel.setParent(this);
                panel.setBreakpoint(bp);
                panel.setBounds(0, y, 453, 99);
                this.jPanel1.add(panel);
                y += 101;
            }
        }
        this.jPanel1.setSize(this.jPanel1.getWidth(), y);
        this.jPanel1.setPreferredSize(new Dimension(this.jPanel1.getWidth(), y));
    }

    private void initComponents() {
        this.jToggleButton3 = new JToggleButton();
        this.jScrollPane2 = new JScrollPane();
        this.jPanel1 = new JPanel();
        this.oneBreakpointPanel1 = new OneBreakpointPanel();
        this.oneBreakpointPanel2 = new OneBreakpointPanel();
        this.jButtonFileSelect10 = new JButton();
        this.jButtonLoad = new JButton();
        this.jButtonSave = new JButton();
        this.jToggleButton3.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/webcam.png")));
        this.jToggleButton3.setToolTipText("Toggle Update (always or only while debug)");
        this.jToggleButton3.setMargin(new Insets(0, 1, 0, -1));
        this.jToggleButton3.setSelectedIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/webcamSelect.png")));
        this.jToggleButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BreakpointJPanel.this.jToggleButton3ActionPerformed(evt);
            }
        });
        this.jPanel1.setPreferredSize(new Dimension(100, 400));
        this.jPanel1.setLayout(null);
        this.jPanel1.add(this.oneBreakpointPanel1);
        this.oneBreakpointPanel1.setBounds(0, 0, 455, 103);
        this.jPanel1.add(this.oneBreakpointPanel2);
        this.oneBreakpointPanel2.setBounds(0, 109, 455, 100);
        this.jScrollPane2.setViewportView(this.jPanel1);
        this.jButtonFileSelect10.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/add.png")));
        this.jButtonFileSelect10.setEnabled(false);
        this.jButtonFileSelect10.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonFileSelect10.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BreakpointJPanel.this.jButtonFileSelect10ActionPerformed(evt);
            }
        });
        this.jButtonLoad.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/page_go.png")));
        this.jButtonLoad.setToolTipText("load breakpoints");
        this.jButtonLoad.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonLoad.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BreakpointJPanel.this.jButtonLoadActionPerformed(evt);
            }
        });
        this.jButtonSave.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/page_save.png")));
        this.jButtonSave.setToolTipText("save breakpoints");
        this.jButtonSave.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BreakpointJPanel.this.jButtonSaveActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jToggleButton3, -2, 20, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButtonFileSelect10).addGap(28, 28, 28).addComponent(this.jButtonLoad).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonSave).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.jScrollPane2, -1, 476, Short.MAX_VALUE)).addGap(0, 0, 0)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jToggleButton3, -2, 20, -2).addComponent(this.jButtonFileSelect10).addComponent(this.jButtonSave).addComponent(this.jButtonLoad)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -1, 247, Short.MAX_VALUE)));
    }

    private void jToggleButton3ActionPerformed(ActionEvent evt) {
        this.updateEnabled = this.jToggleButton3.isSelected();
    }

    private void jButtonFileSelect10ActionPerformed(ActionEvent evt) {
    }

    private void jButtonLoadActionPerformed(ActionEvent evt) {
        this.loadBreakpoints();
    }

    private void jButtonSaveActionPerformed(ActionEvent evt) {
        this.saveBreakpoints();
    }

    private void update() {
        ArrayList<Breakpoint>[] allBreakpoints;
        long newChecksum = -1L;
        for (ArrayList<Breakpoint> list2 : allBreakpoints = this.vecxPanel.getAllBreakpoints()) {
            for (Breakpoint bp : list2) {
                if (bp.wasTriggered()) {
                    this.init();
                    this.checksum = -2L;
                    return;
                }
                newChecksum += (newChecksum << 2) + (long)bp.uid;
            }
        }
        if (newChecksum != this.checksum) {
            this.init();
        }
    }

    @Override
    public void updateValues(boolean forceUpdate) {
        if (!forceUpdate && !this.updateEnabled) {
            return;
        }
        this.update();
    }

    void updateDissi() {
        if (this.dissi == null) {
            return;
        }
        this.dissi.updateTableOnly();
    }

    @Override
    public void setUpdateEnabled(boolean b) {
        this.updateEnabled = b;
    }

    void removeBreakpoint(Breakpoint bp) {
        this.vecxPanel.breakpointRemove(bp);
    }

    @Override
    public void deIconified() {
    }

    public void loadBreakpoints() {
        String filename = Global.mainPathPrefix + "serialize";
        InternalFrameFileChoser fc = new InternalFrameFileChoser();
        Path p = Paths.get(filename, new String[0]);
        fc.setCurrentDirectory(new File(p.toString()));
        FileNameExtensionFilter filter = new FileNameExtensionFilter("Breakpoints", "brk");
        fc.setFileFilter(filter);
        int r = fc.showOpenDialog(Configuration.getConfiguration().getMainFrame());
        if (r != 0) {
            return;
        }
        filename = fc.getSelectedFile().getAbsolutePath();
        Object o = CSAMainFrame.deserialize(filename);
        if (o == null) {
            LogPanel log = (LogPanel)Configuration.getConfiguration().getDebugEntity();
            log.addLog("Deserialization of breakpoints failed!");
            return;
        }
        ArrayList[] allBreakpoints = (ArrayList[])o;
        this.vecxPanel.setAllBreakpoints(allBreakpoints);
        this.init();
        this.dissi.updateTableOnly();
    }

    public void saveBreakpoints() {
        ArrayList<Breakpoint>[] allBreakpoints = this.vecxPanel.getAllBreakpoints();
        String filename = Global.mainPathPrefix + "serialize";
        InternalFrameFileChoser fc = new InternalFrameFileChoser();
        Path p = Paths.get(filename, new String[0]);
        fc.setCurrentDirectory(new File(p.toString()));
        FileNameExtensionFilter filter = new FileNameExtensionFilter("Breakpoints", "brk");
        fc.setFileFilter(filter);
        int r = fc.showOpenDialog(Configuration.getConfiguration().getMainFrame());
        if (r != 0) {
            return;
        }
        filename = fc.getSelectedFile().getAbsolutePath();
        if (!(filename = UtilityString.replaceCI(filename, ".BRK", ".brk")).endsWith(".brk")) {
            filename = filename + ".brk";
        }
        CSAMainFrame.serialize(allBreakpoints, filename);
    }
}

