/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.vecx.panels;

import de.malban.Global;
import de.malban.config.Configuration;
import de.malban.gui.CSAMainFrame;
import de.malban.gui.Stateable;
import de.malban.gui.Windowable;
import de.malban.gui.components.CSAView;
import de.malban.gui.panels.LogPanel;
import de.malban.util.UtilityFiles;
import de.malban.util.UtilityString;
import de.malban.vide.VideConfig;
import de.malban.vide.dissy.DissiPanel;
import de.malban.vide.vecx.Updatable;
import de.malban.vide.vecx.VecXPanel;
import de.malban.vide.vecx.devices.Imager3dDevice;
import de.malban.vide.vecx.devices.ImagerWheel;
import de.malban.vide.vecx.devices.JoyportDevice;
import de.malban.vide.vecx.devices.LightpenDevice;
import de.malban.vide.vecx.devices.VecSpeechDevice;
import de.malban.vide.vecx.devices.VectrexJoyport;
import de.malban.vide.vecx.devices.WheelData;
import de.malban.vide.vecx.panels.WheelEdit;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class JoyportPanel
extends JPanel
implements Windowable,
Stateable,
Updatable {
    transient LogPanel log = (LogPanel)Configuration.getConfiguration().getDebugEntity();
    public VideConfig config = VideConfig.getConfig();
    private CSAView mParent = null;
    private JMenuItem mParentMenuItem = null;
    private int mClassSetting = 0;
    private VecXPanel vecxPanel = null;
    private DissiPanel dissi = null;
    public static String SID = "Debug: Devices";
    boolean nameChanged = false;
    WheelData currentWheel = null;
    private ButtonGroup buttonGroup1;
    private ButtonGroup buttonGroup2;
    private ButtonGroup buttonGroup3;
    private ImagerWheel imagerWheel1;
    private JButton jButton1;
    private JButton jButtonWRTracker;
    private JCheckBox jCheckBox1;
    private JCheckBox jCheckBox2;
    private JCheckBox jCheckBox3;
    private JCheckBox jCheckBox4;
    private JCheckBox jCheckBoxAnaglyphic;
    private JComboBox jComboBox1;
    private JComboBox jComboBoxWheelList;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel16;
    private JLabel jLabel17;
    private JLabel jLabel18;
    private JLabel jLabel19;
    private JLabel jLabel2;
    private JLabel jLabel20;
    private JLabel jLabel21;
    private JLabel jLabel22;
    private JLabel jLabel23;
    private JLabel jLabel24;
    private JLabel jLabel25;
    private JLabel jLabel26;
    private JLabel jLabel27;
    private JLabel jLabel28;
    private JLabel jLabel29;
    private JLabel jLabel3;
    private JLabel jLabel30;
    private JLabel jLabel31;
    private JLabel jLabel32;
    private JLabel jLabel33;
    private JLabel jLabel34;
    private JLabel jLabel35;
    private JLabel jLabel36;
    private JLabel jLabel37;
    private JLabel jLabel38;
    private JLabel jLabel39;
    private JLabel jLabel4;
    private JLabel jLabel40;
    private JLabel jLabel41;
    private JLabel jLabel42;
    private JLabel jLabel43;
    private JLabel jLabel44;
    private JLabel jLabel45;
    private JLabel jLabel46;
    private JLabel jLabel47;
    private JLabel jLabel48;
    private JLabel jLabel49;
    private JLabel jLabel5;
    private JLabel jLabel50;
    private JLabel jLabel51;
    private JLabel jLabel52;
    private JLabel jLabel53;
    private JLabel jLabel54;
    private JLabel jLabel55;
    private JLabel jLabel56;
    private JLabel jLabel57;
    private JLabel jLabel58;
    private JLabel jLabel59;
    private JLabel jLabel6;
    private JLabel jLabel60;
    private JLabel jLabel61;
    private JLabel jLabel62;
    private JLabel jLabel63;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JRadioButton jRadioButton1;
    private JRadioButton jRadioButton2;
    private JSlider jSlider1;
    private JSlider jSlider2;
    private JSlider jSlider3;
    private JSlider jSlider4;
    private JSlider jSlider5;
    private JSlider jSlider6;
    private JTabbedPane jTabbedPane2;
    private JTextField jTextField1;
    private JTextField jTextField10;
    private JTextField jTextField11;
    private JTextField jTextField12;
    private JTextField jTextField13;
    private JTextField jTextField14;
    private JTextField jTextField15;
    private JTextField jTextField16;
    private JTextField jTextField17;
    private JTextField jTextField18;
    private JTextField jTextField19;
    private JTextField jTextField2;
    private JTextField jTextField20;
    private JTextField jTextField21;
    private JTextField jTextField22;
    private JTextField jTextField23;
    private JTextField jTextField24;
    private JTextField jTextField25;
    private JTextField jTextField26;
    private JTextField jTextField27;
    private JTextField jTextField28;
    private JTextField jTextField29;
    private JTextField jTextField3;
    private JTextField jTextField30;
    private JTextField jTextField31;
    private JTextField jTextField32;
    private JTextField jTextField33;
    private JTextField jTextField34;
    private JTextField jTextField35;
    private JTextField jTextField36;
    private JTextField jTextField37;
    private JTextField jTextField38;
    private JTextField jTextField39;
    private JTextField jTextField4;
    private JTextField jTextField40;
    private JTextField jTextField41;
    private JTextField jTextField42;
    private JTextField jTextField43;
    private JTextField jTextField44;
    private JTextField jTextField45;
    private JTextField jTextField46;
    private JTextField jTextField47;
    private JTextField jTextField48;
    private JTextField jTextField49;
    private JTextField jTextField5;
    private JTextField jTextField50;
    private JTextField jTextField51;
    private JTextField jTextField6;
    private JTextField jTextField7;
    private JTextField jTextField8;
    private JTextField jTextField9;
    private JToggleButton jToggleButton1;
    private boolean updateEnabled = false;

    @Override
    public boolean isLoadSettings() {
        return true;
    }

    @Override
    public String getID() {
        return SID;
    }

    @Override
    public String getFileID() {
        return UtilityString.replace(UtilityString.replace(UtilityString.replace(UtilityString.replaceWhiteSpaces(SID, ""), ":", ""), "(", ""), ")", "");
    }

    @Override
    public Serializable getAdditionalStateinfo() {
        return null;
    }

    @Override
    public void setAdditionalStateinfo(Serializable ser) {
    }

    public void setDissi(DissiPanel v) {
        this.dissi = v;
        if (this.dissi == null) {
            return;
        }
    }

    public void setVecxy(VecXPanel v) {
        this.vecxPanel = v;
    }

    @Override
    public boolean isIcon() {
        CSAMainFrame frame = Configuration.getConfiguration().getMainFrame();
        if (frame.getInternalFrame(this) == null) {
            return false;
        }
        return frame.getInternalFrame(this).isIcon();
    }

    @Override
    public void setIcon(boolean b) {
        CSAMainFrame frame = Configuration.getConfiguration().getMainFrame();
        if (frame.getInternalFrame(this) == null) {
            return;
        }
        try {
            frame.getInternalFrame(this).setIcon(b);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void closing() {
        if (this.vecxPanel != null) {
            this.vecxPanel.resetDevice();
        }
        this.deinit();
    }

    @Override
    public void setParentWindow(CSAView jpv) {
        this.mParent = jpv;
    }

    @Override
    public void setMenuItem(JMenuItem item) {
        this.mParentMenuItem = item;
        this.mParentMenuItem.setText(SID);
    }

    @Override
    public JMenuItem getMenuItem() {
        return this.mParentMenuItem;
    }

    @Override
    public JPanel getPanel() {
        return this;
    }

    public void deinit() {
    }

    public JoyportPanel() {
        this.initComponents();
        this.initWheelList();
    }

    private void update() {
        if (this.vecxPanel == null) {
            return;
        }
        this.updateDevice();
        this.updateLightpen();
        this.updateVecVox();
        this.updateVecVoice();
        boolean ok = this.updateImager();
    }

    void updateDevice() {
        int port = this.jComboBox1.getSelectedIndex();
        if (port < 0 || port > 1) {
            return;
        }
        VectrexJoyport[] portDevices = this.vecxPanel.getJoyportDevices();
        if (portDevices == null) {
            return;
        }
        VectrexJoyport portDevice = portDevices[port];
        if (portDevice == null) {
            return;
        }
        if (portDevice.isButton1(false)) {
            this.jTextField1.setText("released");
        } else {
            this.jTextField1.setText("pressed");
        }
        if (portDevice.isButton2(false)) {
            this.jTextField2.setText("released");
        } else {
            this.jTextField2.setText("pressed");
        }
        if (portDevice.isButton3(false)) {
            this.jTextField3.setText("released");
        } else {
            this.jTextField3.setText("pressed");
        }
        if (portDevice.isButton4(false)) {
            this.jTextField4.setText("released");
        } else {
            this.jTextField4.setText("pressed");
        }
        int x = portDevice.getHorizontal() & 0xFF;
        if (x == 128) {
            this.jTextField5.setText("no");
        } else if (x > 128) {
            this.jTextField5.setText("right");
        } else {
            this.jTextField5.setText("left");
        }
        this.jTextField6.setText("$" + String.format("%02X", x));
        int y = portDevice.getVertical() & 0xFF;
        if (y == 128) {
            this.jTextField7.setText("no");
        } else if (y > 128) {
            this.jTextField7.setText("up");
        } else {
            this.jTextField7.setText("down");
        }
        this.jTextField8.setText("$" + String.format("%02X", y));
    }

    void updateLightpen() {
        int port = this.jComboBox1.getSelectedIndex();
        if (port < 0 || port > 1) {
            return;
        }
        VectrexJoyport[] portDevices = this.vecxPanel.getJoyportDevices();
        if (portDevices == null) {
            return;
        }
        VectrexJoyport portDevice = portDevices[port];
        if (portDevice == null) {
            return;
        }
        JoyportDevice device = portDevice.getDevice();
        if (device == null) {
            return;
        }
        if (!(device instanceof LightpenDevice)) {
            return;
        }
        LightpenDevice lightpen = (LightpenDevice)device;
        int x = lightpen.lightpenX;
        if (x == -100000) {
            this.jTextField9.setText("n/a");
        } else {
            int calc_x = x - this.config.ALG_MAX_X / 2;
            boolean neg = calc_x < 0;
            int pos = Math.abs(calc_x) & 0xFFFF;
            if (neg) {
                this.jTextField9.setText("-$" + String.format("%04X", pos));
            } else {
                this.jTextField9.setText("$" + String.format("%04X", pos));
            }
        }
        int y = lightpen.lightpenY;
        if (y == -100000) {
            this.jTextField10.setText("n/a");
        } else {
            int calc_y = y - this.config.ALG_MAX_Y / 2;
            boolean neg = calc_y < 0;
            int pos = Math.abs(calc_y) & 0xFFFF;
            if (neg) {
                this.jTextField10.setText("-$" + String.format("%04X", pos));
            } else {
                this.jTextField10.setText("$" + String.format("%04X", pos));
            }
        }
    }

    void updateVecVox() {
        int port = this.jComboBox1.getSelectedIndex();
        if (port < 0 || port > 1) {
            return;
        }
        VectrexJoyport[] portDevices = this.vecxPanel.getJoyportDevices();
        if (portDevices == null) {
            return;
        }
        VectrexJoyport portDevice = portDevices[port];
        if (portDevice == null) {
            return;
        }
        JoyportDevice device = portDevice.getDevice();
        if (device == null) {
            return;
        }
        if (!(device instanceof VecSpeechDevice)) {
            return;
        }
        VecSpeechDevice vox = (VecSpeechDevice)device;
        if (vox.isVecVoice()) {
            return;
        }
        this.jTextField15.setText("" + vox.getLowLevelState());
        this.jTextField22.setText("" + vox.getSyncCycles());
        this.jTextField18.setText("" + vox.getBitCounterFromVectrex());
        this.jTextField25.setText("" + vox.getBitFromVectrex());
        this.jTextField19.setText("" + vox.getInputLine());
        this.jTextField23.setText("" + vox.getCommand());
        this.jTextField30.setText("" + (int)(vox.getSpVolume() * 127.0));
        this.jTextField29.setText("" + vox.getSpTempo());
        this.jTextField31.setText("" + vox.getSpPitch());
        this.jTextField34.setText("" + vox.getSpBend());
        this.jTextField35.setText("" + vox.getSpRepeat());
        this.jTextField36.setText("" + vox.getSpDelay());
        this.jTextField27.setText(vox.isSpNextFast() ? "yes" : "no");
        this.jTextField28.setText(vox.isSpNextSlow() ? "yes" : "no");
        this.jTextField32.setText(vox.isSpNextStress() ? "yes" : "no");
        this.jTextField33.setText(vox.isSpNextRelax() ? "yes" : "no");
        this.jTextField37.setText("" + vox.getQueueLength());
    }

    void updateVecVoice() {
        int port = this.jComboBox1.getSelectedIndex();
        if (port < 0 || port > 1) {
            return;
        }
        VectrexJoyport[] portDevices = this.vecxPanel.getJoyportDevices();
        if (portDevices == null) {
            return;
        }
        VectrexJoyport portDevice = portDevices[port];
        if (portDevice == null) {
            return;
        }
        JoyportDevice device = portDevice.getDevice();
        if (device == null) {
            return;
        }
        if (!(device instanceof VecSpeechDevice)) {
            return;
        }
        VecSpeechDevice vox = (VecSpeechDevice)device;
        if (!vox.isVecVoice()) {
            return;
        }
        this.jTextField16.setText("" + vox.getLowLevelState());
        this.jTextField24.setText("" + vox.getSyncCycles());
        this.jTextField20.setText("" + vox.getBitCounterFromVectrex());
        this.jTextField38.setText("" + vox.getBitFromVectrex());
        this.jTextField21.setText("" + vox.getInputLine());
        this.jTextField26.setText("" + vox.getCommand());
        this.jTextField49.setText("" + vox.getQueueLength());
    }

    boolean updateImager() {
        this.jCheckBox3.setSelected(false);
        int port = this.jComboBox1.getSelectedIndex();
        if (port < 0 || port > 1) {
            return false;
        }
        VectrexJoyport[] portDevices = this.vecxPanel.getJoyportDevices();
        if (portDevices == null) {
            return false;
        }
        VectrexJoyport portDevice = portDevices[port];
        if (portDevice == null) {
            return false;
        }
        JoyportDevice device = portDevice.getDevice();
        if (device == null) {
            return false;
        }
        if (!(device instanceof Imager3dDevice)) {
            return false;
        }
        Imager3dDevice imager = (Imager3dDevice)device;
        WheelData d = imager.getWheel();
        if (d == null) {
            this.currentWheel = null;
            return false;
        }
        if (this.currentWheel == null) {
            this.currentWheel = d;
            this.setCurrentWheelAsSelection();
            this.initWheel();
        } else if (this.currentWheel.id != d.id) {
            this.currentWheel = d;
            this.setCurrentWheelAsSelection();
            this.initWheel();
        }
        this.imagerWheel1.setAngle(imager.getAngle());
        this.jCheckBox3.setSelected(true);
        if (this.jRadioButton2.isSelected()) {
            this.jTextField11.setText("" + String.format("%.4f", imager.getSpinPerSecond()));
        }
        this.jTextField14.setText("" + String.format("%.2f", 360.0 - imager.getAngle()));
        double spinTime = 1.0 / imager.getSpinPerSecond();
        this.jTextField44.setText("" + String.format("%.6f", spinTime));
        this.jTextField17.setText("" + imager.getCyclePerSpin());
        this.jTextField39.setText("" + String.format("%.6f", imager.getAnglePerCycle()));
        long low = imager.getPulseLen();
        long wlen = imager.getWaveLen();
        this.jTextField12.setText("" + low);
        this.jTextField13.setText("" + wlen);
        double lowMS = (double)low * 6.666666666666667E-7;
        double highMS = (double)wlen * 6.666666666666667E-7;
        this.jTextField41.setText("" + String.format("%.6f", lowMS));
        this.jTextField40.setText("" + String.format("%.6f", highMS));
        long indexPulse = imager.getLastIndexPulse();
        this.jTextField42.setText("" + indexPulse + "(" + imager.getReallyLastIndexPulse() + ")");
        double indexPulseMS = (double)indexPulse * 6.666666666666667E-7;
        this.jTextField43.setText("" + String.format("%.6f", indexPulseMS));
        int colorIndexLeft = imager.getLeftColor();
        if (colorIndexLeft >= 0) {
            this.jCheckBox1.setBackground(imager.getWheel().colors[colorIndexLeft]);
        } else {
            this.jCheckBox1.setBackground(Color.white);
        }
        int colorIndexRight = imager.getRightColor();
        if (colorIndexRight >= 0) {
            this.jCheckBox2.setBackground(imager.getWheel().colors[colorIndexRight]);
        } else {
            this.jCheckBox2.setBackground(Color.white);
        }
        if (this.jRadioButton2.isSelected()) {
            this.jSlider1.setValue((int)imager.getSpinPerSecond());
        }
        double percent = (double)low / (double)wlen;
        this.jTextField51.setText("" + String.format("%.2f", percent));
        this.setTimerValues();
        return true;
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.buttonGroup2 = new ButtonGroup();
        this.buttonGroup3 = new ButtonGroup();
        this.jToggleButton1 = new JToggleButton();
        this.jTabbedPane2 = new JTabbedPane();
        this.jPanel4 = new JPanel();
        this.jLabel8 = new JLabel();
        this.jTextField9 = new JTextField();
        this.jTextField10 = new JTextField();
        this.jLabel9 = new JLabel();
        this.jLabel10 = new JLabel();
        this.jPanel1 = new JPanel();
        this.jTextField18 = new JTextField();
        this.jLabel20 = new JLabel();
        this.jLabel16 = new JLabel();
        this.jTextField15 = new JTextField();
        this.jLabel23 = new JLabel();
        this.jTextField22 = new JTextField();
        this.jLabel19 = new JLabel();
        this.jLabel24 = new JLabel();
        this.jTextField23 = new JTextField();
        this.jTextField25 = new JTextField();
        this.jLabel25 = new JLabel();
        this.jTextField27 = new JTextField();
        this.jLabel26 = new JLabel();
        this.jTextField28 = new JTextField();
        this.jLabel27 = new JLabel();
        this.jLabel28 = new JLabel();
        this.jTextField29 = new JTextField();
        this.jTextField30 = new JTextField();
        this.jLabel29 = new JLabel();
        this.jTextField31 = new JTextField();
        this.jLabel30 = new JLabel();
        this.jTextField32 = new JTextField();
        this.jTextField33 = new JTextField();
        this.jLabel31 = new JLabel();
        this.jLabel32 = new JLabel();
        this.jTextField34 = new JTextField();
        this.jLabel33 = new JLabel();
        this.jTextField35 = new JTextField();
        this.jLabel34 = new JLabel();
        this.jTextField36 = new JTextField();
        this.jLabel11 = new JLabel();
        this.jTextField37 = new JTextField();
        this.jLabel12 = new JLabel();
        this.jTextField19 = new JTextField();
        this.jPanel2 = new JPanel();
        this.jTextField20 = new JTextField();
        this.jLabel21 = new JLabel();
        this.jLabel17 = new JLabel();
        this.jTextField16 = new JTextField();
        this.jLabel35 = new JLabel();
        this.jTextField24 = new JTextField();
        this.jLabel22 = new JLabel();
        this.jLabel36 = new JLabel();
        this.jTextField26 = new JTextField();
        this.jTextField38 = new JTextField();
        this.jLabel13 = new JLabel();
        this.jTextField49 = new JTextField();
        this.jLabel14 = new JLabel();
        this.jTextField21 = new JTextField();
        this.jPanel3 = new JPanel();
        this.jPanel5 = new JPanel();
        this.imagerWheel1 = new ImagerWheel();
        this.jCheckBox1 = new JCheckBox();
        this.jCheckBox2 = new JCheckBox();
        this.jCheckBox4 = new JCheckBox();
        this.jCheckBoxAnaglyphic = new JCheckBox();
        this.jSlider1 = new JSlider();
        this.jLabel15 = new JLabel();
        this.jTextField11 = new JTextField();
        this.jLabel18 = new JLabel();
        this.jLabel37 = new JLabel();
        this.jLabel38 = new JLabel();
        this.jTextField12 = new JTextField();
        this.jTextField13 = new JTextField();
        this.jRadioButton1 = new JRadioButton();
        this.jRadioButton2 = new JRadioButton();
        this.jCheckBox3 = new JCheckBox();
        this.jLabel39 = new JLabel();
        this.jLabel40 = new JLabel();
        this.jLabel41 = new JLabel();
        this.jTextField14 = new JTextField();
        this.jTextField17 = new JTextField();
        this.jTextField39 = new JTextField();
        this.jTextField40 = new JTextField();
        this.jTextField41 = new JTextField();
        this.jLabel42 = new JLabel();
        this.jLabel43 = new JLabel();
        this.jTextField42 = new JTextField();
        this.jLabel44 = new JLabel();
        this.jTextField43 = new JTextField();
        this.jTextField44 = new JTextField();
        this.jLabel45 = new JLabel();
        this.jLabel46 = new JLabel();
        this.jLabel47 = new JLabel();
        this.jLabel48 = new JLabel();
        this.jLabel49 = new JLabel();
        this.jButton1 = new JButton();
        this.jPanel6 = new JPanel();
        this.jLabel50 = new JLabel();
        this.jTextField45 = new JTextField();
        this.jSlider2 = new JSlider();
        this.jSlider3 = new JSlider();
        this.jTextField46 = new JTextField();
        this.jLabel51 = new JLabel();
        this.jSlider4 = new JSlider();
        this.jTextField47 = new JTextField();
        this.jLabel52 = new JLabel();
        this.jLabel53 = new JLabel();
        this.jTextField48 = new JTextField();
        this.jSlider5 = new JSlider();
        this.jLabel54 = new JLabel();
        this.jTextField50 = new JTextField();
        this.jSlider6 = new JSlider();
        this.jLabel56 = new JLabel();
        this.jLabel57 = new JLabel();
        this.jLabel58 = new JLabel();
        this.jLabel59 = new JLabel();
        this.jLabel60 = new JLabel();
        this.jLabel61 = new JLabel();
        this.jLabel62 = new JLabel();
        this.jLabel63 = new JLabel();
        this.jTextField51 = new JTextField();
        this.jLabel55 = new JLabel();
        this.jComboBoxWheelList = new JComboBox();
        this.jButtonWRTracker = new JButton();
        this.jComboBox1 = new JComboBox();
        this.jLabel4 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jTextField3 = new JTextField();
        this.jLabel5 = new JLabel();
        this.jTextField4 = new JTextField();
        this.jLabel1 = new JLabel();
        this.jTextField1 = new JTextField();
        this.jLabel2 = new JLabel();
        this.jTextField2 = new JTextField();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jTextField7 = new JTextField();
        this.jTextField8 = new JTextField();
        this.jTextField6 = new JTextField();
        this.jTextField5 = new JTextField();
        this.setName("regi");
        this.jToggleButton1.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/webcam.png")));
        this.jToggleButton1.setToolTipText("Toggle Update (always or only while debug)");
        this.jToggleButton1.setMargin(new Insets(0, 1, 0, -1));
        this.jToggleButton1.setSelectedIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/webcamSelect.png")));
        this.jToggleButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JoyportPanel.this.jToggleButton1ActionPerformed(evt);
            }
        });
        this.jLabel8.setText("X Pos");
        this.jLabel9.setText("Y Pos");
        this.jLabel10.setForeground(new Color(102, 102, 102));
        this.jLabel10.setText("in vectrex coordinates");
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addComponent(this.jLabel8).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextField9, -2, 80, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel10)).addGroup(jPanel4Layout.createSequentialGroup().addComponent(this.jLabel9).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextField10, -2, 80, -2))).addContainerGap(381, Short.MAX_VALUE)));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel8).addComponent(this.jTextField9, -2, 21, -2).addComponent(this.jLabel10)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel9).addComponent(this.jTextField10, -2, 21, -2)).addContainerGap(510, Short.MAX_VALUE)));
        this.jTabbedPane2.addTab("Lightpen", this.jPanel4);
        this.jTextField18.setToolTipText("in from vectrex");
        this.jLabel20.setText("current bit");
        this.jLabel16.setText("low level state");
        this.jLabel23.setText("sync cycles");
        this.jLabel19.setText("bit counter");
        this.jLabel24.setText("command");
        this.jTextField25.setToolTipText("in from vectrex");
        this.jLabel25.setText("next fast");
        this.jTextField27.setToolTipText("in from vectrex");
        this.jLabel26.setText("next slow");
        this.jTextField28.setToolTipText("in from vectrex");
        this.jLabel27.setText("volume");
        this.jLabel28.setText("tempo");
        this.jTextField29.setToolTipText("in from vectrex");
        this.jTextField30.setToolTipText("in from vectrex");
        this.jLabel29.setText("pitch");
        this.jTextField31.setToolTipText("in from vectrex");
        this.jLabel30.setText("next stress");
        this.jTextField32.setToolTipText("in from vectrex");
        this.jTextField33.setToolTipText("in from vectrex");
        this.jLabel31.setText("next relax");
        this.jLabel32.setText("bend");
        this.jTextField34.setToolTipText("in from vectrex");
        this.jLabel33.setText("repeat");
        this.jTextField35.setToolTipText("in from vectrex");
        this.jLabel34.setText("delay");
        this.jTextField36.setToolTipText("in from vectrex");
        this.jLabel11.setText("queue length");
        this.jTextField37.setToolTipText("in from vectrex");
        this.jLabel12.setText("input line");
        this.jTextField19.setToolTipText("in from vectrex");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel29).addComponent(this.jLabel33).addComponent(this.jLabel34).addComponent(this.jLabel27).addComponent(this.jLabel28).addComponent(this.jLabel32).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jLabel24, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel16, -1, -1, Short.MAX_VALUE)).addComponent(this.jLabel12)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextField15, -2, 220, -2).addComponent(this.jTextField19, -2, 28, -2).addComponent(this.jTextField23, -2, 78, -2).addComponent(this.jTextField30, -2, 30, -2).addComponent(this.jTextField29, -2, 30, -2).addComponent(this.jTextField31, -2, 30, -2).addComponent(this.jTextField34, -2, 30, -2).addComponent(this.jTextField35, -2, 30, -2).addComponent(this.jTextField36, -2, 30, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel23).addComponent(this.jLabel19, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel20).addComponent(this.jLabel11).addComponent(this.jLabel31).addComponent(this.jLabel25).addComponent(this.jLabel30).addComponent(this.jLabel26)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextField22, -2, 80, -2).addComponent(this.jTextField18, -2, 30, -2).addComponent(this.jTextField25).addComponent(this.jTextField37, -2, 30, -2).addComponent(this.jTextField27, -2, 30, -2).addComponent(this.jTextField28, -2, 30, -2).addComponent(this.jTextField32, -2, 30, -2).addComponent(this.jTextField33, -2, 30, -2)).addContainerGap(149, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel16).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel23).addComponent(this.jTextField22, -2, 21, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextField18, -2, 21, -2).addComponent(this.jLabel19).addComponent(this.jLabel12).addComponent(this.jTextField19, -2, 21, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextField25, -2, 21, -2).addComponent(this.jLabel20)).addGap(13, 13, 13)).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addComponent(this.jTextField15, -2, 21, -2).addGap(68, 68, 68).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextField23, -2, 21, -2).addComponent(this.jLabel24).addComponent(this.jLabel11).addComponent(this.jTextField37, -2, 21, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel25).addComponent(this.jTextField27, -2, 21, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel26).addComponent(this.jTextField28, -2, 21, -2))).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel27).addComponent(this.jTextField30, -2, 21, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel28).addComponent(this.jTextField29, -2, 21, -2)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED))).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel29).addComponent(this.jTextField31, -2, 21, -2)).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel30).addComponent(this.jTextField32, -2, 21, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel31).addComponent(this.jTextField33, -2, 21, -2).addComponent(this.jLabel32).addComponent(this.jTextField34, -2, 21, -2)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel33).addComponent(this.jTextField35, -2, 21, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel34).addComponent(this.jTextField36, -2, 21, -2)).addContainerGap(286, Short.MAX_VALUE)));
        this.jTabbedPane2.addTab("VecVox", this.jPanel1);
        this.jTextField20.setToolTipText("in from vectrex");
        this.jLabel21.setText("current bit");
        this.jLabel17.setText("low level state");
        this.jLabel35.setText("sync cycles");
        this.jLabel22.setText("bit counter");
        this.jLabel36.setText("command");
        this.jTextField38.setToolTipText("in from vectrex");
        this.jLabel13.setText("queue length");
        this.jTextField49.setToolTipText("in from vectrex");
        this.jLabel14.setText("input line");
        this.jTextField21.setToolTipText("in from vectrex");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel17).addComponent(this.jLabel14).addComponent(this.jLabel36)).addGap(6, 6, 6).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextField16, -2, 220, -2).addComponent(this.jTextField21, -2, 28, -2).addComponent(this.jTextField26, -2, 78, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel35).addComponent(this.jLabel22, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel21)).addGap(15, 15, 15)).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabel13).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, -1, Short.MAX_VALUE))).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextField38).addComponent(this.jTextField20, -2, 30, -2).addComponent(this.jTextField24, -2, 80, -2).addComponent(this.jTextField49, -2, 30, -2)).addContainerGap(149, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel17).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel35).addComponent(this.jTextField24, -2, 21, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextField20, -2, 21, -2).addComponent(this.jLabel22).addComponent(this.jLabel14).addComponent(this.jTextField21, -2, 21, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextField38, -2, 21, -2).addComponent(this.jLabel21))).addComponent(this.jTextField16, -2, 21, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextField26, -2, 21, -2).addComponent(this.jLabel36)).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel13).addComponent(this.jTextField49, -2, 21, -2))).addContainerGap(456, Short.MAX_VALUE)));
        this.jTabbedPane2.addTab("VecVoice", this.jPanel2);
        this.jPanel5.setPreferredSize(new Dimension(600, 536));
        this.imagerWheel1.setBorder(BorderFactory.createBevelBorder(0));
        this.jCheckBox1.setText("left");
        this.jCheckBox1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JoyportPanel.this.jCheckBox1ActionPerformed(evt);
            }
        });
        this.jCheckBox2.setText("right");
        this.jCheckBox2.setHorizontalTextPosition(10);
        this.jCheckBox2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JoyportPanel.this.jCheckBox2ActionPerformed(evt);
            }
        });
        this.jCheckBox4.setText("b/w");
        this.jCheckBox4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JoyportPanel.this.jCheckBox4ActionPerformed(evt);
            }
        });
        this.jCheckBoxAnaglyphic.setText("anaglyphic");
        this.jCheckBoxAnaglyphic.setHorizontalTextPosition(10);
        this.jCheckBoxAnaglyphic.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JoyportPanel.this.jCheckBoxAnaglyphicActionPerformed(evt);
            }
        });
        GroupLayout imagerWheel1Layout = new GroupLayout(this.imagerWheel1);
        this.imagerWheel1.setLayout(imagerWheel1Layout);
        imagerWheel1Layout.setHorizontalGroup(imagerWheel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(imagerWheel1Layout.createSequentialGroup().addComponent(this.jCheckBox1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 164, Short.MAX_VALUE).addComponent(this.jCheckBox2)).addGroup(imagerWheel1Layout.createSequentialGroup().addComponent(this.jCheckBox4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 147, Short.MAX_VALUE).addComponent(this.jCheckBoxAnaglyphic)));
        imagerWheel1Layout.setVerticalGroup(imagerWheel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(imagerWheel1Layout.createSequentialGroup().addGroup(imagerWheel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBox1).addComponent(this.jCheckBox2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(imagerWheel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBox4).addComponent(this.jCheckBoxAnaglyphic)).addGap(0, 504, Short.MAX_VALUE)));
        this.jSlider1.setMajorTickSpacing(10);
        this.jSlider1.setMaximum(30);
        this.jSlider1.setMinorTickSpacing(1);
        this.jSlider1.setPaintLabels(true);
        this.jSlider1.setPaintTicks(true);
        this.jSlider1.setSnapToTicks(true);
        this.jSlider1.setValue(0);
        this.jSlider1.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                JoyportPanel.this.jSlider1StateChanged(evt);
            }
        });
        this.jLabel15.setText("spin per second");
        this.jTextField11.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                JoyportPanel.this.jTextField11FocusLost(evt);
            }
        });
        this.jTextField11.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JoyportPanel.this.jTextField11ActionPerformed(evt);
            }
        });
        this.jLabel18.setText("vectrex pulse");
        this.jLabel37.setText("low");
        this.jLabel38.setText("len");
        this.buttonGroup3.add(this.jRadioButton1);
        this.jRadioButton1.setSelected(true);
        this.jRadioButton1.setText("manual");
        this.jRadioButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JoyportPanel.this.jRadioButton1ActionPerformed(evt);
            }
        });
        this.buttonGroup3.add(this.jRadioButton2);
        this.jRadioButton2.setText("auto");
        this.jRadioButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JoyportPanel.this.jRadioButton2ActionPerformed(evt);
            }
        });
        this.jCheckBox3.setText("available");
        this.jLabel39.setText("current Angle");
        this.jLabel40.setText("cycles per Spin");
        this.jLabel41.setText("angle per cycle");
        this.jLabel42.setText("cycles");
        this.jLabel43.setText("s");
        this.jLabel44.setText("index pulse");
        this.jTextField44.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                JoyportPanel.this.jTextField44FocusLost(evt);
            }
        });
        this.jTextField44.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JoyportPanel.this.jTextField44ActionPerformed(evt);
            }
        });
        this.jLabel45.setText("s");
        this.jLabel46.setText("cycles");
        this.jLabel47.setText("cycles");
        this.jLabel48.setText("s");
        this.jLabel49.setForeground(new Color(102, 102, 102));
        this.jLabel49.setText("looking through the imager");
        this.jButton1.setText("default");
        this.jButton1.setMargin(new Insets(0, 1, 0, -1));
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JoyportPanel.this.jButton1ActionPerformed(evt);
            }
        });
        this.jLabel50.setText("sync led");
        this.jSlider2.setMajorTickSpacing(10);
        this.jSlider2.setMaximum(360);
        this.jSlider2.setMinorTickSpacing(1);
        this.jSlider2.setOrientation(1);
        this.jSlider2.setPaintTicks(true);
        this.jSlider2.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                JoyportPanel.this.jSlider2StateChanged(evt);
            }
        });
        this.jSlider3.setMajorTickSpacing(10);
        this.jSlider3.setMaximum(360);
        this.jSlider3.setMinorTickSpacing(1);
        this.jSlider3.setOrientation(1);
        this.jSlider3.setPaintTicks(true);
        this.jSlider3.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                JoyportPanel.this.jSlider3StateChanged(evt);
            }
        });
        this.jLabel51.setText("sync hole");
        this.jSlider4.setMajorTickSpacing(10);
        this.jSlider4.setMaximum(360);
        this.jSlider4.setMinimum(180);
        this.jSlider4.setMinorTickSpacing(1);
        this.jSlider4.setOrientation(1);
        this.jSlider4.setPaintTicks(true);
        this.jSlider4.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                JoyportPanel.this.jSlider4StateChanged(evt);
            }
        });
        this.jLabel52.setText("angle 1");
        this.jLabel53.setText("angle 2");
        this.jSlider5.setMajorTickSpacing(10);
        this.jSlider5.setMaximum(360);
        this.jSlider5.setMinimum(180);
        this.jSlider5.setMinorTickSpacing(1);
        this.jSlider5.setOrientation(1);
        this.jSlider5.setPaintTicks(true);
        this.jSlider5.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                JoyportPanel.this.jSlider5StateChanged(evt);
            }
        });
        this.jLabel54.setText("angle 3");
        this.jSlider6.setMajorTickSpacing(10);
        this.jSlider6.setMaximum(360);
        this.jSlider6.setMinimum(180);
        this.jSlider6.setMinorTickSpacing(1);
        this.jSlider6.setOrientation(1);
        this.jSlider6.setPaintTicks(true);
        this.jSlider6.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                JoyportPanel.this.jSlider6StateChanged(evt);
            }
        });
        this.jLabel56.setFont(new Font("Courier New", 0, 10));
        this.jLabel56.setText("0x0000");
        this.jLabel56.setToolTipText("start at cycles [relation to index whole]");
        this.jLabel57.setText("right");
        this.jLabel57.setToolTipText("start at cycles [relation to index whole]");
        this.jLabel58.setText("left");
        this.jLabel58.setToolTipText("start at cycles [relation to index whole]");
        this.jLabel59.setFont(new Font("Courier New", 0, 10));
        this.jLabel59.setText("0x0000");
        this.jLabel59.setToolTipText("start at cycles [relation to index whole]");
        this.jLabel60.setFont(new Font("Courier New", 0, 10));
        this.jLabel60.setText("0x0000");
        this.jLabel60.setToolTipText("start at cycles [relation to index whole]");
        this.jLabel61.setFont(new Font("Courier New", 0, 10));
        this.jLabel61.setText("0x0000");
        this.jLabel61.setToolTipText("start at cycles [relation to index whole]");
        this.jLabel62.setFont(new Font("Courier New", 0, 10));
        this.jLabel62.setText("0x0000");
        this.jLabel62.setToolTipText("start at cycles [relation to index whole]");
        this.jLabel63.setFont(new Font("Courier New", 0, 10));
        this.jLabel63.setText("0x0000");
        this.jLabel63.setToolTipText("start at cycles [relation to index whole]");
        GroupLayout jPanel6Layout = new GroupLayout(this.jPanel6);
        this.jPanel6.setLayout(jPanel6Layout);
        jPanel6Layout.setHorizontalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addContainerGap().addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel50).addComponent(this.jSlider2, -1, 45, Short.MAX_VALUE).addComponent(this.jTextField45)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel51).addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jSlider3, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jTextField46, GroupLayout.Alignment.LEADING, -1, 45, Short.MAX_VALUE))).addGap(27, 27, 27)).addGroup(GroupLayout.Alignment.TRAILING, jPanel6Layout.createSequentialGroup().addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel57).addComponent(this.jLabel58)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED))).addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel59).addComponent(this.jLabel56).addComponent(this.jTextField47, -1, 45, Short.MAX_VALUE).addComponent(this.jLabel52).addComponent(this.jSlider4, -1, -1, Short.MAX_VALUE)).addGap(20, 20, 20).addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel61).addComponent(this.jLabel60).addComponent(this.jTextField48, -1, 45, Short.MAX_VALUE).addComponent(this.jLabel53).addComponent(this.jSlider5, -1, -1, Short.MAX_VALUE)).addGap(20, 20, 20).addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel62).addComponent(this.jLabel63).addComponent(this.jLabel54).addComponent(this.jTextField50).addComponent(this.jSlider6, -1, 46, Short.MAX_VALUE)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel6Layout.setVerticalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel6Layout.createSequentialGroup().addComponent(this.jLabel54).addGap(4, 4, 4).addComponent(this.jTextField50, -2, 21, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSlider6, -2, 138, -2)).addGroup(jPanel6Layout.createSequentialGroup().addComponent(this.jLabel53).addGap(4, 4, 4).addComponent(this.jTextField48, -2, 21, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSlider5, -2, 138, -2)).addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addComponent(this.jLabel50).addGap(4, 4, 4).addComponent(this.jTextField45, -2, 21, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSlider2, -2, 138, -2)).addGroup(jPanel6Layout.createSequentialGroup().addComponent(this.jLabel51).addGap(4, 4, 4).addComponent(this.jTextField46, -2, 21, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSlider3, -2, 138, -2)).addGroup(jPanel6Layout.createSequentialGroup().addComponent(this.jLabel52).addGap(4, 4, 4).addComponent(this.jTextField47, -2, 21, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSlider4, -2, 138, -2)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel56, GroupLayout.Alignment.TRAILING).addComponent(this.jLabel61, GroupLayout.Alignment.TRAILING).addComponent(this.jLabel63, GroupLayout.Alignment.TRAILING).addComponent(this.jLabel57, GroupLayout.Alignment.TRAILING)).addGap(2, 2, 2).addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel62, GroupLayout.Alignment.TRAILING).addComponent(this.jLabel60, GroupLayout.Alignment.TRAILING).addComponent(this.jLabel59, GroupLayout.Alignment.TRAILING).addComponent(this.jLabel58, GroupLayout.Alignment.TRAILING))));
        this.jLabel55.setText("%");
        this.jComboBoxWheelList.setPreferredSize(new Dimension(120, 20));
        this.jComboBoxWheelList.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JoyportPanel.this.jComboBoxWheelListActionPerformed(evt);
            }
        });
        this.jButtonWRTracker.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/page_edit.png")));
        this.jButtonWRTracker.setToolTipText("show tracker");
        this.jButtonWRTracker.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonWRTracker.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JoyportPanel.this.jButtonWRTrackerActionPerformed(evt);
            }
        });
        GroupLayout jPanel5Layout = new GroupLayout(this.jPanel5);
        this.jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addComponent(this.imagerWheel1, -1, -1, Short.MAX_VALUE).addGap(6, 6, 6).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(jPanel5Layout.createSequentialGroup().addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel15, GroupLayout.Alignment.LEADING).addComponent(this.jLabel18, GroupLayout.Alignment.LEADING).addComponent(this.jLabel39, GroupLayout.Alignment.LEADING).addComponent(this.jLabel40, GroupLayout.Alignment.LEADING).addComponent(this.jLabel41, GroupLayout.Alignment.LEADING).addComponent(this.jLabel44, GroupLayout.Alignment.LEADING)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jTextField42).addComponent(this.jTextField39).addComponent(this.jTextField17).addComponent(this.jTextField14).addComponent(this.jRadioButton2).addComponent(this.jTextField41).addComponent(this.jTextField12).addComponent(this.jLabel37).addComponent(this.jTextField11).addComponent(this.jTextField43).addComponent(this.jTextField44, -2, 80, -2)).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addGap(5, 5, 5).addComponent(this.jLabel48)).addGroup(jPanel5Layout.createSequentialGroup().addGap(4, 4, 4).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jTextField13, -2, 80, -2).addComponent(this.jTextField40, -2, 80, -2).addGroup(jPanel5Layout.createSequentialGroup().addComponent(this.jLabel38).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextField51))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel43).addComponent(this.jLabel42).addComponent(this.jLabel55))).addGroup(jPanel5Layout.createSequentialGroup().addGap(4, 4, 4).addComponent(this.jRadioButton1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton1, -2, 109, -2)).addGroup(jPanel5Layout.createSequentialGroup().addGap(5, 5, 5).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel47).addComponent(this.jLabel45).addComponent(this.jLabel46)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSlider1, -2, 98, -2)).addGroup(jPanel5Layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonWRTracker, -2, 21, -2)).addGroup(jPanel5Layout.createSequentialGroup().addGap(6, 6, 6).addComponent(this.jComboBoxWheelList, -2, 192, -2))).addContainerGap()).addComponent(this.jPanel6, -1, -1, Short.MAX_VALUE))).addGroup(jPanel5Layout.createSequentialGroup().addComponent(this.jCheckBox3).addGap(18, 18, 18).addComponent(this.jLabel49).addGap(0, 0, Short.MAX_VALUE)));
        jPanel5Layout.setVerticalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel5Layout.createSequentialGroup().addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBox3).addComponent(this.jLabel49)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.imagerWheel1, -1, -1, Short.MAX_VALUE).addGroup(jPanel5Layout.createSequentialGroup().addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel39).addComponent(this.jTextField14, -2, 21, -2).addComponent(this.jComboBoxWheelList, -2, 21, -2)).addGap(5, 5, 5).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel40).addComponent(this.jTextField17, -2, 21, -2)).addComponent(this.jButtonWRTracker, -2, 21, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel41).addComponent(this.jTextField39, -2, 21, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel37).addComponent(this.jLabel38).addComponent(this.jTextField51, -2, 21, -2).addComponent(this.jLabel55)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel18).addComponent(this.jTextField12, -2, 21, -2).addComponent(this.jTextField13, -2, 21, -2).addComponent(this.jLabel42)).addGap(8, 8, 8).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextField41, -2, 21, -2).addComponent(this.jTextField40, -2, 21, -2).addComponent(this.jLabel43)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jRadioButton1).addComponent(this.jRadioButton2).addComponent(this.jButton1, -2, 21, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel15).addComponent(this.jTextField11, -2, 21, -2).addComponent(this.jLabel46)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextField44, -2, 21, -2).addComponent(this.jLabel45)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextField42, -2, 21, -2).addComponent(this.jLabel44).addComponent(this.jLabel47))).addComponent(this.jSlider1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextField43, -2, 21, -2).addComponent(this.jLabel48)).addGap(5, 5, 5).addComponent(this.jPanel6, -1, -1, Short.MAX_VALUE)))));
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel5, -1, 646, Short.MAX_VALUE));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel5, -1, 570, Short.MAX_VALUE));
        this.jTabbedPane2.addTab("Imager3d", this.jPanel3);
        this.jComboBox1.setModel(new DefaultComboBoxModel<String>(new String[]{"0", "1"}));
        this.jComboBox1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JoyportPanel.this.jComboBox1ActionPerformed(evt);
            }
        });
        this.jLabel4.setText("Port");
        this.jLabel3.setText("Button 3");
        this.jLabel5.setText("Button 4");
        this.jLabel1.setText("Button 1");
        this.jLabel2.setText("Button 2");
        this.jLabel6.setText("Horizontal");
        this.jLabel7.setText("Vertical");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addComponent(this.jToggleButton1, -2, 20, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jLabel4)).addComponent(this.jLabel3, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel5, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel1).addComponent(this.jLabel2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jTextField1, -1, 80, Short.MAX_VALUE).addComponent(this.jTextField2, -1, 80, Short.MAX_VALUE).addComponent(this.jTextField3, -1, 80, Short.MAX_VALUE).addComponent(this.jTextField4, -1, 80, Short.MAX_VALUE).addComponent(this.jComboBox1, 0, -1, Short.MAX_VALUE)).addGap(35, 35, 35).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel6).addComponent(this.jLabel7)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextField5, -2, 80, -2).addComponent(this.jTextField7, -2, 80, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jTextField6, -1, 80, Short.MAX_VALUE).addComponent(this.jTextField8, -1, 80, Short.MAX_VALUE)).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jTabbedPane2))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(2, 2, 2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jToggleButton1, -2, 20, -2).addComponent(this.jLabel4, -2, 21, -2).addComponent(this.jComboBox1, -2, 21, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.jTextField5, -2, 21, -2).addComponent(this.jTextField6, -2, 21, -2)).addGap(27, 27, 27).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7).addComponent(this.jTextField7, -2, 21, -2).addComponent(this.jTextField8, -2, 21, -2))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jTextField1, -2, 21, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jTextField2, -2, 21, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.jTextField3, -2, 21, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.jTextField4, -2, 21, -2)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTabbedPane2)));
    }

    private void jToggleButton1ActionPerformed(ActionEvent evt) {
        this.updateEnabled = this.jToggleButton1.isSelected();
    }

    private void jComboBox1ActionPerformed(ActionEvent evt) {
        this.update();
    }

    private void jSlider1StateChanged(ChangeEvent evt) {
        if (this.jRadioButton1.isSelected()) {
            this.jTextField11.setText("" + String.format("%.4f", this.jSlider1.getValue()));
            this.jTextField11ActionPerformed(null);
        }
    }

    private void jRadioButton1ActionPerformed(ActionEvent evt) {
        this.jSlider1.setEnabled(this.jRadioButton1.isSelected());
        if (this.jRadioButton1.isSelected()) {
            int port = this.jComboBox1.getSelectedIndex();
            if (port < 0 || port > 1) {
                return;
            }
            VectrexJoyport[] portDevices = this.vecxPanel.getJoyportDevices();
            if (portDevices == null) {
                return;
            }
            VectrexJoyport portDevice = portDevices[port];
            if (portDevice == null) {
                return;
            }
            JoyportDevice device = portDevice.getDevice();
            if (device == null) {
                return;
            }
            if (!(device instanceof Imager3dDevice)) {
                return;
            }
            Imager3dDevice imager = (Imager3dDevice)device;
            imager.setAuto(false);
        }
    }

    private void jRadioButton2ActionPerformed(ActionEvent evt) {
        this.jSlider1.setEnabled(this.jRadioButton1.isSelected());
        if (this.jRadioButton2.isSelected()) {
            int port = this.jComboBox1.getSelectedIndex();
            if (port < 0 || port > 1) {
                return;
            }
            VectrexJoyport[] portDevices = this.vecxPanel.getJoyportDevices();
            if (portDevices == null) {
                return;
            }
            VectrexJoyport portDevice = portDevices[port];
            if (portDevice == null) {
                return;
            }
            JoyportDevice device = portDevice.getDevice();
            if (device == null) {
                return;
            }
            if (!(device instanceof Imager3dDevice)) {
                return;
            }
            Imager3dDevice imager = (Imager3dDevice)device;
            imager.setAuto(true);
        }
    }

    private void jTextField11ActionPerformed(ActionEvent evt) {
        int port = this.jComboBox1.getSelectedIndex();
        if (port < 0 || port > 1) {
            return;
        }
        VectrexJoyport[] portDevices = this.vecxPanel.getJoyportDevices();
        if (portDevices == null) {
            return;
        }
        VectrexJoyport portDevice = portDevices[port];
        if (portDevice == null) {
            return;
        }
        JoyportDevice device = portDevice.getDevice();
        if (device == null) {
            return;
        }
        if (!(device instanceof Imager3dDevice)) {
            return;
        }
        Imager3dDevice imager = (Imager3dDevice)device;
        imager.forceSpinPerSecond(UtilityString.DoubleX(this.jTextField11.getText(), 0.0));
    }

    private void jTextField11FocusLost(FocusEvent evt) {
        this.jTextField11ActionPerformed(null);
    }

    private void jTextField44FocusLost(FocusEvent evt) {
    }

    private void jTextField44ActionPerformed(ActionEvent evt) {
    }

    private void jSlider2StateChanged(ChangeEvent evt) {
        this.jTextField45.setText("" + this.jSlider2.getValue());
        Imager3dDevice.photoReceiverAngleStart = this.jSlider2.getValue();
        this.imagerWheel1.repaintWheel();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        int port = this.jComboBox1.getSelectedIndex();
        if (port < 0 || port > 1) {
            return;
        }
        VectrexJoyport[] portDevices = this.vecxPanel.getJoyportDevices();
        if (portDevices == null) {
            return;
        }
        VectrexJoyport portDevice = portDevices[port];
        if (portDevice == null) {
            return;
        }
        JoyportDevice device = portDevice.getDevice();
        if (device == null) {
            return;
        }
        if (!(device instanceof Imager3dDevice)) {
            return;
        }
        Imager3dDevice imager = (Imager3dDevice)device;
        double v = imager.getWheel().defaultFrequency;
        this.jSlider1.setValue((int)v);
        this.jTextField11.setText("" + String.format("%.4f", v));
        this.jRadioButton1.setSelected(true);
        this.jSlider1.setEnabled(this.jRadioButton1.isSelected());
        this.jTextField11ActionPerformed(null);
        this.imagerWheel1.repaintWheel();
        if (this.jRadioButton1.isSelected()) {
            imager.setAuto(false);
        }
    }

    private void jSlider3StateChanged(ChangeEvent evt) {
        if (this.currentWheel == null) {
            return;
        }
        if (this.mClassSetting == 0) {
            this.currentWheel.indexAngle = this.jSlider3.getValue();
        }
        this.jTextField46.setText("" + this.jSlider3.getValue());
        this.imagerWheel1.repaintWheel();
    }

    private void jSlider4StateChanged(ChangeEvent evt) {
        if (this.currentWheel == null) {
            return;
        }
        if (this.currentWheel.startAngle.length < 1) {
            return;
        }
        if (this.mClassSetting == 0) {
            this.currentWheel.startAngle[1] = this.jSlider4.getValue();
        }
        this.jTextField47.setText("" + (int)this.currentWheel.startAngle[1]);
        this.imagerWheel1.repaintWheel();
        int t = this.jSlider5.getValue();
        this.jSlider5.setMinimum(this.jSlider4.getValue());
        this.jSlider5.setValue(t);
    }

    private void jSlider5StateChanged(ChangeEvent evt) {
        if (this.currentWheel == null) {
            return;
        }
        if (this.currentWheel.startAngle.length < 2) {
            return;
        }
        if (this.mClassSetting == 0) {
            this.currentWheel.startAngle[2] = this.jSlider5.getValue();
        }
        this.jTextField48.setText("" + (int)this.currentWheel.startAngle[2]);
        this.imagerWheel1.repaintWheel();
        int t = this.jSlider6.getValue();
        this.jSlider6.setMinimum(this.jSlider5.getValue());
        this.jSlider6.setValue(t);
    }

    private void jSlider6StateChanged(ChangeEvent evt) {
        if (this.currentWheel == null) {
            return;
        }
        if (this.currentWheel.startAngle.length < 3) {
            return;
        }
        if (this.mClassSetting == 0) {
            this.currentWheel.startAngle[3] = this.jSlider6.getValue();
        }
        this.jTextField50.setText("" + (int)this.currentWheel.startAngle[3]);
        this.imagerWheel1.repaintWheel();
    }

    private void jCheckBox1ActionPerformed(ActionEvent evt) {
        int port = this.jComboBox1.getSelectedIndex();
        if (port < 0 || port > 1) {
            return;
        }
        VectrexJoyport[] portDevices = this.vecxPanel.getJoyportDevices();
        if (portDevices == null) {
            return;
        }
        VectrexJoyport portDevice = portDevices[port];
        if (portDevice == null) {
            return;
        }
        JoyportDevice device = portDevice.getDevice();
        if (device == null) {
            return;
        }
        if (!(device instanceof Imager3dDevice)) {
            return;
        }
        Imager3dDevice imager = (Imager3dDevice)device;
        imager.setLeftEnabled(this.jCheckBox1.isSelected());
    }

    private void jCheckBox2ActionPerformed(ActionEvent evt) {
        int port = this.jComboBox1.getSelectedIndex();
        if (port < 0 || port > 1) {
            return;
        }
        VectrexJoyport[] portDevices = this.vecxPanel.getJoyportDevices();
        if (portDevices == null) {
            return;
        }
        VectrexJoyport portDevice = portDevices[port];
        if (portDevice == null) {
            return;
        }
        JoyportDevice device = portDevice.getDevice();
        if (device == null) {
            return;
        }
        if (!(device instanceof Imager3dDevice)) {
            return;
        }
        Imager3dDevice imager = (Imager3dDevice)device;
        imager.setRightEnabled(this.jCheckBox2.isSelected());
    }

    private void jCheckBox4ActionPerformed(ActionEvent evt) {
        int port = this.jComboBox1.getSelectedIndex();
        if (port < 0 || port > 1) {
            return;
        }
        VectrexJoyport[] portDevices = this.vecxPanel.getJoyportDevices();
        if (portDevices == null) {
            return;
        }
        VectrexJoyport portDevice = portDevices[port];
        if (portDevice == null) {
            return;
        }
        JoyportDevice device = portDevice.getDevice();
        if (device == null) {
            return;
        }
        if (!(device instanceof Imager3dDevice)) {
            return;
        }
        Imager3dDevice imager = (Imager3dDevice)device;
        imager.setBwEnabled(this.jCheckBox4.isSelected());
    }

    private void jButtonWRTrackerActionPerformed(ActionEvent evt) {
        WheelEdit.showWheelEdit();
        this.correctWheelAfterEditor();
    }

    private void jComboBoxWheelListActionPerformed(ActionEvent evt) {
        if (this.mClassSetting > 0) {
            return;
        }
        this.loadSelectedWheel();
    }

    private void jCheckBoxAnaglyphicActionPerformed(ActionEvent evt) {
        int port = this.jComboBox1.getSelectedIndex();
        if (port < 0 || port > 1) {
            return;
        }
        VectrexJoyport[] portDevices = this.vecxPanel.getJoyportDevices();
        if (portDevices == null) {
            return;
        }
        VectrexJoyport portDevice = portDevices[port];
        if (portDevice == null) {
            return;
        }
        JoyportDevice device = portDevice.getDevice();
        if (device == null) {
            return;
        }
        if (!(device instanceof Imager3dDevice)) {
            return;
        }
        Imager3dDevice imager = (Imager3dDevice)device;
        imager.setAnaglyphicEnabled(this.jCheckBoxAnaglyphic.isSelected());
    }

    @Override
    public void updateValues(boolean forceUpdate) {
        if (!forceUpdate && !this.updateEnabled) {
            return;
        }
        this.update();
    }

    @Override
    public void setUpdateEnabled(boolean b) {
        this.updateEnabled = b;
    }

    void initWheel() {
        ++this.mClassSetting;
        int port = this.jComboBox1.getSelectedIndex();
        if (port < 0 || port > 1) {
            return;
        }
        VectrexJoyport[] portDevices = this.vecxPanel.getJoyportDevices();
        if (portDevices == null) {
            return;
        }
        VectrexJoyport portDevice = portDevices[port];
        if (portDevice == null) {
            return;
        }
        JoyportDevice device = portDevice.getDevice();
        if (device == null) {
            return;
        }
        if (!(device instanceof Imager3dDevice)) {
            return;
        }
        Imager3dDevice imager = (Imager3dDevice)device;
        imager.setBwEnabled(this.jCheckBox4.isSelected());
        this.jRadioButton2.setSelected(imager.isAuto());
        this.jRadioButton1.setSelected(!imager.isAuto());
        this.jSlider1.setEnabled(!imager.isAuto());
        this.imagerWheel1.setWheel(this.currentWheel);
        this.jSlider2.setValue(339);
        this.jTextField45.setText("339");
        this.jSlider3.setValue((int)this.currentWheel.indexAngle);
        this.jTextField46.setText("" + (int)this.currentWheel.indexAngle);
        this.jSlider4.setValue((int)this.currentWheel.startAngle[1]);
        this.jTextField47.setText("" + (int)this.currentWheel.startAngle[1]);
        this.jSlider5.setValue((int)this.currentWheel.startAngle[2]);
        this.jTextField48.setText("" + (int)this.currentWheel.startAngle[2]);
        this.jSlider6.setValue((int)this.currentWheel.startAngle[3]);
        this.jTextField50.setText("" + (int)this.currentWheel.startAngle[3]);
        this.jCheckBox1.setSelected(imager.isLeftEnabled());
        this.jCheckBox2.setSelected(imager.isRightEnabled());
        this.jCheckBox4.setSelected(imager.isBwEnabled());
        if (!this.jRadioButton2.isSelected()) {
            this.jButton1ActionPerformed(null);
        }
        --this.mClassSetting;
        this.repaint();
    }

    void initWheelList() {
        ++this.mClassSetting;
        String path = Global.mainPathPrefix + "xml" + File.separator + "wheels";
        ArrayList<String> files = UtilityFiles.getXMLFileList(path);
        this.jComboBoxWheelList.removeAllItems();
        for (String name : files) {
            this.jComboBoxWheelList.addItem(UtilityString.replace(name.toLowerCase(), ".xml", ""));
        }
        --this.mClassSetting;
    }

    void loadSelectedWheel() {
        int i = this.jComboBoxWheelList.getSelectedIndex();
        if (i < 0) {
            this.log.addLog("No entry selected - can't load.", LogPanel.WARN);
            return;
        }
        String fname = this.jComboBoxWheelList.getSelectedItem().toString() + ".xml";
        String path = Global.mainPathPrefix + "xml" + File.separator + "wheels" + File.separator + fname;
        WheelData loadedWheel = WheelData.loadWheel(path);
        if (loadedWheel == null) {
            this.log.addLog("Wheel not loaded.", LogPanel.WARN);
            return;
        }
        this.currentWheel = loadedWheel;
        int port = this.jComboBox1.getSelectedIndex();
        if (port < 0 || port > 1) {
            return;
        }
        VectrexJoyport[] portDevices = this.vecxPanel.getJoyportDevices();
        if (portDevices == null) {
            return;
        }
        VectrexJoyport portDevice = portDevices[port];
        if (portDevice == null) {
            return;
        }
        JoyportDevice device = portDevice.getDevice();
        if (device == null) {
            return;
        }
        if (!(device instanceof Imager3dDevice)) {
            return;
        }
        Imager3dDevice imager = (Imager3dDevice)device;
        imager.setWheel(this.currentWheel);
        this.initWheel();
        this.log.addLog("Wheel " + this.currentWheel.name + " loaded.", LogPanel.INFO);
    }

    void correctWheelAfterEditor() {
        if (this.currentWheel == null) {
            return;
        }
        String currentName = UtilityString.replace(this.currentWheel.name.toLowerCase(), ".xml", "");
        ++this.mClassSetting;
        this.initWheelList();
        int index = -1;
        for (int i = 0; i < this.jComboBoxWheelList.getItemCount(); ++i) {
            if (!currentName.equals(this.jComboBoxWheelList.getItemAt(i).toString())) continue;
            index = i;
            break;
        }
        if (index >= 0) {
            this.jComboBoxWheelList.setSelectedIndex(index);
        }
        this.initWheel();
        --this.mClassSetting;
    }

    void setCurrentWheelAsSelection() {
        if (this.currentWheel == null) {
            return;
        }
        String currentName = UtilityString.replace(this.currentWheel.name.toLowerCase(), ".xml", "");
        ++this.mClassSetting;
        int index = -1;
        for (int i = 0; i < this.jComboBoxWheelList.getItemCount(); ++i) {
            if (!currentName.equals(this.jComboBoxWheelList.getItemAt(i).toString())) continue;
            index = i;
            break;
        }
        if (index >= 0) {
            this.jComboBoxWheelList.setSelectedIndex(index);
        }
        this.initWheel();
        --this.mClassSetting;
    }

    void setTimerValues() {
        int port = this.jComboBox1.getSelectedIndex();
        if (port < 0 || port > 1) {
            return;
        }
        VectrexJoyport[] portDevices = this.vecxPanel.getJoyportDevices();
        if (portDevices == null) {
            return;
        }
        VectrexJoyport portDevice = portDevices[port];
        if (portDevice == null) {
            return;
        }
        JoyportDevice device = portDevice.getDevice();
        if (device == null) {
            return;
        }
        if (!(device instanceof Imager3dDevice)) {
            return;
        }
        Imager3dDevice imager = (Imager3dDevice)device;
        double frequency = imager.getSpinPerSecond();
        double angleRight1 = 0.0;
        double angleRight2 = 0.0;
        double angleRight3 = 0.0;
        double angleLeft1 = 0.0;
        double angleLeft2 = 0.0;
        double angleLeft3 = 0.0;
        if (this.currentWheel.startAngle.length >= 1) {
            angleRight1 = this.currentWheel.startAngle[1] + 90.0;
            angleLeft1 = this.currentWheel.startAngle[1] + 90.0 + 180.0;
        }
        if (this.currentWheel.startAngle.length >= 2) {
            angleRight2 = this.currentWheel.startAngle[2] + 90.0;
            angleLeft2 = this.currentWheel.startAngle[2] + 90.0 + 180.0;
        }
        if (this.currentWheel.startAngle.length >= 3) {
            angleRight3 = this.currentWheel.startAngle[3] + 90.0;
            angleLeft3 = this.currentWheel.startAngle[3] + 90.0 + 180.0;
        }
        JoyportPanel.setCycle(angleRight1, this.jLabel56, imager, this.currentWheel);
        JoyportPanel.setCycle(angleRight2, this.jLabel61, imager, this.currentWheel);
        JoyportPanel.setCycle(angleRight3, this.jLabel63, imager, this.currentWheel);
        JoyportPanel.setCycle(angleLeft1, this.jLabel59, imager, this.currentWheel);
        JoyportPanel.setCycle(angleLeft2, this.jLabel60, imager, this.currentWheel);
        JoyportPanel.setCycle(angleLeft3, this.jLabel62, imager, this.currentWheel);
    }

    public static void setCycle(double angle, JLabel label, Imager3dDevice imager, WheelData wheel) {
        double angleOffset = (Imager3dDevice.indexAngleWidth + Imager3dDevice.photoReceiverAngleStart + (360.0 - wheel.indexAngle)) % 360.0;
        angle += angleOffset;
        double anglePerCycle = imager.getAnglePerCycle();
        double cycles = (angle %= 360.0) / anglePerCycle;
        label.setText("0x" + String.format("%04X", (int)cycles & 0xFFFF));
    }

    @Override
    public void deIconified() {
    }
}

