/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.vecx.panels;

import de.malban.config.Configuration;
import de.malban.gui.CSAMainFrame;
import de.malban.gui.Stateable;
import de.malban.gui.Windowable;
import de.malban.gui.components.CSAView;
import de.malban.util.UtilityString;
import de.malban.vide.VideConfig;
import de.malban.vide.dissy.DissiPanel;
import de.malban.vide.dissy.Memory;
import de.malban.vide.dissy.MemoryInformation;
import de.malban.vide.vecx.Updatable;
import de.malban.vide.vecx.VecXPanel;
import de.muntjak.tinylookandfeel.Theme;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;

public class LabelJPanel
extends JPanel
implements Windowable,
Stateable,
Updatable {
    private CSAView mParent = null;
    VideConfig config = VideConfig.getConfig();
    private JMenuItem mParentMenuItem = null;
    private int mClassSetting = 0;
    private DissiPanel dissi = null;
    private VecXPanel vecxPanel = null;
    public static String SID = "Debug: Labels";
    boolean systemLabels = false;
    ArrayList<MemoryInformation> labels = new ArrayList();
    Memory memory = null;
    private JCheckBox jCheckBox1;
    private JScrollPane jScrollPane1;
    private JTable jTable1;
    private JToggleButton jToggleButton4;
    private boolean updateEnabled = false;
    private PropertyChangeListener pListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            LabelJPanel.this.updateMyUI();
        }
    };

    @Override
    public boolean isLoadSettings() {
        return true;
    }

    @Override
    public String getID() {
        return SID;
    }

    @Override
    public String getFileID() {
        return UtilityString.replace(UtilityString.replace(UtilityString.replace(UtilityString.replaceWhiteSpaces(SID, ""), ":", ""), "(", ""), ")", "");
    }

    @Override
    public Serializable getAdditionalStateinfo() {
        return null;
    }

    @Override
    public void setAdditionalStateinfo(Serializable ser) {
    }

    public void setVecxy(VecXPanel v) {
        this.vecxPanel = v;
        this.initLabels();
    }

    public void setDissi(DissiPanel v) {
        this.dissi = v;
        if (this.dissi == null) {
            return;
        }
        this.memory = this.dissi.getMemory();
        this.initLabels();
    }

    @Override
    public boolean isIcon() {
        CSAMainFrame frame = Configuration.getConfiguration().getMainFrame();
        if (frame.getInternalFrame(this) == null) {
            return false;
        }
        return frame.getInternalFrame(this).isIcon();
    }

    @Override
    public void setIcon(boolean b) {
        CSAMainFrame frame = Configuration.getConfiguration().getMainFrame();
        if (frame.getInternalFrame(this) == null) {
            return;
        }
        try {
            frame.getInternalFrame(this).setIcon(b);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void initLabels() {
        MemoryInformation memInfo;
        int m;
        if (this.vecxPanel == null) {
            return;
        }
        if (this.memory == null) {
            return;
        }
        this.labels = new ArrayList();
        int start = 0;
        int end2 = 49151;
        for (m = start; m < end2; ++m) {
            memInfo = this.memory.memMap.get(m);
            if (memInfo.memType != 1 || memInfo.labels.size() <= 0) continue;
            this.labels.add(memInfo);
        }
        if (this.systemLabels) {
            start = 57344;
            end2 = 65535;
            for (m = start; m < end2; ++m) {
                memInfo = this.memory.memMap.get(m);
                if (memInfo.memType != 1 || memInfo.labels.size() <= 0) continue;
                this.labels.add(memInfo);
            }
        }
        this.correctTable();
    }

    @Override
    public void closing() {
        if (this.vecxPanel != null) {
            this.vecxPanel.resetLabi();
        }
        this.deinit();
    }

    @Override
    public void setParentWindow(CSAView jpv) {
        this.mParent = jpv;
    }

    @Override
    public void setMenuItem(JMenuItem item) {
        this.mParentMenuItem = item;
        this.mParentMenuItem.setText(SID);
    }

    @Override
    public JMenuItem getMenuItem() {
        return this.mParentMenuItem;
    }

    @Override
    public JPanel getPanel() {
        return this;
    }

    public void deinit() {
        this.removeUIListerner();
    }

    public LabelJPanel() {
        this.initComponents();
        LabelsTableModel model = new LabelsTableModel();
        this.jTable1.setModel(model);
        this.jTable1.setDefaultRenderer(Object.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
                super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
                if (table.getModel() instanceof LabelsTableModel) {
                    LabelsTableModel model = (LabelsTableModel)table.getModel();
                    if (isSelected) {
                        this.setBackground(table.getSelectionBackground());
                        this.setForeground(table.getSelectionForeground());
                    } else {
                        Color back = model.getBackground(col);
                        if (back != null) {
                            this.setBackground(back);
                        } else {
                            this.setBackground(table.getBackground());
                        }
                        this.setForeground(table.getForeground());
                    }
                }
                return this;
            }
        });
        UIManager.addPropertyChangeListener(this.pListener);
        this.updateMyUI();
        this.correctTable();
    }

    private void initComponents() {
        this.jCheckBox1 = new JCheckBox();
        this.jToggleButton4 = new JToggleButton();
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = this.buildTable();
        this.jCheckBox1.setText("system labels");
        this.jCheckBox1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LabelJPanel.this.jCheckBox1ActionPerformed(evt);
            }
        });
        this.jToggleButton4.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/webcam.png")));
        this.jToggleButton4.setToolTipText("Toggle Update (always or only while debug)");
        this.jToggleButton4.setMargin(new Insets(0, 1, 0, -1));
        this.jToggleButton4.setSelectedIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/webcamSelect.png")));
        this.jToggleButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LabelJPanel.this.jToggleButton4ActionPerformed(evt);
            }
        });
        this.jTable1.setAutoCreateRowSorter(true);
        this.jTable1.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jTable1.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                LabelJPanel.this.jTable1MousePressed(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTable1);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jToggleButton4, -2, 20, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckBox1).addContainerGap(-1, Short.MAX_VALUE)).addComponent(this.jScrollPane1, -1, 409, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jToggleButton4, -2, 21, -2).addComponent(this.jCheckBox1, -2, 21, -2)).addGap(5, 5, 5).addComponent(this.jScrollPane1, -1, 262, Short.MAX_VALUE)));
    }

    private void jCheckBox1ActionPerformed(ActionEvent evt) {
        this.systemLabels = this.jCheckBox1.isSelected();
        this.initLabels();
    }

    private void jToggleButton4ActionPerformed(ActionEvent evt) {
        this.updateEnabled = this.jToggleButton4.isSelected();
    }

    private void jTable1MousePressed(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            JTable table = (JTable)evt.getSource();
            Point p = evt.getPoint();
            int row = table.rowAtPoint(p);
            int col = table.columnAtPoint(p);
            LabelsTableModel model = (LabelsTableModel)this.jTable1.getModel();
            MemoryInformation memInfo = this.labels.get(this.jTable1.convertRowIndexToModel(row));
            int current = memInfo.address;
            if ((evt.getModifiers() & 1) == 1) {
                if (this.vecxPanel != null) {
                    this.vecxPanel.setDumpToAddress(current);
                }
            } else if (this.dissi != null) {
                this.dissi.goAddress(current, true, true, true);
            }
        }
    }

    private void update() {
        this.jTable1.repaint();
    }

    public void correctTable() {
        this.jTable1.tableChanged(null);
        LabelsTableModel model = (LabelsTableModel)this.jTable1.getModel();
        for (int i = 0; i < model.getColumnCount(); ++i) {
            this.jTable1.getColumnModel().getColumn(i).setPreferredWidth(model.getColWidth(i));
        }
    }

    @Override
    public void updateValues(boolean forceUpdate) {
        if (!forceUpdate && !this.updateEnabled) {
            return;
        }
        this.update();
    }

    @Override
    public void setUpdateEnabled(boolean b) {
        this.updateEnabled = b;
    }

    JTable buildTable() {
        JTable table = new JTable(){

            @Override
            public String getToolTipText(MouseEvent e) {
                if (LabelJPanel.this.vecxPanel == null) {
                    return null;
                }
                String tip = "<html>";
                if (LabelJPanel.this.jTable1.getModel() instanceof LabelsTableModel) {
                    LabelsTableModel model = (LabelsTableModel)LabelJPanel.this.jTable1.getModel();
                    Point p = e.getPoint();
                    int rowIndex = this.rowAtPoint(p);
                    int n = this.columnAtPoint(p);
                }
                tip = tip + "</html>";
                return tip;
            }
        };
        return table;
    }

    public void removeUIListerner() {
        UIManager.removePropertyChangeListener(this.pListener);
    }

    void updateMyUI() {
        int fontSize = Theme.textFieldFont.getFont().getSize();
        int rowHeight = fontSize + 3;
        this.jTable1.setRowHeight(rowHeight);
    }

    @Override
    public void deIconified() {
    }

    public class LabelsTableModel
    extends AbstractTableModel {
        @Override
        public int getRowCount() {
            return LabelJPanel.this.labels.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (LabelJPanel.this.vecxPanel == null) {
                return "";
            }
            MemoryInformation memInfo = LabelJPanel.this.labels.get(row);
            if (col == 0) {
                return "$" + String.format("%04X", memInfo.address);
            }
            if (col == 1) {
                String l = "";
                for (int i = 0; i < memInfo.labels.size(); ++i) {
                    if (i > 0) {
                        l = l + ", ";
                    }
                    l = l + memInfo.labels.get(i);
                }
                return l;
            }
            return "";
        }

        @Override
        public String getColumnName(int column) {
            if (column == 1) {
                return "labels";
            }
            if (column == 0) {
                return "address";
            }
            return "-";
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return String.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public int getColWidth(int col) {
            if (col == 1) {
                return 200;
            }
            if (col == 0) {
                return 30;
            }
            return 20;
        }

        public Color getBackground(int col) {
            if (col == 0) {
                return LabelJPanel.this.config.tableAddress;
            }
            return null;
        }
    }
}

