/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.vecx.panels;

import de.malban.Global;
import de.malban.config.Configuration;
import de.malban.graphics.GFXVector;
import de.malban.graphics.GFXVectorAnimation;
import de.malban.graphics.GFXVectorList;
import de.malban.graphics.Single3dDisplayPanel;
import de.malban.gui.CSAMainFrame;
import de.malban.gui.HotKey;
import de.malban.gui.Stateable;
import de.malban.gui.Windowable;
import de.malban.gui.components.CSAView;
import de.malban.util.UtilityString;
import de.malban.vide.VideConfig;
import de.malban.vide.dissy.DASM6809;
import de.malban.vide.dissy.DissiPanel;
import de.malban.vide.dissy.MemoryInformation;
import de.malban.vide.veccy.VeccyInterpreter;
import de.malban.vide.veccy.VeccyPanel;
import de.malban.vide.vecx.Updatable;
import de.malban.vide.vecx.VecXPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JViewport;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;

public class MemoryDumpPanel
extends JPanel
implements Windowable,
Stateable,
Updatable {
    VideConfig config = VideConfig.getConfig();
    private CSAView mParent = null;
    private JMenuItem mParentMenuItem = null;
    private int mClassSetting = 0;
    private DissiPanel dissi = null;
    private VecXPanel vecxPanel = null;
    private static final int DEFAULT_SPLIT_SIZE = 250;
    int endAddress = -1;
    int startAddress = -1;
    Vector<VeccyPanel.PatternInfo> knownPatterns = new Vector();
    private ButtonGroup buttonGroup1;
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButton3;
    private JButton jButton4;
    private JButton jButton5;
    private JButton jButton6;
    private JButton jButton7;
    private JButton jButton8;
    private JButton jButton9;
    private JButton jButtonCopy;
    private JButton jButtonInterprete;
    private JButton jButtonSave3;
    private JCheckBox jCheckBox1;
    private JCheckBox jCheckBoxActive;
    private JComboBox jComboBoxPatterns;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel25;
    private JLabel jLabel26;
    private JLabel jLabel27;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JRadioButton jRadioButton1;
    private JRadioButton jRadioButton2;
    private JScrollPane jScrollPane1;
    private JSlider jSliderSourceScale1;
    private JSpinner jSpinnerRasterWidth;
    private JSplitPane jSplitPane1;
    private JTable jTable1;
    private JTextField jTextField10;
    private JTextField jTextField2;
    private JTextField jTextField3;
    private JTextField jTextField8;
    private JTextField jTextField9;
    private JTextField jTextFieldPatternName;
    private JToggleButton jToggleButton4;
    private Single3dDisplayPanel single3dDisplayPanel1;
    public static String SID = "Debug: Memory dump";
    private boolean updateEnabled = false;
    int bitmapWidth = 1;
    int oldStart = 0;
    int oldEnd = 0;
    int oldWidth = 0;

    @Override
    public boolean isLoadSettings() {
        return true;
    }

    public void setVecxy(VecXPanel v) {
        this.vecxPanel = v;
        this.correctTable();
    }

    private void update() {
        this.jTable1.repaint();
    }

    public void correctTable() {
        this.jTable1.tableChanged(null);
        MemoryDumpTableModel model = (MemoryDumpTableModel)this.jTable1.getModel();
        for (int i = 0; i < model.getColumnCount(); ++i) {
            this.jTable1.getColumnModel().getColumn(i).setPreferredWidth(model.getColWidth(i));
        }
    }

    public void setDissi(DissiPanel d) {
        this.dissi = d;
        this.update();
    }

    @Override
    public boolean isIcon() {
        CSAMainFrame frame = Configuration.getConfiguration().getMainFrame();
        if (frame.getInternalFrame(this) == null) {
            return false;
        }
        return frame.getInternalFrame(this).isIcon();
    }

    @Override
    public void setIcon(boolean b) {
        CSAMainFrame frame = Configuration.getConfiguration().getMainFrame();
        if (frame.getInternalFrame(this) == null) {
            return;
        }
        try {
            frame.getInternalFrame(this).setIcon(b);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void closing() {
        if (this.vecxPanel != null) {
            this.vecxPanel.resetDumpi();
        }
        this.deinit();
    }

    @Override
    public void setParentWindow(CSAView jpv) {
        this.mParent = jpv;
    }

    @Override
    public void setMenuItem(JMenuItem item) {
        this.mParentMenuItem = item;
        this.mParentMenuItem.setText(SID);
    }

    @Override
    public JMenuItem getMenuItem() {
        return this.mParentMenuItem;
    }

    @Override
    public JPanel getPanel() {
        return this;
    }

    public void deinit() {
    }

    public MemoryDumpPanel() {
        this.initComponents();
        MemoryDumpTableModel model = new MemoryDumpTableModel();
        if (Global.getOSName().toUpperCase().contains("MAC")) {
            HotKey.addMacDefaults(this.jTextFieldPatternName);
            HotKey.addMacDefaults(this.jTextField8);
            HotKey.addMacDefaults(this.jTextField9);
            HotKey.addMacDefaults(this.jTextField10);
            HotKey.addMacDefaults(this.jTextField2);
            HotKey.addMacDefaults(this.jTextField3);
        }
        ++this.mClassSetting;
        this.loadPatterns();
        if (this.knownPatterns.size() == 0) {
            VeccyPanel.fillPatternBox(this.knownPatterns);
            this.jComboBoxPatterns.setModel(new DefaultComboBoxModel<VeccyPanel.PatternInfo>(this.knownPatterns));
        }
        --this.mClassSetting;
        this.jComboBoxPatterns.setSelectedIndex(0);
        this.single3dDisplayPanel1.setByteFrame(false);
        this.single3dDisplayPanel1.setAxisAngleX(0);
        this.single3dDisplayPanel1.setAxisAngleY(0);
        this.single3dDisplayPanel1.setAxisAngleZ(0);
        this.single3dDisplayPanel1.setDrawVectorEnds(false);
        this.single3dDisplayPanel1.repaint();
        this.single3dDisplayPanel1.setDumpMode(true);
        this.jSliderSourceScale1StateChanged(null);
        this.jTable1.setModel(model);
        this.jTable1.setDefaultRenderer(Object.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
                super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
                if (table.getModel() instanceof MemoryDumpTableModel) {
                    MemoryDumpTableModel model = (MemoryDumpTableModel)table.getModel();
                    int address = model.getAddress(row, col);
                    if (isSelected) {
                        this.setBackground(table.getSelectionBackground());
                        this.setForeground(table.getSelectionForeground());
                    } else {
                        Color back = model.getBackground(col);
                        if (back != null) {
                            this.setBackground(back);
                        } else {
                            this.setBackground(table.getBackground());
                        }
                        this.setForeground(table.getForeground());
                    }
                    if (address >= MemoryDumpPanel.this.startAddress && address <= MemoryDumpPanel.this.endAddress && MemoryDumpPanel.this.jCheckBox1.isSelected()) {
                        this.setBackground(MemoryDumpPanel.this.config.dataSelection);
                    }
                }
                return this;
            }
        });
        this.correctTable();
        this.jSplitPane1.setDividerLocation(this.jSplitPane1.getSize().height - 250);
        this.jSplitPane1.setDividerSize(5);
    }

    protected boolean loadPatterns() {
        ++this.mClassSetting;
        this.jComboBoxPatterns.setModel(new DefaultComboBoxModel<VeccyPanel.PatternInfo>(this.knownPatterns));
        --this.mClassSetting;
        try {
            this.knownPatterns = (Vector)CSAMainFrame.deserialize(Global.mainPathPrefix + "serialize" + File.separator + "PatternInfo.ser");
            if (this.knownPatterns == null) {
                this.knownPatterns = new Vector();
                return false;
            }
        }
        catch (Throwable e) {
            return false;
        }
        ++this.mClassSetting;
        this.jComboBoxPatterns.setModel(new DefaultComboBoxModel<VeccyPanel.PatternInfo>(this.knownPatterns));
        --this.mClassSetting;
        return true;
    }

    JTable buildTable() {
        JTable table = new JTable(){

            @Override
            public String getToolTipText(MouseEvent e) {
                String tip = "<html>";
                if (MemoryDumpPanel.this.dissi == null) {
                    return null;
                }
                if (MemoryDumpPanel.this.vecxPanel == null) {
                    return null;
                }
                if (MemoryDumpPanel.this.jTable1.getModel() instanceof MemoryDumpTableModel) {
                    MemoryDumpTableModel model = (MemoryDumpTableModel)MemoryDumpPanel.this.jTable1.getModel();
                    Point p = e.getPoint();
                    int rowIndex = this.rowAtPoint(p);
                    int colIndex = this.columnAtPoint(p);
                    try {
                        int i;
                        int num;
                        MemoryInformation memInfo = MemoryDumpPanel.this.dissi.getMemoryInformation(model.getAddress(rowIndex, colIndex), MemoryDumpPanel.this.vecxPanel.getCurrentBank());
                        if (memInfo.memType == 0) {
                            num = model.getIntegerValueAt(rowIndex, colIndex) & 0xFF;
                            tip = tip + "RAM:<BR> ";
                            tip = tip + "binary: " + DASM6809.printbinary(num) + "<BR>";
                            tip = tip + "decimal: " + num + "<BR>";
                            if (num > 127) {
                                num -= 256;
                            }
                            tip = tip + "decimal (2 compl.): " + num + "<BR>";
                            tip = tip + "labels: \"";
                            for (i = 0; i < memInfo.labels.size(); ++i) {
                                if (i > 0) {
                                    tip = tip + ", ";
                                }
                                tip = tip + memInfo.labels.get(i);
                            }
                            tip = tip + "\"<BR>";
                            tip = tip + "comments: \"";
                            for (i = 0; i < memInfo.comments.size(); ++i) {
                                if (i > 0) {
                                    tip = tip + ":";
                                }
                                tip = tip + memInfo.comments.get(i);
                            }
                            tip = tip + "\"<BR>";
                        }
                        if (memInfo.memType == 1) {
                            num = model.getIntegerValueAt(rowIndex, colIndex) & 0xFF;
                            tip = tip + "ROM:<BR>";
                            tip = tip + "binary: " + DASM6809.printbinary(num) + "<BR>";
                            tip = tip + "decimal: " + num + "<BR>";
                            if (num > 127) {
                                num -= 256;
                            }
                            tip = tip + "decimal (2 compl.): " + num + "<BR>";
                            tip = tip + "labels: \"";
                            for (i = 0; i < memInfo.labels.size(); ++i) {
                                if (i > 0) {
                                    tip = tip + ", ";
                                }
                                tip = tip + memInfo.labels.get(i);
                            }
                            tip = tip + "\"<BR>";
                            tip = tip + "comments: \"";
                            for (i = 0; i < memInfo.comments.size(); ++i) {
                                if (i > 0) {
                                    tip = tip + ":";
                                }
                                tip = tip + memInfo.comments.get(i);
                            }
                            tip = tip + "\"<BR>";
                            tip = tip + "Type: " + MemoryInformation.disTypeString[memInfo.disType] + "<BR>";
                        }
                        if (memInfo.memType == 2) {
                            num = model.getIntegerValueAt(rowIndex, colIndex) & 0xFF;
                            tip = tip + "IO:<BR>";
                            tip = tip + "binary: " + DASM6809.printbinary(num) + "<BR>";
                            tip = tip + "decimal: " + num + "<BR>";
                            if (num > 127) {
                                num -= 256;
                            }
                            tip = tip + "decimal (2 compl.): " + num + "<BR>";
                            tip = tip + "labels: \"";
                            for (i = 0; i < memInfo.labels.size(); ++i) {
                                if (i > 0) {
                                    tip = tip + ", ";
                                }
                                tip = tip + memInfo.labels.get(i);
                            }
                            tip = tip + "\"<BR>";
                            tip = tip + "comments: \"";
                            for (i = 0; i < memInfo.comments.size(); ++i) {
                                if (i > 0) {
                                    tip = tip + ":";
                                }
                                tip = tip + memInfo.comments.get(i);
                            }
                            tip = tip + "\"<BR>";
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                }
                tip = tip + "</html>";
                return tip;
            }
        };
        return table;
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jSplitPane1 = new JSplitPane();
        this.jPanel4 = new JPanel();
        this.jPanel1 = new JPanel();
        this.jToggleButton4 = new JToggleButton();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.jButton3 = new JButton();
        this.jButton4 = new JButton();
        this.jButton5 = new JButton();
        this.jButton6 = new JButton();
        this.jButton7 = new JButton();
        this.jButton8 = new JButton();
        this.jButton9 = new JButton();
        this.jCheckBox1 = new JCheckBox();
        this.jLabel5 = new JLabel();
        this.jButtonCopy = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = this.buildTable();
        this.jPanel2 = new JPanel();
        this.single3dDisplayPanel1 = new Single3dDisplayPanel();
        this.jLabel2 = new JLabel();
        this.jRadioButton2 = new JRadioButton();
        this.jRadioButton1 = new JRadioButton();
        this.jTextField2 = new JTextField();
        this.jLabel3 = new JLabel();
        this.jTextField3 = new JTextField();
        this.jLabel4 = new JLabel();
        this.jCheckBoxActive = new JCheckBox();
        this.jSpinnerRasterWidth = new JSpinner();
        this.jPanel3 = new JPanel();
        this.jSliderSourceScale1 = new JSlider();
        this.jTextField9 = new JTextField();
        this.jTextField10 = new JTextField();
        this.jTextField8 = new JTextField();
        this.jTextFieldPatternName = new JTextField();
        this.jComboBoxPatterns = new JComboBox();
        this.jLabel1 = new JLabel();
        this.jButtonSave3 = new JButton();
        this.jButtonInterprete = new JButton();
        this.jLabel25 = new JLabel();
        this.jLabel26 = new JLabel();
        this.jLabel27 = new JLabel();
        this.jSplitPane1.setDividerLocation(250);
        this.jSplitPane1.setOrientation(0);
        this.jSplitPane1.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                MemoryDumpPanel.this.jSplitPane1ComponentResized(evt);
            }
        });
        this.jToggleButton4.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/webcam.png")));
        this.jToggleButton4.setToolTipText("Toggle Update (always or only while debug)");
        this.jToggleButton4.setMargin(new Insets(0, 1, 0, -1));
        this.jToggleButton4.setSelectedIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/webcamSelect.png")));
        this.jToggleButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MemoryDumpPanel.this.jToggleButton4ActionPerformed(evt);
            }
        });
        this.jButton1.setText("$c800");
        this.jButton1.setMargin(new Insets(2, 2, 2, 2));
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MemoryDumpPanel.this.jButton2ActionPerformed(evt);
            }
        });
        this.jButton2.setText("$c880");
        this.jButton2.setMargin(new Insets(2, 2, 2, 2));
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MemoryDumpPanel.this.jButton2ActionPerformed(evt);
            }
        });
        this.jButton3.setText("$c900");
        this.jButton3.setMargin(new Insets(2, 2, 2, 2));
        this.jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MemoryDumpPanel.this.jButton2ActionPerformed(evt);
            }
        });
        this.jButton4.setText("$ca00");
        this.jButton4.setMargin(new Insets(2, 2, 2, 2));
        this.jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MemoryDumpPanel.this.jButton2ActionPerformed(evt);
            }
        });
        this.jButton5.setText("$cb00");
        this.jButton5.setMargin(new Insets(2, 2, 2, 2));
        this.jButton5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MemoryDumpPanel.this.jButton2ActionPerformed(evt);
            }
        });
        this.jButton6.setText("X");
        this.jButton6.setMargin(new Insets(2, 2, 2, 2));
        this.jButton6.setPreferredSize(new Dimension(30, 23));
        this.jButton6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MemoryDumpPanel.this.jButton6jButton2ActionPerformed(evt);
            }
        });
        this.jButton7.setText("Y");
        this.jButton7.setMargin(new Insets(2, 2, 2, 2));
        this.jButton7.setPreferredSize(new Dimension(30, 23));
        this.jButton7.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MemoryDumpPanel.this.jButton7jButton2ActionPerformed(evt);
            }
        });
        this.jButton8.setText("S");
        this.jButton8.setMargin(new Insets(2, 2, 2, 2));
        this.jButton8.setPreferredSize(new Dimension(30, 23));
        this.jButton8.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MemoryDumpPanel.this.jButton8jButton2ActionPerformed(evt);
            }
        });
        this.jButton9.setText("U");
        this.jButton9.setMargin(new Insets(2, 2, 2, 2));
        this.jButton9.setPreferredSize(new Dimension(30, 23));
        this.jButton9.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MemoryDumpPanel.this.jButton9jButton2ActionPerformed(evt);
            }
        });
        this.jCheckBox1.setSelected(true);
        this.jCheckBox1.setText("data display");
        this.jCheckBox1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MemoryDumpPanel.this.jCheckBox1ActionPerformed(evt);
            }
        });
        this.jLabel5.setText("bank always same as emulation (not dissi)");
        this.jButtonCopy.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/page_copy.png")));
        this.jButtonCopy.setToolTipText("copy (selection to clipboard)");
        this.jButtonCopy.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonCopy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MemoryDumpPanel.this.jButtonCopyActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jToggleButton4).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButton1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton6, -1, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton7, -1, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton8, -1, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton9, -1, -1, -2).addGap(4, 4, 4).addComponent(this.jButtonCopy).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBox1).addGap(44, 44, 44).addComponent(this.jLabel5).addGap(0, 472, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jToggleButton4, -1, 43, Short.MAX_VALUE).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton1, -2, 21, -2).addComponent(this.jButton2, -2, 21, -2).addComponent(this.jButton3, -2, 21, -2).addComponent(this.jButton4, -2, 21, -2).addComponent(this.jButton5, -2, 21, -2).addComponent(this.jButton6, -2, 21, -2).addComponent(this.jButton7, -2, 21, -2).addComponent(this.jButton8, -2, 21, -2).addComponent(this.jButton9, -2, 21, -2).addComponent(this.jCheckBox1, -2, 21, -2).addComponent(this.jLabel5)).addComponent(this.jButtonCopy)).addGap(0, 0, Short.MAX_VALUE)));
        this.jTable1.setFont(new Font("Courier", 0, 12));
        this.jTable1.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jTable1.setSelectionMode(2);
        this.jTable1.setShowHorizontalLines(false);
        this.jTable1.setShowVerticalLines(false);
        this.jTable1.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                MemoryDumpPanel.this.jTable1MousePressed(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTable1);
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING, -1, 1100, Short.MAX_VALUE)));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addGap(2, 2, 2).addComponent(this.jPanel1, -2, -1, -2).addGap(2, 2, 2)).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel4Layout.createSequentialGroup().addGap(28, 28, 28).addComponent(this.jScrollPane1, -1, 221, Short.MAX_VALUE))));
        this.jSplitPane1.setLeftComponent(this.jPanel4);
        this.single3dDisplayPanel1.setMaximumSize(new Dimension(150, 150));
        this.single3dDisplayPanel1.setMinimumSize(new Dimension(150, 150));
        this.single3dDisplayPanel1.setPreferredSize(new Dimension(100, 100));
        GroupLayout single3dDisplayPanel1Layout = new GroupLayout(this.single3dDisplayPanel1);
        this.single3dDisplayPanel1.setLayout(single3dDisplayPanel1Layout);
        single3dDisplayPanel1Layout.setHorizontalGroup(single3dDisplayPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        single3dDisplayPanel1Layout.setVerticalGroup(single3dDisplayPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 473, Short.MAX_VALUE));
        this.jLabel2.setText("width");
        this.buttonGroup1.add(this.jRadioButton2);
        this.jRadioButton2.setText("raster");
        this.jRadioButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MemoryDumpPanel.this.jRadioButton2ActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.jRadioButton1);
        this.jRadioButton1.setSelected(true);
        this.jRadioButton1.setText("vectorlist");
        this.jRadioButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MemoryDumpPanel.this.jRadioButton1ActionPerformed(evt);
            }
        });
        this.jTextField2.setPreferredSize(new Dimension(80, 21));
        this.jTextField2.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                MemoryDumpPanel.this.jTextField2FocusLost(evt);
            }
        });
        this.jTextField2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MemoryDumpPanel.this.jTextField2ActionPerformed(evt);
            }
        });
        this.jTextField2.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                MemoryDumpPanel.this.jTextField2KeyTyped(evt);
            }
        });
        this.jLabel3.setText("start");
        this.jTextField3.setPreferredSize(new Dimension(80, 21));
        this.jTextField3.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                MemoryDumpPanel.this.jTextField3FocusLost(evt);
            }
        });
        this.jTextField3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MemoryDumpPanel.this.jTextField3ActionPerformed(evt);
            }
        });
        this.jTextField3.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                MemoryDumpPanel.this.jTextField3KeyTyped(evt);
            }
        });
        this.jLabel4.setText("end");
        this.jCheckBoxActive.setSelected(true);
        this.jCheckBoxActive.setText("active");
        this.jCheckBoxActive.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MemoryDumpPanel.this.jCheckBoxActiveActionPerformed(evt);
            }
        });
        this.jSpinnerRasterWidth.setModel(new SpinnerNumberModel((Number)0, Integer.valueOf(0), null, (Number)1));
        this.jSpinnerRasterWidth.setValue(1);
        this.jSpinnerRasterWidth.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                MemoryDumpPanel.this.jSpinnerRasterWidthStateChanged(evt);
            }
        });
        this.jSpinnerRasterWidth.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                MemoryDumpPanel.this.jSpinnerRasterWidthFocusLost(evt);
            }
        });
        this.jSpinnerRasterWidth.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                MemoryDumpPanel.this.jSpinnerRasterWidthKeyTyped(evt);
            }
        });
        this.jPanel3.setPreferredSize(new Dimension(230, 161));
        this.jSliderSourceScale1.setMajorTickSpacing(1);
        this.jSliderSourceScale1.setMaximum(21);
        this.jSliderSourceScale1.setMinimum(1);
        this.jSliderSourceScale1.setMinorTickSpacing(1);
        this.jSliderSourceScale1.setValue(10);
        this.jSliderSourceScale1.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                MemoryDumpPanel.this.jSliderSourceScale1StateChanged(evt);
            }
        });
        this.jTextField10.setText("%Y %X");
        this.jTextField8.setText("%C");
        this.jTextFieldPatternName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MemoryDumpPanel.this.jTextFieldPatternNameActionPerformed(evt);
            }
        });
        this.jComboBoxPatterns.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBoxPatterns.setPreferredSize(new Dimension(92, 21));
        this.jComboBoxPatterns.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MemoryDumpPanel.this.jComboBoxPatternsActionPerformed(evt);
            }
        });
        this.jLabel1.setText("type");
        this.jButtonSave3.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/page_save.png")));
        this.jButtonSave3.setToolTipText("save current setting");
        this.jButtonSave3.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonSave3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MemoryDumpPanel.this.jButtonSave3ActionPerformed(evt);
            }
        });
        this.jButtonInterprete.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/accept.png")));
        this.jButtonInterprete.setToolTipText("Select previous, +SHIFT moves selected vectorlist one to the left.");
        this.jButtonInterprete.setHorizontalAlignment(2);
        this.jButtonInterprete.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonInterprete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MemoryDumpPanel.this.jButtonInterpreteActionPerformed(evt);
            }
        });
        this.jLabel25.setText("line 1");
        this.jLabel26.setText("line x");
        this.jLabel27.setText("last line");
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel25).addComponent(this.jLabel26).addComponent(this.jLabel27).addGroup(GroupLayout.Alignment.TRAILING, jPanel3Layout.createSequentialGroup().addComponent(this.jButtonInterprete, -2, 20, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButtonSave3))).addGap(8, 8, 8)).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jLabel1).addGap(25, 25, 25))).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextField8, -1, 177, Short.MAX_VALUE).addComponent(this.jTextField10, -1, 177, Short.MAX_VALUE).addComponent(this.jTextFieldPatternName, -1, 177, Short.MAX_VALUE).addComponent(this.jTextField9, -1, 177, Short.MAX_VALUE).addComponent(this.jComboBoxPatterns, 0, 177, Short.MAX_VALUE))).addComponent(this.jSliderSourceScale1, -1, 230, Short.MAX_VALUE));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jComboBoxPatterns, -2, 21, -2).addComponent(this.jLabel1, -2, 21, -2)).addGap(4, 4, 4).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonInterprete).addComponent(this.jButtonSave3).addComponent(this.jTextFieldPatternName, -2, 21, -2)).addGap(6, 6, 6).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel27, -2, 21, -2).addComponent(this.jTextField9, -2, 21, -2)).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel25, -2, 21, -2).addComponent(this.jTextField8, -2, 21, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel26, -2, 21, -2).addComponent(this.jTextField10, -2, 21, -2)).addGap(25, 25, 25))).addComponent(this.jSliderSourceScale1, -2, 22, -2).addGap(0, 14, Short.MAX_VALUE)));
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGap(2, 2, 2).addComponent(this.jPanel3, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jRadioButton1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButton2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSpinnerRasterWidth, -2, 60, -2).addGap(47, 47, 47).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextField2, -2, 80, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jTextField3, -2, 80, -2).addGap(34, 34, 34).addComponent(this.jCheckBoxActive).addContainerGap(237, Short.MAX_VALUE)).addComponent(this.single3dDisplayPanel1, -1, 972, Short.MAX_VALUE))));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGap(2, 2, 2).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jRadioButton2, -2, 21, -2).addComponent(this.jLabel2, -2, 21, -2).addComponent(this.jTextField2, -2, 21, -2).addComponent(this.jLabel3, -2, 21, -2).addComponent(this.jTextField3, -2, 21, -2).addComponent(this.jLabel4, -2, 21, -2).addComponent(this.jRadioButton1, -2, 21, -2).addComponent(this.jCheckBoxActive, -2, 21, -2).addComponent(this.jSpinnerRasterWidth, -2, 21, -2)).addGap(2, 2, 2).addComponent(this.single3dDisplayPanel1, -1, 473, Short.MAX_VALUE)).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jPanel3, -2, -1, -2).addContainerGap()))));
        this.jSplitPane1.setRightComponent(this.jPanel2);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane1));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane1));
    }

    private void jToggleButton4ActionPerformed(ActionEvent evt) {
        this.updateEnabled = this.jToggleButton4.isSelected();
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        int targetAdress = DASM6809.toNumber(((JButton)evt.getSource()).getText());
        this.goAddress(targetAdress);
    }

    private void jButton6jButton2ActionPerformed(ActionEvent evt) {
        if (this.vecxPanel == null) {
            return;
        }
        int targetAdress = this.vecxPanel.getXReg();
        this.goAddress(targetAdress);
    }

    private void jButton7jButton2ActionPerformed(ActionEvent evt) {
        if (this.vecxPanel == null) {
            return;
        }
        int targetAdress = this.vecxPanel.getYReg();
        this.goAddress(targetAdress);
    }

    private void jButton8jButton2ActionPerformed(ActionEvent evt) {
        if (this.vecxPanel == null) {
            return;
        }
        int targetAdress = this.vecxPanel.getSReg();
        this.goAddress(targetAdress);
    }

    private void jButton9jButton2ActionPerformed(ActionEvent evt) {
        if (this.vecxPanel == null) {
            return;
        }
        int targetAdress = this.vecxPanel.getUReg();
        this.goAddress(targetAdress);
    }

    private void jComboBoxPatternsActionPerformed(ActionEvent evt) {
        if (this.mClassSetting > 0) {
            return;
        }
        if (this.mClassSetting > 0) {
            return;
        }
        if (this.jComboBoxPatterns.getSelectedIndex() == -1) {
            return;
        }
        VeccyPanel.PatternInfo info = (VeccyPanel.PatternInfo)this.jComboBoxPatterns.getSelectedItem();
        this.jTextFieldPatternName.setText(info.name);
        this.jTextField8.setText(info.line1Pattern);
        this.jTextField10.setText(info.lineXPattern);
        this.jTextField9.setText(info.lastLinePattern);
        this.selectionChanged();
    }

    void doInterpret() {
        VeccyPanel.PatternInfo info = (VeccyPanel.PatternInfo)this.jComboBoxPatterns.getSelectedItem();
        if (info == null) {
            return;
        }
        if (this.startAddress == -1) {
            return;
        }
        if (this.endAddress == -1) {
            return;
        }
        if (this.endAddress < this.startAddress) {
            return;
        }
        StringBuffer b = new StringBuffer();
        try {
            MemoryInformation memInfo;
            int i;
            if (this.startAddress >= 51200 && this.endAddress <= 52223) {
                for (i = this.startAddress; i <= this.endAddress; ++i) {
                    memInfo = this.dissi.getMemoryInformation(i, this.vecxPanel.getCurrentBank());
                    b.append(" $").append(String.format("%02X", this.vecxPanel.getVecXMem8(i)));
                }
            } else {
                for (i = this.startAddress; i <= this.endAddress; ++i) {
                    memInfo = this.dissi.getMemoryInformation(i, this.vecxPanel.getCurrentBank());
                    b.append(" $").append(String.format("%02X", memInfo.content));
                }
            }
        }
        catch (Exception i) {
            // empty catch block
        }
        VeccyInterpreter interpreter = new VeccyInterpreter();
        interpreter.setPatterns(this.jTextField8.getText(), this.jTextField10.getText(), this.jTextField9.getText());
        ArrayList<Byte> data2 = interpreter.setData(b.toString());
        GFXVectorList newList = interpreter.getVectorList();
        this.single3dDisplayPanel1.setAnimation(new GFXVectorAnimation());
        this.single3dDisplayPanel1.setForegroundVectorList(newList);
        this.single3dDisplayPanel1.setDelay(-1);
    }

    void selectionChanged() {
        this.updateTable();
        if (!this.jCheckBoxActive.isSelected()) {
            return;
        }
        if (!this.jCheckBox1.isSelected()) {
            return;
        }
        if (this.jRadioButton1.isSelected()) {
            this.doInterpret();
        } else {
            this.doBitmap();
        }
    }

    public void setStartEndAddress(int start, int end2) {
        this.startAddress = start;
        this.endAddress = end2;
        this.jTextField2.setText("$" + String.format("%04X", this.startAddress));
        this.jTextField3.setText("$" + String.format("%04X", this.endAddress));
        this.selectionChanged();
        this.jTable1.repaint();
    }

    private void jTextField2ActionPerformed(ActionEvent evt) {
        this.startAddress = DASM6809.toNumber(this.jTextField2.getText());
        this.selectionChanged();
        this.jTable1.repaint();
    }

    private void jTextField3ActionPerformed(ActionEvent evt) {
        this.endAddress = DASM6809.toNumber(this.jTextField3.getText());
        this.selectionChanged();
        this.jTable1.repaint();
    }

    private void jTable1MousePressed(MouseEvent evt) {
        JTable table = (JTable)evt.getSource();
        Point p = evt.getPoint();
        int row = table.rowAtPoint(p);
        int col = table.columnAtPoint(p);
        boolean shift = false;
        if (evt != null) {
            shift = (evt.getModifiers() & 1) == 1;
        }
        MemoryDumpTableModel model = (MemoryDumpTableModel)this.jTable1.getModel();
        int address = model.getAddress(row, col);
        if (shift) {
            this.endAddress = address;
        } else {
            this.startAddress = address;
        }
        this.jTextField2.setText("$" + String.format("%04X", this.startAddress & 0xFFFF));
        this.jTextField3.setText("$" + String.format("%04X", this.endAddress & 0xFFFF));
        this.selectionChanged();
    }

    private void jSliderSourceScale1StateChanged(ChangeEvent evt) {
        int value = this.jSliderSourceScale1.getValue();
        int max = this.jSliderSourceScale1.getMaximum();
        double scale = value - (max - 1) / 2;
        if (value < max / 2 + 1) {
            int invScale = max / 2 + 2 - value;
            scale = 1.0 / (double)invScale;
        }
        this.single3dDisplayPanel1.setScale(scale);
        this.single3dDisplayPanel1.repaint();
    }

    private void jRadioButton2ActionPerformed(ActionEvent evt) {
        this.selectionChanged();
    }

    private void jRadioButton1ActionPerformed(ActionEvent evt) {
        this.selectionChanged();
    }

    private void jTextField2KeyTyped(KeyEvent evt) {
        this.startAddress = DASM6809.toNumber(this.jTextField2.getText());
        this.selectionChanged();
        this.jTable1.repaint();
    }

    private void jTextField3KeyTyped(KeyEvent evt) {
        this.endAddress = DASM6809.toNumber(this.jTextField3.getText());
        this.selectionChanged();
        this.jTable1.repaint();
    }

    private void jCheckBox1ActionPerformed(ActionEvent evt) {
        this.single3dDisplayPanel1.setRepaint(this.jCheckBoxActive.isSelected() && this.jCheckBox1.isSelected());
        if (this.jCheckBox1.isSelected()) {
            this.jSplitPane1.setDividerLocation(this.jSplitPane1.getSize().height - 250);
            this.jSplitPane1.setDividerSize(5);
        } else {
            this.jSplitPane1.setDividerLocation(this.jSplitPane1.getSize().height);
            this.jSplitPane1.setDividerSize(0);
        }
    }

    private void jSplitPane1ComponentResized(ComponentEvent evt) {
        this.jCheckBox1ActionPerformed(null);
    }

    private void jButtonInterpreteActionPerformed(ActionEvent evt) {
        this.selectionChanged();
    }

    private void jButtonSave3ActionPerformed(ActionEvent evt) {
        this.savePatterns();
    }

    private void jTextFieldPatternNameActionPerformed(ActionEvent evt) {
    }

    private void jCheckBoxActiveActionPerformed(ActionEvent evt) {
        this.single3dDisplayPanel1.setRepaint(this.jCheckBoxActive.isSelected() && this.jCheckBox1.isSelected());
    }

    private void jSpinnerRasterWidthStateChanged(ChangeEvent evt) {
        this.bitmapWidth = UtilityString.Int0(this.jSpinnerRasterWidth.getValue().toString());
        this.selectionChanged();
    }

    private void jSpinnerRasterWidthKeyTyped(KeyEvent evt) {
        JFormattedTextField tf = ((JSpinner.DefaultEditor)this.jSpinnerRasterWidth.getEditor()).getTextField();
        String wi = tf.getText();
        this.bitmapWidth = UtilityString.Int0(wi);
        this.selectionChanged();
    }

    private void jTextField2FocusLost(FocusEvent evt) {
        this.startAddress = DASM6809.toNumber(this.jTextField2.getText());
        this.selectionChanged();
    }

    private void jTextField3FocusLost(FocusEvent evt) {
        this.endAddress = DASM6809.toNumber(this.jTextField3.getText());
        this.selectionChanged();
    }

    private void jSpinnerRasterWidthFocusLost(FocusEvent evt) {
        JFormattedTextField tf = ((JSpinner.DefaultEditor)this.jSpinnerRasterWidth.getEditor()).getTextField();
        String wi = tf.getText();
        this.bitmapWidth = UtilityString.Int0(wi);
        this.selectionChanged();
    }

    private void jButtonCopyActionPerformed(ActionEvent evt) {
        this.toClipboard();
    }

    public void updateTable() {
        this.jTable1.repaint();
    }

    @Override
    public String getID() {
        return SID;
    }

    @Override
    public String getFileID() {
        return UtilityString.replace(UtilityString.replace(UtilityString.replace(UtilityString.replaceWhiteSpaces(SID, ""), ":", ""), "(", ""), ")", "");
    }

    @Override
    public Serializable getAdditionalStateinfo() {
        return null;
    }

    @Override
    public void setAdditionalStateinfo(Serializable ser) {
    }

    public void goAddress(int address) {
        int row = address / 16;
        if (row == -1) {
            return;
        }
        this.jTable1.setRowSelectionInterval(row, row);
        MemoryDumpPanel.scrollToVisible(this.jTable1, row, 0);
    }

    public static void scrollToVisible(JTable table, int rowIndex, int vColIndex) {
        JViewport vp = (JViewport)table.getParent();
        int bottomIndex = table.getModel().getRowCount() - 1;
        table.setRowSelectionInterval(bottomIndex, bottomIndex);
        table.changeSelection(bottomIndex, 0, false, false);
        Rectangle r = table.getCellRect(bottomIndex - 1, 0, true);
        int vph = vp.getExtentSize().height;
        r.y += vph;
        table.scrollRectToVisible(r);
        int currentSelectedRow = table.getSelectedRow();
        try {
            table.changeSelection(rowIndex, 0, false, false);
            if (rowIndex > currentSelectedRow) {
                r = table.getCellRect(rowIndex - 1, 0, true);
                vph = vp.getExtentSize().height;
                r.y += vph;
                table.scrollRectToVisible(r);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    String asciiDump(int row) {
        if (this.vecxPanel == null) {
            return "";
        }
        String dump = "";
        for (int i = 0; i < 16; ++i) {
            int v = this.vecxPanel.getVecXMem8(row * 16 + i) & 0xFF;
            if (v < 32) {
                dump = dump + ".";
            } else if (v > 127) {
                dump = dump + ".";
            }
            dump = dump + (char)v;
        }
        return dump;
    }

    @Override
    public void updateValues(boolean forceUpdate) {
        if (!forceUpdate && !this.updateEnabled) {
            return;
        }
        this.update();
    }

    @Override
    public void setUpdateEnabled(boolean b) {
        this.updateEnabled = b;
    }

    void doBitmap() {
        if (this.startAddress == -1) {
            return;
        }
        if (this.endAddress == -1) {
            return;
        }
        if (this.endAddress < this.startAddress) {
            return;
        }
        if (this.oldStart == this.startAddress && this.oldEnd == this.endAddress && this.oldWidth == this.bitmapWidth) {
            return;
        }
        this.oldStart = this.startAddress;
        this.oldEnd = this.endAddress;
        this.oldWidth = this.bitmapWidth;
        this.single3dDisplayPanel1.clearVectors();
        int targetWidth = this.bitmapWidth;
        if (targetWidth == 0) {
            return;
        }
        int targetHeight = (this.endAddress - this.startAddress) / targetWidth;
        this.single3dDisplayPanel1.setSharedRepaint(false);
        this.single3dDisplayPanel1.suspendRepaint();
        int vy = 0 + targetHeight / 2;
        for (int y = 0; y < targetHeight; ++y) {
            int vx = 0 - targetWidth / 2 * 8;
            for (int x = 0; x < targetWidth; ++x) {
                int address = this.startAddress + y * targetWidth + x;
                MemoryInformation memInfo = this.dissi.getMemoryInformation(address, this.vecxPanel.getCurrentBank());
                int brightness = 255;
                int shiftreg = memInfo.content;
                if (address > 51200 && address < 52224 && this.dissi != null) {
                    shiftreg = this.dissi.getVecXPanel().getVecXMem8(address);
                }
                for (int b = 0; b < 8; ++b) {
                    boolean bit = (shiftreg & 0x80) != 0;
                    shiftreg <<= 1;
                    int pattern = bit ? 255 : 0;
                    int sx = vx;
                    int ex = vx + 1;
                    GFXVector v = new GFXVector();
                    v.start.x(sx);
                    v.start.y(vy);
                    v.end.x(ex);
                    v.end.y(vy);
                    v.pattern = pattern;
                    v.setIntensity(brightness);
                    this.single3dDisplayPanel1.addForegroundVector(v);
                    ++vx;
                    if (b != 7) continue;
                    sx = vx;
                    ex = vx + 1;
                    v = new GFXVector();
                    v.start.x(sx);
                    v.start.y(vy);
                    v.end.x(ex);
                    v.end.y(vy);
                    v.pattern = pattern;
                    v.setIntensity(brightness);
                    this.single3dDisplayPanel1.addForegroundVector(v);
                    ++vx;
                }
            }
            --vy;
        }
        this.single3dDisplayPanel1.continueRepaint();
        this.single3dDisplayPanel1.setSharedRepaint(true);
    }

    protected boolean savePatterns() {
        VeccyPanel.PatternInfo ti = new VeccyPanel.PatternInfo();
        ti.name = this.jTextFieldPatternName.getText();
        if (ti.name.trim().length() == 0) {
            return false;
        }
        ti.line1Pattern = this.jTextField8.getText();
        ti.lineXPattern = this.jTextField10.getText();
        ti.lastLinePattern = this.jTextField9.getText();
        for (int i = 0; i < this.knownPatterns.size(); ++i) {
            if (!this.knownPatterns.elementAt(i).equals(ti)) continue;
            return true;
        }
        this.knownPatterns.addElement(ti);
        try {
            CSAMainFrame.serialize(this.knownPatterns, Global.mainPathPrefix + "serialize" + File.separator + "PatternInfo.ser");
        }
        catch (Throwable e) {
            return false;
        }
        ++this.mClassSetting;
        this.jComboBoxPatterns.setModel(new DefaultComboBoxModel<VeccyPanel.PatternInfo>(this.knownPatterns));
        this.jComboBoxPatterns.setSelectedIndex(this.knownPatterns.size() - 1);
        --this.mClassSetting;
        return true;
    }

    @Override
    public void deIconified() {
    }

    private static Clipboard getSystemClipboard() {
        Toolkit defaultToolkit = Toolkit.getDefaultToolkit();
        Clipboard systemClipboard = defaultToolkit.getSystemClipboard();
        return systemClipboard;
    }

    public void toClipboard() {
        if (this.startAddress == -1) {
            return;
        }
        if (this.endAddress == -1) {
            return;
        }
        if (this.endAddress < this.startAddress) {
            return;
        }
        StringBuffer b = new StringBuffer();
        try {
            this.startAddress /= 16;
            this.startAddress *= 16;
            this.endAddress += 15;
            this.endAddress /= 16;
            this.endAddress *= 16;
            if (this.startAddress >= 51200 && this.endAddress <= 52223) {
                boolean somethingDone = false;
                for (int i = this.startAddress; i <= this.endAddress; ++i) {
                    if (i % 16 == 0) {
                        if (somethingDone) {
                            b.append("\n");
                        }
                        b.append(String.format("%04X     ", i));
                        somethingDone = true;
                    }
                    MemoryInformation memInfo = this.dissi.getMemoryInformation(i, this.vecxPanel.getCurrentBank());
                    b.append(String.format("%02X ", this.vecxPanel.getVecXMem8(i)));
                }
            } else {
                for (int i = this.startAddress; i <= this.endAddress; ++i) {
                    boolean somethingDone = false;
                    MemoryInformation memInfo = this.dissi.getMemoryInformation(i, this.vecxPanel.getCurrentBank());
                    if (i % 16 == 0) {
                        if (somethingDone) {
                            b.append("\n");
                        }
                        b.append(String.format("%04X     ", i));
                        somethingDone = true;
                    }
                    b.append(String.format("%02X ", memInfo.content));
                }
            }
        }
        catch (Exception i) {
            // empty catch block
        }
        Clipboard clipboard = MemoryDumpPanel.getSystemClipboard();
        try {
            clipboard.setContents(new StringSelection(b.toString()), null);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public class MemoryDumpTableModel
    extends AbstractTableModel {
        @Override
        public int getRowCount() {
            return 4096;
        }

        @Override
        public int getColumnCount() {
            return 18;
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (MemoryDumpPanel.this.vecxPanel == null) {
                return "";
            }
            if (col == 0) {
                return "$" + String.format("%04X", this.getAddress(row, col) + 1);
            }
            if (col == 17) {
                return MemoryDumpPanel.this.asciiDump(row);
            }
            return "$" + String.format("%02X", MemoryDumpPanel.this.vecxPanel.getVecXMem8(this.getAddress(row, col)));
        }

        public int getIntegerValueAt(int row, int col) {
            if (MemoryDumpPanel.this.vecxPanel == null) {
                return -1;
            }
            if (col == 0) {
                return -1;
            }
            if (col == 17) {
                return -1;
            }
            return MemoryDumpPanel.this.vecxPanel.getVecXMem8(this.getAddress(row, col));
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (aValue == null) {
                return;
            }
            String v = aValue.toString();
            int iv = DASM6809.toNumber(v) & 0xFF;
            if (MemoryDumpPanel.this.dissi != null) {
                MemoryDumpPanel.this.dissi.doThePoke(this.getAddress(rowIndex, columnIndex), (byte)iv);
            }
        }

        public int getAddress(int row, int col) {
            return row * 16 + (col - 1);
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return "Address";
            }
            if (column == 17) {
                return "Chars";
            }
            return "$" + String.format("%02X", (column & 0xFF) - 1);
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return String.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex != 0 && columnIndex != 17;
        }

        public int getColWidth(int col) {
            if (col == 0) {
                return 40;
            }
            if (col == 17) {
                return 120;
            }
            return 20;
        }

        public Color getBackground(int col) {
            if (col == 0) {
                return MemoryDumpPanel.this.config.tableAddress;
            }
            return null;
        }
    }
}

