/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.vecx.panels;

import de.malban.Global;
import de.malban.config.Configuration;
import de.malban.graphics.SingleImagePanel;
import de.malban.gui.CSAMainFrame;
import de.malban.gui.HotKey;
import de.malban.gui.Stateable;
import de.malban.gui.Windowable;
import de.malban.gui.components.CSATableModel;
import de.malban.gui.components.CSATablePanel;
import de.malban.gui.components.CSAView;
import de.malban.gui.components.DoubleClickAction;
import de.malban.gui.components.SelectionChangedListener;
import de.malban.gui.components.SelectionEvent;
import de.malban.gui.dialogs.ShowErrorDialog;
import de.malban.gui.panels.LogPanel;
import de.malban.util.DownloaderPanel;
import de.malban.util.UtilityString;
import de.malban.vide.VideConfig;
import de.malban.vide.vecx.VecXPanel;
import de.malban.vide.vecx.cartridge.Cartridge;
import de.malban.vide.vecx.cartridge.CartridgeProperties;
import de.malban.vide.vecx.cartridge.CartridgePropertiesPool;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;

public class StarterJPanel
extends JPanel
implements Windowable,
Stateable,
SelectionChangedListener {
    transient LogPanel log = (LogPanel)Configuration.getConfiguration().getDebugEntity();
    private CSAView mParent = null;
    boolean myImageShown;
    private JMenuItem mParentMenuItem;
    private int mClassSetting;
    public static String SID = "Starter";
    private CartridgeProperties mCartridgeProperties;
    ArrayList<CartridgeProperties> allCartridges;
    public static String[] headers = new String[]{"Name", "Author", "Year", "Homebrew", "Demo", "Snippet", "Game", "Cart", "Front", "Back", "InGame"};
    CartridgeTableModel model;
    private CSATablePanel cSATablePanel1;
    private JButton jButtonFileSelect12;
    private JButton jButtonFileSelect2;
    private JCheckBox jCheckBox1;
    private JCheckBox jCheckBox10;
    private JCheckBox jCheckBox11;
    private JCheckBox jCheckBox12;
    private JCheckBox jCheckBox13;
    private JCheckBox jCheckBox14;
    private JCheckBox jCheckBox15;
    private JCheckBox jCheckBox16;
    private JCheckBox jCheckBox17;
    private JCheckBox jCheckBox18;
    private JCheckBox jCheckBox19;
    private JCheckBox jCheckBox2;
    private JCheckBox jCheckBox20;
    private JCheckBox jCheckBox21;
    private JCheckBox jCheckBox22;
    private JCheckBox jCheckBox23;
    private JCheckBox jCheckBox24;
    private JCheckBox jCheckBox25;
    private JCheckBox jCheckBox26;
    private JCheckBox jCheckBox3;
    private JCheckBox jCheckBox4;
    private JCheckBox jCheckBox48KROM;
    private JCheckBox jCheckBox5;
    private JCheckBox jCheckBox6;
    private JCheckBox jCheckBox7;
    private JCheckBox jCheckBox8;
    private JCheckBox jCheckBox9;
    private JCheckBox jCheckBoxPB6IRQ;
    private JCheckBox jCheckBoxXmas1;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel17;
    private JLabel jLabel18;
    private JLabel jLabel2;
    private JLabel jLabel22;
    private JLabel jLabel23;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel7;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane4;
    private JScrollPane jScrollPane5;
    private JTabbedPane jTabbedPane1;
    private JTextField jTextField1;
    private JTextField jTextField2;
    private JTextField jTextField3;
    private JTextField jTextField4;
    private JTextField jTextFieldPath;
    private JTextField jTextFieldPath3;
    private JTextPane jTextPane1;
    private JTextPane jTextPane2;
    private JTextPane jTextPane3;
    private JTextPane jTextPane4;
    private JTextPane jTextPane5;
    private SingleImagePanel singleImagePanel1;
    private SingleImagePanel singleImagePanel2;
    private SingleImagePanel singleImagePanel3;
    private SingleImagePanel singleImagePanel4;
    private SingleImagePanel singleImagePanel5;

    @Override
    public boolean isLoadSettings() {
        return true;
    }

    @Override
    public String getID() {
        return SID;
    }

    @Override
    public String getFileID() {
        return UtilityString.replace(UtilityString.replace(UtilityString.replace(UtilityString.replaceWhiteSpaces(SID, ""), ":", ""), "(", ""), ")", "");
    }

    @Override
    public Serializable getAdditionalStateinfo() {
        return null;
    }

    @Override
    public void setAdditionalStateinfo(Serializable ser) {
    }

    @Override
    public void closing() {
        this.deinit();
    }

    @Override
    public boolean isIcon() {
        CSAMainFrame frame = Configuration.getConfiguration().getMainFrame();
        if (frame.getInternalFrame(this) == null) {
            return false;
        }
        return frame.getInternalFrame(this).isIcon();
    }

    @Override
    public void setIcon(boolean b) {
        CSAMainFrame frame = Configuration.getConfiguration().getMainFrame();
        if (frame.getInternalFrame(this) == null) {
            return;
        }
        try {
            frame.getInternalFrame(this).setIcon(b);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void setParentWindow(CSAView jpv) {
        this.mParent = jpv;
    }

    @Override
    public void setMenuItem(JMenuItem item) {
        this.mParentMenuItem = item;
        this.mParentMenuItem.setText(SID);
    }

    @Override
    public JMenuItem getMenuItem() {
        return this.mParentMenuItem;
    }

    @Override
    public JPanel getPanel() {
        return this;
    }

    public void deinit() {
    }

    public StarterJPanel() {
        this.myImageShown = VideConfig.getConfig().loadStarterImages;
        this.mParentMenuItem = null;
        this.mClassSetting = 0;
        this.mCartridgeProperties = null;
        this.allCartridges = new ArrayList();
        this.model = new CartridgeTableModel();
        this.initComponents();
        if (Global.getOSName().toUpperCase().contains("MAC")) {
            HotKey.addMacDefaults(this.jTextField1);
            HotKey.addMacDefaults(this.jTextField2);
            HotKey.addMacDefaults(this.jTextField3);
            HotKey.addMacDefaults(this.jTextField4);
            HotKey.addMacDefaults(this.jTextFieldPath);
            HotKey.addMacDefaults(this.jTextFieldPath3);
            HotKey.addMacDefaults(this.jTextPane1);
            HotKey.addMacDefaults(this.jTextPane2);
            HotKey.addMacDefaults(this.jTextPane3);
            HotKey.addMacDefaults(this.jTextPane4);
            HotKey.addMacDefaults(this.jTextPane5);
        }
        this.loadAllCartridged();
        this.cSATablePanel1.setRowHeight(102);
        this.cSATablePanel1.setTableStyleSwitchingEnabled(false);
        this.cSATablePanel1.setModel(CSATableModel.buildTableModel(this.model));
        this.cSATablePanel1.addSelectionListerner(this);
        this.cSATablePanel1.setDoubleClickAction(new DoubleClickAction(){

            @Override
            public void doIt() {
                int[] rows = StarterJPanel.this.cSATablePanel1.getSelectedRows();
                if (rows.length > 0) {
                    StarterJPanel.this.startCartridge(rows[0]);
                }
            }
        });
    }

    private void initComponents() {
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel1 = new JPanel();
        this.jButtonFileSelect2 = new JButton();
        this.jTextFieldPath = new JTextField();
        this.jLabel7 = new JLabel();
        this.jLabel1 = new JLabel();
        this.jTextField1 = new JTextField();
        this.jTextField2 = new JTextField();
        this.jLabel2 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jTextField3 = new JTextField();
        this.jLabel10 = new JLabel();
        this.jTextField4 = new JTextField();
        this.jCheckBox11 = new JCheckBox();
        this.jCheckBox12 = new JCheckBox();
        this.jCheckBox13 = new JCheckBox();
        this.jCheckBox14 = new JCheckBox();
        this.singleImagePanel3 = new SingleImagePanel();
        this.jLabel11 = new JLabel();
        this.jTextFieldPath3 = new JTextField();
        this.jLabel12 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jTextPane1 = new JTextPane();
        this.jCheckBox10 = new JCheckBox();
        this.jCheckBox3 = new JCheckBox();
        this.jCheckBox6 = new JCheckBox();
        this.jCheckBox5 = new JCheckBox();
        this.jCheckBox7 = new JCheckBox();
        this.jCheckBox4 = new JCheckBox();
        this.jCheckBox2 = new JCheckBox();
        this.jCheckBox9 = new JCheckBox();
        this.jCheckBox8 = new JCheckBox();
        this.jCheckBox15 = new JCheckBox();
        this.jCheckBox1 = new JCheckBox();
        this.jCheckBox16 = new JCheckBox();
        this.jCheckBox17 = new JCheckBox();
        this.jCheckBox18 = new JCheckBox();
        this.jCheckBox19 = new JCheckBox();
        this.jCheckBox20 = new JCheckBox();
        this.jCheckBox21 = new JCheckBox();
        this.jCheckBox22 = new JCheckBox();
        this.jCheckBox23 = new JCheckBox();
        this.jCheckBox48KROM = new JCheckBox();
        this.jCheckBox26 = new JCheckBox();
        this.jCheckBox25 = new JCheckBox();
        this.jCheckBoxXmas1 = new JCheckBox();
        this.jCheckBox24 = new JCheckBox();
        this.jCheckBoxPB6IRQ = new JCheckBox();
        this.jPanel2 = new JPanel();
        this.jScrollPane3 = new JScrollPane();
        this.jTextPane2 = new JTextPane();
        this.jButtonFileSelect12 = new JButton();
        this.jPanel3 = new JPanel();
        this.singleImagePanel1 = new SingleImagePanel();
        this.singleImagePanel2 = new SingleImagePanel();
        this.jPanel4 = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.jTextPane3 = new JTextPane();
        this.jPanel7 = new JPanel();
        this.jLabel17 = new JLabel();
        this.jScrollPane4 = new JScrollPane();
        this.jTextPane4 = new JTextPane();
        this.jLabel18 = new JLabel();
        this.jScrollPane5 = new JScrollPane();
        this.jTextPane5 = new JTextPane();
        this.jLabel22 = new JLabel();
        this.singleImagePanel4 = new SingleImagePanel();
        this.jLabel23 = new JLabel();
        this.singleImagePanel5 = new SingleImagePanel();
        this.cSATablePanel1 = new CSATablePanel();
        this.setName("regi");
        this.jButtonFileSelect2.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/page_link.png")));
        this.jButtonFileSelect2.setToolTipText("opens system browser to homepage");
        this.jButtonFileSelect2.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonFileSelect2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StarterJPanel.this.jButtonFileSelect2ActionPerformed(evt);
            }
        });
        this.jLabel7.setText("Homepage");
        this.jLabel1.setText("Author");
        this.jTextField2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StarterJPanel.this.jTextField2ActionPerformed(evt);
            }
        });
        this.jLabel2.setText("Cart name");
        this.jLabel6.setText("Year");
        this.jLabel10.setText("CRC");
        this.jCheckBox11.setText("Complete game");
        this.jCheckBox12.setText("Demo");
        this.jCheckBox13.setText("Snippet");
        this.jCheckBox14.setText("Homebrew");
        this.singleImagePanel3.setDrawCheckers(true);
        this.singleImagePanel3.setMaximumSize(new Dimension(138, 198));
        this.singleImagePanel3.setMinimumSize(new Dimension(138, 198));
        GroupLayout singleImagePanel3Layout = new GroupLayout(this.singleImagePanel3);
        this.singleImagePanel3.setLayout(singleImagePanel3Layout);
        singleImagePanel3Layout.setHorizontalGroup(singleImagePanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 149, Short.MAX_VALUE));
        singleImagePanel3Layout.setVerticalGroup(singleImagePanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 216, Short.MAX_VALUE));
        this.jLabel11.setText("Rights");
        this.jLabel12.setText("Licence");
        this.jScrollPane1.setViewportView(this.jTextPane1);
        this.jCheckBox10.setText("RAM RA Spectrum");
        this.jCheckBox3.setText("Lightpen Port 1");
        this.jCheckBox3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StarterJPanel.this.jCheckBox3ActionPerformed(evt);
            }
        });
        this.jCheckBox6.setText("extreme multi");
        this.jCheckBox6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StarterJPanel.this.jCheckBox6ActionPerformed(evt);
            }
        });
        this.jCheckBox5.setText("3d Imager");
        this.jCheckBox5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StarterJPanel.this.jCheckBox5ActionPerformed(evt);
            }
        });
        this.jCheckBox7.setText("Bankswitch Dondzila");
        this.jCheckBox4.setText("Lightpen Port 2");
        this.jCheckBox4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StarterJPanel.this.jCheckBox4ActionPerformed(evt);
            }
        });
        this.jCheckBox2.setText("eEprom DS2430A");
        this.jCheckBox9.setText("RAM Animaction");
        this.jCheckBox8.setText("Bankswitch VecFlash");
        this.jCheckBox8.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StarterJPanel.this.jCheckBox8ActionPerformed(evt);
            }
        });
        this.jCheckBox15.setText("VecVox");
        this.jCheckBox1.setText("VecVoice");
        this.jCheckBox16.setText("Microchip 11AA010");
        this.jCheckBox16.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StarterJPanel.this.jCheckBox16ActionPerformed(evt);
            }
        });
        this.jCheckBox17.setText("DualVec1");
        this.jCheckBox18.setText("DualVec2");
        this.jCheckBox19.setText("RAM Logo");
        this.jCheckBox20.setText("XMas LED");
        this.jCheckBox21.setText("eEprom DS2431");
        this.jCheckBox22.setText("32k forced");
        this.jCheckBox23.setText("SID");
        this.jCheckBox48KROM.setText("48k ROM");
        this.jCheckBox26.setText("Atmel");
        this.jCheckBox26.setMargin(new Insets(0, 2, 1, 0));
        this.jCheckBox26.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StarterJPanel.this.jCheckBox26ActionPerformed(evt);
            }
        });
        this.jCheckBox25.setText("PIC");
        this.jCheckBox25.setEnabled(false);
        this.jCheckBox25.setMargin(new Insets(0, 2, 1, 0));
        this.jCheckBoxXmas1.setText("16k BS");
        this.jCheckBoxXmas1.setEnabled(false);
        this.jCheckBoxXmas1.setMargin(new Insets(0, 2, 1, 0));
        this.jCheckBoxXmas1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StarterJPanel.this.jCheckBoxXmas1ActionPerformed(evt);
            }
        });
        this.jCheckBox24.setText("Keyboard");
        this.jCheckBox24.setEnabled(false);
        this.jCheckBox24.setMargin(new Insets(0, 2, 1, 0));
        this.jCheckBox24.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StarterJPanel.this.jCheckBox24ActionPerformed(evt);
            }
        });
        this.jCheckBoxPB6IRQ.setText("BS PB6 & IRQ");
        this.jCheckBoxPB6IRQ.setMargin(new Insets(0, 2, 1, 0));
        this.jCheckBoxPB6IRQ.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StarterJPanel.this.jCheckBoxPB6IRQActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(6, 6, 6).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.jLabel1).addComponent(this.jLabel7).addComponent(this.jLabel11).addComponent(this.jLabel12)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jTextFieldPath3, GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.LEADING, jPanel1Layout.createSequentialGroup().addComponent(this.jTextField1, -2, 127, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jTextField3, -2, 57, -2)).addGroup(GroupLayout.Alignment.LEADING, jPanel1Layout.createSequentialGroup().addComponent(this.jTextField2, -2, 127, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel10).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jTextField4, -2, 57, -2)).addGroup(GroupLayout.Alignment.LEADING, jPanel1Layout.createSequentialGroup().addComponent(this.jTextFieldPath, -2, 208, -2).addGap(18, 18, 18).addComponent(this.jButtonFileSelect2)).addComponent(this.jScrollPane1, GroupLayout.Alignment.LEADING, -2, 247, -2)).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBox11).addComponent(this.jCheckBox12)).addGap(18, 18, 18).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBox13).addComponent(this.jCheckBox14)))).addGap(4, 4, 4).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBox1).addComponent(this.jCheckBox15).addComponent(this.jCheckBox2).addComponent(this.jCheckBox16).addComponent(this.jCheckBox9).addComponent(this.jCheckBox10).addComponent(this.jCheckBox3).addComponent(this.jCheckBox4).addComponent(this.jCheckBox5).addComponent(this.jCheckBox6).addComponent(this.jCheckBoxPB6IRQ, -1, -1, Short.MAX_VALUE).addComponent(this.jCheckBox7).addComponent(this.jCheckBox8).addComponent(this.jCheckBox17).addComponent(this.jCheckBox18)).addGap(1, 1, 1).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.singleImagePanel3, -2, -1, -2).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBox22).addComponent(this.jCheckBox21).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBox19).addComponent(this.jCheckBox20)).addGap(27, 27, 27).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBox23).addComponent(this.jCheckBox48KROM)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBox24, -2, 82, -2).addComponent(this.jCheckBoxXmas1).addComponent(this.jCheckBox26, -2, 96, -2).addComponent(this.jCheckBox25, -2, 105, -2)))).addContainerGap(34, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(6, 6, 6).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jTextField2, -2, -1, -2).addComponent(this.jLabel10).addComponent(this.jTextField4, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jTextField1, -2, -1, -2).addComponent(this.jLabel6).addComponent(this.jTextField3, -2, -1, -2)).addGap(7, 7, 7).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7).addComponent(this.jTextFieldPath, -2, -1, -2)).addComponent(this.jButtonFileSelect2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel11).addComponent(this.jTextFieldPath3, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel12).addComponent(this.jScrollPane1, -2, 162, -2)).addGap(8, 8, 8).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jCheckBox11).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBox12)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jCheckBox13).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBox14)))).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jCheckBox1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBox15).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBox2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBox16).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBox9).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBox10).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBox3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBox4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBox5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBox6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jCheckBoxPB6IRQ)).addComponent(this.singleImagePanel3, -2, -1, -2)).addGap(2, 2, 2).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBox26).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBox19).addComponent(this.jCheckBox23)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBox20).addComponent(this.jCheckBox48KROM).addComponent(this.jCheckBox25)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBox21).addComponent(this.jCheckBoxXmas1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBox22).addComponent(this.jCheckBox24))).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jCheckBox7).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBox8).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBox17).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBox18))))).addContainerGap(49, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab("Information", this.jPanel1);
        this.jScrollPane3.setViewportView(this.jTextPane2);
        this.jButtonFileSelect12.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/gui/Adobe_PDF_file_icon_16x16.png")));
        this.jButtonFileSelect12.setToolTipText("open system pdf viewer");
        this.jButtonFileSelect12.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonFileSelect12.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StarterJPanel.this.jButtonFileSelect12ActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonFileSelect12).addComponent(this.jScrollPane3, -1, 739, Short.MAX_VALUE)).addGap(0, 0, 0)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.jButtonFileSelect12).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane3, -1, 340, Short.MAX_VALUE).addGap(0, 0, 0)));
        this.jTabbedPane1.addTab("Instruction", this.jPanel2);
        GroupLayout singleImagePanel1Layout = new GroupLayout(this.singleImagePanel1);
        this.singleImagePanel1.setLayout(singleImagePanel1Layout);
        singleImagePanel1Layout.setHorizontalGroup(singleImagePanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 247, Short.MAX_VALUE));
        singleImagePanel1Layout.setVerticalGroup(singleImagePanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 332, Short.MAX_VALUE));
        GroupLayout singleImagePanel2Layout = new GroupLayout(this.singleImagePanel2);
        this.singleImagePanel2.setLayout(singleImagePanel2Layout);
        singleImagePanel2Layout.setHorizontalGroup(singleImagePanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 246, Short.MAX_VALUE));
        singleImagePanel2Layout.setVerticalGroup(singleImagePanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 332, Short.MAX_VALUE));
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 749, Short.MAX_VALUE).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGap(18, 18, 18).addComponent(this.singleImagePanel1, -2, -1, -2).addContainerGap(484, Short.MAX_VALUE))).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGap(291, 291, 291).addComponent(this.singleImagePanel2, -2, -1, -2).addContainerGap(212, Short.MAX_VALUE))));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 367, Short.MAX_VALUE).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.singleImagePanel1, -1, -1, -2).addContainerGap())).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.singleImagePanel2, -1, -1, -2).addContainerGap())));
        this.jTabbedPane1.addTab("Front", this.jPanel3);
        this.jScrollPane2.setViewportView(this.jTextPane3);
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.jScrollPane2, -1, 749, Short.MAX_VALUE).addGap(0, 0, 0)));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.jScrollPane2, -1, 367, Short.MAX_VALUE).addGap(0, 0, 0)));
        this.jTabbedPane1.addTab("Critics", this.jPanel4);
        this.jLabel17.setText("Eastereggs");
        this.jScrollPane4.setViewportView(this.jTextPane4);
        this.jLabel18.setText("Cheats");
        this.jScrollPane5.setViewportView(this.jTextPane5);
        this.jLabel22.setText("In game image");
        this.singleImagePanel4.setDrawCheckers(true);
        this.singleImagePanel4.setMaximumSize(new Dimension(138, 198));
        this.singleImagePanel4.setMinimumSize(new Dimension(138, 198));
        GroupLayout singleImagePanel4Layout = new GroupLayout(this.singleImagePanel4);
        this.singleImagePanel4.setLayout(singleImagePanel4Layout);
        singleImagePanel4Layout.setHorizontalGroup(singleImagePanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        singleImagePanel4Layout.setVerticalGroup(singleImagePanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        this.jLabel23.setText("Cartridge");
        this.singleImagePanel5.setDrawCheckers(true);
        this.singleImagePanel5.setMaximumSize(new Dimension(138, 198));
        this.singleImagePanel5.setMinimumSize(new Dimension(138, 198));
        GroupLayout singleImagePanel5Layout = new GroupLayout(this.singleImagePanel5);
        this.singleImagePanel5.setLayout(singleImagePanel5Layout);
        singleImagePanel5Layout.setHorizontalGroup(singleImagePanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        singleImagePanel5Layout.setVerticalGroup(singleImagePanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        GroupLayout jPanel7Layout = new GroupLayout(this.jPanel7);
        this.jPanel7.setLayout(jPanel7Layout);
        jPanel7Layout.setHorizontalGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel7Layout.createSequentialGroup().addContainerGap().addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jScrollPane4, -2, 394, -2).addComponent(this.jLabel18).addComponent(this.jLabel17).addComponent(this.jScrollPane5, -2, 394, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel22).addComponent(this.singleImagePanel4, -2, 125, -2).addComponent(this.jLabel23).addComponent(this.singleImagePanel5, -2, 125, -2))));
        jPanel7Layout.setVerticalGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel7Layout.createSequentialGroup().addContainerGap().addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel17).addComponent(this.jLabel23)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jScrollPane4, -1, 131, Short.MAX_VALUE).addComponent(this.singleImagePanel5, -2, 131, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel18).addComponent(this.jLabel22)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.singleImagePanel4, -2, 153, Short.MAX_VALUE).addComponent(this.jScrollPane5, -1, 153, Short.MAX_VALUE)).addContainerGap()));
        this.jTabbedPane1.addTab("Other", this.jPanel7);
        this.cSATablePanel1.setXMLId("StarterTable");
        this.cSATablePanel1.setPreferredSize(null);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, 0).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTabbedPane1).addComponent(this.cSATablePanel1, -1, -1, Short.MAX_VALUE))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.cSATablePanel1, -1, 323, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTabbedPane1, -2, 395, -2).addGap(0, 0, 0)));
    }

    private void jButtonFileSelect2ActionPerformed(ActionEvent evt) {
        if (this.jTextFieldPath.getText().trim().length() <= 7) {
            return;
        }
        try {
            if (Desktop.isDesktopSupported()) {
                Desktop.getDesktop().browse(new URI(this.jTextFieldPath.getText()));
            } else {
                Runtime runtime = Runtime.getRuntime();
                runtime.exec("/usr/bin/firefox -new-window " + this.jTextFieldPath.getText());
            }
        }
        catch (Throwable e) {
            this.log.addLog(e, LogPanel.WARN);
        }
    }

    private void jCheckBox3ActionPerformed(ActionEvent evt) {
    }

    private void jCheckBox4ActionPerformed(ActionEvent evt) {
    }

    private void jCheckBox5ActionPerformed(ActionEvent evt) {
    }

    private void jCheckBox6ActionPerformed(ActionEvent evt) {
    }

    private void jCheckBox8ActionPerformed(ActionEvent evt) {
    }

    private void jButtonFileSelect12ActionPerformed(ActionEvent evt) {
        Thread pdfLoaderThread = new Thread(){

            @Override
            public void run() {
                if (StarterJPanel.this.mCartridgeProperties == null) {
                    return;
                }
                if (!DownloaderPanel.ensureLocalFile("PDF", StarterJPanel.this.mCartridgeProperties.getPDFLink(), Global.mainPathPrefix + StarterJPanel.this.mCartridgeProperties.getPDFFile())) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ShowErrorDialog.showErrorDialog("Error loading PDF for: " + StarterJPanel.this.mCartridgeProperties.getCartName() + "!");
                        }
                    });
                } else {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            StarterJPanel.this.startPDFCallback();
                        }
                    });
                }
            }
        };
        pdfLoaderThread.start();
    }

    private void startPDFCallback() {
        if (this.mCartridgeProperties.getPDFFile() != null && this.mCartridgeProperties.getPDFFile().trim().length() > 2) {
            StarterJPanel.invokeSystemFile(new File(Global.mainPathPrefix + StarterJPanel.convertSeperator(this.mCartridgeProperties.getPDFFile().trim())));
        }
    }

    private void jTextField2ActionPerformed(ActionEvent evt) {
    }

    private void jCheckBox16ActionPerformed(ActionEvent evt) {
    }

    private void jCheckBox26ActionPerformed(ActionEvent evt) {
    }

    private void jCheckBoxXmas1ActionPerformed(ActionEvent evt) {
    }

    private void jCheckBox24ActionPerformed(ActionEvent evt) {
    }

    private void jCheckBoxPB6IRQActionPerformed(ActionEvent evt) {
    }

    public static boolean invokeSystemFile(File file) {
        Desktop desktop = null;
        try {
            if (Desktop.isDesktopSupported()) {
                desktop = Desktop.getDesktop();
                desktop.open(file);
            }
        }
        catch (IOException e) {
            Configuration.getConfiguration().getDebugEntity().addLog(e, LogPanel.WARN);
            return false;
        }
        return true;
    }

    public void loadAllCartridged() {
        this.allCartridges.clear();
        CartridgePropertiesPool mCartridgePropertiesPool = new CartridgePropertiesPool();
        Collection<CartridgeProperties> colC = mCartridgePropertiesPool.getMapForKlasse("Cartridge").values();
        for (CartridgeProperties item : colC) {
            this.allCartridges.add(item);
        }
    }

    public void save() {
        CartridgePropertiesPool mCartridgePropertiesPool = new CartridgePropertiesPool();
        Collection<CartridgeProperties> colC = mCartridgePropertiesPool.getMapForKlasse("Cartridge").values();
        mCartridgePropertiesPool.put(this.mCartridgeProperties);
        mCartridgePropertiesPool.save();
    }

    @Override
    public void selectionChanged(SelectionEvent e) {
        int[] rows = this.cSATablePanel1.getSelectedRows();
        if (rows.length > 0) {
            this.selectCard(rows[0]);
        }
    }

    void selectCard(int no) {
        FileReader fr;
        this.mCartridgeProperties = this.allCartridges.get(no);
        this.jTextField2.setText(this.mCartridgeProperties.getCartName());
        this.jTextField1.setText(this.mCartridgeProperties.getAuthor());
        this.jTextField3.setText(this.mCartridgeProperties.getYear());
        this.jTextField4.setText("" + this.mCartridgeProperties.getCRC());
        this.jTextFieldPath.setText(this.mCartridgeProperties.getHomepage());
        this.jTextPane4.setText(this.mCartridgeProperties.getCheats());
        this.jTextPane5.setText(this.mCartridgeProperties.getEastereggs());
        this.jTextPane1.setText(this.mCartridgeProperties.getLicence());
        this.jTextFieldPath3.setText(this.mCartridgeProperties.getCopyrightType());
        this.jCheckBox11.setSelected(this.mCartridgeProperties.getCompleteGame());
        this.jCheckBox12.setSelected(this.mCartridgeProperties.getDemo());
        this.jCheckBox13.setSelected(this.mCartridgeProperties.getSnippet());
        this.jCheckBox14.setSelected(this.mCartridgeProperties.getHomebrew());
        int flag = this.mCartridgeProperties.getTypeFlags();
        this.jCheckBox1.setSelected((flag & Cartridge.FLAG_VEC_VOICE) != 0);
        this.jCheckBox2.setSelected((flag & Cartridge.FLAG_DS2430A) != 0);
        this.jCheckBox16.setSelected((flag & Cartridge.FLAG_MICROCHIP) != 0);
        this.jCheckBox9.setSelected((flag & Cartridge.FLAG_RAM_ANIMACTION) != 0);
        this.jCheckBox10.setSelected((flag & Cartridge.FLAG_RAM_RA_SPECTRUM) != 0);
        this.jCheckBox3.setSelected((flag & Cartridge.FLAG_LIGHTPEN1) != 0);
        this.jCheckBox4.setSelected((flag & Cartridge.FLAG_LIGHTPEN2) != 0);
        this.jCheckBox5.setSelected((flag & Cartridge.FLAG_IMAGER) != 0);
        this.jCheckBox6.setSelected((flag & Cartridge.FLAG_EXTREME_MULTI) != 0);
        this.jCheckBox7.setSelected((flag & Cartridge.FLAG_BANKSWITCH_DONDZILA) != 0);
        this.jCheckBox8.setSelected((flag & Cartridge.FLAG_BANKSWITCH_VECFLASH) != 0);
        this.jCheckBox15.setSelected((flag & Cartridge.FLAG_VEC_VOX) != 0);
        this.jCheckBox17.setSelected((flag & Cartridge.FLAG_DUALVEC1) != 0);
        this.jCheckBox18.setSelected((flag & Cartridge.FLAG_DUALVEC2) != 0);
        this.jCheckBox19.setSelected((flag & Cartridge.FLAG_LOGO) != 0);
        this.jCheckBox20.setSelected((flag & Cartridge.FLAG_XMAS) != 0);
        this.jCheckBox21.setSelected((flag & Cartridge.FLAG_DS2431) != 0);
        this.jCheckBox22.setSelected((flag & Cartridge.FLAG_32K_ONLY) != 0);
        this.jCheckBox23.setSelected((flag & Cartridge.FLAG_SID) != 0);
        this.jCheckBox48KROM.setSelected((flag & Cartridge.FLAG_48K) != 0);
        this.jCheckBoxPB6IRQ.setSelected((flag & Cartridge.FLAG_BS_PB6_IRQ) != 0);
        this.jCheckBox26.setSelected((flag & Cartridge.FLAG_ATMEL_EEPROM) != 0);
        this.jCheckBox25.setSelected((flag & Cartridge.FLAG_PIC_EEPROM) != 0);
        this.jCheckBoxXmas1.setSelected((flag & Cartridge.FLAG_V4E_16K_BS) != 0);
        this.jCheckBox24.setSelected((flag & Cartridge.FLAG_KEYBOARD) != 0);
        this.singleImagePanel3.unsetImage();
        if (this.mCartridgeProperties.getOverlay() != null && this.mCartridgeProperties.getOverlay().trim().length() > 2) {
            this.singleImagePanel3.setImage(Global.mainPathPrefix + StarterJPanel.convertSeperator(this.mCartridgeProperties.getOverlay().trim()), true);
        }
        this.singleImagePanel1.unsetImage();
        if (this.mCartridgeProperties.getFrontImage() != null && this.mCartridgeProperties.getFrontImage().trim().length() > 2) {
            this.singleImagePanel1.setImage(Global.mainPathPrefix + StarterJPanel.convertSeperator(this.mCartridgeProperties.getFrontImage()), true);
        }
        this.singleImagePanel2.unsetImage();
        if (this.mCartridgeProperties.getBackImage() != null && this.mCartridgeProperties.getBackImage().trim().length() > 2) {
            this.singleImagePanel2.setImage(Global.mainPathPrefix + StarterJPanel.convertSeperator(this.mCartridgeProperties.getBackImage().trim()), true);
        }
        this.singleImagePanel5.unsetImage();
        if (this.mCartridgeProperties.getCartridgeImage() != null && this.mCartridgeProperties.getCartridgeImage().trim().length() > 2) {
            this.singleImagePanel5.setImage(Global.mainPathPrefix + StarterJPanel.convertSeperator(this.mCartridgeProperties.getCartridgeImage().trim()), true);
        }
        this.singleImagePanel4.unsetImage();
        if (this.mCartridgeProperties.getInGameImage() != null && this.mCartridgeProperties.getInGameImage().trim().length() > 2) {
            this.singleImagePanel4.setImage(Global.mainPathPrefix + StarterJPanel.convertSeperator(this.mCartridgeProperties.getInGameImage().trim()), true);
        }
        this.jTextPane2.setText("");
        if (this.mCartridgeProperties.getInstructionFile() != null && this.mCartridgeProperties.getInstructionFile().trim().length() > 2) {
            try {
                fr = new FileReader(Global.mainPathPrefix + StarterJPanel.convertSeperator(this.mCartridgeProperties.getInstructionFile().trim()));
                this.jTextPane2.read(fr, null);
                fr.close();
            }
            catch (IOException e) {
                this.log.addLog(e, LogPanel.WARN);
            }
        }
        this.jTextPane3.setText("");
        if (this.mCartridgeProperties.getCritic() != null && this.mCartridgeProperties.getCritic().trim().length() > 2) {
            try {
                fr = new FileReader(Global.mainPathPrefix + StarterJPanel.convertSeperator(this.mCartridgeProperties.getCritic().trim()));
                this.jTextPane3.read(fr, null);
                fr.close();
            }
            catch (IOException e) {
                this.log.addLog(e, LogPanel.WARN);
            }
        }
        this.jButtonFileSelect12.setEnabled(this.mCartridgeProperties.getPDFFile().trim().length() != 0);
    }

    void startCartridge(int no) {
        CSAMainFrame p = (CSAMainFrame)this.mParent;
        VecXPanel vecxy = p.getVecxy();
        if (vecxy == null) {
            return;
        }
        CartridgeProperties sel = this.allCartridges.get(no);
        this.loadAllCartridged();
        for (CartridgeProperties rel : this.allCartridges) {
            if (!rel.getCartName().equals(sel.getCartName())) continue;
            sel = rel;
            break;
        }
        vecxy.startCartridge(sel, 2);
    }

    public static String convertSeperator(String filename) {
        String ret = UtilityString.replace(filename, "/", File.separator);
        ret = UtilityString.replace(ret, "\\", File.separator);
        return ret;
    }

    @Override
    public void deIconified() {
    }

    class CartridgeTableModel
    extends AbstractTableModel {
        private CartridgeTableModel() {
        }

        @Override
        public int getRowCount() {
            return StarterJPanel.this.allCartridges.size();
        }

        @Override
        public int getColumnCount() {
            if (!StarterJPanel.this.myImageShown) {
                return headers.length - 4;
            }
            return headers.length;
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (col == 0) {
                return StarterJPanel.this.allCartridges.get(row).getCartName();
            }
            if (col == 1) {
                return StarterJPanel.this.allCartridges.get(row).getAuthor();
            }
            if (col == 2) {
                return StarterJPanel.this.allCartridges.get(row).getYear();
            }
            if (col == 3) {
                return StarterJPanel.this.allCartridges.get(row).getHomebrew();
            }
            if (col == 4) {
                return StarterJPanel.this.allCartridges.get(row).getDemo();
            }
            if (col == 5) {
                return StarterJPanel.this.allCartridges.get(row).getSnippet();
            }
            if (col == 6) {
                return StarterJPanel.this.allCartridges.get(row).getCompleteGame();
            }
            if (col == 7) {
                return StarterJPanel.this.allCartridges.get(row).getSmallCartridgeImage();
            }
            if (col == 8) {
                return StarterJPanel.this.allCartridges.get(row).getSmallFrontImage();
            }
            if (col == 9) {
                return StarterJPanel.this.allCartridges.get(row).getSmallBackImage();
            }
            if (col == 10) {
                return StarterJPanel.this.allCartridges.get(row).getSmallInGameImage();
            }
            return "-";
        }

        @Override
        public String getColumnName(int col) {
            return headers[col];
        }

        @Override
        public Class<?> getColumnClass(int col) {
            if (col == 3) {
                return Boolean.class;
            }
            if (col == 4) {
                return Boolean.class;
            }
            if (col == 5) {
                return Boolean.class;
            }
            if (col == 6) {
                return Boolean.class;
            }
            if (col == 7) {
                return BufferedImage.class;
            }
            if (col == 8) {
                return BufferedImage.class;
            }
            if (col == 9) {
                return BufferedImage.class;
            }
            if (col == 10) {
                return BufferedImage.class;
            }
            return String.class;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }

        @Override
        public void setValueAt(Object aValue, int row, int col) {
        }
    }
}

