/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.vecx.panels;

import de.malban.config.Configuration;
import de.malban.gui.CSAMainFrame;
import de.malban.gui.Stateable;
import de.malban.gui.Windowable;
import de.malban.gui.components.CSAView;
import de.malban.util.UtilityString;
import de.malban.vide.VideConfig;
import de.malban.vide.dissy.DASM6809;
import de.malban.vide.dissy.DissiPanel;
import de.malban.vide.dissy.Memory;
import de.malban.vide.dissy.MemoryInformation;
import de.malban.vide.dissy.Watch;
import de.malban.vide.vecx.Breakpoint;
import de.malban.vide.vecx.Updatable;
import de.malban.vide.vecx.VecXPanel;
import de.malban.vide.vecx.panels.AddVariablePanel;
import de.malban.vide.vecx.panels.GetValuePanel;
import de.muntjak.tinylookandfeel.Theme;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;

public class VarJPanel
extends JPanel
implements Windowable,
Stateable,
Updatable {
    VideConfig config = VideConfig.getConfig();
    private CSAView mParent = null;
    private JMenuItem mParentMenuItem = null;
    private int mClassSetting = 0;
    private DissiPanel dissi = null;
    private VecXPanel vecxPanel = null;
    public static String SID = "Debug: Variables";
    ArrayList<MemoryInformation> variables = new ArrayList();
    Memory memory = null;
    boolean onlyUserRam = false;
    int popUpAddress = -1;
    String popUpName = "";
    private boolean updateEnabled = false;
    private JButton jButtonAddVariable;
    private JCheckBox jCheckBox1;
    private JCheckBox jCheckBoxHideBIOSNames;
    private JCheckBox jCheckBoxShowAllRAM;
    private JLabel jLabel1;
    private JMenu jMenu3;
    private JMenuItem jMenuItem1;
    private JMenuItem jMenuItemBreakpointRead;
    private JMenuItem jMenuItemBreakpointValue;
    private JMenuItem jMenuItemBreakpointWrite;
    private JMenuItem jMenuItemWatchBinary;
    private JMenuItem jMenuItemWatchByte;
    private JMenuItem jMenuItemWatchBytePair;
    private JMenuItem jMenuItemWatchSequence;
    private JMenuItem jMenuItemWatchString;
    private JMenuItem jMenuItemWatchWord;
    private JPopupMenu jPopupMenu1;
    private JScrollPane jScrollPane1;
    private JPopupMenu.Separator jSeparator1;
    private JPopupMenu.Separator jSeparator2;
    private JTable jTable1;
    private JToggleButton jToggleButton4;
    private PropertyChangeListener pListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            VarJPanel.this.updateMyUI();
        }
    };

    @Override
    public boolean isLoadSettings() {
        return true;
    }

    @Override
    public String getID() {
        return SID;
    }

    @Override
    public String getFileID() {
        return UtilityString.replace(UtilityString.replace(UtilityString.replace(UtilityString.replaceWhiteSpaces(SID, ""), ":", ""), "(", ""), ")", "");
    }

    @Override
    public Serializable getAdditionalStateinfo() {
        return null;
    }

    @Override
    public void setAdditionalStateinfo(Serializable ser) {
    }

    public void setVecxy(VecXPanel v) {
        this.vecxPanel = v;
        this.initVariables();
    }

    public void setDissi(DissiPanel v) {
        this.dissi = v;
        if (this.dissi == null) {
            return;
        }
        this.memory = this.dissi.getMemory();
        this.initVariables();
    }

    void initVariables() {
        if (this.vecxPanel == null) {
            return;
        }
        if (this.memory == null) {
            return;
        }
        this.onlyUserRam = this.jCheckBox1.isSelected();
        this.variables = new ArrayList();
        int start = 0;
        int end2 = 65536;
        if (this.onlyUserRam) {
            start = 51328;
            end2 = 52223;
        }
        for (int m = start; m < end2; ++m) {
            MemoryInformation memInfo = this.memory.getBankMemory(this.dissi.getCurrentBank()).get(m);
            this.jLabel1.setText("Ram Layout from bank: " + this.dissi.getCurrentBank());
            if (memInfo.memType != 0) continue;
            if (this.jCheckBoxShowAllRAM.isSelected()) {
                this.variables.add(memInfo);
                continue;
            }
            if (memInfo.labels.size() <= 0) continue;
            this.variables.add(memInfo);
        }
        this.correctTable();
    }

    @Override
    public boolean isIcon() {
        CSAMainFrame frame = Configuration.getConfiguration().getMainFrame();
        if (frame.getInternalFrame(this) == null) {
            return false;
        }
        return frame.getInternalFrame(this).isIcon();
    }

    @Override
    public void setIcon(boolean b) {
        CSAMainFrame frame = Configuration.getConfiguration().getMainFrame();
        if (frame.getInternalFrame(this) == null) {
            return;
        }
        try {
            frame.getInternalFrame(this).setIcon(b);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void closing() {
        if (this.vecxPanel != null) {
            this.vecxPanel.resetVari();
        }
        this.deinit();
    }

    @Override
    public void setParentWindow(CSAView jpv) {
        this.mParent = jpv;
    }

    @Override
    public void setMenuItem(JMenuItem item) {
        this.mParentMenuItem = item;
        this.mParentMenuItem.setText(SID);
    }

    @Override
    public JMenuItem getMenuItem() {
        return this.mParentMenuItem;
    }

    @Override
    public JPanel getPanel() {
        return this;
    }

    public void deinit() {
        this.removeUIListerner();
    }

    public VarJPanel() {
        this.initComponents();
        this.onlyUserRam = this.jCheckBox1.isSelected();
        VariablesTableModel model = new VariablesTableModel();
        this.jTable1.setModel(model);
        TableRowSorter<TableModel> sorter = new TableRowSorter<TableModel>(this.jTable1.getModel());
        this.jTable1.setRowSorter(sorter);
        ArrayList<RowSorter.SortKey> sortKeys = new ArrayList<RowSorter.SortKey>(2);
        sortKeys.add(new RowSorter.SortKey(1, SortOrder.ASCENDING));
        sortKeys.add(new RowSorter.SortKey(0, SortOrder.ASCENDING));
        sorter.setSortKeys(sortKeys);
        this.jTable1.setDefaultRenderer(Object.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
                super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
                if (table.getModel() instanceof VariablesTableModel) {
                    MemoryInformation memInfo;
                    VariablesTableModel model = (VariablesTableModel)table.getModel();
                    int address = DASM6809.toNumber(model.getValueAt(row, 0).toString());
                    boolean backgroundDone = false;
                    if (VarJPanel.this.memory != null && (memInfo = VarJPanel.this.memory.getBankMemory(0).get(address)).hasBreakpoint()) {
                        boolean enabled = false;
                        ArrayList<Breakpoint> bp = memInfo.getBreakpoints();
                        for (Breakpoint b : bp) {
                            if (!b.enabled) continue;
                            enabled = true;
                        }
                        if (enabled) {
                            this.setBackground(VarJPanel.this.config.valueChanged);
                            backgroundDone = true;
                        }
                    }
                    if (VarJPanel.this.vecxPanel != null) {
                        int currentStack = VarJPanel.this.vecxPanel.getSReg();
                        int lowestStack = ((VarJPanel)VarJPanel.this).vecxPanel.get6809().lowestStackValue;
                        int allTimeLow = VarJPanel.this.vecxPanel.getAllTimeLowStack();
                        if (address == allTimeLow) {
                            this.setBackground(Color.RED);
                            backgroundDone = true;
                        } else if (address == lowestStack) {
                            this.setBackground(Color.PINK);
                            backgroundDone = true;
                        } else if (address == currentStack) {
                            this.setBackground(Color.BLUE);
                            backgroundDone = true;
                        } else if (!backgroundDone) {
                            this.setBackground(table.getBackground());
                        }
                    }
                    if (isSelected) {
                        if (!backgroundDone) {
                            this.setBackground(table.getSelectionBackground());
                        }
                        this.setForeground(table.getSelectionForeground());
                    } else {
                        Color back = model.getBackground(col);
                        if (back != null) {
                            if (!backgroundDone) {
                                this.setBackground(back);
                            } else if (!backgroundDone) {
                                this.setBackground(table.getBackground());
                            }
                        }
                        this.setForeground(table.getForeground());
                    }
                }
                return this;
            }
        });
        UIManager.addPropertyChangeListener(this.pListener);
        this.updateMyUI();
        this.correctTable();
    }

    private void update() {
        this.jTable1.repaint();
    }

    public void correctTable() {
        this.jTable1.tableChanged(null);
        VariablesTableModel model = (VariablesTableModel)this.jTable1.getModel();
        for (int i = 0; i < model.getColumnCount(); ++i) {
            this.jTable1.getColumnModel().getColumn(i).setPreferredWidth(model.getColWidth(i));
        }
    }

    private void initComponents() {
        this.jPopupMenu1 = new JPopupMenu();
        this.jMenuItemBreakpointRead = new JMenuItem();
        this.jMenuItemBreakpointWrite = new JMenuItem();
        this.jMenuItemBreakpointValue = new JMenuItem();
        this.jSeparator1 = new JPopupMenu.Separator();
        this.jMenuItem1 = new JMenuItem();
        this.jSeparator2 = new JPopupMenu.Separator();
        this.jMenu3 = new JMenu();
        this.jMenuItemWatchBinary = new JMenuItem();
        this.jMenuItemWatchByte = new JMenuItem();
        this.jMenuItemWatchWord = new JMenuItem();
        this.jMenuItemWatchString = new JMenuItem();
        this.jMenuItemWatchBytePair = new JMenuItem();
        this.jMenuItemWatchSequence = new JMenuItem();
        this.jToggleButton4 = new JToggleButton();
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = this.buildTable();
        this.jCheckBox1 = new JCheckBox();
        this.jButtonAddVariable = new JButton();
        this.jCheckBoxShowAllRAM = new JCheckBox();
        this.jCheckBoxHideBIOSNames = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.jMenuItemBreakpointRead.setText("toggle Breakpoint read");
        this.jMenuItemBreakpointRead.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VarJPanel.this.jMenuItemBreakpointReadActionPerformed(evt);
            }
        });
        this.jPopupMenu1.add(this.jMenuItemBreakpointRead);
        this.jMenuItemBreakpointWrite.setText("toggle breakpoint write");
        this.jMenuItemBreakpointWrite.setActionCommand("toggle breakpoint write");
        this.jMenuItemBreakpointWrite.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VarJPanel.this.jMenuItemBreakpointWriteActionPerformed(evt);
            }
        });
        this.jPopupMenu1.add(this.jMenuItemBreakpointWrite);
        this.jMenuItemBreakpointValue.setText("toggle breakpoint value");
        this.jMenuItemBreakpointValue.setActionCommand("toggle breakpoint value");
        this.jMenuItemBreakpointValue.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VarJPanel.this.jMenuItemBreakpointValueActionPerformed(evt);
            }
        });
        this.jPopupMenu1.add(this.jMenuItemBreakpointValue);
        this.jPopupMenu1.add(this.jSeparator1);
        this.jMenuItem1.setText("use label as data");
        this.jMenuItem1.setToolTipText("marking the label as data enables dissi to load that address to a X,Y,U,S,D register as immediate value, also removed previous labels");
        this.jMenuItem1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VarJPanel.this.jMenuItem1ActionPerformed(evt);
            }
        });
        this.jPopupMenu1.add(this.jMenuItem1);
        this.jPopupMenu1.add(this.jSeparator2);
        this.jMenu3.setText("Watches");
        this.jMenuItemWatchBinary.setText("add watch binary");
        this.jMenuItemWatchBinary.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VarJPanel.this.jMenuItemWatchBinaryActionPerformed(evt);
            }
        });
        this.jMenu3.add(this.jMenuItemWatchBinary);
        this.jMenuItemWatchByte.setText("add watch byte");
        this.jMenuItemWatchByte.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VarJPanel.this.jMenuItemWatchByteActionPerformed(evt);
            }
        });
        this.jMenu3.add(this.jMenuItemWatchByte);
        this.jMenuItemWatchWord.setText("add watch word");
        this.jMenuItemWatchWord.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VarJPanel.this.jMenuItemWatchWordActionPerformed(evt);
            }
        });
        this.jMenu3.add(this.jMenuItemWatchWord);
        this.jMenuItemWatchString.setText("add watch string");
        this.jMenuItemWatchString.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VarJPanel.this.jMenuItemWatchStringActionPerformed(evt);
            }
        });
        this.jMenu3.add(this.jMenuItemWatchString);
        this.jMenuItemWatchBytePair.setText("add watch byte pair");
        this.jMenuItemWatchBytePair.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VarJPanel.this.jMenuItemWatchBytePairActionPerformed(evt);
            }
        });
        this.jMenu3.add(this.jMenuItemWatchBytePair);
        this.jMenuItemWatchSequence.setText("add watch sequence 5");
        this.jMenuItemWatchSequence.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VarJPanel.this.jMenuItemWatchSequenceActionPerformed(evt);
            }
        });
        this.jMenu3.add(this.jMenuItemWatchSequence);
        this.jPopupMenu1.add(this.jMenu3);
        this.jToggleButton4.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/webcam.png")));
        this.jToggleButton4.setToolTipText("Toggle Update (always or only while debug)");
        this.jToggleButton4.setMargin(new Insets(0, 1, 0, -1));
        this.jToggleButton4.setSelectedIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/webcamSelect.png")));
        this.jToggleButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VarJPanel.this.jToggleButton4ActionPerformed(evt);
            }
        });
        this.jTable1.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jTable1.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                VarJPanel.this.jTable1MousePressed(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTable1);
        this.jCheckBox1.setText("only user RAM (from $c880)");
        this.jCheckBox1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VarJPanel.this.jCheckBox1ActionPerformed(evt);
            }
        });
        this.jButtonAddVariable.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/add.png")));
        this.jButtonAddVariable.setToolTipText("add new \"named\" variable (location)");
        this.jButtonAddVariable.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonAddVariable.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VarJPanel.this.jButtonAddVariableActionPerformed(evt);
            }
        });
        this.jCheckBoxShowAllRAM.setSelected(true);
        this.jCheckBoxShowAllRAM.setText("show all RAM");
        this.jCheckBoxShowAllRAM.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VarJPanel.this.jCheckBoxShowAllRAMActionPerformed(evt);
            }
        });
        this.jCheckBoxHideBIOSNames.setSelected(true);
        this.jCheckBoxHideBIOSNames.setText("hide BIOS names");
        this.jCheckBoxHideBIOSNames.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VarJPanel.this.jCheckBoxHideBIOSNamesActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Ram Layout from bank: 1");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jToggleButton4, -2, 20, -2).addGap(18, 18, 18).addComponent(this.jCheckBox1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckBoxShowAllRAM).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxHideBIOSNames).addGap(18, 18, 18).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButtonAddVariable)).addComponent(this.jScrollPane1));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jToggleButton4, -2, 21, -2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBox1, -2, 21, -2).addComponent(this.jCheckBoxShowAllRAM).addComponent(this.jCheckBoxHideBIOSNames).addComponent(this.jLabel1)).addComponent(this.jButtonAddVariable, -2, 21, -2)).addGap(4, 4, 4).addComponent(this.jScrollPane1, -1, 308, Short.MAX_VALUE)));
    }

    private void jCheckBox1ActionPerformed(ActionEvent evt) {
        this.initVariables();
    }

    private void jToggleButton4ActionPerformed(ActionEvent evt) {
        this.updateEnabled = this.jToggleButton4.isSelected();
    }

    private void jTable1MousePressed(MouseEvent evt) {
        int row;
        Point p;
        JTable table;
        if (evt.getButton() == 3) {
            table = (JTable)evt.getSource();
            p = evt.getPoint();
            row = table.rowAtPoint(p);
            Object o = table.getModel().getValueAt(row, 0);
            if (o == null) {
                return;
            }
            this.popUpAddress = DASM6809.toNumber(o.toString());
            this.popUpName = (String)table.getModel().getValueAt(row, 1);
            this.jPopupMenu1.show(this.jTable1, evt.getX() - 20, evt.getY() - 20);
        }
        if (evt.getClickCount() == 2 && evt != null && (evt.getModifiers() & 1) == 1) {
            table = (JTable)evt.getSource();
            p = evt.getPoint();
            row = table.rowAtPoint(p);
            int col = table.columnAtPoint(p);
            if (col == 3) {
                Object o = table.getModel().getValueAt(row, col);
                if (o == null) {
                    return;
                }
                int address = DASM6809.toNumber(o.toString());
                this.vecxPanel.setDumpToAddress(address);
            }
        }
    }

    private void jMenuItemBreakpointReadActionPerformed(ActionEvent evt) {
        if (this.dissi == null) {
            return;
        }
        int b = 0;
        while (b < this.dissi.getMemory().getMaxBank()) {
            MemoryInformation memInfo;
            Breakpoint bp = new Breakpoint();
            bp.memInfo = memInfo = this.memory.getBankMemory(b).get(this.popUpAddress);
            bp.targetAddress = this.popUpAddress;
            bp.targetBank = b++;
            bp.targetType = Breakpoint.BP_TARGET_MEMORY;
            bp.name = this.popUpName;
            bp.targetSubType = 0;
            bp.compareValue = 0;
            bp.type = Breakpoint.BP_READ | Breakpoint.BP_MULTI;
            this.vecxPanel.breakpointVarToggle(bp);
        }
        this.popUpAddress = -1;
        this.popUpName = "";
    }

    private void jMenuItemBreakpointWriteActionPerformed(ActionEvent evt) {
        if (this.dissi == null) {
            return;
        }
        int b = 0;
        while (b < this.dissi.getMemory().getMaxBank()) {
            MemoryInformation memInfo;
            Breakpoint bp = new Breakpoint();
            bp.memInfo = memInfo = this.memory.getBankMemory(b).get(this.popUpAddress);
            bp.targetAddress = this.popUpAddress;
            bp.targetBank = b++;
            bp.targetType = Breakpoint.BP_TARGET_MEMORY;
            bp.targetSubType = 0;
            bp.name = this.popUpName;
            bp.compareValue = 0;
            bp.type = Breakpoint.BP_WRITE | Breakpoint.BP_MULTI;
            this.vecxPanel.breakpointVarToggle(bp);
        }
        this.popUpAddress = -1;
        this.popUpName = "";
    }

    private void jMenuItemBreakpointValueActionPerformed(ActionEvent evt) {
        int value = GetValuePanel.showEnterValueDialog() & 0xFF;
        if (this.dissi == null) {
            return;
        }
        int b = 0;
        while (b < this.dissi.getMemory().getMaxBank()) {
            MemoryInformation memInfo;
            Breakpoint bp = new Breakpoint();
            bp.memInfo = memInfo = this.memory.getBankMemory(b).get(this.popUpAddress);
            bp.targetAddress = this.popUpAddress;
            bp.targetBank = b++;
            bp.targetType = Breakpoint.BP_TARGET_MEMORY;
            bp.targetSubType = 0;
            bp.compareValue = value;
            bp.name = this.popUpName;
            bp.type = Breakpoint.BP_WRITE | Breakpoint.BP_MULTI | Breakpoint.BP_COMPARE;
            this.vecxPanel.breakpointVarToggle(bp);
        }
        this.popUpAddress = -1;
        this.popUpName = "";
    }

    private void jButtonAddVariableActionPerformed(ActionEvent evt) {
        int adress = AddVariablePanel.showEnterValueDialog() & 0xFFFF;
        for (int bank2 = 0; bank2 < this.dissi.getMemory().getMaxBank(); ++bank2) {
            MemoryInformation info = this.dissi.getMemoryInformation(adress, bank2);
            if (info == null) {
                info = this.dissi.getMemory().buildMemInfo(adress, bank2);
            }
            info.labels.add(("_" + String.format("%04X", adress)).toUpperCase());
        }
        this.initVariables();
        this.dissi.completeUpdate();
    }

    private void jMenuItem1ActionPerformed(ActionEvent evt) {
        for (int bank2 = 0; bank2 < this.dissi.getMemory().getMaxBank(); ++bank2) {
            MemoryInformation info = this.dissi.getMemoryInformation(this.popUpAddress, bank2);
            info.immediateLabels.clear();
            for (String l : info.labels) {
                info.immediateLabels.add(l);
            }
        }
        this.initVariables();
        this.dissi.completeUpdate();
    }

    private void jCheckBoxHideBIOSNamesActionPerformed(ActionEvent evt) {
        this.initVariables();
    }

    private void jCheckBoxShowAllRAMActionPerformed(ActionEvent evt) {
        this.initVariables();
    }

    int getPopupWatchAddress() {
        return this.popUpAddress;
    }

    private void jMenuItemWatchBinaryActionPerformed(ActionEvent evt) {
        int adr = this.getPopupWatchAddress();
        if (adr == -1) {
            return;
        }
        int type = 0;
        int len = 0;
        Watch.addWatch(adr, type, len, this.dissi);
        this.dissi.correctTableWatch();
    }

    private void jMenuItemWatchByteActionPerformed(ActionEvent evt) {
        int adr = this.getPopupWatchAddress();
        if (adr == -1) {
            return;
        }
        int type = 1;
        int len = 0;
        Watch.addWatch(adr, type, len, this.dissi);
        this.dissi.correctTableWatch();
    }

    private void jMenuItemWatchWordActionPerformed(ActionEvent evt) {
        int adr = this.getPopupWatchAddress();
        if (adr == -1) {
            return;
        }
        int type = 2;
        int len = 0;
        Watch.addWatch(adr, type, len, this.dissi);
        this.dissi.correctTableWatch();
    }

    private void jMenuItemWatchStringActionPerformed(ActionEvent evt) {
        int adr = this.getPopupWatchAddress();
        if (adr == -1) {
            return;
        }
        int type = 3;
        int len = 0;
        Watch.addWatch(adr, type, len, this.dissi);
        this.dissi.correctTableWatch();
    }

    private void jMenuItemWatchBytePairActionPerformed(ActionEvent evt) {
        int adr = this.getPopupWatchAddress();
        if (adr == -1) {
            return;
        }
        int type = 4;
        int len = 0;
        Watch.addWatch(adr, type, len, this.dissi);
        this.dissi.correctTableWatch();
    }

    private void jMenuItemWatchSequenceActionPerformed(ActionEvent evt) {
        int adr = this.getPopupWatchAddress();
        if (adr == -1) {
            return;
        }
        int type = 5;
        int len = 5;
        Watch.addWatch(adr, type, len, this.dissi);
        this.dissi.correctTableWatch();
    }

    @Override
    public void updateValues(boolean forceUpdate) {
        if (!forceUpdate && !this.updateEnabled) {
            return;
        }
        this.update();
    }

    @Override
    public void setUpdateEnabled(boolean b) {
        this.updateEnabled = b;
    }

    JTable buildTable() {
        JTable table = new JTable(){

            @Override
            public String getToolTipText(MouseEvent e) {
                if (VarJPanel.this.vecxPanel == null) {
                    return null;
                }
                String tip = "<html>";
                if (VarJPanel.this.jTable1.getModel() instanceof VariablesTableModel) {
                    VariablesTableModel model = (VariablesTableModel)VarJPanel.this.jTable1.getModel();
                    Point p = e.getPoint();
                    int rowIndex = this.rowAtPoint(p);
                    int colIndex = this.columnAtPoint(p);
                    rowIndex = VarJPanel.this.jTable1.convertRowIndexToModel(this.rowAtPoint(p));
                    try {
                        MemoryInformation memInfo = VarJPanel.this.variables.get(rowIndex);
                        int val1 = VarJPanel.this.vecxPanel.getVecXMem8(memInfo.address) & 0xFF;
                        int val2 = (VarJPanel.this.vecxPanel.getVecXMem8(memInfo.address) & 0xFF) * 256 + (VarJPanel.this.vecxPanel.getVecXMem8(memInfo.address + 1) & 0xFF);
                        if (colIndex == 1) {
                            tip = tip + "<pre>";
                            for (String st : memInfo.labels) {
                                tip = tip + st + "\n";
                            }
                            tip = tip + "</pre>";
                        }
                        if (colIndex == 2) {
                            tip = tip + "decimal: " + val1 + "(unsigned)<BR>";
                            tip = tip + "decimal: " + (val1 > 128 ? val1 - 256 : val1) + "(signed)<BR>";
                            if (val1 >= 32 && val1 < 127) {
                                tip = tip + "ascii: '" + (char)val1 + "'<BR>";
                            }
                        }
                        if (colIndex == 3) {
                            tip = tip + "decimal: " + val2 + "(unsigned)<BR>";
                            tip = tip + "decimal: " + (val2 > 32768 ? val2 - 65536 : val2) + "(signed)<BR>";
                            int vhi = val2 / 256;
                            int vlo = val2 & 0xFF;
                            if (vhi >= 32 && vhi < 127) {
                                tip = tip + "ascii(1): '" + (char)vhi + "'<BR>";
                            }
                            if (vlo >= 32 && vlo < 127) {
                                tip = tip + "ascii(2): '" + (char)vlo + "'<BR>";
                            }
                        }
                        if (colIndex == 4) {
                            tip = tip + "<pre>";
                            for (String st : memInfo.comments) {
                                tip = tip + st + "\n";
                            }
                            tip = tip + "</pre>";
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                }
                tip = tip + "</html>";
                return tip;
            }
        };
        return table;
    }

    public void removeUIListerner() {
        UIManager.removePropertyChangeListener(this.pListener);
    }

    void updateMyUI() {
        SwingUtilities.updateComponentTreeUI(this.jPopupMenu1);
        int fontSize = Theme.textFieldFont.getFont().getSize();
        int rowHeight = fontSize + 3;
        this.jTable1.setRowHeight(rowHeight);
    }

    public void setSelectedAddress(int address) {
        int row = -1;
        int c = 0;
        for (MemoryInformation memInfo : this.variables) {
            if (memInfo.address == address) {
                row = c;
                break;
            }
            ++c;
        }
        if (row == -1) {
            this.jCheckBoxShowAllRAM.setSelected(true);
            this.initVariables();
            row = 51200 - address;
            if (row < 0) {
                return;
            }
            if (row > 1024) {
                return;
            }
            if (row > this.variables.size()) {
                return;
            }
        }
        this.jTable1.setRowSelectionInterval(row, row);
        DissiPanel.scrollToVisibleMid(this.jTable1, row, 0);
    }

    @Override
    public void deIconified() {
    }

    public class VariablesTableModel
    extends AbstractTableModel {
        @Override
        public int getRowCount() {
            if (VarJPanel.this.jCheckBoxShowAllRAM.isSelected()) {
                return 1024;
            }
            return VarJPanel.this.variables.size();
        }

        @Override
        public int getColumnCount() {
            return 5;
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (VarJPanel.this.vecxPanel == null) {
                return "";
            }
            if (row >= VarJPanel.this.variables.size()) {
                return "";
            }
            MemoryInformation memInfo = VarJPanel.this.variables.get(row);
            if (col == 0) {
                return "$" + String.format("%04X", memInfo.address);
            }
            if (col == 1) {
                String l = "";
                for (int i = 0; i < memInfo.labels.size(); ++i) {
                    if (VarJPanel.this.jCheckBoxHideBIOSNames.isSelected()) {
                        if (DASM6809.isBIOSLabelPublic(memInfo.labels.get(i), memInfo.address)) continue;
                        if (l.length() > 0) {
                            l = l + ", ";
                        }
                        l = l + memInfo.labels.get(i);
                        continue;
                    }
                    if (l.length() > 0) {
                        l = l + ", ";
                    }
                    l = l + memInfo.labels.get(i);
                }
                return l;
            }
            if (col == 2) {
                return "$" + String.format("%02X", VarJPanel.this.vecxPanel.getVecXMem8(memInfo.address) & 0xFF);
            }
            if (col == 3) {
                return "$" + String.format("%04X", (VarJPanel.this.vecxPanel.getVecXMem8(memInfo.address) & 0xFF) * 256 + (VarJPanel.this.vecxPanel.getVecXMem8(memInfo.address + 1) & 0xFF));
            }
            if (col == 4) {
                String l = "";
                for (int i = 0; i < memInfo.comments.size(); ++i) {
                    if (i > 0) {
                        l = l + ", ";
                    }
                    l = l + memInfo.comments.get(i);
                }
                return l;
            }
            return "";
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return "address";
            }
            if (column == 1) {
                return "variables";
            }
            if (column == 2) {
                return "8 bit";
            }
            if (column == 3) {
                return "16 bit";
            }
            if (column == 4) {
                return "comment";
            }
            return "-";
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return String.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 1 || columnIndex == 4 || columnIndex == 2 || columnIndex == 3;
        }

        public int getColWidth(int col) {
            if (col == 0) {
                return 20;
            }
            if (col == 1) {
                return 200;
            }
            if (col == 2) {
                return 10;
            }
            if (col == 3) {
                return 20;
            }
            if (col == 4) {
                return 80;
            }
            return 20;
        }

        public Color getBackground(int col) {
            if (col == 0) {
                return VarJPanel.this.config.tableAddress;
            }
            return null;
        }

        @Override
        public void setValueAt(Object aValue, int row, int col) {
            MemoryInformation memInfoOrg;
            int iv;
            String v;
            MemoryInformation memInfo;
            if (col == 2) {
                memInfo = VarJPanel.this.variables.get(row);
                if (aValue == null) {
                    return;
                }
                v = aValue.toString();
                iv = DASM6809.toNumber(v) & 0xFF;
                if (VarJPanel.this.dissi != null) {
                    VarJPanel.this.dissi.doThePoke(memInfo.address, (byte)iv, true);
                }
            }
            if (col == 3) {
                memInfo = VarJPanel.this.variables.get(row);
                if (aValue == null) {
                    return;
                }
                v = aValue.toString();
                iv = DASM6809.toNumber(v) & 0xFFFF;
                if (VarJPanel.this.dissi != null) {
                    int msb = iv / 256 & 0xFF;
                    int lsb = iv & 0xFF;
                    VarJPanel.this.dissi.doThePoke(memInfo.address, (byte)msb, true);
                    VarJPanel.this.dissi.doThePoke(memInfo.address + 1, (byte)lsb, true);
                }
            }
            if (col == 1) {
                memInfoOrg = VarJPanel.this.variables.get(row);
                int address = memInfoOrg.address;
                boolean changeRelevant = false;
                for (int bank2 = 0; bank2 < VarJPanel.this.dissi.getMemory().getMaxBank(); ++bank2) {
                    int adr;
                    int dp;
                    HashMap<Integer, String> dmap;
                    String[] labels;
                    MemoryInformation memInfo2 = VarJPanel.this.dissi.getMemoryInformation(address, bank2);
                    ArrayList oldLabels = (ArrayList)memInfo2.labels.clone();
                    memInfo2.labels.clear();
                    String label = aValue.toString();
                    for (String l : labels = label.split(":")) {
                        if (l.trim().length() <= 0) continue;
                        memInfo2.labels.add(l);
                    }
                    if (VarJPanel.this.dissi == null) {
                        return;
                    }
                    Memory orgData = VarJPanel.this.dissi.getMemory();
                    boolean changeRelevantThis = true;
                    if (orgData != null) {
                        changeRelevantThis = orgData.labelsChanged(memInfo2, oldLabels);
                    }
                    if ((dmap = orgData.directLabels.get(dp = (adr = memInfo2.address) / 256)) != null && dmap.get(adr & 0xFF) != null && labels.length > 0) {
                        dmap.put(adr & 0xFF, labels[0]);
                    }
                    changeRelevant = changeRelevant || changeRelevantThis;
                }
                if (changeRelevant) {
                    VarJPanel.this.dissi.varUpdate();
                }
                this.fireTableCellUpdated(row, col);
            }
            if (col == 4) {
                memInfoOrg = VarJPanel.this.variables.get(row);
                int address = memInfoOrg.address;
                for (int bank3 = 0; bank3 < VarJPanel.this.dissi.getMemory().getMaxBank(); ++bank3) {
                    String[] comments;
                    MemoryInformation memInfo3 = VarJPanel.this.dissi.getMemoryInformation(address, bank3);
                    memInfo3.comments.clear();
                    String comment = aValue.toString();
                    for (String c : comments = comment.split(":")) {
                        memInfo3.comments.add(c);
                    }
                }
                this.fireTableCellUpdated(row, col);
            }
        }
    }
}

