/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.vecx.panels;

import de.malban.Global;
import de.malban.config.Configuration;
import de.malban.gui.CSAMainFrame;
import de.malban.gui.components.ModalInternalFrame;
import de.malban.gui.panels.LogPanel;
import de.malban.util.UtilityFiles;
import de.malban.util.UtilityString;
import de.malban.vide.vecx.devices.ImagerWheel;
import de.malban.vide.vecx.devices.WheelData;
import de.malban.vide.vecx.panels.OneWheelColorPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class WheelEdit
extends JPanel {
    transient LogPanel log = (LogPanel)Configuration.getConfiguration().getDebugEntity();
    private int mClassSetting = 0;
    boolean newFile = true;
    WheelData currentWheel = WheelData.createNewWheel();
    private ImagerWheel imagerWheel1;
    private JButton jButton1;
    private JButton jButtonColor1;
    private JButton jButtonNew1;
    private JButton jButtonSave;
    private JComboBox jComboBoxWheelList;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel51;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JSlider jSlider3;
    private JTextField jTextField1;
    private JTextField jTextField2;
    private JTextField jTextField3;
    private JTextField jTextField46;
    ModalInternalFrame modelDialog;

    public WheelEdit() {
        this.initComponents();
        this.initWheelList();
        this.loadSelectedWheel();
    }

    private void initComponents() {
        this.jTextField46 = new JTextField();
        this.jLabel51 = new JLabel();
        this.jSlider3 = new JSlider();
        this.imagerWheel1 = new ImagerWheel();
        this.jScrollPane1 = new JScrollPane();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jTextField1 = new JTextField();
        this.jTextField2 = new JTextField();
        this.jLabel2 = new JLabel();
        this.jTextField3 = new JTextField();
        this.jLabel3 = new JLabel();
        this.jComboBoxWheelList = new JComboBox();
        this.jLabel4 = new JLabel();
        this.jButtonSave = new JButton();
        this.jButtonNew1 = new JButton();
        this.jButtonColor1 = new JButton();
        this.jButton1 = new JButton();
        this.jLabel51.setText("sync hole");
        this.jSlider3.setMajorTickSpacing(10);
        this.jSlider3.setMaximum(360);
        this.jSlider3.setMinorTickSpacing(1);
        this.jSlider3.setOrientation(1);
        this.jSlider3.setPaintTicks(true);
        this.jSlider3.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                WheelEdit.this.jSlider3StateChanged(evt);
            }
        });
        GroupLayout imagerWheel1Layout = new GroupLayout(this.imagerWheel1);
        this.imagerWheel1.setLayout(imagerWheel1Layout);
        imagerWheel1Layout.setHorizontalGroup(imagerWheel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        imagerWheel1Layout.setVerticalGroup(imagerWheel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        this.jPanel1.setBorder(BorderFactory.createEtchedBorder());
        this.jPanel1.setPreferredSize(new Dimension(350, 250));
        this.jPanel1.setLayout(new FlowLayout(0));
        this.jScrollPane1.setViewportView(this.jPanel1);
        this.jLabel1.setText("Name");
        this.jLabel2.setText("Id");
        this.jLabel3.setText("default Frequency");
        this.jComboBoxWheelList.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WheelEdit.this.jComboBoxWheelListActionPerformed(evt);
            }
        });
        this.jLabel4.setText("Name");
        this.jButtonSave.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/page_save.png")));
        this.jButtonSave.setToolTipText("Save File (with shift - > save as)");
        this.jButtonSave.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WheelEdit.this.jButtonSaveActionPerformed(evt);
            }
        });
        this.jButtonNew1.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/new.png")));
        this.jButtonNew1.setToolTipText("new Project");
        this.jButtonNew1.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonNew1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WheelEdit.this.jButtonNew1ActionPerformed(evt);
            }
        });
        this.jButtonColor1.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/add.png")));
        this.jButtonColor1.setToolTipText("add color");
        this.jButtonColor1.setMargin(new Insets(0, 0, 0, -1));
        this.jButtonColor1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WheelEdit.this.jButtonColor1ActionPerformed(evt);
            }
        });
        this.jButton1.setText("close");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.jLabel51)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(40, 40, 40).addComponent(this.jButtonColor1, -2, 21, -2)).addGroup(layout.createSequentialGroup().addGap(12, 12, 12).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextField46, -2, 64, -2).addComponent(this.jButton1).addComponent(this.jLabel3).addComponent(this.jLabel2).addComponent(this.jLabel1).addComponent(this.jSlider3, -2, -1, -2))).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel4))).addGap(5, 5, 5).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jComboBoxWheelList, -2, 216, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonSave).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonNew1).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.jScrollPane1, -1, 367, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jTextField3, GroupLayout.Alignment.LEADING, -1, 144, Short.MAX_VALUE).addComponent(this.jTextField2, GroupLayout.Alignment.LEADING).addComponent(this.jTextField1, GroupLayout.Alignment.LEADING)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.imagerWheel1, -1, -1, Short.MAX_VALUE)))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(2, 2, 2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel4, -2, 21, -2).addGap(7, 7, 7).addComponent(this.jLabel51).addGap(4, 4, 4).addComponent(this.jTextField46, -2, 21, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSlider3, -2, -1, -2).addGap(34, 34, 34).addComponent(this.jButtonColor1, -2, 21, -2)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jComboBoxWheelList, -2, 21, -2).addComponent(this.jButtonSave).addComponent(this.jButtonNew1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jTextField1, -2, 21, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextField2, -2, 21, -2).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextField3, -2, 21, -2).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 143, Short.MAX_VALUE).addComponent(this.jButton1, -2, 21, -2).addContainerGap()).addComponent(this.imagerWheel1, -1, -1, Short.MAX_VALUE))));
    }

    private void jSlider3StateChanged(ChangeEvent evt) {
        if (this.currentWheel == null) {
            return;
        }
        if (this.mClassSetting == 0) {
            this.currentWheel.indexAngle = this.jSlider3.getValue();
        }
        this.jTextField46.setText("" + this.jSlider3.getValue());
        this.imagerWheel1.repaintWheel();
    }

    private void jButtonSaveActionPerformed(ActionEvent evt) {
        this.getFields();
        this.saveCurrentWheel();
    }

    private void jComboBoxWheelListActionPerformed(ActionEvent evt) {
        if (this.mClassSetting > 0) {
            return;
        }
        this.loadSelectedWheel();
    }

    private void jButtonNew1ActionPerformed(ActionEvent evt) {
        this.currentWheel = WheelData.createNewWheel();
        this.currentWheel.id = 3;
        this.currentWheel.name = this.currentWheel.name + "_clone";
        this.setAllFields();
        this.newFile = true;
    }

    private void jButtonColor1ActionPerformed(ActionEvent evt) {
        if (this.currentWheel == null) {
            return;
        }
        this.currentWheel.addSection(Color.YELLOW);
        OneWheelColorPanel owc = new OneWheelColorPanel(this.currentWheel, this.currentWheel.colors.length - 1, this);
        owc.setBounds(0, 0, 59, 246);
        this.jPanel1.add(owc);
        this.invalidate();
        this.validate();
        this.repaint();
    }

    void initWheelList() {
        ++this.mClassSetting;
        String path = Global.mainPathPrefix + "xml" + File.separator + "wheels";
        ArrayList<String> files = UtilityFiles.getXMLFileList(path);
        this.jComboBoxWheelList.removeAllItems();
        for (String name : files) {
            this.jComboBoxWheelList.addItem(UtilityString.replace(name.toLowerCase(), ".xml", ""));
        }
        --this.mClassSetting;
    }

    void setAllFields() {
        ++this.mClassSetting;
        this.imagerWheel1.setWheel(this.currentWheel);
        this.jSlider3.setValue((int)this.currentWheel.indexAngle);
        this.jTextField46.setText("" + (int)this.currentWheel.indexAngle);
        this.jTextField1.setText(this.currentWheel.name);
        this.jTextField2.setText("" + this.currentWheel.id);
        this.jTextField3.setText("" + String.format("%.4f", this.currentWheel.defaultFrequency));
        this.redoSections();
        --this.mClassSetting;
    }

    void loadSelectedWheel() {
        int i = this.jComboBoxWheelList.getSelectedIndex();
        if (i < 0) {
            this.log.addLog("No entry selected - can't load.", LogPanel.WARN);
            return;
        }
        String fname = this.jComboBoxWheelList.getSelectedItem().toString() + ".xml";
        String path = Global.mainPathPrefix + "xml" + File.separator + "wheels" + File.separator + fname;
        WheelData loadedWheel = WheelData.loadWheel(path);
        if (loadedWheel == null) {
            this.log.addLog("Wheel not loaded.", LogPanel.WARN);
            return;
        }
        this.currentWheel = loadedWheel;
        this.setAllFields();
        this.newFile = false;
        this.log.addLog("Wheel " + this.currentWheel.name + " loaded.", LogPanel.INFO);
    }

    void saveCurrentWheel() {
        if (this.currentWheel == null) {
            this.log.addLog("No wheel - can't save.", LogPanel.WARN);
            return;
        }
        if (this.currentWheel.name.trim().length() == 0) {
            this.log.addLog("No wheel name - can't save.", LogPanel.WARN);
            return;
        }
        String fname = this.currentWheel.name.trim().toLowerCase() + ".xml";
        String path = Global.mainPathPrefix + "xml" + File.separator + "wheels" + File.separator + fname;
        boolean ok = this.currentWheel.saveAsXML(path);
        if (!ok) {
            this.log.addLog("Wheel not saved.", LogPanel.WARN);
            return;
        }
        this.correctComboAfterSave();
        this.newFile = false;
        this.log.addLog("Wheel " + this.currentWheel.name + " saved.", LogPanel.INFO);
    }

    void correctComboAfterSave() {
        if (!this.newFile) {
            return;
        }
        String currentName = UtilityString.replace(this.currentWheel.name.toLowerCase(), ".xml", "");
        ++this.mClassSetting;
        this.initWheelList();
        int index = -1;
        for (int i = 0; i < this.jComboBoxWheelList.getItemCount(); ++i) {
            if (!currentName.equals(this.jComboBoxWheelList.getItemAt(i).toString())) continue;
            index = i;
            break;
        }
        if (index > 0) {
            this.jComboBoxWheelList.setSelectedIndex(index);
        }
        --this.mClassSetting;
    }

    public static void showWheelEdit() {
        ModalInternalFrame modal;
        CSAMainFrame frame = Configuration.getConfiguration().getMainFrame();
        WheelEdit panel = new WheelEdit();
        ArrayList<JButton> eb = new ArrayList<JButton>();
        eb.add(panel.jButton1);
        panel.modelDialog = modal = new ModalInternalFrame("Wheel editor", frame.getRootPane(), frame, panel, null, null, eb);
        modal.setVisible(true);
        String result = modal.getNamedExit();
    }

    void redoSections() {
        this.jPanel1.removeAll();
        for (int i = 1; i < this.currentWheel.startAngle.length; ++i) {
            OneWheelColorPanel owc = new OneWheelColorPanel(this.currentWheel, i, this);
            owc.setBounds(0, 0, 59, 246);
            this.jPanel1.add(owc);
        }
        this.imagerWheel1.repaintWheel();
        this.invalidate();
        this.validate();
        this.repaint();
    }

    void updateSections() {
        for (Component comp : this.jPanel1.getComponents()) {
            if (!(comp instanceof OneWheelColorPanel)) continue;
            OneWheelColorPanel owc = (OneWheelColorPanel)comp;
            owc.update();
        }
        this.imagerWheel1.repaintWheel();
        this.invalidate();
        this.validate();
        this.repaint();
    }

    void colorChanged(int colorNo) {
        this.updateSections();
    }

    void removeSection(int colorNo) {
        this.currentWheel.removeSection(colorNo);
        this.redoSections();
    }

    void getFields() {
        this.currentWheel.name = this.jTextField1.getText();
        this.currentWheel.id = UtilityString.IntX(this.jTextField2.getText(), 3);
        this.currentWheel.indexAngle = this.jSlider3.getValue();
        this.currentWheel.defaultFrequency = UtilityString.DoubleX(this.jTextField3.getText(), 26.1579);
        this.currentWheel.indexAngle = this.jSlider3.getValue();
    }
}

