/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.vecx.spline;

import de.malban.vide.VideConfig;
import de.malban.vide.vecx.spline.Pt;
import de.malban.vide.vecx.spline.Vec;
import java.util.ArrayList;
import java.util.List;

public final class CardinalSpline {
    static VideConfig config = VideConfig.getConfig();
    private List<Pt> points;
    private List<Pt> interp;
    double tightness;

    public CardinalSpline() {
        this.setPoints(new ArrayList<Pt>());
        this.interp = new ArrayList<Pt>();
        this.setTightness(1.0);
    }

    public ArrayList<Pt> getPoints() {
        return (ArrayList)this.interp;
    }

    public void setPoints(List<Pt> data2) {
        this.points = data2;
    }

    public void addPoint(Pt pt) {
        this.points.add(pt);
    }

    String pl(List<Pt> pts) {
        StringBuilder ret = new StringBuilder();
        double xold = 0.0;
        for (Pt p : pts) {
            ret.append(p.x).append(",").append(p.y).append("->");
            xold = p.x;
        }
        return ret.toString();
    }

    public void caculate() {
        CardinalSpline.calculateSlopesCardinal(this.points, this.tightness);
        CardinalSpline.interpolateCardinal(this.interp, this.points);
    }

    public static double h1(double t) {
        return 2.0 * Math.pow(t, 3.0) - 3.0 * Math.pow(t, 2.0) + 1.0;
    }

    public static double h2(double t) {
        return Math.pow(t, 3.0) - 2.0 * Math.pow(t, 2.0) + t;
    }

    public static double h3(double t) {
        return -2.0 * Math.pow(t, 3.0) + 3.0 * Math.pow(t, 2.0);
    }

    public static double h4(double t) {
        return Math.pow(t, 3.0) - Math.pow(t, 2.0);
    }

    public static void calculateSlopesCardinal(List<Pt> points, double tightness) {
        for (int i = 1; i < points.size() - 1; ++i) {
            Vec d = new Vec(points.get(i - 1), points.get(i + 1));
            Vec slope = d.getVectorOfMagnitude(tightness * (d.mag() / 2.0));
            points.get(i).setVec("slope", slope);
        }
        if (points.size() > 2) {
            Pt first = points.get(0);
            Pt last = points.get(points.size() - 1);
            Vec d = new Vec(first, points.get(1));
            first.setVec("slope", d.getVectorOfMagnitude(tightness * (d.mag() / 2.0)));
            d = new Vec(points.get(points.size() - 2), last);
            last.setVec("slope", d.getVectorOfMagnitude(tightness * (d.mag() / 2.0)));
        }
    }

    public static void interpolateCardinal(List<Pt> interpolatedPoints, List<Pt> controlPoints) {
        interpolatedPoints.clear();
        for (int i = 0; i < controlPoints.size() - 1; ++i) {
            interpolatedPoints.addAll(CardinalSpline.interpolateCardinalPatch(controlPoints.get(i), controlPoints.get(i + 1)));
        }
    }

    public static List<Pt> interpolateCardinalPatch(Pt a, Pt b) {
        ArrayList<Pt> ret = new ArrayList<Pt>();
        Vec m0 = a.getVec("slope");
        Vec m1 = b.getVec("slope");
        double c = Math.sqrt((a.x - b.x) * (a.x - b.x) + (a.y - b.y) * (a.y - b.y));
        int distance = (int)c / (CardinalSpline.config.splineDensity * 100);
        if (distance < 3) {
            distance = 3;
        }
        if (m0 != null && m1 != null) {
            for (int i = 0; i < distance; ++i) {
                double t = (double)i / (double)distance;
                double x = a.x * CardinalSpline.h1(t) + m0.getX() * CardinalSpline.h2(t) + b.x * CardinalSpline.h3(t) + m1.getX() * CardinalSpline.h4(t);
                double y = a.y * CardinalSpline.h1(t) + m0.getY() * CardinalSpline.h2(t) + b.y * CardinalSpline.h3(t) + m1.getY() * CardinalSpline.h4(t);
                if (Double.isNaN(x) || Double.isNaN(y)) continue;
                ret.add(new Pt(x, y));
            }
        }
        return ret;
    }

    public void setTightness(double tightness) {
        if (tightness < 0.0 || tightness > 1.0) {
            // empty if block
        }
        this.tightness = tightness;
        CardinalSpline.calculateSlopesCardinal(this.points, tightness);
        CardinalSpline.interpolateCardinal(this.interp, this.points);
    }

    public static void bug(String what) {
        System.out.println("CatmullRom: " + what);
    }
}

