/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.vecx.spline;

import de.malban.vide.vecx.spline.Vec;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Pt
extends Point2D.Double
implements Comparable<Pt> {
    public static double EQ_TOL = 1.0E-5;
    public static int ID_COUNTER = 0;
    protected long time;
    protected Map<String, Object> attribs;
    protected final int id = ID_COUNTER++;

    public Pt() {
        this.attribs = new HashMap<String, Object>();
    }

    public Pt(int x, int y) {
        this((double)x, (double)y);
    }

    public Pt(double x, double y) {
        this(x, y, 0L);
    }

    public Pt(Vec direction) {
        this(direction.getX(), direction.getY());
    }

    public Pt(MouseEvent ev) {
        this(ev.getPoint().getX(), ev.getPoint().getY(), ev.getWhen());
    }

    public Pt(double x, double y, long time) {
        super(x, y);
        this.time = time;
    }

    public Pt(Point2D source, long time) {
        this(source.getX(), source.getY(), time);
    }

    public int getID() {
        return this.id;
    }

    public Map<String, Object> getAttribs() {
        if (this.attribs == null) {
            this.attribs = new HashMap<String, Object>();
        }
        return this.attribs;
    }

    public void scale(double amt) {
        this.setLocation(this.getX() * amt, this.getY() * amt);
    }

    public Pt getScaled(double amt) {
        return new Pt(this.getX() * amt, this.getY() * amt);
    }

    @Override
    public int compareTo(Pt other) {
        if (this.getTime() < other.getTime()) {
            return -1;
        }
        if (this.getTime() > other.getTime()) {
            return 1;
        }
        return 0;
    }

    public boolean isSameLocation(Pt other) {
        return Math.abs(this.getX() - other.getX()) < EQ_TOL && Math.abs(this.getY() - other.getY()) < EQ_TOL;
    }

    public static Comparator<Pt> sortByX() {
        return new Comparator(){

            public int compare(Object aa, Object bb) {
                int ret = 0;
                Pt a = (Pt)aa;
                Pt b = (Pt)bb;
                ret = a.getX() < b.getX() ? -1 : (a.getX() > b.getX() ? 1 : (a.getY() > b.getY() ? 1 : -1));
                return ret;
            }

            @Override
            public boolean equals(Object obj) {
                return false;
            }
        };
    }

    public int ix() {
        return (int)this.getX();
    }

    public int iy() {
        return (int)this.getY();
    }

    public static boolean eq(Pt a, Pt b, double tolerance) {
        double xOk = Math.abs(a.getX() - b.getX());
        double yOk = Math.abs(a.getY() - b.getY());
        return xOk < tolerance && yOk < tolerance;
    }

    public boolean equals(Pt other) {
        boolean basic;
        if (other.compareTo(this) == 0) {
            // empty if block
        }
        boolean advanced = (basic = Pt.eq(this, other, EQ_TOL)) ? this.getAttribs().equals(other.getAttribs()) : false;
        return basic && advanced;
    }

    public Pt copy() {
        Pt twin = new Pt(this.getX(), this.getY(), this.getTime());
        twin.attribs = this.attribs == null ? null : (HashMap)((HashMap)this.attribs).clone();
        return twin;
    }

    public final void setTime(long time) {
        this.time = time;
    }

    public long getTime() {
        return this.time;
    }

    public void setAttribute(String name, Object value) {
        this.getAttribs().put(name, value);
    }

    public void setBoolean(String name, boolean value) {
        this.getAttribs().put(name, value);
    }

    public boolean getBoolean(String name) {
        return this.getAttribs().containsKey(name) && (Boolean)this.getAttribute(name) != false;
    }

    public void setDouble(String name, double value) {
        this.getAttribs().put(name, value);
    }

    public void setString(String name, String value) {
        this.getAttribs().put(name, value);
    }

    public boolean hasAttribute(String name) {
        return this.getAttribs().containsKey(name);
    }

    public Object getAttribute(String name) {
        return this.getAttribs().get(name);
    }

    public void removeAttribute(String name) {
        this.getAttribs().remove(name);
    }

    public Vec getVec(String name) {
        return (Vec)this.getAttribute(name);
    }

    public void setVec(String name, Vec value) {
        this.setAttribute(name, value);
    }

    public double getDouble(String name) {
        Object shouldBeDouble = this.getAttribute(name);
        return (Double)shouldBeDouble;
    }

    public String getString(String name) {
        return (String)this.getAttribute(name);
    }

    public void setMap(String name, Map<?, ?> value) {
        this.getAttribs().put(name, value);
    }

    public Map<?, ?> getMap(String name) {
        return (Map)this.getAttribute(name);
    }

    public void setList(String name, List<?> value) {
        this.getAttribs().put(name, value);
    }

    public List<?> getList(String name) {
        return (List)this.getAttribute(name);
    }
}

