/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.vedi;

import de.malban.vide.vedi.CloseEvent;
import de.malban.vide.vedi.CloseListener;
import de.muntjak.tinylookandfeel.Theme;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;

public class CloseButton
extends JPanel {
    public static final int CB_NORMAL = 0;
    public static final int CB_ARMED = 1;
    public static final int CB_PRESSED = 2;
    public int state = 0;
    private ArrayList<CloseListener> mListener = new ArrayList();
    private PropertyChangeListener pListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            CloseButton.this.uiUpdate();
        }
    };
    private JLabel jLabel1;

    public CloseButton() {
        this.initComponents();
        this.setStateDisplay();
        UIManager.addPropertyChangeListener(this.pListener);
        this.uiUpdate();
    }

    public void uiUpdate() {
        final int fs = Theme.labelFont.getFont().getSize();
        final Dimension newSize = new Dimension(fs + 2, fs + 2);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int xWidth = newSize.width - 11 + 6;
                int xHeight = newSize.height - 11 + 14;
                Rectangle bound = CloseButton.this.getBounds();
                CloseButton.this.setBounds(CloseButton.this.getBounds().x, CloseButton.this.getBounds().y, newSize.width, newSize.height);
                CloseButton.this.setSize(newSize.width, newSize.height);
                CloseButton.this.setPreferredSize(newSize);
                CloseButton.this.setMinimumSize(newSize);
                CloseButton.this.setMaximumSize(newSize);
                int startX = fs / 2 - xWidth / 2;
                int startY = fs / 2 - xHeight / 2;
                int var = 1;
                if (fs == 18) {
                    var = 1;
                }
                if (fs == 17) {
                    var = 1;
                }
                if (fs == 16) {
                    var = 1;
                }
                if (fs == 15) {
                    var = 2;
                }
                if (fs == 14) {
                    var = 2;
                }
                if (fs == 13) {
                    var = 2;
                }
                if (fs == 12) {
                    var = 3;
                }
                if (fs == 11) {
                    var = 3;
                }
                if (fs == 10) {
                    var = 3;
                }
                Rectangle boundl = CloseButton.this.jLabel1.getBounds();
                CloseButton.this.jLabel1.setBounds(startX + 3, startY + var, fs, fs);
                CloseButton.this.setNormal();
                CloseButton.this.invalidate();
                CloseButton.this.validate();
                CloseButton.this.repaint();
            }
        });
    }

    public void removeUIListerner() {
        UIManager.removePropertyChangeListener(this.pListener);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.setMaximumSize(new Dimension(10, 10));
        this.setPreferredSize(new Dimension(10, 10));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent evt) {
                CloseButton.this.formMouseExited(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                CloseButton.this.formMouseEntered(evt);
            }
        });
        this.setLayout(null);
        this.jLabel1.setText("x");
        this.jLabel1.setMaximumSize(new Dimension(6, 10));
        this.jLabel1.setMinimumSize(new Dimension(6, 10));
        this.jLabel1.setPreferredSize(new Dimension(6, 10));
        this.jLabel1.setSize(new Dimension(6, 10));
        this.jLabel1.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                CloseButton.this.jLabel1MousePressed(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                CloseButton.this.jLabel1MouseReleased(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                CloseButton.this.jLabel1MouseExited(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                CloseButton.this.jLabel1MouseEntered(evt);
            }
        });
        this.add(this.jLabel1);
        this.jLabel1.setBounds(2, -3, 6, 10);
    }

    private void jLabel1MouseEntered(MouseEvent evt) {
        this.setArmed(true);
    }

    private void jLabel1MouseExited(MouseEvent evt) {
        this.setNormal();
    }

    private void jLabel1MousePressed(MouseEvent evt) {
        this.setPressed(true);
    }

    private void jLabel1MouseReleased(MouseEvent evt) {
        if ((this.state & 1) == 1) {
            this.fireClosePressed();
        }
        this.setNormal();
    }

    private void formMouseEntered(MouseEvent evt) {
        this.setArmed(true);
    }

    private void formMouseExited(MouseEvent evt) {
        this.setNormal();
    }

    public void setArmed(boolean b) {
        this.state = b ? (this.state |= 1) : (this.state &= 0xFFFFFFFE);
        this.setStateDisplay();
    }

    public void setPressed(boolean b) {
        this.state = b ? (this.state |= 2) : (this.state &= 0xFFFFFFFD);
        this.setStateDisplay();
    }

    public void setNormal() {
        this.state = 0;
        this.setStateDisplay();
    }

    void setStateDisplay() {
        UIDefaults table = UIManager.getLookAndFeelDefaults();
        Color foreground = (Color)table.get("Label.foreground");
        Color background = (Color)table.get("Label.background");
        if ((this.state & 1) == 1) {
            this.setBorder(BorderFactory.createLineBorder(foreground));
        } else {
            this.setBorder(BorderFactory.createLineBorder(background));
        }
        if ((this.state & 2) == 2) {
            this.setBackground(foreground);
            this.jLabel1.setForeground(background);
        } else {
            this.jLabel1.setForeground(foreground);
            this.setBackground(background);
        }
        this.repaint();
    }

    private void fireClosePressed() {
        boolean close = true;
        CloseEvent e = new CloseEvent();
        e.source = this;
        ArrayList clone = (ArrayList)this.mListener.clone();
        for (CloseListener l : clone) {
            close = l.closeRequested(e);
            if (close) continue;
            return;
        }
    }

    public void addCloseListerner(CloseListener listener) {
        this.mListener.remove(listener);
        this.mListener.add(listener);
    }

    public void removeCloseListerner(CloseListener listener) {
        this.mListener.remove(listener);
    }

    public void clearCloseListerner() {
        this.mListener.clear();
    }

    public void renameTo(String newFilename) {
        ArrayList clone = (ArrayList)this.mListener.clone();
        for (CloseListener l : clone) {
            l.renameTo(newFilename);
        }
    }
}

