/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.vedi;

import de.malban.vide.vedi.DebugComment;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;

public class DebugCommentList
implements Serializable {
    ArrayList<DebugComment> comments = new ArrayList();
    public String filename = "";

    public ArrayList<DebugComment> getList() {
        return this.comments;
    }

    public boolean removeComment(DebugComment c) {
        return this.comments.remove(c);
    }

    private DebugComment addComment(int l, int t, int st, String s, int p, String vn) {
        DebugComment c = new DebugComment();
        c.type = t;
        c.subType = st;
        c.beforLineNo = l;
        c.generatedComment = s;
        c.additionalParameter = p;
        c.file = this.filename;
        c.varname = vn;
        this.comments.add(c);
        Collections.sort(this.comments);
        return c;
    }

    public DebugComment addBreakComment(int line) {
        return this.addComment(line, 1, 0, "; hey dissi \"break\"", 0, "");
    }

    public DebugComment addBreakOnceComment(int line) {
        return this.addComment(line, 1, 1, "; hey dissi \"break once\"", 0, "");
    }

    public DebugComment addWatchComment(String varName, int subType, int param) {
        DebugComment dbcold = null;
        do {
            if ((dbcold = this.getWatch(varName)) == null) continue;
            this.removeComment(dbcold);
        } while (dbcold != null);
        return this.addComment(0, 2, subType, "; hey dissi \"watch $" + varName + " " + subType + " " + param + "\"", param, varName);
    }

    public DebugComment getBreakpoint(int line) {
        for (DebugComment dbc : this.comments) {
            if (dbc.beforLineNo != line || dbc.type != 1) continue;
            return dbc;
        }
        return null;
    }

    public DebugComment getWatch(String word) {
        for (DebugComment dbc : this.comments) {
            if (!dbc.varname.equals(word) || dbc.type != 2) continue;
            return dbc;
        }
        return null;
    }
}

