/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.vedi;

import de.malban.Global;
import de.malban.config.Configuration;
import de.malban.config.TinyLogInterface;
import de.malban.gui.HotKey;
import de.malban.gui.ListPopupJPanel;
import de.malban.gui.dialogs.InternalFrameFileChoser;
import de.malban.gui.panels.LogPanel;
import de.malban.util.Utility;
import de.malban.util.UtilityFiles;
import de.malban.util.UtilityString;
import de.malban.util.syntax.Syntax.HighlightedDocument;
import de.malban.util.syntax.Syntax.TokenStyles;
import de.malban.util.syntax.entities.EntityDefinition;
import de.malban.vide.VideConfig;
import de.malban.vide.veccy.VectorListFileChoserJPanel;
import de.malban.vide.vedi.Bookmark;
import de.malban.vide.vedi.DebugComment;
import de.malban.vide.vedi.DebugCommentList;
import de.malban.vide.vedi.EditorPanelFoundation;
import de.malban.vide.vedi.PiTrexTerminal;
import de.malban.vide.vedi.VEdiFoundationPanel;
import de.malban.vide.vedi.VediPanel;
import de.malban.vide.vedi.panels.GetJumpValuePanel;
import de.malban.vide.vedi.panels.GetRadiusValuePanel;
import de.malban.vide.vedi.panels.GetSinValuePanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.zip.CRC32;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.TextUI;
import javax.swing.table.AbstractTableModel;
import javax.swing.text.AttributeSet;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyleConstants;

public class EditorPanel
extends EditorPanelFoundation {
    VideConfig config = VideConfig.getConfig();
    LogPanel log = (LogPanel)Configuration.getConfiguration().getDebugEntity();
    int rowCount = -1;
    boolean isBasic = false;
    boolean hasChanged1 = false;
    boolean hasChanged2 = false;
    boolean assume6809Asm = false;
    boolean assume6809C = false;
    boolean addToSettings = true;
    TinyLogInterface tinyLog = null;
    private String filename = "";
    boolean initError = false;
    VEdiFoundationPanel parent;
    private HighlightedDocument editorPaneDocument;
    int vediId = -1;
    JPanel noWrapPanel = new JPanel(new BorderLayout());
    private static HashMap<String, EditorPanel> openEditorMap = new HashMap();
    int savedCaretPosition = 0;
    boolean inSetup = false;
    int[] brackCount;
    int popUpTextPos = 0;
    private JMenu jMenu1;
    private JMenu jMenu3;
    private JMenuItem jMenuItem1;
    private JMenuItem jMenuItem2;
    private JMenuItem jMenuItem3;
    private JMenuItem jMenuItem4;
    private JMenuItem jMenuItem5;
    private JMenuItem jMenuItemAddAnim;
    private JMenuItem jMenuItemAddVectorlist;
    private JMenuItem jMenuItemWatchBinary;
    private JMenuItem jMenuItemWatchByte;
    private JMenuItem jMenuItemWatchBytePair;
    private JMenuItem jMenuItemWatchSequence;
    private JMenuItem jMenuItemWatchString;
    private JMenuItem jMenuItemWatchWord;
    private JPopupMenu jPopupMenu1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JTextPane jTextPane1;
    private JTextPane jTextPane2;
    int selStart = 0;
    int selEnd = 0;
    Dimension oldDim = null;
    boolean _0d0a = false;
    AbstractAction tabAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                int last;
                String TAB_STRING = EditorPanel.this.getTABString();
                int start = EditorPanel.this.jTextPane1.getSelectionStart();
                int end2 = EditorPanel.this.jTextPane1.getSelectionEnd();
                if (start != end2) {
                    --end2;
                }
                if (end2 - start == 0) {
                    EditorPanel.this.jTextPane1.getDocument().insertString(EditorPanel.this.jTextPane1.getCaretPosition(), TAB_STRING, null);
                    return;
                }
                EditorPanel.this.stopColoring();
                int first = EditorPanel.this.getLineOfPos(EditorPanel.this.jTextPane1, start);
                for (int i = last = EditorPanel.this.getLineOfPos(EditorPanel.this.jTextPane1, end2); i >= first; --i) {
                    int pos = EditorPanel.this.getPosOfLineStart(i);
                    EditorPanel.this.jTextPane1.getDocument().insertString(pos, TAB_STRING, null);
                    end2 += TAB_STRING.length();
                }
                EditorPanel.this.startColoring();
                EditorPanel.this.jTextPane1.setSelectionStart(start);
                EditorPanel.this.jTextPane1.setSelectionEnd(end2);
            }
            catch (Throwable ex) {
                ex.printStackTrace();
                EditorPanel.this.startColoring();
            }
        }
    };
    AbstractAction shiftTabAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                boolean startEQEnd;
                String TAB_STRING = EditorPanel.this.getTABString();
                int start = EditorPanel.this.jTextPane1.getSelectionStart();
                int end2 = EditorPanel.this.jTextPane1.getSelectionEnd();
                boolean bl = startEQEnd = start == end2;
                if (start != end2) {
                    --end2;
                }
                EditorPanel.this.stopColoring();
                int first = EditorPanel.this.getLineOfPos(EditorPanel.this.jTextPane1, start);
                int last = EditorPanel.this.getLineOfPos(EditorPanel.this.jTextPane1, end2);
                int myLine = EditorPanel.this.getLineOfPos(EditorPanel.this.jTextPane1, EditorPanel.this.jTextPane1.getCaretPosition());
                int myPos = EditorPanel.this.jTextPane1.getCaretPosition();
                boolean myPosIsStart = myPos == start;
                for (int i = last; i >= first; --i) {
                    int pos = EditorPanel.this.getPosOfLineStart(i);
                    for (int c = 0; EditorPanel.this.jTextPane1.getDocument().getText(pos, 1).equals(" ") && c < TAB_STRING.length(); ++c) {
                        EditorPanel.this.jTextPane1.getDocument().remove(pos, 1);
                        --end2;
                    }
                }
                EditorPanel.this.startColoring();
                if (startEQEnd) {
                    EditorPanel.this.jTextPane1.setSelectionStart(end2);
                } else {
                    EditorPanel.this.jTextPane1.setSelectionStart(start);
                }
                EditorPanel.this.jTextPane1.setSelectionEnd(end2);
            }
            catch (Throwable ex) {
                ex.printStackTrace();
                EditorPanel.this.startColoring();
            }
        }
    };
    int oldlnWidth = -1;
    Point vpSave = new Point(0, 0);
    CRC32 loadCRC32 = new CRC32();

    void setAddToSettings(boolean b) {
        this.addToSettings = b;
    }

    boolean isAddToSettings() {
        return this.addToSettings;
    }

    public void setParent(VEdiFoundationPanel p) {
        this.parent = p;
    }

    public void resetDocument() {
        this.editorPaneDocument = new HighlightedDocument(this.vediId, this.getFilename());
        this.resetCRC();
    }

    protected boolean isInitError() {
        return this.initError;
    }

    public EditorPanel() {
        this.initComponents();
        try {
            this.setup(this.jTextPane1.getText());
        }
        catch (Throwable e) {
            this.initError = true;
        }
    }

    public int getVediId() {
        if (this.vediId != -1) {
            return this.vediId;
        }
        VEdiFoundationPanel vedi = VEdiFoundationPanel.getVedi(this);
        if (vedi != null) {
            this.vediId = vedi.UID;
        }
        return -1;
    }

    public EditorPanel(String fn, TinyLogInterface tl, int id) {
        this.vediId = id;
        this.tinyLog = tl;
        this.filename = fn;
        this.initComponents();
        if (tl instanceof VEdiFoundationPanel) {
            this.parent = (VEdiFoundationPanel)((Object)tl);
        }
        this.jScrollPane2.remove(this.jTextPane1);
        this.noWrapPanel.add(this.jTextPane1);
        this.jScrollPane2.setViewportView(this.noWrapPanel);
        this.jScrollPane2.getVerticalScrollBar().setUnitIncrement(12);
        try {
            openEditorMap.put(this.filename.toLowerCase(), this);
            FileReader fr = new FileReader(this.getFilename());
            this.jTextPane1.read(fr, null);
            fr.close();
            this.resetCRC();
        }
        catch (IOException e) {
            if (tl != null) {
                tl.printError("Error loading file: " + this.getFilename());
            }
            this.initError = true;
        }
        if (!this.initError) {
            try {
                this.setup(null);
            }
            catch (Throwable e) {
                this.initError = true;
            }
        }
        if (this.initError) {
            this.deinit();
        }
    }

    public boolean reload(boolean recolor) {
        if (recolor) {
            this.stopColoring();
        }
        String t = UtilityString.readTextFileToOneString(new File(this.getFilename()));
        t = UtilityString.replace(t, "\r\n", "\n");
        this.jTextPane1.setText(t);
        this.resetCRC();
        if (recolor) {
            this.startColoring();
        }
        return true;
    }

    public static String getTextForFile(String filename) {
        EditorPanel p = openEditorMap.get(filename.toLowerCase());
        if (p == null) {
            return null;
        }
        try {
            String text = p.jTextPane1.getDocument().getText(0, p.jTextPane1.getDocument().getLength());
            return text;
        }
        catch (Throwable e) {
            LogPanel slog = (LogPanel)Configuration.getConfiguration().getDebugEntity();
            slog.addLog(e);
            return null;
        }
    }

    JTextPane buildTextPane() {
        JTextPane tp = new JTextPane(){

            @Override
            public boolean getScrollableTracksViewportWidth() {
                Container parent = this.getParent();
                TextUI uii = this.getUI();
                return parent != null ? uii.getPreferredSize((JComponent)this).width <= parent.getSize().width : true;
            }
        };
        tp.addCaretListener(new EditorPanelFoundation.VisibleCaretListener());
        return tp;
    }

    public void stopColoring() {
        if (this.editorPaneDocument == null) {
            return;
        }
        this.savePos();
        this.editorPaneDocument.stopColoring();
    }

    private void startColoring() {
        if (this.editorPaneDocument == null) {
            return;
        }
        this.editorPaneDocument.startColoring();
        this.restorePos();
    }

    public void startColoring(int fontSize) {
        this.startColoring();
        this.jScrollPane2.getVerticalScrollBar().setUnitIncrement(fontSize);
        this.correctLineNumbers(true);
    }

    void savePos() {
        this.savedCaretPosition = this.jTextPane1.getCaretPosition();
    }

    void restorePos() {
        if (this.savedCaretPosition > this.jTextPane1.getDocument().getLength()) {
            return;
        }
        this.jTextPane1.setCaretPosition(this.savedCaretPosition);
        this.jTextPane1.requestFocusInWindow();
    }

    public void setViewportEnabled(final boolean b) {
        if (this.jScrollPane2.getViewport() instanceof CSAViewport2) {
            if (b) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ((CSAViewport2)((EditorPanel)EditorPanel.this).jScrollPane2.getViewport()).enableViewport = b;
                    }
                });
            } else {
                ((CSAViewport2)this.jScrollPane2.getViewport()).enableViewport = b;
            }
        }
    }

    public void setup(String t) {
        VEdiFoundationPanel vedi;
        this.inSetup = true;
        this.jTextPane2.setMargin(new Insets(1, 3, 1, 3));
        this.rowCount = -1;
        this.jTextPane1.setCaret(new EditorPanelFoundation.HighlightCaret(this));
        if (t == null) {
            t = this.jTextPane1.getText();
        }
        if (this.vediId == -1 && (vedi = VEdiFoundationPanel.getVedi(this)) != null) {
            this.vediId = vedi.UID;
        }
        this.resetDocument();
        this.jTextPane1.setDocument(this.editorPaneDocument);
        this.resetCRC();
        if (this.getFilename().toLowerCase().endsWith(".template") || this.getFilename().toLowerCase().endsWith(".s") || this.getFilename().toLowerCase().endsWith(".asm") || this.getFilename().toLowerCase().endsWith(".as9") || this.getFilename().toLowerCase().endsWith(".a69") || this.getFilename().toLowerCase().endsWith(".inc")) {
            this.assume6809Asm = true;
            this.editorPaneDocument.setHighlightStyle(HighlightedDocument.M6809_STYLE, false);
        } else if (this.getFilename().toLowerCase().endsWith(".bas")) {
            this.editorPaneDocument.setHighlightStyle(HighlightedDocument.BASIC_STYLE);
        } else if (this.getFilename().toLowerCase().endsWith(".java")) {
            this.editorPaneDocument.setHighlightStyle(HighlightedDocument.JAVA_STYLE);
        } else if (this.getFilename().toLowerCase().endsWith(".js")) {
            this.editorPaneDocument.setHighlightStyle(HighlightedDocument.JAVASCRIPT_STYLE);
        } else if (this.getFilename().toLowerCase().endsWith(".c") || this.getFilename().toLowerCase().endsWith(".h") || this.getFilename().toLowerCase().endsWith(".ec")) {
            this.editorPaneDocument.setHighlightStyle(HighlightedDocument.C_STYLE);
            this.assume6809C = true;
        } else if (this.getFilename().toLowerCase().endsWith(".htm") || this.getFilename().toLowerCase().endsWith(".html")) {
            this.editorPaneDocument.setHighlightStyle(HighlightedDocument.HTML_STYLE);
        } else if (this.getFilename().toLowerCase().endsWith(".sql")) {
            this.editorPaneDocument.setHighlightStyle(HighlightedDocument.SQL_STYLE);
        } else if (this.getFilename().toLowerCase().endsWith(".properties")) {
            this.editorPaneDocument.setHighlightStyle(HighlightedDocument.PROPERTIES_STYLE);
        } else {
            this.editorPaneDocument.setHighlightStyle(HighlightedDocument.GRAYED_OUT_STYLE);
        }
        if (this.parent instanceof VediPanel && this.getFilename().toLowerCase().endsWith(".i")) {
            if (((VediPanel)this.parent).currentProject != null && ((VediPanel)this.parent).currentProject.getIsPeerCProject()) {
                this.editorPaneDocument.setHighlightStyle(HighlightedDocument.C_STYLE);
                this.assume6809C = true;
            }
            if (!this.assume6809C) {
                this.assume6809Asm = true;
                this.editorPaneDocument.setHighlightStyle(HighlightedDocument.M6809_STYLE, false);
            }
        }
        if (t != null) {
            this.jTextPane1.setText(t);
        }
        this.editorPaneDocument.start(this.getFilename());
        this.resetCRC();
        if (VideConfig.editorUndoEnabled) {
            this.editorPaneDocument.addUndoableEditListener(this.undoManager);
            new HotKey("UndoMac", (Action)this.undoAction, (JTextComponent)this.jTextPane1);
            new HotKey("RedoMac", (Action)this.redoAction, (JTextComponent)this.jTextPane1);
            new HotKey("UndoWin", (Action)this.undoAction, (JTextComponent)this.jTextPane1);
            new HotKey("RedoWin", (Action)this.redoAction, (JTextComponent)this.jTextPane1);
            new HotKey("UndoWin", (Action)this.undoAction, (JTextComponent)this.jTextPane1);
            new HotKey("RedoWin", (Action)this.redoAction, (JTextComponent)this.jTextPane1);
        }
        new HotKey("copy-to-clipboard", (Action)null, (JTextComponent)this.jTextPane1);
        new HotKey("paste-from-clipboard", (Action)null, (JTextComponent)this.jTextPane1);
        new HotKey("cut-to-clipboard", (Action)null, (JTextComponent)this.jTextPane1);
        new HotKey("select-all", (Action)null, (JTextComponent)this.jTextPane1);
        new HotKey("EditorSearchCopy", "copy-to-clipboard", (JTextComponent)this.jTextPane1);
        new HotKey("EditorSearchPaste", "paste-from-clipboard", (JTextComponent)this.jTextPane1);
        new HotKey("EditorSearchCut", "cut-to-clipboard", (JTextComponent)this.jTextPane1);
        new HotKey("EditorSearchSelect", "select-all", (JTextComponent)this.jTextPane1);
        if (Global.getOSName().toUpperCase().contains("MAC")) {
            new HotKey("FirstCharInLine", "caret-begin-line", (JTextComponent)this.jTextPane1);
            new HotKey("LastCharInLine", "caret-end-line", (JTextComponent)this.jTextPane1);
            new HotKey("FileStart", "caret-begin", (JTextComponent)this.jTextPane1);
            new HotKey("FileEnd", "caret-end", (JTextComponent)this.jTextPane1);
        }
        new HotKey("unindent", (Action)this.shiftTabAction, (JTextComponent)this.jTextPane1);
        new HotKey("indent", (Action)this.tabAction, (JTextComponent)this.jTextPane1);
        new HotKey("SearchMac", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (EditorPanel.this.parent != null) {
                    EditorPanel.this.parent.requestSearchFocus();
                }
            }
        }, this);
        new HotKey("SearchWin", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (EditorPanel.this.parent != null) {
                    EditorPanel.this.parent.requestSearchFocus();
                }
            }
        }, this);
        new HotKey("Run", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (EditorPanel.this.parent != null) {
                    EditorPanel.this.parent.run();
                }
            }
        }, this);
        new HotKey("Debug", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (EditorPanel.this.parent != null) {
                    EditorPanel.this.parent.debug();
                }
            }
        }, this);
        new HotKey("RecolorMac", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditorPanel.this.stopColoring();
                EditorPanel.this.startColoring();
            }
        }, (JTextComponent)this.jTextPane1);
        new HotKey("RecolorWin", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditorPanel.this.stopColoring();
                EditorPanel.this.startColoring();
            }
        }, (JTextComponent)this.jTextPane1);
        new HotKey("JumpMac", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditorPanel.this.jump();
            }
        }, (JTextComponent)this.jTextPane1);
        new HotKey("JumpWin", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditorPanel.this.jump();
            }
        }, (JTextComponent)this.jTextPane1);
        new HotKey("QuickHelp", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditorPanel.this.help();
            }
        }, this);
        JViewport viewport = this.jScrollPane2.getViewport();
        viewport.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                EditorPanel.this.syncViewports();
            }
        });
        this.jScrollPane1.getViewport().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JViewport viewport = EditorPanel.this.jScrollPane2.getViewport();
                if (viewport == null) {
                    return;
                }
                Point p = viewport.getViewPosition();
                JViewport viewport2 = EditorPanel.this.jScrollPane1.getViewport();
                if (p.y != viewport2.getViewPosition().y) {
                    p.x = 0;
                    viewport2.setViewPosition(p);
                }
            }
        });
        this.jTextPane1.setCaretPosition(0);
        DefaultStyledDocument doc = new DefaultStyledDocument();
        this.jTextPane2.setDocument(doc);
        this.correctLineNumbers(true);
        this.initDebugDisplay();
        this.inSetup = false;
    }

    public void deinit() {
        if (this.editorPaneDocument != null) {
            this.editorPaneDocument.deinit();
        }
        this.editorPaneDocument = null;
        if (this.parent instanceof VediPanel) {
            this.parent.settings.setOpenPosition(this.getFilename(), this.getPosition());
        }
        if (this.parent instanceof PiTrexTerminal) {
            this.parent.settings.setOpenPosition(this.getFilename(), this.getPosition());
        }
        if (this.filename != null) {
            openEditorMap.remove(this.filename.toLowerCase());
        }
    }

    private void initComponents() {
        this.jPopupMenu1 = new JPopupMenu();
        this.jMenuItemAddVectorlist = new JMenuItem();
        this.jMenuItemAddAnim = new JMenuItem();
        this.jMenu1 = new JMenu();
        this.jMenuItem1 = new JMenuItem();
        this.jMenuItem2 = new JMenuItem();
        this.jMenuItem3 = new JMenuItem();
        this.jMenuItem4 = new JMenuItem();
        this.jMenuItem5 = new JMenuItem();
        this.jMenu3 = new JMenu();
        this.jMenuItemWatchBinary = new JMenuItem();
        this.jMenuItemWatchByte = new JMenuItem();
        this.jMenuItemWatchWord = new JMenuItem();
        this.jMenuItemWatchString = new JMenuItem();
        this.jMenuItemWatchBytePair = new JMenuItem();
        this.jMenuItemWatchSequence = new JMenuItem();
        this.jScrollPane2 = new JScrollPane(){

            @Override
            protected JViewport createViewport() {
                return new CSAViewport2();
            }
        };
        this.jTextPane1 = this.buildTextPane();
        this.jScrollPane1 = new JScrollPane(){

            @Override
            protected JViewport createViewport() {
                return new CSAViewport();
            }
        };
        this.jTextPane2 = new JTextPane();
        this.jMenuItemAddVectorlist.setText("insert vectorlist");
        this.jMenuItemAddVectorlist.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditorPanel.this.jMenuItemAddVectorlistActionPerformed(evt);
            }
        });
        this.jPopupMenu1.add(this.jMenuItemAddVectorlist);
        this.jMenuItemAddAnim.setText("insert animation/scenario");
        this.jMenuItemAddAnim.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditorPanel.this.jMenuItemAddAnimActionPerformed(evt);
            }
        });
        this.jPopupMenu1.add(this.jMenuItemAddAnim);
        this.jMenu1.setText("data generation");
        this.jMenuItem1.setText("sin");
        this.jMenuItem1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditorPanel.this.jMenuItem1ActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.jMenuItem1);
        this.jMenuItem2.setText("cos");
        this.jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditorPanel.this.jMenuItem2ActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.jMenuItem2);
        this.jMenuItem3.setText("circle (y=cos, x = -sin)");
        this.jMenuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditorPanel.this.jMenuItem3ActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.jMenuItem3);
        this.jMenuItem4.setText("sin dif");
        this.jMenuItem4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditorPanel.this.jMenuItem4ActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.jMenuItem4);
        this.jMenuItem5.setText("Faller 256");
        this.jMenuItem5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditorPanel.this.jMenuItem5ActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.jMenuItem5);
        this.jPopupMenu1.add(this.jMenu1);
        this.jMenu3.setText("Watches");
        this.jMenuItemWatchBinary.setText("add watch binary");
        this.jMenuItemWatchBinary.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditorPanel.this.jMenuItemWatchBinaryActionPerformed(evt);
            }
        });
        this.jMenu3.add(this.jMenuItemWatchBinary);
        this.jMenuItemWatchByte.setText("add watch byte");
        this.jMenuItemWatchByte.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditorPanel.this.jMenuItemWatchByteActionPerformed(evt);
            }
        });
        this.jMenu3.add(this.jMenuItemWatchByte);
        this.jMenuItemWatchWord.setText("add watch word");
        this.jMenuItemWatchWord.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditorPanel.this.jMenuItemWatchWordActionPerformed(evt);
            }
        });
        this.jMenu3.add(this.jMenuItemWatchWord);
        this.jMenuItemWatchString.setText("add watch string");
        this.jMenuItemWatchString.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditorPanel.this.jMenuItemWatchStringActionPerformed(evt);
            }
        });
        this.jMenu3.add(this.jMenuItemWatchString);
        this.jMenuItemWatchBytePair.setText("add watch byte pair");
        this.jMenuItemWatchBytePair.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditorPanel.this.jMenuItemWatchBytePairActionPerformed(evt);
            }
        });
        this.jMenu3.add(this.jMenuItemWatchBytePair);
        this.jMenuItemWatchSequence.setText("add watch sequence 5");
        this.jMenuItemWatchSequence.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditorPanel.this.jMenuItemWatchSequenceActionPerformed(evt);
            }
        });
        this.jMenu3.add(this.jMenuItemWatchSequence);
        this.jPopupMenu1.add(this.jMenu3);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                EditorPanel.this.formComponentResized(evt);
            }
        });
        this.setLayout(new BorderLayout());
        this.jScrollPane2.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                EditorPanel.this.jScrollPane2ComponentResized(evt);
            }
        });
        this.jTextPane1.setBorder(BorderFactory.createEmptyBorder(1, 3, 1, 3));
        this.jTextPane1.setFont(new Font("Courier New", 0, 12));
        this.jTextPane1.setText("\n\n\n        ORG     $0000                      ; start address of all vectrex progs -> 0\n\n        DB -$0e,  $ff, -$01, -$02, -$03, -$08, -$0a, -$0c,  $00\n\nPrint_Str_hwyx  EQU     $F373   ;\nIntensity_5F    EQU     $F2A5   ;\nWait_Recal      EQU     $F192   ;\nmusic1  EQU $FD0D               ;\n\n\n; Magic Init Block\n\n\n_m:     ; M\n        fcb     20*5,0\n        fcb     5*5,-5*5\n        fcb     0,-17*5\n        fcb     0,-18*5\n        fcb     -25*5,0\n        fcb     0,10*5\n        fcb     20*5,0\n        fcb     -5*5,5*5\n        fcb     -15*5,0\n        fcb     0,10*5\n        fcb     20*5,0\n        fcb     -5*5,5*5\n        fcb     -15*5,0\n        fcb     0,10*5\n;        fcb     1\n        fcb     -2,2,3,-1,1,1,-2,2\n\n        FCB     $67,$20                    ; copyright sign and space\n        FCC     \"GCE XXXX\"                 ; copyright text, must start with copyright sign space GCE\n        FCB     $80                        ; end of text marker\n        FDB     music1                      ; music address to be played on title screen\n        FDB     $f850                      ; text size for following text height, width (A,B)\n        FDB     $30b8                      ; position of following text y,x (A,B)\n        FCC     \"MOON LANDER\"              ; text\n        FCB     $80,$0                     ; text end ($80) and header end (0)\n\n        direct $d0                         ; vectrex starts with dp set to $d0\ninit:                                      ; start of program\n        lda <$01\n\n        JSR \t\tWait_Recal\n        jsr     Intensity_5F            ; brightness to $5f\n                                           ; no need to go to zero here,\n                                           ; since this is the first printing\n\n        ldu     #TestString1               ; load score string\n        jsr     Print_Str_hwyx          ; print it\n        ldu     #TestString2               ; load score string\n        jsr     Print_Str_hwyx          ; print it\n        ldu     #TestString3               ; load score string\n        jsr     Print_Str_hwyx          ; print it\n        ldu     #TestString4               ; load score string\n        jsr     Print_Str_hwyx          ; print it\n        ldu     #TestString5               ; load score string\n        jsr     Print_Str_hwyx          ; print it\n        ldu     #TestString6               ; load score string\n        jsr     Print_Str_hwyx          ; print it\n        ldu     #TestString7               ; load score string\n        jsr     Print_Str_hwyx          ; print it\n        ldu     #TestString8               ; load score string\n        jsr     Print_Str_hwyx          ; print it\n        ldu     #TestString9               ; load score string\n        jsr     Print_Str_hwyx          ; print it\n\n        jmp init\n\n\n\nTestString1:\n        fdb      $f53a\n        fdb      $7090\n\tFCC     \"THIS IS A LONG MESSAGE TO BE\"\n\t  FCB $81\nTestString2:\n        fdb      $f53a\n        fdb      $5090\n\tFCC     \"PRINTED ON A POOR VECTREX\"\n\t  FCB $81\nTestString3:\n        fdb      $f53a\n        fdb      $3090\n\tFCC     \"DISPLAY, BUT IT MIGHT BE USED\"\n\t  FCB $81\nTestString4:\n        fdb      $f53a\n        fdb      $1090\n\tFCC     \"AS A SPEEDTEST FOR THE PRINT\"\n\t  FCB $81\nTestString5:\n        fdb      $f53a\n        fdb      $e090\n\tFCC     \"ROUTINES!\"\n\t  FCB $81\nTestString6:\n        fdb      $f53a\n        fdb      $d090\n\tFCC     \"THIS IS A LONG MESSAGE TO BE\"\n\t  FCB $81\nTestString7:\n        fdb      $f53a\n        fdb      $b090\n\tFCC     \"PRINTED ON A POOR VECTREX\"\n\t  FCB $81\nTestString8:\n        fdb      $f53a\n        fdb      $9090\n\tFCC     \"DISPLAY, BUT IT MIGHT BE USED\"\n\t  FCB $81\nTestString9:\n        fdb      $f53a\n        fdb      $8090\n\tFCC     \"AS A SPEEDTEST FOR THE PRINT\"\n\t  FCB $81\n");
        this.jTextPane1.setMinimumSize(new Dimension(100, 100));
        this.jTextPane1.setPreferredSize(null);
        this.jTextPane1.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent evt) {
                EditorPanel.this.jTextPane1CaretUpdate(evt);
            }
        });
        this.jTextPane1.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                EditorPanel.this.jTextPane1MousePressed(evt);
            }
        });
        this.jTextPane1.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                EditorPanel.this.jTextPane1ComponentResized(evt);
            }
        });
        this.jTextPane1.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                EditorPanel.this.jTextPane1KeyPressed(evt);
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                EditorPanel.this.jTextPane1KeyTyped(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.jTextPane1);
        this.add((Component)this.jScrollPane2, "Center");
        this.jScrollPane1.setHorizontalScrollBarPolicy(31);
        this.jScrollPane1.setVerticalScrollBarPolicy(21);
        this.jScrollPane1.setFocusable(false);
        this.jTextPane2.setEditable(false);
        this.jTextPane2.setFont(new Font("Courier New", 0, 12));
        this.jTextPane2.setCursor(new Cursor(0));
        this.jTextPane2.setPreferredSize(null);
        this.jTextPane2.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                EditorPanel.this.jTextPane2MousePressed(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTextPane2);
        this.add((Component)this.jScrollPane1, "West");
    }

    int countChars(String s, String c) {
        int count = 0;
        int pos = -1;
        do {
            if ((pos = s.indexOf(c, pos + 1)) < 0) continue;
            ++count;
        } while (pos >= 0);
        return count;
    }

    void recountBraces() {
        int lineCount = this.getLineCount(this.jTextPane1);
        if (lineCount <= 0) {
            lineCount = 0;
        }
        int openCount = 0;
        this.brackCount = new int[lineCount];
        try {
            int length = this.jTextPane1.getDocument().getLength();
            String text = this.jTextPane1.getDocument().getText(0, length);
            String[] split = text.split("\n");
            for (int i = 0; i < split.length; ++i) {
                openCount += this.countChars(split[i], "{");
                openCount -= this.countChars(split[i], "}");
                if (i + 1 >= this.brackCount.length) continue;
                this.brackCount[i + 1] = openCount;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    String getTabForLineBracket(int line) {
        this.recountBraces();
        if (line >= this.brackCount.length) {
            return "";
        }
        if (line < 0) {
            return "";
        }
        String ret = "";
        for (int i = 0; i < this.brackCount[line]; ++i) {
            ret = ret + this.getTABString();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jTextPane1KeyTyped(KeyEvent evt) {
        this.rowCount = -1;
        this.fireEditorChanged(1, this.getPosition());
        this.hasChanged1 = true;
        this.hasChanged2 = true;
        if (evt.getExtendedKeyCode() == 10) {
            try {
                int startPos = this.jTextPane1.getCaretPosition();
                int lineNo = this.getLineOfPos(startPos);
                Object object = this.editorPaneDocument.getDocumentLock();
                synchronized (object) {
                    this.jTextPane1.setSelectionStart(startPos);
                    this.jTextPane1.setSelectionEnd(startPos);
                    this.jTextPane1.replaceSelection(this.getTabForLineBracket(lineNo));
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
                this.log.addLog("Attrib:\n" + Utility.getStackTrace(e), LogPanel.INFO);
            }
        }
        if (evt.getExtendedKeyCode() == 162) {
            try {
                int startPos = this.jTextPane1.getCaretPosition() - this.getTABString().length();
                int endPos = this.jTextPane1.getCaretPosition() - 0;
                this.jTextPane1.setSelectionStart(startPos);
                this.jTextPane1.setSelectionEnd(endPos);
                String before = this.jTextPane1.getSelectedText();
                if (before.endsWith(this.getTABString())) {
                    Object object = this.editorPaneDocument.getDocumentLock();
                    synchronized (object) {
                        this.jTextPane1.replaceSelection("}");
                        evt.consume();
                    }
                }
                this.jTextPane1.setSelectionStart(startPos + 1);
                this.jTextPane1.setSelectionEnd(startPos + 1);
            }
            catch (Throwable e) {
                e.printStackTrace();
                this.log.addLog("Attrib:\n" + Utility.getStackTrace(e), LogPanel.INFO);
            }
        }
        this.correctLineNumbers(false);
    }

    private void jTextPane1CaretUpdate(CaretEvent evt) {
        this.fireEditorChanged(0, this.getPosition());
    }

    private String getStarterText() {
        int pos = this.jTextPane1.getCaretPosition() - 1;
        if (pos <= 0) {
            return "";
        }
        String word = "";
        try {
            String text = this.jTextPane1.getDocument().getText(0, this.jTextPane1.getDocument().getLength());
            char c = text.charAt(pos);
            while (!UtilityString.isWordBoundry(c) && --pos >= 0) {
                c = text.charAt(pos);
            }
            c = text.charAt(++pos);
            while (!UtilityString.isWordBoundry(c) && pos <= this.jTextPane1.getCaretPosition() - 1) {
                word = word + c;
                c = text.charAt(++pos);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return word;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jTextPane1KeyPressed(KeyEvent evt) {
        boolean ctrl;
        boolean bl = ctrl = (evt.getModifiersEx() & 0x80) == 128;
        if (!ctrl) {
            return;
        }
        if (evt.getKeyCode() == 32) {
            int endPos = this.jTextPane1.getCaretPosition();
            int startPos = endPos - 1;
            if (startPos <= 0) {
                return;
            }
            try {
                int y5;
                int y4;
                int y3;
                int y2;
                int y1;
                int posy;
                int x5;
                int x4;
                int x3;
                int x2;
                Rectangle pos;
                int x1;
                int posx;
                String text = this.jTextPane1.getDocument().getText(0, this.jTextPane1.getDocument().getLength());
                char c = text.charAt(startPos);
                while (!UtilityString.isWordBoundry(c) && --startPos >= 0) {
                    c = text.charAt(startPos);
                }
                String starter = this.getStarterText();
                ArrayList<String> possibleWord = this.getPossibleWords(starter);
                String select = ListPopupJPanel.showListDialog(possibleWord, posx = (x1 = (int)(pos = this.jTextPane1.modelToView(++startPos)).getX()) + (x2 = this.parent.getEditorPos().x) + (x3 = Configuration.getConfiguration().getMainFrame().getInternalFrame(this.parent).getX()) + (x4 = this.jScrollPane1.getWidth() + 4) + (x5 = -this.jScrollPane2.getViewport().getViewPosition().x), posy = (y1 = (int)pos.getY()) + (y2 = this.parent.getEditorPos().y) + (y3 = Configuration.getConfiguration().getMainFrame().getInternalFrame(this.parent).getY()) + (y4 = 95) + (y5 = -this.jScrollPane2.getViewport().getViewPosition().y));
                if (select.length() != 0) {
                    Object object = this.editorPaneDocument.getDocumentLock();
                    synchronized (object) {
                        this.jTextPane1.setSelectionStart(startPos);
                        this.jTextPane1.setSelectionEnd(endPos);
                        this.jTextPane1.replaceSelection(select);
                    }
                }
                this.jTextPane1.requestFocusInWindow();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    ArrayList<String> getPossibleWords(String starter) {
        ArrayList<String> ret = new ArrayList<String>();
        if (this.assume6809Asm) {
            Set<Map.Entry<String, EntityDefinition>> entries = VediPanel.getVedi((Component)this).asmInfo.knownGlobalVariables.entrySet();
            Iterator<Map.Entry<String, EntityDefinition>> it = entries.iterator();
            while (it.hasNext()) {
                try {
                    Map.Entry<String, EntityDefinition> entry = it.next();
                    EntityDefinition value = entry.getValue();
                    if (!value.getName().toLowerCase().startsWith(starter.toLowerCase())) continue;
                    ret.add(value.getName());
                }
                catch (Throwable entry) {}
            }
        } else if (this.assume6809C) {
            Set<Map.Entry<String, EntityDefinition>> entries = VediPanel.getVedi((Component)this).cInfo.knownGlobalFunctions.entrySet();
            for (Map.Entry<String, EntityDefinition> entry : entries) {
                EntityDefinition value = entry.getValue();
                if (!value.getName().toLowerCase().startsWith(starter.toLowerCase())) continue;
                ret.add(value.getName());
            }
        }
        Collections.sort(ret);
        return ret;
    }

    private void jTextPane1MousePressed(MouseEvent evt) {
        boolean shift;
        if (this.isBasic) {
            return;
        }
        Point pt = new Point(evt.getX(), evt.getY());
        int pos = this.jTextPane1.viewToModel(pt);
        boolean bl = shift = (evt.getModifiersEx() & 0x40) == 64;
        if (evt.getClickCount() == 2) {
            this.jTextPane1.setSelectionStart(pos);
            this.jTextPane1.setSelectionEnd(pos);
            if (SwingUtilities.isMiddleMouseButton(evt) || shift) {
                String word = this.getWordOfPos(this.jTextPane1, pos);
                if (this.parent != null) {
                    this.parent.processWord(word);
                }
            } else {
                int line = this.getLineOfPos(this.jTextPane1, pos);
                if (line != -1 && this.parent != null) {
                    this.parent.processIncludeLine(this.getLine(this.jTextPane1, line));
                }
            }
        } else if (SwingUtilities.isLeftMouseButton(evt)) {
            if ((evt.getModifiersEx() & 0x40) == 64) {
                int oldpos = this.jTextPane1.getCaretPosition();
                this.jTextPane1.setSelectionStart(pos);
                this.jTextPane1.setSelectionEnd(oldpos);
                this.jTextPane1.setCaretPosition(oldpos);
                return;
            }
        } else if (SwingUtilities.isRightMouseButton(evt)) {
            this.popUpTextPos = pos;
            this.jMenu3.setVisible(this.assume6809Asm);
            this.jPopupMenu1.show(this, evt.getX() - 20 - this.jScrollPane2.getViewport().getViewPosition().x, evt.getY() - 20 - this.jScrollPane2.getViewport().getViewPosition().y);
        }
        this.jTextPane1.setSelectionStart(pos);
        this.jTextPane1.setSelectionEnd(pos);
    }

    private void jMenuItemAddVectorlistActionPerformed(ActionEvent evt) {
        String filenameI = Global.mainPathPrefix + "xml" + File.separator + "vectorlist";
        String text = VectorListFileChoserJPanel.showLoadPanel(filenameI, "Load Vectorlist", false, true);
        this.stopColoring();
        try {
            this.jTextPane1.getDocument().insertString(this.popUpTextPos, text, null);
            this.correctLineNumbers(false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.startColoring();
    }

    private void jMenuItemAddAnimActionPerformed(ActionEvent evt) {
        String filenameI = Global.mainPathPrefix + "xml" + File.separator + "vectoranimation";
        String text = VectorListFileChoserJPanel.showLoadPanel(filenameI, "Load Vector-Animation", true, true);
        this.stopColoring();
        try {
            this.jTextPane1.getDocument().insertString(this.popUpTextPos, text, null);
            this.correctLineNumbers(false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.startColoring();
    }

    private void jTextPane1ComponentResized(ComponentEvent evt) {
    }

    private void jScrollPane2ComponentResized(ComponentEvent evt) {
    }

    private void formComponentResized(ComponentEvent evt) {
        this.jScrollPane2.doLayout();
        Rectangle size = this.jScrollPane2.getBounds();
        size.height = this.getHeight();
        this.jScrollPane2.setBounds(size);
        size = this.jScrollPane1.getBounds();
        size.height = this.getHeight();
        this.jScrollPane1.setBounds(size);
        this.invalidate();
        this.validate();
        this.doLayout();
        this.repaint();
    }

    private void jTextPane2MousePressed(MouseEvent evt) {
        if (this.isBasic) {
            return;
        }
        Point pt = new Point(evt.getX(), evt.getY());
        int pos = this.jTextPane2.viewToModel(pt);
        int line = this.getLineOfPos(this.jTextPane2, pos);
        if (line == -1) {
            return;
        }
        if (SwingUtilities.isLeftMouseButton(evt)) {
            if (this.assume6809Asm) {
                this.toggleBreakpoint(line);
            } else if (this.assume6809C) {
                this.toggleBreakpoint(line);
            }
        } else if (SwingUtilities.isRightMouseButton(evt)) {
            // empty if block
        }
    }

    private void jMenuItem1ActionPerformed(ActionEvent evt) {
        int count = GetSinValuePanel.showEnterValueDialog();
        double radius = GetRadiusValuePanel.showEnterValueDialog();
        if (count == 0) {
            return;
        }
        StringBuilder builder = new StringBuilder();
        double adds = 360.0 / (double)count;
        double angle = 0.0;
        builder.append("; sin generated 0\u00b0-360\u00b0 in ").append(count).append(" steps, radius: " + (int)radius + "\n");
        for (int i = 0; i < count; ++i) {
            int v = (int)(Math.sin(Math.toRadians(angle)) * radius) & 0xFF;
            builder.append(" ").append("db ").append("$").append(String.format("%02X", v)).append(" ; degrees: ").append((int)angle).append("\u00b0\n");
            angle += adds;
        }
        this.stopColoring();
        try {
            this.jTextPane1.getDocument().insertString(this.popUpTextPos, builder.toString(), null);
            this.correctLineNumbers(false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.startColoring();
    }

    private void jMenuItem2ActionPerformed(ActionEvent evt) {
        int count = GetSinValuePanel.showEnterValueDialog();
        double radius = GetRadiusValuePanel.showEnterValueDialog();
        if (count == 0) {
            return;
        }
        StringBuilder builder = new StringBuilder();
        double adds = 360.0 / (double)count;
        double angle = 0.0;
        builder.append("; cos generated 0\u00b0-360\u00b0 in ").append(count).append(" steps, radius: " + (int)radius + "\n");
        for (int i = 0; i < count; ++i) {
            int v = (int)(Math.cos(Math.toRadians(angle)) * radius) & 0xFF;
            builder.append(" ").append("db ").append("$").append(String.format("%02X", v)).append(" ; degrees: ").append((int)angle).append("\u00b0\n");
            angle += adds;
        }
        this.stopColoring();
        try {
            this.jTextPane1.getDocument().insertString(this.popUpTextPos, builder.toString(), null);
            this.correctLineNumbers(false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.startColoring();
    }

    private void jMenuItem3ActionPerformed(ActionEvent evt) {
        int count = GetSinValuePanel.showEnterValueDialog();
        double radius = GetRadiusValuePanel.showEnterValueDialog();
        if (count == 0) {
            return;
        }
        StringBuilder builder = new StringBuilder();
        double adds = 360.0 / (double)count;
        double angle = 0.0;
        builder.append("; circle generated 0\u00b0-360\u00b0 in ").append(count).append(" steps (cos, -sin), radius: " + (int)radius + "\n");
        for (int i = 0; i < count; ++i) {
            int cos = (int)(Math.cos(Math.toRadians(angle)) * radius) & 0xFF;
            int sin = (int)(-Math.sin(Math.toRadians(angle)) * radius) & 0xFF;
            builder.append(" ").append("db ").append("$").append(String.format("%02X", cos)).append(", $").append(String.format("%02X", sin)).append(" ; degrees: ").append((int)angle).append("\u00b0\n");
            angle += adds;
        }
        this.stopColoring();
        try {
            this.jTextPane1.getDocument().insertString(this.popUpTextPos, builder.toString(), null);
            this.correctLineNumbers(false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.startColoring();
    }

    private void jMenuItemWatchBinaryActionPerformed(ActionEvent evt) {
        this.addWatch(this.popUpTextPos, 0, 0);
    }

    private void jMenuItemWatchByteActionPerformed(ActionEvent evt) {
        this.addWatch(this.popUpTextPos, 1, 0);
    }

    private void jMenuItemWatchWordActionPerformed(ActionEvent evt) {
        this.addWatch(this.popUpTextPos, 2, 0);
    }

    private void jMenuItemWatchStringActionPerformed(ActionEvent evt) {
        this.addWatch(this.popUpTextPos, 3, 0);
    }

    private void jMenuItemWatchBytePairActionPerformed(ActionEvent evt) {
        this.addWatch(this.popUpTextPos, 4, 0);
    }

    private void jMenuItemWatchSequenceActionPerformed(ActionEvent evt) {
        this.addWatch(this.popUpTextPos, 5, 5);
    }

    private void jMenuItem4ActionPerformed(ActionEvent evt) {
        int count = GetSinValuePanel.showEnterValueDialog();
        double radius = GetRadiusValuePanel.showEnterValueDialog();
        if (count == 0) {
            return;
        }
        StringBuilder builder = new StringBuilder();
        double adds = 360.0 / (double)count;
        double angle = 0.0;
        builder.append("; sin generated 0\u00b0-360\u00b0 in ").append(count).append(" steps, radius: " + (int)radius + "\n");
        int oldValue = 0;
        for (int i = 0; i < count; ++i) {
            int v = (int)(Math.sin(Math.toRadians(angle)) * radius) & 0xFF;
            int difValue = v - oldValue;
            oldValue = v;
            builder.append(" ").append("db ").append("$").append(String.format("%02X", difValue & 0xFF)).append(" ; degrees: ").append((int)angle).append("\u00b0\n");
            angle += adds;
        }
        this.stopColoring();
        try {
            this.jTextPane1.getDocument().insertString(this.popUpTextPos, builder.toString(), null);
            this.correctLineNumbers(false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.startColoring();
    }

    private void jMenuItem5ActionPerformed(ActionEvent evt) {
        int count = GetSinValuePanel.showEnterValueDialog();
        double radius = GetRadiusValuePanel.showEnterValueDialog();
        if (count == 0) {
            return;
        }
        StringBuilder builder = new StringBuilder();
        double adds = 360.0 / (double)count;
        double angle = 270.0;
        builder.append("; circle generated 0\u00b0-360\u00b0 in ").append(count).append(" steps (cos, -sin), radius: " + (int)radius + "\n");
        double anglePrint = 0.0;
        for (int i = 0; i < count; ++i) {
            int cos = (int)(Math.cos(Math.toRadians(angle)) * radius) & 0xFF;
            int sin = (int)(-Math.sin(Math.toRadians(angle)) * radius) & 0xFF;
            builder.append(" ").append("db ").append("$").append(String.format("%02X", cos)).append(", $").append(String.format("%02X", sin)).append(" ; degrees: ").append((int)anglePrint).append("\u00b0 (" + i + ")\n");
            angle -= adds;
            anglePrint += adds;
            if (!(angle < 0.0)) continue;
            angle += 360.0;
        }
        this.stopColoring();
        try {
            this.jTextPane1.getDocument().insertString(this.popUpTextPos, builder.toString(), null);
            this.correctLineNumbers(false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.startColoring();
    }

    int getCurrentLineNumber() {
        return this.getLineOfPos(this.jTextPane1.getCaretPosition());
    }

    int getLineOfPos(int pos) {
        return this.getLineOfPos(this.jTextPane1, pos);
    }

    int getLineOfPos(JTextPane comp, int pos) {
        int ret = -1;
        try {
            String[] lines = comp.getDocument().getText(0, comp.getDocument().getLength()).split("\n");
            int c = -1;
            for (int count = 0; count <= pos; count += lines[++c].length() + 1) {
            }
            if (c < lines.length) {
                ret = c;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return ret;
    }

    int getStartOfWord(JTextPane comp, int pos) {
        int word = -1;
        try {
            String text = comp.getDocument().getText(0, comp.getDocument().getLength());
            char c = text.charAt(pos);
            while (!UtilityString.isWordBoundry(c) && --pos >= 0) {
                c = text.charAt(pos);
            }
            return ++pos;
        }
        catch (Throwable throwable) {
            return word;
        }
    }

    String getWordOfPos(JTextPane comp, int pos) {
        String word = "";
        try {
            String text = comp.getDocument().getText(0, comp.getDocument().getLength());
            char c = text.charAt(pos);
            while (!UtilityString.isWordBoundry(c) && --pos >= 0) {
                c = text.charAt(pos);
            }
            c = text.charAt(++pos);
            while (!UtilityString.isWordBoundry(c)) {
                word = word + c;
                c = text.charAt(++pos);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return word;
    }

    String getIntOfPos(JTextPane comp, int pos) {
        String word = "";
        try {
            String text = comp.getDocument().getText(0, comp.getDocument().getLength());
            char c = text.charAt(pos);
            while (!UtilityString.isIntBoundry(c) && --pos >= 0) {
                c = text.charAt(pos);
            }
            c = text.charAt(++pos);
            while (!UtilityString.isIntBoundry(c)) {
                word = word + c;
                c = text.charAt(++pos);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return word;
    }

    public int getPosOfLineStart(int line) {
        int pos = 0;
        try {
            String[] lines = this.jTextPane1.getDocument().getText(0, this.jTextPane1.getDocument().getLength()).split("\n");
            int lineCounter = 0;
            while (lineCounter < line) {
                pos += lines[lineCounter].length() + 1;
                if (++lineCounter < lines.length) continue;
                return -1;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return pos;
    }

    public int getPosOfLineStart(int line, JTextPane jTextPane) {
        int pos = 0;
        try {
            String[] lines = jTextPane.getDocument().getText(0, jTextPane.getDocument().getLength()).split("\n");
            int lineCounter = 0;
            while (lineCounter < line) {
                pos += lines[lineCounter].length() + 1;
                if (++lineCounter < lines.length) continue;
                return -1;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return pos;
    }

    public String getLine(JTextPane comp, int line) {
        try {
            return comp.getDocument().getText(0, comp.getDocument().getLength()).split("\n")[line];
        }
        catch (Throwable throwable) {
            return "";
        }
    }

    public void setTinyLog(TinyLogInterface tl) {
        this.tinyLog = tl;
    }

    public int getCharCount() {
        return this.editorPaneDocument.getLength();
    }

    public int getTextpaneRowCount() {
        if (this.rowCount != -1) {
            return this.rowCount;
        }
        this.rowCount = this.jTextPane1.getText().split("\n").length;
        return this.rowCount;
    }

    public String getFilename() {
        return this.filename;
    }

    public void replaceFilename(String fn) {
        openEditorMap.remove(this.filename.toLowerCase());
        this.filename = fn;
        openEditorMap.put(this.filename.toLowerCase(), this);
    }

    public String getPath() {
        Path path = Paths.get(this.filename, new String[0]);
        return path.getParent().toString();
    }

    public String getText() {
        String text = "";
        try {
            text = this.jTextPane1.getDocument().getText(0, this.jTextPane1.getDocument().getLength());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return text;
    }

    public void setText(String text) {
        this.jTextPane1.setText(text);
    }

    public void setFilename(String ff) {
        openEditorMap.remove(this.filename.toLowerCase());
        this.filename = ff;
        openEditorMap.put(this.filename.toLowerCase(), this);
    }

    public boolean goNext(String toSearch, boolean ignoreCase) {
        try {
            int startPos;
            int startSearchPos = this.jTextPane1.getCaretPosition();
            if (ignoreCase) {
                toSearch = toSearch.toLowerCase();
            }
            String text = this.jTextPane1.getDocument().getText(0, this.jTextPane1.getDocument().getLength()).substring(startSearchPos);
            if (ignoreCase) {
                text = text.toLowerCase();
            }
            if ((startPos = text.indexOf(toSearch)) < 0 && startSearchPos > 1) {
                startSearchPos = 0;
                text = this.jTextPane1.getDocument().getText(0, this.jTextPane1.getDocument().getLength()).substring(startSearchPos);
                if (ignoreCase) {
                    text = text.toLowerCase();
                }
                if ((startPos = text.indexOf(toSearch)) < 0) {
                    return false;
                }
                this.parent.wrapped = true;
            }
            this.jTextPane1.setSelectionStart(startPos + startSearchPos);
            this.jTextPane1.setSelectionEnd(startPos + startSearchPos + toSearch.length());
            this.jTextPane1.requestFocusInWindow();
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public boolean goPrevious(String toSearch, boolean ignoreCase) {
        try {
            int startPos;
            if (ignoreCase) {
                toSearch = toSearch.toLowerCase();
            }
            String text = this.jTextPane1.getDocument().getText(0, this.jTextPane1.getDocument().getLength()).substring(0, this.jTextPane1.getCaretPosition());
            if (ignoreCase) {
                text = text.toLowerCase();
            }
            if ((startPos = text.lastIndexOf(toSearch)) < 0) {
                text = this.jTextPane1.getDocument().getText(0, this.jTextPane1.getDocument().getLength());
                if (ignoreCase) {
                    text = text.toLowerCase();
                }
                if ((startPos = text.lastIndexOf(toSearch)) < 0) {
                    return false;
                }
                this.parent.wrapped = true;
            }
            this.jTextPane1.setSelectionStart(startPos);
            this.jTextPane1.setSelectionEnd(startPos + toSearch.length() - 1);
            this.jTextPane1.requestFocusInWindow();
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public boolean goLine(int lineNumber) {
        try {
            int lineNow;
            String[] lines = this.jTextPane1.getDocument().getText(0, this.jTextPane1.getDocument().getLength()).split("\n");
            int lenNow = 0;
            for (lineNow = 1; lineNow != lineNumber; ++lineNow) {
                lenNow += lines[lineNow - 1].length() + 1;
            }
            int lineNowf = lineNow;
            int lenNowf = lenNow;
            this.jTextPane1.requestFocusInWindow();
            this.jTextPane1.setSelectionStart(0);
            this.jTextPane1.setSelectionEnd(lenNowf + lines[lineNowf - 1].length());
            this.jTextPane1.setSelectionStart(lenNowf);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean replaceNext(String toSearch, String replacement, boolean ignoreCase, boolean singleReplace, boolean isLocked) {
        try {
            int startPos;
            int startSearchPos = this.jTextPane1.getCaretPosition();
            if (ignoreCase) {
                toSearch = toSearch.toLowerCase();
            }
            String text = this.jTextPane1.getDocument().getText(0, this.jTextPane1.getDocument().getLength()).substring(startSearchPos);
            if (ignoreCase) {
                text = text.toLowerCase();
            }
            if ((startPos = text.indexOf(toSearch)) < 0) {
                return false;
            }
            if (!isLocked) {
                Object object = this.editorPaneDocument.getDocumentLock();
                synchronized (object) {
                    this.jTextPane1.setSelectionStart(startPos + startSearchPos);
                    this.jTextPane1.setSelectionEnd(startPos + startSearchPos + toSearch.length());
                    this.jTextPane1.replaceSelection(replacement);
                }
            } else {
                this.jTextPane1.setSelectionStart(startPos + startSearchPos);
                this.jTextPane1.setSelectionEnd(startPos + startSearchPos + toSearch.length());
                this.jTextPane1.replaceSelection(replacement);
            }
            if (singleReplace) {
                this.jTextPane1.requestFocusInWindow();
            }
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int replaceAll(String toSearch, String replacement, boolean ignoreCase) {
        if (toSearch.length() == 0) {
            return -1;
        }
        int count = -1;
        int startSearchPos = this.jTextPane1.getCaretPosition();
        this.jTextPane1.setCaretPosition(0);
        this.stopColoring();
        Object object = this.editorPaneDocument.getDocumentLock();
        synchronized (object) {
            boolean found = false;
            do {
                ++count;
            } while (found = this.replaceNext(toSearch, replacement, ignoreCase, false, true));
        }
        this.startColoring();
        this.jTextPane1.setCaretPosition(startSearchPos);
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int replaceSel(String toSearch, String replacement, boolean ignoreCase, int start, int end2, boolean isLocked) {
        try {
            int startSearchPos = this.jTextPane1.getCaretPosition();
            if (start != -1) {
                startSearchPos = start;
            }
            if (ignoreCase) {
                toSearch = toSearch.toLowerCase();
            }
            String text = this.jTextPane1.getDocument().getText(0, this.jTextPane1.getDocument().getLength()).substring(startSearchPos);
            if (ignoreCase) {
                text = text.toLowerCase();
            }
            int startPos = text.indexOf(toSearch);
            if (end2 != -1 && startPos + startSearchPos + toSearch.length() > end2) {
                return -1;
            }
            if (startPos < 0) {
                return -1;
            }
            if (!isLocked) {
                Object object = this.editorPaneDocument.getDocumentLock();
                synchronized (object) {
                    this.jTextPane1.setSelectionStart(startPos + startSearchPos);
                    this.jTextPane1.setSelectionEnd(startPos + startSearchPos + toSearch.length());
                    this.jTextPane1.replaceSelection(replacement);
                    this.jTextPane1.requestFocusInWindow();
                }
            } else {
                this.jTextPane1.setSelectionStart(startPos + startSearchPos);
                this.jTextPane1.setSelectionEnd(startPos + startSearchPos + toSearch.length());
                this.jTextPane1.replaceSelection(replacement);
                this.jTextPane1.requestFocusInWindow();
            }
            return this.jTextPane1.getCaretPosition();
        }
        catch (Throwable e) {
            e.printStackTrace();
            return -1;
        }
    }

    public boolean hasSelection() {
        int start = this.jTextPane1.getSelectionStart();
        int end2 = this.jTextPane1.getSelectionEnd();
        return end2 - start != 0;
    }

    public void saveSelection() {
        this.selStart = this.jTextPane1.getSelectionStart();
        this.selEnd = this.jTextPane1.getSelectionEnd();
    }

    public void restoreSelection() {
        this.jTextPane1.setSelectionStart(this.selStart);
        this.jTextPane1.setSelectionEnd(this.selEnd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int replaceInSelection(String toSearch, String replacement, boolean ignoreCase) {
        int start;
        int startOrg = start = this.jTextPane1.getSelectionStart();
        int end2 = this.jTextPane1.getSelectionEnd();
        int count = -1;
        this.stopColoring();
        this.jTextPane1.setCaretPosition(start);
        Object object = this.editorPaneDocument.getDocumentLock();
        synchronized (object) {
            do {
                ++count;
            } while ((start = this.replaceSel(toSearch, replacement, ignoreCase, start, end2, true)) > 0);
        }
        this.startColoring();
        this.jTextPane1.setCaretPosition(startOrg);
        this.jTextPane1.setSelectionStart(startOrg);
        this.jTextPane1.setSelectionEnd(end2);
        this.jTextPane1.requestFocusInWindow();
        return count;
    }

    public void reColor() {
        this.editorPaneDocument.colorAll();
    }

    public void reColorDirect() {
        this.editorPaneDocument.stopColoring();
        this.editorPaneDocument.startColoring();
    }

    @Override
    public Dimension getPreferredSize() {
        try {
            this.oldDim = super.getPreferredSize();
        }
        catch (Throwable e) {
            System.out.println("Bad things happen!");
        }
        return this.oldDim;
    }

    public void setODOA(boolean b) {
        this._0d0a = b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean save(boolean saveAs) {
        boolean ret = true;
        String newFilename = this.filename;
        String oldFilename = this.filename;
        if (saveAs) {
            InternalFrameFileChoser fc = new InternalFrameFileChoser();
            Path p = Paths.get(this.filename, new String[0]);
            fc.setCurrentDirectory(new File(p.getParent().toString()));
            int r = fc.showOpenDialog(Configuration.getConfiguration().getMainFrame());
            if (r != 0) {
                return false;
            }
            this.filename = newFilename = fc.getSelectedFile().getAbsolutePath();
        }
        if (this._0d0a) {
            if (saveAs) {
                this.parent.changeFileName(oldFilename, newFilename);
            }
            this.tinyLog.printMessage("Saving file: " + this.filename);
            try {
                String text = this.jTextPane1.getDocument().getText(0, this.jTextPane1.getDocument().getLength());
                text = UtilityString.replace(text, "\n", "\r\n");
                UtilityFiles.createTextFile(this.filename, text);
            }
            catch (Throwable e) {
                this.tinyLog.printError("Error saving file: " + this.filename);
                this.tinyLog.printError(Utility.getCurrentStackTrace());
            }
            return ret;
        }
        FileWriter writer = null;
        try {
            writer = new FileWriter(this.getFilename());
            this.jTextPane1.write(writer);
            this.tinyLog.printMessage("Saving file: " + this.getFilename());
            if (saveAs) {
                this.parent.changeFileName(oldFilename, newFilename);
            }
            this.resetCRC();
        }
        catch (IOException e) {
            this.tinyLog.printError("Error saving file: " + this.filename);
            this.tinyLog.printError(Utility.getCurrentStackTrace());
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Throwable throwable) {}
            }
        }
        return ret;
    }

    String getTABString() {
        String tab = "";
        for (int i = 0; i < this.config.tab_width; ++i) {
            tab = tab + " ";
        }
        return tab;
    }

    @Override
    protected void editActionChanged() {
        if (this.parent == null) {
            return;
        }
        this.parent.tabChanged(false);
    }

    public void jump() {
        int line = GetJumpValuePanel.showEnterValueDialog();
        this.jump(line);
        if (line <= 0) {
            this.goLine(0);
        } else if (line > this.getTextpaneRowCount()) {
            this.goLine(this.getTextpaneRowCount() - 1);
        } else {
            this.goLine(line);
        }
        this.jTextPane1.grabFocus();
    }

    public void jump(int line) {
        if (line <= 0) {
            this.goLine(0);
        } else if (line > this.getTextpaneRowCount()) {
            this.goLine(this.getTextpaneRowCount() - 1);
        } else {
            this.goLine(line);
        }
        this.jTextPane1.grabFocus();
    }

    public void help() {
        int pos = this.jTextPane1.getCaretPosition();
        String word = this.getWordOfPos(this.jTextPane1, pos);
        String integer = this.getIntOfPos(this.jTextPane1, pos);
        this.parent.doQuickHelp(word, integer);
    }

    public void setBasic(boolean b) {
        this.isBasic = b;
    }

    @Override
    public void fireEditorChanged(int type, int line) {
        super.fireEditorChanged(type, line);
    }

    void updateMyUI() {
        SwingUtilities.updateComponentTreeUI(this.jPopupMenu1);
        this.correctLineNumbers(true);
    }

    int getLineCount(JTextPane textpane) {
        try {
            int length = textpane.getDocument().getLength();
            String text = textpane.getDocument().getText(0, length);
            int lineCount = text.split("\n").length;
            int backOffset = 1;
            while (text.charAt(length - backOffset) == '\n') {
                ++lineCount;
                ++backOffset;
            }
            return lineCount;
        }
        catch (Throwable throwable) {
            return -1;
        }
    }

    public void correctLineNumbers(boolean force) {
        try {
            int lineNumberWidth;
            AttributeSet normal = TokenStyles.getStyle("comment");
            AttributeSet bookmark = TokenStyles.getStyle("bookmark");
            AttributeSet breakpoint = TokenStyles.getStyle("breakpoint");
            int lineCountOrg = this.getLineCount(this.jTextPane1);
            int lineCountNow = this.getLineCount(this.jTextPane2);
            if (lineCountOrg > lineCountNow) {
                this.breakPointLineAdded();
            } else if (lineCountOrg < lineCountNow) {
                this.breakPointLineDeleted();
            }
            if (lineCountNow > lineCountOrg || force) {
                lineCountNow = 0;
            }
            int w = 3;
            if (lineCountOrg > 999) {
                w = 4;
            }
            if (lineCountOrg > 9999) {
                w = 5;
            }
            if (lineCountOrg > 99999) {
                w = 6;
            }
            if (this.oldlnWidth != (lineNumberWidth = (StyleConstants.getFontSize(normal) - 1) * w)) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Dimension lNumberSize = new Dimension(lineNumberWidth, ((EditorPanel)EditorPanel.this).jScrollPane1.getSize().height);
                        EditorPanel.this.jScrollPane1.setSize(lNumberSize);
                        EditorPanel.this.jScrollPane1.setPreferredSize(lNumberSize);
                        EditorPanel.this.jScrollPane1.setMinimumSize(lNumberSize);
                        EditorPanel.this.jScrollPane1.setMaximumSize(lNumberSize);
                        EditorPanel.this.jScrollPane1.invalidate();
                        EditorPanel.this.jScrollPane1.validate();
                        EditorPanel.this.jScrollPane1.repaint();
                        if (((EditorPanel)EditorPanel.this).jScrollPane1.getSize().height != 0) {
                            EditorPanel.this.oldlnWidth = lineNumberWidth;
                        }
                    }
                });
            }
            DefaultStyledDocument doc = (DefaultStyledDocument)this.jTextPane2.getDocument();
            DebugCommentList list2 = null;
            if (this.parent instanceof VediPanel) {
                VediPanel vedi = (VediPanel)this.parent;
                list2 = vedi.getDebugComments(this);
            }
            if (lineCountNow == 0 && !force) {
                StringBuilder sb = new StringBuilder();
                while (lineCountNow < lineCountOrg) {
                    if (++lineCountNow == 1) {
                        sb.append("" + lineCountNow);
                        continue;
                    }
                    sb.append("\n" + lineCountNow);
                }
                this.jTextPane2.setText(sb.toString());
                doc.setCharacterAttributes(0, doc.getLength(), normal, true);
                boolean pos = false;
                for (lineCountNow = 0; lineCountNow < lineCountOrg; ++lineCountNow) {
                    if (list2 == null || list2.getBreakpoint(lineCountNow) == null) continue;
                    this.correctLine(lineCountNow);
                }
            } else {
                if (lineCountNow == 0 || force) {
                    this.jTextPane2.setText("");
                }
                if (lineCountNow == -1) {
                    lineCountNow = 0;
                }
                while (lineCountNow < lineCountOrg) {
                    AttributeSet currentStyle = normal;
                    if (this.hasBookmark(lineCountNow, this.getFilename())) {
                        currentStyle = bookmark;
                    }
                    if (list2 != null && list2.getBreakpoint(lineCountNow) != null) {
                        currentStyle = breakpoint;
                    }
                    if (++lineCountNow == 1) {
                        doc.insertString(this.jTextPane2.getDocument().getLength(), "" + lineCountNow, currentStyle);
                        continue;
                    }
                    doc.insertString(this.jTextPane2.getDocument().getLength(), "\n" + lineCountNow, currentStyle);
                }
            }
        }
        catch (Throwable e) {
            this.log.addLog("LineNumbers (bp1):\n" + Utility.getStackTrace(e), LogPanel.INFO);
        }
        this.syncViewports();
    }

    void syncViewports() {
        JViewport viewport = this.jScrollPane2.getViewport();
        Point p = viewport.getViewPosition();
        JViewport viewport2 = this.jScrollPane1.getViewport();
        p.x = 0;
        if (viewport2 == null) {
            return;
        }
        if (viewport2 instanceof CSAViewport) {
            ((CSAViewport)viewport2).setViewPositionCSA(p);
        } else {
            viewport2.setViewPosition(p);
        }
    }

    void saveViewportPos() {
        JViewport viewport = this.jScrollPane2.getViewport();
        this.vpSave = viewport.getViewPosition();
    }

    void restoreViewportPos() {
        JViewport viewport = this.jScrollPane2.getViewport();
        viewport.setViewPosition(this.vpSave);
        this.syncViewports();
    }

    public Point getCursorPos() {
        String[] splitter;
        Point p = new Point(1, 1);
        try {
            splitter = this.jTextPane1.getDocument().getText(0, this.jTextPane1.getDocument().getLength()).split("\n");
        }
        catch (Throwable e) {
            return p;
        }
        int pos = this.jTextPane1.getCaretPosition();
        int count = 0;
        for (String split : splitter) {
            if (count + split.length() >= pos) {
                p.x = pos - count + 1;
                break;
            }
            count += split.length();
            ++count;
            ++p.y;
        }
        return p;
    }

    void addWatch(int pos, int type, int param) {
        String word = this.getWordOfPos(this.jTextPane1, this.popUpTextPos);
        if (this.parent instanceof VediPanel) {
            VediPanel vedi = (VediPanel)this.parent;
            DebugCommentList list2 = vedi.getDebugComments(this);
            list2.addWatchComment(word, type, param);
        }
        this.updateParentTables();
    }

    private void toggleBreakpoint(int line) {
        if (this.parent instanceof VediPanel) {
            VediPanel vedi = (VediPanel)this.parent;
            DebugCommentList list2 = vedi.getDebugComments(this);
            DebugComment dbc = list2.getBreakpoint(line);
            if (dbc != null) {
                list2.removeComment(dbc);
            } else {
                list2.addBreakComment(line);
            }
            this.correctLine(line);
        }
        this.updateParentTables();
    }

    void breakPointLineAdded() {
        if (this.parent instanceof VediPanel) {
            VediPanel vedi = (VediPanel)this.parent;
            DebugCommentList dbclist = vedi.getDebugComments(this);
            int currentLine = this.getLineOfPos(this.jTextPane1, this.jTextPane1.getCaretPosition());
            ArrayList<DebugComment> list2 = dbclist.getList();
            for (DebugComment dbc : list2) {
                if (dbc.beforLineNo < currentLine) continue;
                if (!this.inSetup) {
                    ++dbc.beforLineNo;
                }
                this.correctLine(dbc.beforLineNo - 1);
                this.correctLine(dbc.beforLineNo);
            }
        }
        this.updateParentTables();
    }

    void breakPointLineDeleted() {
        if (this.parent instanceof VediPanel) {
            VediPanel vedi = (VediPanel)this.parent;
            DebugCommentList dbclist = vedi.getDebugComments(this);
            int currentLine = this.getLineOfPos(this.jTextPane1, this.jTextPane1.getCaretPosition());
            ArrayList<DebugComment> list2 = dbclist.getList();
            for (DebugComment dbc : list2) {
                if (dbc.beforLineNo <= currentLine) continue;
                --dbc.beforLineNo;
                this.correctLine(dbc.beforLineNo + 1);
                this.correctLine(dbc.beforLineNo);
            }
        }
        this.updateParentTables();
    }

    public void updateParentTables() {
        if (this.parent instanceof VediPanel) {
            VediPanel vedi = (VediPanel)this.parent;
            vedi.updateTables();
        }
    }

    private void initDebugDisplay() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (!(EditorPanel.this.parent instanceof VediPanel)) {
                    return;
                }
                if (!EditorPanel.this.assume6809Asm) {
                    return;
                }
                DebugCommentList list2 = null;
                if (EditorPanel.this.parent instanceof VediPanel) {
                    VediPanel vedi = (VediPanel)EditorPanel.this.parent;
                    list2 = vedi.getDebugComments(EditorPanel.this);
                }
                if (list2 != null) {
                    for (DebugComment c : list2.getList()) {
                        EditorPanel.this.correctLine(c.beforLineNo);
                    }
                }
                Set<Map.Entry<Integer, Bookmark>> entries = EditorPanel.this.parent.settings.bookmarks.entrySet();
                for (Map.Entry<Integer, Bookmark> entry : entries) {
                    Bookmark bm = entry.getValue();
                    int lineNumber = bm.lineNumber;
                    String filename = bm.fullFilename;
                    if (!filename.equals(EditorPanel.this.getFilename())) continue;
                    EditorPanel.this.correctLine(lineNumber);
                }
            }
        });
    }

    public int getPosition() {
        JViewport viewport = this.jScrollPane2.getViewport();
        Point p = viewport.getViewPosition();
        return p.y;
    }

    public void setPosition(final int _y) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JViewport viewport = EditorPanel.this.jScrollPane2.getViewport();
                Point p = viewport.getViewPosition();
                p.y = _y;
                p.x = 0;
                viewport.setViewPosition(p);
                viewport = EditorPanel.this.jScrollPane1.getViewport();
                viewport.setViewPosition(p);
                EditorPanel.this.jScrollPane2.invalidate();
                EditorPanel.this.jScrollPane2.validate();
                EditorPanel.this.jScrollPane2.repaint();
                EditorPanel.this.jScrollPane1.invalidate();
                EditorPanel.this.jScrollPane1.validate();
                EditorPanel.this.jScrollPane1.repaint();
            }
        });
    }

    void correctLine(int line) {
        String num;
        AttributeSet currentStyle;
        int pos;
        DefaultStyledDocument doc;
        try {
            AttributeSet normal = TokenStyles.getStyle("comment");
            AttributeSet breakpoint = TokenStyles.getStyle("breakpoint");
            int lineCountOrg = this.getLineCount(this.jTextPane1);
            int lineCountNow = 0;
            DebugCommentList list2 = null;
            if (this.parent instanceof VediPanel) {
                VediPanel vedi = (VediPanel)this.parent;
                list2 = vedi.getDebugComments(this);
            }
            doc = (DefaultStyledDocument)this.jTextPane2.getDocument();
            pos = 0;
            while (lineCountNow < lineCountOrg) {
                currentStyle = normal;
                if (list2 != null && list2.getBreakpoint(lineCountNow) != null) {
                    currentStyle = breakpoint;
                }
                num = ++lineCountNow == 1 ? "" + lineCountNow : "\n" + lineCountNow;
                if (line + 1 != lineCountNow) {
                    pos += num.length();
                    continue;
                }
                doc.setCharacterAttributes(pos, num.length(), currentStyle, true);
                break;
            }
        }
        catch (Throwable e) {
            this.log.addLog("Correct Line (bp):\n" + Utility.getStackTrace(e), LogPanel.INFO);
        }
        String name = this.getFilename();
        try {
            AttributeSet normal = TokenStyles.getStyle("comment");
            AttributeSet bookmark = TokenStyles.getStyle("bookmark");
            int lineCountOrg = this.getLineCount(this.jTextPane1);
            int lineCountNow = 0;
            doc = (DefaultStyledDocument)this.jTextPane2.getDocument();
            pos = 0;
            while (lineCountNow < lineCountOrg) {
                currentStyle = normal;
                num = ++lineCountNow == 1 ? "" + lineCountNow : "\n" + lineCountNow;
                if (line + 1 != lineCountNow) {
                    pos += num.length();
                    continue;
                }
                if (this.hasBookmark(lineCountNow - 1, name)) {
                    currentStyle = bookmark;
                    doc.setCharacterAttributes(pos, num.length(), currentStyle, true);
                }
                return;
            }
        }
        catch (Throwable e) {
            this.log.addLog("Correct Line (bm):\n" + Utility.getStackTrace(e), LogPanel.INFO);
        }
    }

    boolean hasBookmark(int line, String name) {
        Set<Map.Entry<Integer, Bookmark>> entries = this.parent.settings.bookmarks.entrySet();
        Iterator<Map.Entry<Integer, Bookmark>> it = entries.iterator();
        ++line;
        while (it.hasNext()) {
            Map.Entry<Integer, Bookmark> entry = it.next();
            Bookmark bm = entry.getValue();
            int lineNumber = bm.lineNumber;
            String filename = bm.fullFilename;
            if (!name.endsWith(filename) || line != lineNumber) continue;
            return true;
        }
        return false;
    }

    public void resetCRC() {
        String s = this.getText();
        this.loadCRC32 = new CRC32();
        for (int i = 0; i < s.length(); ++i) {
            this.loadCRC32.update(s.charAt(i));
        }
    }

    public boolean hasChanged() {
        long now;
        String s = this.getText();
        CRC32 localCRC32 = new CRC32();
        for (int i = 0; i < s.length(); ++i) {
            localCRC32.update(s.charAt(i));
        }
        long org2 = this.loadCRC32.getValue();
        return org2 != (now = localCRC32.getValue());
    }

    public class LineTableModel
    extends AbstractTableModel {
        @Override
        public int getRowCount() {
            return EditorPanel.this.getTextpaneRowCount();
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public Object getValueAt(int row, int col) {
            return row + 1;
        }

        @Override
        public String getColumnName(int column) {
            return "";
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return Integer.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public int getColWidth(int col) {
            if (col == 0) {
                return 40;
            }
            if (col == 17) {
                return 120;
            }
            return 20;
        }

        public Color getBackground(int col) {
            if (col == 0) {
                return new Color(200, 255, 200, 255);
            }
            return null;
        }
    }

    class CSAViewport2
    extends JViewport {
        public boolean enableViewport = true;

        CSAViewport2() {
        }

        @Override
        public void setViewPosition(Point p) {
            if (this.enableViewport) {
                super.setViewPosition(p);
            }
        }
    }

    class CSAViewport
    extends JViewport {
        CSAViewport() {
        }

        @Override
        public void setViewPosition(Point p) {
        }

        public void setViewPositionCSA(Point p) {
            super.setViewPosition(p);
        }
    }
}

