/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.vedi;

import de.malban.vide.VideConfig;
import de.malban.vide.vedi.EditorEvent;
import de.malban.vide.vedi.EditorListener;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.DefaultCaret;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;

public class EditorPanelFoundation
extends JPanel {
    protected CompoundUndoManager undoManager = new CompoundUndoManager();
    protected UndoAction undoAction;
    protected RedoAction redoAction;
    private ArrayList<EditorListener> mListener = new ArrayList();
    protected static final Highlighter.HighlightPainter unfocusedPainter = new DefaultHighlighter.DefaultHighlightPainter(new Color(43, 107, 197, 255));
    protected static final Highlighter.HighlightPainter focusedPainter = new DefaultHighlighter.DefaultHighlightPainter(new Color(43, 107, 197, 255));

    public void addEditorListener(EditorListener listener) {
        this.mListener.remove(listener);
        this.mListener.add(listener);
    }

    public void removeEditorListener(EditorListener listener) {
        this.mListener.remove(listener);
    }

    public void fireEditorChanged(int type, int line) {
        EditorEvent e = new EditorEvent();
        e.type = type;
        e.line = line;
        e.source = this;
        for (int i = 0; i < this.mListener.size(); ++i) {
            this.mListener.get(i).editorChanged(e);
        }
    }

    public void undo() {
        if (VideConfig.editorUndoEnabled) {
            this.undoAction.actionPerformed(null);
        }
    }

    public void redo() {
        if (VideConfig.editorUndoEnabled) {
            this.redoAction.actionPerformed(null);
        }
    }

    public boolean canUndo() {
        if (!VideConfig.editorUndoEnabled) {
            return false;
        }
        return this.undoManager.canUndo();
    }

    public boolean canRedo() {
        if (!VideConfig.editorUndoEnabled) {
            return false;
        }
        return this.undoManager.canRedo();
    }

    public EditorPanelFoundation() {
        this.initComponents();
        if (VideConfig.editorUndoEnabled) {
            this.undoAction = new UndoAction();
            this.redoAction = new RedoAction();
            this.undoManager.setLimit(1000);
        }
    }

    private void initComponents() {
        this.setPreferredSize(null);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
    }

    protected void editActionChanged() {
    }

    protected class HighlightCaret
    extends DefaultCaret {
        private static final long serialVersionUID = 1L;
        private boolean isFocused;

        protected HighlightCaret() {
        }

        @Override
        protected Highlighter.HighlightPainter getSelectionPainter() {
            this.setBlinkRate(500);
            return this.isFocused ? focusedPainter : unfocusedPainter;
        }

        @Override
        public void setSelectionVisible(boolean hasFocus) {
            if (hasFocus != this.isFocused) {
                this.isFocused = hasFocus;
                super.setSelectionVisible(false);
                super.setSelectionVisible(true);
            }
        }
    }

    class RedoAction
    extends AbstractAction {
        public RedoAction() {
            super("Redo");
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                EditorPanelFoundation.this.undoManager.redo();
                EditorPanelFoundation.this.fireEditorChanged(4, -1);
            }
            catch (CannotRedoException ex) {
                ex.printStackTrace();
            }
            this.update();
            EditorPanelFoundation.this.undoAction.update();
        }

        protected void update() {
            if (EditorPanelFoundation.this.undoManager.canRedo()) {
                this.setEnabled(true);
                this.putValue("Name", EditorPanelFoundation.this.undoManager.getRedoPresentationName());
            } else {
                this.setEnabled(false);
                this.putValue("Name", "Redo");
            }
            EditorPanelFoundation.this.editActionChanged();
        }
    }

    class UndoAction
    extends AbstractAction {
        public UndoAction() {
            super("Undo");
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                EditorPanelFoundation.this.undoManager.undo();
                EditorPanelFoundation.this.fireEditorChanged(3, -1);
            }
            catch (CannotUndoException cannotUndoException) {
                // empty catch block
            }
            this.update();
            EditorPanelFoundation.this.redoAction.update();
        }

        protected void update() {
            if (EditorPanelFoundation.this.undoManager.canUndo()) {
                this.setEnabled(true);
                this.putValue("Name", EditorPanelFoundation.this.undoManager.getUndoPresentationName());
            } else {
                this.setEnabled(false);
                this.putValue("Name", "Undo");
            }
            EditorPanelFoundation.this.editActionChanged();
        }
    }

    class CompoundUndoManager
    extends UndoManager
    implements UndoableEditListener {
        private CompoundEdit compoundEdit;

        CompoundUndoManager() {
        }

        @Override
        public void undoableEditHappened(UndoableEditEvent e) {
            if (e.getEdit() instanceof AbstractDocument.DefaultDocumentEvent) {
                AbstractDocument.DefaultDocumentEvent event = (AbstractDocument.DefaultDocumentEvent)e.getEdit();
                if (event.getType().equals(DocumentEvent.EventType.CHANGE)) {
                    if (this.compoundEdit == null) {
                        return;
                    }
                    this.compoundEdit.addEdit(e.getEdit());
                    return;
                }
            } else {
                String compareString = UIManager.getString("AbstractDocument.styleChangeText");
                if (e.getEdit().getPresentationName().equals(compareString)) {
                    if (this.compoundEdit == null) {
                        return;
                    }
                    this.compoundEdit.addEdit(e.getEdit());
                    return;
                }
            }
            if (this.compoundEdit == null) {
                this.compoundEdit = this.startCompoundEdit(e.getEdit());
                return;
            }
            this.compoundEdit.end();
            this.compoundEdit = this.startCompoundEdit(e.getEdit());
        }

        private CompoundEdit startCompoundEdit(UndoableEdit anEdit) {
            this.compoundEdit = new MyCompoundEdit();
            this.compoundEdit.addEdit(anEdit);
            this.addEdit(this.compoundEdit);
            EditorPanelFoundation.this.undoAction.update();
            EditorPanelFoundation.this.redoAction.update();
            return this.compoundEdit;
        }

        class MyCompoundEdit
        extends CompoundEdit {
            MyCompoundEdit() {
            }

            @Override
            public boolean isInProgress() {
                return false;
            }

            @Override
            public void undo() throws CannotUndoException {
                if (CompoundUndoManager.this.compoundEdit != null) {
                    CompoundUndoManager.this.compoundEdit.end();
                }
                super.undo();
                CompoundUndoManager.this.compoundEdit = null;
            }
        }
    }

    public static class VisibleCaretListener
    implements CaretListener {
        private int visiblePixels;

        public VisibleCaretListener() {
            this(2);
        }

        public VisibleCaretListener(int visiblePixels) {
            this.setVisiblePixels(visiblePixels);
        }

        public int getVisiblePixels() {
            return this.visiblePixels;
        }

        public void setVisiblePixels(int visiblePixels) {
            this.visiblePixels = visiblePixels;
        }

        @Override
        public void caretUpdate(final CaretEvent e) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        JTextComponent component = (JTextComponent)e.getSource();
                        int position = component.getCaretPosition();
                        Rectangle r = component.modelToView(position);
                        r.x += visiblePixels;
                        component.scrollRectToVisible(r);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
    }
}

